
      subroutine PARAMS_HDR( plon, plonl, plat, plev, &
			     phtcnt, rxntot, &
			     adv_cnt, nadv_cnt, histout_cnt, &
		             chemistry, diffusion, convection, arch_type, &
                             filespec )
!-----------------------------------------------------------------------
!        ... Make the params.h file
!-----------------------------------------------------------------------

      use io,      only : lout
      use var_mod, only : hst_cat_lim

      implicit none

!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) ::     plon, plonl, plat, plev
      integer, intent(in) ::     phtcnt, rxntot
      integer, intent(in) ::     adv_cnt, nadv_cnt
      integer, intent(in) ::     histout_cnt(hst_cat_lim,2)
      logical, intent(in) ::     chemistry, diffusion, convection
      character(len=8), intent(in) :: arch_type
      character(len=*), intent(in) :: filespec

!-----------------------------------------------------------------------
!        ... The local variables
!-----------------------------------------------------------------------
      integer           :: ios
      logical           :: lexist
      
      inquire( file = trim(filespec), exist = lexist )
      if( lexist ) then
	 call system( 'rm '//trim(filespec) )
      end if
      open( unit = 30, file = trim(filespec), iostat=ios )
      if( ios /= 0 ) then
	 write(lout,*) 'PARAMS_HDR: Failed to open simulation datafile ',trim(filespec),' ;error = ',ios
	 stop
      end if
      write(30,'("# ifndef PARAMS_H")')
      write(30,'("# define PARAMS_H")')
      write(30,'('' '')')
      write(30,'("# define CALC_ETADOT")')
      if( diffusion ) then
         write(30,'("# define DI_VDIFF")')
      else
         write(30,'("# define AR_VDIFF")')
      end if
      if( convection ) then
         write(30,'("# define DI_CONV_CCM")')
      else
         write(30,'("# define AR_CONV_CCM")')
      end if
      write(30,'("# define DI_CLOUD_PHYS")')
      if( chemistry ) then
         write(30,'("# define TROP_CHEM")')
      end if
      write(30,'('' '')')
      write(30,'("# endif")')

      close( 30 )
      
      end subroutine PARAMS_HDR
