
      module PROD_LOSS

      use IO, only : temp_path

      CONTAINS

      subroutine PL_CODE( spccnt, clscnt, clsmap, cls_rxt_cnt, cls_rxt_map, &
                          pcoeff_ind, pcoeff, permute, machine, f90 )
!-----------------------------------------------------------------------
!	... Write the fortran production and loss code
!-----------------------------------------------------------------------
     
      use VAR_MOD, only : var_lim
      use RXT_MOD, only : rxt_lim, prd_lim

      implicit none

!-----------------------------------------------------------------------
!        ... The arguments
!
!            The columns of the cls_rxt_cnt represent the reaction count
!	     for each class with the following row conontation:
!		(1) - independent reactions
!		(2) - linear reactions
!		(3) - nonlinear reactions
!		(4) - heterogeneous processes
!-----------------------------------------------------------------------
      integer, intent(in) ::  spccnt
      integer, intent(in) ::  clscnt(5), &
                              clsmap(var_lim,5,2), &
                              cls_rxt_map(rxt_lim,prd_lim+3,5), &
                              cls_rxt_cnt(4,5)
      integer, intent(in) ::  pcoeff_ind(rxt_lim)
      integer, intent(in) ::  permute(var_lim,5)
      real, intent(in)    ::  pcoeff(prd_lim,rxt_lim)
      character(len=8), intent(in) :: machine
      logical, intent(in) ::  f90
      
!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer, parameter :: max_len = 90
      integer  ::   i, k, kl, ku, l, m, ml
      integer  ::   spos
      integer  ::   length, index, cnt
      integer  ::   line_pos, target
      integer  ::   class
      integer  ::   base
      integer  ::   species
      integer  ::   match_cnt
      integer  ::   other_ind
      integer  ::   match_ind(4)
      integer  ::   max_loc(1)
      integer  ::   freq(spccnt)
      integer, allocatable  ::   indexer(:)
      real     ::   rate
      character(len=max_len) :: line
      character(len=72) :: buff
      character(len=24) :: sub_name
      character(len=16) :: rate_con
      character(len=12) :: het_piece
      character(len= 7) :: l_piece, p_piece
      character(len= 6) :: rxt_piece
      character(len= 4) :: sol_piece
      character(len= 3) :: num
      logical, allocatable :: match_mask(:,:)
      logical, allocatable :: pmask(:,:)
      logical  ::  beg_line
      logical  ::  lexist, first
      


Class_loop : &
      do class = 1,5
	 if( class == 2 .or. class == 3 ) then
	    cycle
	 end if
	 select case( class )
	    case( 1 )
               line     = '      module mo_exp_prod_loss'
               sub_name = 'exp_prod_loss.F'
	    case( 2 )
               line     = '      module mo_ebi_prod_loss'
               sub_name = 'ebi_prod_loss.F'
	    case( 3 )
               line     = '      module mo_hov_prod_loss'
               sub_name = 'hov_prod_loss.F'
	    case( 4 )
               line     = '      module mo_imp_prod_loss'
               sub_name = 'imp_prod_loss.F'
	    case( 5 )
               line     = '      module mo_rodas_prod_loss'
               sub_name = 'rodas_prod_loss.F'
	 end select

         inquire( file = trim( temp_path ) // trim( sub_name ), exist = lexist )
         if( lexist ) then
	    call system( 'rm ' // trim( temp_path ) // trim( sub_name ) )
         end if
         open( unit = 30, file = trim( temp_path ) // trim( sub_name ) )

         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
         line = '      contains'
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
            if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
	       select case( class )
	          case( 1 )
                     line = '      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 2 )
                     line = '      subroutine ebi_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 3 )
                     line = '      subroutine hov_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 4 )
                     line = '      subroutine imp_prod_loss( ofl, ofu, prod, loss, y, &'
                     write(30,100) trim(line)
                     line = '                                rxt, het_rates )'
	          case( 5 )
                     line = '      subroutine rodas_prod_loss( ofl, ofu, prod, loss, y, &'
                     write(30,100) trim(line)
                     line = '                                  rxt, het_rates )'
	       end select
	    else
	       select case( class )
	          case( 1 )
                     line = '      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 2 )
                     line = '      subroutine ebi_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 3 )
                     line = '      subroutine hov_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 4 )
                     line = '      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )'
	          case( 5 )
                     line = '      subroutine rodas_prod_loss( prod, loss, y, rxt, het_rates )'
	       end select
	    end if
            write(30,100) trim(line)
            line = ' '
            write(30,100) trim(line)
	    select case( class )
	       case(1)
                  line = '      use chem_mods, only : clscnt1, rxntot, hetcnt'
	       case(4)
                  line = '      use chem_mods, only : clscnt4, rxntot, hetcnt, clsze'
	       case(5)
                  line = '      use chem_mods, only : clscnt5, rxntot, hetcnt, clsze'
	    end select
            write(30,100) trim(line)
            line = '      use mo_grid,   only : pcnstm1'
            write(30,100) trim(line)
            line = ' '
            write(30,100) trim(line)
            line = '      implicit none '
            write(30,100) trim(line)
            line = ' '
            write(30,100) trim(line)
            line = '!--------------------------------------------------------------------'
            write(30,100) trim(line)
            line = '!     ... Dummy args'
            write(30,100) line
            line = '!--------------------------------------------------------------------'
            write(30,100) trim(line)
            line = '      real, dimension(:,:), intent(out) :: &'
	    if( class == 4 ) then
		  if( machine == 'INTEL' ) then
                     line = '      real, dimension(:), intent(out) :: &'
		     p_piece = 'prod('
		     l_piece = 'loss('
		     rxt_piece = 'rxt('
		     het_piece = 'het_rates('
		     sol_piece = 'y('
	          else if( machine == 'CRAY' .or. machine == 'CRAYYMP' .or. machine == 'J90' .or. machine == 'C90' ) then
		     p_piece = 'prod(k,'
		     l_piece = 'loss(k,'
		     rxt_piece = 'rxt(k,'
		     het_piece = 'het_rates(k,'
		     sol_piece = 'y(k,'
	          else if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
		     p_piece = 'prod(k,'
		     l_piece = 'loss(k,'
		     rxt_piece = 'rxt(k,'
		     het_piece = 'het_rates(k,'
		     sol_piece = 'y(k,'
		  else
		     p_piece = 'prod(k,'
		     l_piece = 'loss(k,'
		     rxt_piece = 'rxt(k,'
		     het_piece = 'het_rates(k,'
		     sol_piece = 'y(k,'
		  end if
	    else if( class == 5 ) then
		  if( machine == 'INTEL' ) then
                     line = '      real, dimension(:), intent(out) :: &'
		     p_piece = 'prod('
		     l_piece = 'loss('
		     rxt_piece = 'rxt('
		     het_piece = 'het_rates('
		     sol_piece = 'y('
	          else if( machine == 'CRAY' .or. machine == 'CRAYYMP' .or. machine == 'J90' .or. machine == 'C90' ) then
		     p_piece = 'prod(k,'
		     l_piece = 'loss(k,'
		     rxt_piece = 'rxt(k,'
		     het_piece = 'het_rates(k,'
		     sol_piece = 'y(k,'
	          else if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
		     p_piece = 'prod(k,'
		     l_piece = 'loss(k,'
		     rxt_piece = 'rxt(k,'
		     het_piece = 'het_rates(k,'
		     sol_piece = 'y(k,'
		  else
		     p_piece = 'prod(k,'
		     l_piece = 'loss(k,'
		     rxt_piece = 'rxt(k,'
		     het_piece = 'het_rates(k,'
		     sol_piece = 'y(k,'
		  end if
	    end if
            write(30,100) trim(line)
            line = '            prod, &'
            write(30,100) trim(line)
            line = '            loss'
            write(30,100) trim(line)
	    if( class == 1 ) then
                  line = '      real, intent(in)    ::  y(:,:)'
                  write(30,100) trim(line)
                  line = '      real, intent(in)    ::  rxt(:,:)'
                  write(30,100) trim(line)
                  line = '      real, intent(in)    ::  het_rates(:,:)'
                  write(30,100) trim(line)
	    else
		  if( machine == 'INTEL' ) then
                     line = '      real, intent(in)    ::  y(:)'
                     write(30,100) trim(line)
                     line = '      real, intent(in)    ::  rxt(:)'
                     write(30,100) trim(line)
                     line = '      real, intent(in)    ::  het_rates(:)'
		  else if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                     line = '      integer, intent(in)    ::  ofl'
                     write(30,100) trim(line)
                     line = '      integer, intent(in)    ::  ofu'
                     write(30,100) trim(line)
                     line = '      real, intent(in)       ::  y(:,:)'
                     write(30,100) trim(line)
                     line = '      real, intent(in)       ::  rxt(:,:)'
                     write(30,100) trim(line)
                     line = '      real, intent(in)       ::  het_rates(:,:)'
		  else
                     line = '      real, intent(in)    ::  y(:,:)'
                     write(30,100) trim(line)
                     line = '      real, intent(in)    ::  rxt(:,:)'
                     write(30,100) trim(line)
                     line = '      real, intent(in)    ::  het_rates(:,:)'
		  end if
                  write(30,100) trim(line)
	    end if
            line = ' '
            write(30,100) trim(line)
	 if( clscnt(class) /= 0 ) then
            line = ' '
            write(30,100) trim(line)
            buff = ' '
	    if( class == 4 .or. class == 5 ) then
               if( machine /= 'INTEL' ) then
                  line = '!--------------------------------------------------------------------'
                  write(30,100) trim(line)
                  line = '!     ... Local variables'
                  write(30,100) line
                  line = '!--------------------------------------------------------------------'
                  write(30,100) trim(line)
                  line = ' '
                  line(7:) = 'integer :: k'
                  write(30,100) trim(line)
	       end if
               line = ' '
               write(30,100) trim(line)
               line = ' '
	    end if
	    if( ALLOCATED( match_mask ) ) then
	       DEALLOCATE( match_mask )
	    end if
	    if( ALLOCATED( pmask ) ) then
	       DEALLOCATE( pmask )
	    end if
	    if( ALLOCATED( indexer ) ) then
	       DEALLOCATE( indexer )
	    end if
	    k = SUM( cls_rxt_cnt(:,class) )
	    if( k == 0 ) then
               call terminate_subroutine
	       cycle Class_loop
	    end if
	    ALLOCATE( match_mask(k,3) )
	    ALLOCATE( indexer(k) )
	    if( SUM( cls_rxt_cnt(2:3,class) ) /= 0 ) then
	       ALLOCATE( pmask(k,prd_lim) )
	    end if
            line = '!--------------------------------------------------------------------'
	    write(30,100) trim(line)
            line = '!       ... Loss and production for'
	    length = len_trim( line ) + 2
	    select case( class )
	       case( 1 )
	          line(length:) = 'Explicit method'
	       case( 2 )
	          line(length:) = 'Ebi-gs method'
	       case( 3 )
	          line(length:) = 'Hov-gs method'
	       case( 4 )
	          line(length:) = 'Implicit method'
	       case( 5 )
	          line(length:) = 'Rodas3 method'
	    end select
	    write(30,100) trim(line)
            line = '!--------------------------------------------------------------------'
	    write(30,100) trim(line)
	    line = ' '
	    write(30,100) trim(line)
100   format(a)

	    if( class == 2 ) then
	       line = ' '
	       line(10:) = 'select case( index )'
	       write(30,100) trim(line)
	       line = ' '
	    else if( class == 4 .or. class == 5 ) then
	       line = ' '
	       if( machine /= 'INTEL' ) then
	          if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
	             line(7:) = 'do k = ofl,ofu'
		  else
	             line(7:) = 'do k = 1,clsze'
		  end if
	       end if
	       write(30,100) trim(line)
	       line = ' '
	    end if
Species_loop : &
            do species = 1,clscnt(class)
	       if( class == 2 .or. class == 3 ) then
		  write(num,'(i3)') permute(species,2)
	          line = ' '
	          line(13:) = 'case( ' // num(:len_trim(num)) // ' )'
	          write(30,100) trim(line)
	          line = ' '
	       end if
!-----------------------------------------------------------------------
!   	...Write code for loss processes; linear, nonlinear, and heterogeneous
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
!   	... Setup indicies and check whether species is in any loss reactions
!-----------------------------------------------------------------------
	       target = clsmap(species,class,2)
	       kl = cls_rxt_cnt(1,class) + 1
	       ku = SUM( cls_rxt_cnt(:3,class) )
	       do i = 1,2
	          match_mask(kl:ku,i) = cls_rxt_map(kl:ku,i+1,class) == target
	          where( match_mask(kl:ku,i) )
	             indexer(kl:ku) = 6/(i+1)
	          endwhere
	       end do
	       match_mask(kl:ku,1) = match_mask(kl:ku,1) .or. match_mask(kl:ku,2)
	       kl = ku + 1 ; ku = SUM(cls_rxt_cnt(:,class))
	       match_mask(kl:ku,1) = cls_rxt_map(kl:ku,2,class) == species
	       kl = cls_rxt_cnt(1,class) + 1
	       if( class == 2 .or. class == 3 ) then
		  num = '1'
	       else
	          write(num,'(i3)') permute(species,class)
	          num =  ADJUSTL( num )
	       end if
	       if( COUNT( match_mask(kl:ku,1) ) == 0 ) then
		  if( class == 4 .or. class == 5 ) then
	             line(10:) = trim( l_piece ) // num(:len_trim(num)) // ') = 0.'
		  else
	             line(7:) = 'loss(:,' // num(:len_trim(num)) // ') = 0.'
		  end if
	          write(30,100) trim(line)
	       else
	          line = ' '
	          if( class == 1 .or. class >= 4 ) then
		     if( class == 4 .or. class == 5 ) then
	                line(10:) = trim( l_piece ) // num(:len_trim(num)) // ') = ('
		     else
	                line(7:) = 'loss(:,' // num(:len_trim(num)) // ') = ('
		     end if
	             line_pos = len_trim( line ) + 1
	          else
!	     if( class == 4 ) then
!                line(10:) = trim( l_piece ) // num(:len_trim(num)) // ') ='
!	     else
	                line(7:) = 'loss(:,' // num(:len_trim(num)) // ') ='
!	     end if
	             line_pos = len_trim( line ) + 2
	          end if
!-----------------------------------------------------------------------
!	... Scan loss reactions for common terms
!-----------------------------------------------------------------------
	          ku = ku - cls_rxt_cnt(4,class)
		  first = .true.
	          do m = 1,spccnt
		     match_mask(kl:ku,2) = .false.
		     do k = kl,ku
			if( match_mask(k,1) ) then
			   if( ABS( cls_rxt_map(k,indexer(k),class) ) == m ) then
			      match_mask(k,2) = .true.
			   end if
			end if
		     end do
		     cnt = COUNT( match_mask(kl:ku,2) )
		     if( cnt == 0 ) then
		        cycle
		     end if
		     if( m == target ) then
		        if( cnt > 1 ) then
			   if( first ) then
		              buff = '2.*('
		           else
		              buff = ' + 2.*('
			   end if
		        else
			   if( first ) then
		              buff = '2.*'
		           else
		              buff = ' + 2.*'
			   end if
		        end if
		     else
		        if( cnt > 1 ) then
			   if( first ) then
		              buff = '('
		           else
		              buff = ' + ('
			   end if
		        else
			   if( first ) then
		              buff = ' '
		           else
		              buff = ' + '
			   end if
		        end if
		     end if
		     if( first ) then
			first = .false.
		     end if
		     l = 0
		     do k = kl,ku
		        if( match_mask(k,2) ) then
			   l = l + 1
	                   write(num,'(i3)') cls_rxt_map(k,1,class)
	                   num =  ADJUSTL( num )
			   if( class == 4 .or. class == 5 ) then
		              buff(len_trim(buff)+1:) = trim( rxt_piece ) // num(:len_trim(num)) // ') +'
		           else
		              buff(len_trim(buff)+1:) = 'rxt(:,' // num(:len_trim(num)) // ') +'
		           end if
			   if( l == cnt ) then
		              if( cnt > 1 ) then
			         buff(len_trim(buff)-1:) = ')'
			      else
			         buff(len_trim(buff)-1:) = ' '
			      end if
			      call PUT_IN_LINE()
			      write(num,'(i3)') m
	                      num =  ADJUSTL( num )
			      if( class == 4 .or. class == 5 ) then
		                 buff(len_trim(buff)+1:) = '* ' // trim( sol_piece ) // num(:len_trim(num)) // ')'
			      else
		                 buff(len_trim(buff)+1:) = '* y(:,' // num(:len_trim(num)) // ')'
			      end if
			   end if
			   call PUT_IN_LINE()
		        end if
		     end do
		     where( match_mask(kl:ku,2) )
		        match_mask(kl:ku,1) = .false.
		     endwhere
	          end do
!-----------------------------------------------------------------------
!	... Strictly unimolecular losses
!-----------------------------------------------------------------------
	          ku = SUM( cls_rxt_cnt(:,class) )
	          cnt = COUNT( match_mask(kl:ku,1) )
		  if( cnt > 0 ) then
	             do k = kl,ku
		        if( match_mask(k,1) ) then
		           cnt = cnt - 1
	                   write(num,'(i3)') cls_rxt_map(k,1,class)
	                   num =  ADJUSTL( num )
			   if( k <= SUM(cls_rxt_cnt(1:3,class)) ) then
			      if( class == 4 .or. class == 5 ) then
		                 buff(len_trim(buff)+1:) = ' + ' // trim( rxt_piece ) // num(:len_trim(num)) // ')'
		              else
		                 buff(len_trim(buff)+1:) = ' + rxt(:,' // num(:len_trim(num)) // ')'
		              end if
		           else
			      if( class == 4 .or. class == 5 ) then
		                 buff(len_trim(buff)+1:) = ' + ' // trim( het_piece ) // num(:len_trim(num)) // ')'
		              else
		                 buff(len_trim(buff)+1:) = ' + het_rates(:,' // num(:len_trim(num)) // ')'
		              end if
		           end if
	                   if( cnt == 0 .and. (class == 1 .or. class >= 4) ) then
		              buff(len_trim(buff)+1:) = ')'
		           end if
		           call PUT_IN_LINE()
		        end if
	             end do
		  else if( class == 1 .or. class >= 4 ) then
		     buff(len_trim(buff)+1:) = ')'
		     call PUT_IN_LINE()
		  end if
		  if( class == 1 .or. class >= 4 ) then
	             write(num,'(i3)') target
	             num =  ADJUSTL( num )
		     if( class == 4 .or. class == 5 ) then
		        buff(len_trim(buff)+1:) = '* ' // trim( sol_piece ) // num(:len_trim(num)) // ')'
	             else
		        buff(len_trim(buff)+1:) = '* y(:,' // num(:len_trim(num)) // ')'
		     end if
		     call PUT_IN_LINE()
		  end if
	          if( line(7:) /= ' ' ) then
		     write(30,100) trim(line)
	          end if
	       end if
!-----------------------------------------------------------------------
!   	...Write code for production from linear and nonlinear reactions
!-----------------------------------------------------------------------
	       ku = SUM( cls_rxt_cnt(:3,class) )
	       do k = kl,ku
		  pmask(k,:) = cls_rxt_map(k,4:prd_lim+3,class) == species
	          match_mask(k,1) = ANY( pmask(k,:) )
	       end do
	       if( class == 2 .or. class == 3 ) then
		  num = '1'
	       else
	          write(num,'(i3)') permute(species,class)
	          num =  ADJUSTL( num )
	       end if
	       line = ' '
!-----------------------------------------------------------------------
!	... No species products
!-----------------------------------------------------------------------
	       if( COUNT( match_mask(kl:ku,1) ) == 0 ) then
		  if( class == 4 .or. class == 5 ) then
	             line(10:) = trim( p_piece ) // num(:len_trim(num)) // ') = 0.'
	          else
	             line(7:) = 'prod(:,' // num(:len_trim(num)) // ') = 0.'
	          end if
		  write(30,100) trim(line)
		  cycle Species_loop
	       else
		  if( class == 4 .or. class == 5 ) then
	             line(10:) = trim( p_piece ) // num(:len_trim(num)) // ') = '
	          else
	             line(7:) = 'prod(:,' // num(:len_trim(num)) // ') = '
	          end if
	       end if
	       first = .true.
	       do
	          do m = 1,spccnt
		     match_mask(kl:ku,3) = (ABS(cls_rxt_map(kl:ku,2,class)) == m .or. &
		                           ABS(cls_rxt_map(kl:ku,3,class)) == m) .and.&
					   match_mask(kl:ku,1)
		     freq(m) = COUNT( match_mask(kl:ku,3) )
	          end do
		  max_loc = MAXLOC( freq(:spccnt) )
		  cnt = MAXVAL( freq(:spccnt) )
		  match_mask(kl:ku,3) = (ABS(cls_rxt_map(kl:ku,2,class)) == max_loc(1) .or. &
		                        ABS(cls_rxt_map(kl:ku,3,class)) == max_loc(1)) .and. &
					match_mask(kl:ku,1)
		  do k = kl,ku
		     if( match_mask(k,3) ) then
			if( ABS( cls_rxt_map(k,2,class) ) == max_loc(1) ) then
			   indexer(k) = 3
			else
			   indexer(k) = 2
			end if
		     end if
		  end do
		  if( cnt > 1 ) then
		     if( first ) then
		        buff = ' ('
		     else
		        buff = ' + ('
		     end if
		  else if( first ) then
		     buff = ' '
		  else
		     buff = ' +'
		  end if
		  if( first ) then
		     first = .false.
		  end if
		  m = cnt
		  do k = kl,ku
		     if( match_mask(k,3) ) then
		        index = pcoeff_ind(cls_rxt_map(k,1,class))
			if( index /= 0 ) then
			   rate = 0.
			   do ml = 1,prd_lim
			      if( pmask(k,ml) ) then
			         rate = rate + pcoeff(ml,index)
			      end if
			   end do
			else
			   rate = REAL( COUNT( ABS( cls_rxt_map(k,4:prd_lim+3,class) ) == species ) )
		        end if
		        if( rate /= 0. .and. rate /= 1. ) then
                           spos = len_trim(buff)+1
			   call R2C( rate_con, abs(rate), 'l' )
!		           call R2C( buff(spos:), abs(rate), 'l' )
                           if( rate < 0. ) then
                              buff(spos:spos+1) = '(-'
                              spos = spos + 2
                           end if
                           buff(spos:) = trim(rate_con)
                           if( rate < 0. ) then
                              spos = len_trim(buff)+1
                              buff(spos:) = ')'
                           end if
			   buff(len_trim( buff )+1:) = '*'
		        end if
	                write(num,'(i3)') cls_rxt_map(k,1,class)
	                num =  ADJUSTL( num )
			if( class == 4 .or. class == 5 ) then
		           buff(len_trim(buff)+1:) = trim( rxt_piece ) // num(:len_trim(num)) // ')'
			else
		           buff(len_trim(buff)+1:) = 'rxt(:,' // num(:len_trim(num)) // ')'
			end if
			if( ABS( cls_rxt_map(k,indexer(k),class) ) /= 0 ) then
	                   write(num,'(i3)') ABS( cls_rxt_map(k,indexer(k),class) )
	                   num =  ADJUSTL( num )
			   if( class == 4 .or. class == 5 ) then
			      if( m > 1 ) then
		                 buff(len_trim(buff)+1:) = '*' // trim( sol_piece ) // num(:len_trim(num)) // ') +'
			      else if( cnt > 1 ) then
		                 buff(len_trim(buff)+1:) = '*' // trim( sol_piece ) // num(:len_trim(num)) // '))'
			      else
		                 buff(len_trim(buff)+1:) = '*' // trim( sol_piece ) // num(:len_trim(num)) // ')'
			      end if
			   else
			      if( m > 1 ) then
		                 buff(len_trim(buff)+1:) = '*y(:,' // num(:len_trim(num)) // ') +'
			      else if( cnt > 1 ) then
		                 buff(len_trim(buff)+1:) = '*y(:,' // num(:len_trim(num)) // '))'
			      else
		                 buff(len_trim(buff)+1:) = '*y(:,' // num(:len_trim(num)) // ')'
			      end if
			   end if
			else
			   if( m > 1 ) then
		              buff(len_trim(buff)+1:) = ' +'
			   else if( cnt > 1 ) then
		              buff(len_trim(buff)+1:) = ')'
			   end if
			end if
			call PUT_IN_LINE()
			if( m == 1 ) then
	                   write(num,'(i3)') max_loc(1)
	                   num =  ADJUSTL( num )
			   if( class == 4 .or. class == 5 ) then
		              buff = '*' // trim( sol_piece ) // num(:len_trim(num)) // ')'
			   else
		              buff = '*y(:,' // num(:len_trim(num)) // ')'
			   end if
			   call PUT_IN_LINE()
			   exit
			end if
			m = m - 1
		     end if
		  end do
		  where( match_mask(kl:ku,3) )
		     match_mask(kl:ku,1) = .false.
		  endwhere
		  if( COUNT( match_mask(kl:ku,1) ) == 0 ) then
		     exit
		  end if
	       end do
	       if( line(7:) /= ' ' ) then
		  write(30,100) trim(line)
		  line = ' '
	       end if
	    end do Species_loop
	    if( class == 2 ) then
	       line = ' '
	       line(10:) = 'end select'
	       write(30,100) trim(line)
	       line = ' '
	    end if
	    if( class == 4 .or. class == 5 ) then
	       if( machine /= 'INTEL' ) then
	          line = '      end do'
	          write(30,100) trim(line)
	       end if
	    end if
	 end if
!-----------------------------------------------------------------------
!	... Terminate the subroutine
!-----------------------------------------------------------------------
         call terminate_subroutine
         close( 30 )
      end do Class_loop


      if( ALLOCATED( match_mask ) ) then
	 DEALLOCATE( match_mask )
      end if
      if( ALLOCATED( pmask ) ) then
	 DEALLOCATE( pmask )
      end if
      if( ALLOCATED( indexer ) ) then
	 DEALLOCATE( indexer )
      end if

      CONTAINS

      subroutine PUT_IN_LINE( )
!-----------------------------------------------------------------------
!	... Put line piece in buff into the line
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!	... Local variables
!-----------------------------------------------------------------------
      integer :: blen, llen

      blen = len_trim( buff )
      llen = len_trim( line ) + 1
      if( blen + llen < max_len-2 ) then
	 line(llen:) = buff(:blen)
      else
	 line(len_trim(line)+1:) = ' &'
	 write(30,'(a)') trim(line)
	 line = ' '
	 line(18:) = buff(:length)
      end if
      buff = ' '

      end subroutine PUT_IN_LINE

      subroutine terminate_subroutine
!-----------------------------------------------------------------------
!	... Terminate the subroutine
!-----------------------------------------------------------------------

      implicit none

      line = ' '
      write(30,100) trim(line)
      select case( class )
	 case( 1 )
            line = '      end subroutine exp_prod_loss'
	 case( 2 )
            line = '      end subroutine ebi_prod_loss'
	 case( 3 )
            line = '      end subroutine hov_prod_loss'
	 case( 4 )
            line = '      end subroutine imp_prod_loss'
	 case( 5 )
            line = '      end subroutine rodas_prod_loss'
      end select
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      select case( class )
	 case( 1 )
            line = '      end module mo_exp_prod_loss'
	 case( 2 )
            line = '      end module mo_ebi_prod_loss'
	 case( 3 )
            line = '      end module mo_hov_prod_loss'
	 case( 4 )
            line = '      end module mo_imp_prod_loss'
	 case( 5 )
            line = '      end module mo_rodas_prod_loss'
      end select
      write(30,100) trim(line)

100   format(a)

      end subroutine terminate_subroutine

      end subroutine PL_CODE
       
      end module PROD_LOSS
