
      subroutine MAKE_RADJ( fixmap, &
                            fixcnt, &
                            rxmap, &
                            rxmcnt, &
                            phtcnt, &
			    f90 )
!-----------------------------------------------------------------------
!        ... Make the reaction rate "adjustment" code
!-----------------------------------------------------------------------

      use VAR_MOD, only : var_lim
      use RXT_MOD, only : rxt_lim
      use IO,      only : temp_path

      implicit none

!-----------------------------------------------------------------------
!        ... The arguments
!-----------------------------------------------------------------------
      integer, intent(in) ::  phtcnt
      integer, intent(in) ::  rxmcnt
      integer, intent(in) ::  fixcnt(2)
      integer, intent(in) ::  fixmap(var_lim,3,2)
      integer, intent(in) ::  rxmap(rxt_lim)
      logical, intent(in) ::  f90

!-----------------------------------------------------------------------
!        ... The local variables
!-----------------------------------------------------------------------
      integer  ::   j, k, l, rxno
      character(len=72) :: line
      logical  ::  first
      logical  ::  divide
      logical  ::  doloop
      logical  ::  lexist
      
      integer  ::  STRLEN
      
      INQUIRE( file = TRIM( temp_path ) // 'mo_adjrxt.F', exist = lexist )
      if( lexist ) then
	 call SYSTEM( 'rm ' // TRIM( temp_path ) // 'mo_adjrxt.F' )
      end if
      OPEN( unit = 30, file = TRIM( temp_path ) // 'mo_adjrxt.F' )

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'module mo_adjrxt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'private'
      write(30,100) trim(line)
      line(7:) = 'public :: adjrxt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'contains'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'subroutine adjrxt( rate, inv, m, plnplv )'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'use chem_mods, only : nfs, rxntot'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'implicit none '
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '!       ... Dummy arguments'
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '      integer, intent(in) :: plnplv'
      write(30,100) trim(line)
      line = '      real, intent(in)    :: inv(plnplv,nfs)'
      write(30,100) trim(line)
      line = '      real, intent(in)    :: m(plnplv)'
      write(30,100) trim(line)
      line = '      real, intent(inout) :: rate(plnplv,rxntot)'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '!       ... Local variables'
      write(30,100) trim(line)
      line = '!--------------------------------------------------------------------'
      write(30,100) trim(line)
      line = '      real    ::  im(plnplv)'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      
      
      first = .true.
      divide = .false.
      doloop = .false.
!---------------------------------------------------------
!	... First check reactions with invariants for 
!	    potential modification
!---------------------------------------------------------
      do j = 1,2
         do k = 1,fixcnt(j)
            rxno = ABS( fixmap(k,1,j) )
            if( j == 2 .or. rxno > phtcnt ) then
               if( first ) then
                  first = .false.
                  doloop = .true.
               end if
               if( .not. divide .and. fixmap(k,1,j) < 0 ) then
                  line(7:) = 'im(:) = 1. / m(:)'
                  write(30,100) trim(line)
                  divide = .true.
               end if
               line(7:) = 'rate(:,   ) = rate(:,   )'
               write(line(14:16),'(i3)') rxno
               write(line(28:30),'(i3)') rxno
               do l = 2,j+1
                  line(STRLEN(line)+1:) = ' * inv(:,'
                  write(line(STRLEN(line)+1:),'(i2)') fixmap(k,l,j)
                  line(STRLEN(line)+1:) = ')'
               end do
               if( fixmap(k,1,j) < 0 ) then
                  line(STRLEN(line)+1:) = ' * im(:)'
               end if
               write(30,100) trim(line)
            end if
         end do
      end do

!---------------------------------------------------------
!	... Now do all nonlinear reactions
!---------------------------------------------------------
      first = .true.
      do k = 1,rxmcnt
         rxno = rxmap(k)
         if( first ) then
            line = ' '
            line(7:) = 'rate(:,   ) = rate(:,   ) * m(:)'
            first    = .false.
            doloop   = .true.
         end if
         write(line(14:16),'(i3)') rxno
         write(line(28:30),'(i3)') rxno
         write(30,100) trim(line)
      end do

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end subroutine adjrxt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end module mo_adjrxt'
      write(30,100) trim(line)
      
      CLOSE(30)
      
100   format(a)      
      
      end subroutine MAKE_RADJ
