
      module SET_RXT_RATES

      use IO, only : temp_path

      private
      public :: make_rate

      CONTAINS

      subroutine MAKE_RATE( sym_rates, &
                            rxptab, &
                            rxpcnt, &
                            machine, &
                            arch_type, &
                            vec_ftns, &
			    f90 )
!-----------------------------------------------------------------------
!        ... Write fortran "internal" reaction rates
!-----------------------------------------------------------------------

      use RXT_MOD, only : troecnt, troetab, troe_sym_rates, rxparm

      implicit none

!-----------------------------------------------------------------------
!        ... Dummy arguments
!-----------------------------------------------------------------------
      integer, intent(in) ::    rxpcnt
      integer, intent(in) ::    rxptab(*)
      character(len=16), intent(in) :: sym_rates(2,*)
      character(len=8), intent(in)  :: machine
      character(len=8), intent(in)  :: arch_type
      logical, intent(in) ::    f90
      logical, intent(in) ::    vec_ftns

!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer  ::   i, cnt, indp, inde, l, m, m1, pos
      integer  ::   match_cnt
      integer  ::   match_ind(rxpcnt)
      real     ::   rate
      character(len=132) :: line
      character(len=32)  :: wrk, buff
      character(len=3)   :: num
      logical  ::  lexist
      logical  ::  t_dependent(rxpcnt)
      

      INQUIRE( file = TRIM( temp_path ) // 'mo_setrxt.F', exist = lexist )
      if( lexist ) then
	 call SYSTEM( 'rm ' // TRIM( temp_path ) // 'mo_setrxt.F' )
      end if
      OPEN( unit = 30, file = TRIM( temp_path ) // 'mo_setrxt.F' )

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'module mo_setrxt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'private'
      write(30,100) trim(line)
      line(7:) = 'public :: setrxt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'contains'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
         line(7:) = 'subroutine setrxt( rate, temp, m, plnplv )'
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
      else
         line(7:) = 'subroutine setrxt( rate, temp, m, plonl )'
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
         line = ' '
         line(7:) = 'use mo_grid,   only : plev, plnplv'
      end if
      write(30,100) trim(line)
      line(7:) = 'use chem_mods, only : rxntot'
      write(30,100) trim(line)
      line(7:) = 'use mo_jpl,    only : jpl'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'implicit none '
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line = '!-------------------------------------------------------'
      write(30,100) trim(line)
      line = '!       ... Dummy arguments'
      write(30,100) trim(line)
      line = '!-------------------------------------------------------'
      write(30,100) trim(line)
      if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
         line = '      integer, intent(in) :: plnplv'
         write(30,100) trim(line)
         line = '      real, intent(in)    :: temp(plnplv), m(plnplv)'
         write(30,100) trim(line)
         line = '      real, intent(inout) :: rate(plnplv,rxntot)'
      else
         line = '      integer, intent(in) :: plonl'
         write(30,100) trim(line)
         line = '      real, intent(in)    :: temp(plonl,plev), m(plonl,plev)'
         write(30,100) trim(line)
         line = '      real, intent(inout) :: rate(plonl,plev,rxntot)'
      end if
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)

      if( rxpcnt == 0 ) then
         line(7:) = 'end subroutine setrxt'
         write(30,100) trim(line)
         line = ' '
         write(30,100) trim(line)
         line(7:) = 'end module mo_setrxt'
         write(30,100) trim(line)
	 return
      end if

!-----------------------------------------------------------------------
!        ... Check for temp dependent rates
!-----------------------------------------------------------------------
      t_dependent(:rxpcnt) = sym_rates(2,:rxpcnt) /= ' '
      cnt = COUNT( t_dependent(:rxpcnt) )
      if( cnt /= 0 .or. troecnt /= 0 ) then
         line = '!-------------------------------------------------------'
	 write(30,100) trim(line)
         line = '!       ... Local variables'
	 write(30,100) trim(line)
         line = '!-------------------------------------------------------'
	 write(30,100) trim(line)
	 line = ' '
	 if( vec_ftns ) then
            line(7:) = 'integer  ::  n'
	    write(30,100) trim(line)
	 end if
	 if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
            line(7:) = 'real  ::  itemp(plnplv), exp_fac(plnplv)'
	 else
            line(7:) = 'real  ::  itemp(plonl,plev), exp_fac(plonl,plev)'
	 end if
         write(30,100) trim(line)
      end if
      if( troecnt /= 0 ) then
         if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
            line(7:) = 'real, dimension(plnplv) :: ko, kinf'
	 else
            line(7:) = 'real, dimension(plonl,plev) :: ko, kinf'
	 end if
         write(30,100) trim(line)
      end if
      line = ' '
      write(30,100) trim(line)
      
!-----------------------------------------------------------------------
!        ... First do all temperature independent rates
!-----------------------------------------------------------------------
      if( cnt /= rxpcnt ) then
         line = ' '
         do i = 1,rxpcnt
            if( sym_rates(2,i) == ' ' ) then
	       if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                  line(7:) = 'rate(:,'
	       else
                  line(7:) = 'rate(:,:,'
	       end if
               write(num,'(i3)') rxptab(i)
	       num = ADJUSTL( num )
	       l = len_TRIM( sym_rates(1,i) )
	       wrk = sym_rates(1,i)(:l)
	       indp = SCAN( wrk(:l), '.' )
	       inde = SCAN( wrk(:l), 'eE' )
	       if( indp == 0 .and. inde == 0 ) then
		  l = l + 1
		  wrk(l:l) = '.'
	       end if
	       line(len_trim(line)+1:) = num(:len_TRIM(num)) // ') = ' // wrk(:l)
               write(30,100) trim(line)
            end if
         end do
      end if

!-----------------------------------------------------------------------
!        ... Now do temp dependent rxts
!-----------------------------------------------------------------------
      if( cnt /= 0 ) then
	 if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
            line(7:) = 'itemp(:) = 1. / temp(:)'
	 else
            line(7:) = 'itemp(:,:) = 1. / temp(:,:)'
	 end if
         write(30,100) trim(line)
	 if( vec_ftns ) then
            line(7:) = 'n = plonl*plev'
            write(30,100) trim(line)
	 end if
         line = ' '
         do i = 1,rxpcnt
            if( t_dependent(i) ) then
	       match_cnt = 0
	       do m = i,rxpcnt
		  if( rxparm(2,i) == rxparm(2,m) ) then
		     match_cnt = match_cnt + 1
		     match_ind(match_cnt) = m
		     t_dependent(m) = .false.
		  end if
	       end do
	       if( match_cnt > 1 ) then
	          if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                     line(7:) = 'exp_fac(:) = '
	          else if( .not. vec_ftns ) then
                     line(7:) = 'exp_fac(:,:) = '
	          end if
	          l    = len_TRIM( sym_rates(2,i) )
	          wrk  = sym_rates(2,i)(:l)
	          indp = SCAN( wrk(:l), '.' )
	          inde = SCAN( wrk(:l), 'eE' )
	          if( indp == 0 .and. inde == 0 ) then
		     l = l + 1
		     wrk(l:l) = '.'
	          end if
	          pos = len_TRIM( line )
		  if( .not. vec_ftns ) then
                     line(pos+1:) = ' exp( ' // wrk(:l)
		  else
                     line(7:) = 'call vexp( exp_fac, ' // wrk(:l)
		  end if
	          if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                     line(len_trim(line)+1:) = ' * itemp(:) )'
	          else if( .not. vec_ftns ) then
                     line(len_trim(line)+1:) = ' * itemp(:,:) )'
		  else if( vec_ftns ) then
                     line(len_trim(line)+1:) = ' * itemp, n )'
	          end if
                  write(30,100) trim(line)
		  do m = 1,match_cnt
	             if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                        line(7:) = 'rate(:,'
	             else
                        line(7:) = 'rate(:,:,'
	             end if
		     m1 = match_ind(m)
                     write(num,'(i3)') rxptab(m1)
	             num = ADJUSTL( num )
	             l = len_TRIM( sym_rates(1,m1) )
	             wrk = sym_rates(1,m1)(:l)
	             indp = SCAN( wrk(:l), '.' )
	             inde = SCAN( wrk(:l), 'eE' )
	             if( indp == 0 .and. inde == 0 ) then
		        l = l + 1
		        wrk(l:l) = '.'
	             end if
	             if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
	                line(len_trim(line)+1:) = num(:len_TRIM(num)) // ') = ' // wrk(:l) // ' * exp_fac(:)'
		     else
	                line(len_trim(line)+1:) = num(:len_TRIM(num)) // ') = ' // wrk(:l) // ' * exp_fac(:,:)'
		     end if
                     write(30,100) trim(line)
	          end do
	       else
	          if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                     line(7:) = 'rate(:,'
	          else if( .not. vec_ftns ) then
                     line(7:) = 'rate(:,:,'
	          end if
                  write(num,'(i3)') rxptab(i)
	          num = ADJUSTL( num )
	          l = len_TRIM( sym_rates(1,i) )
	          wrk  = sym_rates(1,i)(:l)
	          indp = SCAN( wrk(:l), '.' )
	          inde = SCAN( wrk(:l), 'eE' )
	          if( indp == 0 .and. inde == 0 ) then
		     l = l + 1
		     wrk(l:l) = '.'
	          end if
		  if( .not. vec_ftns ) then
	             line(len_trim(line)+1:) = num(:len_TRIM(num)) // ') = ' // wrk(:l)
		  else
		     buff = wrk
		  end if
	          l = len_TRIM( sym_rates(2,i) )
	          wrk  = sym_rates(2,i)(:l)
	          indp = SCAN( wrk(:l), '.' )
	          inde = SCAN( wrk(:l), 'eE' )
	          if( indp == 0 .and. inde == 0 ) then
		     l = l + 1
		     wrk(l:l) = '.'
	          end if
		  if( vec_ftns ) then
                     line(7:) = 'call vexp( exp_fac, ' // wrk(:l) // '*itemp, n )'
                     write(30,100) trim(line)
                     line(7:) = 'rate(:,:,' // trim(num) // ') = ' // trim(buff) // ' * exp_fac(:,:)'
		  end if
		  if( .not. vec_ftns ) then
	             pos = len_TRIM( line )
                     line(pos+1:) = ' * exp( ' // wrk(:l)
	             if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
                        line(len_trim(line)+1:) = ' * itemp(:) )'
	             else
                        line(len_trim(line)+1:) = ' * itemp(:,:) )'
	             end if
		  end if
                  write(30,100) trim(line)
	       end if
            end if
         end do
      end if

!-----------------------------------------------------------------------
!        ... Troe rates
!-----------------------------------------------------------------------
      if( troecnt /= 0 ) then
	 line = ' '
         write(30,100) trim(line)
	 if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
            line(7:) = 'itemp(:) = 300. * itemp(:)'
	 else
            line(7:) = 'itemp(:,:) = 300. * itemp(:,:)'
	 end if
         write(30,100) trim(line)
         do i = 1,troecnt
            line = ' '
            write(30,100) trim(line)
	    if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
               line(7:) = 'ko(:)'
	    else
               line(7:) = 'ko(:,:)'
	    end if
	    l = len_TRIM( troe_sym_rates(1,i) )
	    wrk = troe_sym_rates(1,i)(:l)
	    indp = SCAN( wrk(:l), '.' )
	    inde = SCAN( wrk(:l), 'eE' )
	    if( indp == 0 .and. inde == 0 ) then
	       l = l + 1
	       wrk(l:l) = '.'
	    end if
	    line(len_trim(line)+1:) =  ' = ' // wrk(:l)
	    if( troe_sym_rates(2,i) /= ' ' ) then
	       l = len_TRIM( troe_sym_rates(2,i) )
	       read(troe_sym_rates(2,i)(:l),*) rate
	       wrk = troe_sym_rates(2,i)(:l)
	       indp = SCAN( wrk(:l), '.' )
	       inde = SCAN( wrk(:l), 'eE' )
	       if( indp == 0 .and. inde == 0 ) then
		  l = l + 1
		  wrk(l:l) = '.'
	       end if
	       if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
		  if( rate /= 0. ) then
		     if( rate > 0. ) then
                        line(len_trim(line)+1:) = ' * itemp(:)**' // wrk(:l)
		     else
                        line(len_trim(line)+1:) = ' * itemp(:)**(' // wrk(:l) // ')'
		     end if
		  end if
	       else
		  if( rate /= 0. ) then
		     if( rate > 0. ) then
                        line(len_trim(line)+1:) = ' * itemp(:,:)**' // wrk(:l)
		     else
                        line(len_trim(line)+1:) = ' * itemp(:,:)**(' // wrk(:l) // ')'
		     end if
		  end if
	       end if
	    end if
            write(30,100) trim(line)
	    if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
               line(7:) = 'kinf(:)'
	    else
               line(7:) = 'kinf(:,:)'
	    end if
	    l = len_TRIM( troe_sym_rates(3,i) )
	    wrk = troe_sym_rates(3,i)(:l)
	    indp = SCAN( wrk(:l), '.' )
	    inde = SCAN( wrk(:l), 'eE' )
	    if( indp == 0 .and. inde == 0 ) then
	       l = l + 1
	       wrk(l:l) = '.'
	    end if
	    line(len_trim(line)+1:) =  ' = ' // wrk(:l)
	    if( troe_sym_rates(4,i) /= ' ' ) then
	       l = len_TRIM( troe_sym_rates(4,i) )
	       read(troe_sym_rates(4,i)(:l),*) rate
	       wrk = troe_sym_rates(4,i)(:l)
	       indp = SCAN( wrk(:l), '.' )
	       inde = SCAN( wrk(:l), 'eE' )
	       if( indp == 0 .and. inde == 0 ) then
		  l = l + 1
		  wrk(l:l) = '.'
	       end if
	       if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
		  if( rate /= 0. ) then
		     if( rate /= 1. ) then
		        if( rate > 0. ) then
                           line(len_trim(line)+1:) = ' * itemp(:)**' // wrk(:l)
		        else
                           line(len_trim(line)+1:) = ' * itemp(:)**(' // wrk(:l) // ')'
		        end if
		     else
                        line(len_trim(line)+1:) = ' * itemp(:)'
		     end if
		  end if
	       else
		  if( rate /= 0. ) then
		     if( rate /= 1. ) then
		        if( rate > 0. ) then
                           line(len_trim(line)+1:) = ' * itemp(:,:)**' // wrk(:l)
		        else
                           line(len_trim(line)+1:) = ' * itemp(:,:)**(' // wrk(:l) // ')'
		        end if
		     else
                        line(len_trim(line)+1:) = ' * itemp(:,:)'
		     end if
		  end if
	       end if
	    end if
            write(30,100) trim(line)
	    if( machine == 'NEC' .or. machine == 'FUJITSU' ) then
               line(7:) = 'call jpl( rate(1,'
	    else
               line(7:) = 'call jpl( rate(1,1,'
	    end if
            write(num,'(i3)') troetab(i)
	    num = ADJUSTL( num )
	    l = len_TRIM( troe_sym_rates(5,i) )
	    wrk = troe_sym_rates(5,i)(:l)
	    indp = SCAN( wrk(:l), '.' )
	    inde = SCAN( wrk(:l), 'eE' )
	    if( indp == 0 .and. inde == 0 ) then
	       l = l + 1
	       wrk(l:l) = '.'
	    end if
	    line(len_trim(line)+1:) = num(:len_TRIM(num)) // '), m, ' // wrk(:l) // ', ko, kinf, plnplv )'
            write(30,100) trim(line)
         end do
      end if

      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end subroutine setrxt'
      write(30,100) trim(line)
      line = ' '
      write(30,100) trim(line)
      line(7:) = 'end module mo_setrxt'
      write(30,100) trim(line)
      
      CLOSE(30)
      
100   format(a)

      end subroutine MAKE_RATE

      end module SET_RXT_RATES
