
      subroutine MAKE_RMOD( rxt2rel_pntr, &
                            rel_rxt_map, &
                            rxt2grp_pntr, &
                            grp_rxt_map, &
                            hetmap, &
                            hetcnt, &
                            rxntot, &
			    f90 )
!-----------------------------------------------------------------------
!        ... Make the group ratios reaction rate adjustment code
!-----------------------------------------------------------------------

      use RXT_MOD, only : rxt_lim
      use IO,      only : temp_path

      implicit none

!-----------------------------------------------------------------------
!        ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) ::    rxt2rel_pntr(rxt_lim,2)
      integer, intent(in) ::    rel_rxt_map(rxt_lim,3,2)
      integer, intent(in) ::    rxt2grp_pntr(rxt_lim,2)
      integer, intent(in) ::    grp_rxt_map(rxt_lim,3,2)
      integer, intent(in) ::    hetmap(rxt_lim)
      integer, intent(in) ::    rxntot
      integer, intent(in) ::    hetcnt
      logical, intent(in) ::    f90

!-----------------------------------------------------------------------
!        ... Local variables
!-----------------------------------------------------------------------
      integer, parameter :: max_len = 90
      integer  ::   k, l, rxno, row, index
      character(len=max_len) :: line
      logical  ::  first
      logical  ::  found
      logical  ::  lexist
      
      integer  ::  STRLEN
      
      INQUIRE( file = trim( temp_path ) // 'mo_rxt_mod.F', exist = lexist )
      if( lexist ) then
	 call SYSTEM( 'rm ' // trim( temp_path ) // 'mo_rxt_mod.F' )
      end if
      OPEN( unit = 30, file = trim( temp_path ) // 'mo_rxt_mod.F' )

      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'module mo_rxt_mod'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'private'
      write(30,100) line(:len_trim(line))
      line(7:) = 'public :: rxt_mod'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'contains'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'subroutine rxt_mod( rate, het_rates, grp_ratios, plnplv )'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) trim( line )
      line(7:) = 'use chem_mods, only : rxntot, hetcnt, grpcnt'
      write(30,100) trim( line )
      line = ' '
      write(30,100) trim( line )
      line(7:) = 'implicit none '
      write(30,100) trim( line )
      line = ' '
      write(30,100) trim( line )
      line = '!---------------------------------------------------------------------------'
      write(30,100) line(:len_trim(line))
      line = '!       ... Dummy arguments'
      write(30,100) line(:len_trim(line))
      line = '!---------------------------------------------------------------------------'
      write(30,100) line(:len_trim(line))
      line = '      integer, intent(in) ::  plnplv'
      write(30,100) line(:len_trim(line))
      line = '      real, intent(inout) ::  rate(plnplv,rxntot)'
      write(30,100) line(:len_trim(line))
      line = '      real, intent(inout) ::  het_rates(plnplv,hetcnt)'
      write(30,100) line(:len_trim(line))
      line = '      real, intent(in)    ::  grp_ratios(plnplv,grpcnt)'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      
      first = .true.
      do k = 1,rxntot
!-----------------------------------------------------------------------
!        ... Scan the group map
!-----------------------------------------------------------------------
	 found = .false.
         index = rxt2grp_pntr(k,1)
         row   = rxt2grp_pntr(k,2)
         do l = 1,index
            found = .true.
            if( first ) then
               line = ' '
               first = .false.
            end if
            rxno = grp_rxt_map(row,1,index)
            if( l == 1 ) then
	       line = ' '
               line(7:) = 'rate(:,   ) = rate(:,   )'
               write(line(14:16),'(i3)') rxno
               write(line(28:30),'(i3)') rxno
               line(STRLEN(line)+2:) = ' * grp_ratios(:,'
               write(line(STRLEN(line)+1:),'(i2)') grp_rxt_map(row,l+1,index)
               line(STRLEN(line)+1:) = ')'
	    else
	       line(len_trim(line)+1:) = ' &'
	       write(30,100) line(:len_trim(line))
	       line(6:) = ' '
               line(33:) = ' * grp_ratios(:,'
               write(line(STRLEN(line)+1:),'(i2)') grp_rxt_map(row,l+1,index)
               line(STRLEN(line)+1:) = ')'
            end if
         end do
         if( found ) then
            write(30,100) line(:len_trim(line))
         end if
      end do

      do k = 1,hetcnt
	 if( hetmap(k) /= 0 ) then
            line = ' '
            if( first ) then
               first = .false.
            end if
            line(7:) = '    het_rates(j,   ) = het_rates(j,   )'
            write(line(19:21),'(i3)') k
            write(line(38:40),'(i3)') k
            line(STRLEN(line)+2:) = ' * grp_ratios(:,'
            write(line(STRLEN(line)+1:),'(i2)') hetmap(k)
            line(STRLEN(line)+1:) = ')'
            write(30,100) line(:len_trim(line))
         end if
      end do

      line = ' '
      write(30,100) line(:len_trim(line))
      line = '      end subroutine rxt_mod'
      write(30,100) line(:len_trim(line))
      line = ' '
      write(30,100) line(:len_trim(line))
      line(7:) = 'end module mo_rxt_mod'
      write(30,100) line(:len_trim(line))
      
      CLOSE(30)
      
100   format(a)      
      
      end subroutine MAKE_RMOD
