
      module surface_flux

      implicit none

      private
      public :: srfflx

      contains

      subroutine srfflx( lin, lout, new_nq, new_solsym, srf_flx_map, &
                         srf_flx_cnt, tag, megan_map, xactive_map )

      use var_mod, only : var_lim

!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in)    ::  lin                     ! input unit number
      integer, intent(in)    ::  lout                    ! output unit number
      integer, intent(in)    ::  new_nq                  ! species count
      integer, intent(in)    ::  tag                     ! emission or deposition tag ( 1,2 )
      integer, intent(inout) ::  srf_flx_cnt             ! count of species with srf flux
      integer, intent(out)   ::  srf_flx_map(:)          ! srf flux "map"
      logical, optional, intent(out) ::  megan_map(:)    ! interactive megan srf flux "map"
      logical, optional, intent(out) ::  xactive_map(:)  ! interactive srf flux "map"
      character(len=8), intent(in)   ::  new_solsym(:)   ! species names

!-----------------------------------------------------------------------
!       ... Local variables
!-----------------------------------------------------------------------
      integer, parameter ::  srf_flx = 1
      integer, parameter ::  dep_vel = 2
!     integer, parameter ::  symlen = 8
      integer, parameter ::  symlen = 32

      integer  ::  nchar
      integer  ::  toklen(20)
      integer  ::  j, k
      integer  ::  slen, delim_pos
      integer  ::  no_tokens

      character(len=120) ::  buff
      character(len=120) ::  buffh
      character(len=symlen) ::  tokens(20)
      character(len=7)   ::  upper_case

      logical  ::  found
      logical  ::  has_qualifier

!-----------------------------------------------------------------------
!       ... Read the surface flux species
!-----------------------------------------------------------------------
read_loop : &
      do
         call cardin( lin, buff, nchar )
         buffh = buff
         call upcase( buffh )
         if( tag == srf_flx .and. buffh == 'ENDSURFACEFLUX' ) then
	    exit
         else if( tag == dep_vel .and. buffh == 'ENDSURFACEDEPOSITION' ) then
	    exit
	 end if
         call gettokens(  buff,     nchar,    ',',      symlen, &
                          tokens,   toklen,   20,       no_tokens )
         if( no_tokens == 0 ) then
            call errmes( ' SRFFLX: Species input line in error@', lout, buff, 1, buff )
         end if
token_loop : &
         do j = 1,no_tokens
            srf_flx_cnt = srf_flx_cnt + 1
            if( srf_flx_cnt > var_lim ) then
               call errmes( ' SRFFLX: Species count exceeds limit@', lout, buff, 1, buff )
            end if
            has_qualifier = .false.
            if( tag == srf_flx ) then
	       slen = index( tokens(j), '=' )
               if( slen > 0 ) then
                  if( slen == 1 ) then
                     call errmes( 'SRFFLX: srf emis definition missing species name@', lout, tokens(j), toklen(j), buff )
                  end if
                  slen = slen - 1
                  has_qualifier = .true.
               end if
            else
	       slen = 0
            end if
            if( slen == 0 ) then
	       slen = len_trim( tokens(j) )
            end if
	    found = .false.
match_loop : &
	    do k = 1,new_nq
	       if( tokens(j)(:slen) == new_solsym(k) ) then
		  if( srf_flx_cnt > 1 ) then
		     if( any( srf_flx_map(:srf_flx_cnt) == k ) ) then
			if( tag == srf_flx ) then
                           call errmes( '# is already in srf emis list@', lout, tokens(j), toklen(j), buff )
			else if( tag == dep_vel ) then
                           call errmes( '# is already in dry dep list@', lout, tokens(j), toklen(j), buff )
			end if
		     end if
		  end if
	          srf_flx_map(srf_flx_cnt) = k
	          found = .true.
		  exit
	       end if
	    end do match_loop
	    if( .not. found ) then
               call errmes( '# is not in solution species list@', lout, tokens(j), toklen(j), buff )
            end if
	    if( present( megan_map ) .and. has_qualifier ) then
               buffh = tokens(j)(slen+2:)
               slen  = index( buffh, ':' )
               if( slen == 0 ) then
                  delim_pos  = len_trim( buffh )
               else
                  delim_pos  = slen - 1
               end if
               upper_case = buffh(:delim_pos)
               call upcase( upper_case )
	       if( upper_case == 'XACTIVE' ) then
	          xactive_map(srf_flx_cnt) = .true.
               else
                  call errmes( ' SRFFLX: XACTIVE qualifier missing@', lout, buff, 1, buff )
               end if
               if( slen > 0 ) then
                  upper_case = buffh(slen+1:)
                  call upcase( upper_case )
	          if( upper_case == 'MEGAN' ) then
	             megan_map(srf_flx_cnt) = .true.
                  else
	             megan_map(srf_flx_cnt) = .false.
                  end if
               end if
            end if
         end do token_loop
      end do read_loop

      end subroutine srfflx

      end module surface_flux
