
      subroutine SYMBOL( iout )
!-----------------------------------------------------------------------
!	... Parse out the solution, pce, fixed, column, and group variables
!-----------------------------------------------------------------------

      use IO
      use VAR_MOD, only : indexh2o, spccnt, indexm, grpsym, grpcof, &
			  grpmap, grpcnt, colsym, colmap, spcsym, &
			  colub, relmap, aliases, var_lim

      implicit none

!-----------------------------------------------------------------------
!	... Dummy args
!-----------------------------------------------------------------------
      character(len=80), intent(out) ::  iout(*)

!-----------------------------------------------------------------------
!	... Local variables
!-----------------------------------------------------------------------
      integer, parameter :: symlen = 8

      integer  ::  retcod, parsw(5), nchar
      integer  ::  spclim(5)
      integer  ::  kpar, i
      integer  ::  symbol_len

      integer, allocatable ::      toklen(:)
      integer  ::  j, k, jl, l, ic, m, count
      integer  ::  jeq, no_tokens, relcnt
      integer  ::  line_cnt

      character(len=80), allocatable ::  tokens(:)
      character(len=16) ::  param
      character(len=8)  ::  spchdr(5) = (/ 'SOLUTION', 'PCE     ', 'FIXED   ', &
					   'GROUPS  ', 'COL-INT ' /)
      character(len=11)  :: spcend(5) = (/ 'ENDSOLUTION', 'ENDPCE     ', 'ENDFIXED   ', &
					   'ENDGROUPS  ', 'ENDCOL-INT ' /)
      character(len=8)  ::  upname
      character(len=1)  ::  char

      logical  :: found
      logical  :: new_grp

      spclim(:) = var_lim
      parsw(:) = 0
      buffh = buff
      call upcase( buffh )
      if( buffh /= 'SPECIES' ) then
         call errmes( '"Species" card missing; run terminated@', lout, char, 1, buff )
      end if
      kpar = 0
      allocate( tokens(64) )
      allocate( toklen(64) )

symbol_loop : &
      do
         call cardin( lin, buff, nchar )
         buffh = buff
         call upcase( buffh )
         if( buffh == 'ENDSPECIES' ) then
	    deallocate( tokens )
	    deallocate( toklen )
	    exit symbol_loop
         end if
         count = 0
	 found = .false.
         do kpar = 1,5
           if( buffh == spchdr(kpar) ) then
	      found = .true.
	      exit
	   end if
         end do
	 if( .not. found ) then
            call errmes( '# is an invalid species header@', lout, buff(:8), 8, buff )
         else if( parsw(kpar) /= 0 ) then
            call errmes( '# species class already declared@', lout, spchdr(kpar), len_trim(spchdr(kpar)), buff )
         else if( kpar >= 4 .and. MAXVAL( spccnt(1:3) ) == 0 ) then
               call errmes( 'There are no sol,pce,fixed species; cannot declare # species class@', lout,  &
                            spchdr(kpar), len_trim(spchdr(kpar)), buff )
         else if( kpar == 2 .and. parsw(1) /= 1 ) then
            call errmes( ' Solution species must be specified BEFORE pce species@', lout, buff, 1, ' ' )
         end if
         parsw(kpar) = 1

         if( kpar <= 3 ) then
!-----------------------------------------------------------------------
!       ... Read the solution, fixed, and/or "relationship" variables
!-----------------------------------------------------------------------
            do
               call cardin( lin, buff, nchar )
               buffh = buff
               call upcase( buffh )
               if( buffh == spcend(kpar) ) then
                  if( kpar == 1 .and. count == 0 ) then
                     call errmes( 'No # variables declared; terminating@', lout, spchdr(1), &
                         len_trim(spchdr(1)), &
                         buff )
                  end if
		  spccnt(kpar) = count
		  exit
               end if
	       if( kpar == 1 ) then
		  symbol_len = 80
	       else if( kpar /= 2 ) then
		  symbol_len = symlen
	       else
		  symbol_len = 2*symlen+1
	       end if
               call gettokens(  buff,     nchar,    ',',      symbol_len, &
                                tokens,   toklen,   64,       no_tokens )
               if( no_tokens <= 0 ) then
                  call errmes( ' Species input line in error@', lout, buff, 1, ' ' )
               end if
               if( (count + no_tokens) > spclim(kpar) ) then
                  call errmes( ' Species count exceeds limit@', lout, buff, 1, buff )
               end if
               do j = 1,no_tokens
                  count = count + 1
                  if( kpar == 1 ) then
		     l = index( tokens(j)(:toklen(j)), '->' )
		     if( l == 0 ) then
			if( toklen(j) <= symlen ) then
                           spcsym(count,1) = tokens(j)(:toklen(j))
			else
                           call errmes( ' Species input line in error@', lout, buff, 1, ' ' )
		        end if
		     else
			l = l - 1
			if( l <= symlen ) then
                           spcsym(count,1) = tokens(j)(:l)
			else
                           call errmes( ' Species input line in error@', lout, buff, 1, ' ' )
			end if
			l = l + 3
			if( toklen(j) - l + 1 <= 64 ) then
			   aliases(count) = tokens(j)(l:toklen(j))
			else
                           call errmes( ' Species input line in error@', lout, buff, 1, ' ' )
		        end if
		     end if
                  else if( kpar == 2 ) then
                     call gettokens(   tokens(j), toklen(j), '/', &
                                       symlen, tokens(19), toklen(19), &
                                       2, relcnt )
                     if( relcnt /= 2 ) then
                        call errmes( ' Relationship syntax error@', lout, buff, 1, ' ' )
                     end if
match_loop :         do m = 1,2
                        do l = 1,spccnt(1)
                           if( tokens(18+m) == spcsym(l,1)) then
                              relmap(count,m) = l
                              cycle match_loop
                           end if
                        end do
                        if( relmap(count,m) == 0 ) then
                           call errmes( ' Relation member # not in solution list@', lout, &
                                       tokens(18+m), toklen(18+m), &
                                       buff )
                        end if
                     end do match_loop
                  else
                     spcsym(count,kpar) = tokens(j)(:toklen(j))
                  end if
               end do
            end do
         
!-----------------------------------------------------------------------
!       ... Check fixed species for atmospheric total density symbol "M"
!	    and see if water vapor is declard
!-----------------------------------------------------------------------
            if( kpar == 3 ) then
	       found = .false.
               do i = 1,spccnt(3)
	          upname = spcsym(i,3)
	          call upcase( upname )
                  if( upname == 'M' ) then
                     indexm = i
		     found = .true.
		     exit
	          end if
               end do
	       if( .not. found ) then
                  call errmes( 'There must be a fixed symbol "m"; run terminated@', lout, char, 1, buff )
	       end if
               do i = 1,spccnt(3)
	          upname = spcsym(i,3)
	          call upcase( upname )
                  if( upname == 'H2O' ) then
                     indexh2o = i
		     exit
	          end if
               end do
            end if
         else if( kpar == 4 ) then
!-----------------------------------------------------------------------
!     ... The group section
!-----------------------------------------------------------------------
            line_cnt = 0
grp_loop :  do
               call cardin( lin, buff, nchar )
	       buffh = buff
               call upcase( buffh )
               if( buffh == spcend(kpar) ) then
		  spccnt(4) = count
		  exit grp_loop
	       end if
	       jeq     = index( buff(:symlen+1),'=' )
	       new_grp = jeq > 0
               if( new_grp ) then
                  count = count + 1
                  if( count > spclim(kpar) ) then
                     call errmes( 'Group count exceeds limit@', lout, buff, 1, buff )
                  end if
	          if( jeq == 0 ) then
                     call errmes( 'Group name exceeds char limit@', lout, buff, 1, buff )
	          else if( jeq == 1 ) then
                     call errmes( 'Group name missing@', lout, buff, 1, buff )
	          else if( jeq == nchar ) then
                     call errmes( 'Group list missing@', lout, buff, 1, buff )
	          end if
                  grpsym(count) = buff(:jeq-1)
	          l = 0
               end if
               jl = jeq + 1
               call gettokens(  buff(jl:nchar),     nchar - jl + 1,    '+', 16, &
                                tokens,   toklen,   20,       no_tokens )
	       if( no_tokens <= 1 ) then
                  call errmes( 'One or fewer group members@', lout, buff, 1, buff )
	       end if
grp_tok_loop : do j = 1,no_tokens
		  k = index( tokens(j)(:toklen(j)),'*' )
		  if( k == 1 ) then
                     call errmes( 'No group member multiplier specified@', lout, buff, 1, buff )
		  else if( k == toklen(j) ) then
                     call errmes( 'No group member specified@', lout, buff, 1, buff )
		  end if
		  param = tokens(j)(k+1:toklen(j))
		  found = .false.
grp_srch_loop :   do ic = 1,2
                     do m = 1,spccnt(ic)
                        if( param == spcsym(m,ic) ) then
			   found = .true.
			   exit grp_srch_loop
			end if
                     end do
                  end do grp_srch_loop
		  if( .not. found ) then
                     call errmes( 'Group member # not in sol,pce lists@', lout, param, k, buff )
		  end if
                  l = l + 1
                  if( l > 20 ) then
                     call errmes( 'Group member count exceeds limit@', lout, buff, 1, buff )
                  end if
		  if( k /= 0 ) then
		     param = tokens(j)(:k-1)
                     call relcon( param, k-1, grpcof(l,count), retcod )
                     if( retcod /= 0 ) then
                        call errmes( '# is an invalid group member coefficient@', lout, param, k-1, buff )
                     end if
		  end if
                  grpmap(l,count) = 1000*ic + m
	       end do grp_tok_loop

               if( l == 0 ) then
                  call errmes( 'Group has no members@', lout, buff, 1, buff )
               end if
               grpcnt(count) = l
               line_cnt = line_cnt + 1
	       iout(line_cnt) = ' '
               if( new_grp ) then
	          iout(line_cnt) = buff(:jeq-1) // ' = '
               end if
	       do j = 1,no_tokens
		  jl = len_trim(iout(line_cnt)) + 1
		  if( j == 1 ) then
		     iout(line_cnt)(jl+1:) = tokens(j)(:toklen(j))
		  else
		     iout(line_cnt)(jl:) = ' + ' // tokens(j)(:toklen(j))
		  end if
	       end do
            end do grp_loop
         else if( kpar == 5 ) then
!-----------------------------------------------------------------------
!     ... The column integrals
!-----------------------------------------------------------------------
col_loop :  do
               call cardin( lin, buff, nchar )
	       buffh = buff
               call upcase( buffh )
               if( buffh == spcend(kpar) ) then
	          spccnt(5) = count
	          exit col_loop
	       end if
               call gettokens(  buff(:nchar),     nchar,    ',', 32, &
                                tokens,   toklen,   20,       no_tokens )
	       if( no_tokens <= 0 ) then
                  call errmes( 'Column integral list improperly specified@', lout, buff, 1, buff )
	       end if
col_tok_loop : do j = 1,no_tokens
                  param = tokens(j)
	          found = .false.
colub_srch_loop : do ic = 1,3
                     do m = 1,spccnt(ic)
                        if( param == spcsym(m,ic) ) then
			   found = .true.
			   exit colub_srch_loop
	                end if
                     end do
                  end do colub_srch_loop
	          if( .not. found ) then
                     call errmes( 'Column member # not in sol,pce, or fixed lists@', lout, param, k, buff )
	          end if
                  count = count + 1
                  if( count > spclim(kpar) ) then
                     call errmes( 'Column count exceeds limit@', lout, buff, 1, buff )
                  end if
                  colsym(count) = tokens(j)
               end do col_tok_loop
            end do col_loop
         end if
      end do symbol_loop

      end subroutine SYMBOL
