
      module mo_setrxt

      private
      public :: setrxt

      contains

      subroutine setrxt( rate, temp, m, plonl )

      use mo_grid,   only : plev, plnplv
      use chem_mods, only : rxntot
      use mo_jpl,    only : jpl

      implicit none

!-------------------------------------------------------
!       ... Dummy arguments
!-------------------------------------------------------
      integer, intent(in) :: plonl
      real, intent(in)    :: temp(plonl,plev), m(plonl,plev)
      real, intent(inout) :: rate(plonl,plev,rxntot)

!-------------------------------------------------------
!       ... Local variables
!-------------------------------------------------------
      real  ::  itemp(plonl,plev), exp_fac(plonl,plev)
      real, dimension(plonl,plev) :: ko, kinf

      rate(:,:,44) = 2.2e-10
      rate(:,:,45) = 1.1e-10
      rate(:,:,56) = 6.7e-11
      rate(:,:,57) = 4.9e-11
      rate(:,:,75) = 1.5e-10
      rate(:,:,82) = 9.e-12
      rate(:,:,87) = 1.e-14
      rate(:,:,92) = 2.e-13
      rate(:,:,93) = 6.8e-14
      rate(:,:,107) = 1e-12
      rate(:,:,120) = 5.4e-11
      rate(:,:,122) = 3.5e-12
      rate(:,:,126) = 6.8e-13
      rate(:,:,132) = 3.e-12
      rate(:,:,133) = 1.e-11
      rate(:,:,137) = 1.1e-11
      rate(:,:,141) = 2.4e-12
      rate(:,:,145) = 1.4e-11
      rate(:,:,152) = 2.4e-12
      rate(:,:,155) = 1.4e-11
      rate(:,:,158) = 5.e-12
      rate(:,:,171) = 7.e-13
      rate(:,:,174) = 2.4e-12
      rate(:,:,178) = 4.5e-11
      rate(:,:,182) = 2.4e-12
      rate(:,:,191) = 4.e-14
      rate(:,:,192) = 3.e-12
      rate(:,:,193) = 1.e-11
      rate(:,:,194) = 2.1e-6
      rate(:,:,195) = 7.1e-6
      rate(:,:,201) = 7.1e-6
      itemp(:,:) = 1. / temp(:,:)
      rate(:,:,41) = 8e-12 * exp( -2060. * itemp(:,:) )
      rate(:,:,42) = 2.1e-11 * exp( 115. * itemp(:,:) )
      rate(:,:,43) = 3.2e-11 * exp( 70. * itemp(:,:) )
      exp_fac(:,:) = exp( -2000. * itemp(:,:) )
      rate(:,:,46) = 5.5e-12 * exp_fac(:,:)
      rate(:,:,139) = 1.05e-14 * exp_fac(:,:)
      rate(:,:,47) = 2.2e-11 * exp( 120. * itemp(:,:) )
      exp_fac(:,:) = exp( 200. * itemp(:,:) )
      rate(:,:,48) = 3e-11 * exp_fac(:,:)
      rate(:,:,80) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,94) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,100) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,114) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,119) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,125) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,130) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,136) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,143) = 1.52e-11 * exp_fac(:,:)
      rate(:,:,156) = 2.3e-11 * exp_fac(:,:)
      rate(:,:,170) = 3.8e-12 * exp_fac(:,:)
      rate(:,:,49) = 1.7e-12 * exp( -940. * itemp(:,:) )
      rate(:,:,50) = 1.e-14 * exp( -490. * itemp(:,:) )
      rate(:,:,52) = 2.9e-12 * exp( -160. * itemp(:,:) )
      exp_fac(:,:) = exp( 250. * itemp(:,:) )
      rate(:,:,53) = 4.8e-11 * exp_fac(:,:)
      rate(:,:,58) = 3.5e-12 * exp_fac(:,:)
      rate(:,:,54) = 4.2e-12 * exp( -240. * itemp(:,:) )
      rate(:,:,59) = 3e-12 * exp( -1500. * itemp(:,:) )
      exp_fac(:,:) = exp( 180. * itemp(:,:) )
      rate(:,:,60) = 5.6e-12 * exp_fac(:,:)
      rate(:,:,86) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,98) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,111) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,121) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,123) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,128) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,134) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,140) = 4.4e-12 * exp_fac(:,:)
      rate(:,:,168) = 4.2e-12 * exp_fac(:,:)
      rate(:,:,61) = 1.2e-13 * exp( -2450. * itemp(:,:) )
      exp_fac(:,:) = exp( 170. * itemp(:,:) )
      rate(:,:,62) = 2.3e-12 * exp_fac(:,:)
      rate(:,:,67) = 1.5e-11 * exp_fac(:,:)
      rate(:,:,69) = 1.3e-12 * exp( 380. * itemp(:,:) )
      rate(:,:,74) = 2.45e-12 * exp( -1775. * itemp(:,:) )
      exp_fac(:,:) = exp( 300. * itemp(:,:) )
      rate(:,:,76) = 2.8e-12 * exp_fac(:,:)
      rate(:,:,116) = 2.9e-12 * exp_fac(:,:)
      rate(:,:,77) = 5.e-13 * exp( -424. * itemp(:,:) )
      rate(:,:,78) = 1.9e-14 * exp( 706. * itemp(:,:) )
      rate(:,:,79) = 4.1e-13 * exp( 750. * itemp(:,:) )
      rate(:,:,81) = 6.0e-13 * exp( -2058. * itemp(:,:) )
      rate(:,:,85) = 1.2e-14 * exp( -2630. * itemp(:,:) )
      rate(:,:,88) = 1.6e11 * exp( -4150. * itemp(:,:) )
      rate(:,:,89) = 8.7e-12 * exp( -1070. * itemp(:,:) )
      rate(:,:,90) = 2.6e-12 * exp( 365. * itemp(:,:) )
      exp_fac(:,:) = exp( 700. * itemp(:,:) )
      rate(:,:,91) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,99) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,112) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,117) = 8.6e-13 * exp_fac(:,:)
      rate(:,:,124) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,129) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,135) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,142) = 8.e-13 * exp_fac(:,:)
      rate(:,:,153) = 8.e-13 * exp_fac(:,:)
      rate(:,:,169) = 7.5e-13 * exp_fac(:,:)
      rate(:,:,175) = 8.e-13 * exp_fac(:,:)
      rate(:,:,183) = 8.e-13 * exp_fac(:,:)
      exp_fac(:,:) = exp( -1900. * itemp(:,:) )
      rate(:,:,96) = 6.5e-15 * exp_fac(:,:)
      rate(:,:,102) = 1.4e-12 * exp_fac(:,:)
      rate(:,:,97) = 4.6e-13 * exp( -1156. * itemp(:,:) )
      exp_fac(:,:) = exp( 270. * itemp(:,:) )
      rate(:,:,101) = 5.6e-12 * exp_fac(:,:)
      rate(:,:,103) = 8.1e-12 * exp_fac(:,:)
      exp_fac(:,:) = exp( 1040. * itemp(:,:) )
      rate(:,:,105) = 4.3e-13 * exp_fac(:,:)
      rate(:,:,159) = 4.30e-13 * exp_fac(:,:)
      exp_fac(:,:) = exp( 500. * itemp(:,:) )
      rate(:,:,106) = 2.0e-12 * exp_fac(:,:)
      rate(:,:,109) = 2.5e-12 * exp_fac(:,:)
      rate(:,:,118) = 2.0e-12 * exp_fac(:,:)
      rate(:,:,160) = 2.0e-12 * exp_fac(:,:)
      rate(:,:,110) = 1.0e-11 * exp( -660. * itemp(:,:) )
      rate(:,:,113) = 3.75e-13 * exp( -40. * itemp(:,:) )
      rate(:,:,127) = 2.3e-12 * exp( -170. * itemp(:,:) )
      rate(:,:,131) = 1.7e-12 * exp( 352. * itemp(:,:) )
      rate(:,:,138) = 2.54e-11 * exp( 410. * itemp(:,:) )
      exp_fac(:,:) = exp( 400. * itemp(:,:) )
      rate(:,:,144) = 5.e-13 * exp_fac(:,:)
      rate(:,:,154) = 5.e-13 * exp_fac(:,:)
      rate(:,:,184) = 5.e-13 * exp_fac(:,:)
      rate(:,:,146) = 4.13e-12 * exp( 452. * itemp(:,:) )
      rate(:,:,147) = 7.52e-16 * exp( -1521. * itemp(:,:) )
      exp_fac(:,:) = exp( 175. * itemp(:,:) )
      rate(:,:,148) = 1.86e-11 * exp_fac(:,:)
      rate(:,:,180) = 1.86e-11 * exp_fac(:,:)
      rate(:,:,149) = 4.4e-15 * exp( -2500. * itemp(:,:) )
      exp_fac(:,:) = exp( 360. * itemp(:,:) )
      rate(:,:,150) = 2.7e-12 * exp_fac(:,:)
      rate(:,:,151) = 1.3e-13 * exp_fac(:,:)
      rate(:,:,157) = 5.3e-12 * exp_fac(:,:)
      rate(:,:,173) = 2.7e-12 * exp_fac(:,:)
      rate(:,:,181) = 2.7e-12 * exp_fac(:,:)
      exp_fac(:,:) = exp( 530. * itemp(:,:) )
      rate(:,:,161) = 4.6e-12 * exp_fac(:,:)
      rate(:,:,162) = 2.3e-12 * exp_fac(:,:)
      rate(:,:,165) = 1.2e-11 * exp( 444. * itemp(:,:) )
      rate(:,:,166) = 1.e-15 * exp( -732. * itemp(:,:) )
      rate(:,:,167) = 1.2e-12 * exp( 490. * itemp(:,:) )
      rate(:,:,172) = 3.03e-12 * exp( -446. * itemp(:,:) )
      rate(:,:,176) = 8.4e-13 * exp( 830. * itemp(:,:) )
      exp_fac(:,:) = exp( -1860. * itemp(:,:) )
      rate(:,:,177) = 1.4e-12 * exp_fac(:,:)
      rate(:,:,179) = 1.4e-12 * exp_fac(:,:)
      rate(:,:,185) = 1.3e-12 * exp( 640. * itemp(:,:) )
      rate(:,:,186) = 1.90e-12 * exp( 190. * itemp(:,:) )
      rate(:,:,188) = 7.3e-12 * exp( -620. * itemp(:,:) )
      rate(:,:,189) = 6.9e-12 * exp( -230. * itemp(:,:) )
      rate(:,:,197) = 9.6e-12 * exp( -234. * itemp(:,:) )
      rate(:,:,199) = 1.9e-13 * exp( 520. * itemp(:,:) )
      rate(:,:,200) = 1.7e-12 * exp( -710. * itemp(:,:) )

      itemp(:,:) = 300. * itemp(:,:)

      ko(:,:) = 6.9e-31 * itemp(:,:)**1.
      kinf(:,:) = 2.6e-11
      call jpl( rate(1,1,55), m, .6, ko, kinf, plnplv )

      ko(:,:) = 2.e-30 * itemp(:,:)**4.4
      kinf(:,:) = 1.4e-12 * itemp(:,:)**.7
      call jpl( rate(1,1,63), m, .6, ko, kinf, plnplv )

      ko(:,:) = 2.0e-30 * itemp(:,:)**3.0
      kinf(:,:) = 2.5e-11
      call jpl( rate(1,1,65), m, .6, ko, kinf, plnplv )

      ko(:,:) = 1.8e-31 * itemp(:,:)**3.2
      kinf(:,:) = 4.7e-12 * itemp(:,:)**1.4
      call jpl( rate(1,1,68), m, .6, ko, kinf, plnplv )

      ko(:,:) = 1.e-28 * itemp(:,:)**.8
      kinf(:,:) = 8.8e-12
      call jpl( rate(1,1,84), m, .6, ko, kinf, plnplv )

      ko(:,:) = 8.e-27 * itemp(:,:)**3.5
      kinf(:,:) = 3.e-11
      call jpl( rate(1,1,95), m, .5, ko, kinf, plnplv )

      ko(:,:) = 8.5e-29 * itemp(:,:)**6.5
      kinf(:,:) = 1.1e-11 * itemp(:,:)
      call jpl( rate(1,1,104), m, .6, ko, kinf, plnplv )

      ko(:,:) = 8.e-27 * itemp(:,:)**3.5
      kinf(:,:) = 3.e-11
      call jpl( rate(1,1,190), m, .5, ko, kinf, plnplv )

      end subroutine setrxt

      end module mo_setrxt
