!-----------------------------------------------------------------------------
!    COPYRIGHT (C) 2013-2014 NDACC/IRWG
!    THIS FILE IS PART OF SFIT.
!
!    SFIT IS FREE SOFTWARE: YOU CAN REDISTRIBUTE IT AND/OR MODIFY
!    IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
!    THE FREE SOFTWARE FOUNDATION, EITHER VERSION 3 OF THE LICENSE, OR
!    ANY LATER VERSION.
!
!    SFIT IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
!    BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
!    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
!    GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
!    YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
!    ALONG WITH SFIT.  IF NOT, SEE <HTTP://WWW.GNU.ORG/LICENSES/>
!-----------------------------------------------------------------------------

   MODULE TIPS

! NOV 2018  UPDATED FROM HITRAN RELEASE VERSION TIPS_2009 / TIPS_2011 to TIPS_2017

   USE PARAMS, ONLY:  DOUBLE
   IMPLICIT NONE
   !IMPLICIT DOUBLE PRECISION (a-h,o-z)

   LOGICAL                                 :: USE_TIPS = .FALSE. ! SWITCH OFF TIPS AS DEFAULT
   INTEGER, PARAMETER                      :: NMOL = 53, Max_ISO = 20, NT = 4510
   CHARACTER (LEN=7), DIMENSION( 0:NMOL )  :: MOLID ! 2017 is char*6
   INTEGER, DIMENSION( NMOL, MAX_ISO)      :: ISO82
   REAL(8), DIMENSION( NMOL, Max_ISO )     :: TMAX
   INTEGER, PRIVATE                        :: I, J, NDAT

   REAL(DOUBLE)                            :: DT, TMI, EPS, TDAT

! (I don't think this is used at all)
   INTEGER, PARAMETER, DIMENSION( NMOL )   :: ISONM  = (/ &
!    The number of isotopes for a particular molecule:
!  #    1    2   3    4   5    6   7
!     H2O, CO2, O3, N2O, CO, CH4, O2,
        9,  13, 18,   5,  9,  4,  6, &

!  #    8    9   10   11    12  13  14   15   16  17
!      NO, SO2, NO2, NH3, HNO3, OH, HF, HCl, HBr, HI,
        3,   2,   1,   2,    2,  3,  2,   4,   4,  2, &

!  #   18   19    20    21  22   23     24    25    26    27   28
!     ClO, OCS, H2CO, HOCl, N2, HCN, CH3Cl, H2O2, C2H2, C2H6, PH3
        2,   5,    3,    2,  3,   3,     2,    1,    3,    2,   1, &

!  #    29,  30   31     32   33 34      35    36    37    38
!     COF2, SF6, H2S, HCOOH, HO2, O, ClONO2,  NO+, HOBr, C2H4
         2,   1,   3,     1,   1, 1,      2,    1,    2,    2, &

!  #     39     40     41   42    43    44    45    46   47    48   49
!     CH3OH, CH3Br, CH3CN, CF4, C4H2, HC3N    H2    CS  SO3  C2N2   COCl2
         1,      2,     4,   1,    1,    6,    2,    4,   1,    2,   2, &

!  #    50   51   52   53
!       SO C3H4  CH3  CS2
         3,   1,   1,   4/)

! (I don't think this is used at all)
! Molecule names (HITRAN order + some)
      DATA (MOLID(I),I=0,NMOL)/ '   All', &
!           1        2        3        4        5        6        7
      '   H2O','   CO2','    O3','   N2O','    CO','   CH4','    O2', &
!           8        9       10       11       12       13       14
      '    NO','   SO2','   NO2','   NH3','  HNO3','    OH','    HF', &
!          15       16       17       18       19       20       21
      '   HCl','   HBr','    HI','   ClO','   OCS','  H2CO','  HOCl', &
!          22       23       24       25       26       27       28
      '    N2','   HCN',' CH3Cl','  H2O2','  C2H2','  C2H6','   PH3', &
!          29       30       31       32       33       34       35
      '  COF2','   SF6','   H2S',' HCOOH','   HO2','     O','ClONO2',&
!          36       37       38       39       40       41       42
      '   NO+','  HOBr','  C2H4',' CH3OH',' CH3Br',' CH3CN','   CF4', &
!          43       44       45       46       47       48       49
      '  C4H2','  HC3N','    H2','    CS','   SO3','  C2N2',' COCl2', &
!          50       51       52       53       54       55       56
      '    SO','  C3H4','   CH3','   CS2'/

!! (I don't think this is used at all)
! SET HITRAN ISOTOPE ID VALUES
! 1     H2O
      DATA (ISO82(1,J),J=1,9)/161,181,171,162,182,172,262,282,272/
! 2     CO2
      DATA (ISO82(2,J),J=1,13)/626,636,628,627,638,637,828,728,727,838,837,737,646/
! 3     O3
      DATA (ISO82(3,J),J=1,18)/666,668,686,667,676,886,868,678,768,786,776,767,888,887,878,778,787,777/
! 4     N2O
      DATA (ISO82(4,J),J=1,5)/446,456,546,448,447/
! 5     CO,
      DATA (ISO82(5,J),J=1,9)/26,36,28,27,38,37,46,48,47/
! 6    CH4
      DATA (ISO82(6,J),J=1,4)/211,311,212,312/
! 7     O2
      DATA (ISO82(7,J),J=1,6)/66,68,67,88,87,77/
! 8     NO
      DATA (ISO82(8,J),J=1,3)/46,56,48/
! 9     SO2
      DATA (ISO82(9,J),J=1,2)/626,646/
!10    NO2
      DATA (ISO82(10,J),J=1,1)/646/
!11     NH3
      DATA (ISO82(11,J),J=1,2)/4111,5111/
!12     HNO3
      DATA (ISO82(12,J),J=1,2)/146,156/
!13     OH
      DATA (ISO82(13,J),J=1,3)/61,81,62/
!14     HF
      DATA (ISO82(14,J),J=1,2)/19,29/
!15     HCl
      DATA (ISO82(15,J),J=1,4)/15,17,25,27/
!16     HBr
      DATA (ISO82(16,J),J=1,4)/19,11,29,21/
!17     HI
      DATA (ISO82(17,J),J=1,2)/17,27/
!18     ClO,
      DATA (ISO82(18,J),J=1,2)/56,76/
!19     OCS
      DATA (ISO82(19,J),J=1,5)/622,624,632,623,822/
!20     H2CO
      DATA (ISO82(20,J),J=1,3)/126,136,128/
!21     HOCl,
      DATA (ISO82(21,J),J=1,2)/165,167/
!22     N2
      DATA (ISO82(22,J),J=1,3)/44,45,55/
!23     HCN
      DATA (ISO82(23,J),J=1,3)/124,134,125/
!24     CH3Cl
      DATA (ISO82(24,J),J=1,2)/215,217/
!25     H2O2
      DATA (ISO82(25,J),J=1,1)/1661/
!26     C2H2
      DATA (ISO82(26,J),J=1,3)/1221,1231,1222/
!27    C2H6
      DATA (ISO82(27,J),J=1,2)/1221,1231/
!28     PH3
      DATA (ISO82(28,J),J=1,1)/1111/
!29   COF2
      DATA (ISO82(29,J),J=1,2)/269,369/
!30     SF6
      DATA (ISO82(30,J),J=1,1)/29/
!31     H2S
      DATA (ISO82(31,J),J=1,3)/121,141,131/
!32     HCOOH
      DATA (ISO82(32,J),J=1,1)/126/
!33     HO2
      DATA (ISO82(33,J),J=1,1)/166/
!34     O
      DATA (ISO82(34,J),J=1,1)/6/
!35     ClONO2
      DATA (ISO82(35,J),J=1,2)/5646,7646/
!36     NO+
      DATA (ISO82(36,J),J=1,1)/46/
!37    HOBr
      DATA (ISO82(37,J),J=1,2)/169,161/
!38     C2H4
      DATA (ISO82(38,J),J=1,2)/221,231/
!39     CH3OH
      DATA (ISO82(39,J),J=1,1)/2161/
!40     CH3Br
      DATA (ISO82(40,J),J=1,2)/219,211/
!41     CH3CN
      DATA (ISO82(41,J),J=1,4)/2124,3124,2134,3134/
!42     CF4
      DATA (ISO82(42,J),J=1,1)/29/
!43     C4H2
      DATA (ISO82(43,J),J=1,1)/2211/
!44     HC3N
      DATA (ISO82(44,J),J=1,6)/12224,12225,12234,12324,13224,22224/
!45     H2
      DATA (ISO82(45,J),J=1,2)/11,12/
!46     CS
      DATA (ISO82(46,J),J=1,4)/22,24,32,23/
!47     SO3
      DATA (ISO82(47,J),J=1,1)/26/
!48     C2N2
      DATA (ISO82(48,J),J=1,2)/4224,5225/
!49     COCl2
      DATA (ISO82(49,J),J=1,2)/2655,2657/
!50     SO
      DATA (ISO82(50,J),J=1,3)/26,46,28/
!51     C3H4
      DATA (ISO82(51,J),J=1,1)/1221/
!52     CH3
      DATA (ISO82(52,J),J=1,1)/2111/
!53       CS2
      DATA (ISO82(53,J),J=1,4)/222,224,223,232/

!
!...max temperatures for isotopologues
      data (Tmax(1,I),I=1,9)/5000.,5000.,5000.,5000.,5000.,5000.,6000.,6000.,6000./  ! H2O
      data (Tmax(2,I),I=1,13)/5000.,5000.,3500.,3500.,3500.,3500.,5000.,3500.,5000.,5000.,3500.,5000.,5000./  ! CO2
      data (Tmax(3,I),I=1,18)/3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500.,3500./  ! O3
      data (Tmax(4,I),I=1,5)/5000.,3500.,3500.,3500.,3500./  ! N2O
      data (Tmax(5,I),I=1,9)/9000.,9000.,9000.,9000.,9000.,9000.,9000.,9000.,9000./  ! CO
      data (Tmax(6,I),I=1,4)/3500.,3500.,4500.,3500./ ! CH4
      data (Tmax(7,I),I=1,6)/7500.,7500.,7500.,7500.,7500.,7500./  ! O2
      data (Tmax(8,I),I=1,3)/3500.,3500.,3500./  ! NO
      data (Tmax(9,I),I=1,2)/3500.,3500./  ! SO2
      data Tmax(10,1)/3500./  ! NO2
      data (Tmax(11,I),I=1,2)/6000.,6000./  ! NH3
      data (Tmax(12,I),I=1,2)/3500.,3500./  ! HNO3
      data (Tmax(13,I),I=1,3)/9000.,3500.,3500./  ! OH
      data (Tmax(14,I),I=1,2)/6000.,6000./  ! HF
      data (Tmax(15,I),I=1,4)/6000.,6000.,6000.,4000./  ! HCl
      data (Tmax(16,I),I=1,4)/6000.,6000.,6000.,6000./  ! HBr
      data (Tmax(17,I),I=1,2)/6000.,6000./  ! HI
      data (Tmax(18,I),I=1,2)/3500.,3500./  ! ClO
      data (Tmax(19,I),I=1,5)/3500.,3500.,3500.,3500.,3500./  ! OCS
      data (Tmax(20,I),I=1,3)/3500.,3500.,3500./  ! H2CO
      data (Tmax(21,I),I=1,2)/3500.,3500./  ! HOCl
      data (Tmax(22,I),I=1,3)/9000.,9000.,9000./  ! N2
      data (Tmax(23,I),I=1,3)/3500.,3500.,3500./  ! HCN
      data (Tmax(24,I),I=1,2)/3500.,3500./  ! CH3Cl
      data Tmax(25,1)/6000./  ! H2O2
      data (Tmax(26,I),I=1,3)/5000.,3500.,3500./  ! C2H2
      data (Tmax(27,I),I=1,2)/3500.,3500./  ! C2H6
      data Tmax(28,1)/4500./  ! PH3
      data (Tmax(29,I),I=1,2)/3500.,3500./  ! COF2
      data Tmax(30,1)/3500./  ! SF6
      data (Tmax(31,I),I=1,3)/4000.,3500.,3500./  ! H2S
      data Tmax(32,1)/3500./  ! HCOOH
      data Tmax(33,1)/3500./  ! HO2
!     O atom do data
      data Tmax(34,1)/10./  ! HO2
      data (Tmax(35,I),I=1,2)/3500.,3500./  ! ClONO2
      data Tmax(36,1)/3500./  ! NO+
      data (Tmax(37,I),I=1,2)/3500.,3500./  ! HOBr
      data (Tmax(38,I),I=1,2)/3500.,3500./  ! C2H4
      data Tmax(39,1)/3500./  ! CH3OH
      data (Tmax(40,I),I=1,2)/3500.,3500./  ! CH3Br
      data (Tmax(41,I),I=1,4)/3500.,3500.,3500.,3500./  ! CH3CN
      data Tmax(42,1)/3010./  ! CF4
      data Tmax(43,1)/3500./  ! C4H2
      data (Tmax(44,I),I=1,6)/3500.,3500.,3500.,3500.,3500.,3500./  ! HC3N
      data (Tmax(45,I),I=1,2)/6000.,6000./  ! H2
      data (Tmax(46,I),I=1,4)/3500.,3500.,3500.,3500./  ! CS
      data Tmax(47,1)/3500./  ! SO3
      data (Tmax(48,I),I=1,2)/3500.,3500./  ! C2N2
      data (Tmax(49,I),I=1,2)/5000.,5000./  ! COCl2
      data (Tmax(50,I),I=1,3)/3500.,3500.,3500./  ! SO
      data Tmax(51,1)/3500./  ! C3H4
      data Tmax(52,1)/3500./  ! CH3
      data (Tmax(53,I),I=1,4)/3500.,3500.,3500.,3500./  ! CS2

   CONTAINS

!***********************

   SUBROUTINE BD_TIPS_2017( MOL, Temp, ISO, gi, QT)

!***********************
!
!       MOL,           HITRAN molecule number
!       Temp,          temperature in K
!       ISO,           isotopomer index
!       gi,            state independent degeneracy factor
!       QT)            total internal partition sum
!
!    Subroutine BD_TIPS_2017 written by R.R. Gamache
!
!
!...date last changed 27         June, 2017
!
! MIT License
!
! Copyright (c) [2016] [Robert Gamache]
!
! Permission is hereby granted, free of charge, to any person obtaining a copy
! of this software and associated documentation files (the "Software"), to deal
! in the Software without restriction, including without limitation the rights
! to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
! copies of the Software, and to permit persons to whom the Software is
! furnished to do so, subject to the following conditions:
!
! The above copyright notice and this permission notice shall be included in all
! copies or substantial portions of the Software.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
! IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
! FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
! AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
! LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
! OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
! SOFTWARE.
!
!
!  --  UPDATES  --
!    27 June, 2017 too many to list - see publication
!    Gamache et al., Total internal partition sums for molecular isotopologues on the HITRAN
!    database and beyond, JQSRT, 203, 70-87 2017.
!  --  UPDATES  --
!    7 May 2104 addition of 737 and 646 of CO2,
!    16 April 2104 corrected and greatly improved Q(T)s for O2 including 88, 78, and 77 isotopologues,
!    18 March 2011 addition of molecules 43-51, 838,837 of CO2,
!     1222 of C2H2, CH3D, 13CH3D, 13C12CH6,CH3Br
!    19 July 2010 correction of the sign of D in CO  constants
!    13 July 2010 addition of several new species/isotopologues: ^13C^18O2,
!       ^18O^13C^17O, ^13CH3D,  ^13C12CH2, CF4: note a number of the block
!       data codes were updated as well
!    15 May 2008 Dijon Q(T) values for CH4
!    18 December 2003 better vibrational fundamentals for PH3
!
!    This program calculates the total internal
!    partition sum (TIPS) for a given molecule, isotopologue, and
!    temperature.  Current limitations are the molecular species on the
!    HITRAN molecular database plus a few additional  molecules and the temperature range 1 - 3500 K.
!
!...This program calculates the TIPS by 4-point LaaGrange interpolation
!
!..  JQSRT - 82, 401-412, 2003
!..  J. Fischer(a) R.R. Gamache(a&), A. Goldman(b), L.S. Rothman(c), and A. Perrin(d)
!..
!..  (a)  Department of Environmental, Earth, and Atmospheric Sciences,
!..       University of Massachusetts Lowell, Lowell, MA 01854, U.S.A.
!..
!..  (b)  Department of Physics, University of Denver, Denver, CO 80208, U.S.A.
!..
!..  (c)  Harvard-Smithsonian Center for Astrophysics, 60 Garden St, Cambridge, MA 02138 USA
!..
!..  (d)  Laboratoire de Photophysique MolÈculaire, UniversitÈ Paris Sud, 91405 Orsay, FRANCE
!..
!..  &  Corresponding author. Email address: Robert_Gamache@uml.edu
!..  Abstract
!..        Total internal partition sums (TIPS) are calculated for all molecular species in
!..  the 2000 HITRAN database.  In addition, the TIPS for 13 other isotopomers/isotopologues
!..  of ozone and carbon dioxide are presented.  The calculations address the corrections
!..  suggested by Goldman et al. (JQSRT 2000;66:55-86).  The calculations consider the
!..  temperature range 70-3000 K to be applicable to a variety of remote sensing needs.
!..  The method of calculation for each molecular species is stated and comparisons with
!..  data from the literature are discussed.  A new method of recall for the partition sums,
!..  Lagrange 4-point interpolation, is developed.  This method, unlike previous versions of
!..  the TIPS code, allows all molecular species to be considered.
!

      USE MOLCPARAM

      INTEGER, INTENT(IN) :: MOL  ! HITRAN MOLECULE NUMBER
      INTEGER       :: ISO        ! ISOTOPOMER INDEX
      REAL(DOUBLE)  :: TEMP       ! TEMPERATURE IN K
      REAL(DOUBLE)  :: GI         ! STATE INDEPENDENT DEGENERACY FACTOR
      REAL(DOUBLE)  :: QT         ! TOTAL INTERNAL PARTITION SUM

      INTEGER           :: I, IT
      REAL(DOUBLE)                            :: TDAT
!++
      !INCLUDE 'Species_2016.cmn'
!++

!++
      !INCLUDE 'Isotops.cmn'
      !INCLUDE 'MOLEC.cmn'
!++:  bd-QT
      COMMON/Temperatures/tdat(NT)

! --- CHECK WE DON'T OVERRUN ISO VALUE IN QOFT ARRAY
!     NOTE USING SFIT ISO NUMBERS

   if( iso .GT. ISONM(mol) )then !NHIISO
      print *, 'TIPS : REQUESTED ISO : ', ISO, ' FOR MOLECULE : ', MOL, ' OUT OF RANGE IN TIPS : ', NHIISO(MOL)
      print *, 'Turn TIPS off (fw.tips = F) and continue'
      stop
   endif

!...fill T array
      I = 0
      do IT = 1,20
        I = I+1
        Tdat(I) = IT*1.
      enddo
      do IT = 22,9000,2
        I = I+1
        Tdat(I) = IT*1.
      enddo
!
!     GO TO PARTICULAR MOLECULE:
!
   SELECT CASE (MOL)
   CASE (1)
      CALL QT_H2O (TEMP, ISO, GI, QT)
   CASE (2)
      CALL QT_CO2 (TEMP, ISO, GI, QT)
   CASE (3)
      CALL QT_O3 (TEMP, ISO, GI, QT)
   CASE (4)
      CALL QT_N2O (TEMP, ISO, GI, QT)
   CASE (5)
      CALL QT_CO (TEMP, ISO, GI, QT)
   CASE (6)
      CALL QT_CH4 (TEMP, ISO, GI, QT)
   CASE (7)
      CALL QT_O2 (TEMP, ISO, GI, QT)
   CASE (8)
      CALL QT_NO (TEMP, ISO, GI, QT)
   CASE (9)
      CALL QT_SO2 (TEMP, ISO, GI, QT)
   CASE (10)
      CALL QT_NO2 (TEMP, ISO, GI, QT)
   CASE (11)
      CALL QT_NH3 (TEMP, ISO, GI, QT)
   CASE (12)
      CALL QT_HNO3 (TEMP, ISO, GI, QT)
   CASE (13)
      CALL QT_OH (TEMP, ISO, GI, QT)
   CASE (14)
      CALL QT_HF (TEMP, ISO, GI, QT)
   CASE (15)
      CALL QT_HCL (TEMP, ISO, GI, QT)
   CASE (16)
      CALL QT_HBR (TEMP, ISO, GI, QT)
   CASE (17)
      CALL QT_HI (TEMP, ISO, GI, QT)
   CASE (18)
      CALL QT_CLO (TEMP, ISO, GI, QT)
   CASE (19)
      CALL QT_OCS (TEMP, ISO, GI, QT)
   CASE (20)
      CALL QT_H2CO (TEMP, ISO, GI, QT)
   CASE (21)
      CALL QT_HOCL (TEMP, ISO, GI, QT)

! --- UP TO HITRAN # 21 SFIT & HITRAN ARE THE SAME
!     THIS SUBROUTINE IS CALLED WITH SFIT MOL ID'S
!     SO NOW WE CALL THE GAS SUBROUTINE ASSOCIATED WITH THE SFIT MOL ID

   CASE (22)
      CALL QT_HO2 (TEMP, ISO, GI, QT)
   CASE (23)
      CALL QT_H2O2 (TEMP, ISO, GI, QT)
   CASE (27)
      CALL QT_CLONO2 (TEMP, ISO, GI, QT)
   CASE (28)
      CALL QT_HCN (TEMP, ISO, GI, QT)
   CASE (30)
      CALL QT_CH3CL (TEMP, ISO, GI, QT)
   CASE (31)
      CALL QT_CF4(TEMP,ISO,GI,QT)
   CASE (36)
      CALL QT_COF2 (TEMP, ISO, GI, QT)
   CASE (38)
      CALL QT_C2H6 (TEMP, ISO, GI, QT)
   CASE (39)
      CALL QT_C2H4 (TEMP, ISO, GI, QT)
   CASE (40)
      CALL QT_C2H2 (TEMP, ISO, GI, QT)
   CASE (41)
      CALL QT_N2 (TEMP, ISO, GI, QT)
   CASE (44)
      CALL QT_CH3BR(TEMP,ISO,GI,QT)
   CASE (46)
      CALL QT_HCOOH (TEMP, ISO, GI, QT)
   CASE (47)
      CALL QT_H2S (TEMP, ISO, GI, QT)
   CASE (49) ! O2CIA -----NEED TO CHECK
      CALL QT_O2 (TEMP, ISO, GI, QT)
   CASE (50)
      CALL QT_SF6 (TEMP, ISO, GI, QT)
   CASE (52) ! N2CIA -----NEED TO CHECK
      CALL QT_N2 (TEMP, ISO, GI, QT)
   CASE (64)
      CALL QT_CH3OH (TEMP, ISO, GI, QT)
   CASE (69)
      CALL QT_CH3CN(TEMP,ISO,GI,QT)

! --- SFIT DOES NOT USE THESE SPECIES...YET

      !CALL QT_O( T, ISO, GSI, QT )
      !CALL QT_HC3N(TEMP,ISO,GI,QT)
      !CALL QT_CH3(TEMP,ISO,GI,QT)
      !CALL QT_PH3 (TEMP, ISO, GI, QT)
      !CALL QT_H2(TEMP,ISO,GI,QT)
      !CALL QT_CS(TEMP,ISO,GI,QT)
      !CALL QT_NOp (TEMP, ISO, GI, QT)
      !CALL QT_HOBR (TEMP, ISO, GI, QT)
      !CALL QT_C4H2(TEMP,ISO,GI,QT)
      !CALL QT_C2N2(TEMP,ISO,GI,QT)
      !CALL QT_SO(TEMP,ISO,GI,QT)
      !CALL QT_C3H4(TEMP,ISO,GI,QT)
      !CALL QT_CS2(TEMP,ISO,GI,QT)
      !CALL QT_SO3(TEMP,ISO,GI,QT)

   CASE DEFAULT
!        ... RETURN 0S IF ANY OTHER MOLECULE
      GI = 0
      QT = 0.

   END SELECT

   RETURN
   END


!**************************************
      SUBROUTINE CLEAR
!**************************************
      implicit DOUBLE PRECISION (a-h,o-z)
!
      DO 10 I = 1,24
       WRITE (*,'(1X)')
   10 CONTINUE
      RETURN
      END

!
!     *****************
      Subroutine QT_H2O( T, ISO, GSI, QT )

      USE params, ONLY:  DOUBLE
      IMPLICIT NONE
      INTEGER , INTENT(IN)       :: ISO ! isotope code (HITRAN INDEX)
      REAL(DOUBLE)               :: T   ! temperature in K
      REAL(DOUBLE) , INTENT(OUT) :: GSI ! state independent nuclear degeneracyfactor
      REAL(DOUBLE)               :: QT  ! Total Internal Partition Function
      INTEGER                    :: I, J, NDAT
      REAL(DOUBLE)                             :: TDAT
      REAL(DOUBLE), DIMENSION( ISONM(1) )     :: XGJ
      REAL(DOUBLE), DIMENSION( ISONM(1), NT ) :: QOFT
      REAL(DOUBLE), DIMENSION( NT )           :: Q
      REAL(DOUBLE), DIMENSION( Max_ISO )      :: TMX

      COMMON/Temperatures/tdat(NT)

      data (Tmx(I),I=1,9)/5000.,5000.,5000.,5000.,5000.,5000.,6000.,6000.,6000./
      data xgj/ 1.,1.,6.,6.,6.,36.,1.,1.,6./
!...      H2O
!...        --       161
      data (QofT( 1,J),J=1,2408)/ 1.0000E+00, 1.0000E+00, 1.0001E+00, 1.0017E+00, 1.0097E+00, 1.0307E+00, 1.0706E+00, 1.1329E+00, &
       1.2189E+00, 1.3284E+00, 1.4601E+00, 1.6123E+00, 1.7830E+00, 1.9702E+00, 2.1721E+00, 2.3870E+00, 2.6134E+00, 2.8499E+00, &
       3.0954E+00, 3.3489E+00, 3.8767E+00, 4.4281E+00, 4.9993E+00, 5.5878E+00, 6.1918E+00, 6.8103E+00, 7.4424E+00, 8.0877E+00, &
       8.7459E+00, 9.4170E+00, 1.0101E+01, 1.0797E+01, 1.1506E+01, 1.2227E+01, 1.2962E+01, 1.3708E+01, 1.4467E+01, 1.5239E+01, &
       1.6023E+01, 1.6819E+01, 1.7627E+01, 1.8447E+01, 1.9280E+01, 2.0124E+01, 2.0980E+01, 2.1847E+01, 2.2726E+01, 2.3617E+01, &
       2.4519E+01, 2.5432E+01, 2.6356E+01, 2.7291E+01, 2.8237E+01, 2.9194E+01, 3.0161E+01, 3.1139E+01, 3.2127E+01, 3.3125E+01, &
       3.4134E+01, 3.5153E+01, 3.6182E+01, 3.7221E+01, 3.8270E+01, 3.9328E+01, 4.0396E+01, 4.1474E+01, 4.2561E+01, 4.3658E+01, &
       4.4764E+01, 4.5880E+01, 4.7004E+01, 4.8138E+01, 4.9281E+01, 5.0432E+01, 5.1593E+01, 5.2763E+01, 5.3941E+01, 5.5128E+01, &
       5.6324E+01, 5.7528E+01, 5.8741E+01, 5.9963E+01, 6.1193E+01, 6.2431E+01, 6.3678E+01, 6.4932E+01, 6.6196E+01, 6.7467E+01, &
       6.8746E+01, 7.0034E+01, 7.1330E+01, 7.2633E+01, 7.3945E+01, 7.5264E+01, 7.6591E+01, 7.7926E+01, 7.9269E+01, 8.0620E+01, &
       8.1978E+01, 8.3344E+01, 8.4718E+01, 8.6099E+01, 8.7487E+01, 8.8883E+01, 9.0287E+01, 9.1698E+01, 9.3116E+01, 9.4542E+01, &
       9.5975E+01, 9.7415E+01, 9.8863E+01, 1.0032E+02, 1.0178E+02, 1.0325E+02, 1.0472E+02, 1.0621E+02, 1.0770E+02, 1.0920E+02, &
       1.1070E+02, 1.1221E+02, 1.1373E+02, 1.1525E+02, 1.1679E+02, 1.1833E+02, 1.1987E+02, 1.2142E+02, 1.2298E+02, 1.2455E+02, &
       1.2612E+02, 1.2770E+02, 1.2929E+02, 1.3088E+02, 1.3248E+02, 1.3409E+02, 1.3570E+02, 1.3732E+02, 1.3895E+02, 1.4058E+02, &
       1.4222E+02, 1.4386E+02, 1.4552E+02, 1.4717E+02, 1.4884E+02, 1.5051E+02, 1.5219E+02, 1.5387E+02, 1.5556E+02, 1.5726E+02, &
       1.5896E+02, 1.6067E+02, 1.6239E+02, 1.6411E+02, 1.6584E+02, 1.6758E+02, 1.6932E+02, 1.7107E+02, 1.7282E+02, 1.7458E+02, &
       1.7635E+02, 1.7812E+02, 1.7990E+02, 1.8168E+02, 1.8348E+02, 1.8527E+02, 1.8708E+02, 1.8889E+02, 1.9070E+02, 1.9253E+02, &
       1.9435E+02, 1.9619E+02, 1.9803E+02, 1.9988E+02, 2.0173E+02, 2.0359E+02, 2.0545E+02, 2.0733E+02, 2.0920E+02, 2.1109E+02, &
       2.1298E+02, 2.1487E+02, 2.1677E+02, 2.1868E+02, 2.2060E+02, 2.2252E+02, 2.2444E+02, 2.2637E+02, 2.2831E+02, 2.3026E+02, &
       2.3221E+02, 2.3416E+02, 2.3613E+02, 2.3810E+02, 2.4007E+02, 2.4205E+02, 2.4404E+02, 2.4603E+02, 2.4803E+02, 2.5003E+02, &
       2.5205E+02, 2.5406E+02, 2.5609E+02, 2.5812E+02, 2.6015E+02, 2.6219E+02, 2.6424E+02, 2.6629E+02, 2.6835E+02, 2.7042E+02, &
       2.7249E+02, 2.7457E+02, 2.7665E+02, 2.7874E+02, 2.8084E+02, 2.8294E+02, 2.8505E+02, 2.8716E+02, 2.8929E+02, 2.9141E+02, &
       2.9354E+02, 2.9568E+02, 2.9783E+02, 2.9998E+02, 3.0214E+02, 3.0430E+02, 3.0647E+02, 3.0865E+02, 3.1083E+02, 3.1302E+02, &
       3.1521E+02, 3.1741E+02, 3.1962E+02, 3.2183E+02, 3.2405E+02, 3.2627E+02, 3.2851E+02, 3.3074E+02, 3.3299E+02, 3.3524E+02, &
       3.3749E+02, 3.3976E+02, 3.4203E+02, 3.4430E+02, 3.4658E+02, 3.4887E+02, 3.5116E+02, 3.5346E+02, 3.5577E+02, 3.5808E+02, &
       3.6040E+02, 3.6273E+02, 3.6506E+02, 3.6740E+02, 3.6974E+02, 3.7209E+02, 3.7445E+02, 3.7681E+02, 3.7918E+02, 3.8156E+02, &
       3.8394E+02, 3.8633E+02, 3.8872E+02, 3.9113E+02, 3.9353E+02, 3.9595E+02, 3.9837E+02, 4.0080E+02, 4.0323E+02, 4.0567E+02, &
       4.0812E+02, 4.1057E+02, 4.1303E+02, 4.1550E+02, 4.1797E+02, 4.2045E+02, 4.2294E+02, 4.2543E+02, 4.2793E+02, 4.3043E+02, &
       4.3295E+02, 4.3546E+02, 4.3799E+02, 4.4052E+02, 4.4306E+02, 4.4561E+02, 4.4816E+02, 4.5072E+02, 4.5328E+02, 4.5585E+02, &
       4.5843E+02, 4.6102E+02, 4.6361E+02, 4.6621E+02, 4.6881E+02, 4.7143E+02, 4.7405E+02, 4.7667E+02, 4.7930E+02, 4.8194E+02, &
       4.8459E+02, 4.8724E+02, 4.8990E+02, 4.9257E+02, 4.9524E+02, 4.9792E+02, 5.0061E+02, 5.0331E+02, 5.0601E+02, 5.0871E+02, &
       5.1143E+02, 5.1415E+02, 5.1688E+02, 5.1962E+02, 5.2236E+02, 5.2511E+02, 5.2787E+02, 5.3063E+02, 5.3340E+02, 5.3618E+02, &
       5.3896E+02, 5.4175E+02, 5.4455E+02, 5.4736E+02, 5.5017E+02, 5.5299E+02, 5.5582E+02, 5.5866E+02, 5.6150E+02, 5.6435E+02, &
       5.6720E+02, 5.7007E+02, 5.7294E+02, 5.7581E+02, 5.7870E+02, 5.8159E+02, 5.8449E+02, 5.8740E+02, 5.9031E+02, 5.9323E+02, &
       5.9616E+02, 5.9910E+02, 6.0204E+02, 6.0499E+02, 6.0795E+02, 6.1091E+02, 6.1389E+02, 6.1687E+02, 6.1986E+02, 6.2285E+02, &
       6.2585E+02, 6.2886E+02, 6.3188E+02, 6.3491E+02, 6.3794E+02, 6.4098E+02, 6.4403E+02, 6.4708E+02, 6.5014E+02, 6.5322E+02, &
       6.5629E+02, 6.5938E+02, 6.6247E+02, 6.6557E+02, 6.6868E+02, 6.7180E+02, 6.7492E+02, 6.7805E+02, 6.8119E+02, 6.8434E+02, &
       6.8749E+02, 6.9066E+02, 6.9383E+02, 6.9701E+02, 7.0019E+02, 7.0339E+02, 7.0659E+02, 7.0980E+02, 7.1301E+02, 7.1624E+02, &
       7.1947E+02, 7.2271E+02, 7.2596E+02, 7.2922E+02, 7.3249E+02, 7.3576E+02, 7.3904E+02, 7.4233E+02, 7.4563E+02, 7.4893E+02, &
       7.5224E+02, 7.5557E+02, 7.5890E+02, 7.6223E+02, 7.6558E+02, 7.6893E+02, 7.7229E+02, 7.7566E+02, 7.7904E+02, 7.8243E+02, &
       7.8582E+02, 7.8923E+02, 7.9264E+02, 7.9606E+02, 7.9949E+02, 8.0292E+02, 8.0637E+02, 8.0982E+02, 8.1328E+02, 8.1675E+02, &
       8.2023E+02, 8.2372E+02, 8.2721E+02, 8.3071E+02, 8.3423E+02, 8.3775E+02, 8.4128E+02, 8.4481E+02, 8.4836E+02, 8.5191E+02, &
       8.5548E+02, 8.5905E+02, 8.6263E+02, 8.6622E+02, 8.6982E+02, 8.7342E+02, 8.7704E+02, 8.8066E+02, 8.8429E+02, 8.8793E+02, &
       8.9158E+02, 8.9524E+02, 8.9891E+02, 9.0259E+02, 9.0627E+02, 9.0997E+02, 9.1367E+02, 9.1738E+02, 9.2110E+02, 9.2483E+02, &
       9.2857E+02, 9.3232E+02, 9.3607E+02, 9.3984E+02, 9.4361E+02, 9.4740E+02, 9.5119E+02, 9.5499E+02, 9.5880E+02, 9.6262E+02, &
       9.6645E+02, 9.7029E+02, 9.7414E+02, 9.7799E+02, 9.8186E+02, 9.8573E+02, 9.8962E+02, 9.9351E+02, 9.9742E+02, 1.0013E+03, &
       1.0052E+03, 1.0092E+03, 1.0131E+03, 1.0171E+03, 1.0210E+03, 1.0250E+03, 1.0290E+03, 1.0330E+03, 1.0370E+03, 1.0410E+03, &
       1.0450E+03, 1.0490E+03, 1.0530E+03, 1.0571E+03, 1.0611E+03, 1.0652E+03, 1.0693E+03, 1.0734E+03, 1.0774E+03, 1.0816E+03, &
       1.0857E+03, 1.0898E+03, 1.0939E+03, 1.0981E+03, 1.1022E+03, 1.1064E+03, 1.1105E+03, 1.1147E+03, 1.1189E+03, 1.1231E+03, &
       1.1273E+03, 1.1315E+03, 1.1358E+03, 1.1400E+03, 1.1443E+03, 1.1485E+03, 1.1528E+03, 1.1571E+03, 1.1614E+03, 1.1657E+03, &
       1.1700E+03, 1.1743E+03, 1.1786E+03, 1.1830E+03, 1.1873E+03, 1.1917E+03, 1.1961E+03, 1.2004E+03, 1.2048E+03, 1.2092E+03, &
       1.2136E+03, 1.2181E+03, 1.2225E+03, 1.2269E+03, 1.2314E+03, 1.2359E+03, 1.2403E+03, 1.2448E+03, 1.2493E+03, 1.2538E+03, &
       1.2584E+03, 1.2629E+03, 1.2674E+03, 1.2720E+03, 1.2765E+03, 1.2811E+03, 1.2857E+03, 1.2903E+03, 1.2949E+03, 1.2995E+03, &
       1.3041E+03, 1.3088E+03, 1.3134E+03, 1.3181E+03, 1.3227E+03, 1.3274E+03, 1.3321E+03, 1.3368E+03, 1.3415E+03, 1.3462E+03, &
       1.3510E+03, 1.3557E+03, 1.3605E+03, 1.3652E+03, 1.3700E+03, 1.3748E+03, 1.3796E+03, 1.3844E+03, 1.3892E+03, 1.3941E+03, &
       1.3989E+03, 1.4038E+03, 1.4086E+03, 1.4135E+03, 1.4184E+03, 1.4233E+03, 1.4282E+03, 1.4331E+03, 1.4381E+03, 1.4430E+03, &
       1.4480E+03, 1.4530E+03, 1.4579E+03, 1.4629E+03, 1.4679E+03, 1.4730E+03, 1.4780E+03, 1.4830E+03, 1.4881E+03, 1.4931E+03, &
       1.4982E+03, 1.5033E+03, 1.5084E+03, 1.5135E+03, 1.5186E+03, 1.5238E+03, 1.5289E+03, 1.5341E+03, 1.5392E+03, 1.5444E+03, &
       1.5496E+03, 1.5548E+03, 1.5600E+03, 1.5653E+03, 1.5705E+03, 1.5757E+03, 1.5810E+03, 1.5863E+03, 1.5916E+03, 1.5969E+03, &
       1.6022E+03, 1.6075E+03, 1.6129E+03, 1.6182E+03, 1.6236E+03, 1.6289E+03, 1.6343E+03, 1.6397E+03, 1.6451E+03, 1.6506E+03, &
       1.6560E+03, 1.6615E+03, 1.6669E+03, 1.6724E+03, 1.6779E+03, 1.6834E+03, 1.6889E+03, 1.6944E+03, 1.7000E+03, 1.7055E+03, &
       1.7111E+03, 1.7166E+03, 1.7222E+03, 1.7278E+03, 1.7334E+03, 1.7391E+03, 1.7447E+03, 1.7504E+03, 1.7560E+03, 1.7617E+03, &
       1.7674E+03, 1.7731E+03, 1.7788E+03, 1.7846E+03, 1.7903E+03, 1.7961E+03, 1.8018E+03, 1.8076E+03, 1.8134E+03, 1.8192E+03, &
       1.8250E+03, 1.8309E+03, 1.8367E+03, 1.8426E+03, 1.8484E+03, 1.8543E+03, 1.8602E+03, 1.8662E+03, 1.8721E+03, 1.8780E+03, &
       1.8840E+03, 1.8899E+03, 1.8959E+03, 1.9019E+03, 1.9079E+03, 1.9140E+03, 1.9200E+03, 1.9260E+03, 1.9321E+03, 1.9382E+03, &
       1.9443E+03, 1.9504E+03, 1.9565E+03, 1.9626E+03, 1.9688E+03, 1.9749E+03, 1.9811E+03, 1.9873E+03, 1.9935E+03, 1.9997E+03, &
       2.0059E+03, 2.0122E+03, 2.0184E+03, 2.0247E+03, 2.0310E+03, 2.0373E+03, 2.0436E+03, 2.0499E+03, 2.0563E+03, 2.0626E+03, &
       2.0690E+03, 2.0754E+03, 2.0818E+03, 2.0882E+03, 2.0946E+03, 2.1011E+03, 2.1075E+03, 2.1140E+03, 2.1205E+03, 2.1270E+03, &
       2.1335E+03, 2.1401E+03, 2.1466E+03, 2.1532E+03, 2.1597E+03, 2.1663E+03, 2.1729E+03, 2.1795E+03, 2.1862E+03, 2.1928E+03, &
       2.1995E+03, 2.2062E+03, 2.2128E+03, 2.2196E+03, 2.2263E+03, 2.2330E+03, 2.2398E+03, 2.2465E+03, 2.2533E+03, 2.2601E+03, &
       2.2669E+03, 2.2737E+03, 2.2806E+03, 2.2874E+03, 2.2943E+03, 2.3012E+03, 2.3081E+03, 2.3150E+03, 2.3220E+03, 2.3289E+03, &
       2.3359E+03, 2.3428E+03, 2.3498E+03, 2.3569E+03, 2.3639E+03, 2.3709E+03, 2.3780E+03, 2.3851E+03, 2.3921E+03, 2.3992E+03, &
       2.4064E+03, 2.4135E+03, 2.4206E+03, 2.4278E+03, 2.4350E+03, 2.4422E+03, 2.4494E+03, 2.4566E+03, 2.4639E+03, 2.4711E+03, &
       2.4784E+03, 2.4857E+03, 2.4930E+03, 2.5004E+03, 2.5077E+03, 2.5151E+03, 2.5224E+03, 2.5298E+03, 2.5372E+03, 2.5446E+03, &
       2.5521E+03, 2.5595E+03, 2.5670E+03, 2.5745E+03, 2.5820E+03, 2.5895E+03, 2.5971E+03, 2.6046E+03, 2.6122E+03, 2.6198E+03, &
       2.6274E+03, 2.6350E+03, 2.6426E+03, 2.6503E+03, 2.6579E+03, 2.6656E+03, 2.6733E+03, 2.6811E+03, 2.6888E+03, 2.6965E+03, &
       2.7043E+03, 2.7121E+03, 2.7199E+03, 2.7277E+03, 2.7356E+03, 2.7434E+03, 2.7513E+03, 2.7592E+03, 2.7671E+03, 2.7750E+03, &
       2.7829E+03, 2.7909E+03, 2.7989E+03, 2.8069E+03, 2.8149E+03, 2.8229E+03, 2.8309E+03, 2.8390E+03, 2.8471E+03, 2.8552E+03, &
       2.8633E+03, 2.8714E+03, 2.8796E+03, 2.8877E+03, 2.8959E+03, 2.9041E+03, 2.9123E+03, 2.9206E+03, 2.9288E+03, 2.9371E+03, &
       2.9454E+03, 2.9537E+03, 2.9620E+03, 2.9704E+03, 2.9787E+03, 2.9871E+03, 2.9955E+03, 3.0039E+03, 3.0124E+03, 3.0208E+03, &
       3.0293E+03, 3.0378E+03, 3.0463E+03, 3.0548E+03, 3.0633E+03, 3.0719E+03, 3.0805E+03, 3.0891E+03, 3.0977E+03, 3.1063E+03, &
       3.1150E+03, 3.1236E+03, 3.1323E+03, 3.1410E+03, 3.1498E+03, 3.1585E+03, 3.1673E+03, 3.1760E+03, 3.1848E+03, 3.1937E+03, &
       3.2025E+03, 3.2114E+03, 3.2202E+03, 3.2291E+03, 3.2380E+03, 3.2470E+03, 3.2559E+03, 3.2649E+03, 3.2739E+03, 3.2829E+03, &
       3.2919E+03, 3.3010E+03, 3.3100E+03, 3.3191E+03, 3.3282E+03, 3.3373E+03, 3.3465E+03, 3.3556E+03, 3.3648E+03, 3.3740E+03, &
       3.3832E+03, 3.3925E+03, 3.4017E+03, 3.4110E+03, 3.4203E+03, 3.4296E+03, 3.4390E+03, 3.4483E+03, 3.4577E+03, 3.4671E+03, &
       3.4765E+03, 3.4859E+03, 3.4954E+03, 3.5049E+03, 3.5144E+03, 3.5239E+03, 3.5334E+03, 3.5430E+03, 3.5525E+03, 3.5621E+03, &
       3.5717E+03, 3.5814E+03, 3.5910E+03, 3.6007E+03, 3.6104E+03, 3.6201E+03, 3.6298E+03, 3.6396E+03, 3.6494E+03, 3.6592E+03, &
       3.6690E+03, 3.6788E+03, 3.6887E+03, 3.6986E+03, 3.7085E+03, 3.7184E+03, 3.7283E+03, 3.7383E+03, 3.7483E+03, 3.7583E+03, &
       3.7683E+03, 3.7783E+03, 3.7884E+03, 3.7985E+03, 3.8086E+03, 3.8187E+03, 3.8288E+03, 3.8390E+03, 3.8492E+03, 3.8594E+03, &
       3.8696E+03, 3.8799E+03, 3.8902E+03, 3.9005E+03, 3.9108E+03, 3.9211E+03, 3.9315E+03, 3.9419E+03, 3.9523E+03, 3.9627E+03, &
       3.9731E+03, 3.9836E+03, 3.9941E+03, 4.0046E+03, 4.0151E+03, 4.0257E+03, 4.0362E+03, 4.0468E+03, 4.0575E+03, 4.0681E+03, &
       4.0788E+03, 4.0894E+03, 4.1001E+03, 4.1109E+03, 4.1216E+03, 4.1324E+03, 4.1432E+03, 4.1540E+03, 4.1648E+03, 4.1757E+03, &
       4.1866E+03, 4.1975E+03, 4.2084E+03, 4.2193E+03, 4.2303E+03, 4.2413E+03, 4.2523E+03, 4.2634E+03, 4.2744E+03, 4.2855E+03, &
       4.2966E+03, 4.3077E+03, 4.3189E+03, 4.3300E+03, 4.3412E+03, 4.3525E+03, 4.3637E+03, 4.3750E+03, 4.3862E+03, 4.3976E+03, &
       4.4089E+03, 4.4202E+03, 4.4316E+03, 4.4430E+03, 4.4544E+03, 4.4659E+03, 4.4774E+03, 4.4888E+03, 4.5004E+03, 4.5119E+03, &
       4.5235E+03, 4.5350E+03, 4.5467E+03, 4.5583E+03, 4.5699E+03, 4.5816E+03, 4.5933E+03, 4.6051E+03, 4.6168E+03, 4.6286E+03, &
       4.6404E+03, 4.6522E+03, 4.6640E+03, 4.6759E+03, 4.6878E+03, 4.6997E+03, 4.7117E+03, 4.7236E+03, 4.7356E+03, 4.7476E+03, &
       4.7596E+03, 4.7717E+03, 4.7838E+03, 4.7959E+03, 4.8080E+03, 4.8202E+03, 4.8324E+03, 4.8446E+03, 4.8568E+03, 4.8691E+03, &
       4.8813E+03, 4.8936E+03, 4.9060E+03, 4.9183E+03, 4.9307E+03, 4.9431E+03, 4.9555E+03, 4.9680E+03, 4.9804E+03, 4.9929E+03, &
       5.0055E+03, 5.0180E+03, 5.0306E+03, 5.0432E+03, 5.0558E+03, 5.0684E+03, 5.0811E+03, 5.0938E+03, 5.1065E+03, 5.1193E+03, &
       5.1321E+03, 5.1449E+03, 5.1577E+03, 5.1705E+03, 5.1834E+03, 5.1963E+03, 5.2092E+03, 5.2222E+03, 5.2352E+03, 5.2482E+03, &
       5.2612E+03, 5.2742E+03, 5.2873E+03, 5.3004E+03, 5.3136E+03, 5.3267E+03, 5.3399E+03, 5.3531E+03, 5.3663E+03, 5.3796E+03, &
       5.3929E+03, 5.4062E+03, 5.4195E+03, 5.4329E+03, 5.4463E+03, 5.4597E+03, 5.4731E+03, 5.4866E+03, 5.5001E+03, 5.5136E+03, &
       5.5272E+03, 5.5408E+03, 5.5544E+03, 5.5680E+03, 5.5816E+03, 5.5953E+03, 5.6090E+03, 5.6228E+03, 5.6365E+03, 5.6503E+03, &
       5.6641E+03, 5.6780E+03, 5.6918E+03, 5.7057E+03, 5.7196E+03, 5.7336E+03, 5.7476E+03, 5.7616E+03, 5.7756E+03, 5.7896E+03, &
       5.8037E+03, 5.8178E+03, 5.8320E+03, 5.8461E+03, 5.8603E+03, 5.8746E+03, 5.8888E+03, 5.9031E+03, 5.9174E+03, 5.9317E+03, &
       5.9461E+03, 5.9604E+03, 5.9749E+03, 5.9893E+03, 6.0038E+03, 6.0183E+03, 6.0328E+03, 6.0473E+03, 6.0619E+03, 6.0765E+03, &
       6.0912E+03, 6.1058E+03, 6.1205E+03, 6.1352E+03, 6.1500E+03, 6.1648E+03, 6.1796E+03, 6.1944E+03, 6.2093E+03, 6.2242E+03, &
       6.2391E+03, 6.2540E+03, 6.2690E+03, 6.2840E+03, 6.2990E+03, 6.3141E+03, 6.3292E+03, 6.3443E+03, 6.3595E+03, 6.3746E+03, &
       6.3898E+03, 6.4051E+03, 6.4203E+03, 6.4356E+03, 6.4509E+03, 6.4663E+03, 6.4817E+03, 6.4971E+03, 6.5125E+03, 6.5280E+03, &
       6.5435E+03, 6.5590E+03, 6.5746E+03, 6.5901E+03, 6.6058E+03, 6.6214E+03, 6.6371E+03, 6.6528E+03, 6.6685E+03, 6.6843E+03, &
       6.7001E+03, 6.7159E+03, 6.7317E+03, 6.7476E+03, 6.7635E+03, 6.7795E+03, 6.7954E+03, 6.8114E+03, 6.8275E+03, 6.8435E+03, &
       6.8596E+03, 6.8758E+03, 6.8919E+03, 6.9081E+03, 6.9243E+03, 6.9405E+03, 6.9568E+03, 6.9731E+03, 6.9895E+03, 7.0058E+03, &
       7.0222E+03, 7.0386E+03, 7.0551E+03, 7.0716E+03, 7.0881E+03, 7.1047E+03, 7.1212E+03, 7.1379E+03, 7.1545E+03, 7.1712E+03, &
       7.1879E+03, 7.2046E+03, 7.2214E+03, 7.2382E+03, 7.2550E+03, 7.2719E+03, 7.2888E+03, 7.3057E+03, 7.3226E+03, 7.3396E+03, &
       7.3566E+03, 7.3737E+03, 7.3908E+03, 7.4079E+03, 7.4250E+03, 7.4422E+03, 7.4594E+03, 7.4767E+03, 7.4939E+03, 7.5112E+03, &
       7.5286E+03, 7.5459E+03, 7.5633E+03, 7.5808E+03, 7.5982E+03, 7.6157E+03, 7.6333E+03, 7.6508E+03, 7.6684E+03, 7.6860E+03, &
       7.7037E+03, 7.7214E+03, 7.7391E+03, 7.7569E+03, 7.7747E+03, 7.7925E+03, 7.8103E+03, 7.8282E+03, 7.8461E+03, 7.8641E+03, &
       7.8821E+03, 7.9001E+03, 7.9182E+03, 7.9362E+03, 7.9544E+03, 7.9725E+03, 7.9907E+03, 8.0089E+03, 8.0272E+03, 8.0454E+03, &
       8.0638E+03, 8.0821E+03, 8.1005E+03, 8.1189E+03, 8.1374E+03, 8.1558E+03, 8.1744E+03, 8.1929E+03, 8.2115E+03, 8.2301E+03, &
       8.2488E+03, 8.2675E+03, 8.2862E+03, 8.3049E+03, 8.3237E+03, 8.3426E+03, 8.3614E+03, 8.3803E+03, 8.3992E+03, 8.4182E+03, &
       8.4372E+03, 8.4562E+03, 8.4753E+03, 8.4944E+03, 8.5135E+03, 8.5327E+03, 8.5519E+03, 8.5711E+03, 8.5904E+03, 8.6097E+03, &
       8.6290E+03, 8.6484E+03, 8.6678E+03, 8.6873E+03, 8.7068E+03, 8.7263E+03, 8.7458E+03, 8.7654E+03, 8.7850E+03, 8.8047E+03, &
       8.8244E+03, 8.8441E+03, 8.8639E+03, 8.8837E+03, 8.9035E+03, 8.9234E+03, 8.9433E+03, 8.9632E+03, 8.9832E+03, 9.0032E+03, &
       9.0233E+03, 9.0433E+03, 9.0635E+03, 9.0836E+03, 9.1038E+03, 9.1240E+03, 9.1443E+03, 9.1646E+03, 9.1849E+03, 9.2053E+03, &
       9.2257E+03, 9.2462E+03, 9.2667E+03, 9.2872E+03, 9.3077E+03, 9.3283E+03, 9.3489E+03, 9.3696E+03, 9.3903E+03, 9.4111E+03, &
       9.4318E+03, 9.4526E+03, 9.4735E+03, 9.4944E+03, 9.5153E+03, 9.5363E+03, 9.5573E+03, 9.5783E+03, 9.5994E+03, 9.6205E+03, &
       9.6416E+03, 9.6628E+03, 9.6840E+03, 9.7053E+03, 9.7266E+03, 9.7479E+03, 9.7693E+03, 9.7907E+03, 9.8121E+03, 9.8336E+03, &
       9.8551E+03, 9.8767E+03, 9.8983E+03, 9.9199E+03, 9.9416E+03, 9.9633E+03, 9.9851E+03, 1.0007E+04, 1.0029E+04, 1.0051E+04, &
       1.0072E+04, 1.0094E+04, 1.0116E+04, 1.0138E+04, 1.0160E+04, 1.0183E+04, 1.0205E+04, 1.0227E+04, 1.0249E+04, 1.0271E+04, &
       1.0294E+04, 1.0316E+04, 1.0338E+04, 1.0361E+04, 1.0383E+04, 1.0406E+04, 1.0428E+04, 1.0451E+04, 1.0473E+04, 1.0496E+04, &
       1.0519E+04, 1.0541E+04, 1.0564E+04, 1.0587E+04, 1.0610E+04, 1.0633E+04, 1.0656E+04, 1.0679E+04, 1.0702E+04, 1.0725E+04, &
       1.0748E+04, 1.0771E+04, 1.0794E+04, 1.0817E+04, 1.0840E+04, 1.0864E+04, 1.0887E+04, 1.0910E+04, 1.0934E+04, 1.0957E+04, &
       1.0981E+04, 1.1004E+04, 1.1028E+04, 1.1051E+04, 1.1075E+04, 1.1099E+04, 1.1122E+04, 1.1146E+04, 1.1170E+04, 1.1194E+04, &
       1.1218E+04, 1.1242E+04, 1.1266E+04, 1.1290E+04, 1.1314E+04, 1.1338E+04, 1.1362E+04, 1.1386E+04, 1.1410E+04, 1.1434E+04, &
       1.1459E+04, 1.1483E+04, 1.1508E+04, 1.1532E+04, 1.1556E+04, 1.1581E+04, 1.1605E+04, 1.1630E+04, 1.1655E+04, 1.1679E+04, &
       1.1704E+04, 1.1729E+04, 1.1754E+04, 1.1779E+04, 1.1803E+04, 1.1828E+04, 1.1853E+04, 1.1878E+04, 1.1903E+04, 1.1928E+04, &
       1.1954E+04, 1.1979E+04, 1.2004E+04, 1.2029E+04, 1.2055E+04, 1.2080E+04, 1.2105E+04, 1.2131E+04, 1.2156E+04, 1.2182E+04, &
       1.2207E+04, 1.2233E+04, 1.2259E+04, 1.2284E+04, 1.2310E+04, 1.2336E+04, 1.2362E+04, 1.2388E+04, 1.2414E+04, 1.2439E+04, &
       1.2465E+04, 1.2492E+04, 1.2518E+04, 1.2544E+04, 1.2570E+04, 1.2596E+04, 1.2622E+04, 1.2649E+04, 1.2675E+04, 1.2702E+04, &
       1.2728E+04, 1.2754E+04, 1.2781E+04, 1.2808E+04, 1.2834E+04, 1.2861E+04, 1.2888E+04, 1.2914E+04, 1.2941E+04, 1.2968E+04, &
       1.2995E+04, 1.3022E+04, 1.3049E+04, 1.3076E+04, 1.3103E+04, 1.3130E+04, 1.3157E+04, 1.3184E+04, 1.3212E+04, 1.3239E+04, &
       1.3266E+04, 1.3294E+04, 1.3321E+04, 1.3349E+04, 1.3376E+04, 1.3404E+04, 1.3431E+04, 1.3459E+04, 1.3487E+04, 1.3514E+04, &
       1.3542E+04, 1.3570E+04, 1.3598E+04, 1.3626E+04, 1.3654E+04, 1.3682E+04, 1.3710E+04, 1.3738E+04, 1.3766E+04, 1.3795E+04, &
       1.3823E+04, 1.3851E+04, 1.3880E+04, 1.3908E+04, 1.3936E+04, 1.3965E+04, 1.3993E+04, 1.4022E+04, 1.4051E+04, 1.4079E+04, &
       1.4108E+04, 1.4137E+04, 1.4166E+04, 1.4195E+04, 1.4223E+04, 1.4252E+04, 1.4281E+04, 1.4311E+04, 1.4340E+04, 1.4369E+04, &
       1.4398E+04, 1.4427E+04, 1.4457E+04, 1.4486E+04, 1.4515E+04, 1.4545E+04, 1.4574E+04, 1.4604E+04, 1.4633E+04, 1.4663E+04, &
       1.4693E+04, 1.4723E+04, 1.4752E+04, 1.4782E+04, 1.4812E+04, 1.4842E+04, 1.4872E+04, 1.4902E+04, 1.4932E+04, 1.4962E+04, &
       1.4992E+04, 1.5023E+04, 1.5053E+04, 1.5083E+04, 1.5114E+04, 1.5144E+04, 1.5174E+04, 1.5205E+04, 1.5236E+04, 1.5266E+04, &
       1.5297E+04, 1.5328E+04, 1.5358E+04, 1.5389E+04, 1.5420E+04, 1.5451E+04, 1.5482E+04, 1.5513E+04, 1.5544E+04, 1.5575E+04, &
       1.5606E+04, 1.5638E+04, 1.5669E+04, 1.5700E+04, 1.5731E+04, 1.5763E+04, 1.5794E+04, 1.5826E+04, 1.5857E+04, 1.5889E+04, &
       1.5921E+04, 1.5953E+04, 1.5984E+04, 1.6016E+04, 1.6048E+04, 1.6080E+04, 1.6112E+04, 1.6144E+04, 1.6176E+04, 1.6208E+04, &
       1.6240E+04, 1.6273E+04, 1.6305E+04, 1.6337E+04, 1.6370E+04, 1.6402E+04, 1.6435E+04, 1.6467E+04, 1.6500E+04, 1.6532E+04, &
       1.6565E+04, 1.6598E+04, 1.6631E+04, 1.6663E+04, 1.6696E+04, 1.6729E+04, 1.6762E+04, 1.6795E+04, 1.6829E+04, 1.6862E+04, &
       1.6895E+04, 1.6928E+04, 1.6962E+04, 1.6995E+04, 1.7028E+04, 1.7062E+04, 1.7095E+04, 1.7129E+04, 1.7163E+04, 1.7196E+04, &
       1.7230E+04, 1.7264E+04, 1.7298E+04, 1.7332E+04, 1.7366E+04, 1.7400E+04, 1.7434E+04, 1.7468E+04, 1.7502E+04, 1.7536E+04, &
       1.7571E+04, 1.7605E+04, 1.7639E+04, 1.7674E+04, 1.7708E+04, 1.7743E+04, 1.7778E+04, 1.7812E+04, 1.7847E+04, 1.7882E+04, &
       1.7917E+04, 1.7951E+04, 1.7986E+04, 1.8021E+04, 1.8056E+04, 1.8092E+04, 1.8127E+04, 1.8162E+04, 1.8197E+04, 1.8232E+04, &
       1.8268E+04, 1.8303E+04, 1.8339E+04, 1.8374E+04, 1.8410E+04, 1.8446E+04, 1.8481E+04, 1.8517E+04, 1.8553E+04, 1.8589E+04, &
       1.8625E+04, 1.8661E+04, 1.8697E+04, 1.8733E+04, 1.8769E+04, 1.8805E+04, 1.8842E+04, 1.8878E+04, 1.8914E+04, 1.8951E+04, &
       1.8987E+04, 1.9024E+04, 1.9060E+04, 1.9097E+04, 1.9134E+04, 1.9171E+04, 1.9207E+04, 1.9244E+04, 1.9281E+04, 1.9318E+04, &
       1.9355E+04, 1.9392E+04, 1.9430E+04, 1.9467E+04, 1.9504E+04, 1.9542E+04, 1.9579E+04, 1.9616E+04, 1.9654E+04, 1.9691E+04, &
       1.9729E+04, 1.9767E+04, 1.9805E+04, 1.9842E+04, 1.9880E+04, 1.9918E+04, 1.9956E+04, 1.9994E+04, 2.0032E+04, 2.0070E+04, &
       2.0109E+04, 2.0147E+04, 2.0185E+04, 2.0224E+04, 2.0262E+04, 2.0301E+04, 2.0339E+04, 2.0378E+04, 2.0417E+04, 2.0455E+04, &
       2.0494E+04, 2.0533E+04, 2.0572E+04, 2.0611E+04, 2.0650E+04, 2.0689E+04, 2.0728E+04, 2.0767E+04, 2.0807E+04, 2.0846E+04, &
       2.0885E+04, 2.0925E+04, 2.0964E+04, 2.1004E+04, 2.1044E+04, 2.1083E+04, 2.1123E+04, 2.1163E+04, 2.1203E+04, 2.1243E+04, &
       2.1283E+04, 2.1323E+04, 2.1363E+04, 2.1403E+04, 2.1443E+04, 2.1484E+04, 2.1524E+04, 2.1564E+04, 2.1605E+04, 2.1646E+04, &
       2.1686E+04, 2.1727E+04, 2.1768E+04, 2.1808E+04, 2.1849E+04, 2.1890E+04, 2.1931E+04, 2.1972E+04, 2.2013E+04, 2.2054E+04, &
       2.2096E+04, 2.2137E+04, 2.2178E+04, 2.2220E+04, 2.2261E+04, 2.2303E+04, 2.2344E+04, 2.2386E+04, 2.2428E+04, 2.2469E+04, &
       2.2511E+04, 2.2553E+04, 2.2595E+04, 2.2637E+04, 2.2679E+04, 2.2721E+04, 2.2764E+04, 2.2806E+04, 2.2848E+04, 2.2891E+04, &
       2.2933E+04, 2.2976E+04, 2.3018E+04, 2.3061E+04, 2.3104E+04, 2.3146E+04, 2.3189E+04, 2.3232E+04, 2.3275E+04, 2.3318E+04, &
       2.3361E+04, 2.3404E+04, 2.3448E+04, 2.3491E+04, 2.3534E+04, 2.3578E+04, 2.3621E+04, 2.3665E+04, 2.3708E+04, 2.3752E+04, &
       2.3796E+04, 2.3839E+04, 2.3883E+04, 2.3927E+04, 2.3971E+04, 2.4015E+04, 2.4059E+04, 2.4104E+04, 2.4148E+04, 2.4192E+04, &
       2.4237E+04, 2.4281E+04, 2.4326E+04, 2.4370E+04, 2.4415E+04, 2.4460E+04, 2.4504E+04, 2.4549E+04, 2.4594E+04, 2.4639E+04, &
       2.4684E+04, 2.4729E+04, 2.4774E+04, 2.4820E+04, 2.4865E+04, 2.4910E+04, 2.4956E+04, 2.5001E+04, 2.5047E+04, 2.5092E+04, &
       2.5138E+04, 2.5184E+04, 2.5230E+04, 2.5276E+04, 2.5322E+04, 2.5368E+04, 2.5414E+04, 2.5460E+04, 2.5506E+04, 2.5552E+04, &
       2.5599E+04, 2.5645E+04, 2.5692E+04, 2.5738E+04, 2.5785E+04, 2.5832E+04, 2.5878E+04, 2.5925E+04, 2.5972E+04, 2.6019E+04, &
       2.6066E+04, 2.6113E+04, 2.6160E+04, 2.6208E+04, 2.6255E+04, 2.6302E+04, 2.6350E+04, 2.6397E+04, 2.6445E+04, 2.6493E+04, &
       2.6540E+04, 2.6588E+04, 2.6636E+04, 2.6684E+04, 2.6732E+04, 2.6780E+04, 2.6828E+04, 2.6876E+04, 2.6925E+04, 2.6973E+04, &
       2.7021E+04, 2.7070E+04, 2.7118E+04, 2.7167E+04, 2.7216E+04, 2.7264E+04, 2.7313E+04, 2.7362E+04, 2.7411E+04, 2.7460E+04, &
       2.7509E+04, 2.7558E+04, 2.7608E+04, 2.7657E+04, 2.7706E+04, 2.7756E+04, 2.7805E+04, 2.7855E+04, 2.7905E+04, 2.7954E+04, &
       2.8004E+04, 2.8054E+04, 2.8104E+04, 2.8154E+04, 2.8204E+04, 2.8254E+04, 2.8304E+04, 2.8355E+04, 2.8405E+04, 2.8455E+04, &
       2.8506E+04, 2.8557E+04, 2.8607E+04, 2.8658E+04, 2.8709E+04, 2.8760E+04, 2.8811E+04, 2.8862E+04, 2.8913E+04, 2.8964E+04, &
       2.9015E+04, 2.9066E+04, 2.9118E+04, 2.9169E+04, 2.9221E+04, 2.9272E+04, 2.9324E+04, 2.9376E+04, 2.9427E+04, 2.9479E+04, &
       2.9531E+04, 2.9583E+04, 2.9635E+04, 2.9688E+04, 2.9740E+04, 2.9792E+04, 2.9844E+04, 2.9897E+04, 2.9949E+04, 3.0002E+04, &
       3.0055E+04, 3.0108E+04, 3.0160E+04, 3.0213E+04, 3.0266E+04, 3.0319E+04, 3.0372E+04, 3.0426E+04, 3.0479E+04, 3.0532E+04, &
       3.0586E+04, 3.0639E+04, 3.0693E+04, 3.0746E+04, 3.0800E+04, 3.0854E+04, 3.0908E+04, 3.0962E+04, 3.1016E+04, 3.1070E+04, &
       3.1124E+04, 3.1178E+04, 3.1232E+04, 3.1287E+04, 3.1341E+04, 3.1396E+04, 3.1450E+04, 3.1505E+04, 3.1560E+04, 3.1615E+04, &
       3.1669E+04, 3.1724E+04, 3.1779E+04, 3.1835E+04, 3.1890E+04, 3.1945E+04, 3.2000E+04, 3.2056E+04, 3.2111E+04, 3.2167E+04, &
       3.2223E+04, 3.2278E+04, 3.2334E+04, 3.2390E+04, 3.2446E+04, 3.2502E+04, 3.2558E+04, 3.2614E+04, 3.2671E+04, 3.2727E+04, &
       3.2783E+04, 3.2840E+04, 3.2897E+04, 3.2953E+04, 3.3010E+04, 3.3067E+04, 3.3124E+04, 3.3181E+04, 3.3238E+04, 3.3295E+04, &
       3.3352E+04, 3.3409E+04, 3.3467E+04, 3.3524E+04, 3.3581E+04, 3.3639E+04, 3.3697E+04, 3.3754E+04, 3.3812E+04, 3.3870E+04, &
       3.3928E+04, 3.3986E+04, 3.4044E+04, 3.4102E+04, 3.4161E+04, 3.4219E+04, 3.4278E+04, 3.4336E+04, 3.4395E+04, 3.4453E+04, &
       3.4512E+04, 3.4571E+04, 3.4630E+04, 3.4689E+04, 3.4748E+04, 3.4807E+04, 3.4866E+04, 3.4926E+04, 3.4985E+04, 3.5044E+04, &
       3.5104E+04, 3.5164E+04, 3.5223E+04, 3.5283E+04, 3.5343E+04, 3.5403E+04, 3.5463E+04, 3.5523E+04, 3.5583E+04, 3.5644E+04, &
       3.5704E+04, 3.5764E+04, 3.5825E+04, 3.5885E+04, 3.5946E+04, 3.6007E+04, 3.6068E+04, 3.6129E+04, 3.6189E+04, 3.6251E+04, &
       3.6312E+04, 3.6373E+04, 3.6434E+04, 3.6496E+04, 3.6557E+04, 3.6619E+04, 3.6680E+04, 3.6742E+04, 3.6804E+04, 3.6866E+04, &
       3.6928E+04, 3.6990E+04, 3.7052E+04, 3.7114E+04, 3.7176E+04, 3.7239E+04, 3.7301E+04, 3.7364E+04, 3.7426E+04, 3.7489E+04, &
       3.7552E+04, 3.7615E+04, 3.7678E+04, 3.7741E+04, 3.7804E+04, 3.7867E+04, 3.7930E+04, 3.7994E+04, 3.8057E+04, 3.8120E+04, &
       3.8184E+04, 3.8248E+04, 3.8312E+04, 3.8375E+04, 3.8439E+04, 3.8503E+04, 3.8567E+04, 3.8632E+04, 3.8696E+04, 3.8760E+04, &
       3.8825E+04, 3.8889E+04, 3.8954E+04, 3.9018E+04, 3.9083E+04, 3.9148E+04, 3.9213E+04, 3.9278E+04, 3.9343E+04, 3.9408E+04, &
       3.9474E+04, 3.9539E+04, 3.9604E+04, 3.9670E+04, 3.9736E+04, 3.9801E+04, 3.9867E+04, 3.9933E+04, 3.9999E+04, 4.0065E+04, &
       4.0131E+04, 4.0197E+04, 4.0264E+04, 4.0330E+04, 4.0396E+04, 4.0463E+04, 4.0530E+04, 4.0596E+04, 4.0663E+04, 4.0730E+04, &
       4.0797E+04, 4.0864E+04, 4.0931E+04, 4.0998E+04, 4.1066E+04, 4.1133E+04, 4.1201E+04, 4.1268E+04, 4.1336E+04, 4.1404E+04, &
       4.1471E+04, 4.1539E+04, 4.1607E+04, 4.1675E+04, 4.1744E+04, 4.1812E+04, 4.1880E+04, 4.1949E+04, 4.2017E+04, 4.2086E+04, &
       4.2155E+04, 4.2223E+04, 4.2292E+04, 4.2361E+04, 4.2430E+04, 4.2499E+04, 4.2569E+04, 4.2638E+04, 4.2707E+04, 4.2777E+04, &
       4.2846E+04, 4.2916E+04, 4.2986E+04, 4.3056E+04, 4.3125E+04, 4.3196E+04, 4.3266E+04, 4.3336E+04, 4.3406E+04, 4.3476E+04, &
       4.3547E+04, 4.3617E+04, 4.3688E+04, 4.3759E+04, 4.3830E+04, 4.3900E+04, 4.3971E+04, 4.4043E+04, 4.4114E+04, 4.4185E+04, &
       4.4256E+04, 4.4328E+04, 4.4399E+04, 4.4471E+04, 4.4543E+04, 4.4614E+04, 4.4686E+04, 4.4758E+04, 4.4830E+04, 4.4902E+04, &
       4.4975E+04, 4.5047E+04, 4.5119E+04, 4.5192E+04, 4.5264E+04, 4.5337E+04, 4.5410E+04, 4.5483E+04, 4.5556E+04, 4.5629E+04, &
       4.5702E+04, 4.5775E+04, 4.5848E+04, 4.5922E+04, 4.5995E+04, 4.6069E+04, 4.6143E+04, 4.6216E+04, 4.6290E+04, 4.6364E+04, &
       4.6438E+04, 4.6512E+04, 4.6587E+04, 4.6661E+04, 4.6735E+04, 4.6810E+04, 4.6884E+04, 4.6959E+04, 4.7034E+04, 4.7109E+04, &
       4.7184E+04, 4.7259E+04, 4.7334E+04, 4.7409E+04, 4.7484E+04, 4.7560E+04, 4.7635E+04, 4.7711E+04, 4.7787E+04, 4.7862E+04, &
       4.7938E+04, 4.8014E+04, 4.8090E+04, 4.8167E+04, 4.8243E+04, 4.8319E+04, 4.8396E+04, 4.8472E+04, 4.8549E+04, 4.8625E+04, &
       4.8702E+04, 4.8779E+04, 4.8856E+04, 4.8933E+04, 4.9010E+04, 4.9088E+04, 4.9165E+04, 4.9242E+04, 4.9320E+04, 4.9398E+04, &
       4.9475E+04, 4.9553E+04, 4.9631E+04, 4.9709E+04, 4.9787E+04, 4.9866E+04, 4.9944E+04, 5.0022E+04, 5.0101E+04, 5.0179E+04, &
       5.0258E+04, 5.0337E+04, 5.0416E+04, 5.0495E+04, 5.0574E+04, 5.0653E+04, 5.0732E+04, 5.0811E+04, 5.0891E+04, 5.0970E+04, &
       5.1050E+04, 5.1130E+04, 5.1209E+04, 5.1289E+04, 5.1369E+04, 5.1450E+04, 5.1530E+04, 5.1610E+04, 5.1690E+04, 5.1771E+04, &
       5.1851E+04, 5.1932E+04, 5.2013E+04, 5.2094E+04, 5.2175E+04, 5.2256E+04, 5.2337E+04, 5.2418E+04, 5.2500E+04, 5.2581E+04, &
       5.2663E+04, 5.2744E+04, 5.2826E+04, 5.2908E+04, 5.2990E+04, 5.3072E+04, 5.3154E+04, 5.3236E+04, 5.3318E+04, 5.3401E+04, &
       5.3483E+04, 5.3566E+04, 5.3649E+04, 5.3731E+04, 5.3814E+04, 5.3897E+04, 5.3980E+04, 5.4064E+04, 5.4147E+04, 5.4230E+04, &
       5.4314E+04, 5.4397E+04, 5.4481E+04, 5.4565E+04, 5.4649E+04, 5.4733E+04, 5.4817E+04, 5.4901E+04, 5.4985E+04, 5.5069E+04, &
       5.5154E+04, 5.5238E+04, 5.5323E+04, 5.5408E+04, 5.5493E+04, 5.5578E+04, 5.5663E+04, 5.5748E+04, 5.5833E+04, 5.5918E+04, &
       5.6004E+04, 5.6089E+04, 5.6175E+04, 5.6261E+04, 5.6347E+04, 5.6433E+04, 5.6519E+04, 5.6605E+04, 5.6691E+04, 5.6777E+04, &
       5.6864E+04, 5.6950E+04, 5.7037E+04, 5.7124E+04, 5.7210E+04, 5.7297E+04, 5.7384E+04, 5.7472E+04, 5.7559E+04, 5.7646E+04, &
       5.7734E+04, 5.7821E+04, 5.7909E+04, 5.7996E+04, 5.8084E+04, 5.8172E+04, 5.8260E+04, 5.8348E+04, 5.8437E+04, 5.8525E+04, &
       5.8613E+04, 5.8702E+04, 5.8791E+04, 5.8879E+04, 5.8968E+04, 5.9057E+04, 5.9146E+04, 5.9235E+04, 5.9325E+04, 5.9414E+04, &
       5.9503E+04, 5.9593E+04, 5.9683E+04, 5.9772E+04, 5.9862E+04, 5.9952E+04, 6.0042E+04, 6.0132E+04, 6.0223E+04, 6.0313E+04, &
       6.0404E+04, 6.0494E+04, 6.0585E+04, 6.0676E+04, 6.0766E+04, 6.0857E+04, 6.0948E+04, 6.1040E+04, 6.1131E+04, 6.1222E+04, &
       6.1314E+04, 6.1405E+04, 6.1497E+04, 6.1589E+04, 6.1681E+04, 6.1773E+04, 6.1865E+04, 6.1957E+04, 6.2049E+04, 6.2142E+04, &
       6.2234E+04, 6.2327E+04, 6.2420E+04, 6.2513E+04, 6.2606E+04, 6.2699E+04, 6.2792E+04, 6.2885E+04, 6.2978E+04, 6.3072E+04, &
       6.3165E+04, 6.3259E+04, 6.3353E+04, 6.3447E+04, 6.3541E+04, 6.3635E+04, 6.3729E+04, 6.3823E+04, 6.3918E+04, 6.4012E+04, &
       6.4107E+04, 6.4201E+04, 6.4296E+04, 6.4391E+04, 6.4486E+04, 6.4581E+04, 6.4676E+04, 6.4772E+04, 6.4867E+04, 6.4963E+04, &
       6.5058E+04, 6.5154E+04, 6.5250E+04, 6.5346E+04, 6.5442E+04, 6.5538E+04, 6.5634E+04, 6.5731E+04, 6.5827E+04, 6.5924E+04, &
       6.6021E+04, 6.6117E+04, 6.6214E+04, 6.6311E+04, 6.6409E+04, 6.6506E+04, 6.6603E+04, 6.6701E+04, 6.6798E+04, 6.6896E+04, &
       6.6993E+04, 6.7091E+04, 6.7189E+04, 6.7287E+04, 6.7386E+04, 6.7484E+04, 6.7582E+04, 6.7681E+04, 6.7779E+04, 6.7878E+04, &
       6.7977E+04, 6.8076E+04, 6.8175E+04, 6.8274E+04, 6.8373E+04, 6.8473E+04, 6.8572E+04, 6.8672E+04, 6.8771E+04, 6.8871E+04, &
       6.8971E+04, 6.9071E+04, 6.9171E+04, 6.9271E+04, 6.9372E+04, 6.9472E+04, 6.9573E+04, 6.9673E+04, 6.9774E+04, 6.9875E+04, &
       6.9976E+04, 7.0077E+04, 7.0178E+04, 7.0280E+04, 7.0381E+04, 7.0482E+04, 7.0584E+04, 7.0686E+04, 7.0788E+04, 7.0890E+04, &
       7.0992E+04, 7.1094E+04, 7.1196E+04, 7.1299E+04, 7.1401E+04, 7.1504E+04, 7.1606E+04, 7.1709E+04, 7.1812E+04, 7.1915E+04, &
       7.2018E+04, 7.2121E+04, 7.2225E+04, 7.2328E+04, 7.2432E+04, 7.2536E+04, 7.2639E+04, 7.2743E+04, 7.2847E+04, 7.2951E+04/
      data (QofT( 1,J),J=2409,4510)/ 7.3056E+04, 7.3160E+04, 7.3265E+04, 7.3369E+04, 7.3474E+04, 7.3579E+04, 7.3683E+04, 7.3788E+04, &
       7.3894E+04, 7.3999E+04, 7.4104E+04, 7.4210E+04, 7.4315E+04, 7.4421E+04, 7.4527E+04, 7.4633E+04, 7.4739E+04, 7.4845E+04, &
       7.4951E+04, 7.5057E+04, 7.5164E+04, 7.5270E+04, 7.5377E+04, 7.5484E+04, 7.5591E+04, 7.5698E+04, 7.5805E+04, 7.5912E+04, &
       7.6019E+04, 7.6127E+04, 7.6234E+04, 7.6342E+04, 7.6450E+04, 7.6558E+04, 7.6666E+04, 7.6774E+04, 7.6882E+04, 7.6990E+04, &
       7.7099E+04, 7.7207E+04, 7.7316E+04, 7.7425E+04, 7.7534E+04, 7.7643E+04, 7.7752E+04, 7.7861E+04, 7.7970E+04, 7.8080E+04, &
       7.8189E+04, 7.8299E+04, 7.8409E+04, 7.8519E+04, 7.8629E+04, 7.8739E+04, 7.8849E+04, 7.8959E+04, 7.9070E+04, 7.9180E+04, &
       7.9291E+04, 7.9402E+04, 7.9513E+04, 7.9624E+04, 7.9735E+04, 7.9846E+04, 7.9958E+04, 8.0069E+04, 8.0181E+04, 8.0293E+04, &
       8.0404E+04, 8.0516E+04, 8.0628E+04, 8.0740E+04, 8.0853E+04, 8.0965E+04, 8.1078E+04, 8.1190E+04, 8.1303E+04, 8.1416E+04, &
       8.1529E+04, 8.1642E+04, 8.1755E+04, 8.1868E+04, 8.1982E+04, 8.2095E+04, 8.2209E+04, 8.2323E+04, 8.2437E+04, 8.2551E+04, &
       8.2665E+04, 8.2779E+04, 8.2893E+04, 8.3008E+04, 8.3122E+04, 8.3237E+04, 8.3352E+04, 8.3467E+04, 8.3582E+04, 8.3697E+04, &
       8.3812E+04, 8.3927E+04, 8.4043E+04, 8.4159E+04, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       181
      data (QofT( 2,J),J=1,2408)/ 1.0000E+00, 1.0000E+00, 1.0001E+00, 1.0018E+00, 1.0098E+00, 1.0310E+00, 1.0714E+00, 1.1343E+00, &
       1.2213E+00, 1.3319E+00, 1.4650E+00, 1.6189E+00, 1.7914E+00, 1.9806E+00, 2.1846E+00, 2.4016E+00, 2.6303E+00, 2.8691E+00, &
       3.1169E+00, 3.3728E+00, 3.9054E+00, 4.4617E+00, 5.0378E+00, 5.6313E+00, 6.2404E+00, 6.8640E+00, 7.5014E+00, 8.1520E+00, &
       8.8157E+00, 9.4923E+00, 1.0182E+01, 1.0884E+01, 1.1599E+01, 1.2326E+01, 1.3066E+01, 1.3819E+01, 1.4585E+01, 1.5362E+01, &
       1.6153E+01, 1.6956E+01, 1.7771E+01, 1.8598E+01, 1.9437E+01, 2.0288E+01, 2.1151E+01, 2.2026E+01, 2.2913E+01, 2.3811E+01, &
       2.4720E+01, 2.5641E+01, 2.6573E+01, 2.7516E+01, 2.8470E+01, 2.9434E+01, 3.0410E+01, 3.1396E+01, 3.2392E+01, 3.3399E+01, &
       3.4417E+01, 3.5444E+01, 3.6482E+01, 3.7529E+01, 3.8587E+01, 3.9654E+01, 4.0731E+01, 4.1818E+01, 4.2915E+01, 4.4021E+01, &
       4.5136E+01, 4.6261E+01, 4.7395E+01, 4.8538E+01, 4.9691E+01, 5.0852E+01, 5.2023E+01, 5.3202E+01, 5.4390E+01, 5.5587E+01, &
       5.6793E+01, 5.8008E+01, 5.9231E+01, 6.0463E+01, 6.1703E+01, 6.2952E+01, 6.4209E+01, 6.5475E+01, 6.6748E+01, 6.8030E+01, &
       6.9321E+01, 7.0619E+01, 7.1926E+01, 7.3240E+01, 7.4563E+01, 7.5893E+01, 7.7232E+01, 7.8578E+01, 7.9932E+01, 8.1294E+01, &
       8.2664E+01, 8.4042E+01, 8.5427E+01, 8.6819E+01, 8.8220E+01, 8.9628E+01, 9.1043E+01, 9.2466E+01, 9.3896E+01, 9.5334E+01, &
       9.6779E+01, 9.8232E+01, 9.9691E+01, 1.0116E+02, 1.0263E+02, 1.0411E+02, 1.0560E+02, 1.0710E+02, 1.0860E+02, 1.1011E+02, &
       1.1163E+02, 1.1315E+02, 1.1468E+02, 1.1622E+02, 1.1777E+02, 1.1932E+02, 1.2088E+02, 1.2244E+02, 1.2402E+02, 1.2560E+02, &
       1.2718E+02, 1.2877E+02, 1.3037E+02, 1.3198E+02, 1.3359E+02, 1.3521E+02, 1.3684E+02, 1.3847E+02, 1.4011E+02, 1.4176E+02, &
       1.4341E+02, 1.4507E+02, 1.4674E+02, 1.4841E+02, 1.5009E+02, 1.5178E+02, 1.5347E+02, 1.5517E+02, 1.5687E+02, 1.5858E+02, &
       1.6030E+02, 1.6203E+02, 1.6376E+02, 1.6550E+02, 1.6724E+02, 1.6899E+02, 1.7075E+02, 1.7251E+02, 1.7428E+02, 1.7605E+02, &
       1.7783E+02, 1.7962E+02, 1.8142E+02, 1.8322E+02, 1.8502E+02, 1.8684E+02, 1.8866E+02, 1.9048E+02, 1.9231E+02, 1.9415E+02, &
       1.9599E+02, 1.9784E+02, 1.9970E+02, 2.0156E+02, 2.0343E+02, 2.0531E+02, 2.0719E+02, 2.0908E+02, 2.1097E+02, 2.1287E+02, &
       2.1478E+02, 2.1669E+02, 2.1861E+02, 2.2053E+02, 2.2246E+02, 2.2440E+02, 2.2634E+02, 2.2829E+02, 2.3024E+02, 2.3221E+02, &
       2.3417E+02, 2.3615E+02, 2.3813E+02, 2.4011E+02, 2.4210E+02, 2.4410E+02, 2.4611E+02, 2.4812E+02, 2.5013E+02, 2.5215E+02, &
       2.5418E+02, 2.5622E+02, 2.5826E+02, 2.6031E+02, 2.6236E+02, 2.6442E+02, 2.6648E+02, 2.6856E+02, 2.7063E+02, 2.7272E+02, &
       2.7481E+02, 2.7690E+02, 2.7900E+02, 2.8111E+02, 2.8323E+02, 2.8535E+02, 2.8748E+02, 2.8961E+02, 2.9175E+02, 2.9389E+02, &
       2.9604E+02, 2.9820E+02, 3.0037E+02, 3.0254E+02, 3.0471E+02, 3.0690E+02, 3.0908E+02, 3.1128E+02, 3.1348E+02, 3.1569E+02, &
       3.1790E+02, 3.2012E+02, 3.2235E+02, 3.2458E+02, 3.2682E+02, 3.2906E+02, 3.3131E+02, 3.3357E+02, 3.3584E+02, 3.3811E+02, &
       3.4038E+02, 3.4266E+02, 3.4495E+02, 3.4725E+02, 3.4955E+02, 3.5186E+02, 3.5417E+02, 3.5649E+02, 3.5882E+02, 3.6115E+02, &
       3.6349E+02, 3.6584E+02, 3.6819E+02, 3.7055E+02, 3.7292E+02, 3.7529E+02, 3.7767E+02, 3.8005E+02, 3.8244E+02, 3.8484E+02, &
       3.8724E+02, 3.8965E+02, 3.9207E+02, 3.9449E+02, 3.9692E+02, 3.9936E+02, 4.0180E+02, 4.0425E+02, 4.0671E+02, 4.0917E+02, &
       4.1164E+02, 4.1412E+02, 4.1660E+02, 4.1909E+02, 4.2158E+02, 4.2409E+02, 4.2659E+02, 4.2911E+02, 4.3163E+02, 4.3416E+02, &
       4.3669E+02, 4.3924E+02, 4.4179E+02, 4.4434E+02, 4.4690E+02, 4.4947E+02, 4.5205E+02, 4.5463E+02, 4.5722E+02, 4.5981E+02, &
       4.6242E+02, 4.6502E+02, 4.6764E+02, 4.7026E+02, 4.7289E+02, 4.7553E+02, 4.7817E+02, 4.8082E+02, 4.8348E+02, 4.8614E+02, &
       4.8881E+02, 4.9149E+02, 4.9418E+02, 4.9687E+02, 4.9957E+02, 5.0227E+02, 5.0498E+02, 5.0770E+02, 5.1043E+02, 5.1316E+02, &
       5.1590E+02, 5.1865E+02, 5.2141E+02, 5.2417E+02, 5.2693E+02, 5.2971E+02, 5.3249E+02, 5.3528E+02, 5.3808E+02, 5.4088E+02, &
       5.4369E+02, 5.4651E+02, 5.4934E+02, 5.5217E+02, 5.5501E+02, 5.5786E+02, 5.6071E+02, 5.6357E+02, 5.6644E+02, 5.6932E+02, &
       5.7220E+02, 5.7509E+02, 5.7799E+02, 5.8089E+02, 5.8380E+02, 5.8672E+02, 5.8965E+02, 5.9259E+02, 5.9553E+02, 5.9848E+02, &
       6.0143E+02, 6.0440E+02, 6.0737E+02, 6.1035E+02, 6.1333E+02, 6.1633E+02, 6.1933E+02, 6.2234E+02, 6.2535E+02, 6.2838E+02, &
       6.3141E+02, 6.3445E+02, 6.3749E+02, 6.4055E+02, 6.4361E+02, 6.4668E+02, 6.4975E+02, 6.5284E+02, 6.5593E+02, 6.5903E+02, &
       6.6214E+02, 6.6525E+02, 6.6838E+02, 6.7151E+02, 6.7465E+02, 6.7779E+02, 6.8095E+02, 6.8411E+02, 6.8728E+02, 6.9045E+02, &
       6.9364E+02, 6.9683E+02, 7.0003E+02, 7.0324E+02, 7.0646E+02, 7.0968E+02, 7.1292E+02, 7.1616E+02, 7.1940E+02, 7.2266E+02, &
       7.2593E+02, 7.2920E+02, 7.3248E+02, 7.3577E+02, 7.3906E+02, 7.4237E+02, 7.4568E+02, 7.4900E+02, 7.5233E+02, 7.5567E+02, &
       7.5901E+02, 7.6237E+02, 7.6573E+02, 7.6910E+02, 7.7248E+02, 7.7586E+02, 7.7926E+02, 7.8266E+02, 7.8607E+02, 7.8949E+02, &
       7.9292E+02, 7.9636E+02, 7.9980E+02, 8.0325E+02, 8.0671E+02, 8.1018E+02, 8.1366E+02, 8.1715E+02, 8.2064E+02, 8.2415E+02, &
       8.2766E+02, 8.3118E+02, 8.3471E+02, 8.3824E+02, 8.4179E+02, 8.4535E+02, 8.4891E+02, 8.5248E+02, 8.5606E+02, 8.5965E+02, &
       8.6325E+02, 8.6685E+02, 8.7047E+02, 8.7409E+02, 8.7773E+02, 8.8137E+02, 8.8502E+02, 8.8868E+02, 8.9234E+02, 8.9602E+02, &
       8.9970E+02, 9.0340E+02, 9.0710E+02, 9.1081E+02, 9.1453E+02, 9.1826E+02, 9.2200E+02, 9.2575E+02, 9.2951E+02, 9.3327E+02, &
       9.3705E+02, 9.4083E+02, 9.4462E+02, 9.4843E+02, 9.5224E+02, 9.5606E+02, 9.5989E+02, 9.6372E+02, 9.6757E+02, 9.7143E+02, &
       9.7529E+02, 9.7917E+02, 9.8305E+02, 9.8695E+02, 9.9085E+02, 9.9476E+02, 9.9868E+02, 1.0026E+03, 1.0066E+03, 1.0105E+03, &
       1.0145E+03, 1.0184E+03, 1.0224E+03, 1.0264E+03, 1.0304E+03, 1.0344E+03, 1.0384E+03, 1.0424E+03, 1.0465E+03, 1.0505E+03, &
       1.0546E+03, 1.0586E+03, 1.0627E+03, 1.0668E+03, 1.0709E+03, 1.0750E+03, 1.0791E+03, 1.0832E+03, 1.0874E+03, 1.0915E+03, &
       1.0956E+03, 1.0998E+03, 1.1040E+03, 1.1082E+03, 1.1123E+03, 1.1165E+03, 1.1208E+03, 1.1250E+03, 1.1292E+03, 1.1334E+03, &
       1.1377E+03, 1.1420E+03, 1.1462E+03, 1.1505E+03, 1.1548E+03, 1.1591E+03, 1.1634E+03, 1.1677E+03, 1.1721E+03, 1.1764E+03, &
       1.1807E+03, 1.1851E+03, 1.1895E+03, 1.1939E+03, 1.1982E+03, 1.2026E+03, 1.2071E+03, 1.2115E+03, 1.2159E+03, 1.2204E+03, &
       1.2248E+03, 1.2293E+03, 1.2337E+03, 1.2382E+03, 1.2427E+03, 1.2472E+03, 1.2518E+03, 1.2563E+03, 1.2608E+03, 1.2654E+03, &
       1.2699E+03, 1.2745E+03, 1.2791E+03, 1.2837E+03, 1.2883E+03, 1.2929E+03, 1.2975E+03, 1.3021E+03, 1.3068E+03, 1.3114E+03, &
       1.3161E+03, 1.3208E+03, 1.3255E+03, 1.3302E+03, 1.3349E+03, 1.3396E+03, 1.3443E+03, 1.3491E+03, 1.3538E+03, 1.3586E+03, &
       1.3633E+03, 1.3681E+03, 1.3729E+03, 1.3777E+03, 1.3826E+03, 1.3874E+03, 1.3922E+03, 1.3971E+03, 1.4019E+03, 1.4068E+03, &
       1.4117E+03, 1.4166E+03, 1.4215E+03, 1.4264E+03, 1.4314E+03, 1.4363E+03, 1.4413E+03, 1.4462E+03, 1.4512E+03, 1.4562E+03, &
       1.4612E+03, 1.4662E+03, 1.4712E+03, 1.4763E+03, 1.4813E+03, 1.4864E+03, 1.4914E+03, 1.4965E+03, 1.5016E+03, 1.5067E+03, &
       1.5118E+03, 1.5170E+03, 1.5221E+03, 1.5272E+03, 1.5324E+03, 1.5376E+03, 1.5428E+03, 1.5480E+03, 1.5532E+03, 1.5584E+03, &
       1.5636E+03, 1.5689E+03, 1.5741E+03, 1.5794E+03, 1.5847E+03, 1.5900E+03, 1.5953E+03, 1.6006E+03, 1.6059E+03, 1.6113E+03, &
       1.6166E+03, 1.6220E+03, 1.6274E+03, 1.6328E+03, 1.6382E+03, 1.6436E+03, 1.6490E+03, 1.6544E+03, 1.6599E+03, 1.6654E+03, &
       1.6708E+03, 1.6763E+03, 1.6818E+03, 1.6873E+03, 1.6929E+03, 1.6984E+03, 1.7040E+03, 1.7095E+03, 1.7151E+03, 1.7207E+03, &
       1.7263E+03, 1.7319E+03, 1.7375E+03, 1.7432E+03, 1.7488E+03, 1.7545E+03, 1.7602E+03, 1.7659E+03, 1.7716E+03, 1.7773E+03, &
       1.7830E+03, 1.7888E+03, 1.7945E+03, 1.8003E+03, 1.8061E+03, 1.8119E+03, 1.8177E+03, 1.8235E+03, 1.8293E+03, 1.8352E+03, &
       1.8410E+03, 1.8469E+03, 1.8528E+03, 1.8587E+03, 1.8646E+03, 1.8705E+03, 1.8764E+03, 1.8824E+03, 1.8884E+03, 1.8943E+03, &
       1.9003E+03, 1.9063E+03, 1.9124E+03, 1.9184E+03, 1.9244E+03, 1.9305E+03, 1.9366E+03, 1.9426E+03, 1.9487E+03, 1.9549E+03, &
       1.9610E+03, 1.9671E+03, 1.9733E+03, 1.9794E+03, 1.9856E+03, 1.9918E+03, 1.9980E+03, 2.0042E+03, 2.0105E+03, 2.0167E+03, &
       2.0230E+03, 2.0293E+03, 2.0356E+03, 2.0419E+03, 2.0482E+03, 2.0545E+03, 2.0609E+03, 2.0672E+03, 2.0736E+03, 2.0800E+03, &
       2.0864E+03, 2.0928E+03, 2.0992E+03, 2.1057E+03, 2.1121E+03, 2.1186E+03, 2.1251E+03, 2.1316E+03, 2.1381E+03, 2.1447E+03, &
       2.1512E+03, 2.1578E+03, 2.1643E+03, 2.1709E+03, 2.1775E+03, 2.1841E+03, 2.1908E+03, 2.1974E+03, 2.2041E+03, 2.2108E+03, &
       2.2175E+03, 2.2242E+03, 2.2309E+03, 2.2376E+03, 2.2444E+03, 2.2511E+03, 2.2579E+03, 2.2647E+03, 2.2715E+03, 2.2783E+03, &
       2.2852E+03, 2.2920E+03, 2.2989E+03, 2.3058E+03, 2.3127E+03, 2.3196E+03, 2.3265E+03, 2.3334E+03, 2.3404E+03, 2.3474E+03, &
       2.3544E+03, 2.3614E+03, 2.3684E+03, 2.3754E+03, 2.3825E+03, 2.3895E+03, 2.3966E+03, 2.4037E+03, 2.4108E+03, 2.4179E+03, &
       2.4251E+03, 2.4322E+03, 2.4394E+03, 2.4466E+03, 2.4538E+03, 2.4610E+03, 2.4682E+03, 2.4755E+03, 2.4827E+03, 2.4900E+03, &
       2.4973E+03, 2.5046E+03, 2.5120E+03, 2.5193E+03, 2.5267E+03, 2.5340E+03, 2.5414E+03, 2.5488E+03, 2.5562E+03, 2.5637E+03, &
       2.5711E+03, 2.5786E+03, 2.5861E+03, 2.5936E+03, 2.6011E+03, 2.6086E+03, 2.6162E+03, 2.6238E+03, 2.6313E+03, 2.6389E+03, &
       2.6466E+03, 2.6542E+03, 2.6618E+03, 2.6695E+03, 2.6772E+03, 2.6849E+03, 2.6926E+03, 2.7003E+03, 2.7080E+03, 2.7158E+03, &
       2.7236E+03, 2.7314E+03, 2.7392E+03, 2.7470E+03, 2.7549E+03, 2.7627E+03, 2.7706E+03, 2.7785E+03, 2.7864E+03, 2.7943E+03, &
       2.8023E+03, 2.8102E+03, 2.8182E+03, 2.8262E+03, 2.8342E+03, 2.8422E+03, 2.8503E+03, 2.8583E+03, 2.8664E+03, 2.8745E+03, &
       2.8826E+03, 2.8908E+03, 2.8989E+03, 2.9071E+03, 2.9153E+03, 2.9235E+03, 2.9317E+03, 2.9399E+03, 2.9482E+03, 2.9564E+03, &
       2.9647E+03, 2.9730E+03, 2.9813E+03, 2.9897E+03, 2.9980E+03, 3.0064E+03, 3.0148E+03, 3.0232E+03, 3.0316E+03, 3.0400E+03, &
       3.0485E+03, 3.0570E+03, 3.0655E+03, 3.0740E+03, 3.0825E+03, 3.0911E+03, 3.0996E+03, 3.1082E+03, 3.1168E+03, 3.1254E+03, &
       3.1341E+03, 3.1427E+03, 3.1514E+03, 3.1601E+03, 3.1688E+03, 3.1775E+03, 3.1863E+03, 3.1950E+03, 3.2038E+03, 3.2126E+03, &
       3.2214E+03, 3.2303E+03, 3.2391E+03, 3.2480E+03, 3.2569E+03, 3.2658E+03, 3.2747E+03, 3.2837E+03, 3.2926E+03, 3.3016E+03, &
       3.3106E+03, 3.3196E+03, 3.3287E+03, 3.3377E+03, 3.3468E+03, 3.3559E+03, 3.3650E+03, 3.3741E+03, 3.3833E+03, 3.3924E+03, &
       3.4016E+03, 3.4108E+03, 3.4201E+03, 3.4293E+03, 3.4386E+03, 3.4478E+03, 3.4571E+03, 3.4665E+03, 3.4758E+03, 3.4852E+03, &
       3.4945E+03, 3.5039E+03, 3.5133E+03, 3.5228E+03, 3.5322E+03, 3.5417E+03, 3.5512E+03, 3.5607E+03, 3.5702E+03, 3.5798E+03, &
       3.5894E+03, 3.5989E+03, 3.6086E+03, 3.6182E+03, 3.6278E+03, 3.6375E+03, 3.6472E+03, 3.6569E+03, 3.6666E+03, 3.6763E+03, &
       3.6861E+03, 3.6959E+03, 3.7057E+03, 3.7155E+03, 3.7254E+03, 3.7352E+03, 3.7451E+03, 3.7550E+03, 3.7649E+03, 3.7749E+03, &
       3.7848E+03, 3.7948E+03, 3.8048E+03, 3.8148E+03, 3.8249E+03, 3.8350E+03, 3.8450E+03, 3.8551E+03, 3.8653E+03, 3.8754E+03, &
       3.8856E+03, 3.8958E+03, 3.9060E+03, 3.9162E+03, 3.9264E+03, 3.9367E+03, 3.9470E+03, 3.9573E+03, 3.9676E+03, 3.9780E+03, &
       3.9883E+03, 3.9987E+03, 4.0091E+03, 4.0196E+03, 4.0300E+03, 4.0405E+03, 4.0510E+03, 4.0615E+03, 4.0720E+03, 4.0826E+03, &
       4.0932E+03, 4.1038E+03, 4.1144E+03, 4.1250E+03, 4.1357E+03, 4.1464E+03, 4.1571E+03, 4.1678E+03, 4.1785E+03, 4.1893E+03, &
       4.2001E+03, 4.2109E+03, 4.2217E+03, 4.2326E+03, 4.2434E+03, 4.2543E+03, 4.2652E+03, 4.2762E+03, 4.2871E+03, 4.2981E+03, &
       4.3091E+03, 4.3201E+03, 4.3312E+03, 4.3423E+03, 4.3533E+03, 4.3645E+03, 4.3756E+03, 4.3867E+03, 4.3979E+03, 4.4091E+03, &
       4.4203E+03, 4.4316E+03, 4.4428E+03, 4.4541E+03, 4.4654E+03, 4.4768E+03, 4.4881E+03, 4.4995E+03, 4.5109E+03, 4.5223E+03, &
       4.5337E+03, 4.5452E+03, 4.5567E+03, 4.5682E+03, 4.5797E+03, 4.5913E+03, 4.6028E+03, 4.6144E+03, 4.6261E+03, 4.6377E+03, &
       4.6494E+03, 4.6610E+03, 4.6728E+03, 4.6845E+03, 4.6962E+03, 4.7080E+03, 4.7198E+03, 4.7316E+03, 4.7435E+03, 4.7554E+03, &
       4.7672E+03, 4.7792E+03, 4.7911E+03, 4.8031E+03, 4.8150E+03, 4.8270E+03, 4.8391E+03, 4.8511E+03, 4.8632E+03, 4.8753E+03, &
       4.8874E+03, 4.8996E+03, 4.9117E+03, 4.9239E+03, 4.9361E+03, 4.9484E+03, 4.9606E+03, 4.9729E+03, 4.9852E+03, 4.9976E+03, &
       5.0099E+03, 5.0223E+03, 5.0347E+03, 5.0471E+03, 5.0596E+03, 5.0720E+03, 5.0845E+03, 5.0971E+03, 5.1096E+03, 5.1222E+03, &
       5.1348E+03, 5.1474E+03, 5.1600E+03, 5.1727E+03, 5.1854E+03, 5.1981E+03, 5.2108E+03, 5.2236E+03, 5.2364E+03, 5.2492E+03, &
       5.2620E+03, 5.2749E+03, 5.2878E+03, 5.3007E+03, 5.3136E+03, 5.3266E+03, 5.3395E+03, 5.3525E+03, 5.3656E+03, 5.3786E+03, &
       5.3917E+03, 5.4048E+03, 5.4179E+03, 5.4311E+03, 5.4443E+03, 5.4575E+03, 5.4707E+03, 5.4839E+03, 5.4972E+03, 5.5105E+03, &
       5.5239E+03, 5.5372E+03, 5.5506E+03, 5.5640E+03, 5.5774E+03, 5.5909E+03, 5.6043E+03, 5.6178E+03, 5.6314E+03, 5.6449E+03, &
       5.6585E+03, 5.6721E+03, 5.6857E+03, 5.6994E+03, 5.7131E+03, 5.7268E+03, 5.7405E+03, 5.7542E+03, 5.7680E+03, 5.7818E+03, &
       5.7957E+03, 5.8095E+03, 5.8234E+03, 5.8373E+03, 5.8513E+03, 5.8652E+03, 5.8792E+03, 5.8932E+03, 5.9073E+03, 5.9213E+03, &
       5.9354E+03, 5.9495E+03, 5.9637E+03, 5.9778E+03, 5.9920E+03, 6.0063E+03, 6.0205E+03, 6.0348E+03, 6.0491E+03, 6.0634E+03, &
       6.0778E+03, 6.0921E+03, 6.1065E+03, 6.1210E+03, 6.1354E+03, 6.1499E+03, 6.1644E+03, 6.1790E+03, 6.1935E+03, 6.2081E+03, &
       6.2227E+03, 6.2374E+03, 6.2521E+03, 6.2668E+03, 6.2815E+03, 6.2962E+03, 6.3110E+03, 6.3258E+03, 6.3407E+03, 6.3555E+03, &
       6.3704E+03, 6.3853E+03, 6.4003E+03, 6.4152E+03, 6.4302E+03, 6.4453E+03, 6.4603E+03, 6.4754E+03, 6.4905E+03, 6.5056E+03, &
       6.5208E+03, 6.5360E+03, 6.5512E+03, 6.5665E+03, 6.5817E+03, 6.5970E+03, 6.6124E+03, 6.6277E+03, 6.6431E+03, 6.6585E+03, &
       6.6739E+03, 6.6894E+03, 6.7049E+03, 6.7204E+03, 6.7360E+03, 6.7516E+03, 6.7672E+03, 6.7828E+03, 6.7985E+03, 6.8141E+03, &
       6.8299E+03, 6.8456E+03, 6.8614E+03, 6.8772E+03, 6.8930E+03, 6.9089E+03, 6.9248E+03, 6.9407E+03, 6.9566E+03, 6.9726E+03, &
       6.9886E+03, 7.0047E+03, 7.0207E+03, 7.0368E+03, 7.0529E+03, 7.0691E+03, 7.0852E+03, 7.1015E+03, 7.1177E+03, 7.1340E+03, &
       7.1502E+03, 7.1666E+03, 7.1829E+03, 7.1993E+03, 7.2157E+03, 7.2321E+03, 7.2486E+03, 7.2651E+03, 7.2816E+03, 7.2982E+03, &
       7.3148E+03, 7.3314E+03, 7.3480E+03, 7.3647E+03, 7.3814E+03, 7.3981E+03, 7.4149E+03, 7.4317E+03, 7.4485E+03, 7.4654E+03, &
       7.4822E+03, 7.4992E+03, 7.5161E+03, 7.5331E+03, 7.5501E+03, 7.5671E+03, 7.5842E+03, 7.6012E+03, 7.6184E+03, 7.6355E+03, &
       7.6527E+03, 7.6699E+03, 7.6871E+03, 7.7044E+03, 7.7217E+03, 7.7391E+03, 7.7564E+03, 7.7738E+03, 7.7912E+03, 7.8087E+03, &
       7.8262E+03, 7.8437E+03, 7.8612E+03, 7.8788E+03, 7.8964E+03, 7.9141E+03, 7.9317E+03, 7.9494E+03, 7.9672E+03, 7.9849E+03, &
       8.0027E+03, 8.0205E+03, 8.0384E+03, 8.0563E+03, 8.0742E+03, 8.0921E+03, 8.1101E+03, 8.1281E+03, 8.1462E+03, 8.1642E+03, &
       8.1824E+03, 8.2005E+03, 8.2187E+03, 8.2369E+03, 8.2551E+03, 8.2734E+03, 8.2916E+03, 8.3100E+03, 8.3283E+03, 8.3467E+03, &
       8.3651E+03, 8.3836E+03, 8.4021E+03, 8.4206E+03, 8.4391E+03, 8.4577E+03, 8.4763E+03, 8.4950E+03, 8.5137E+03, 8.5324E+03, &
       8.5511E+03, 8.5699E+03, 8.5887E+03, 8.6075E+03, 8.6264E+03, 8.6453E+03, 8.6642E+03, 8.6832E+03, 8.7022E+03, 8.7212E+03, &
       8.7403E+03, 8.7594E+03, 8.7785E+03, 8.7977E+03, 8.8169E+03, 8.8361E+03, 8.8554E+03, 8.8747E+03, 8.8940E+03, 8.9134E+03, &
       8.9328E+03, 8.9522E+03, 8.9717E+03, 8.9911E+03, 9.0107E+03, 9.0302E+03, 9.0498E+03, 9.0695E+03, 9.0891E+03, 9.1088E+03, &
       9.1285E+03, 9.1483E+03, 9.1681E+03, 9.1879E+03, 9.2078E+03, 9.2277E+03, 9.2476E+03, 9.2676E+03, 9.2876E+03, 9.3076E+03, &
       9.3277E+03, 9.3478E+03, 9.3679E+03, 9.3881E+03, 9.4083E+03, 9.4285E+03, 9.4488E+03, 9.4691E+03, 9.4894E+03, 9.5098E+03, &
       9.5302E+03, 9.5506E+03, 9.5711E+03, 9.5916E+03, 9.6121E+03, 9.6327E+03, 9.6533E+03, 9.6740E+03, 9.6947E+03, 9.7154E+03, &
       9.7361E+03, 9.7569E+03, 9.7777E+03, 9.7986E+03, 9.8195E+03, 9.8404E+03, 9.8614E+03, 9.8824E+03, 9.9034E+03, 9.9245E+03, &
       9.9456E+03, 9.9667E+03, 9.9879E+03, 1.0009E+04, 1.0030E+04, 1.0052E+04, 1.0073E+04, 1.0094E+04, 1.0116E+04, 1.0137E+04, &
       1.0159E+04, 1.0180E+04, 1.0202E+04, 1.0223E+04, 1.0245E+04, 1.0266E+04, 1.0288E+04, 1.0310E+04, 1.0331E+04, 1.0353E+04, &
       1.0375E+04, 1.0397E+04, 1.0419E+04, 1.0441E+04, 1.0463E+04, 1.0485E+04, 1.0507E+04, 1.0529E+04, 1.0551E+04, 1.0573E+04, &
       1.0595E+04, 1.0617E+04, 1.0640E+04, 1.0662E+04, 1.0684E+04, 1.0707E+04, 1.0729E+04, 1.0751E+04, 1.0774E+04, 1.0796E+04, &
       1.0819E+04, 1.0842E+04, 1.0864E+04, 1.0887E+04, 1.0909E+04, 1.0932E+04, 1.0955E+04, 1.0978E+04, 1.1001E+04, 1.1024E+04, &
       1.1046E+04, 1.1069E+04, 1.1092E+04, 1.1115E+04, 1.1138E+04, 1.1162E+04, 1.1185E+04, 1.1208E+04, 1.1231E+04, 1.1254E+04, &
       1.1278E+04, 1.1301E+04, 1.1324E+04, 1.1348E+04, 1.1371E+04, 1.1395E+04, 1.1418E+04, 1.1442E+04, 1.1465E+04, 1.1489E+04, &
       1.1513E+04, 1.1536E+04, 1.1560E+04, 1.1584E+04, 1.1608E+04, 1.1632E+04, 1.1656E+04, 1.1679E+04, 1.1703E+04, 1.1727E+04, &
       1.1752E+04, 1.1776E+04, 1.1800E+04, 1.1824E+04, 1.1848E+04, 1.1872E+04, 1.1897E+04, 1.1921E+04, 1.1945E+04, 1.1970E+04, &
       1.1994E+04, 1.2019E+04, 1.2043E+04, 1.2068E+04, 1.2092E+04, 1.2117E+04, 1.2142E+04, 1.2167E+04, 1.2191E+04, 1.2216E+04, &
       1.2241E+04, 1.2266E+04, 1.2291E+04, 1.2316E+04, 1.2341E+04, 1.2366E+04, 1.2391E+04, 1.2416E+04, 1.2441E+04, 1.2466E+04, &
       1.2492E+04, 1.2517E+04, 1.2542E+04, 1.2568E+04, 1.2593E+04, 1.2618E+04, 1.2644E+04, 1.2669E+04, 1.2695E+04, 1.2721E+04, &
       1.2746E+04, 1.2772E+04, 1.2798E+04, 1.2823E+04, 1.2849E+04, 1.2875E+04, 1.2901E+04, 1.2927E+04, 1.2953E+04, 1.2979E+04, &
       1.3005E+04, 1.3031E+04, 1.3057E+04, 1.3083E+04, 1.3110E+04, 1.3136E+04, 1.3162E+04, 1.3189E+04, 1.3215E+04, 1.3241E+04, &
       1.3268E+04, 1.3294E+04, 1.3321E+04, 1.3348E+04, 1.3374E+04, 1.3401E+04, 1.3428E+04, 1.3454E+04, 1.3481E+04, 1.3508E+04, &
       1.3535E+04, 1.3562E+04, 1.3589E+04, 1.3616E+04, 1.3643E+04, 1.3670E+04, 1.3697E+04, 1.3724E+04, 1.3752E+04, 1.3779E+04, &
       1.3806E+04, 1.3833E+04, 1.3861E+04, 1.3888E+04, 1.3916E+04, 1.3943E+04, 1.3971E+04, 1.3999E+04, 1.4026E+04, 1.4054E+04, &
       1.4082E+04, 1.4109E+04, 1.4137E+04, 1.4165E+04, 1.4193E+04, 1.4221E+04, 1.4249E+04, 1.4277E+04, 1.4305E+04, 1.4333E+04, &
       1.4361E+04, 1.4390E+04, 1.4418E+04, 1.4446E+04, 1.4475E+04, 1.4503E+04, 1.4531E+04, 1.4560E+04, 1.4588E+04, 1.4617E+04, &
       1.4646E+04, 1.4674E+04, 1.4703E+04, 1.4732E+04, 1.4761E+04, 1.4789E+04, 1.4818E+04, 1.4847E+04, 1.4876E+04, 1.4905E+04, &
       1.4934E+04, 1.4963E+04, 1.4992E+04, 1.5022E+04, 1.5051E+04, 1.5080E+04, 1.5110E+04, 1.5139E+04, 1.5168E+04, 1.5198E+04, &
       1.5227E+04, 1.5257E+04, 1.5286E+04, 1.5316E+04, 1.5346E+04, 1.5375E+04, 1.5405E+04, 1.5435E+04, 1.5465E+04, 1.5495E+04, &
       1.5525E+04, 1.5555E+04, 1.5585E+04, 1.5615E+04, 1.5645E+04, 1.5675E+04, 1.5706E+04, 1.5736E+04, 1.5766E+04, 1.5797E+04, &
       1.5827E+04, 1.5857E+04, 1.5888E+04, 1.5919E+04, 1.5949E+04, 1.5980E+04, 1.6010E+04, 1.6041E+04, 1.6072E+04, 1.6103E+04, &
       1.6134E+04, 1.6165E+04, 1.6196E+04, 1.6227E+04, 1.6258E+04, 1.6289E+04, 1.6320E+04, 1.6351E+04, 1.6382E+04, 1.6414E+04, &
       1.6445E+04, 1.6477E+04, 1.6508E+04, 1.6539E+04, 1.6571E+04, 1.6603E+04, 1.6634E+04, 1.6666E+04, 1.6698E+04, 1.6729E+04, &
       1.6761E+04, 1.6793E+04, 1.6825E+04, 1.6857E+04, 1.6889E+04, 1.6921E+04, 1.6953E+04, 1.6985E+04, 1.7018E+04, 1.7050E+04, &
       1.7082E+04, 1.7115E+04, 1.7147E+04, 1.7179E+04, 1.7212E+04, 1.7244E+04, 1.7277E+04, 1.7310E+04, 1.7342E+04, 1.7375E+04, &
       1.7408E+04, 1.7441E+04, 1.7474E+04, 1.7507E+04, 1.7540E+04, 1.7573E+04, 1.7606E+04, 1.7639E+04, 1.7672E+04, 1.7705E+04, &
       1.7739E+04, 1.7772E+04, 1.7805E+04, 1.7839E+04, 1.7872E+04, 1.7906E+04, 1.7939E+04, 1.7973E+04, 1.8007E+04, 1.8040E+04, &
       1.8074E+04, 1.8108E+04, 1.8142E+04, 1.8176E+04, 1.8210E+04, 1.8244E+04, 1.8278E+04, 1.8312E+04, 1.8346E+04, 1.8380E+04, &
       1.8415E+04, 1.8449E+04, 1.8483E+04, 1.8518E+04, 1.8552E+04, 1.8587E+04, 1.8621E+04, 1.8656E+04, 1.8691E+04, 1.8725E+04, &
       1.8760E+04, 1.8795E+04, 1.8830E+04, 1.8865E+04, 1.8900E+04, 1.8935E+04, 1.8970E+04, 1.9005E+04, 1.9040E+04, 1.9075E+04, &
       1.9111E+04, 1.9146E+04, 1.9182E+04, 1.9217E+04, 1.9252E+04, 1.9288E+04, 1.9324E+04, 1.9359E+04, 1.9395E+04, 1.9431E+04, &
       1.9467E+04, 1.9502E+04, 1.9538E+04, 1.9574E+04, 1.9610E+04, 1.9646E+04, 1.9683E+04, 1.9719E+04, 1.9755E+04, 1.9791E+04, &
       1.9828E+04, 1.9864E+04, 1.9900E+04, 1.9937E+04, 1.9973E+04, 2.0010E+04, 2.0047E+04, 2.0083E+04, 2.0120E+04, 2.0157E+04, &
       2.0194E+04, 2.0231E+04, 2.0268E+04, 2.0305E+04, 2.0342E+04, 2.0379E+04, 2.0416E+04, 2.0453E+04, 2.0491E+04, 2.0528E+04, &
       2.0565E+04, 2.0603E+04, 2.0640E+04, 2.0678E+04, 2.0716E+04, 2.0753E+04, 2.0791E+04, 2.0829E+04, 2.0866E+04, 2.0904E+04, &
       2.0942E+04, 2.0980E+04, 2.1018E+04, 2.1056E+04, 2.1095E+04, 2.1133E+04, 2.1171E+04, 2.1209E+04, 2.1248E+04, 2.1286E+04, &
       2.1325E+04, 2.1363E+04, 2.1402E+04, 2.1440E+04, 2.1479E+04, 2.1518E+04, 2.1557E+04, 2.1596E+04, 2.1634E+04, 2.1673E+04, &
       2.1712E+04, 2.1752E+04, 2.1791E+04, 2.1830E+04, 2.1869E+04, 2.1908E+04, 2.1948E+04, 2.1987E+04, 2.2027E+04, 2.2066E+04, &
       2.2106E+04, 2.2145E+04, 2.2185E+04, 2.2225E+04, 2.2265E+04, 2.2305E+04, 2.2345E+04, 2.2385E+04, 2.2425E+04, 2.2465E+04, &
       2.2505E+04, 2.2545E+04, 2.2585E+04, 2.2626E+04, 2.2666E+04, 2.2706E+04, 2.2747E+04, 2.2787E+04, 2.2828E+04, 2.2869E+04, &
       2.2909E+04, 2.2950E+04, 2.2991E+04, 2.3032E+04, 2.3073E+04, 2.3114E+04, 2.3155E+04, 2.3196E+04, 2.3237E+04, 2.3278E+04, &
       2.3320E+04, 2.3361E+04, 2.3402E+04, 2.3444E+04, 2.3485E+04, 2.3527E+04, 2.3569E+04, 2.3610E+04, 2.3652E+04, 2.3694E+04, &
       2.3736E+04, 2.3778E+04, 2.3820E+04, 2.3862E+04, 2.3904E+04, 2.3946E+04, 2.3988E+04, 2.4030E+04, 2.4073E+04, 2.4115E+04, &
       2.4158E+04, 2.4200E+04, 2.4243E+04, 2.4285E+04, 2.4328E+04, 2.4371E+04, 2.4414E+04, 2.4456E+04, 2.4499E+04, 2.4542E+04, &
       2.4585E+04, 2.4629E+04, 2.4672E+04, 2.4715E+04, 2.4758E+04, 2.4802E+04, 2.4845E+04, 2.4888E+04, 2.4932E+04, 2.4975E+04, &
       2.5019E+04, 2.5063E+04, 2.5107E+04, 2.5150E+04, 2.5194E+04, 2.5238E+04, 2.5282E+04, 2.5326E+04, 2.5370E+04, 2.5415E+04, &
       2.5459E+04, 2.5503E+04, 2.5547E+04, 2.5592E+04, 2.5636E+04, 2.5681E+04, 2.5726E+04, 2.5770E+04, 2.5815E+04, 2.5860E+04, &
       2.5905E+04, 2.5950E+04, 2.5994E+04, 2.6040E+04, 2.6085E+04, 2.6130E+04, 2.6175E+04, 2.6220E+04, 2.6266E+04, 2.6311E+04, &
       2.6356E+04, 2.6402E+04, 2.6448E+04, 2.6493E+04, 2.6539E+04, 2.6585E+04, 2.6631E+04, 2.6676E+04, 2.6722E+04, 2.6768E+04, &
       2.6815E+04, 2.6861E+04, 2.6907E+04, 2.6953E+04, 2.6999E+04, 2.7046E+04, 2.7092E+04, 2.7139E+04, 2.7185E+04, 2.7232E+04, &
       2.7279E+04, 2.7326E+04, 2.7372E+04, 2.7419E+04, 2.7466E+04, 2.7513E+04, 2.7560E+04, 2.7608E+04, 2.7655E+04, 2.7702E+04, &
       2.7749E+04, 2.7797E+04, 2.7844E+04, 2.7892E+04, 2.7939E+04, 2.7987E+04, 2.8035E+04, 2.8083E+04, 2.8130E+04, 2.8178E+04, &
       2.8226E+04, 2.8274E+04, 2.8323E+04, 2.8371E+04, 2.8419E+04, 2.8467E+04, 2.8516E+04, 2.8564E+04, 2.8613E+04, 2.8661E+04, &
       2.8710E+04, 2.8758E+04, 2.8807E+04, 2.8856E+04, 2.8905E+04, 2.8954E+04, 2.9003E+04, 2.9052E+04, 2.9101E+04, 2.9150E+04, &
       2.9200E+04, 2.9249E+04, 2.9298E+04, 2.9348E+04, 2.9397E+04, 2.9447E+04, 2.9497E+04, 2.9546E+04, 2.9596E+04, 2.9646E+04, &
       2.9696E+04, 2.9746E+04, 2.9796E+04, 2.9846E+04, 2.9896E+04, 2.9947E+04, 2.9997E+04, 3.0047E+04, 3.0098E+04, 3.0148E+04, &
       3.0199E+04, 3.0250E+04, 3.0300E+04, 3.0351E+04, 3.0402E+04, 3.0453E+04, 3.0504E+04, 3.0555E+04, 3.0606E+04, 3.0657E+04, &
       3.0709E+04, 3.0760E+04, 3.0811E+04, 3.0863E+04, 3.0914E+04, 3.0966E+04, 3.1018E+04, 3.1069E+04, 3.1121E+04, 3.1173E+04, &
       3.1225E+04, 3.1277E+04, 3.1329E+04, 3.1381E+04, 3.1433E+04, 3.1486E+04, 3.1538E+04, 3.1590E+04, 3.1643E+04, 3.1695E+04, &
       3.1748E+04, 3.1801E+04, 3.1854E+04, 3.1906E+04, 3.1959E+04, 3.2012E+04, 3.2065E+04, 3.2118E+04, 3.2171E+04, 3.2225E+04, &
       3.2278E+04, 3.2331E+04, 3.2385E+04, 3.2438E+04, 3.2492E+04, 3.2546E+04, 3.2599E+04, 3.2653E+04, 3.2707E+04, 3.2761E+04, &
       3.2815E+04, 3.2869E+04, 3.2923E+04, 3.2977E+04, 3.3032E+04, 3.3086E+04, 3.3140E+04, 3.3195E+04, 3.3250E+04, 3.3304E+04, &
       3.3359E+04, 3.3414E+04, 3.3468E+04, 3.3523E+04, 3.3578E+04, 3.3633E+04, 3.3689E+04, 3.3744E+04, 3.3799E+04, 3.3854E+04, &
       3.3910E+04, 3.3965E+04, 3.4021E+04, 3.4076E+04, 3.4132E+04, 3.4188E+04, 3.4244E+04, 3.4300E+04, 3.4356E+04, 3.4412E+04, &
       3.4468E+04, 3.4524E+04, 3.4580E+04, 3.4637E+04, 3.4693E+04, 3.4749E+04, 3.4806E+04, 3.4863E+04, 3.4919E+04, 3.4976E+04, &
       3.5033E+04, 3.5090E+04, 3.5147E+04, 3.5204E+04, 3.5261E+04, 3.5318E+04, 3.5376E+04, 3.5433E+04, 3.5490E+04, 3.5548E+04, &
       3.5605E+04, 3.5663E+04, 3.5721E+04, 3.5779E+04, 3.5836E+04, 3.5894E+04, 3.5952E+04, 3.6010E+04, 3.6069E+04, 3.6127E+04, &
       3.6185E+04, 3.6243E+04, 3.6302E+04, 3.6360E+04, 3.6419E+04, 3.6478E+04, 3.6536E+04, 3.6595E+04, 3.6654E+04, 3.6713E+04, &
       3.6772E+04, 3.6831E+04, 3.6890E+04, 3.6950E+04, 3.7009E+04, 3.7068E+04, 3.7128E+04, 3.7187E+04, 3.7247E+04, 3.7307E+04, &
       3.7367E+04, 3.7426E+04, 3.7486E+04, 3.7546E+04, 3.7606E+04, 3.7667E+04, 3.7727E+04, 3.7787E+04, 3.7848E+04, 3.7908E+04, &
       3.7969E+04, 3.8029E+04, 3.8090E+04, 3.8151E+04, 3.8211E+04, 3.8272E+04, 3.8333E+04, 3.8394E+04, 3.8456E+04, 3.8517E+04, &
       3.8578E+04, 3.8639E+04, 3.8701E+04, 3.8762E+04, 3.8824E+04, 3.8886E+04, 3.8947E+04, 3.9009E+04, 3.9071E+04, 3.9133E+04, &
       3.9195E+04, 3.9257E+04, 3.9320E+04, 3.9382E+04, 3.9444E+04, 3.9507E+04, 3.9569E+04, 3.9632E+04, 3.9694E+04, 3.9757E+04, &
       3.9820E+04, 3.9883E+04, 3.9946E+04, 4.0009E+04, 4.0072E+04, 4.0135E+04, 4.0199E+04, 4.0262E+04, 4.0325E+04, 4.0389E+04, &
       4.0453E+04, 4.0516E+04, 4.0580E+04, 4.0644E+04, 4.0708E+04, 4.0772E+04, 4.0836E+04, 4.0900E+04, 4.0964E+04, 4.1028E+04, &
       4.1093E+04, 4.1157E+04, 4.1222E+04, 4.1286E+04, 4.1351E+04, 4.1416E+04, 4.1481E+04, 4.1546E+04, 4.1611E+04, 4.1676E+04, &
       4.1741E+04, 4.1806E+04, 4.1872E+04, 4.1937E+04, 4.2003E+04, 4.2068E+04, 4.2134E+04, 4.2200E+04, 4.2265E+04, 4.2331E+04, &
       4.2397E+04, 4.2463E+04, 4.2529E+04, 4.2596E+04, 4.2662E+04, 4.2728E+04, 4.2795E+04, 4.2861E+04, 4.2928E+04, 4.2995E+04, &
       4.3061E+04, 4.3128E+04, 4.3195E+04, 4.3262E+04, 4.3329E+04, 4.3396E+04, 4.3464E+04, 4.3531E+04, 4.3599E+04, 4.3666E+04, &
       4.3734E+04, 4.3801E+04, 4.3869E+04, 4.3937E+04, 4.4005E+04, 4.4073E+04, 4.4141E+04, 4.4209E+04, 4.4277E+04, 4.4346E+04, &
       4.4414E+04, 4.4482E+04, 4.4551E+04, 4.4620E+04, 4.4688E+04, 4.4757E+04, 4.4826E+04, 4.4895E+04, 4.4964E+04, 4.5033E+04, &
       4.5103E+04, 4.5172E+04, 4.5241E+04, 4.5311E+04, 4.5380E+04, 4.5450E+04, 4.5520E+04, 4.5589E+04, 4.5659E+04, 4.5729E+04, &
       4.5799E+04, 4.5870E+04, 4.5940E+04, 4.6010E+04, 4.6080E+04, 4.6151E+04, 4.6221E+04, 4.6292E+04, 4.6363E+04, 4.6434E+04, &
       4.6505E+04, 4.6576E+04, 4.6647E+04, 4.6718E+04, 4.6789E+04, 4.6860E+04, 4.6932E+04, 4.7003E+04, 4.7075E+04, 4.7146E+04, &
       4.7218E+04, 4.7290E+04, 4.7362E+04, 4.7434E+04, 4.7506E+04, 4.7578E+04, 4.7650E+04, 4.7723E+04, 4.7795E+04, 4.7868E+04, &
       4.7940E+04, 4.8013E+04, 4.8086E+04, 4.8158E+04, 4.8231E+04, 4.8304E+04, 4.8377E+04, 4.8451E+04, 4.8524E+04, 4.8597E+04, &
       4.8671E+04, 4.8744E+04, 4.8818E+04, 4.8892E+04, 4.8965E+04, 4.9039E+04, 4.9113E+04, 4.9187E+04, 4.9261E+04, 4.9336E+04, &
       4.9410E+04, 4.9484E+04, 4.9559E+04, 4.9633E+04, 4.9708E+04, 4.9783E+04, 4.9857E+04, 4.9932E+04, 5.0007E+04, 5.0082E+04, &
       5.0158E+04, 5.0233E+04, 5.0308E+04, 5.0384E+04, 5.0459E+04, 5.0535E+04, 5.0611E+04, 5.0686E+04, 5.0762E+04, 5.0838E+04, &
       5.0914E+04, 5.0990E+04, 5.1067E+04, 5.1143E+04, 5.1219E+04, 5.1296E+04, 5.1372E+04, 5.1449E+04, 5.1526E+04, 5.1603E+04, &
       5.1680E+04, 5.1757E+04, 5.1834E+04, 5.1911E+04, 5.1988E+04, 5.2066E+04, 5.2143E+04, 5.2221E+04, 5.2298E+04, 5.2376E+04, &
       5.2454E+04, 5.2532E+04, 5.2610E+04, 5.2688E+04, 5.2766E+04, 5.2844E+04, 5.2923E+04, 5.3001E+04, 5.3080E+04, 5.3158E+04, &
       5.3237E+04, 5.3316E+04, 5.3395E+04, 5.3474E+04, 5.3553E+04, 5.3632E+04, 5.3711E+04, 5.3791E+04, 5.3870E+04, 5.3950E+04, &
       5.4029E+04, 5.4109E+04, 5.4189E+04, 5.4269E+04, 5.4349E+04, 5.4429E+04, 5.4509E+04, 5.4589E+04, 5.4669E+04, 5.4750E+04, &
       5.4830E+04, 5.4911E+04, 5.4992E+04, 5.5073E+04, 5.5153E+04, 5.5234E+04, 5.5315E+04, 5.5397E+04, 5.5478E+04, 5.5559E+04, &
       5.5641E+04, 5.5722E+04, 5.5804E+04, 5.5886E+04, 5.5967E+04, 5.6049E+04, 5.6131E+04, 5.6213E+04, 5.6296E+04, 5.6378E+04, &
       5.6460E+04, 5.6543E+04, 5.6625E+04, 5.6708E+04, 5.6791E+04, 5.6874E+04, 5.6956E+04, 5.7039E+04, 5.7123E+04, 5.7206E+04, &
       5.7289E+04, 5.7373E+04, 5.7456E+04, 5.7540E+04, 5.7623E+04, 5.7707E+04, 5.7791E+04, 5.7875E+04, 5.7959E+04, 5.8043E+04, &
       5.8127E+04, 5.8212E+04, 5.8296E+04, 5.8381E+04, 5.8465E+04, 5.8550E+04, 5.8635E+04, 5.8720E+04, 5.8805E+04, 5.8890E+04, &
       5.8975E+04, 5.9060E+04, 5.9146E+04, 5.9231E+04, 5.9317E+04, 5.9402E+04, 5.9488E+04, 5.9574E+04, 5.9660E+04, 5.9746E+04, &
       5.9832E+04, 5.9918E+04, 6.0004E+04, 6.0091E+04, 6.0177E+04, 6.0264E+04, 6.0351E+04, 6.0437E+04, 6.0524E+04, 6.0611E+04, &
       6.0698E+04, 6.0786E+04, 6.0873E+04, 6.0960E+04, 6.1048E+04, 6.1135E+04, 6.1223E+04, 6.1311E+04, 6.1399E+04, 6.1487E+04, &
       6.1575E+04, 6.1663E+04, 6.1751E+04, 6.1839E+04, 6.1928E+04, 6.2016E+04, 6.2105E+04, 6.2194E+04, 6.2283E+04, 6.2372E+04, &
       6.2461E+04, 6.2550E+04, 6.2639E+04, 6.2728E+04, 6.2818E+04, 6.2907E+04, 6.2997E+04, 6.3086E+04, 6.3176E+04, 6.3266E+04, &
       6.3356E+04, 6.3446E+04, 6.3536E+04, 6.3627E+04, 6.3717E+04, 6.3808E+04, 6.3898E+04, 6.3989E+04, 6.4080E+04, 6.4171E+04, &
       6.4262E+04, 6.4353E+04, 6.4444E+04, 6.4535E+04, 6.4626E+04, 6.4718E+04, 6.4810E+04, 6.4901E+04, 6.4993E+04, 6.5085E+04, &
       6.5177E+04, 6.5269E+04, 6.5361E+04, 6.5453E+04, 6.5546E+04, 6.5638E+04, 6.5731E+04, 6.5823E+04, 6.5916E+04, 6.6009E+04, &
       6.6102E+04, 6.6195E+04, 6.6288E+04, 6.6382E+04, 6.6475E+04, 6.6568E+04, 6.6662E+04, 6.6756E+04, 6.6849E+04, 6.6943E+04, &
       6.7037E+04, 6.7131E+04, 6.7226E+04, 6.7320E+04, 6.7414E+04, 6.7509E+04, 6.7603E+04, 6.7698E+04, 6.7793E+04, 6.7888E+04/
      data (QofT( 2,J),J=2409,4510)/ 6.7983E+04, 6.8078E+04, 6.8173E+04, 6.8268E+04, 6.8364E+04, 6.8459E+04, 6.8555E+04, 6.8650E+04, &
       6.8746E+04, 6.8842E+04, 6.8938E+04, 6.9034E+04, 6.9130E+04, 6.9227E+04, 6.9323E+04, 6.9420E+04, 6.9516E+04, 6.9613E+04, &
       6.9710E+04, 6.9807E+04, 6.9904E+04, 7.0001E+04, 7.0098E+04, 7.0195E+04, 7.0293E+04, 7.0390E+04, 7.0488E+04, 7.0586E+04, &
       7.0684E+04, 7.0782E+04, 7.0880E+04, 7.0978E+04, 7.1076E+04, 7.1174E+04, 7.1273E+04, 7.1371E+04, 7.1470E+04, 7.1569E+04, &
       7.1668E+04, 7.1767E+04, 7.1866E+04, 7.1965E+04, 7.2064E+04, 7.2164E+04, 7.2263E+04, 7.2363E+04, 7.2463E+04, 7.2563E+04, &
       7.2662E+04, 7.2762E+04, 7.2863E+04, 7.2963E+04, 7.3063E+04, 7.3164E+04, 7.3264E+04, 7.3365E+04, 7.3466E+04, 7.3567E+04, &
       7.3668E+04, 7.3769E+04, 7.3870E+04, 7.3971E+04, 7.4073E+04, 7.4174E+04, 7.4276E+04, 7.4377E+04, 7.4479E+04, 7.4581E+04, &
       7.4683E+04, 7.4785E+04, 7.4888E+04, 7.4990E+04, 7.5092E+04, 7.5195E+04, 7.5298E+04, 7.5400E+04, 7.5503E+04, 7.5606E+04, &
       7.5709E+04, 7.5813E+04, 7.5916E+04, 7.6019E+04, 7.6123E+04, 7.6226E+04, 7.6330E+04, 7.6434E+04, 7.6538E+04, 7.6642E+04, &
       7.6746E+04, 7.6851E+04, 7.6955E+04, 7.7059E+04, 7.7164E+04, 7.7269E+04, 7.7374E+04, 7.7478E+04, 7.7583E+04, 7.7689E+04, &
       7.7794E+04, 7.7899E+04, 7.8005E+04, 7.8110E+04, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       171
      data (QofT( 3,J),J=1,2408)/ 6.0000E+00, 6.0000E+00, 6.0006E+00, 6.0105E+00, 6.0585E+00, 6.1853E+00, 6.4260E+00, 6.8018E+00, &
       7.3208E+00, 7.9814E+00, 8.7762E+00, 9.6944E+00, 1.0724E+01, 1.1854E+01, 1.3072E+01, 1.4368E+01, 1.5734E+01, 1.7160E+01, &
       1.8640E+01, 2.0169E+01, 2.3351E+01, 2.6675E+01, 3.0118E+01, 3.3665E+01, 3.7305E+01, 4.1032E+01, 4.4841E+01, 4.8730E+01, &
       5.2697E+01, 5.6740E+01, 6.0860E+01, 6.5057E+01, 6.9329E+01, 7.3677E+01, 7.8101E+01, 8.2600E+01, 8.7175E+01, 9.1824E+01, &
       9.6548E+01, 1.0135E+02, 1.0622E+02, 1.1116E+02, 1.1618E+02, 1.2126E+02, 1.2642E+02, 1.3165E+02, 1.3695E+02, 1.4232E+02, &
       1.4775E+02, 1.5325E+02, 1.5882E+02, 1.6446E+02, 1.7016E+02, 1.7592E+02, 1.8175E+02, 1.8765E+02, 1.9360E+02, 1.9962E+02, &
       2.0570E+02, 2.1184E+02, 2.1804E+02, 2.2430E+02, 2.3062E+02, 2.3700E+02, 2.4344E+02, 2.4993E+02, 2.5649E+02, 2.6310E+02, &
       2.6976E+02, 2.7648E+02, 2.8326E+02, 2.9009E+02, 2.9698E+02, 3.0392E+02, 3.1092E+02, 3.1797E+02, 3.2507E+02, 3.3222E+02, &
       3.3943E+02, 3.4669E+02, 3.5400E+02, 3.6136E+02, 3.6877E+02, 3.7623E+02, 3.8375E+02, 3.9131E+02, 3.9892E+02, 4.0659E+02, &
       4.1430E+02, 4.2206E+02, 4.2986E+02, 4.3772E+02, 4.4563E+02, 4.5358E+02, 4.6158E+02, 4.6962E+02, 4.7772E+02, 4.8586E+02, &
       4.9404E+02, 5.0227E+02, 5.1055E+02, 5.1887E+02, 5.2724E+02, 5.3566E+02, 5.4412E+02, 5.5262E+02, 5.6117E+02, 5.6976E+02, &
       5.7840E+02, 5.8708E+02, 5.9580E+02, 6.0457E+02, 6.1338E+02, 6.2223E+02, 6.3113E+02, 6.4007E+02, 6.4905E+02, 6.5807E+02, &
       6.6714E+02, 6.7625E+02, 6.8540E+02, 6.9459E+02, 7.0382E+02, 7.1310E+02, 7.2241E+02, 7.3177E+02, 7.4117E+02, 7.5061E+02, &
       7.6009E+02, 7.6961E+02, 7.7917E+02, 7.8877E+02, 7.9841E+02, 8.0809E+02, 8.1781E+02, 8.2757E+02, 8.3737E+02, 8.4721E+02, &
       8.5709E+02, 8.6701E+02, 8.7697E+02, 8.8696E+02, 8.9700E+02, 9.0707E+02, 9.1719E+02, 9.2734E+02, 9.3753E+02, 9.4776E+02, &
       9.5802E+02, 9.6833E+02, 9.7867E+02, 9.8906E+02, 9.9948E+02, 1.0099E+03, 1.0204E+03, 1.0310E+03, 1.0415E+03, 1.0521E+03, &
       1.0628E+03, 1.0735E+03, 1.0842E+03, 1.0950E+03, 1.1058E+03, 1.1166E+03, 1.1275E+03, 1.1384E+03, 1.1493E+03, 1.1603E+03, &
       1.1713E+03, 1.1824E+03, 1.1935E+03, 1.2046E+03, 1.2158E+03, 1.2270E+03, 1.2382E+03, 1.2495E+03, 1.2608E+03, 1.2722E+03, &
       1.2836E+03, 1.2950E+03, 1.3064E+03, 1.3179E+03, 1.3295E+03, 1.3410E+03, 1.3527E+03, 1.3643E+03, 1.3760E+03, 1.3877E+03, &
       1.3995E+03, 1.4113E+03, 1.4231E+03, 1.4349E+03, 1.4469E+03, 1.4588E+03, 1.4708E+03, 1.4828E+03, 1.4948E+03, 1.5069E+03, &
       1.5190E+03, 1.5312E+03, 1.5434E+03, 1.5556E+03, 1.5679E+03, 1.5802E+03, 1.5925E+03, 1.6049E+03, 1.6173E+03, 1.6298E+03, &
       1.6423E+03, 1.6548E+03, 1.6673E+03, 1.6799E+03, 1.6926E+03, 1.7052E+03, 1.7180E+03, 1.7307E+03, 1.7435E+03, 1.7563E+03, &
       1.7692E+03, 1.7820E+03, 1.7950E+03, 1.8079E+03, 1.8209E+03, 1.8340E+03, 1.8471E+03, 1.8602E+03, 1.8733E+03, 1.8865E+03, &
       1.8997E+03, 1.9130E+03, 1.9263E+03, 1.9396E+03, 1.9530E+03, 1.9664E+03, 1.9799E+03, 1.9933E+03, 2.0069E+03, 2.0204E+03, &
       2.0340E+03, 2.0477E+03, 2.0613E+03, 2.0751E+03, 2.0888E+03, 2.1026E+03, 2.1164E+03, 2.1303E+03, 2.1442E+03, 2.1581E+03, &
       2.1721E+03, 2.1861E+03, 2.2002E+03, 2.2142E+03, 2.2284E+03, 2.2425E+03, 2.2567E+03, 2.2710E+03, 2.2853E+03, 2.2996E+03, &
       2.3139E+03, 2.3283E+03, 2.3428E+03, 2.3573E+03, 2.3718E+03, 2.3863E+03, 2.4009E+03, 2.4155E+03, 2.4302E+03, 2.4449E+03, &
       2.4597E+03, 2.4744E+03, 2.4893E+03, 2.5041E+03, 2.5190E+03, 2.5340E+03, 2.5490E+03, 2.5640E+03, 2.5790E+03, 2.5941E+03, &
       2.6093E+03, 2.6245E+03, 2.6397E+03, 2.6549E+03, 2.6702E+03, 2.6856E+03, 2.7010E+03, 2.7164E+03, 2.7318E+03, 2.7473E+03, &
       2.7629E+03, 2.7784E+03, 2.7941E+03, 2.8097E+03, 2.8254E+03, 2.8412E+03, 2.8569E+03, 2.8728E+03, 2.8886E+03, 2.9045E+03, &
       2.9205E+03, 2.9365E+03, 2.9525E+03, 2.9686E+03, 2.9847E+03, 3.0008E+03, 3.0170E+03, 3.0333E+03, 3.0495E+03, 3.0658E+03, &
       3.0822E+03, 3.0986E+03, 3.1150E+03, 3.1315E+03, 3.1481E+03, 3.1646E+03, 3.1812E+03, 3.1979E+03, 3.2146E+03, 3.2313E+03, &
       3.2481E+03, 3.2649E+03, 3.2818E+03, 3.2987E+03, 3.3156E+03, 3.3326E+03, 3.3497E+03, 3.3667E+03, 3.3839E+03, 3.4010E+03, &
       3.4182E+03, 3.4355E+03, 3.4528E+03, 3.4701E+03, 3.4875E+03, 3.5049E+03, 3.5224E+03, 3.5399E+03, 3.5574E+03, 3.5750E+03, &
       3.5927E+03, 3.6104E+03, 3.6281E+03, 3.6459E+03, 3.6637E+03, 3.6815E+03, 3.6995E+03, 3.7174E+03, 3.7354E+03, 3.7534E+03, &
       3.7715E+03, 3.7897E+03, 3.8078E+03, 3.8261E+03, 3.8443E+03, 3.8626E+03, 3.8810E+03, 3.8994E+03, 3.9178E+03, 3.9363E+03, &
       3.9549E+03, 3.9735E+03, 3.9921E+03, 4.0108E+03, 4.0295E+03, 4.0483E+03, 4.0671E+03, 4.0859E+03, 4.1048E+03, 4.1238E+03, &
       4.1428E+03, 4.1619E+03, 4.1809E+03, 4.2001E+03, 4.2193E+03, 4.2385E+03, 4.2578E+03, 4.2771E+03, 4.2965E+03, 4.3159E+03, &
       4.3354E+03, 4.3549E+03, 4.3745E+03, 4.3941E+03, 4.4138E+03, 4.4335E+03, 4.4532E+03, 4.4730E+03, 4.4929E+03, 4.5128E+03, &
       4.5327E+03, 4.5527E+03, 4.5728E+03, 4.5929E+03, 4.6130E+03, 4.6332E+03, 4.6535E+03, 4.6738E+03, 4.6941E+03, 4.7145E+03, &
       4.7349E+03, 4.7554E+03, 4.7760E+03, 4.7965E+03, 4.8172E+03, 4.8379E+03, 4.8586E+03, 4.8794E+03, 4.9002E+03, 4.9211E+03, &
       4.9421E+03, 4.9631E+03, 4.9841E+03, 5.0052E+03, 5.0263E+03, 5.0475E+03, 5.0688E+03, 5.0901E+03, 5.1114E+03, 5.1328E+03, &
       5.1543E+03, 5.1758E+03, 5.1973E+03, 5.2189E+03, 5.2406E+03, 5.2623E+03, 5.2840E+03, 5.3059E+03, 5.3277E+03, 5.3496E+03, &
       5.3716E+03, 5.3936E+03, 5.4157E+03, 5.4378E+03, 5.4600E+03, 5.4823E+03, 5.5045E+03, 5.5269E+03, 5.5493E+03, 5.5717E+03, &
       5.5942E+03, 5.6168E+03, 5.6394E+03, 5.6620E+03, 5.6848E+03, 5.7075E+03, 5.7304E+03, 5.7532E+03, 5.7762E+03, 5.7991E+03, &
       5.8222E+03, 5.8453E+03, 5.8684E+03, 5.8916E+03, 5.9149E+03, 5.9382E+03, 5.9616E+03, 5.9850E+03, 6.0085E+03, 6.0320E+03, &
       6.0556E+03, 6.0793E+03, 6.1030E+03, 6.1268E+03, 6.1506E+03, 6.1745E+03, 6.1984E+03, 6.2224E+03, 6.2464E+03, 6.2705E+03, &
       6.2947E+03, 6.3189E+03, 6.3432E+03, 6.3675E+03, 6.3919E+03, 6.4163E+03, 6.4408E+03, 6.4654E+03, 6.4900E+03, 6.5147E+03, &
       6.5394E+03, 6.5642E+03, 6.5891E+03, 6.6140E+03, 6.6389E+03, 6.6640E+03, 6.6890E+03, 6.7142E+03, 6.7394E+03, 6.7647E+03, &
       6.7900E+03, 6.8154E+03, 6.8408E+03, 6.8663E+03, 6.8919E+03, 6.9175E+03, 6.9432E+03, 6.9689E+03, 6.9947E+03, 7.0206E+03, &
       7.0465E+03, 7.0725E+03, 7.0985E+03, 7.1246E+03, 7.1508E+03, 7.1770E+03, 7.2033E+03, 7.2296E+03, 7.2560E+03, 7.2825E+03, &
       7.3090E+03, 7.3356E+03, 7.3623E+03, 7.3890E+03, 7.4158E+03, 7.4426E+03, 7.4695E+03, 7.4965E+03, 7.5235E+03, 7.5506E+03, &
       7.5778E+03, 7.6050E+03, 7.6323E+03, 7.6596E+03, 7.6871E+03, 7.7145E+03, 7.7421E+03, 7.7697E+03, 7.7973E+03, 7.8251E+03, &
       7.8529E+03, 7.8807E+03, 7.9086E+03, 7.9366E+03, 7.9647E+03, 7.9928E+03, 8.0210E+03, 8.0492E+03, 8.0775E+03, 8.1059E+03, &
       8.1344E+03, 8.1629E+03, 8.1914E+03, 8.2201E+03, 8.2488E+03, 8.2776E+03, 8.3064E+03, 8.3353E+03, 8.3643E+03, 8.3933E+03, &
       8.4224E+03, 8.4516E+03, 8.4808E+03, 8.5101E+03, 8.5395E+03, 8.5690E+03, 8.5985E+03, 8.6280E+03, 8.6577E+03, 8.6874E+03, &
       8.7172E+03, 8.7470E+03, 8.7770E+03, 8.8069E+03, 8.8370E+03, 8.8671E+03, 8.8973E+03, 8.9276E+03, 8.9579E+03, 8.9883E+03, &
       9.0188E+03, 9.0493E+03, 9.0799E+03, 9.1106E+03, 9.1414E+03, 9.1722E+03, 9.2031E+03, 9.2340E+03, 9.2651E+03, 9.2962E+03, &
       9.3273E+03, 9.3586E+03, 9.3899E+03, 9.4213E+03, 9.4528E+03, 9.4843E+03, 9.5159E+03, 9.5476E+03, 9.5793E+03, 9.6111E+03, &
       9.6430E+03, 9.6750E+03, 9.7070E+03, 9.7391E+03, 9.7713E+03, 9.8035E+03, 9.8359E+03, 9.8683E+03, 9.9008E+03, 9.9333E+03, &
       9.9659E+03, 9.9986E+03, 1.0031E+04, 1.0064E+04, 1.0097E+04, 1.0130E+04, 1.0163E+04, 1.0196E+04, 1.0230E+04, 1.0263E+04, &
       1.0296E+04, 1.0330E+04, 1.0363E+04, 1.0397E+04, 1.0430E+04, 1.0464E+04, 1.0498E+04, 1.0532E+04, 1.0566E+04, 1.0600E+04, &
       1.0634E+04, 1.0668E+04, 1.0702E+04, 1.0737E+04, 1.0771E+04, 1.0806E+04, 1.0840E+04, 1.0875E+04, 1.0910E+04, 1.0945E+04, &
       1.0979E+04, 1.1014E+04, 1.1050E+04, 1.1085E+04, 1.1120E+04, 1.1155E+04, 1.1191E+04, 1.1226E+04, 1.1261E+04, 1.1297E+04, &
       1.1333E+04, 1.1369E+04, 1.1404E+04, 1.1440E+04, 1.1476E+04, 1.1512E+04, 1.1549E+04, 1.1585E+04, 1.1621E+04, 1.1658E+04, &
       1.1694E+04, 1.1731E+04, 1.1767E+04, 1.1804E+04, 1.1841E+04, 1.1878E+04, 1.1915E+04, 1.1952E+04, 1.1989E+04, 1.2026E+04, &
       1.2063E+04, 1.2101E+04, 1.2138E+04, 1.2176E+04, 1.2213E+04, 1.2251E+04, 1.2289E+04, 1.2327E+04, 1.2365E+04, 1.2403E+04, &
       1.2441E+04, 1.2479E+04, 1.2518E+04, 1.2556E+04, 1.2594E+04, 1.2633E+04, 1.2672E+04, 1.2710E+04, 1.2749E+04, 1.2788E+04, &
       1.2827E+04, 1.2866E+04, 1.2905E+04, 1.2944E+04, 1.2984E+04, 1.3023E+04, 1.3063E+04, 1.3102E+04, 1.3142E+04, 1.3182E+04, &
       1.3222E+04, 1.3262E+04, 1.3302E+04, 1.3342E+04, 1.3382E+04, 1.3422E+04, 1.3463E+04, 1.3503E+04, 1.3544E+04, 1.3584E+04, &
       1.3625E+04, 1.3666E+04, 1.3707E+04, 1.3748E+04, 1.3789E+04, 1.3830E+04, 1.3871E+04, 1.3912E+04, 1.3954E+04, 1.3995E+04, &
       1.4037E+04, 1.4079E+04, 1.4121E+04, 1.4162E+04, 1.4204E+04, 1.4247E+04, 1.4289E+04, 1.4331E+04, 1.4373E+04, 1.4416E+04, &
       1.4458E+04, 1.4501E+04, 1.4544E+04, 1.4586E+04, 1.4629E+04, 1.4672E+04, 1.4715E+04, 1.4759E+04, 1.4802E+04, 1.4845E+04, &
       1.4889E+04, 1.4932E+04, 1.4976E+04, 1.5020E+04, 1.5063E+04, 1.5107E+04, 1.5151E+04, 1.5195E+04, 1.5240E+04, 1.5284E+04, &
       1.5328E+04, 1.5373E+04, 1.5417E+04, 1.5462E+04, 1.5507E+04, 1.5552E+04, 1.5597E+04, 1.5642E+04, 1.5687E+04, 1.5732E+04, &
       1.5778E+04, 1.5823E+04, 1.5869E+04, 1.5914E+04, 1.5960E+04, 1.6006E+04, 1.6052E+04, 1.6098E+04, 1.6144E+04, 1.6190E+04, &
       1.6237E+04, 1.6283E+04, 1.6330E+04, 1.6376E+04, 1.6423E+04, 1.6470E+04, 1.6517E+04, 1.6564E+04, 1.6611E+04, 1.6658E+04, &
       1.6705E+04, 1.6753E+04, 1.6800E+04, 1.6848E+04, 1.6896E+04, 1.6943E+04, 1.6991E+04, 1.7039E+04, 1.7088E+04, 1.7136E+04, &
       1.7184E+04, 1.7233E+04, 1.7281E+04, 1.7330E+04, 1.7379E+04, 1.7427E+04, 1.7476E+04, 1.7525E+04, 1.7575E+04, 1.7624E+04, &
       1.7673E+04, 1.7723E+04, 1.7772E+04, 1.7822E+04, 1.7872E+04, 1.7921E+04, 1.7971E+04, 1.8022E+04, 1.8072E+04, 1.8122E+04, &
       1.8172E+04, 1.8223E+04, 1.8274E+04, 1.8324E+04, 1.8375E+04, 1.8426E+04, 1.8477E+04, 1.8528E+04, 1.8579E+04, 1.8631E+04, &
       1.8682E+04, 1.8734E+04, 1.8786E+04, 1.8837E+04, 1.8889E+04, 1.8941E+04, 1.8993E+04, 1.9046E+04, 1.9098E+04, 1.9150E+04, &
       1.9203E+04, 1.9256E+04, 1.9308E+04, 1.9361E+04, 1.9414E+04, 1.9467E+04, 1.9520E+04, 1.9574E+04, 1.9627E+04, 1.9681E+04, &
       1.9734E+04, 1.9788E+04, 1.9842E+04, 1.9896E+04, 1.9950E+04, 2.0004E+04, 2.0058E+04, 2.0113E+04, 2.0167E+04, 2.0222E+04, &
       2.0277E+04, 2.0332E+04, 2.0387E+04, 2.0442E+04, 2.0497E+04, 2.0552E+04, 2.0608E+04, 2.0663E+04, 2.0719E+04, 2.0775E+04, &
       2.0831E+04, 2.0887E+04, 2.0943E+04, 2.0999E+04, 2.1055E+04, 2.1112E+04, 2.1168E+04, 2.1225E+04, 2.1282E+04, 2.1339E+04, &
       2.1396E+04, 2.1453E+04, 2.1510E+04, 2.1567E+04, 2.1625E+04, 2.1683E+04, 2.1740E+04, 2.1798E+04, 2.1856E+04, 2.1914E+04, &
       2.1972E+04, 2.2031E+04, 2.2089E+04, 2.2148E+04, 2.2206E+04, 2.2265E+04, 2.2324E+04, 2.2383E+04, 2.2442E+04, 2.2502E+04, &
       2.2561E+04, 2.2620E+04, 2.2680E+04, 2.2740E+04, 2.2800E+04, 2.2860E+04, 2.2920E+04, 2.2980E+04, 2.3040E+04, 2.3101E+04, &
       2.3161E+04, 2.3222E+04, 2.3283E+04, 2.3344E+04, 2.3405E+04, 2.3466E+04, 2.3527E+04, 2.3589E+04, 2.3650E+04, 2.3712E+04, &
       2.3774E+04, 2.3836E+04, 2.3898E+04, 2.3960E+04, 2.4022E+04, 2.4085E+04, 2.4147E+04, 2.4210E+04, 2.4273E+04, 2.4336E+04, &
       2.4399E+04, 2.4462E+04, 2.4525E+04, 2.4589E+04, 2.4652E+04, 2.4716E+04, 2.4780E+04, 2.4844E+04, 2.4908E+04, 2.4972E+04, &
       2.5036E+04, 2.5101E+04, 2.5165E+04, 2.5230E+04, 2.5295E+04, 2.5360E+04, 2.5425E+04, 2.5490E+04, 2.5556E+04, 2.5621E+04, &
       2.5687E+04, 2.5752E+04, 2.5818E+04, 2.5884E+04, 2.5950E+04, 2.6017E+04, 2.6083E+04, 2.6150E+04, 2.6216E+04, 2.6283E+04, &
       2.6350E+04, 2.6417E+04, 2.6484E+04, 2.6551E+04, 2.6619E+04, 2.6686E+04, 2.6754E+04, 2.6822E+04, 2.6890E+04, 2.6958E+04, &
       2.7026E+04, 2.7094E+04, 2.7163E+04, 2.7232E+04, 2.7300E+04, 2.7369E+04, 2.7438E+04, 2.7507E+04, 2.7577E+04, 2.7646E+04, &
       2.7716E+04, 2.7785E+04, 2.7855E+04, 2.7925E+04, 2.7995E+04, 2.8066E+04, 2.8136E+04, 2.8206E+04, 2.8277E+04, 2.8348E+04, &
       2.8419E+04, 2.8490E+04, 2.8561E+04, 2.8632E+04, 2.8704E+04, 2.8776E+04, 2.8847E+04, 2.8919E+04, 2.8991E+04, 2.9063E+04, &
       2.9136E+04, 2.9208E+04, 2.9281E+04, 2.9353E+04, 2.9426E+04, 2.9499E+04, 2.9572E+04, 2.9646E+04, 2.9719E+04, 2.9793E+04, &
       2.9866E+04, 2.9940E+04, 3.0014E+04, 3.0088E+04, 3.0163E+04, 3.0237E+04, 3.0312E+04, 3.0386E+04, 3.0461E+04, 3.0536E+04, &
       3.0611E+04, 3.0687E+04, 3.0762E+04, 3.0838E+04, 3.0913E+04, 3.0989E+04, 3.1065E+04, 3.1141E+04, 3.1217E+04, 3.1294E+04, &
       3.1370E+04, 3.1447E+04, 3.1524E+04, 3.1601E+04, 3.1678E+04, 3.1756E+04, 3.1833E+04, 3.1911E+04, 3.1988E+04, 3.2066E+04, &
       3.2144E+04, 3.2222E+04, 3.2301E+04, 3.2379E+04, 3.2458E+04, 3.2537E+04, 3.2616E+04, 3.2695E+04, 3.2774E+04, 3.2853E+04, &
       3.2933E+04, 3.3012E+04, 3.3092E+04, 3.3172E+04, 3.3252E+04, 3.3333E+04, 3.3413E+04, 3.3494E+04, 3.3574E+04, 3.3655E+04, &
       3.3736E+04, 3.3817E+04, 3.3899E+04, 3.3980E+04, 3.4062E+04, 3.4144E+04, 3.4226E+04, 3.4308E+04, 3.4390E+04, 3.4472E+04, &
       3.4555E+04, 3.4638E+04, 3.4720E+04, 3.4803E+04, 3.4887E+04, 3.4970E+04, 3.5053E+04, 3.5137E+04, 3.5221E+04, 3.5305E+04, &
       3.5389E+04, 3.5473E+04, 3.5558E+04, 3.5642E+04, 3.5727E+04, 3.5812E+04, 3.5897E+04, 3.5982E+04, 3.6067E+04, 3.6153E+04, &
       3.6239E+04, 3.6324E+04, 3.6410E+04, 3.6497E+04, 3.6583E+04, 3.6669E+04, 3.6756E+04, 3.6843E+04, 3.6930E+04, 3.7017E+04, &
       3.7104E+04, 3.7191E+04, 3.7279E+04, 3.7367E+04, 3.7455E+04, 3.7543E+04, 3.7631E+04, 3.7719E+04, 3.7808E+04, 3.7897E+04, &
       3.7986E+04, 3.8075E+04, 3.8164E+04, 3.8253E+04, 3.8343E+04, 3.8432E+04, 3.8522E+04, 3.8612E+04, 3.8703E+04, 3.8793E+04, &
       3.8883E+04, 3.8974E+04, 3.9065E+04, 3.9156E+04, 3.9247E+04, 3.9339E+04, 3.9430E+04, 3.9522E+04, 3.9614E+04, 3.9706E+04, &
       3.9798E+04, 3.9890E+04, 3.9983E+04, 4.0075E+04, 4.0168E+04, 4.0261E+04, 4.0354E+04, 4.0448E+04, 4.0541E+04, 4.0635E+04, &
       4.0729E+04, 4.0823E+04, 4.0917E+04, 4.1011E+04, 4.1106E+04, 4.1201E+04, 4.1296E+04, 4.1391E+04, 4.1486E+04, 4.1581E+04, &
       4.1677E+04, 4.1773E+04, 4.1869E+04, 4.1965E+04, 4.2061E+04, 4.2157E+04, 4.2254E+04, 4.2351E+04, 4.2448E+04, 4.2545E+04, &
       4.2642E+04, 4.2740E+04, 4.2837E+04, 4.2935E+04, 4.3033E+04, 4.3131E+04, 4.3230E+04, 4.3328E+04, 4.3427E+04, 4.3526E+04, &
       4.3625E+04, 4.3724E+04, 4.3823E+04, 4.3923E+04, 4.4023E+04, 4.4123E+04, 4.4223E+04, 4.4323E+04, 4.4424E+04, 4.4524E+04, &
       4.4625E+04, 4.4726E+04, 4.4827E+04, 4.4929E+04, 4.5030E+04, 4.5132E+04, 4.5234E+04, 4.5336E+04, 4.5438E+04, 4.5541E+04, &
       4.5643E+04, 4.5746E+04, 4.5849E+04, 4.5952E+04, 4.6056E+04, 4.6159E+04, 4.6263E+04, 4.6367E+04, 4.6471E+04, 4.6575E+04, &
       4.6680E+04, 4.6784E+04, 4.6889E+04, 4.6994E+04, 4.7099E+04, 4.7205E+04, 4.7310E+04, 4.7416E+04, 4.7522E+04, 4.7628E+04, &
       4.7734E+04, 4.7841E+04, 4.7948E+04, 4.8054E+04, 4.8162E+04, 4.8269E+04, 4.8376E+04, 4.8484E+04, 4.8592E+04, 4.8700E+04, &
       4.8808E+04, 4.8916E+04, 4.9025E+04, 4.9133E+04, 4.9242E+04, 4.9352E+04, 4.9461E+04, 4.9570E+04, 4.9680E+04, 4.9790E+04, &
       4.9900E+04, 5.0010E+04, 5.0121E+04, 5.0231E+04, 5.0342E+04, 5.0453E+04, 5.0565E+04, 5.0676E+04, 5.0788E+04, 5.0899E+04, &
       5.1011E+04, 5.1124E+04, 5.1236E+04, 5.1349E+04, 5.1461E+04, 5.1574E+04, 5.1688E+04, 5.1801E+04, 5.1914E+04, 5.2028E+04, &
       5.2142E+04, 5.2256E+04, 5.2371E+04, 5.2485E+04, 5.2600E+04, 5.2715E+04, 5.2830E+04, 5.2945E+04, 5.3061E+04, 5.3177E+04, &
       5.3293E+04, 5.3409E+04, 5.3525E+04, 5.3641E+04, 5.3758E+04, 5.3875E+04, 5.3992E+04, 5.4110E+04, 5.4227E+04, 5.4345E+04, &
       5.4463E+04, 5.4581E+04, 5.4699E+04, 5.4818E+04, 5.4936E+04, 5.5055E+04, 5.5175E+04, 5.5294E+04, 5.5413E+04, 5.5533E+04, &
       5.5653E+04, 5.5773E+04, 5.5894E+04, 5.6014E+04, 5.6135E+04, 5.6256E+04, 5.6377E+04, 5.6498E+04, 5.6620E+04, 5.6742E+04, &
       5.6864E+04, 5.6986E+04, 5.7108E+04, 5.7231E+04, 5.7354E+04, 5.7477E+04, 5.7600E+04, 5.7724E+04, 5.7847E+04, 5.7971E+04, &
       5.8095E+04, 5.8219E+04, 5.8344E+04, 5.8469E+04, 5.8594E+04, 5.8719E+04, 5.8844E+04, 5.8970E+04, 5.9095E+04, 5.9221E+04, &
       5.9347E+04, 5.9474E+04, 5.9600E+04, 5.9727E+04, 5.9854E+04, 5.9982E+04, 6.0109E+04, 6.0237E+04, 6.0365E+04, 6.0493E+04, &
       6.0621E+04, 6.0749E+04, 6.0878E+04, 6.1007E+04, 6.1136E+04, 6.1266E+04, 6.1395E+04, 6.1525E+04, 6.1655E+04, 6.1785E+04, &
       6.1916E+04, 6.2046E+04, 6.2177E+04, 6.2308E+04, 6.2440E+04, 6.2571E+04, 6.2703E+04, 6.2835E+04, 6.2967E+04, 6.3100E+04, &
       6.3232E+04, 6.3365E+04, 6.3498E+04, 6.3632E+04, 6.3765E+04, 6.3899E+04, 6.4033E+04, 6.4167E+04, 6.4301E+04, 6.4436E+04, &
       6.4571E+04, 6.4706E+04, 6.4841E+04, 6.4977E+04, 6.5113E+04, 6.5249E+04, 6.5385E+04, 6.5521E+04, 6.5658E+04, 6.5795E+04, &
       6.5932E+04, 6.6069E+04, 6.6207E+04, 6.6344E+04, 6.6482E+04, 6.6621E+04, 6.6759E+04, 6.6898E+04, 6.7037E+04, 6.7176E+04, &
       6.7315E+04, 6.7455E+04, 6.7594E+04, 6.7734E+04, 6.7875E+04, 6.8015E+04, 6.8156E+04, 6.8297E+04, 6.8438E+04, 6.8579E+04, &
       6.8721E+04, 6.8863E+04, 6.9005E+04, 6.9147E+04, 6.9290E+04, 6.9433E+04, 6.9576E+04, 6.9719E+04, 6.9863E+04, 7.0006E+04, &
       7.0150E+04, 7.0294E+04, 7.0439E+04, 7.0584E+04, 7.0728E+04, 7.0874E+04, 7.1019E+04, 7.1165E+04, 7.1310E+04, 7.1456E+04, &
       7.1603E+04, 7.1749E+04, 7.1896E+04, 7.2043E+04, 7.2190E+04, 7.2338E+04, 7.2486E+04, 7.2634E+04, 7.2782E+04, 7.2930E+04, &
       7.3079E+04, 7.3228E+04, 7.3377E+04, 7.3526E+04, 7.3676E+04, 7.3826E+04, 7.3976E+04, 7.4126E+04, 7.4277E+04, 7.4428E+04, &
       7.4579E+04, 7.4730E+04, 7.4882E+04, 7.5034E+04, 7.5186E+04, 7.5338E+04, 7.5491E+04, 7.5643E+04, 7.5796E+04, 7.5950E+04, &
       7.6103E+04, 7.6257E+04, 7.6411E+04, 7.6565E+04, 7.6720E+04, 7.6875E+04, 7.7030E+04, 7.7185E+04, 7.7340E+04, 7.7496E+04, &
       7.7652E+04, 7.7808E+04, 7.7965E+04, 7.8121E+04, 7.8278E+04, 7.8436E+04, 7.8593E+04, 7.8751E+04, 7.8909E+04, 7.9067E+04, &
       7.9225E+04, 7.9384E+04, 7.9543E+04, 7.9702E+04, 7.9862E+04, 8.0022E+04, 8.0182E+04, 8.0342E+04, 8.0502E+04, 8.0663E+04, &
       8.0824E+04, 8.0985E+04, 8.1147E+04, 8.1309E+04, 8.1471E+04, 8.1633E+04, 8.1795E+04, 8.1958E+04, 8.2121E+04, 8.2284E+04, &
       8.2448E+04, 8.2612E+04, 8.2776E+04, 8.2940E+04, 8.3105E+04, 8.3270E+04, 8.3435E+04, 8.3600E+04, 8.3766E+04, 8.3931E+04, &
       8.4098E+04, 8.4264E+04, 8.4431E+04, 8.4597E+04, 8.4765E+04, 8.4932E+04, 8.5100E+04, 8.5268E+04, 8.5436E+04, 8.5604E+04, &
       8.5773E+04, 8.5942E+04, 8.6111E+04, 8.6281E+04, 8.6451E+04, 8.6621E+04, 8.6791E+04, 8.6962E+04, 8.7132E+04, 8.7303E+04, &
       8.7475E+04, 8.7646E+04, 8.7818E+04, 8.7991E+04, 8.8163E+04, 8.8336E+04, 8.8509E+04, 8.8682E+04, 8.8855E+04, 8.9029E+04, &
       8.9203E+04, 8.9377E+04, 8.9552E+04, 8.9727E+04, 8.9902E+04, 9.0077E+04, 9.0253E+04, 9.0429E+04, 9.0605E+04, 9.0782E+04, &
       9.0958E+04, 9.1135E+04, 9.1313E+04, 9.1490E+04, 9.1668E+04, 9.1846E+04, 9.2024E+04, 9.2203E+04, 9.2382E+04, 9.2561E+04, &
       9.2741E+04, 9.2920E+04, 9.3100E+04, 9.3281E+04, 9.3461E+04, 9.3642E+04, 9.3823E+04, 9.4005E+04, 9.4186E+04, 9.4368E+04, &
       9.4551E+04, 9.4733E+04, 9.4916E+04, 9.5099E+04, 9.5282E+04, 9.5466E+04, 9.5650E+04, 9.5834E+04, 9.6018E+04, 9.6203E+04, &
       9.6388E+04, 9.6573E+04, 9.6759E+04, 9.6945E+04, 9.7131E+04, 9.7317E+04, 9.7504E+04, 9.7691E+04, 9.7878E+04, 9.8066E+04, &
       9.8254E+04, 9.8442E+04, 9.8630E+04, 9.8819E+04, 9.9008E+04, 9.9197E+04, 9.9387E+04, 9.9577E+04, 9.9767E+04, 9.9957E+04, &
       1.0015E+05, 1.0034E+05, 1.0053E+05, 1.0072E+05, 1.0091E+05, 1.0111E+05, 1.0130E+05, 1.0149E+05, 1.0168E+05, 1.0188E+05, &
       1.0207E+05, 1.0226E+05, 1.0246E+05, 1.0265E+05, 1.0285E+05, 1.0304E+05, 1.0324E+05, 1.0343E+05, 1.0363E+05, 1.0383E+05, &
       1.0402E+05, 1.0422E+05, 1.0442E+05, 1.0461E+05, 1.0481E+05, 1.0501E+05, 1.0521E+05, 1.0541E+05, 1.0561E+05, 1.0580E+05, &
       1.0600E+05, 1.0620E+05, 1.0640E+05, 1.0660E+05, 1.0680E+05, 1.0701E+05, 1.0721E+05, 1.0741E+05, 1.0761E+05, 1.0781E+05, &
       1.0801E+05, 1.0822E+05, 1.0842E+05, 1.0862E+05, 1.0883E+05, 1.0903E+05, 1.0924E+05, 1.0944E+05, 1.0964E+05, 1.0985E+05, &
       1.1006E+05, 1.1026E+05, 1.1047E+05, 1.1067E+05, 1.1088E+05, 1.1109E+05, 1.1129E+05, 1.1150E+05, 1.1171E+05, 1.1192E+05, &
       1.1213E+05, 1.1234E+05, 1.1254E+05, 1.1275E+05, 1.1296E+05, 1.1317E+05, 1.1338E+05, 1.1359E+05, 1.1381E+05, 1.1402E+05, &
       1.1423E+05, 1.1444E+05, 1.1465E+05, 1.1487E+05, 1.1508E+05, 1.1529E+05, 1.1550E+05, 1.1572E+05, 1.1593E+05, 1.1615E+05, &
       1.1636E+05, 1.1658E+05, 1.1679E+05, 1.1701E+05, 1.1722E+05, 1.1744E+05, 1.1766E+05, 1.1787E+05, 1.1809E+05, 1.1831E+05, &
       1.1853E+05, 1.1874E+05, 1.1896E+05, 1.1918E+05, 1.1940E+05, 1.1962E+05, 1.1984E+05, 1.2006E+05, 1.2028E+05, 1.2050E+05, &
       1.2072E+05, 1.2094E+05, 1.2116E+05, 1.2139E+05, 1.2161E+05, 1.2183E+05, 1.2205E+05, 1.2228E+05, 1.2250E+05, 1.2272E+05, &
       1.2295E+05, 1.2317E+05, 1.2340E+05, 1.2362E+05, 1.2385E+05, 1.2407E+05, 1.2430E+05, 1.2453E+05, 1.2475E+05, 1.2498E+05, &
       1.2521E+05, 1.2544E+05, 1.2566E+05, 1.2589E+05, 1.2612E+05, 1.2635E+05, 1.2658E+05, 1.2681E+05, 1.2704E+05, 1.2727E+05, &
       1.2750E+05, 1.2773E+05, 1.2796E+05, 1.2820E+05, 1.2843E+05, 1.2866E+05, 1.2889E+05, 1.2913E+05, 1.2936E+05, 1.2959E+05, &
       1.2983E+05, 1.3006E+05, 1.3030E+05, 1.3053E+05, 1.3077E+05, 1.3100E+05, 1.3124E+05, 1.3148E+05, 1.3171E+05, 1.3195E+05, &
       1.3219E+05, 1.3242E+05, 1.3266E+05, 1.3290E+05, 1.3314E+05, 1.3338E+05, 1.3362E+05, 1.3386E+05, 1.3410E+05, 1.3434E+05, &
       1.3458E+05, 1.3482E+05, 1.3506E+05, 1.3530E+05, 1.3555E+05, 1.3579E+05, 1.3603E+05, 1.3627E+05, 1.3652E+05, 1.3676E+05, &
       1.3701E+05, 1.3725E+05, 1.3750E+05, 1.3774E+05, 1.3799E+05, 1.3823E+05, 1.3848E+05, 1.3872E+05, 1.3897E+05, 1.3922E+05, &
       1.3947E+05, 1.3971E+05, 1.3996E+05, 1.4021E+05, 1.4046E+05, 1.4071E+05, 1.4096E+05, 1.4121E+05, 1.4146E+05, 1.4171E+05, &
       1.4196E+05, 1.4221E+05, 1.4247E+05, 1.4272E+05, 1.4297E+05, 1.4322E+05, 1.4348E+05, 1.4373E+05, 1.4398E+05, 1.4424E+05, &
       1.4449E+05, 1.4475E+05, 1.4500E+05, 1.4526E+05, 1.4552E+05, 1.4577E+05, 1.4603E+05, 1.4629E+05, 1.4654E+05, 1.4680E+05, &
       1.4706E+05, 1.4732E+05, 1.4758E+05, 1.4784E+05, 1.4810E+05, 1.4836E+05, 1.4862E+05, 1.4888E+05, 1.4914E+05, 1.4940E+05, &
       1.4966E+05, 1.4992E+05, 1.5019E+05, 1.5045E+05, 1.5071E+05, 1.5098E+05, 1.5124E+05, 1.5150E+05, 1.5177E+05, 1.5203E+05, &
       1.5230E+05, 1.5257E+05, 1.5283E+05, 1.5310E+05, 1.5336E+05, 1.5363E+05, 1.5390E+05, 1.5417E+05, 1.5444E+05, 1.5470E+05, &
       1.5497E+05, 1.5524E+05, 1.5551E+05, 1.5578E+05, 1.5605E+05, 1.5633E+05, 1.5660E+05, 1.5687E+05, 1.5714E+05, 1.5741E+05, &
       1.5769E+05, 1.5796E+05, 1.5823E+05, 1.5851E+05, 1.5878E+05, 1.5906E+05, 1.5933E+05, 1.5961E+05, 1.5988E+05, 1.6016E+05, &
       1.6043E+05, 1.6071E+05, 1.6099E+05, 1.6127E+05, 1.6154E+05, 1.6182E+05, 1.6210E+05, 1.6238E+05, 1.6266E+05, 1.6294E+05, &
       1.6322E+05, 1.6350E+05, 1.6378E+05, 1.6406E+05, 1.6435E+05, 1.6463E+05, 1.6491E+05, 1.6519E+05, 1.6548E+05, 1.6576E+05, &
       1.6604E+05, 1.6633E+05, 1.6661E+05, 1.6690E+05, 1.6718E+05, 1.6747E+05, 1.6776E+05, 1.6804E+05, 1.6833E+05, 1.6862E+05, &
       1.6891E+05, 1.6919E+05, 1.6948E+05, 1.6977E+05, 1.7006E+05, 1.7035E+05, 1.7064E+05, 1.7093E+05, 1.7122E+05, 1.7152E+05, &
       1.7181E+05, 1.7210E+05, 1.7239E+05, 1.7269E+05, 1.7298E+05, 1.7327E+05, 1.7357E+05, 1.7386E+05, 1.7416E+05, 1.7445E+05, &
       1.7475E+05, 1.7504E+05, 1.7534E+05, 1.7564E+05, 1.7593E+05, 1.7623E+05, 1.7653E+05, 1.7683E+05, 1.7713E+05, 1.7743E+05, &
       1.7773E+05, 1.7803E+05, 1.7833E+05, 1.7863E+05, 1.7893E+05, 1.7923E+05, 1.7953E+05, 1.7984E+05, 1.8014E+05, 1.8044E+05, &
       1.8075E+05, 1.8105E+05, 1.8135E+05, 1.8166E+05, 1.8196E+05, 1.8227E+05, 1.8258E+05, 1.8288E+05, 1.8319E+05, 1.8350E+05, &
       1.8381E+05, 1.8411E+05, 1.8442E+05, 1.8473E+05, 1.8504E+05, 1.8535E+05, 1.8566E+05, 1.8597E+05, 1.8628E+05, 1.8659E+05, &
       1.8690E+05, 1.8722E+05, 1.8753E+05, 1.8784E+05, 1.8816E+05, 1.8847E+05, 1.8878E+05, 1.8910E+05, 1.8941E+05, 1.8973E+05, &
       1.9005E+05, 1.9036E+05, 1.9068E+05, 1.9100E+05, 1.9131E+05, 1.9163E+05, 1.9195E+05, 1.9227E+05, 1.9259E+05, 1.9291E+05, &
       1.9323E+05, 1.9355E+05, 1.9387E+05, 1.9419E+05, 1.9451E+05, 1.9483E+05, 1.9516E+05, 1.9548E+05, 1.9580E+05, 1.9613E+05, &
       1.9645E+05, 1.9678E+05, 1.9710E+05, 1.9743E+05, 1.9775E+05, 1.9808E+05, 1.9840E+05, 1.9873E+05, 1.9906E+05, 1.9939E+05, &
       1.9972E+05, 2.0004E+05, 2.0037E+05, 2.0070E+05, 2.0103E+05, 2.0136E+05, 2.0170E+05, 2.0203E+05, 2.0236E+05, 2.0269E+05, &
       2.0302E+05, 2.0336E+05, 2.0369E+05, 2.0402E+05, 2.0436E+05, 2.0469E+05, 2.0503E+05, 2.0536E+05, 2.0570E+05, 2.0604E+05, &
       2.0637E+05, 2.0671E+05, 2.0705E+05, 2.0739E+05, 2.0773E+05, 2.0807E+05, 2.0841E+05, 2.0875E+05, 2.0909E+05, 2.0943E+05, &
       2.0977E+05, 2.1011E+05, 2.1045E+05, 2.1079E+05, 2.1114E+05, 2.1148E+05, 2.1183E+05, 2.1217E+05, 2.1251E+05, 2.1286E+05, &
       2.1321E+05, 2.1355E+05, 2.1390E+05, 2.1424E+05, 2.1459E+05, 2.1494E+05, 2.1529E+05, 2.1564E+05, 2.1599E+05, 2.1634E+05, &
       2.1669E+05, 2.1704E+05, 2.1739E+05, 2.1774E+05, 2.1809E+05, 2.1844E+05, 2.1880E+05, 2.1915E+05, 2.1950E+05, 2.1986E+05, &
       2.2021E+05, 2.2057E+05, 2.2092E+05, 2.2128E+05, 2.2163E+05, 2.2199E+05, 2.2235E+05, 2.2271E+05, 2.2306E+05, 2.2342E+05, &
       2.2378E+05, 2.2414E+05, 2.2450E+05, 2.2486E+05, 2.2522E+05, 2.2558E+05, 2.2595E+05, 2.2631E+05, 2.2667E+05, 2.2703E+05, &
       2.2740E+05, 2.2776E+05, 2.2813E+05, 2.2849E+05, 2.2886E+05, 2.2922E+05, 2.2959E+05, 2.2995E+05, 2.3032E+05, 2.3069E+05, &
       2.3106E+05, 2.3143E+05, 2.3179E+05, 2.3216E+05, 2.3253E+05, 2.3290E+05, 2.3328E+05, 2.3365E+05, 2.3402E+05, 2.3439E+05, &
       2.3476E+05, 2.3514E+05, 2.3551E+05, 2.3588E+05, 2.3626E+05, 2.3663E+05, 2.3701E+05, 2.3739E+05, 2.3776E+05, 2.3814E+05, &
       2.3852E+05, 2.3889E+05, 2.3927E+05, 2.3965E+05, 2.4003E+05, 2.4041E+05, 2.4079E+05, 2.4117E+05, 2.4155E+05, 2.4193E+05, &
       2.4232E+05, 2.4270E+05, 2.4308E+05, 2.4346E+05, 2.4385E+05, 2.4423E+05, 2.4462E+05, 2.4500E+05, 2.4539E+05, 2.4578E+05, &
       2.4616E+05, 2.4655E+05, 2.4694E+05, 2.4732E+05, 2.4771E+05, 2.4810E+05, 2.4849E+05, 2.4888E+05, 2.4927E+05, 2.4966E+05, &
       2.5006E+05, 2.5045E+05, 2.5084E+05, 2.5123E+05, 2.5163E+05, 2.5202E+05, 2.5241E+05, 2.5281E+05, 2.5320E+05, 2.5360E+05, &
       2.5400E+05, 2.5439E+05, 2.5479E+05, 2.5519E+05, 2.5559E+05, 2.5599E+05, 2.5638E+05, 2.5678E+05, 2.5718E+05, 2.5759E+05, &
       2.5799E+05, 2.5839E+05, 2.5879E+05, 2.5919E+05, 2.5960E+05, 2.6000E+05, 2.6040E+05, 2.6081E+05, 2.6121E+05, 2.6162E+05, &
       2.6202E+05, 2.6243E+05, 2.6284E+05, 2.6325E+05, 2.6365E+05, 2.6406E+05, 2.6447E+05, 2.6488E+05, 2.6529E+05, 2.6570E+05, &
       2.6611E+05, 2.6652E+05, 2.6694E+05, 2.6735E+05, 2.6776E+05, 2.6817E+05, 2.6859E+05, 2.6900E+05, 2.6942E+05, 2.6983E+05, &
       2.7025E+05, 2.7066E+05, 2.7108E+05, 2.7150E+05, 2.7192E+05, 2.7234E+05, 2.7275E+05, 2.7317E+05, 2.7359E+05, 2.7401E+05, &
       2.7443E+05, 2.7486E+05, 2.7528E+05, 2.7570E+05, 2.7612E+05, 2.7655E+05, 2.7697E+05, 2.7739E+05, 2.7782E+05, 2.7824E+05, &
       2.7867E+05, 2.7910E+05, 2.7952E+05, 2.7995E+05, 2.8038E+05, 2.8081E+05, 2.8124E+05, 2.8167E+05, 2.8210E+05, 2.8253E+05, &
       2.8296E+05, 2.8339E+05, 2.8382E+05, 2.8425E+05, 2.8469E+05, 2.8512E+05, 2.8555E+05, 2.8599E+05, 2.8642E+05, 2.8686E+05, &
       2.8730E+05, 2.8773E+05, 2.8817E+05, 2.8861E+05, 2.8905E+05, 2.8948E+05, 2.8992E+05, 2.9036E+05, 2.9080E+05, 2.9124E+05, &
       2.9169E+05, 2.9213E+05, 2.9257E+05, 2.9301E+05, 2.9346E+05, 2.9390E+05, 2.9434E+05, 2.9479E+05, 2.9523E+05, 2.9568E+05, &
       2.9613E+05, 2.9657E+05, 2.9702E+05, 2.9747E+05, 2.9792E+05, 2.9837E+05, 2.9882E+05, 2.9927E+05, 2.9972E+05, 3.0017E+05, &
       3.0062E+05, 3.0107E+05, 3.0152E+05, 3.0198E+05, 3.0243E+05, 3.0289E+05, 3.0334E+05, 3.0380E+05, 3.0425E+05, 3.0471E+05, &
       3.0517E+05, 3.0562E+05, 3.0608E+05, 3.0654E+05, 3.0700E+05, 3.0746E+05, 3.0792E+05, 3.0838E+05, 3.0884E+05, 3.0930E+05, &
       3.0976E+05, 3.1023E+05, 3.1069E+05, 3.1115E+05, 3.1162E+05, 3.1208E+05, 3.1255E+05, 3.1301E+05, 3.1348E+05, 3.1395E+05, &
       3.1442E+05, 3.1488E+05, 3.1535E+05, 3.1582E+05, 3.1629E+05, 3.1676E+05, 3.1723E+05, 3.1770E+05, 3.1818E+05, 3.1865E+05, &
       3.1912E+05, 3.1960E+05, 3.2007E+05, 3.2054E+05, 3.2102E+05, 3.2150E+05, 3.2197E+05, 3.2245E+05, 3.2293E+05, 3.2340E+05, &
       3.2388E+05, 3.2436E+05, 3.2484E+05, 3.2532E+05, 3.2580E+05, 3.2628E+05, 3.2676E+05, 3.2725E+05, 3.2773E+05, 3.2821E+05, &
       3.2870E+05, 3.2918E+05, 3.2967E+05, 3.3015E+05, 3.3064E+05, 3.3112E+05, 3.3161E+05, 3.3210E+05, 3.3259E+05, 3.3308E+05, &
       3.3357E+05, 3.3406E+05, 3.3455E+05, 3.3504E+05, 3.3553E+05, 3.3602E+05, 3.3651E+05, 3.3701E+05, 3.3750E+05, 3.3800E+05, &
       3.3849E+05, 3.3899E+05, 3.3948E+05, 3.3998E+05, 3.4048E+05, 3.4097E+05, 3.4147E+05, 3.4197E+05, 3.4247E+05, 3.4297E+05, &
       3.4347E+05, 3.4397E+05, 3.4448E+05, 3.4498E+05, 3.4548E+05, 3.4598E+05, 3.4649E+05, 3.4699E+05, 3.4750E+05, 3.4800E+05, &
       3.4851E+05, 3.4902E+05, 3.4952E+05, 3.5003E+05, 3.5054E+05, 3.5105E+05, 3.5156E+05, 3.5207E+05, 3.5258E+05, 3.5309E+05, &
       3.5360E+05, 3.5412E+05, 3.5463E+05, 3.5514E+05, 3.5566E+05, 3.5617E+05, 3.5669E+05, 3.5720E+05, 3.5772E+05, 3.5824E+05, &
       3.5875E+05, 3.5927E+05, 3.5979E+05, 3.6031E+05, 3.6083E+05, 3.6135E+05, 3.6187E+05, 3.6239E+05, 3.6292E+05, 3.6344E+05, &
       3.6396E+05, 3.6449E+05, 3.6501E+05, 3.6554E+05, 3.6606E+05, 3.6659E+05, 3.6711E+05, 3.6764E+05, 3.6817E+05, 3.6870E+05, &
       3.6923E+05, 3.6976E+05, 3.7029E+05, 3.7082E+05, 3.7135E+05, 3.7188E+05, 3.7241E+05, 3.7295E+05, 3.7348E+05, 3.7402E+05, &
       3.7455E+05, 3.7509E+05, 3.7562E+05, 3.7616E+05, 3.7670E+05, 3.7724E+05, 3.7777E+05, 3.7831E+05, 3.7885E+05, 3.7939E+05, &
       3.7993E+05, 3.8048E+05, 3.8102E+05, 3.8156E+05, 3.8210E+05, 3.8265E+05, 3.8319E+05, 3.8374E+05, 3.8428E+05, 3.8483E+05, &
       3.8538E+05, 3.8592E+05, 3.8647E+05, 3.8702E+05, 3.8757E+05, 3.8812E+05, 3.8867E+05, 3.8922E+05, 3.8977E+05, 3.9032E+05, &
       3.9088E+05, 3.9143E+05, 3.9198E+05, 3.9254E+05, 3.9309E+05, 3.9365E+05, 3.9421E+05, 3.9476E+05, 3.9532E+05, 3.9588E+05, &
       3.9644E+05, 3.9700E+05, 3.9756E+05, 3.9812E+05, 3.9868E+05, 3.9924E+05, 3.9980E+05, 4.0037E+05, 4.0093E+05, 4.0149E+05, &
       4.0206E+05, 4.0262E+05, 4.0319E+05, 4.0376E+05, 4.0432E+05, 4.0489E+05, 4.0546E+05, 4.0603E+05, 4.0660E+05, 4.0717E+05/
      data (QofT( 3,J),J=2409,4510)/ 4.0774E+05, 4.0831E+05, 4.0888E+05, 4.0946E+05, 4.1003E+05, 4.1060E+05, 4.1118E+05, 4.1175E+05, &
       4.1233E+05, 4.1291E+05, 4.1348E+05, 4.1406E+05, 4.1464E+05, 4.1522E+05, 4.1580E+05, 4.1638E+05, 4.1696E+05, 4.1754E+05, &
       4.1812E+05, 4.1870E+05, 4.1929E+05, 4.1987E+05, 4.2046E+05, 4.2104E+05, 4.2163E+05, 4.2221E+05, 4.2280E+05, 4.2339E+05, &
       4.2398E+05, 4.2456E+05, 4.2515E+05, 4.2574E+05, 4.2633E+05, 4.2693E+05, 4.2752E+05, 4.2811E+05, 4.2870E+05, 4.2930E+05, &
       4.2989E+05, 4.3049E+05, 4.3108E+05, 4.3168E+05, 4.3228E+05, 4.3287E+05, 4.3347E+05, 4.3407E+05, 4.3467E+05, 4.3527E+05, &
       4.3587E+05, 4.3647E+05, 4.3707E+05, 4.3768E+05, 4.3828E+05, 4.3888E+05, 4.3949E+05, 4.4009E+05, 4.4070E+05, 4.4130E+05, &
       4.4191E+05, 4.4252E+05, 4.4313E+05, 4.4374E+05, 4.4435E+05, 4.4496E+05, 4.4557E+05, 4.4618E+05, 4.4679E+05, 4.4740E+05, &
       4.4802E+05, 4.4863E+05, 4.4924E+05, 4.4986E+05, 4.5048E+05, 4.5109E+05, 4.5171E+05, 4.5233E+05, 4.5295E+05, 4.5356E+05, &
       4.5418E+05, 4.5481E+05, 4.5543E+05, 4.5605E+05, 4.5667E+05, 4.5729E+05, 4.5792E+05, 4.5854E+05, 4.5917E+05, 4.5979E+05, &
       4.6042E+05, 4.6104E+05, 4.6167E+05, 4.6230E+05, 4.6293E+05, 4.6356E+05, 4.6419E+05, 4.6482E+05, 4.6545E+05, 4.6608E+05, &
       4.6671E+05, 4.6735E+05, 4.6798E+05, 4.6862E+05, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       162
      data (QofT( 4,J),J=1,2408)/ 6.0000E+00, 6.0003E+00, 6.0106E+00, 6.0686E+00, 6.2126E+00, 6.4588E+00, 6.8073E+00, 7.2517E+00, &
       7.7840E+00, 8.3962E+00, 9.0812E+00, 9.8326E+00, 1.0645E+01, 1.1513E+01, 1.2431E+01, 1.3397E+01, 1.4407E+01, 1.5457E+01, &
       1.6545E+01, 1.7668E+01, 2.0013E+01, 2.2479E+01, 2.5055E+01, 2.7733E+01, 3.0509E+01, 3.3377E+01, 3.6333E+01, 3.9374E+01, &
       4.2498E+01, 4.5702E+01, 4.8985E+01, 5.2343E+01, 5.5776E+01, 5.9282E+01, 6.2860E+01, 6.6507E+01, 7.0223E+01, 7.4006E+01, &
       7.7856E+01, 8.1771E+01, 8.5750E+01, 8.9792E+01, 9.3896E+01, 9.8061E+01, 1.0229E+02, 1.0657E+02, 1.1092E+02, 1.1532E+02, &
       1.1978E+02, 1.2429E+02, 1.2886E+02, 1.3349E+02, 1.3817E+02, 1.4291E+02, 1.4769E+02, 1.5253E+02, 1.5743E+02, 1.6237E+02, &
       1.6737E+02, 1.7241E+02, 1.7751E+02, 1.8266E+02, 1.8785E+02, 1.9310E+02, 1.9839E+02, 2.0373E+02, 2.0912E+02, 2.1455E+02, &
       2.2003E+02, 2.2556E+02, 2.3114E+02, 2.3675E+02, 2.4242E+02, 2.4813E+02, 2.5388E+02, 2.5968E+02, 2.6552E+02, 2.7141E+02, &
       2.7734E+02, 2.8331E+02, 2.8932E+02, 2.9538E+02, 3.0148E+02, 3.0762E+02, 3.1380E+02, 3.2003E+02, 3.2629E+02, 3.3260E+02, &
       3.3894E+02, 3.4533E+02, 3.5176E+02, 3.5822E+02, 3.6473E+02, 3.7127E+02, 3.7786E+02, 3.8448E+02, 3.9114E+02, 3.9784E+02, &
       4.0458E+02, 4.1136E+02, 4.1817E+02, 4.2503E+02, 4.3192E+02, 4.3885E+02, 4.4581E+02, 4.5281E+02, 4.5985E+02, 4.6693E+02, &
       4.7404E+02, 4.8119E+02, 4.8837E+02, 4.9559E+02, 5.0285E+02, 5.1014E+02, 5.1747E+02, 5.2483E+02, 5.3223E+02, 5.3966E+02, &
       5.4713E+02, 5.5464E+02, 5.6218E+02, 5.6975E+02, 5.7736E+02, 5.8500E+02, 5.9268E+02, 6.0039E+02, 6.0813E+02, 6.1591E+02, &
       6.2373E+02, 6.3157E+02, 6.3945E+02, 6.4737E+02, 6.5532E+02, 6.6330E+02, 6.7131E+02, 6.7936E+02, 6.8745E+02, 6.9556E+02, &
       7.0371E+02, 7.1189E+02, 7.2010E+02, 7.2835E+02, 7.3663E+02, 7.4494E+02, 7.5329E+02, 7.6167E+02, 7.7008E+02, 7.7852E+02, &
       7.8700E+02, 7.9551E+02, 8.0405E+02, 8.1262E+02, 8.2123E+02, 8.2987E+02, 8.3854E+02, 8.4724E+02, 8.5598E+02, 8.6474E+02, &
       8.7354E+02, 8.8237E+02, 8.9124E+02, 9.0013E+02, 9.0906E+02, 9.1802E+02, 9.2701E+02, 9.3604E+02, 9.4509E+02, 9.5418E+02, &
       9.6330E+02, 9.7245E+02, 9.8164E+02, 9.9086E+02, 1.0001E+03, 1.0094E+03, 1.0187E+03, 1.0280E+03, 1.0374E+03, 1.0468E+03, &
       1.0563E+03, 1.0657E+03, 1.0752E+03, 1.0848E+03, 1.0944E+03, 1.1040E+03, 1.1136E+03, 1.1232E+03, 1.1329E+03, 1.1427E+03, &
       1.1524E+03, 1.1622E+03, 1.1721E+03, 1.1819E+03, 1.1918E+03, 1.2017E+03, 1.2117E+03, 1.2217E+03, 1.2317E+03, 1.2417E+03, &
       1.2518E+03, 1.2620E+03, 1.2721E+03, 1.2823E+03, 1.2925E+03, 1.3027E+03, 1.3130E+03, 1.3233E+03, 1.3337E+03, 1.3441E+03, &
       1.3545E+03, 1.3649E+03, 1.3754E+03, 1.3859E+03, 1.3965E+03, 1.4070E+03, 1.4176E+03, 1.4283E+03, 1.4390E+03, 1.4497E+03, &
       1.4604E+03, 1.4712E+03, 1.4820E+03, 1.4929E+03, 1.5037E+03, 1.5146E+03, 1.5256E+03, 1.5366E+03, 1.5476E+03, 1.5586E+03, &
       1.5697E+03, 1.5808E+03, 1.5920E+03, 1.6031E+03, 1.6144E+03, 1.6256E+03, 1.6369E+03, 1.6482E+03, 1.6596E+03, 1.6710E+03, &
       1.6824E+03, 1.6938E+03, 1.7053E+03, 1.7169E+03, 1.7284E+03, 1.7400E+03, 1.7516E+03, 1.7633E+03, 1.7750E+03, 1.7867E+03, &
       1.7985E+03, 1.8103E+03, 1.8222E+03, 1.8340E+03, 1.8460E+03, 1.8579E+03, 1.8699E+03, 1.8819E+03, 1.8940E+03, 1.9061E+03, &
       1.9182E+03, 1.9303E+03, 1.9425E+03, 1.9548E+03, 1.9671E+03, 1.9794E+03, 1.9917E+03, 2.0041E+03, 2.0165E+03, 2.0290E+03, &
       2.0414E+03, 2.0540E+03, 2.0665E+03, 2.0791E+03, 2.0918E+03, 2.1045E+03, 2.1172E+03, 2.1299E+03, 2.1427E+03, 2.1555E+03, &
       2.1684E+03, 2.1813E+03, 2.1942E+03, 2.2072E+03, 2.2202E+03, 2.2333E+03, 2.2464E+03, 2.2595E+03, 2.2727E+03, 2.2859E+03, &
       2.2991E+03, 2.3124E+03, 2.3257E+03, 2.3391E+03, 2.3525E+03, 2.3659E+03, 2.3794E+03, 2.3929E+03, 2.4064E+03, 2.4200E+03, &
       2.4337E+03, 2.4473E+03, 2.4610E+03, 2.4748E+03, 2.4886E+03, 2.5024E+03, 2.5163E+03, 2.5302E+03, 2.5441E+03, 2.5581E+03, &
       2.5721E+03, 2.5862E+03, 2.6003E+03, 2.6145E+03, 2.6287E+03, 2.6429E+03, 2.6572E+03, 2.6715E+03, 2.6858E+03, 2.7002E+03, &
       2.7147E+03, 2.7291E+03, 2.7437E+03, 2.7582E+03, 2.7728E+03, 2.7875E+03, 2.8021E+03, 2.8169E+03, 2.8316E+03, 2.8465E+03, &
       2.8613E+03, 2.8762E+03, 2.8911E+03, 2.9061E+03, 2.9211E+03, 2.9362E+03, 2.9513E+03, 2.9665E+03, 2.9817E+03, 2.9969E+03, &
       3.0122E+03, 3.0275E+03, 3.0429E+03, 3.0583E+03, 3.0737E+03, 3.0892E+03, 3.1048E+03, 3.1204E+03, 3.1360E+03, 3.1517E+03, &
       3.1674E+03, 3.1831E+03, 3.1990E+03, 3.2148E+03, 3.2307E+03, 3.2466E+03, 3.2626E+03, 3.2787E+03, 3.2947E+03, 3.3109E+03, &
       3.3270E+03, 3.3432E+03, 3.3595E+03, 3.3758E+03, 3.3922E+03, 3.4085E+03, 3.4250E+03, 3.4415E+03, 3.4580E+03, 3.4746E+03, &
       3.4912E+03, 3.5079E+03, 3.5246E+03, 3.5414E+03, 3.5582E+03, 3.5751E+03, 3.5920E+03, 3.6089E+03, 3.6259E+03, 3.6430E+03, &
       3.6601E+03, 3.6772E+03, 3.6944E+03, 3.7116E+03, 3.7289E+03, 3.7463E+03, 3.7637E+03, 3.7811E+03, 3.7986E+03, 3.8161E+03, &
       3.8337E+03, 3.8513E+03, 3.8690E+03, 3.8867E+03, 3.9045E+03, 3.9223E+03, 3.9402E+03, 3.9581E+03, 3.9761E+03, 3.9941E+03, &
       4.0122E+03, 4.0303E+03, 4.0485E+03, 4.0667E+03, 4.0850E+03, 4.1033E+03, 4.1217E+03, 4.1401E+03, 4.1586E+03, 4.1772E+03, &
       4.1957E+03, 4.2144E+03, 4.2331E+03, 4.2518E+03, 4.2706E+03, 4.2894E+03, 4.3083E+03, 4.3273E+03, 4.3462E+03, 4.3653E+03, &
       4.3844E+03, 4.4036E+03, 4.4228E+03, 4.4420E+03, 4.4613E+03, 4.4807E+03, 4.5001E+03, 4.5196E+03, 4.5391E+03, 4.5587E+03, &
       4.5783E+03, 4.5980E+03, 4.6178E+03, 4.6375E+03, 4.6574E+03, 4.6773E+03, 4.6973E+03, 4.7173E+03, 4.7373E+03, 4.7575E+03, &
       4.7776E+03, 4.7979E+03, 4.8182E+03, 4.8385E+03, 4.8589E+03, 4.8794E+03, 4.8999E+03, 4.9204E+03, 4.9411E+03, 4.9618E+03, &
       4.9825E+03, 5.0033E+03, 5.0241E+03, 5.0450E+03, 5.0660E+03, 5.0870E+03, 5.1081E+03, 5.1292E+03, 5.1504E+03, 5.1717E+03, &
       5.1930E+03, 5.2144E+03, 5.2358E+03, 5.2573E+03, 5.2788E+03, 5.3004E+03, 5.3221E+03, 5.3438E+03, 5.3655E+03, 5.3874E+03, &
       5.4093E+03, 5.4312E+03, 5.4532E+03, 5.4753E+03, 5.4974E+03, 5.5196E+03, 5.5419E+03, 5.5642E+03, 5.5866E+03, 5.6090E+03, &
       5.6315E+03, 5.6541E+03, 5.6767E+03, 5.6993E+03, 5.7221E+03, 5.7449E+03, 5.7677E+03, 5.7907E+03, 5.8136E+03, 5.8367E+03, &
       5.8598E+03, 5.8830E+03, 5.9062E+03, 5.9295E+03, 5.9528E+03, 5.9763E+03, 5.9997E+03, 6.0233E+03, 6.0469E+03, 6.0706E+03, &
       6.0943E+03, 6.1181E+03, 6.1420E+03, 6.1659E+03, 6.1899E+03, 6.2139E+03, 6.2381E+03, 6.2622E+03, 6.2865E+03, 6.3108E+03, &
       6.3352E+03, 6.3596E+03, 6.3841E+03, 6.4087E+03, 6.4334E+03, 6.4581E+03, 6.4828E+03, 6.5077E+03, 6.5326E+03, 6.5575E+03, &
       6.5826E+03, 6.6077E+03, 6.6328E+03, 6.6581E+03, 6.6834E+03, 6.7088E+03, 6.7342E+03, 6.7597E+03, 6.7853E+03, 6.8109E+03, &
       6.8366E+03, 6.8624E+03, 6.8882E+03, 6.9142E+03, 6.9401E+03, 6.9662E+03, 6.9923E+03, 7.0185E+03, 7.0448E+03, 7.0711E+03, &
       7.0975E+03, 7.1240E+03, 7.1505E+03, 7.1771E+03, 7.2038E+03, 7.2305E+03, 7.2573E+03, 7.2842E+03, 7.3112E+03, 7.3382E+03, &
       7.3653E+03, 7.3925E+03, 7.4197E+03, 7.4470E+03, 7.4744E+03, 7.5019E+03, 7.5294E+03, 7.5570E+03, 7.5847E+03, 7.6125E+03, &
       7.6403E+03, 7.6682E+03, 7.6961E+03, 7.7242E+03, 7.7523E+03, 7.7805E+03, 7.8087E+03, 7.8371E+03, 7.8655E+03, 7.8940E+03, &
       7.9225E+03, 7.9512E+03, 7.9799E+03, 8.0086E+03, 8.0375E+03, 8.0664E+03, 8.0954E+03, 8.1245E+03, 8.1537E+03, 8.1829E+03, &
       8.2122E+03, 8.2416E+03, 8.2711E+03, 8.3006E+03, 8.3302E+03, 8.3599E+03, 8.3897E+03, 8.4195E+03, 8.4495E+03, 8.4795E+03, &
       8.5095E+03, 8.5397E+03, 8.5699E+03, 8.6002E+03, 8.6306E+03, 8.6611E+03, 8.6917E+03, 8.7223E+03, 8.7530E+03, 8.7838E+03, &
       8.8146E+03, 8.8456E+03, 8.8766E+03, 8.9077E+03, 8.9389E+03, 8.9702E+03, 9.0015E+03, 9.0329E+03, 9.0644E+03, 9.0960E+03, &
       9.1277E+03, 9.1594E+03, 9.1913E+03, 9.2232E+03, 9.2552E+03, 9.2872E+03, 9.3194E+03, 9.3516E+03, 9.3840E+03, 9.4164E+03, &
       9.4489E+03, 9.4814E+03, 9.5141E+03, 9.5468E+03, 9.5796E+03, 9.6125E+03, 9.6455E+03, 9.6786E+03, 9.7118E+03, 9.7450E+03, &
       9.7783E+03, 9.8117E+03, 9.8452E+03, 9.8788E+03, 9.9125E+03, 9.9462E+03, 9.9801E+03, 1.0014E+04, 1.0048E+04, 1.0082E+04, &
       1.0116E+04, 1.0151E+04, 1.0185E+04, 1.0219E+04, 1.0254E+04, 1.0288E+04, 1.0323E+04, 1.0358E+04, 1.0393E+04, 1.0428E+04, &
       1.0463E+04, 1.0498E+04, 1.0533E+04, 1.0569E+04, 1.0604E+04, 1.0639E+04, 1.0675E+04, 1.0711E+04, 1.0746E+04, 1.0782E+04, &
       1.0818E+04, 1.0854E+04, 1.0890E+04, 1.0927E+04, 1.0963E+04, 1.0999E+04, 1.1036E+04, 1.1072E+04, 1.1109E+04, 1.1146E+04, &
       1.1183E+04, 1.1220E+04, 1.1257E+04, 1.1294E+04, 1.1331E+04, 1.1368E+04, 1.1406E+04, 1.1443E+04, 1.1481E+04, 1.1519E+04, &
       1.1556E+04, 1.1594E+04, 1.1632E+04, 1.1670E+04, 1.1708E+04, 1.1747E+04, 1.1785E+04, 1.1824E+04, 1.1862E+04, 1.1901E+04, &
       1.1939E+04, 1.1978E+04, 1.2017E+04, 1.2056E+04, 1.2095E+04, 1.2135E+04, 1.2174E+04, 1.2213E+04, 1.2253E+04, 1.2292E+04, &
       1.2332E+04, 1.2372E+04, 1.2412E+04, 1.2452E+04, 1.2492E+04, 1.2532E+04, 1.2572E+04, 1.2613E+04, 1.2653E+04, 1.2694E+04, &
       1.2734E+04, 1.2775E+04, 1.2816E+04, 1.2857E+04, 1.2898E+04, 1.2939E+04, 1.2981E+04, 1.3022E+04, 1.3064E+04, 1.3105E+04, &
       1.3147E+04, 1.3189E+04, 1.3230E+04, 1.3272E+04, 1.3315E+04, 1.3357E+04, 1.3399E+04, 1.3441E+04, 1.3484E+04, 1.3527E+04, &
       1.3569E+04, 1.3612E+04, 1.3655E+04, 1.3698E+04, 1.3741E+04, 1.3784E+04, 1.3828E+04, 1.3871E+04, 1.3915E+04, 1.3958E+04, &
       1.4002E+04, 1.4046E+04, 1.4090E+04, 1.4134E+04, 1.4178E+04, 1.4223E+04, 1.4267E+04, 1.4312E+04, 1.4356E+04, 1.4401E+04, &
       1.4446E+04, 1.4491E+04, 1.4536E+04, 1.4581E+04, 1.4626E+04, 1.4671E+04, 1.4717E+04, 1.4762E+04, 1.4808E+04, 1.4854E+04, &
       1.4900E+04, 1.4946E+04, 1.4992E+04, 1.5038E+04, 1.5085E+04, 1.5131E+04, 1.5178E+04, 1.5224E+04, 1.5271E+04, 1.5318E+04, &
       1.5365E+04, 1.5412E+04, 1.5459E+04, 1.5507E+04, 1.5554E+04, 1.5602E+04, 1.5650E+04, 1.5697E+04, 1.5745E+04, 1.5793E+04, &
       1.5842E+04, 1.5890E+04, 1.5938E+04, 1.5987E+04, 1.6035E+04, 1.6084E+04, 1.6133E+04, 1.6182E+04, 1.6231E+04, 1.6280E+04, &
       1.6329E+04, 1.6379E+04, 1.6428E+04, 1.6478E+04, 1.6528E+04, 1.6578E+04, 1.6628E+04, 1.6678E+04, 1.6728E+04, 1.6778E+04, &
       1.6829E+04, 1.6879E+04, 1.6930E+04, 1.6981E+04, 1.7032E+04, 1.7083E+04, 1.7134E+04, 1.7185E+04, 1.7237E+04, 1.7288E+04, &
       1.7340E+04, 1.7392E+04, 1.7444E+04, 1.7496E+04, 1.7548E+04, 1.7600E+04, 1.7653E+04, 1.7705E+04, 1.7758E+04, 1.7810E+04, &
       1.7863E+04, 1.7916E+04, 1.7969E+04, 1.8023E+04, 1.8076E+04, 1.8130E+04, 1.8183E+04, 1.8237E+04, 1.8291E+04, 1.8345E+04, &
       1.8399E+04, 1.8453E+04, 1.8508E+04, 1.8562E+04, 1.8617E+04, 1.8671E+04, 1.8726E+04, 1.8781E+04, 1.8836E+04, 1.8892E+04, &
       1.8947E+04, 1.9003E+04, 1.9058E+04, 1.9114E+04, 1.9170E+04, 1.9226E+04, 1.9282E+04, 1.9338E+04, 1.9395E+04, 1.9451E+04, &
       1.9508E+04, 1.9565E+04, 1.9622E+04, 1.9679E+04, 1.9736E+04, 1.9793E+04, 1.9851E+04, 1.9908E+04, 1.9966E+04, 2.0024E+04, &
       2.0082E+04, 2.0140E+04, 2.0198E+04, 2.0256E+04, 2.0315E+04, 2.0373E+04, 2.0432E+04, 2.0491E+04, 2.0550E+04, 2.0609E+04, &
       2.0669E+04, 2.0728E+04, 2.0788E+04, 2.0847E+04, 2.0907E+04, 2.0967E+04, 2.1027E+04, 2.1087E+04, 2.1148E+04, 2.1208E+04, &
       2.1269E+04, 2.1330E+04, 2.1391E+04, 2.1452E+04, 2.1513E+04, 2.1574E+04, 2.1636E+04, 2.1697E+04, 2.1759E+04, 2.1821E+04, &
       2.1883E+04, 2.1945E+04, 2.2008E+04, 2.2070E+04, 2.2133E+04, 2.2195E+04, 2.2258E+04, 2.2321E+04, 2.2384E+04, 2.2448E+04, &
       2.2511E+04, 2.2575E+04, 2.2638E+04, 2.2702E+04, 2.2766E+04, 2.2830E+04, 2.2895E+04, 2.2959E+04, 2.3024E+04, 2.3088E+04, &
       2.3153E+04, 2.3218E+04, 2.3283E+04, 2.3349E+04, 2.3414E+04, 2.3480E+04, 2.3545E+04, 2.3611E+04, 2.3677E+04, 2.3743E+04, &
       2.3810E+04, 2.3876E+04, 2.3943E+04, 2.4009E+04, 2.4076E+04, 2.4143E+04, 2.4210E+04, 2.4278E+04, 2.4345E+04, 2.4413E+04, &
       2.4481E+04, 2.4549E+04, 2.4617E+04, 2.4685E+04, 2.4753E+04, 2.4822E+04, 2.4890E+04, 2.4959E+04, 2.5028E+04, 2.5097E+04, &
       2.5167E+04, 2.5236E+04, 2.5306E+04, 2.5375E+04, 2.5445E+04, 2.5515E+04, 2.5585E+04, 2.5656E+04, 2.5726E+04, 2.5797E+04, &
       2.5868E+04, 2.5939E+04, 2.6010E+04, 2.6081E+04, 2.6152E+04, 2.6224E+04, 2.6296E+04, 2.6368E+04, 2.6440E+04, 2.6512E+04, &
       2.6584E+04, 2.6657E+04, 2.6729E+04, 2.6802E+04, 2.6875E+04, 2.6948E+04, 2.7022E+04, 2.7095E+04, 2.7169E+04, 2.7242E+04, &
       2.7316E+04, 2.7390E+04, 2.7465E+04, 2.7539E+04, 2.7614E+04, 2.7688E+04, 2.7763E+04, 2.7838E+04, 2.7913E+04, 2.7989E+04, &
       2.8064E+04, 2.8140E+04, 2.8216E+04, 2.8292E+04, 2.8368E+04, 2.8444E+04, 2.8521E+04, 2.8598E+04, 2.8674E+04, 2.8751E+04, &
       2.8828E+04, 2.8906E+04, 2.8983E+04, 2.9061E+04, 2.9139E+04, 2.9217E+04, 2.9295E+04, 2.9373E+04, 2.9452E+04, 2.9530E+04, &
       2.9609E+04, 2.9688E+04, 2.9767E+04, 2.9846E+04, 2.9926E+04, 3.0006E+04, 3.0085E+04, 3.0165E+04, 3.0246E+04, 3.0326E+04, &
       3.0406E+04, 3.0487E+04, 3.0568E+04, 3.0649E+04, 3.0730E+04, 3.0811E+04, 3.0893E+04, 3.0974E+04, 3.1056E+04, 3.1138E+04, &
       3.1220E+04, 3.1303E+04, 3.1385E+04, 3.1468E+04, 3.1551E+04, 3.1634E+04, 3.1717E+04, 3.1801E+04, 3.1884E+04, 3.1968E+04, &
       3.2052E+04, 3.2136E+04, 3.2220E+04, 3.2305E+04, 3.2389E+04, 3.2474E+04, 3.2559E+04, 3.2644E+04, 3.2730E+04, 3.2815E+04, &
       3.2901E+04, 3.2987E+04, 3.3073E+04, 3.3159E+04, 3.3245E+04, 3.3332E+04, 3.3419E+04, 3.3505E+04, 3.3593E+04, 3.3680E+04, &
       3.3767E+04, 3.3855E+04, 3.3943E+04, 3.4031E+04, 3.4119E+04, 3.4207E+04, 3.4296E+04, 3.4385E+04, 3.4474E+04, 3.4563E+04, &
       3.4652E+04, 3.4741E+04, 3.4831E+04, 3.4921E+04, 3.5011E+04, 3.5101E+04, 3.5192E+04, 3.5282E+04, 3.5373E+04, 3.5464E+04, &
       3.5555E+04, 3.5646E+04, 3.5738E+04, 3.5829E+04, 3.5921E+04, 3.6013E+04, 3.6106E+04, 3.6198E+04, 3.6291E+04, 3.6383E+04, &
       3.6476E+04, 3.6570E+04, 3.6663E+04, 3.6756E+04, 3.6850E+04, 3.6944E+04, 3.7038E+04, 3.7133E+04, 3.7227E+04, 3.7322E+04, &
       3.7417E+04, 3.7512E+04, 3.7607E+04, 3.7703E+04, 3.7798E+04, 3.7894E+04, 3.7990E+04, 3.8086E+04, 3.8183E+04, 3.8279E+04, &
       3.8376E+04, 3.8473E+04, 3.8570E+04, 3.8668E+04, 3.8765E+04, 3.8863E+04, 3.8961E+04, 3.9059E+04, 3.9158E+04, 3.9256E+04, &
       3.9355E+04, 3.9454E+04, 3.9553E+04, 3.9653E+04, 3.9752E+04, 3.9852E+04, 3.9952E+04, 4.0052E+04, 4.0152E+04, 4.0253E+04, &
       4.0354E+04, 4.0455E+04, 4.0556E+04, 4.0657E+04, 4.0759E+04, 4.0860E+04, 4.0962E+04, 4.1064E+04, 4.1167E+04, 4.1269E+04, &
       4.1372E+04, 4.1475E+04, 4.1578E+04, 4.1682E+04, 4.1785E+04, 4.1889E+04, 4.1993E+04, 4.2097E+04, 4.2201E+04, 4.2306E+04, &
       4.2411E+04, 4.2516E+04, 4.2621E+04, 4.2726E+04, 4.2832E+04, 4.2938E+04, 4.3044E+04, 4.3150E+04, 4.3257E+04, 4.3363E+04, &
       4.3470E+04, 4.3577E+04, 4.3685E+04, 4.3792E+04, 4.3900E+04, 4.4008E+04, 4.4116E+04, 4.4224E+04, 4.4333E+04, 4.4441E+04, &
       4.4550E+04, 4.4660E+04, 4.4769E+04, 4.4878E+04, 4.4988E+04, 4.5098E+04, 4.5209E+04, 4.5319E+04, 4.5430E+04, 4.5541E+04, &
       4.5652E+04, 4.5763E+04, 4.5874E+04, 4.5986E+04, 4.6098E+04, 4.6210E+04, 4.6323E+04, 4.6435E+04, 4.6548E+04, 4.6661E+04, &
       4.6774E+04, 4.6888E+04, 4.7001E+04, 4.7115E+04, 4.7229E+04, 4.7344E+04, 4.7458E+04, 4.7573E+04, 4.7688E+04, 4.7803E+04, &
       4.7919E+04, 4.8034E+04, 4.8150E+04, 4.8266E+04, 4.8383E+04, 4.8499E+04, 4.8616E+04, 4.8733E+04, 4.8850E+04, 4.8967E+04, &
       4.9085E+04, 4.9203E+04, 4.9321E+04, 4.9439E+04, 4.9558E+04, 4.9676E+04, 4.9795E+04, 4.9915E+04, 5.0034E+04, 5.0154E+04, &
       5.0274E+04, 5.0394E+04, 5.0514E+04, 5.0635E+04, 5.0755E+04, 5.0876E+04, 5.0998E+04, 5.1119E+04, 5.1241E+04, 5.1363E+04, &
       5.1485E+04, 5.1607E+04, 5.1730E+04, 5.1853E+04, 5.1976E+04, 5.2099E+04, 5.2222E+04, 5.2346E+04, 5.2470E+04, 5.2594E+04, &
       5.2719E+04, 5.2844E+04, 5.2968E+04, 5.3094E+04, 5.3219E+04, 5.3345E+04, 5.3470E+04, 5.3596E+04, 5.3723E+04, 5.3849E+04, &
       5.3976E+04, 5.4103E+04, 5.4230E+04, 5.4358E+04, 5.4485E+04, 5.4613E+04, 5.4742E+04, 5.4870E+04, 5.4999E+04, 5.5128E+04, &
       5.5257E+04, 5.5386E+04, 5.5516E+04, 5.5646E+04, 5.5776E+04, 5.5906E+04, 5.6036E+04, 5.6167E+04, 5.6298E+04, 5.6430E+04, &
       5.6561E+04, 5.6693E+04, 5.6825E+04, 5.6957E+04, 5.7090E+04, 5.7222E+04, 5.7355E+04, 5.7488E+04, 5.7622E+04, 5.7756E+04, &
       5.7890E+04, 5.8024E+04, 5.8158E+04, 5.8293E+04, 5.8428E+04, 5.8563E+04, 5.8698E+04, 5.8834E+04, 5.8970E+04, 5.9106E+04, &
       5.9242E+04, 5.9379E+04, 5.9516E+04, 5.9653E+04, 5.9790E+04, 5.9928E+04, 6.0066E+04, 6.0204E+04, 6.0342E+04, 6.0481E+04, &
       6.0620E+04, 6.0759E+04, 6.0898E+04, 6.1038E+04, 6.1178E+04, 6.1318E+04, 6.1458E+04, 6.1599E+04, 6.1740E+04, 6.1881E+04, &
       6.2022E+04, 6.2164E+04, 6.2306E+04, 6.2448E+04, 6.2590E+04, 6.2733E+04, 6.2876E+04, 6.3019E+04, 6.3162E+04, 6.3306E+04, &
       6.3450E+04, 6.3594E+04, 6.3738E+04, 6.3883E+04, 6.4028E+04, 6.4173E+04, 6.4318E+04, 6.4464E+04, 6.4610E+04, 6.4756E+04, &
       6.4903E+04, 6.5049E+04, 6.5196E+04, 6.5344E+04, 6.5491E+04, 6.5639E+04, 6.5787E+04, 6.5935E+04, 6.6084E+04, 6.6232E+04, &
       6.6381E+04, 6.6531E+04, 6.6680E+04, 6.6830E+04, 6.6980E+04, 6.7131E+04, 6.7281E+04, 6.7432E+04, 6.7583E+04, 6.7735E+04, &
       6.7886E+04, 6.8038E+04, 6.8191E+04, 6.8343E+04, 6.8496E+04, 6.8649E+04, 6.8802E+04, 6.8956E+04, 6.9109E+04, 6.9263E+04, &
       6.9418E+04, 6.9572E+04, 6.9727E+04, 6.9882E+04, 7.0038E+04, 7.0193E+04, 7.0349E+04, 7.0506E+04, 7.0662E+04, 7.0819E+04, &
       7.0976E+04, 7.1133E+04, 7.1291E+04, 7.1448E+04, 7.1607E+04, 7.1765E+04, 7.1924E+04, 7.2082E+04, 7.2242E+04, 7.2401E+04, &
       7.2561E+04, 7.2721E+04, 7.2881E+04, 7.3042E+04, 7.3202E+04, 7.3363E+04, 7.3525E+04, 7.3686E+04, 7.3848E+04, 7.4011E+04, &
       7.4173E+04, 7.4336E+04, 7.4499E+04, 7.4662E+04, 7.4826E+04, 7.4989E+04, 7.5154E+04, 7.5318E+04, 7.5483E+04, 7.5648E+04, &
       7.5813E+04, 7.5978E+04, 7.6144E+04, 7.6310E+04, 7.6477E+04, 7.6643E+04, 7.6810E+04, 7.6977E+04, 7.7145E+04, 7.7313E+04, &
       7.7481E+04, 7.7649E+04, 7.7817E+04, 7.7986E+04, 7.8155E+04, 7.8325E+04, 7.8495E+04, 7.8665E+04, 7.8835E+04, 7.9006E+04, &
       7.9176E+04, 7.9347E+04, 7.9519E+04, 7.9691E+04, 7.9863E+04, 8.0035E+04, 8.0207E+04, 8.0380E+04, 8.0553E+04, 8.0727E+04, &
       8.0901E+04, 8.1075E+04, 8.1249E+04, 8.1423E+04, 8.1598E+04, 8.1773E+04, 8.1949E+04, 8.2125E+04, 8.2301E+04, 8.2477E+04, &
       8.2654E+04, 8.2830E+04, 8.3008E+04, 8.3185E+04, 8.3363E+04, 8.3541E+04, 8.3719E+04, 8.3898E+04, 8.4077E+04, 8.4256E+04, &
       8.4435E+04, 8.4615E+04, 8.4795E+04, 8.4976E+04, 8.5156E+04, 8.5337E+04, 8.5519E+04, 8.5700E+04, 8.5882E+04, 8.6064E+04, &
       8.6247E+04, 8.6429E+04, 8.6613E+04, 8.6796E+04, 8.6979E+04, 8.7163E+04, 8.7348E+04, 8.7532E+04, 8.7717E+04, 8.7902E+04, &
       8.8088E+04, 8.8273E+04, 8.8459E+04, 8.8646E+04, 8.8832E+04, 8.9019E+04, 8.9206E+04, 8.9394E+04, 8.9582E+04, 8.9770E+04, &
       8.9958E+04, 9.0147E+04, 9.0336E+04, 9.0525E+04, 9.0715E+04, 9.0905E+04, 9.1095E+04, 9.1286E+04, 9.1476E+04, 9.1668E+04, &
       9.1859E+04, 9.2051E+04, 9.2243E+04, 9.2435E+04, 9.2628E+04, 9.2821E+04, 9.3014E+04, 9.3208E+04, 9.3401E+04, 9.3596E+04, &
       9.3790E+04, 9.3985E+04, 9.4180E+04, 9.4375E+04, 9.4571E+04, 9.4767E+04, 9.4964E+04, 9.5160E+04, 9.5357E+04, 9.5554E+04, &
       9.5752E+04, 9.5950E+04, 9.6148E+04, 9.6347E+04, 9.6545E+04, 9.6745E+04, 9.6944E+04, 9.7144E+04, 9.7344E+04, 9.7544E+04, &
       9.7745E+04, 9.7946E+04, 9.8147E+04, 9.8349E+04, 9.8551E+04, 9.8753E+04, 9.8956E+04, 9.9158E+04, 9.9362E+04, 9.9565E+04, &
       9.9769E+04, 9.9973E+04, 1.0018E+05, 1.0038E+05, 1.0059E+05, 1.0079E+05, 1.0100E+05, 1.0120E+05, 1.0141E+05, 1.0162E+05, &
       1.0182E+05, 1.0203E+05, 1.0224E+05, 1.0245E+05, 1.0266E+05, 1.0286E+05, 1.0307E+05, 1.0328E+05, 1.0349E+05, 1.0370E+05, &
       1.0391E+05, 1.0412E+05, 1.0433E+05, 1.0454E+05, 1.0476E+05, 1.0497E+05, 1.0518E+05, 1.0539E+05, 1.0560E+05, 1.0582E+05, &
       1.0603E+05, 1.0625E+05, 1.0646E+05, 1.0667E+05, 1.0689E+05, 1.0710E+05, 1.0732E+05, 1.0753E+05, 1.0775E+05, 1.0797E+05, &
       1.0818E+05, 1.0840E+05, 1.0862E+05, 1.0883E+05, 1.0905E+05, 1.0927E+05, 1.0949E+05, 1.0971E+05, 1.0993E+05, 1.1015E+05, &
       1.1037E+05, 1.1059E+05, 1.1081E+05, 1.1103E+05, 1.1125E+05, 1.1147E+05, 1.1169E+05, 1.1192E+05, 1.1214E+05, 1.1236E+05, &
       1.1258E+05, 1.1281E+05, 1.1303E+05, 1.1326E+05, 1.1348E+05, 1.1371E+05, 1.1393E+05, 1.1416E+05, 1.1438E+05, 1.1461E+05, &
       1.1483E+05, 1.1506E+05, 1.1529E+05, 1.1552E+05, 1.1574E+05, 1.1597E+05, 1.1620E+05, 1.1643E+05, 1.1666E+05, 1.1689E+05, &
       1.1712E+05, 1.1735E+05, 1.1758E+05, 1.1781E+05, 1.1804E+05, 1.1827E+05, 1.1850E+05, 1.1874E+05, 1.1897E+05, 1.1920E+05, &
       1.1944E+05, 1.1967E+05, 1.1990E+05, 1.2014E+05, 1.2037E+05, 1.2061E+05, 1.2084E+05, 1.2108E+05, 1.2131E+05, 1.2155E+05, &
       1.2179E+05, 1.2202E+05, 1.2226E+05, 1.2250E+05, 1.2274E+05, 1.2297E+05, 1.2321E+05, 1.2345E+05, 1.2369E+05, 1.2393E+05, &
       1.2417E+05, 1.2441E+05, 1.2465E+05, 1.2489E+05, 1.2514E+05, 1.2538E+05, 1.2562E+05, 1.2586E+05, 1.2610E+05, 1.2635E+05, &
       1.2659E+05, 1.2684E+05, 1.2708E+05, 1.2732E+05, 1.2757E+05, 1.2781E+05, 1.2806E+05, 1.2831E+05, 1.2855E+05, 1.2880E+05, &
       1.2905E+05, 1.2929E+05, 1.2954E+05, 1.2979E+05, 1.3004E+05, 1.3029E+05, 1.3053E+05, 1.3078E+05, 1.3103E+05, 1.3128E+05, &
       1.3153E+05, 1.3179E+05, 1.3204E+05, 1.3229E+05, 1.3254E+05, 1.3279E+05, 1.3304E+05, 1.3330E+05, 1.3355E+05, 1.3380E+05, &
       1.3406E+05, 1.3431E+05, 1.3457E+05, 1.3482E+05, 1.3508E+05, 1.3533E+05, 1.3559E+05, 1.3585E+05, 1.3610E+05, 1.3636E+05, &
       1.3662E+05, 1.3688E+05, 1.3713E+05, 1.3739E+05, 1.3765E+05, 1.3791E+05, 1.3817E+05, 1.3843E+05, 1.3869E+05, 1.3895E+05, &
       1.3921E+05, 1.3947E+05, 1.3974E+05, 1.4000E+05, 1.4026E+05, 1.4052E+05, 1.4079E+05, 1.4105E+05, 1.4131E+05, 1.4158E+05, &
       1.4184E+05, 1.4211E+05, 1.4237E+05, 1.4264E+05, 1.4291E+05, 1.4317E+05, 1.4344E+05, 1.4371E+05, 1.4397E+05, 1.4424E+05, &
       1.4451E+05, 1.4478E+05, 1.4505E+05, 1.4532E+05, 1.4559E+05, 1.4586E+05, 1.4613E+05, 1.4640E+05, 1.4667E+05, 1.4694E+05, &
       1.4721E+05, 1.4749E+05, 1.4776E+05, 1.4803E+05, 1.4831E+05, 1.4858E+05, 1.4885E+05, 1.4913E+05, 1.4940E+05, 1.4968E+05, &
       1.4995E+05, 1.5023E+05, 1.5051E+05, 1.5078E+05, 1.5106E+05, 1.5134E+05, 1.5161E+05, 1.5189E+05, 1.5217E+05, 1.5245E+05, &
       1.5273E+05, 1.5301E+05, 1.5329E+05, 1.5357E+05, 1.5385E+05, 1.5413E+05, 1.5441E+05, 1.5470E+05, 1.5498E+05, 1.5526E+05, &
       1.5554E+05, 1.5583E+05, 1.5611E+05, 1.5639E+05, 1.5668E+05, 1.5696E+05, 1.5725E+05, 1.5753E+05, 1.5782E+05, 1.5811E+05, &
       1.5839E+05, 1.5868E+05, 1.5897E+05, 1.5926E+05, 1.5954E+05, 1.5983E+05, 1.6012E+05, 1.6041E+05, 1.6070E+05, 1.6099E+05, &
       1.6128E+05, 1.6157E+05, 1.6186E+05, 1.6215E+05, 1.6245E+05, 1.6274E+05, 1.6303E+05, 1.6332E+05, 1.6362E+05, 1.6391E+05, &
       1.6421E+05, 1.6450E+05, 1.6480E+05, 1.6509E+05, 1.6539E+05, 1.6568E+05, 1.6598E+05, 1.6628E+05, 1.6657E+05, 1.6687E+05, &
       1.6717E+05, 1.6747E+05, 1.6777E+05, 1.6807E+05, 1.6836E+05, 1.6866E+05, 1.6897E+05, 1.6927E+05, 1.6957E+05, 1.6987E+05, &
       1.7017E+05, 1.7047E+05, 1.7077E+05, 1.7108E+05, 1.7138E+05, 1.7168E+05, 1.7199E+05, 1.7229E+05, 1.7260E+05, 1.7290E+05, &
       1.7321E+05, 1.7352E+05, 1.7382E+05, 1.7413E+05, 1.7444E+05, 1.7474E+05, 1.7505E+05, 1.7536E+05, 1.7567E+05, 1.7598E+05, &
       1.7629E+05, 1.7660E+05, 1.7691E+05, 1.7722E+05, 1.7753E+05, 1.7784E+05, 1.7815E+05, 1.7846E+05, 1.7878E+05, 1.7909E+05, &
       1.7940E+05, 1.7972E+05, 1.8003E+05, 1.8034E+05, 1.8066E+05, 1.8098E+05, 1.8129E+05, 1.8161E+05, 1.8192E+05, 1.8224E+05, &
       1.8256E+05, 1.8287E+05, 1.8319E+05, 1.8351E+05, 1.8383E+05, 1.8415E+05, 1.8447E+05, 1.8479E+05, 1.8511E+05, 1.8543E+05, &
       1.8575E+05, 1.8607E+05, 1.8639E+05, 1.8672E+05, 1.8704E+05, 1.8736E+05, 1.8769E+05, 1.8801E+05, 1.8833E+05, 1.8866E+05, &
       1.8898E+05, 1.8931E+05, 1.8963E+05, 1.8996E+05, 1.9029E+05, 1.9061E+05, 1.9094E+05, 1.9127E+05, 1.9160E+05, 1.9193E+05, &
       1.9226E+05, 1.9258E+05, 1.9291E+05, 1.9324E+05, 1.9358E+05, 1.9391E+05, 1.9424E+05, 1.9457E+05, 1.9490E+05, 1.9523E+05, &
       1.9557E+05, 1.9590E+05, 1.9623E+05, 1.9657E+05, 1.9690E+05, 1.9724E+05, 1.9757E+05, 1.9791E+05, 1.9824E+05, 1.9858E+05, &
       1.9892E+05, 1.9926E+05, 1.9959E+05, 1.9993E+05, 2.0027E+05, 2.0061E+05, 2.0095E+05, 2.0129E+05, 2.0163E+05, 2.0197E+05, &
       2.0231E+05, 2.0265E+05, 2.0299E+05, 2.0333E+05, 2.0368E+05, 2.0402E+05, 2.0436E+05, 2.0471E+05, 2.0505E+05, 2.0539E+05, &
       2.0574E+05, 2.0608E+05, 2.0643E+05, 2.0678E+05, 2.0712E+05, 2.0747E+05, 2.0782E+05, 2.0817E+05, 2.0851E+05, 2.0886E+05, &
       2.0921E+05, 2.0956E+05, 2.0991E+05, 2.1026E+05, 2.1061E+05, 2.1096E+05, 2.1131E+05, 2.1166E+05, 2.1202E+05, 2.1237E+05, &
       2.1272E+05, 2.1308E+05, 2.1343E+05, 2.1378E+05, 2.1414E+05, 2.1449E+05, 2.1485E+05, 2.1520E+05, 2.1556E+05, 2.1592E+05, &
       2.1627E+05, 2.1663E+05, 2.1699E+05, 2.1735E+05, 2.1771E+05, 2.1806E+05, 2.1842E+05, 2.1878E+05, 2.1914E+05, 2.1950E+05, &
       2.1987E+05, 2.2023E+05, 2.2059E+05, 2.2095E+05, 2.2131E+05, 2.2168E+05, 2.2204E+05, 2.2240E+05, 2.2277E+05, 2.2313E+05, &
       2.2350E+05, 2.2386E+05, 2.2423E+05, 2.2460E+05, 2.2496E+05, 2.2533E+05, 2.2570E+05, 2.2607E+05, 2.2643E+05, 2.2680E+05, &
       2.2717E+05, 2.2754E+05, 2.2791E+05, 2.2828E+05, 2.2865E+05, 2.2902E+05, 2.2940E+05, 2.2977E+05, 2.3014E+05, 2.3051E+05, &
       2.3089E+05, 2.3126E+05, 2.3164E+05, 2.3201E+05, 2.3238E+05, 2.3276E+05, 2.3314E+05, 2.3351E+05, 2.3389E+05, 2.3427E+05, &
       2.3464E+05, 2.3502E+05, 2.3540E+05, 2.3578E+05, 2.3616E+05, 2.3654E+05, 2.3692E+05, 2.3730E+05, 2.3768E+05, 2.3806E+05, &
       2.3844E+05, 2.3882E+05, 2.3921E+05, 2.3959E+05, 2.3997E+05, 2.4035E+05, 2.4074E+05, 2.4112E+05, 2.4151E+05, 2.4189E+05, &
       2.4228E+05, 2.4267E+05, 2.4305E+05, 2.4344E+05, 2.4383E+05, 2.4421E+05, 2.4460E+05, 2.4499E+05, 2.4538E+05, 2.4577E+05, &
       2.4616E+05, 2.4655E+05, 2.4694E+05, 2.4733E+05, 2.4772E+05, 2.4812E+05, 2.4851E+05, 2.4890E+05, 2.4929E+05, 2.4969E+05, &
       2.5008E+05, 2.5048E+05, 2.5087E+05, 2.5127E+05, 2.5166E+05, 2.5206E+05, 2.5245E+05, 2.5285E+05, 2.5325E+05, 2.5365E+05, &
       2.5405E+05, 2.5444E+05, 2.5484E+05, 2.5524E+05, 2.5564E+05, 2.5604E+05, 2.5644E+05, 2.5684E+05, 2.5725E+05, 2.5765E+05, &
       2.5805E+05, 2.5845E+05, 2.5886E+05, 2.5926E+05, 2.5966E+05, 2.6007E+05, 2.6047E+05, 2.6088E+05, 2.6129E+05, 2.6169E+05, &
       2.6210E+05, 2.6251E+05, 2.6291E+05, 2.6332E+05, 2.6373E+05, 2.6414E+05, 2.6455E+05, 2.6496E+05, 2.6537E+05, 2.6578E+05, &
       2.6619E+05, 2.6660E+05, 2.6701E+05, 2.6742E+05, 2.6784E+05, 2.6825E+05, 2.6866E+05, 2.6908E+05, 2.6949E+05, 2.6991E+05, &
       2.7032E+05, 2.7074E+05, 2.7115E+05, 2.7157E+05, 2.7199E+05, 2.7240E+05, 2.7282E+05, 2.7324E+05, 2.7366E+05, 2.7408E+05, &
       2.7449E+05, 2.7491E+05, 2.7533E+05, 2.7576E+05, 2.7618E+05, 2.7660E+05, 2.7702E+05, 2.7744E+05, 2.7786E+05, 2.7829E+05, &
       2.7871E+05, 2.7914E+05, 2.7956E+05, 2.7998E+05, 2.8041E+05, 2.8084E+05, 2.8126E+05, 2.8169E+05, 2.8212E+05, 2.8254E+05, &
       2.8297E+05, 2.8340E+05, 2.8383E+05, 2.8426E+05, 2.8469E+05, 2.8512E+05, 2.8555E+05, 2.8598E+05, 2.8641E+05, 2.8684E+05, &
       2.8727E+05, 2.8771E+05, 2.8814E+05, 2.8857E+05, 2.8901E+05, 2.8944E+05, 2.8987E+05, 2.9031E+05, 2.9075E+05, 2.9118E+05, &
       2.9162E+05, 2.9205E+05, 2.9249E+05, 2.9293E+05, 2.9337E+05, 2.9381E+05, 2.9424E+05, 2.9468E+05, 2.9512E+05, 2.9556E+05, &
       2.9601E+05, 2.9645E+05, 2.9689E+05, 2.9733E+05, 2.9777E+05, 2.9821E+05, 2.9866E+05, 2.9910E+05, 2.9955E+05, 2.9999E+05, &
       3.0044E+05, 3.0088E+05, 3.0133E+05, 3.0177E+05, 3.0222E+05, 3.0267E+05, 3.0311E+05, 3.0356E+05, 3.0401E+05, 3.0446E+05, &
       3.0491E+05, 3.0536E+05, 3.0581E+05, 3.0626E+05, 3.0671E+05, 3.0716E+05, 3.0761E+05, 3.0807E+05, 3.0852E+05, 3.0897E+05, &
       3.0943E+05, 3.0988E+05, 3.1033E+05, 3.1079E+05, 3.1124E+05, 3.1170E+05, 3.1216E+05, 3.1261E+05, 3.1307E+05, 3.1353E+05, &
       3.1398E+05, 3.1444E+05, 3.1490E+05, 3.1536E+05, 3.1582E+05, 3.1628E+05, 3.1674E+05, 3.1720E+05, 3.1766E+05, 3.1813E+05, &
       3.1859E+05, 3.1905E+05, 3.1951E+05, 3.1998E+05, 3.2044E+05, 3.2090E+05, 3.2137E+05, 3.2184E+05, 3.2230E+05, 3.2277E+05, &
       3.2323E+05, 3.2370E+05, 3.2417E+05, 3.2464E+05, 3.2510E+05, 3.2557E+05, 3.2604E+05, 3.2651E+05, 3.2698E+05, 3.2745E+05, &
       3.2792E+05, 3.2839E+05, 3.2887E+05, 3.2934E+05, 3.2981E+05, 3.3028E+05, 3.3076E+05, 3.3123E+05, 3.3171E+05, 3.3218E+05, &
       3.3266E+05, 3.3313E+05, 3.3361E+05, 3.3408E+05, 3.3456E+05, 3.3504E+05, 3.3552E+05, 3.3599E+05, 3.3647E+05, 3.3695E+05, &
       3.3743E+05, 3.3791E+05, 3.3839E+05, 3.3887E+05, 3.3935E+05, 3.3984E+05, 3.4032E+05, 3.4080E+05, 3.4128E+05, 3.4177E+05, &
       3.4225E+05, 3.4273E+05, 3.4322E+05, 3.4370E+05, 3.4419E+05, 3.4468E+05, 3.4516E+05, 3.4565E+05, 3.4614E+05, 3.4663E+05, &
       3.4711E+05, 3.4760E+05, 3.4809E+05, 3.4858E+05, 3.4907E+05, 3.4956E+05, 3.5005E+05, 3.5054E+05, 3.5104E+05, 3.5153E+05, &
       3.5202E+05, 3.5251E+05, 3.5301E+05, 3.5350E+05, 3.5400E+05, 3.5449E+05, 3.5499E+05, 3.5548E+05, 3.5598E+05, 3.5647E+05, &
       3.5697E+05, 3.5747E+05, 3.5797E+05, 3.5846E+05, 3.5896E+05, 3.5946E+05, 3.5996E+05, 3.6046E+05, 3.6096E+05, 3.6146E+05, &
       3.6196E+05, 3.6247E+05, 3.6297E+05, 3.6347E+05, 3.6397E+05, 3.6448E+05, 3.6498E+05, 3.6549E+05, 3.6599E+05, 3.6650E+05, &
       3.6700E+05, 3.6751E+05, 3.6801E+05, 3.6852E+05, 3.6903E+05, 3.6954E+05, 3.7005E+05, 3.7055E+05, 3.7106E+05, 3.7157E+05, &
       3.7208E+05, 3.7259E+05, 3.7310E+05, 3.7362E+05, 3.7413E+05, 3.7464E+05, 3.7515E+05, 3.7567E+05, 3.7618E+05, 3.7669E+05, &
       3.7721E+05, 3.7772E+05, 3.7824E+05, 3.7875E+05, 3.7927E+05, 3.7979E+05, 3.8030E+05, 3.8082E+05, 3.8134E+05, 3.8186E+05, &
       3.8238E+05, 3.8290E+05, 3.8342E+05, 3.8394E+05, 3.8446E+05, 3.8498E+05, 3.8550E+05, 3.8602E+05, 3.8654E+05, 3.8707E+05, &
       3.8759E+05, 3.8811E+05, 3.8864E+05, 3.8916E+05, 3.8969E+05, 3.9021E+05, 3.9074E+05, 3.9126E+05, 3.9179E+05, 3.9232E+05, &
       3.9285E+05, 3.9337E+05, 3.9390E+05, 3.9443E+05, 3.9496E+05, 3.9549E+05, 3.9602E+05, 3.9655E+05, 3.9708E+05, 3.9761E+05, &
       3.9815E+05, 3.9868E+05, 3.9921E+05, 3.9974E+05, 4.0028E+05, 4.0081E+05, 4.0135E+05, 4.0188E+05, 4.0242E+05, 4.0295E+05, &
       4.0349E+05, 4.0403E+05, 4.0456E+05, 4.0510E+05, 4.0564E+05, 4.0618E+05, 4.0672E+05, 4.0726E+05, 4.0780E+05, 4.0834E+05, &
       4.0888E+05, 4.0942E+05, 4.0996E+05, 4.1050E+05, 4.1104E+05, 4.1159E+05, 4.1213E+05, 4.1267E+05, 4.1322E+05, 4.1376E+05, &
       4.1431E+05, 4.1485E+05, 4.1540E+05, 4.1595E+05, 4.1649E+05, 4.1704E+05, 4.1759E+05, 4.1814E+05, 4.1869E+05, 4.1924E+05, &
       4.1978E+05, 4.2033E+05, 4.2089E+05, 4.2144E+05, 4.2199E+05, 4.2254E+05, 4.2309E+05, 4.2364E+05, 4.2420E+05, 4.2475E+05, &
       4.2530E+05, 4.2586E+05, 4.2641E+05, 4.2697E+05, 4.2752E+05, 4.2808E+05, 4.2864E+05, 4.2919E+05, 4.2975E+05, 4.3031E+05/
      data (QofT( 4,J),J=2409,4510)/ 4.3087E+05, 4.3143E+05, 4.3199E+05, 4.3254E+05, 4.3311E+05, 4.3367E+05, 4.3423E+05, 4.3479E+05, &
       4.3535E+05, 4.3591E+05, 4.3647E+05, 4.3704E+05, 4.3760E+05, 4.3817E+05, 4.3873E+05, 4.3929E+05, 4.3986E+05, 4.4043E+05, &
       4.4099E+05, 4.4156E+05, 4.4213E+05, 4.4269E+05, 4.4326E+05, 4.4383E+05, 4.4440E+05, 4.4497E+05, 4.4554E+05, 4.4611E+05, &
       4.4668E+05, 4.4725E+05, 4.4782E+05, 4.4839E+05, 4.4896E+05, 4.4954E+05, 4.5011E+05, 4.5068E+05, 4.5126E+05, 4.5183E+05, &
       4.5241E+05, 4.5298E+05, 4.5356E+05, 4.5414E+05, 4.5471E+05, 4.5529E+05, 4.5587E+05, 4.5645E+05, 4.5702E+05, 4.5760E+05, &
       4.5818E+05, 4.5876E+05, 4.5934E+05, 4.5992E+05, 4.6050E+05, 4.6109E+05, 4.6167E+05, 4.6225E+05, 4.6283E+05, 4.6342E+05, &
       4.6400E+05, 4.6458E+05, 4.6517E+05, 4.6575E+05, 4.6634E+05, 4.6692E+05, 4.6751E+05, 4.6810E+05, 4.6868E+05, 4.6927E+05, &
       4.6986E+05, 4.7045E+05, 4.7104E+05, 4.7163E+05, 4.7222E+05, 4.7281E+05, 4.7340E+05, 4.7399E+05, 4.7458E+05, 4.7517E+05, &
       4.7577E+05, 4.7636E+05, 4.7695E+05, 4.7755E+05, 4.7814E+05, 4.7873E+05, 4.7933E+05, 4.7993E+05, 4.8052E+05, 4.8112E+05, &
       4.8171E+05, 4.8231E+05, 4.8291E+05, 4.8351E+05, 4.8411E+05, 4.8471E+05, 4.8531E+05, 4.8591E+05, 4.8651E+05, 4.8711E+05, &
       4.8771E+05, 4.8831E+05, 4.8891E+05, 4.8951E+05, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       182
      data (QofT( 5,J),J=1,2408)/ 6.0000E+00, 6.0003E+00, 6.0111E+00, 6.0709E+00, 6.2186E+00, 6.4702E+00, 6.8259E+00, 7.2791E+00, &
       7.8214E+00, 8.4450E+00, 9.1423E+00, 9.9067E+00, 1.0733E+01, 1.1614E+01, 1.2548E+01, 1.3529E+01, 1.4553E+01, 1.5619E+01, &
       1.6722E+01, 1.7861E+01, 2.0238E+01, 2.2736E+01, 2.5345E+01, 2.8058E+01, 3.0868E+01, 3.3772E+01, 3.6765E+01, 3.9844E+01, &
       4.3007E+01, 4.6252E+01, 4.9575E+01, 5.2975E+01, 5.6451E+01, 6.0001E+01, 6.3623E+01, 6.7315E+01, 7.1078E+01, 7.4908E+01, &
       7.8806E+01, 8.2770E+01, 8.6798E+01, 9.0891E+01, 9.5046E+01, 9.9263E+01, 1.0354E+02, 1.0788E+02, 1.1228E+02, 1.1674E+02, &
       1.2125E+02, 1.2582E+02, 1.3045E+02, 1.3513E+02, 1.3987E+02, 1.4467E+02, 1.4952E+02, 1.5442E+02, 1.5937E+02, 1.6438E+02, &
       1.6944E+02, 1.7455E+02, 1.7971E+02, 1.8492E+02, 1.9018E+02, 1.9549E+02, 2.0085E+02, 2.0625E+02, 2.1171E+02, 2.1721E+02, &
       2.2276E+02, 2.2836E+02, 2.3400E+02, 2.3969E+02, 2.4543E+02, 2.5121E+02, 2.5704E+02, 2.6291E+02, 2.6882E+02, 2.7478E+02, &
       2.8079E+02, 2.8683E+02, 2.9292E+02, 2.9905E+02, 3.0523E+02, 3.1145E+02, 3.1771E+02, 3.2401E+02, 3.3035E+02, 3.3674E+02, &
       3.4316E+02, 3.4963E+02, 3.5614E+02, 3.6268E+02, 3.6927E+02, 3.7590E+02, 3.8257E+02, 3.8927E+02, 3.9602E+02, 4.0280E+02, &
       4.0963E+02, 4.1649E+02, 4.2339E+02, 4.3033E+02, 4.3730E+02, 4.4432E+02, 4.5137E+02, 4.5846E+02, 4.6559E+02, 4.7275E+02, &
       4.7995E+02, 4.8719E+02, 4.9447E+02, 5.0178E+02, 5.0913E+02, 5.1651E+02, 5.2393E+02, 5.3139E+02, 5.3888E+02, 5.4640E+02, &
       5.5397E+02, 5.6157E+02, 5.6920E+02, 5.7687E+02, 5.8457E+02, 5.9231E+02, 6.0008E+02, 6.0789E+02, 6.1573E+02, 6.2361E+02, &
       6.3152E+02, 6.3947E+02, 6.4745E+02, 6.5546E+02, 6.6351E+02, 6.7159E+02, 6.7971E+02, 6.8786E+02, 6.9604E+02, 7.0426E+02, &
       7.1251E+02, 7.2080E+02, 7.2911E+02, 7.3746E+02, 7.4585E+02, 7.5427E+02, 7.6272E+02, 7.7120E+02, 7.7972E+02, 7.8827E+02, &
       7.9685E+02, 8.0547E+02, 8.1411E+02, 8.2280E+02, 8.3151E+02, 8.4026E+02, 8.4904E+02, 8.5785E+02, 8.6669E+02, 8.7557E+02, &
       8.8448E+02, 8.9343E+02, 9.0240E+02, 9.1141E+02, 9.2045E+02, 9.2952E+02, 9.3863E+02, 9.4777E+02, 9.5694E+02, 9.6614E+02, &
       9.7538E+02, 9.8465E+02, 9.9395E+02, 1.0033E+03, 1.0126E+03, 1.0220E+03, 1.0315E+03, 1.0409E+03, 1.0504E+03, 1.0600E+03, &
       1.0695E+03, 1.0791E+03, 1.0887E+03, 1.0984E+03, 1.1081E+03, 1.1178E+03, 1.1276E+03, 1.1374E+03, 1.1472E+03, 1.1570E+03, &
       1.1669E+03, 1.1768E+03, 1.1868E+03, 1.1968E+03, 1.2068E+03, 1.2168E+03, 1.2269E+03, 1.2370E+03, 1.2472E+03, 1.2574E+03, &
       1.2676E+03, 1.2778E+03, 1.2881E+03, 1.2984E+03, 1.3088E+03, 1.3192E+03, 1.3296E+03, 1.3400E+03, 1.3505E+03, 1.3610E+03, &
       1.3716E+03, 1.3821E+03, 1.3928E+03, 1.4034E+03, 1.4141E+03, 1.4248E+03, 1.4355E+03, 1.4463E+03, 1.4571E+03, 1.4680E+03, &
       1.4789E+03, 1.4898E+03, 1.5007E+03, 1.5117E+03, 1.5228E+03, 1.5338E+03, 1.5449E+03, 1.5560E+03, 1.5672E+03, 1.5784E+03, &
       1.5896E+03, 1.6009E+03, 1.6122E+03, 1.6235E+03, 1.6348E+03, 1.6462E+03, 1.6577E+03, 1.6692E+03, 1.6807E+03, 1.6922E+03, &
       1.7038E+03, 1.7154E+03, 1.7270E+03, 1.7387E+03, 1.7504E+03, 1.7622E+03, 1.7740E+03, 1.7858E+03, 1.7977E+03, 1.8095E+03, &
       1.8215E+03, 1.8334E+03, 1.8454E+03, 1.8575E+03, 1.8696E+03, 1.8817E+03, 1.8938E+03, 1.9060E+03, 1.9182E+03, 1.9305E+03, &
       1.9428E+03, 1.9551E+03, 1.9675E+03, 1.9799E+03, 1.9923E+03, 2.0048E+03, 2.0173E+03, 2.0299E+03, 2.0425E+03, 2.0551E+03, &
       2.0678E+03, 2.0805E+03, 2.0932E+03, 2.1060E+03, 2.1188E+03, 2.1317E+03, 2.1445E+03, 2.1575E+03, 2.1704E+03, 2.1834E+03, &
       2.1965E+03, 2.2096E+03, 2.2227E+03, 2.2359E+03, 2.2491E+03, 2.2623E+03, 2.2756E+03, 2.2889E+03, 2.3022E+03, 2.3156E+03, &
       2.3291E+03, 2.3425E+03, 2.3561E+03, 2.3696E+03, 2.3832E+03, 2.3968E+03, 2.4105E+03, 2.4242E+03, 2.4380E+03, 2.4518E+03, &
       2.4656E+03, 2.4795E+03, 2.4934E+03, 2.5073E+03, 2.5213E+03, 2.5354E+03, 2.5494E+03, 2.5635E+03, 2.5777E+03, 2.5919E+03, &
       2.6061E+03, 2.6204E+03, 2.6347E+03, 2.6491E+03, 2.6635E+03, 2.6780E+03, 2.6924E+03, 2.7070E+03, 2.7215E+03, 2.7362E+03, &
       2.7508E+03, 2.7655E+03, 2.7802E+03, 2.7950E+03, 2.8099E+03, 2.8247E+03, 2.8396E+03, 2.8546E+03, 2.8696E+03, 2.8846E+03, &
       2.8997E+03, 2.9148E+03, 2.9300E+03, 2.9452E+03, 2.9605E+03, 2.9758E+03, 2.9911E+03, 3.0065E+03, 3.0219E+03, 3.0374E+03, &
       3.0529E+03, 3.0685E+03, 3.0841E+03, 3.0998E+03, 3.1155E+03, 3.1312E+03, 3.1470E+03, 3.1628E+03, 3.1787E+03, 3.1946E+03, &
       3.2106E+03, 3.2266E+03, 3.2427E+03, 3.2588E+03, 3.2750E+03, 3.2912E+03, 3.3074E+03, 3.3237E+03, 3.3400E+03, 3.3564E+03, &
       3.3728E+03, 3.3893E+03, 3.4058E+03, 3.4224E+03, 3.4390E+03, 3.4557E+03, 3.4724E+03, 3.4892E+03, 3.5060E+03, 3.5228E+03, &
       3.5397E+03, 3.5567E+03, 3.5737E+03, 3.5907E+03, 3.6078E+03, 3.6250E+03, 3.6421E+03, 3.6594E+03, 3.6767E+03, 3.6940E+03, &
       3.7114E+03, 3.7288E+03, 3.7463E+03, 3.7638E+03, 3.7814E+03, 3.7991E+03, 3.8167E+03, 3.8345E+03, 3.8522E+03, 3.8701E+03, &
       3.8880E+03, 3.9059E+03, 3.9239E+03, 3.9419E+03, 3.9600E+03, 3.9781E+03, 3.9963E+03, 4.0145E+03, 4.0328E+03, 4.0511E+03, &
       4.0695E+03, 4.0880E+03, 4.1065E+03, 4.1250E+03, 4.1436E+03, 4.1622E+03, 4.1809E+03, 4.1997E+03, 4.2185E+03, 4.2374E+03, &
       4.2563E+03, 4.2752E+03, 4.2942E+03, 4.3133E+03, 4.3324E+03, 4.3516E+03, 4.3708E+03, 4.3901E+03, 4.4094E+03, 4.4288E+03, &
       4.4483E+03, 4.4677E+03, 4.4873E+03, 4.5069E+03, 4.5266E+03, 4.5463E+03, 4.5660E+03, 4.5859E+03, 4.6057E+03, 4.6257E+03, &
       4.6456E+03, 4.6657E+03, 4.6858E+03, 4.7059E+03, 4.7261E+03, 4.7464E+03, 4.7667E+03, 4.7871E+03, 4.8075E+03, 4.8280E+03, &
       4.8486E+03, 4.8692E+03, 4.8898E+03, 4.9105E+03, 4.9313E+03, 4.9521E+03, 4.9730E+03, 4.9940E+03, 5.0150E+03, 5.0360E+03, &
       5.0571E+03, 5.0783E+03, 5.0996E+03, 5.1208E+03, 5.1422E+03, 5.1636E+03, 5.1851E+03, 5.2066E+03, 5.2282E+03, 5.2498E+03, &
       5.2715E+03, 5.2933E+03, 5.3151E+03, 5.3370E+03, 5.3589E+03, 5.3809E+03, 5.4030E+03, 5.4251E+03, 5.4473E+03, 5.4695E+03, &
       5.4918E+03, 5.5142E+03, 5.5366E+03, 5.5591E+03, 5.5817E+03, 5.6043E+03, 5.6269E+03, 5.6497E+03, 5.6725E+03, 5.6953E+03, &
       5.7182E+03, 5.7412E+03, 5.7643E+03, 5.7874E+03, 5.8105E+03, 5.8338E+03, 5.8571E+03, 5.8804E+03, 5.9038E+03, 5.9273E+03, &
       5.9509E+03, 5.9745E+03, 5.9981E+03, 6.0219E+03, 6.0457E+03, 6.0695E+03, 6.0935E+03, 6.1175E+03, 6.1415E+03, 6.1656E+03, &
       6.1898E+03, 6.2141E+03, 6.2384E+03, 6.2628E+03, 6.2872E+03, 6.3118E+03, 6.3363E+03, 6.3610E+03, 6.3857E+03, 6.4105E+03, &
       6.4353E+03, 6.4602E+03, 6.4852E+03, 6.5103E+03, 6.5354E+03, 6.5606E+03, 6.5858E+03, 6.6111E+03, 6.6365E+03, 6.6620E+03, &
       6.6875E+03, 6.7131E+03, 6.7387E+03, 6.7644E+03, 6.7902E+03, 6.8161E+03, 6.8420E+03, 6.8680E+03, 6.8941E+03, 6.9202E+03, &
       6.9464E+03, 6.9727E+03, 6.9991E+03, 7.0255E+03, 7.0520E+03, 7.0785E+03, 7.1051E+03, 7.1318E+03, 7.1586E+03, 7.1854E+03, &
       7.2123E+03, 7.2393E+03, 7.2664E+03, 7.2935E+03, 7.3207E+03, 7.3480E+03, 7.3753E+03, 7.4027E+03, 7.4302E+03, 7.4578E+03, &
       7.4854E+03, 7.5131E+03, 7.5409E+03, 7.5687E+03, 7.5966E+03, 7.6246E+03, 7.6527E+03, 7.6808E+03, 7.7090E+03, 7.7373E+03, &
       7.7657E+03, 7.7941E+03, 7.8226E+03, 7.8512E+03, 7.8799E+03, 7.9086E+03, 7.9374E+03, 7.9663E+03, 7.9953E+03, 8.0243E+03, &
       8.0534E+03, 8.0826E+03, 8.1119E+03, 8.1412E+03, 8.1706E+03, 8.2001E+03, 8.2297E+03, 8.2593E+03, 8.2891E+03, 8.3189E+03, &
       8.3487E+03, 8.3787E+03, 8.4087E+03, 8.4388E+03, 8.4690E+03, 8.4993E+03, 8.5296E+03, 8.5601E+03, 8.5906E+03, 8.6212E+03, &
       8.6518E+03, 8.6826E+03, 8.7134E+03, 8.7443E+03, 8.7753E+03, 8.8063E+03, 8.8374E+03, 8.8687E+03, 8.9000E+03, 8.9313E+03, &
       8.9628E+03, 8.9943E+03, 9.0260E+03, 9.0577E+03, 9.0895E+03, 9.1213E+03, 9.1533E+03, 9.1853E+03, 9.2174E+03, 9.2496E+03, &
       9.2819E+03, 9.3142E+03, 9.3467E+03, 9.3792E+03, 9.4118E+03, 9.4445E+03, 9.4773E+03, 9.5101E+03, 9.5430E+03, 9.5761E+03, &
       9.6092E+03, 9.6424E+03, 9.6756E+03, 9.7090E+03, 9.7424E+03, 9.7760E+03, 9.8096E+03, 9.8433E+03, 9.8771E+03, 9.9109E+03, &
       9.9449E+03, 9.9789E+03, 1.0013E+04, 1.0047E+04, 1.0082E+04, 1.0116E+04, 1.0150E+04, 1.0185E+04, 1.0220E+04, 1.0254E+04, &
       1.0289E+04, 1.0324E+04, 1.0359E+04, 1.0394E+04, 1.0429E+04, 1.0465E+04, 1.0500E+04, 1.0535E+04, 1.0571E+04, 1.0607E+04, &
       1.0642E+04, 1.0678E+04, 1.0714E+04, 1.0750E+04, 1.0786E+04, 1.0822E+04, 1.0858E+04, 1.0895E+04, 1.0931E+04, 1.0968E+04, &
       1.1004E+04, 1.1041E+04, 1.1078E+04, 1.1115E+04, 1.1152E+04, 1.1189E+04, 1.1226E+04, 1.1263E+04, 1.1300E+04, 1.1338E+04, &
       1.1375E+04, 1.1413E+04, 1.1451E+04, 1.1488E+04, 1.1526E+04, 1.1564E+04, 1.1602E+04, 1.1641E+04, 1.1679E+04, 1.1717E+04, &
       1.1756E+04, 1.1794E+04, 1.1833E+04, 1.1872E+04, 1.1910E+04, 1.1949E+04, 1.1988E+04, 1.2028E+04, 1.2067E+04, 1.2106E+04, &
       1.2146E+04, 1.2185E+04, 1.2225E+04, 1.2264E+04, 1.2304E+04, 1.2344E+04, 1.2384E+04, 1.2424E+04, 1.2464E+04, 1.2505E+04, &
       1.2545E+04, 1.2585E+04, 1.2626E+04, 1.2667E+04, 1.2708E+04, 1.2748E+04, 1.2789E+04, 1.2830E+04, 1.2872E+04, 1.2913E+04, &
       1.2954E+04, 1.2996E+04, 1.3037E+04, 1.3079E+04, 1.3121E+04, 1.3163E+04, 1.3205E+04, 1.3247E+04, 1.3289E+04, 1.3331E+04, &
       1.3374E+04, 1.3416E+04, 1.3459E+04, 1.3501E+04, 1.3544E+04, 1.3587E+04, 1.3630E+04, 1.3673E+04, 1.3716E+04, 1.3760E+04, &
       1.3803E+04, 1.3846E+04, 1.3890E+04, 1.3934E+04, 1.3978E+04, 1.4022E+04, 1.4066E+04, 1.4110E+04, 1.4154E+04, 1.4198E+04, &
       1.4243E+04, 1.4287E+04, 1.4332E+04, 1.4377E+04, 1.4422E+04, 1.4467E+04, 1.4512E+04, 1.4557E+04, 1.4602E+04, 1.4648E+04, &
       1.4693E+04, 1.4739E+04, 1.4784E+04, 1.4830E+04, 1.4876E+04, 1.4922E+04, 1.4968E+04, 1.5015E+04, 1.5061E+04, 1.5108E+04, &
       1.5154E+04, 1.5201E+04, 1.5248E+04, 1.5295E+04, 1.5342E+04, 1.5389E+04, 1.5436E+04, 1.5483E+04, 1.5531E+04, 1.5579E+04, &
       1.5626E+04, 1.5674E+04, 1.5722E+04, 1.5770E+04, 1.5818E+04, 1.5866E+04, 1.5915E+04, 1.5963E+04, 1.6012E+04, 1.6061E+04, &
       1.6109E+04, 1.6158E+04, 1.6207E+04, 1.6257E+04, 1.6306E+04, 1.6355E+04, 1.6405E+04, 1.6454E+04, 1.6504E+04, 1.6554E+04, &
       1.6604E+04, 1.6654E+04, 1.6704E+04, 1.6754E+04, 1.6805E+04, 1.6855E+04, 1.6906E+04, 1.6957E+04, 1.7008E+04, 1.7059E+04, &
       1.7110E+04, 1.7161E+04, 1.7212E+04, 1.7264E+04, 1.7315E+04, 1.7367E+04, 1.7419E+04, 1.7471E+04, 1.7523E+04, 1.7575E+04, &
       1.7627E+04, 1.7680E+04, 1.7732E+04, 1.7785E+04, 1.7838E+04, 1.7891E+04, 1.7944E+04, 1.7997E+04, 1.8050E+04, 1.8104E+04, &
       1.8157E+04, 1.8211E+04, 1.8264E+04, 1.8318E+04, 1.8372E+04, 1.8426E+04, 1.8481E+04, 1.8535E+04, 1.8589E+04, 1.8644E+04, &
       1.8699E+04, 1.8753E+04, 1.8808E+04, 1.8864E+04, 1.8919E+04, 1.8974E+04, 1.9030E+04, 1.9085E+04, 1.9141E+04, 1.9197E+04, &
       1.9253E+04, 1.9309E+04, 1.9365E+04, 1.9421E+04, 1.9478E+04, 1.9534E+04, 1.9591E+04, 1.9648E+04, 1.9705E+04, 1.9762E+04, &
       1.9819E+04, 1.9876E+04, 1.9934E+04, 1.9991E+04, 2.0049E+04, 2.0107E+04, 2.0165E+04, 2.0223E+04, 2.0281E+04, 2.0340E+04, &
       2.0398E+04, 2.0457E+04, 2.0515E+04, 2.0574E+04, 2.0633E+04, 2.0692E+04, 2.0752E+04, 2.0811E+04, 2.0871E+04, 2.0930E+04, &
       2.0990E+04, 2.1050E+04, 2.1110E+04, 2.1170E+04, 2.1231E+04, 2.1291E+04, 2.1352E+04, 2.1412E+04, 2.1473E+04, 2.1534E+04, &
       2.1595E+04, 2.1656E+04, 2.1718E+04, 2.1779E+04, 2.1841E+04, 2.1903E+04, 2.1965E+04, 2.2027E+04, 2.2089E+04, 2.2151E+04, &
       2.2214E+04, 2.2276E+04, 2.2339E+04, 2.2402E+04, 2.2465E+04, 2.2528E+04, 2.2591E+04, 2.2654E+04, 2.2718E+04, 2.2782E+04, &
       2.2845E+04, 2.2909E+04, 2.2974E+04, 2.3038E+04, 2.3102E+04, 2.3167E+04, 2.3231E+04, 2.3296E+04, 2.3361E+04, 2.3426E+04, &
       2.3491E+04, 2.3556E+04, 2.3622E+04, 2.3688E+04, 2.3753E+04, 2.3819E+04, 2.3885E+04, 2.3951E+04, 2.4018E+04, 2.4084E+04, &
       2.4151E+04, 2.4217E+04, 2.4284E+04, 2.4351E+04, 2.4418E+04, 2.4486E+04, 2.4553E+04, 2.4621E+04, 2.4688E+04, 2.4756E+04, &
       2.4824E+04, 2.4892E+04, 2.4961E+04, 2.5029E+04, 2.5098E+04, 2.5167E+04, 2.5235E+04, 2.5304E+04, 2.5374E+04, 2.5443E+04, &
       2.5512E+04, 2.5582E+04, 2.5652E+04, 2.5722E+04, 2.5792E+04, 2.5862E+04, 2.5932E+04, 2.6003E+04, 2.6073E+04, 2.6144E+04, &
       2.6215E+04, 2.6286E+04, 2.6357E+04, 2.6429E+04, 2.6500E+04, 2.6572E+04, 2.6644E+04, 2.6716E+04, 2.6788E+04, 2.6860E+04, &
       2.6932E+04, 2.7005E+04, 2.7078E+04, 2.7150E+04, 2.7223E+04, 2.7297E+04, 2.7370E+04, 2.7443E+04, 2.7517E+04, 2.7591E+04, &
       2.7665E+04, 2.7739E+04, 2.7813E+04, 2.7887E+04, 2.7962E+04, 2.8036E+04, 2.8111E+04, 2.8186E+04, 2.8261E+04, 2.8337E+04, &
       2.8412E+04, 2.8488E+04, 2.8564E+04, 2.8639E+04, 2.8715E+04, 2.8792E+04, 2.8868E+04, 2.8945E+04, 2.9021E+04, 2.9098E+04, &
       2.9175E+04, 2.9252E+04, 2.9330E+04, 2.9407E+04, 2.9485E+04, 2.9562E+04, 2.9640E+04, 2.9718E+04, 2.9797E+04, 2.9875E+04, &
       2.9954E+04, 3.0032E+04, 3.0111E+04, 3.0190E+04, 3.0270E+04, 3.0349E+04, 3.0428E+04, 3.0508E+04, 3.0588E+04, 3.0668E+04, &
       3.0748E+04, 3.0829E+04, 3.0909E+04, 3.0990E+04, 3.1070E+04, 3.1151E+04, 3.1233E+04, 3.1314E+04, 3.1395E+04, 3.1477E+04, &
       3.1559E+04, 3.1641E+04, 3.1723E+04, 3.1805E+04, 3.1887E+04, 3.1970E+04, 3.2053E+04, 3.2136E+04, 3.2219E+04, 3.2302E+04, &
       3.2386E+04, 3.2469E+04, 3.2553E+04, 3.2637E+04, 3.2721E+04, 3.2805E+04, 3.2890E+04, 3.2974E+04, 3.3059E+04, 3.3144E+04, &
       3.3229E+04, 3.3314E+04, 3.3400E+04, 3.3485E+04, 3.3571E+04, 3.3657E+04, 3.3743E+04, 3.3829E+04, 3.3916E+04, 3.4002E+04, &
       3.4089E+04, 3.4176E+04, 3.4263E+04, 3.4350E+04, 3.4438E+04, 3.4525E+04, 3.4613E+04, 3.4701E+04, 3.4789E+04, 3.4878E+04, &
       3.4966E+04, 3.5055E+04, 3.5144E+04, 3.5233E+04, 3.5322E+04, 3.5411E+04, 3.5501E+04, 3.5590E+04, 3.5680E+04, 3.5770E+04, &
       3.5860E+04, 3.5951E+04, 3.6041E+04, 3.6132E+04, 3.6223E+04, 3.6314E+04, 3.6405E+04, 3.6497E+04, 3.6588E+04, 3.6680E+04, &
       3.6772E+04, 3.6864E+04, 3.6957E+04, 3.7049E+04, 3.7142E+04, 3.7235E+04, 3.7328E+04, 3.7421E+04, 3.7514E+04, 3.7608E+04, &
       3.7701E+04, 3.7795E+04, 3.7890E+04, 3.7984E+04, 3.8078E+04, 3.8173E+04, 3.8268E+04, 3.8363E+04, 3.8458E+04, 3.8553E+04, &
       3.8649E+04, 3.8744E+04, 3.8840E+04, 3.8936E+04, 3.9033E+04, 3.9129E+04, 3.9226E+04, 3.9323E+04, 3.9420E+04, 3.9517E+04, &
       3.9614E+04, 3.9712E+04, 3.9809E+04, 3.9907E+04, 4.0005E+04, 4.0104E+04, 4.0202E+04, 4.0301E+04, 4.0400E+04, 4.0499E+04, &
       4.0598E+04, 4.0697E+04, 4.0797E+04, 4.0897E+04, 4.0997E+04, 4.1097E+04, 4.1197E+04, 4.1298E+04, 4.1398E+04, 4.1499E+04, &
       4.1600E+04, 4.1701E+04, 4.1803E+04, 4.1905E+04, 4.2006E+04, 4.2108E+04, 4.2211E+04, 4.2313E+04, 4.2416E+04, 4.2518E+04, &
       4.2621E+04, 4.2724E+04, 4.2828E+04, 4.2931E+04, 4.3035E+04, 4.3139E+04, 4.3243E+04, 4.3347E+04, 4.3452E+04, 4.3557E+04, &
       4.3662E+04, 4.3767E+04, 4.3872E+04, 4.3977E+04, 4.4083E+04, 4.4189E+04, 4.4295E+04, 4.4401E+04, 4.4508E+04, 4.4614E+04, &
       4.4721E+04, 4.4828E+04, 4.4935E+04, 4.5043E+04, 4.5150E+04, 4.5258E+04, 4.5366E+04, 4.5474E+04, 4.5583E+04, 4.5691E+04, &
       4.5800E+04, 4.5909E+04, 4.6018E+04, 4.6128E+04, 4.6237E+04, 4.6347E+04, 4.6457E+04, 4.6567E+04, 4.6677E+04, 4.6788E+04, &
       4.6899E+04, 4.7010E+04, 4.7121E+04, 4.7232E+04, 4.7344E+04, 4.7456E+04, 4.7568E+04, 4.7680E+04, 4.7792E+04, 4.7905E+04, &
       4.8018E+04, 4.8131E+04, 4.8244E+04, 4.8357E+04, 4.8471E+04, 4.8585E+04, 4.8699E+04, 4.8813E+04, 4.8927E+04, 4.9042E+04, &
       4.9157E+04, 4.9272E+04, 4.9387E+04, 4.9502E+04, 4.9618E+04, 4.9734E+04, 4.9850E+04, 4.9966E+04, 5.0083E+04, 5.0199E+04, &
       5.0316E+04, 5.0433E+04, 5.0551E+04, 5.0668E+04, 5.0786E+04, 5.0904E+04, 5.1022E+04, 5.1140E+04, 5.1259E+04, 5.1378E+04, &
       5.1497E+04, 5.1616E+04, 5.1735E+04, 5.1855E+04, 5.1974E+04, 5.2095E+04, 5.2215E+04, 5.2335E+04, 5.2456E+04, 5.2577E+04, &
       5.2698E+04, 5.2819E+04, 5.2941E+04, 5.3062E+04, 5.3184E+04, 5.3306E+04, 5.3429E+04, 5.3551E+04, 5.3674E+04, 5.3797E+04, &
       5.3920E+04, 5.4044E+04, 5.4167E+04, 5.4291E+04, 5.4415E+04, 5.4540E+04, 5.4664E+04, 5.4789E+04, 5.4914E+04, 5.5039E+04, &
       5.5164E+04, 5.5290E+04, 5.5416E+04, 5.5542E+04, 5.5668E+04, 5.5794E+04, 5.5921E+04, 5.6048E+04, 5.6175E+04, 5.6302E+04, &
       5.6430E+04, 5.6558E+04, 5.6686E+04, 5.6814E+04, 5.6942E+04, 5.7071E+04, 5.7200E+04, 5.7329E+04, 5.7458E+04, 5.7588E+04, &
       5.7718E+04, 5.7848E+04, 5.7978E+04, 5.8108E+04, 5.8239E+04, 5.8370E+04, 5.8501E+04, 5.8632E+04, 5.8764E+04, 5.8895E+04, &
       5.9027E+04, 5.9160E+04, 5.9292E+04, 5.9425E+04, 5.9558E+04, 5.9691E+04, 5.9824E+04, 5.9958E+04, 6.0092E+04, 6.0226E+04, &
       6.0360E+04, 6.0494E+04, 6.0629E+04, 6.0764E+04, 6.0899E+04, 6.1035E+04, 6.1170E+04, 6.1306E+04, 6.1442E+04, 6.1578E+04, &
       6.1715E+04, 6.1852E+04, 6.1989E+04, 6.2126E+04, 6.2263E+04, 6.2401E+04, 6.2539E+04, 6.2677E+04, 6.2815E+04, 6.2954E+04, &
       6.3093E+04, 6.3232E+04, 6.3371E+04, 6.3511E+04, 6.3651E+04, 6.3791E+04, 6.3931E+04, 6.4071E+04, 6.4212E+04, 6.4353E+04, &
       6.4494E+04, 6.4636E+04, 6.4777E+04, 6.4919E+04, 6.5061E+04, 6.5204E+04, 6.5346E+04, 6.5489E+04, 6.5632E+04, 6.5775E+04, &
       6.5919E+04, 6.6063E+04, 6.6207E+04, 6.6351E+04, 6.6496E+04, 6.6640E+04, 6.6785E+04, 6.6930E+04, 6.7076E+04, 6.7222E+04, &
       6.7367E+04, 6.7514E+04, 6.7660E+04, 6.7807E+04, 6.7954E+04, 6.8101E+04, 6.8248E+04, 6.8396E+04, 6.8544E+04, 6.8692E+04, &
       6.8840E+04, 6.8989E+04, 6.9137E+04, 6.9286E+04, 6.9436E+04, 6.9585E+04, 6.9735E+04, 6.9885E+04, 7.0035E+04, 7.0186E+04, &
       7.0337E+04, 7.0488E+04, 7.0639E+04, 7.0790E+04, 7.0942E+04, 7.1094E+04, 7.1246E+04, 7.1399E+04, 7.1552E+04, 7.1705E+04, &
       7.1858E+04, 7.2011E+04, 7.2165E+04, 7.2319E+04, 7.2473E+04, 7.2628E+04, 7.2783E+04, 7.2938E+04, 7.3093E+04, 7.3248E+04, &
       7.3404E+04, 7.3560E+04, 7.3716E+04, 7.3873E+04, 7.4029E+04, 7.4186E+04, 7.4344E+04, 7.4501E+04, 7.4659E+04, 7.4817E+04, &
       7.4975E+04, 7.5134E+04, 7.5292E+04, 7.5451E+04, 7.5610E+04, 7.5770E+04, 7.5930E+04, 7.6090E+04, 7.6250E+04, 7.6411E+04, &
       7.6571E+04, 7.6732E+04, 7.6894E+04, 7.7055E+04, 7.7217E+04, 7.7379E+04, 7.7541E+04, 7.7704E+04, 7.7867E+04, 7.8030E+04, &
       7.8193E+04, 7.8357E+04, 7.8521E+04, 7.8685E+04, 7.8849E+04, 7.9014E+04, 7.9179E+04, 7.9344E+04, 7.9509E+04, 7.9675E+04, &
       7.9841E+04, 8.0007E+04, 8.0174E+04, 8.0340E+04, 8.0507E+04, 8.0675E+04, 8.0842E+04, 8.1010E+04, 8.1178E+04, 8.1346E+04, &
       8.1515E+04, 8.1684E+04, 8.1853E+04, 8.2022E+04, 8.2192E+04, 8.2362E+04, 8.2532E+04, 8.2702E+04, 8.2873E+04, 8.3044E+04, &
       8.3215E+04, 8.3386E+04, 8.3558E+04, 8.3730E+04, 8.3902E+04, 8.4075E+04, 8.4248E+04, 8.4421E+04, 8.4594E+04, 8.4768E+04, &
       8.4942E+04, 8.5116E+04, 8.5290E+04, 8.5465E+04, 8.5640E+04, 8.5815E+04, 8.5991E+04, 8.6166E+04, 8.6342E+04, 8.6519E+04, &
       8.6695E+04, 8.6872E+04, 8.7049E+04, 8.7227E+04, 8.7404E+04, 8.7582E+04, 8.7760E+04, 8.7939E+04, 8.8118E+04, 8.8297E+04, &
       8.8476E+04, 8.8656E+04, 8.8835E+04, 8.9016E+04, 8.9196E+04, 8.9377E+04, 8.9558E+04, 8.9739E+04, 8.9920E+04, 9.0102E+04, &
       9.0284E+04, 9.0467E+04, 9.0649E+04, 9.0832E+04, 9.1015E+04, 9.1199E+04, 9.1382E+04, 9.1566E+04, 9.1751E+04, 9.1935E+04, &
       9.2120E+04, 9.2305E+04, 9.2491E+04, 9.2676E+04, 9.2862E+04, 9.3049E+04, 9.3235E+04, 9.3422E+04, 9.3609E+04, 9.3796E+04, &
       9.3984E+04, 9.4172E+04, 9.4360E+04, 9.4549E+04, 9.4737E+04, 9.4926E+04, 9.5116E+04, 9.5305E+04, 9.5495E+04, 9.5686E+04, &
       9.5876E+04, 9.6067E+04, 9.6258E+04, 9.6449E+04, 9.6641E+04, 9.6833E+04, 9.7025E+04, 9.7217E+04, 9.7410E+04, 9.7603E+04, &
       9.7797E+04, 9.7990E+04, 9.8184E+04, 9.8378E+04, 9.8573E+04, 9.8768E+04, 9.8963E+04, 9.9158E+04, 9.9354E+04, 9.9550E+04, &
       9.9746E+04, 9.9942E+04, 1.0014E+05, 1.0034E+05, 1.0053E+05, 1.0073E+05, 1.0093E+05, 1.0113E+05, 1.0133E+05, 1.0153E+05, &
       1.0172E+05, 1.0192E+05, 1.0212E+05, 1.0232E+05, 1.0252E+05, 1.0272E+05, 1.0293E+05, 1.0313E+05, 1.0333E+05, 1.0353E+05, &
       1.0373E+05, 1.0393E+05, 1.0414E+05, 1.0434E+05, 1.0454E+05, 1.0475E+05, 1.0495E+05, 1.0515E+05, 1.0536E+05, 1.0556E+05, &
       1.0577E+05, 1.0597E+05, 1.0618E+05, 1.0639E+05, 1.0659E+05, 1.0680E+05, 1.0701E+05, 1.0721E+05, 1.0742E+05, 1.0763E+05, &
       1.0784E+05, 1.0804E+05, 1.0825E+05, 1.0846E+05, 1.0867E+05, 1.0888E+05, 1.0909E+05, 1.0930E+05, 1.0951E+05, 1.0972E+05, &
       1.0993E+05, 1.1014E+05, 1.1036E+05, 1.1057E+05, 1.1078E+05, 1.1099E+05, 1.1121E+05, 1.1142E+05, 1.1163E+05, 1.1185E+05, &
       1.1206E+05, 1.1228E+05, 1.1249E+05, 1.1271E+05, 1.1292E+05, 1.1314E+05, 1.1335E+05, 1.1357E+05, 1.1379E+05, 1.1400E+05, &
       1.1422E+05, 1.1444E+05, 1.1465E+05, 1.1487E+05, 1.1509E+05, 1.1531E+05, 1.1553E+05, 1.1575E+05, 1.1597E+05, 1.1619E+05, &
       1.1641E+05, 1.1663E+05, 1.1685E+05, 1.1707E+05, 1.1729E+05, 1.1752E+05, 1.1774E+05, 1.1796E+05, 1.1818E+05, 1.1841E+05, &
       1.1863E+05, 1.1885E+05, 1.1908E+05, 1.1930E+05, 1.1953E+05, 1.1975E+05, 1.1998E+05, 1.2020E+05, 1.2043E+05, 1.2065E+05, &
       1.2088E+05, 1.2111E+05, 1.2134E+05, 1.2156E+05, 1.2179E+05, 1.2202E+05, 1.2225E+05, 1.2248E+05, 1.2271E+05, 1.2294E+05, &
       1.2317E+05, 1.2340E+05, 1.2363E+05, 1.2386E+05, 1.2409E+05, 1.2432E+05, 1.2455E+05, 1.2478E+05, 1.2502E+05, 1.2525E+05, &
       1.2548E+05, 1.2571E+05, 1.2595E+05, 1.2618E+05, 1.2642E+05, 1.2665E+05, 1.2689E+05, 1.2712E+05, 1.2736E+05, 1.2759E+05, &
       1.2783E+05, 1.2807E+05, 1.2830E+05, 1.2854E+05, 1.2878E+05, 1.2902E+05, 1.2925E+05, 1.2949E+05, 1.2973E+05, 1.2997E+05, &
       1.3021E+05, 1.3045E+05, 1.3069E+05, 1.3093E+05, 1.3117E+05, 1.3141E+05, 1.3166E+05, 1.3190E+05, 1.3214E+05, 1.3238E+05, &
       1.3262E+05, 1.3287E+05, 1.3311E+05, 1.3336E+05, 1.3360E+05, 1.3384E+05, 1.3409E+05, 1.3433E+05, 1.3458E+05, 1.3483E+05, &
       1.3507E+05, 1.3532E+05, 1.3557E+05, 1.3581E+05, 1.3606E+05, 1.3631E+05, 1.3656E+05, 1.3681E+05, 1.3705E+05, 1.3730E+05, &
       1.3755E+05, 1.3780E+05, 1.3805E+05, 1.3830E+05, 1.3855E+05, 1.3881E+05, 1.3906E+05, 1.3931E+05, 1.3956E+05, 1.3981E+05, &
       1.4007E+05, 1.4032E+05, 1.4057E+05, 1.4083E+05, 1.4108E+05, 1.4134E+05, 1.4159E+05, 1.4185E+05, 1.4210E+05, 1.4236E+05, &
       1.4262E+05, 1.4287E+05, 1.4313E+05, 1.4339E+05, 1.4364E+05, 1.4390E+05, 1.4416E+05, 1.4442E+05, 1.4468E+05, 1.4494E+05, &
       1.4520E+05, 1.4546E+05, 1.4572E+05, 1.4598E+05, 1.4624E+05, 1.4650E+05, 1.4677E+05, 1.4703E+05, 1.4729E+05, 1.4755E+05, &
       1.4782E+05, 1.4808E+05, 1.4834E+05, 1.4861E+05, 1.4887E+05, 1.4914E+05, 1.4940E+05, 1.4967E+05, 1.4994E+05, 1.5020E+05, &
       1.5047E+05, 1.5074E+05, 1.5100E+05, 1.5127E+05, 1.5154E+05, 1.5181E+05, 1.5208E+05, 1.5235E+05, 1.5262E+05, 1.5289E+05, &
       1.5316E+05, 1.5343E+05, 1.5370E+05, 1.5397E+05, 1.5424E+05, 1.5451E+05, 1.5479E+05, 1.5506E+05, 1.5533E+05, 1.5561E+05, &
       1.5588E+05, 1.5615E+05, 1.5643E+05, 1.5670E+05, 1.5698E+05, 1.5725E+05, 1.5753E+05, 1.5781E+05, 1.5808E+05, 1.5836E+05, &
       1.5864E+05, 1.5892E+05, 1.5919E+05, 1.5947E+05, 1.5975E+05, 1.6003E+05, 1.6031E+05, 1.6059E+05, 1.6087E+05, 1.6115E+05, &
       1.6143E+05, 1.6171E+05, 1.6200E+05, 1.6228E+05, 1.6256E+05, 1.6284E+05, 1.6313E+05, 1.6341E+05, 1.6370E+05, 1.6398E+05, &
       1.6426E+05, 1.6455E+05, 1.6484E+05, 1.6512E+05, 1.6541E+05, 1.6569E+05, 1.6598E+05, 1.6627E+05, 1.6656E+05, 1.6684E+05, &
       1.6713E+05, 1.6742E+05, 1.6771E+05, 1.6800E+05, 1.6829E+05, 1.6858E+05, 1.6887E+05, 1.6916E+05, 1.6945E+05, 1.6975E+05, &
       1.7004E+05, 1.7033E+05, 1.7062E+05, 1.7092E+05, 1.7121E+05, 1.7150E+05, 1.7180E+05, 1.7209E+05, 1.7239E+05, 1.7268E+05, &
       1.7298E+05, 1.7328E+05, 1.7357E+05, 1.7387E+05, 1.7417E+05, 1.7446E+05, 1.7476E+05, 1.7506E+05, 1.7536E+05, 1.7566E+05, &
       1.7596E+05, 1.7626E+05, 1.7656E+05, 1.7686E+05, 1.7716E+05, 1.7746E+05, 1.7776E+05, 1.7807E+05, 1.7837E+05, 1.7867E+05, &
       1.7898E+05, 1.7928E+05, 1.7958E+05, 1.7989E+05, 1.8019E+05, 1.8050E+05, 1.8080E+05, 1.8111E+05, 1.8142E+05, 1.8172E+05, &
       1.8203E+05, 1.8234E+05, 1.8265E+05, 1.8296E+05, 1.8326E+05, 1.8357E+05, 1.8388E+05, 1.8419E+05, 1.8450E+05, 1.8481E+05, &
       1.8513E+05, 1.8544E+05, 1.8575E+05, 1.8606E+05, 1.8637E+05, 1.8669E+05, 1.8700E+05, 1.8731E+05, 1.8763E+05, 1.8794E+05, &
       1.8826E+05, 1.8857E+05, 1.8889E+05, 1.8920E+05, 1.8952E+05, 1.8984E+05, 1.9016E+05, 1.9047E+05, 1.9079E+05, 1.9111E+05, &
       1.9143E+05, 1.9175E+05, 1.9207E+05, 1.9239E+05, 1.9271E+05, 1.9303E+05, 1.9335E+05, 1.9367E+05, 1.9399E+05, 1.9432E+05, &
       1.9464E+05, 1.9496E+05, 1.9529E+05, 1.9561E+05, 1.9593E+05, 1.9626E+05, 1.9658E+05, 1.9691E+05, 1.9724E+05, 1.9756E+05, &
       1.9789E+05, 1.9822E+05, 1.9854E+05, 1.9887E+05, 1.9920E+05, 1.9953E+05, 1.9986E+05, 2.0019E+05, 2.0052E+05, 2.0085E+05, &
       2.0118E+05, 2.0151E+05, 2.0184E+05, 2.0217E+05, 2.0251E+05, 2.0284E+05, 2.0317E+05, 2.0351E+05, 2.0384E+05, 2.0417E+05, &
       2.0451E+05, 2.0484E+05, 2.0518E+05, 2.0552E+05, 2.0585E+05, 2.0619E+05, 2.0653E+05, 2.0686E+05, 2.0720E+05, 2.0754E+05, &
       2.0788E+05, 2.0822E+05, 2.0856E+05, 2.0890E+05, 2.0924E+05, 2.0958E+05, 2.0992E+05, 2.1026E+05, 2.1060E+05, 2.1095E+05, &
       2.1129E+05, 2.1163E+05, 2.1198E+05, 2.1232E+05, 2.1267E+05, 2.1301E+05, 2.1336E+05, 2.1370E+05, 2.1405E+05, 2.1439E+05, &
       2.1474E+05, 2.1509E+05, 2.1544E+05, 2.1579E+05, 2.1613E+05, 2.1648E+05, 2.1683E+05, 2.1718E+05, 2.1753E+05, 2.1788E+05, &
       2.1823E+05, 2.1859E+05, 2.1894E+05, 2.1929E+05, 2.1964E+05, 2.2000E+05, 2.2035E+05, 2.2070E+05, 2.2106E+05, 2.2141E+05, &
       2.2177E+05, 2.2212E+05, 2.2248E+05, 2.2284E+05, 2.2319E+05, 2.2355E+05, 2.2391E+05, 2.2427E+05, 2.2463E+05, 2.2499E+05, &
       2.2535E+05, 2.2571E+05, 2.2607E+05, 2.2643E+05, 2.2679E+05, 2.2715E+05, 2.2751E+05, 2.2787E+05, 2.2824E+05, 2.2860E+05, &
       2.2896E+05, 2.2933E+05, 2.2969E+05, 2.3006E+05, 2.3042E+05, 2.3079E+05, 2.3115E+05, 2.3152E+05, 2.3189E+05, 2.3226E+05, &
       2.3262E+05, 2.3299E+05, 2.3336E+05, 2.3373E+05, 2.3410E+05, 2.3447E+05, 2.3484E+05, 2.3521E+05, 2.3558E+05, 2.3596E+05, &
       2.3633E+05, 2.3670E+05, 2.3707E+05, 2.3745E+05, 2.3782E+05, 2.3820E+05, 2.3857E+05, 2.3895E+05, 2.3932E+05, 2.3970E+05, &
       2.4007E+05, 2.4045E+05, 2.4083E+05, 2.4121E+05, 2.4158E+05, 2.4196E+05, 2.4234E+05, 2.4272E+05, 2.4310E+05, 2.4348E+05, &
       2.4386E+05, 2.4424E+05, 2.4463E+05, 2.4501E+05, 2.4539E+05, 2.4577E+05, 2.4616E+05, 2.4654E+05, 2.4693E+05, 2.4731E+05, &
       2.4770E+05, 2.4808E+05, 2.4847E+05, 2.4885E+05, 2.4924E+05, 2.4963E+05, 2.5002E+05, 2.5040E+05, 2.5079E+05, 2.5118E+05, &
       2.5157E+05, 2.5196E+05, 2.5235E+05, 2.5274E+05, 2.5314E+05, 2.5353E+05, 2.5392E+05, 2.5431E+05, 2.5471E+05, 2.5510E+05, &
       2.5549E+05, 2.5589E+05, 2.5628E+05, 2.5668E+05, 2.5707E+05, 2.5747E+05, 2.5787E+05, 2.5826E+05, 2.5866E+05, 2.5906E+05, &
       2.5946E+05, 2.5986E+05, 2.6026E+05, 2.6066E+05, 2.6106E+05, 2.6146E+05, 2.6186E+05, 2.6226E+05, 2.6266E+05, 2.6306E+05, &
       2.6347E+05, 2.6387E+05, 2.6428E+05, 2.6468E+05, 2.6508E+05, 2.6549E+05, 2.6590E+05, 2.6630E+05, 2.6671E+05, 2.6711E+05, &
       2.6752E+05, 2.6793E+05, 2.6834E+05, 2.6875E+05, 2.6916E+05, 2.6957E+05, 2.6998E+05, 2.7039E+05, 2.7080E+05, 2.7121E+05, &
       2.7162E+05, 2.7203E+05, 2.7245E+05, 2.7286E+05, 2.7327E+05, 2.7369E+05, 2.7410E+05, 2.7452E+05, 2.7493E+05, 2.7535E+05, &
       2.7577E+05, 2.7618E+05, 2.7660E+05, 2.7702E+05, 2.7744E+05, 2.7786E+05, 2.7828E+05, 2.7870E+05, 2.7912E+05, 2.7954E+05, &
       2.7996E+05, 2.8038E+05, 2.8080E+05, 2.8122E+05, 2.8165E+05, 2.8207E+05, 2.8249E+05, 2.8292E+05, 2.8334E+05, 2.8377E+05, &
       2.8419E+05, 2.8462E+05, 2.8505E+05, 2.8547E+05, 2.8590E+05, 2.8633E+05, 2.8676E+05, 2.8719E+05, 2.8762E+05, 2.8805E+05, &
       2.8848E+05, 2.8891E+05, 2.8934E+05, 2.8977E+05, 2.9020E+05, 2.9064E+05, 2.9107E+05, 2.9150E+05, 2.9194E+05, 2.9237E+05, &
       2.9281E+05, 2.9324E+05, 2.9368E+05, 2.9412E+05, 2.9455E+05, 2.9499E+05, 2.9543E+05, 2.9587E+05, 2.9630E+05, 2.9674E+05, &
       2.9718E+05, 2.9762E+05, 2.9806E+05, 2.9851E+05, 2.9895E+05, 2.9939E+05, 2.9983E+05, 3.0028E+05, 3.0072E+05, 3.0116E+05, &
       3.0161E+05, 3.0205E+05, 3.0250E+05, 3.0294E+05, 3.0339E+05, 3.0384E+05, 3.0428E+05, 3.0473E+05, 3.0518E+05, 3.0563E+05, &
       3.0608E+05, 3.0653E+05, 3.0698E+05, 3.0743E+05, 3.0788E+05, 3.0833E+05, 3.0878E+05, 3.0924E+05, 3.0969E+05, 3.1014E+05, &
       3.1060E+05, 3.1105E+05, 3.1151E+05, 3.1196E+05, 3.1242E+05, 3.1287E+05, 3.1333E+05, 3.1379E+05, 3.1425E+05, 3.1470E+05, &
       3.1516E+05, 3.1562E+05, 3.1608E+05, 3.1654E+05, 3.1700E+05, 3.1746E+05, 3.1793E+05, 3.1839E+05, 3.1885E+05, 3.1931E+05, &
       3.1978E+05, 3.2024E+05, 3.2071E+05, 3.2117E+05, 3.2164E+05, 3.2210E+05, 3.2257E+05, 3.2304E+05, 3.2350E+05, 3.2397E+05, &
       3.2444E+05, 3.2491E+05, 3.2538E+05, 3.2585E+05, 3.2632E+05, 3.2679E+05, 3.2726E+05, 3.2773E+05, 3.2821E+05, 3.2868E+05, &
       3.2915E+05, 3.2963E+05, 3.3010E+05, 3.3058E+05, 3.3105E+05, 3.3153E+05, 3.3200E+05, 3.3248E+05, 3.3296E+05, 3.3343E+05, &
       3.3391E+05, 3.3439E+05, 3.3487E+05, 3.3535E+05, 3.3583E+05, 3.3631E+05, 3.3679E+05, 3.3727E+05, 3.3776E+05, 3.3824E+05, &
       3.3872E+05, 3.3921E+05, 3.3969E+05, 3.4018E+05, 3.4066E+05, 3.4115E+05, 3.4163E+05, 3.4212E+05, 3.4261E+05, 3.4309E+05, &
       3.4358E+05, 3.4407E+05, 3.4456E+05, 3.4505E+05, 3.4554E+05, 3.4603E+05, 3.4652E+05, 3.4701E+05, 3.4751E+05, 3.4800E+05, &
       3.4849E+05, 3.4899E+05, 3.4948E+05, 3.4997E+05, 3.5047E+05, 3.5096E+05, 3.5146E+05, 3.5196E+05, 3.5245E+05, 3.5295E+05, &
       3.5345E+05, 3.5395E+05, 3.5445E+05, 3.5495E+05, 3.5545E+05, 3.5595E+05, 3.5645E+05, 3.5695E+05, 3.5745E+05, 3.5796E+05, &
       3.5846E+05, 3.5896E+05, 3.5947E+05, 3.5997E+05, 3.6048E+05, 3.6098E+05, 3.6149E+05, 3.6200E+05, 3.6250E+05, 3.6301E+05, &
       3.6352E+05, 3.6403E+05, 3.6454E+05, 3.6505E+05, 3.6556E+05, 3.6607E+05, 3.6658E+05, 3.6709E+05, 3.6760E+05, 3.6812E+05, &
       3.6863E+05, 3.6914E+05, 3.6966E+05, 3.7017E+05, 3.7069E+05, 3.7121E+05, 3.7172E+05, 3.7224E+05, 3.7276E+05, 3.7327E+05, &
       3.7379E+05, 3.7431E+05, 3.7483E+05, 3.7535E+05, 3.7587E+05, 3.7639E+05, 3.7691E+05, 3.7744E+05, 3.7796E+05, 3.7848E+05, &
       3.7901E+05, 3.7953E+05, 3.8005E+05, 3.8058E+05, 3.8111E+05, 3.8163E+05, 3.8216E+05, 3.8269E+05, 3.8321E+05, 3.8374E+05, &
       3.8427E+05, 3.8480E+05, 3.8533E+05, 3.8586E+05, 3.8639E+05, 3.8692E+05, 3.8745E+05, 3.8799E+05, 3.8852E+05, 3.8905E+05, &
       3.8959E+05, 3.9012E+05, 3.9066E+05, 3.9119E+05, 3.9173E+05, 3.9226E+05, 3.9280E+05, 3.9334E+05, 3.9388E+05, 3.9442E+05, &
       3.9496E+05, 3.9550E+05, 3.9604E+05, 3.9658E+05, 3.9712E+05, 3.9766E+05, 3.9820E+05, 3.9874E+05, 3.9929E+05, 3.9983E+05, &
       4.0038E+05, 4.0092E+05, 4.0147E+05, 4.0201E+05, 4.0256E+05, 4.0311E+05, 4.0365E+05, 4.0420E+05, 4.0475E+05, 4.0530E+05, &
       4.0585E+05, 4.0640E+05, 4.0695E+05, 4.0750E+05, 4.0805E+05, 4.0861E+05, 4.0916E+05, 4.0971E+05, 4.1027E+05, 4.1082E+05, &
       4.1138E+05, 4.1193E+05, 4.1249E+05, 4.1304E+05, 4.1360E+05, 4.1416E+05, 4.1472E+05, 4.1528E+05, 4.1583E+05, 4.1639E+05/
      data (QofT( 5,J),J=2409,4510)/ 4.1695E+05, 4.1752E+05, 4.1808E+05, 4.1864E+05, 4.1920E+05, 4.1976E+05, 4.2033E+05, 4.2089E+05, &
       4.2146E+05, 4.2202E+05, 4.2259E+05, 4.2315E+05, 4.2372E+05, 4.2429E+05, 4.2486E+05, 4.2542E+05, 4.2599E+05, 4.2656E+05, &
       4.2713E+05, 4.2770E+05, 4.2827E+05, 4.2884E+05, 4.2942E+05, 4.2999E+05, 4.3056E+05, 4.3114E+05, 4.3171E+05, 4.3229E+05, &
       4.3286E+05, 4.3344E+05, 4.3401E+05, 4.3459E+05, 4.3517E+05, 4.3575E+05, 4.3632E+05, 4.3690E+05, 4.3748E+05, 4.3806E+05, &
       4.3864E+05, 4.3922E+05, 4.3981E+05, 4.4039E+05, 4.4097E+05, 4.4156E+05, 4.4214E+05, 4.4272E+05, 4.4331E+05, 4.4389E+05, &
       4.4448E+05, 4.4507E+05, 4.4565E+05, 4.4624E+05, 4.4683E+05, 4.4742E+05, 4.4801E+05, 4.4860E+05, 4.4919E+05, 4.4978E+05, &
       4.5037E+05, 4.5096E+05, 4.5156E+05, 4.5215E+05, 4.5274E+05, 4.5334E+05, 4.5393E+05, 4.5453E+05, 4.5512E+05, 4.5572E+05, &
       4.5632E+05, 4.5692E+05, 4.5751E+05, 4.5811E+05, 4.5871E+05, 4.5931E+05, 4.5991E+05, 4.6051E+05, 4.6111E+05, 4.6172E+05, &
       4.6232E+05, 4.6292E+05, 4.6353E+05, 4.6413E+05, 4.6474E+05, 4.6534E+05, 4.6595E+05, 4.6655E+05, 4.6716E+05, 4.6777E+05, &
       4.6838E+05, 4.6898E+05, 4.6959E+05, 4.7020E+05, 4.7081E+05, 4.7142E+05, 4.7204E+05, 4.7265E+05, 4.7326E+05, 4.7387E+05, &
       4.7449E+05, 4.7510E+05, 4.7572E+05, 4.7633E+05, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       172
      data (QofT( 6,J),J=1,2408)/ 3.6000E+01, 3.6002E+01, 3.6065E+01, 3.6419E+01, 3.7294E+01, 3.8789E+01, 4.0902E+01, 4.3596E+01, &
       4.6822E+01, 5.0531E+01, 5.4680E+01, 5.9229E+01, 6.4145E+01, 6.9396E+01, 7.4956E+01, 8.0798E+01, 8.6904E+01, 9.3252E+01, &
       9.9829E+01, 1.0662E+02, 1.2079E+02, 1.3568E+02, 1.5124E+02, 1.6742E+02, 1.8419E+02, 2.0151E+02, 2.1936E+02, 2.3773E+02, &
       2.5660E+02, 2.7595E+02, 2.9577E+02, 3.1606E+02, 3.3679E+02, 3.5796E+02, 3.7957E+02, 4.0160E+02, 4.2404E+02, 4.4689E+02, &
       4.7014E+02, 4.9378E+02, 5.1781E+02, 5.4222E+02, 5.6701E+02, 5.9216E+02, 6.1768E+02, 6.4356E+02, 6.6980E+02, 6.9638E+02, &
       7.2331E+02, 7.5058E+02, 7.7819E+02, 8.0613E+02, 8.3440E+02, 8.6300E+02, 8.9192E+02, 9.2116E+02, 9.5071E+02, 9.8057E+02, &
       1.0107E+03, 1.0412E+03, 1.0720E+03, 1.1031E+03, 1.1345E+03, 1.1661E+03, 1.1981E+03, 1.2304E+03, 1.2629E+03, 1.2957E+03, &
       1.3288E+03, 1.3622E+03, 1.3959E+03, 1.4298E+03, 1.4640E+03, 1.4985E+03, 1.5333E+03, 1.5683E+03, 1.6036E+03, 1.6391E+03, &
       1.6749E+03, 1.7110E+03, 1.7474E+03, 1.7839E+03, 1.8208E+03, 1.8579E+03, 1.8952E+03, 1.9328E+03, 1.9707E+03, 2.0088E+03, &
       2.0471E+03, 2.0857E+03, 2.1245E+03, 2.1636E+03, 2.2029E+03, 2.2424E+03, 2.2822E+03, 2.3222E+03, 2.3625E+03, 2.4030E+03, &
       2.4437E+03, 2.4846E+03, 2.5258E+03, 2.5672E+03, 2.6089E+03, 2.6507E+03, 2.6928E+03, 2.7351E+03, 2.7777E+03, 2.8204E+03, &
       2.8634E+03, 2.9066E+03, 2.9500E+03, 2.9937E+03, 3.0376E+03, 3.0816E+03, 3.1259E+03, 3.1704E+03, 3.2152E+03, 3.2601E+03, &
       3.3053E+03, 3.3506E+03, 3.3962E+03, 3.4420E+03, 3.4880E+03, 3.5342E+03, 3.5807E+03, 3.6273E+03, 3.6741E+03, 3.7212E+03, &
       3.7684E+03, 3.8159E+03, 3.8636E+03, 3.9114E+03, 3.9595E+03, 4.0078E+03, 4.0563E+03, 4.1050E+03, 4.1539E+03, 4.2029E+03, &
       4.2522E+03, 4.3017E+03, 4.3514E+03, 4.4013E+03, 4.4514E+03, 4.5017E+03, 4.5522E+03, 4.6029E+03, 4.6538E+03, 4.7049E+03, &
       4.7562E+03, 4.8077E+03, 4.8594E+03, 4.9113E+03, 4.9634E+03, 5.0157E+03, 5.0682E+03, 5.1208E+03, 5.1737E+03, 5.2268E+03, &
       5.2801E+03, 5.3335E+03, 5.3872E+03, 5.4411E+03, 5.4951E+03, 5.5494E+03, 5.6038E+03, 5.6585E+03, 5.7133E+03, 5.7683E+03, &
       5.8236E+03, 5.8790E+03, 5.9346E+03, 5.9904E+03, 6.0464E+03, 6.1026E+03, 6.1590E+03, 6.2156E+03, 6.2724E+03, 6.3294E+03, &
       6.3866E+03, 6.4440E+03, 6.5016E+03, 6.5594E+03, 6.6173E+03, 6.6755E+03, 6.7339E+03, 6.7924E+03, 6.8512E+03, 6.9101E+03, &
       6.9693E+03, 7.0286E+03, 7.0882E+03, 7.1479E+03, 7.2079E+03, 7.2680E+03, 7.3283E+03, 7.3889E+03, 7.4496E+03, 7.5105E+03, &
       7.5717E+03, 7.6330E+03, 7.6945E+03, 7.7563E+03, 7.8182E+03, 7.8803E+03, 7.9426E+03, 8.0052E+03, 8.0679E+03, 8.1308E+03, &
       8.1940E+03, 8.2573E+03, 8.3208E+03, 8.3846E+03, 8.4485E+03, 8.5126E+03, 8.5770E+03, 8.6415E+03, 8.7063E+03, 8.7712E+03, &
       8.8364E+03, 8.9017E+03, 8.9673E+03, 9.0331E+03, 9.0991E+03, 9.1652E+03, 9.2316E+03, 9.2982E+03, 9.3650E+03, 9.4320E+03, &
       9.4993E+03, 9.5667E+03, 9.6343E+03, 9.7022E+03, 9.7702E+03, 9.8385E+03, 9.9070E+03, 9.9756E+03, 1.0045E+04, 1.0114E+04, &
       1.0183E+04, 1.0252E+04, 1.0322E+04, 1.0392E+04, 1.0462E+04, 1.0533E+04, 1.0603E+04, 1.0674E+04, 1.0745E+04, 1.0816E+04, &
       1.0888E+04, 1.0959E+04, 1.1031E+04, 1.1103E+04, 1.1176E+04, 1.1248E+04, 1.1321E+04, 1.1394E+04, 1.1467E+04, 1.1541E+04, &
       1.1614E+04, 1.1688E+04, 1.1762E+04, 1.1837E+04, 1.1911E+04, 1.1986E+04, 1.2061E+04, 1.2136E+04, 1.2211E+04, 1.2287E+04, &
       1.2363E+04, 1.2439E+04, 1.2515E+04, 1.2592E+04, 1.2669E+04, 1.2746E+04, 1.2823E+04, 1.2900E+04, 1.2978E+04, 1.3056E+04, &
       1.3134E+04, 1.3212E+04, 1.3291E+04, 1.3370E+04, 1.3449E+04, 1.3528E+04, 1.3608E+04, 1.3688E+04, 1.3768E+04, 1.3848E+04, &
       1.3928E+04, 1.4009E+04, 1.4090E+04, 1.4171E+04, 1.4253E+04, 1.4334E+04, 1.4416E+04, 1.4498E+04, 1.4581E+04, 1.4663E+04, &
       1.4746E+04, 1.4829E+04, 1.4913E+04, 1.4996E+04, 1.5080E+04, 1.5164E+04, 1.5248E+04, 1.5333E+04, 1.5418E+04, 1.5503E+04, &
       1.5588E+04, 1.5674E+04, 1.5759E+04, 1.5845E+04, 1.5932E+04, 1.6018E+04, 1.6105E+04, 1.6192E+04, 1.6279E+04, 1.6367E+04, &
       1.6455E+04, 1.6543E+04, 1.6631E+04, 1.6720E+04, 1.6809E+04, 1.6898E+04, 1.6987E+04, 1.7077E+04, 1.7166E+04, 1.7256E+04, &
       1.7347E+04, 1.7437E+04, 1.7528E+04, 1.7620E+04, 1.7711E+04, 1.7803E+04, 1.7895E+04, 1.7987E+04, 1.8079E+04, 1.8172E+04, &
       1.8265E+04, 1.8358E+04, 1.8452E+04, 1.8545E+04, 1.8639E+04, 1.8734E+04, 1.8828E+04, 1.8923E+04, 1.9018E+04, 1.9114E+04, &
       1.9209E+04, 1.9305E+04, 1.9402E+04, 1.9498E+04, 1.9595E+04, 1.9692E+04, 1.9789E+04, 1.9887E+04, 1.9985E+04, 2.0083E+04, &
       2.0181E+04, 2.0280E+04, 2.0379E+04, 2.0478E+04, 2.0578E+04, 2.0678E+04, 2.0778E+04, 2.0878E+04, 2.0979E+04, 2.1080E+04, &
       2.1181E+04, 2.1283E+04, 2.1384E+04, 2.1486E+04, 2.1589E+04, 2.1692E+04, 2.1795E+04, 2.1898E+04, 2.2001E+04, 2.2105E+04, &
       2.2209E+04, 2.2314E+04, 2.2418E+04, 2.2523E+04, 2.2629E+04, 2.2734E+04, 2.2840E+04, 2.2946E+04, 2.3053E+04, 2.3160E+04, &
       2.3267E+04, 2.3374E+04, 2.3482E+04, 2.3590E+04, 2.3698E+04, 2.3807E+04, 2.3916E+04, 2.4025E+04, 2.4134E+04, 2.4244E+04, &
       2.4354E+04, 2.4465E+04, 2.4576E+04, 2.4687E+04, 2.4798E+04, 2.4910E+04, 2.5022E+04, 2.5134E+04, 2.5247E+04, 2.5359E+04, &
       2.5473E+04, 2.5586E+04, 2.5700E+04, 2.5814E+04, 2.5929E+04, 2.6044E+04, 2.6159E+04, 2.6274E+04, 2.6390E+04, 2.6506E+04, &
       2.6622E+04, 2.6739E+04, 2.6856E+04, 2.6974E+04, 2.7091E+04, 2.7209E+04, 2.7328E+04, 2.7446E+04, 2.7565E+04, 2.7685E+04, &
       2.7804E+04, 2.7924E+04, 2.8045E+04, 2.8165E+04, 2.8286E+04, 2.8408E+04, 2.8529E+04, 2.8651E+04, 2.8774E+04, 2.8896E+04, &
       2.9019E+04, 2.9143E+04, 2.9266E+04, 2.9390E+04, 2.9515E+04, 2.9639E+04, 2.9764E+04, 2.9890E+04, 3.0015E+04, 3.0141E+04, &
       3.0268E+04, 3.0395E+04, 3.0522E+04, 3.0649E+04, 3.0777E+04, 3.0905E+04, 3.1034E+04, 3.1162E+04, 3.1292E+04, 3.1421E+04, &
       3.1551E+04, 3.1681E+04, 3.1812E+04, 3.1943E+04, 3.2074E+04, 3.2206E+04, 3.2338E+04, 3.2470E+04, 3.2603E+04, 3.2736E+04, &
       3.2870E+04, 3.3003E+04, 3.3138E+04, 3.3272E+04, 3.3407E+04, 3.3542E+04, 3.3678E+04, 3.3814E+04, 3.3950E+04, 3.4087E+04, &
       3.4224E+04, 3.4362E+04, 3.4500E+04, 3.4638E+04, 3.4776E+04, 3.4915E+04, 3.5055E+04, 3.5194E+04, 3.5335E+04, 3.5475E+04, &
       3.5616E+04, 3.5757E+04, 3.5899E+04, 3.6041E+04, 3.6183E+04, 3.6326E+04, 3.6469E+04, 3.6612E+04, 3.6756E+04, 3.6901E+04, &
       3.7045E+04, 3.7190E+04, 3.7336E+04, 3.7482E+04, 3.7628E+04, 3.7775E+04, 3.7922E+04, 3.8069E+04, 3.8217E+04, 3.8365E+04, &
       3.8513E+04, 3.8662E+04, 3.8812E+04, 3.8962E+04, 3.9112E+04, 3.9262E+04, 3.9413E+04, 3.9565E+04, 3.9716E+04, 3.9869E+04, &
       4.0021E+04, 4.0174E+04, 4.0328E+04, 4.0481E+04, 4.0635E+04, 4.0790E+04, 4.0945E+04, 4.1101E+04, 4.1256E+04, 4.1413E+04, &
       4.1569E+04, 4.1726E+04, 4.1884E+04, 4.2042E+04, 4.2200E+04, 4.2359E+04, 4.2518E+04, 4.2677E+04, 4.2837E+04, 4.2998E+04, &
       4.3159E+04, 4.3320E+04, 4.3482E+04, 4.3644E+04, 4.3806E+04, 4.3969E+04, 4.4132E+04, 4.4296E+04, 4.4460E+04, 4.4625E+04, &
       4.4790E+04, 4.4956E+04, 4.5122E+04, 4.5288E+04, 4.5455E+04, 4.5622E+04, 4.5790E+04, 4.5958E+04, 4.6126E+04, 4.6295E+04, &
       4.6465E+04, 4.6635E+04, 4.6805E+04, 4.6976E+04, 4.7147E+04, 4.7319E+04, 4.7491E+04, 4.7663E+04, 4.7836E+04, 4.8010E+04, &
       4.8183E+04, 4.8358E+04, 4.8532E+04, 4.8708E+04, 4.8883E+04, 4.9059E+04, 4.9236E+04, 4.9413E+04, 4.9591E+04, 4.9768E+04, &
       4.9947E+04, 5.0126E+04, 5.0305E+04, 5.0485E+04, 5.0665E+04, 5.0846E+04, 5.1027E+04, 5.1209E+04, 5.1391E+04, 5.1573E+04, &
       5.1756E+04, 5.1940E+04, 5.2124E+04, 5.2308E+04, 5.2493E+04, 5.2678E+04, 5.2864E+04, 5.3051E+04, 5.3237E+04, 5.3425E+04, &
       5.3612E+04, 5.3801E+04, 5.3989E+04, 5.4178E+04, 5.4368E+04, 5.4558E+04, 5.4749E+04, 5.4940E+04, 5.5132E+04, 5.5324E+04, &
       5.5516E+04, 5.5709E+04, 5.5903E+04, 5.6097E+04, 5.6291E+04, 5.6486E+04, 5.6682E+04, 5.6878E+04, 5.7074E+04, 5.7271E+04, &
       5.7469E+04, 5.7667E+04, 5.7865E+04, 5.8064E+04, 5.8264E+04, 5.8464E+04, 5.8664E+04, 5.8865E+04, 5.9066E+04, 5.9268E+04, &
       5.9471E+04, 5.9674E+04, 5.9877E+04, 6.0081E+04, 6.0286E+04, 6.0491E+04, 6.0696E+04, 6.0903E+04, 6.1109E+04, 6.1316E+04, &
       6.1524E+04, 6.1732E+04, 6.1940E+04, 6.2150E+04, 6.2359E+04, 6.2569E+04, 6.2780E+04, 6.2991E+04, 6.3203E+04, 6.3415E+04, &
       6.3628E+04, 6.3841E+04, 6.4055E+04, 6.4270E+04, 6.4485E+04, 6.4700E+04, 6.4916E+04, 6.5132E+04, 6.5350E+04, 6.5567E+04, &
       6.5785E+04, 6.6004E+04, 6.6223E+04, 6.6443E+04, 6.6663E+04, 6.6884E+04, 6.7105E+04, 6.7327E+04, 6.7549E+04, 6.7772E+04, &
       6.7996E+04, 6.8220E+04, 6.8444E+04, 6.8670E+04, 6.8895E+04, 6.9122E+04, 6.9348E+04, 6.9576E+04, 6.9804E+04, 7.0032E+04, &
       7.0261E+04, 7.0491E+04, 7.0721E+04, 7.0951E+04, 7.1183E+04, 7.1414E+04, 7.1647E+04, 7.1880E+04, 7.2113E+04, 7.2347E+04, &
       7.2582E+04, 7.2817E+04, 7.3053E+04, 7.3289E+04, 7.3526E+04, 7.3763E+04, 7.4001E+04, 7.4240E+04, 7.4479E+04, 7.4719E+04, &
       7.4959E+04, 7.5200E+04, 7.5442E+04, 7.5684E+04, 7.5926E+04, 7.6170E+04, 7.6413E+04, 7.6658E+04, 7.6903E+04, 7.7148E+04, &
       7.7394E+04, 7.7641E+04, 7.7889E+04, 7.8136E+04, 7.8385E+04, 7.8634E+04, 7.8884E+04, 7.9134E+04, 7.9385E+04, 7.9636E+04, &
       7.9888E+04, 8.0141E+04, 8.0394E+04, 8.0648E+04, 8.0903E+04, 8.1158E+04, 8.1413E+04, 8.1670E+04, 8.1926E+04, 8.2184E+04, &
       8.2442E+04, 8.2701E+04, 8.2960E+04, 8.3220E+04, 8.3480E+04, 8.3742E+04, 8.4003E+04, 8.4266E+04, 8.4529E+04, 8.4792E+04, &
       8.5057E+04, 8.5321E+04, 8.5587E+04, 8.5853E+04, 8.6120E+04, 8.6387E+04, 8.6655E+04, 8.6923E+04, 8.7193E+04, 8.7462E+04, &
       8.7733E+04, 8.8004E+04, 8.8276E+04, 8.8548E+04, 8.8821E+04, 8.9095E+04, 8.9369E+04, 8.9644E+04, 8.9919E+04, 9.0195E+04, &
       9.0472E+04, 9.0750E+04, 9.1028E+04, 9.1306E+04, 9.1586E+04, 9.1866E+04, 9.2146E+04, 9.2428E+04, 9.2710E+04, 9.2992E+04, &
       9.3276E+04, 9.3559E+04, 9.3844E+04, 9.4129E+04, 9.4415E+04, 9.4702E+04, 9.4989E+04, 9.5277E+04, 9.5565E+04, 9.5854E+04, &
       9.6144E+04, 9.6435E+04, 9.6726E+04, 9.7017E+04, 9.7310E+04, 9.7603E+04, 9.7897E+04, 9.8191E+04, 9.8486E+04, 9.8782E+04, &
       9.9079E+04, 9.9376E+04, 9.9674E+04, 9.9972E+04, 1.0027E+05, 1.0057E+05, 1.0087E+05, 1.0117E+05, 1.0147E+05, 1.0178E+05, &
       1.0208E+05, 1.0238E+05, 1.0269E+05, 1.0299E+05, 1.0330E+05, 1.0361E+05, 1.0391E+05, 1.0422E+05, 1.0453E+05, 1.0484E+05, &
       1.0515E+05, 1.0546E+05, 1.0577E+05, 1.0609E+05, 1.0640E+05, 1.0671E+05, 1.0703E+05, 1.0734E+05, 1.0766E+05, 1.0797E+05, &
       1.0829E+05, 1.0861E+05, 1.0893E+05, 1.0925E+05, 1.0957E+05, 1.0989E+05, 1.1021E+05, 1.1053E+05, 1.1085E+05, 1.1118E+05, &
       1.1150E+05, 1.1183E+05, 1.1215E+05, 1.1248E+05, 1.1281E+05, 1.1313E+05, 1.1346E+05, 1.1379E+05, 1.1412E+05, 1.1445E+05, &
       1.1478E+05, 1.1512E+05, 1.1545E+05, 1.1578E+05, 1.1612E+05, 1.1645E+05, 1.1679E+05, 1.1713E+05, 1.1746E+05, 1.1780E+05, &
       1.1814E+05, 1.1848E+05, 1.1882E+05, 1.1916E+05, 1.1950E+05, 1.1985E+05, 1.2019E+05, 1.2053E+05, 1.2088E+05, 1.2122E+05, &
       1.2157E+05, 1.2192E+05, 1.2226E+05, 1.2261E+05, 1.2296E+05, 1.2331E+05, 1.2366E+05, 1.2401E+05, 1.2437E+05, 1.2472E+05, &
       1.2507E+05, 1.2543E+05, 1.2578E+05, 1.2614E+05, 1.2650E+05, 1.2685E+05, 1.2721E+05, 1.2757E+05, 1.2793E+05, 1.2829E+05, &
       1.2865E+05, 1.2902E+05, 1.2938E+05, 1.2974E+05, 1.3011E+05, 1.3047E+05, 1.3084E+05, 1.3121E+05, 1.3158E+05, 1.3194E+05, &
       1.3231E+05, 1.3268E+05, 1.3305E+05, 1.3343E+05, 1.3380E+05, 1.3417E+05, 1.3455E+05, 1.3492E+05, 1.3530E+05, 1.3567E+05, &
       1.3605E+05, 1.3643E+05, 1.3681E+05, 1.3719E+05, 1.3757E+05, 1.3795E+05, 1.3833E+05, 1.3871E+05, 1.3910E+05, 1.3948E+05, &
       1.3987E+05, 1.4025E+05, 1.4064E+05, 1.4103E+05, 1.4142E+05, 1.4181E+05, 1.4220E+05, 1.4259E+05, 1.4298E+05, 1.4337E+05, &
       1.4377E+05, 1.4416E+05, 1.4456E+05, 1.4495E+05, 1.4535E+05, 1.4575E+05, 1.4614E+05, 1.4654E+05, 1.4694E+05, 1.4735E+05, &
       1.4775E+05, 1.4815E+05, 1.4855E+05, 1.4896E+05, 1.4936E+05, 1.4977E+05, 1.5018E+05, 1.5058E+05, 1.5099E+05, 1.5140E+05, &
       1.5181E+05, 1.5222E+05, 1.5263E+05, 1.5305E+05, 1.5346E+05, 1.5387E+05, 1.5429E+05, 1.5471E+05, 1.5512E+05, 1.5554E+05, &
       1.5596E+05, 1.5638E+05, 1.5680E+05, 1.5722E+05, 1.5764E+05, 1.5807E+05, 1.5849E+05, 1.5891E+05, 1.5934E+05, 1.5977E+05, &
       1.6019E+05, 1.6062E+05, 1.6105E+05, 1.6148E+05, 1.6191E+05, 1.6234E+05, 1.6278E+05, 1.6321E+05, 1.6364E+05, 1.6408E+05, &
       1.6452E+05, 1.6495E+05, 1.6539E+05, 1.6583E+05, 1.6627E+05, 1.6671E+05, 1.6715E+05, 1.6759E+05, 1.6804E+05, 1.6848E+05, &
       1.6893E+05, 1.6937E+05, 1.6982E+05, 1.7027E+05, 1.7072E+05, 1.7116E+05, 1.7162E+05, 1.7207E+05, 1.7252E+05, 1.7297E+05, &
       1.7343E+05, 1.7388E+05, 1.7434E+05, 1.7479E+05, 1.7525E+05, 1.7571E+05, 1.7617E+05, 1.7663E+05, 1.7709E+05, 1.7755E+05, &
       1.7802E+05, 1.7848E+05, 1.7895E+05, 1.7941E+05, 1.7988E+05, 1.8035E+05, 1.8081E+05, 1.8128E+05, 1.8175E+05, 1.8223E+05, &
       1.8270E+05, 1.8317E+05, 1.8365E+05, 1.8412E+05, 1.8460E+05, 1.8508E+05, 1.8555E+05, 1.8603E+05, 1.8651E+05, 1.8699E+05, &
       1.8747E+05, 1.8796E+05, 1.8844E+05, 1.8893E+05, 1.8941E+05, 1.8990E+05, 1.9039E+05, 1.9087E+05, 1.9136E+05, 1.9185E+05, &
       1.9235E+05, 1.9284E+05, 1.9333E+05, 1.9382E+05, 1.9432E+05, 1.9482E+05, 1.9531E+05, 1.9581E+05, 1.9631E+05, 1.9681E+05, &
       1.9731E+05, 1.9781E+05, 1.9832E+05, 1.9882E+05, 1.9932E+05, 1.9983E+05, 2.0034E+05, 2.0085E+05, 2.0135E+05, 2.0186E+05, &
       2.0237E+05, 2.0289E+05, 2.0340E+05, 2.0391E+05, 2.0443E+05, 2.0494E+05, 2.0546E+05, 2.0598E+05, 2.0650E+05, 2.0702E+05, &
       2.0754E+05, 2.0806E+05, 2.0858E+05, 2.0910E+05, 2.0963E+05, 2.1015E+05, 2.1068E+05, 2.1121E+05, 2.1174E+05, 2.1227E+05, &
       2.1280E+05, 2.1333E+05, 2.1386E+05, 2.1440E+05, 2.1493E+05, 2.1547E+05, 2.1600E+05, 2.1654E+05, 2.1708E+05, 2.1762E+05, &
       2.1816E+05, 2.1870E+05, 2.1924E+05, 2.1979E+05, 2.2033E+05, 2.2088E+05, 2.2143E+05, 2.2197E+05, 2.2252E+05, 2.2307E+05, &
       2.2362E+05, 2.2418E+05, 2.2473E+05, 2.2528E+05, 2.2584E+05, 2.2640E+05, 2.2695E+05, 2.2751E+05, 2.2807E+05, 2.2863E+05, &
       2.2919E+05, 2.2976E+05, 2.3032E+05, 2.3088E+05, 2.3145E+05, 2.3202E+05, 2.3258E+05, 2.3315E+05, 2.3372E+05, 2.3429E+05, &
       2.3487E+05, 2.3544E+05, 2.3601E+05, 2.3659E+05, 2.3716E+05, 2.3774E+05, 2.3832E+05, 2.3890E+05, 2.3948E+05, 2.4006E+05, &
       2.4064E+05, 2.4123E+05, 2.4181E+05, 2.4240E+05, 2.4299E+05, 2.4357E+05, 2.4416E+05, 2.4475E+05, 2.4535E+05, 2.4594E+05, &
       2.4653E+05, 2.4713E+05, 2.4772E+05, 2.4832E+05, 2.4892E+05, 2.4952E+05, 2.5012E+05, 2.5072E+05, 2.5132E+05, 2.5192E+05, &
       2.5253E+05, 2.5313E+05, 2.5374E+05, 2.5435E+05, 2.5496E+05, 2.5557E+05, 2.5618E+05, 2.5679E+05, 2.5740E+05, 2.5802E+05, &
       2.5863E+05, 2.5925E+05, 2.5987E+05, 2.6049E+05, 2.6111E+05, 2.6173E+05, 2.6235E+05, 2.6297E+05, 2.6360E+05, 2.6422E+05, &
       2.6485E+05, 2.6548E+05, 2.6611E+05, 2.6674E+05, 2.6737E+05, 2.6800E+05, 2.6863E+05, 2.6927E+05, 2.6990E+05, 2.7054E+05, &
       2.7118E+05, 2.7182E+05, 2.7246E+05, 2.7310E+05, 2.7374E+05, 2.7439E+05, 2.7503E+05, 2.7568E+05, 2.7632E+05, 2.7697E+05, &
       2.7762E+05, 2.7827E+05, 2.7893E+05, 2.7958E+05, 2.8023E+05, 2.8089E+05, 2.8154E+05, 2.8220E+05, 2.8286E+05, 2.8352E+05, &
       2.8418E+05, 2.8484E+05, 2.8551E+05, 2.8617E+05, 2.8684E+05, 2.8751E+05, 2.8817E+05, 2.8884E+05, 2.8951E+05, 2.9019E+05, &
       2.9086E+05, 2.9153E+05, 2.9221E+05, 2.9288E+05, 2.9356E+05, 2.9424E+05, 2.9492E+05, 2.9560E+05, 2.9628E+05, 2.9697E+05, &
       2.9765E+05, 2.9834E+05, 2.9903E+05, 2.9971E+05, 3.0040E+05, 3.0110E+05, 3.0179E+05, 3.0248E+05, 3.0317E+05, 3.0387E+05, &
       3.0457E+05, 3.0527E+05, 3.0596E+05, 3.0667E+05, 3.0737E+05, 3.0807E+05, 3.0877E+05, 3.0948E+05, 3.1019E+05, 3.1089E+05, &
       3.1160E+05, 3.1231E+05, 3.1302E+05, 3.1374E+05, 3.1445E+05, 3.1517E+05, 3.1588E+05, 3.1660E+05, 3.1732E+05, 3.1804E+05, &
       3.1876E+05, 3.1948E+05, 3.2021E+05, 3.2093E+05, 3.2166E+05, 3.2239E+05, 3.2311E+05, 3.2384E+05, 3.2458E+05, 3.2531E+05, &
       3.2604E+05, 3.2678E+05, 3.2751E+05, 3.2825E+05, 3.2899E+05, 3.2973E+05, 3.3047E+05, 3.3121E+05, 3.3196E+05, 3.3270E+05, &
       3.3345E+05, 3.3420E+05, 3.3494E+05, 3.3569E+05, 3.3645E+05, 3.3720E+05, 3.3795E+05, 3.3871E+05, 3.3946E+05, 3.4022E+05, &
       3.4098E+05, 3.4174E+05, 3.4250E+05, 3.4327E+05, 3.4403E+05, 3.4480E+05, 3.4556E+05, 3.4633E+05, 3.4710E+05, 3.4787E+05, &
       3.4864E+05, 3.4942E+05, 3.5019E+05, 3.5097E+05, 3.5174E+05, 3.5252E+05, 3.5330E+05, 3.5408E+05, 3.5486E+05, 3.5565E+05, &
       3.5643E+05, 3.5722E+05, 3.5801E+05, 3.5880E+05, 3.5959E+05, 3.6038E+05, 3.6117E+05, 3.6196E+05, 3.6276E+05, 3.6356E+05, &
       3.6435E+05, 3.6515E+05, 3.6595E+05, 3.6676E+05, 3.6756E+05, 3.6836E+05, 3.6917E+05, 3.6998E+05, 3.7079E+05, 3.7160E+05, &
       3.7241E+05, 3.7322E+05, 3.7404E+05, 3.7485E+05, 3.7567E+05, 3.7649E+05, 3.7730E+05, 3.7813E+05, 3.7895E+05, 3.7977E+05, &
       3.8060E+05, 3.8142E+05, 3.8225E+05, 3.8308E+05, 3.8391E+05, 3.8474E+05, 3.8557E+05, 3.8641E+05, 3.8724E+05, 3.8808E+05, &
       3.8892E+05, 3.8976E+05, 3.9060E+05, 3.9144E+05, 3.9229E+05, 3.9313E+05, 3.9398E+05, 3.9482E+05, 3.9567E+05, 3.9652E+05, &
       3.9738E+05, 3.9823E+05, 3.9909E+05, 3.9994E+05, 4.0080E+05, 4.0166E+05, 4.0252E+05, 4.0338E+05, 4.0424E+05, 4.0511E+05, &
       4.0597E+05, 4.0684E+05, 4.0771E+05, 4.0858E+05, 4.0945E+05, 4.1032E+05, 4.1120E+05, 4.1207E+05, 4.1295E+05, 4.1383E+05, &
       4.1471E+05, 4.1559E+05, 4.1647E+05, 4.1736E+05, 4.1824E+05, 4.1913E+05, 4.2002E+05, 4.2091E+05, 4.2180E+05, 4.2269E+05, &
       4.2359E+05, 4.2448E+05, 4.2538E+05, 4.2628E+05, 4.2718E+05, 4.2808E+05, 4.2898E+05, 4.2989E+05, 4.3079E+05, 4.3170E+05, &
       4.3261E+05, 4.3352E+05, 4.3443E+05, 4.3534E+05, 4.3626E+05, 4.3717E+05, 4.3809E+05, 4.3901E+05, 4.3993E+05, 4.4085E+05, &
       4.4177E+05, 4.4270E+05, 4.4362E+05, 4.4455E+05, 4.4548E+05, 4.4641E+05, 4.4734E+05, 4.4827E+05, 4.4921E+05, 4.5014E+05, &
       4.5108E+05, 4.5202E+05, 4.5296E+05, 4.5390E+05, 4.5484E+05, 4.5579E+05, 4.5674E+05, 4.5768E+05, 4.5863E+05, 4.5958E+05, &
       4.6054E+05, 4.6149E+05, 4.6244E+05, 4.6340E+05, 4.6436E+05, 4.6532E+05, 4.6628E+05, 4.6724E+05, 4.6821E+05, 4.6917E+05, &
       4.7014E+05, 4.7111E+05, 4.7208E+05, 4.7305E+05, 4.7402E+05, 4.7500E+05, 4.7597E+05, 4.7695E+05, 4.7793E+05, 4.7891E+05, &
       4.7989E+05, 4.8088E+05, 4.8186E+05, 4.8285E+05, 4.8384E+05, 4.8483E+05, 4.8582E+05, 4.8681E+05, 4.8780E+05, 4.8880E+05, &
       4.8980E+05, 4.9080E+05, 4.9180E+05, 4.9280E+05, 4.9380E+05, 4.9481E+05, 4.9581E+05, 4.9682E+05, 4.9783E+05, 4.9884E+05, &
       4.9985E+05, 5.0087E+05, 5.0188E+05, 5.0290E+05, 5.0392E+05, 5.0494E+05, 5.0596E+05, 5.0699E+05, 5.0801E+05, 5.0904E+05, &
       5.1007E+05, 5.1110E+05, 5.1213E+05, 5.1316E+05, 5.1419E+05, 5.1523E+05, 5.1627E+05, 5.1731E+05, 5.1835E+05, 5.1939E+05, &
       5.2043E+05, 5.2148E+05, 5.2253E+05, 5.2357E+05, 5.2462E+05, 5.2568E+05, 5.2673E+05, 5.2778E+05, 5.2884E+05, 5.2990E+05, &
       5.3096E+05, 5.3202E+05, 5.3308E+05, 5.3415E+05, 5.3521E+05, 5.3628E+05, 5.3735E+05, 5.3842E+05, 5.3949E+05, 5.4057E+05, &
       5.4164E+05, 5.4272E+05, 5.4380E+05, 5.4488E+05, 5.4596E+05, 5.4704E+05, 5.4813E+05, 5.4922E+05, 5.5030E+05, 5.5139E+05, &
       5.5249E+05, 5.5358E+05, 5.5467E+05, 5.5577E+05, 5.5687E+05, 5.5797E+05, 5.5907E+05, 5.6017E+05, 5.6128E+05, 5.6238E+05, &
       5.6349E+05, 5.6460E+05, 5.6571E+05, 5.6682E+05, 5.6794E+05, 5.6906E+05, 5.7017E+05, 5.7129E+05, 5.7241E+05, 5.7354E+05, &
       5.7466E+05, 5.7579E+05, 5.7691E+05, 5.7804E+05, 5.7917E+05, 5.8031E+05, 5.8144E+05, 5.8258E+05, 5.8371E+05, 5.8485E+05, &
       5.8599E+05, 5.8714E+05, 5.8828E+05, 5.8943E+05, 5.9057E+05, 5.9172E+05, 5.9287E+05, 5.9403E+05, 5.9518E+05, 5.9634E+05, &
       5.9749E+05, 5.9865E+05, 5.9981E+05, 6.0098E+05, 6.0214E+05, 6.0331E+05, 6.0447E+05, 6.0564E+05, 6.0681E+05, 6.0799E+05, &
       6.0916E+05, 6.1034E+05, 6.1152E+05, 6.1270E+05, 6.1388E+05, 6.1506E+05, 6.1624E+05, 6.1743E+05, 6.1862E+05, 6.1981E+05, &
       6.2100E+05, 6.2219E+05, 6.2339E+05, 6.2458E+05, 6.2578E+05, 6.2698E+05, 6.2818E+05, 6.2939E+05, 6.3059E+05, 6.3180E+05, &
       6.3301E+05, 6.3422E+05, 6.3543E+05, 6.3664E+05, 6.3786E+05, 6.3908E+05, 6.4030E+05, 6.4152E+05, 6.4274E+05, 6.4396E+05, &
       6.4519E+05, 6.4642E+05, 6.4765E+05, 6.4888E+05, 6.5011E+05, 6.5134E+05, 6.5258E+05, 6.5382E+05, 6.5506E+05, 6.5630E+05, &
       6.5754E+05, 6.5879E+05, 6.6004E+05, 6.6128E+05, 6.6254E+05, 6.6379E+05, 6.6504E+05, 6.6630E+05, 6.6755E+05, 6.6881E+05, &
       6.7007E+05, 6.7134E+05, 6.7260E+05, 6.7387E+05, 6.7514E+05, 6.7641E+05, 6.7768E+05, 6.7895E+05, 6.8023E+05, 6.8150E+05, &
       6.8278E+05, 6.8406E+05, 6.8535E+05, 6.8663E+05, 6.8792E+05, 6.8920E+05, 6.9049E+05, 6.9178E+05, 6.9308E+05, 6.9437E+05, &
       6.9567E+05, 6.9697E+05, 6.9827E+05, 6.9957E+05, 7.0087E+05, 7.0218E+05, 7.0349E+05, 7.0480E+05, 7.0611E+05, 7.0742E+05, &
       7.0874E+05, 7.1005E+05, 7.1137E+05, 7.1269E+05, 7.1401E+05, 7.1534E+05, 7.1666E+05, 7.1799E+05, 7.1932E+05, 7.2065E+05, &
       7.2199E+05, 7.2332E+05, 7.2466E+05, 7.2600E+05, 7.2734E+05, 7.2868E+05, 7.3002E+05, 7.3137E+05, 7.3272E+05, 7.3407E+05, &
       7.3542E+05, 7.3677E+05, 7.3813E+05, 7.3948E+05, 7.4084E+05, 7.4220E+05, 7.4357E+05, 7.4493E+05, 7.4630E+05, 7.4767E+05, &
       7.4904E+05, 7.5041E+05, 7.5178E+05, 7.5316E+05, 7.5454E+05, 7.5592E+05, 7.5730E+05, 7.5868E+05, 7.6007E+05, 7.6145E+05, &
       7.6284E+05, 7.6423E+05, 7.6562E+05, 7.6702E+05, 7.6842E+05, 7.6981E+05, 7.7121E+05, 7.7262E+05, 7.7402E+05, 7.7543E+05, &
       7.7683E+05, 7.7824E+05, 7.7965E+05, 7.8107E+05, 7.8248E+05, 7.8390E+05, 7.8532E+05, 7.8674E+05, 7.8816E+05, 7.8959E+05, &
       7.9102E+05, 7.9244E+05, 7.9388E+05, 7.9531E+05, 7.9674E+05, 7.9818E+05, 7.9962E+05, 8.0106E+05, 8.0250E+05, 8.0394E+05, &
       8.0539E+05, 8.0684E+05, 8.0829E+05, 8.0974E+05, 8.1119E+05, 8.1265E+05, 8.1411E+05, 8.1557E+05, 8.1703E+05, 8.1849E+05, &
       8.1996E+05, 8.2142E+05, 8.2289E+05, 8.2436E+05, 8.2584E+05, 8.2731E+05, 8.2879E+05, 8.3027E+05, 8.3175E+05, 8.3323E+05, &
       8.3472E+05, 8.3621E+05, 8.3769E+05, 8.3919E+05, 8.4068E+05, 8.4217E+05, 8.4367E+05, 8.4517E+05, 8.4667E+05, 8.4817E+05, &
       8.4968E+05, 8.5118E+05, 8.5269E+05, 8.5420E+05, 8.5571E+05, 8.5723E+05, 8.5875E+05, 8.6026E+05, 8.6178E+05, 8.6331E+05, &
       8.6483E+05, 8.6636E+05, 8.6789E+05, 8.6942E+05, 8.7095E+05, 8.7248E+05, 8.7402E+05, 8.7556E+05, 8.7710E+05, 8.7864E+05, &
       8.8019E+05, 8.8173E+05, 8.8328E+05, 8.8483E+05, 8.8638E+05, 8.8794E+05, 8.8950E+05, 8.9105E+05, 8.9262E+05, 8.9418E+05, &
       8.9574E+05, 8.9731E+05, 8.9888E+05, 9.0045E+05, 9.0202E+05, 9.0360E+05, 9.0517E+05, 9.0675E+05, 9.0833E+05, 9.0992E+05, &
       9.1150E+05, 9.1309E+05, 9.1468E+05, 9.1627E+05, 9.1786E+05, 9.1946E+05, 9.2105E+05, 9.2265E+05, 9.2425E+05, 9.2586E+05, &
       9.2746E+05, 9.2907E+05, 9.3068E+05, 9.3229E+05, 9.3391E+05, 9.3552E+05, 9.3714E+05, 9.3876E+05, 9.4038E+05, 9.4201E+05, &
       9.4363E+05, 9.4526E+05, 9.4689E+05, 9.4852E+05, 9.5016E+05, 9.5179E+05, 9.5343E+05, 9.5507E+05, 9.5672E+05, 9.5836E+05, &
       9.6001E+05, 9.6166E+05, 9.6331E+05, 9.6496E+05, 9.6662E+05, 9.6827E+05, 9.6993E+05, 9.7159E+05, 9.7326E+05, 9.7492E+05, &
       9.7659E+05, 9.7826E+05, 9.7993E+05, 9.8161E+05, 9.8328E+05, 9.8496E+05, 9.8664E+05, 9.8833E+05, 9.9001E+05, 9.9170E+05, &
       9.9339E+05, 9.9508E+05, 9.9677E+05, 9.9847E+05, 1.0002E+06, 1.0019E+06, 1.0036E+06, 1.0053E+06, 1.0070E+06, 1.0087E+06, &
       1.0104E+06, 1.0121E+06, 1.0138E+06, 1.0155E+06, 1.0173E+06, 1.0190E+06, 1.0207E+06, 1.0224E+06, 1.0242E+06, 1.0259E+06, &
       1.0276E+06, 1.0294E+06, 1.0311E+06, 1.0328E+06, 1.0346E+06, 1.0363E+06, 1.0381E+06, 1.0398E+06, 1.0415E+06, 1.0433E+06, &
       1.0451E+06, 1.0468E+06, 1.0486E+06, 1.0503E+06, 1.0521E+06, 1.0539E+06, 1.0556E+06, 1.0574E+06, 1.0592E+06, 1.0609E+06, &
       1.0627E+06, 1.0645E+06, 1.0663E+06, 1.0680E+06, 1.0698E+06, 1.0716E+06, 1.0734E+06, 1.0752E+06, 1.0770E+06, 1.0788E+06, &
       1.0806E+06, 1.0824E+06, 1.0842E+06, 1.0860E+06, 1.0878E+06, 1.0896E+06, 1.0914E+06, 1.0932E+06, 1.0950E+06, 1.0969E+06, &
       1.0987E+06, 1.1005E+06, 1.1023E+06, 1.1041E+06, 1.1060E+06, 1.1078E+06, 1.1096E+06, 1.1115E+06, 1.1133E+06, 1.1151E+06, &
       1.1170E+06, 1.1188E+06, 1.1207E+06, 1.1225E+06, 1.1244E+06, 1.1262E+06, 1.1281E+06, 1.1299E+06, 1.1318E+06, 1.1337E+06, &
       1.1355E+06, 1.1374E+06, 1.1393E+06, 1.1411E+06, 1.1430E+06, 1.1449E+06, 1.1468E+06, 1.1486E+06, 1.1505E+06, 1.1524E+06, &
       1.1543E+06, 1.1562E+06, 1.1581E+06, 1.1600E+06, 1.1619E+06, 1.1638E+06, 1.1657E+06, 1.1676E+06, 1.1695E+06, 1.1714E+06, &
       1.1733E+06, 1.1752E+06, 1.1771E+06, 1.1790E+06, 1.1809E+06, 1.1829E+06, 1.1848E+06, 1.1867E+06, 1.1886E+06, 1.1906E+06, &
       1.1925E+06, 1.1944E+06, 1.1964E+06, 1.1983E+06, 1.2002E+06, 1.2022E+06, 1.2041E+06, 1.2061E+06, 1.2080E+06, 1.2100E+06, &
       1.2119E+06, 1.2139E+06, 1.2159E+06, 1.2178E+06, 1.2198E+06, 1.2218E+06, 1.2237E+06, 1.2257E+06, 1.2277E+06, 1.2296E+06, &
       1.2316E+06, 1.2336E+06, 1.2356E+06, 1.2376E+06, 1.2396E+06, 1.2415E+06, 1.2435E+06, 1.2455E+06, 1.2475E+06, 1.2495E+06, &
       1.2515E+06, 1.2535E+06, 1.2555E+06, 1.2576E+06, 1.2596E+06, 1.2616E+06, 1.2636E+06, 1.2656E+06, 1.2676E+06, 1.2697E+06, &
       1.2717E+06, 1.2737E+06, 1.2757E+06, 1.2778E+06, 1.2798E+06, 1.2818E+06, 1.2839E+06, 1.2859E+06, 1.2880E+06, 1.2900E+06, &
       1.2921E+06, 1.2941E+06, 1.2962E+06, 1.2982E+06, 1.3003E+06, 1.3023E+06, 1.3044E+06, 1.3065E+06, 1.3085E+06, 1.3106E+06, &
       1.3127E+06, 1.3148E+06, 1.3168E+06, 1.3189E+06, 1.3210E+06, 1.3231E+06, 1.3252E+06, 1.3273E+06, 1.3294E+06, 1.3314E+06, &
       1.3335E+06, 1.3356E+06, 1.3377E+06, 1.3398E+06, 1.3420E+06, 1.3441E+06, 1.3462E+06, 1.3483E+06, 1.3504E+06, 1.3525E+06, &
       1.3546E+06, 1.3568E+06, 1.3589E+06, 1.3610E+06, 1.3632E+06, 1.3653E+06, 1.3674E+06, 1.3696E+06, 1.3717E+06, 1.3738E+06, &
       1.3760E+06, 1.3781E+06, 1.3803E+06, 1.3824E+06, 1.3846E+06, 1.3868E+06, 1.3889E+06, 1.3911E+06, 1.3932E+06, 1.3954E+06, &
       1.3976E+06, 1.3998E+06, 1.4019E+06, 1.4041E+06, 1.4063E+06, 1.4085E+06, 1.4106E+06, 1.4128E+06, 1.4150E+06, 1.4172E+06, &
       1.4194E+06, 1.4216E+06, 1.4238E+06, 1.4260E+06, 1.4282E+06, 1.4304E+06, 1.4326E+06, 1.4348E+06, 1.4371E+06, 1.4393E+06, &
       1.4415E+06, 1.4437E+06, 1.4459E+06, 1.4482E+06, 1.4504E+06, 1.4526E+06, 1.4549E+06, 1.4571E+06, 1.4593E+06, 1.4616E+06, &
       1.4638E+06, 1.4661E+06, 1.4683E+06, 1.4706E+06, 1.4728E+06, 1.4751E+06, 1.4773E+06, 1.4796E+06, 1.4819E+06, 1.4841E+06, &
       1.4864E+06, 1.4887E+06, 1.4910E+06, 1.4932E+06, 1.4955E+06, 1.4978E+06, 1.5001E+06, 1.5024E+06, 1.5046E+06, 1.5069E+06, &
       1.5092E+06, 1.5115E+06, 1.5138E+06, 1.5161E+06, 1.5184E+06, 1.5207E+06, 1.5231E+06, 1.5254E+06, 1.5277E+06, 1.5300E+06, &
       1.5323E+06, 1.5346E+06, 1.5370E+06, 1.5393E+06, 1.5416E+06, 1.5440E+06, 1.5463E+06, 1.5486E+06, 1.5510E+06, 1.5533E+06, &
       1.5557E+06, 1.5580E+06, 1.5604E+06, 1.5627E+06, 1.5651E+06, 1.5674E+06, 1.5698E+06, 1.5722E+06, 1.5745E+06, 1.5769E+06, &
       1.5793E+06, 1.5816E+06, 1.5840E+06, 1.5864E+06, 1.5888E+06, 1.5912E+06, 1.5935E+06, 1.5959E+06, 1.5983E+06, 1.6007E+06, &
       1.6031E+06, 1.6055E+06, 1.6079E+06, 1.6103E+06, 1.6127E+06, 1.6151E+06, 1.6176E+06, 1.6200E+06, 1.6224E+06, 1.6248E+06, &
       1.6272E+06, 1.6297E+06, 1.6321E+06, 1.6345E+06, 1.6370E+06, 1.6394E+06, 1.6418E+06, 1.6443E+06, 1.6467E+06, 1.6492E+06, &
       1.6516E+06, 1.6541E+06, 1.6565E+06, 1.6590E+06, 1.6614E+06, 1.6639E+06, 1.6664E+06, 1.6688E+06, 1.6713E+06, 1.6738E+06, &
       1.6763E+06, 1.6787E+06, 1.6812E+06, 1.6837E+06, 1.6862E+06, 1.6887E+06, 1.6912E+06, 1.6937E+06, 1.6962E+06, 1.6987E+06, &
       1.7012E+06, 1.7037E+06, 1.7062E+06, 1.7087E+06, 1.7112E+06, 1.7137E+06, 1.7162E+06, 1.7187E+06, 1.7213E+06, 1.7238E+06, &
       1.7263E+06, 1.7289E+06, 1.7314E+06, 1.7339E+06, 1.7365E+06, 1.7390E+06, 1.7416E+06, 1.7441E+06, 1.7467E+06, 1.7492E+06, &
       1.7518E+06, 1.7543E+06, 1.7569E+06, 1.7595E+06, 1.7620E+06, 1.7646E+06, 1.7672E+06, 1.7697E+06, 1.7723E+06, 1.7749E+06, &
       1.7775E+06, 1.7801E+06, 1.7826E+06, 1.7852E+06, 1.7878E+06, 1.7904E+06, 1.7930E+06, 1.7956E+06, 1.7982E+06, 1.8008E+06, &
       1.8035E+06, 1.8061E+06, 1.8087E+06, 1.8113E+06, 1.8139E+06, 1.8165E+06, 1.8192E+06, 1.8218E+06, 1.8244E+06, 1.8271E+06, &
       1.8297E+06, 1.8323E+06, 1.8350E+06, 1.8376E+06, 1.8403E+06, 1.8429E+06, 1.8456E+06, 1.8482E+06, 1.8509E+06, 1.8536E+06, &
       1.8562E+06, 1.8589E+06, 1.8616E+06, 1.8642E+06, 1.8669E+06, 1.8696E+06, 1.8723E+06, 1.8750E+06, 1.8776E+06, 1.8803E+06, &
       1.8830E+06, 1.8857E+06, 1.8884E+06, 1.8911E+06, 1.8938E+06, 1.8965E+06, 1.8992E+06, 1.9019E+06, 1.9047E+06, 1.9074E+06, &
       1.9101E+06, 1.9128E+06, 1.9155E+06, 1.9183E+06, 1.9210E+06, 1.9237E+06, 1.9265E+06, 1.9292E+06, 1.9320E+06, 1.9347E+06, &
       1.9375E+06, 1.9402E+06, 1.9430E+06, 1.9457E+06, 1.9485E+06, 1.9512E+06, 1.9540E+06, 1.9568E+06, 1.9595E+06, 1.9623E+06, &
       1.9651E+06, 1.9679E+06, 1.9706E+06, 1.9734E+06, 1.9762E+06, 1.9790E+06, 1.9818E+06, 1.9846E+06, 1.9874E+06, 1.9902E+06, &
       1.9930E+06, 1.9958E+06, 1.9986E+06, 2.0014E+06, 2.0042E+06, 2.0071E+06, 2.0099E+06, 2.0127E+06, 2.0155E+06, 2.0184E+06, &
       2.0212E+06, 2.0240E+06, 2.0269E+06, 2.0297E+06, 2.0326E+06, 2.0354E+06, 2.0382E+06, 2.0411E+06, 2.0440E+06, 2.0468E+06, &
       2.0497E+06, 2.0525E+06, 2.0554E+06, 2.0583E+06, 2.0611E+06, 2.0640E+06, 2.0669E+06, 2.0698E+06, 2.0727E+06, 2.0755E+06, &
       2.0784E+06, 2.0813E+06, 2.0842E+06, 2.0871E+06, 2.0900E+06, 2.0929E+06, 2.0958E+06, 2.0987E+06, 2.1017E+06, 2.1046E+06, &
       2.1075E+06, 2.1104E+06, 2.1133E+06, 2.1163E+06, 2.1192E+06, 2.1221E+06, 2.1251E+06, 2.1280E+06, 2.1309E+06, 2.1339E+06, &
       2.1368E+06, 2.1398E+06, 2.1427E+06, 2.1457E+06, 2.1486E+06, 2.1516E+06, 2.1546E+06, 2.1575E+06, 2.1605E+06, 2.1635E+06, &
       2.1665E+06, 2.1694E+06, 2.1724E+06, 2.1754E+06, 2.1784E+06, 2.1814E+06, 2.1844E+06, 2.1874E+06, 2.1904E+06, 2.1934E+06, &
       2.1964E+06, 2.1994E+06, 2.2024E+06, 2.2054E+06, 2.2084E+06, 2.2114E+06, 2.2145E+06, 2.2175E+06, 2.2205E+06, 2.2236E+06, &
       2.2266E+06, 2.2296E+06, 2.2327E+06, 2.2357E+06, 2.2388E+06, 2.2418E+06, 2.2449E+06, 2.2479E+06, 2.2510E+06, 2.2540E+06, &
       2.2571E+06, 2.2602E+06, 2.2632E+06, 2.2663E+06, 2.2694E+06, 2.2725E+06, 2.2755E+06, 2.2786E+06, 2.2817E+06, 2.2848E+06, &
       2.2879E+06, 2.2910E+06, 2.2941E+06, 2.2972E+06, 2.3003E+06, 2.3034E+06, 2.3065E+06, 2.3096E+06, 2.3128E+06, 2.3159E+06, &
       2.3190E+06, 2.3221E+06, 2.3252E+06, 2.3284E+06, 2.3315E+06, 2.3347E+06, 2.3378E+06, 2.3409E+06, 2.3441E+06, 2.3472E+06, &
       2.3504E+06, 2.3535E+06, 2.3567E+06, 2.3599E+06, 2.3630E+06, 2.3662E+06, 2.3694E+06, 2.3725E+06, 2.3757E+06, 2.3789E+06, &
       2.3821E+06, 2.3853E+06, 2.3885E+06, 2.3917E+06, 2.3948E+06, 2.3980E+06, 2.4012E+06, 2.4044E+06, 2.4077E+06, 2.4109E+06/
      data (QofT( 6,J),J=2409,4510)/ 2.4141E+06, 2.4173E+06, 2.4205E+06, 2.4237E+06, 2.4270E+06, 2.4302E+06, 2.4334E+06, 2.4367E+06, &
       2.4399E+06, 2.4431E+06, 2.4464E+06, 2.4496E+06, 2.4529E+06, 2.4561E+06, 2.4594E+06, 2.4626E+06, 2.4659E+06, 2.4692E+06, &
       2.4724E+06, 2.4757E+06, 2.4790E+06, 2.4823E+06, 2.4855E+06, 2.4888E+06, 2.4921E+06, 2.4954E+06, 2.4987E+06, 2.5020E+06, &
       2.5053E+06, 2.5086E+06, 2.5119E+06, 2.5152E+06, 2.5185E+06, 2.5218E+06, 2.5251E+06, 2.5285E+06, 2.5318E+06, 2.5351E+06, &
       2.5384E+06, 2.5418E+06, 2.5451E+06, 2.5484E+06, 2.5518E+06, 2.5551E+06, 2.5585E+06, 2.5618E+06, 2.5652E+06, 2.5685E+06, &
       2.5719E+06, 2.5752E+06, 2.5786E+06, 2.5820E+06, 2.5854E+06, 2.5887E+06, 2.5921E+06, 2.5955E+06, 2.5989E+06, 2.6023E+06, &
       2.6057E+06, 2.6090E+06, 2.6124E+06, 2.6158E+06, 2.6192E+06, 2.6226E+06, 2.6261E+06, 2.6295E+06, 2.6329E+06, 2.6363E+06, &
       2.6397E+06, 2.6431E+06, 2.6466E+06, 2.6500E+06, 2.6534E+06, 2.6569E+06, 2.6603E+06, 2.6638E+06, 2.6672E+06, 2.6707E+06, &
       2.6741E+06, 2.6776E+06, 2.6810E+06, 2.6845E+06, 2.6880E+06, 2.6914E+06, 2.6949E+06, 2.6984E+06, 2.7018E+06, 2.7053E+06, &
       2.7088E+06, 2.7123E+06, 2.7158E+06, 2.7193E+06, 2.7228E+06, 2.7263E+06, 2.7298E+06, 2.7333E+06, 2.7368E+06, 2.7403E+06, &
       2.7438E+06, 2.7473E+06, 2.7509E+06, 2.7544E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       262
      data (QofT( 7,J),J=1,2408)/ 6.0000E+00, 6.0015E+00, 6.0282E+00, 6.1302E+00, 6.3426E+00, 6.6776E+00, 7.1332E+00, 7.7007E+00, &
       8.3695E+00, 9.1292E+00, 9.9706E+00, 1.0885E+01, 1.1867E+01, 1.2909E+01, 1.4007E+01, 1.5156E+01, 1.6354E+01, 1.7596E+01, &
       1.8881E+01, 2.0206E+01, 2.2969E+01, 2.5872E+01, 2.8906E+01, 3.2063E+01, 3.5336E+01, 3.8720E+01, 4.2210E+01, 4.5802E+01, &
       4.9494E+01, 5.3282E+01, 5.7163E+01, 6.1136E+01, 6.5198E+01, 6.9346E+01, 7.3581E+01, 7.7898E+01, 8.2298E+01, 8.6778E+01, &
       9.1337E+01, 9.5974E+01, 1.0069E+02, 1.0548E+02, 1.1034E+02, 1.1527E+02, 1.2028E+02, 1.2536E+02, 1.3051E+02, 1.3573E+02, &
       1.4101E+02, 1.4637E+02, 1.5179E+02, 1.5727E+02, 1.6282E+02, 1.6844E+02, 1.7412E+02, 1.7986E+02, 1.8566E+02, 1.9152E+02, &
       1.9745E+02, 2.0344E+02, 2.0948E+02, 2.1559E+02, 2.2175E+02, 2.2797E+02, 2.3425E+02, 2.4059E+02, 2.4698E+02, 2.5343E+02, &
       2.5994E+02, 2.6650E+02, 2.7311E+02, 2.7978E+02, 2.8650E+02, 2.9328E+02, 3.0011E+02, 3.0699E+02, 3.1392E+02, 3.2091E+02, &
       3.2795E+02, 3.3504E+02, 3.4218E+02, 3.4937E+02, 3.5661E+02, 3.6390E+02, 3.7124E+02, 3.7863E+02, 3.8606E+02, 3.9355E+02, &
       4.0109E+02, 4.0867E+02, 4.1630E+02, 4.2398E+02, 4.3171E+02, 4.3948E+02, 4.4730E+02, 4.5517E+02, 4.6308E+02, 4.7104E+02, &
       4.7905E+02, 4.8710E+02, 4.9519E+02, 5.0334E+02, 5.1152E+02, 5.1975E+02, 5.2803E+02, 5.3635E+02, 5.4472E+02, 5.5313E+02, &
       5.6158E+02, 5.7008E+02, 5.7862E+02, 5.8721E+02, 5.9584E+02, 6.0451E+02, 6.1322E+02, 6.2198E+02, 6.3079E+02, 6.3963E+02, &
       6.4852E+02, 6.5745E+02, 6.6642E+02, 6.7544E+02, 6.8449E+02, 6.9359E+02, 7.0273E+02, 7.1192E+02, 7.2114E+02, 7.3041E+02, &
       7.3972E+02, 7.4907E+02, 7.5847E+02, 7.6790E+02, 7.7738E+02, 7.8690E+02, 7.9646E+02, 8.0606E+02, 8.1571E+02, 8.2539E+02, &
       8.3512E+02, 8.4489E+02, 8.5470E+02, 8.6455E+02, 8.7444E+02, 8.8437E+02, 8.9435E+02, 9.0436E+02, 9.1442E+02, 9.2452E+02, &
       9.3466E+02, 9.4484E+02, 9.5507E+02, 9.6533E+02, 9.7564E+02, 9.8598E+02, 9.9637E+02, 1.0068E+03, 1.0173E+03, 1.0278E+03, &
       1.0383E+03, 1.0489E+03, 1.0596E+03, 1.0703E+03, 1.0810E+03, 1.0917E+03, 1.1025E+03, 1.1134E+03, 1.1243E+03, 1.1352E+03, &
       1.1462E+03, 1.1572E+03, 1.1682E+03, 1.1793E+03, 1.1905E+03, 1.2017E+03, 1.2129E+03, 1.2242E+03, 1.2355E+03, 1.2468E+03, &
       1.2582E+03, 1.2697E+03, 1.2811E+03, 1.2927E+03, 1.3042E+03, 1.3158E+03, 1.3275E+03, 1.3392E+03, 1.3509E+03, 1.3627E+03, &
       1.3745E+03, 1.3864E+03, 1.3983E+03, 1.4102E+03, 1.4222E+03, 1.4343E+03, 1.4463E+03, 1.4585E+03, 1.4706E+03, 1.4829E+03, &
       1.4951E+03, 1.5074E+03, 1.5198E+03, 1.5322E+03, 1.5446E+03, 1.5571E+03, 1.5696E+03, 1.5822E+03, 1.5948E+03, 1.6074E+03, &
       1.6201E+03, 1.6329E+03, 1.6457E+03, 1.6585E+03, 1.6714E+03, 1.6843E+03, 1.6973E+03, 1.7103E+03, 1.7234E+03, 1.7365E+03, &
       1.7497E+03, 1.7629E+03, 1.7761E+03, 1.7894E+03, 1.8028E+03, 1.8161E+03, 1.8296E+03, 1.8431E+03, 1.8566E+03, 1.8702E+03, &
       1.8838E+03, 1.8975E+03, 1.9112E+03, 1.9249E+03, 1.9388E+03, 1.9526E+03, 1.9665E+03, 1.9805E+03, 1.9945E+03, 2.0085E+03, &
       2.0226E+03, 2.0368E+03, 2.0510E+03, 2.0652E+03, 2.0795E+03, 2.0939E+03, 2.1083E+03, 2.1227E+03, 2.1372E+03, 2.1517E+03, &
       2.1663E+03, 2.1809E+03, 2.1956E+03, 2.2104E+03, 2.2252E+03, 2.2400E+03, 2.2549E+03, 2.2698E+03, 2.2848E+03, 2.2998E+03, &
       2.3149E+03, 2.3301E+03, 2.3453E+03, 2.3605E+03, 2.3758E+03, 2.3911E+03, 2.4065E+03, 2.4220E+03, 2.4375E+03, 2.4530E+03, &
       2.4686E+03, 2.4843E+03, 2.5000E+03, 2.5158E+03, 2.5316E+03, 2.5475E+03, 2.5634E+03, 2.5793E+03, 2.5954E+03, 2.6114E+03, &
       2.6276E+03, 2.6438E+03, 2.6600E+03, 2.6763E+03, 2.6926E+03, 2.7090E+03, 2.7255E+03, 2.7420E+03, 2.7586E+03, 2.7752E+03, &
       2.7919E+03, 2.8086E+03, 2.8254E+03, 2.8422E+03, 2.8591E+03, 2.8761E+03, 2.8931E+03, 2.9101E+03, 2.9273E+03, 2.9444E+03, &
       2.9617E+03, 2.9790E+03, 2.9963E+03, 3.0137E+03, 3.0312E+03, 3.0487E+03, 3.0663E+03, 3.0839E+03, 3.1016E+03, 3.1193E+03, &
       3.1371E+03, 3.1550E+03, 3.1729E+03, 3.1909E+03, 3.2089E+03, 3.2270E+03, 3.2452E+03, 3.2634E+03, 3.2817E+03, 3.3000E+03, &
       3.3184E+03, 3.3369E+03, 3.3554E+03, 3.3740E+03, 3.3926E+03, 3.4113E+03, 3.4300E+03, 3.4489E+03, 3.4677E+03, 3.4867E+03, &
       3.5057E+03, 3.5247E+03, 3.5439E+03, 3.5630E+03, 3.5823E+03, 3.6016E+03, 3.6210E+03, 3.6404E+03, 3.6599E+03, 3.6795E+03, &
       3.6991E+03, 3.7188E+03, 3.7385E+03, 3.7583E+03, 3.7782E+03, 3.7982E+03, 3.8182E+03, 3.8382E+03, 3.8584E+03, 3.8786E+03, &
       3.8988E+03, 3.9192E+03, 3.9396E+03, 3.9600E+03, 3.9806E+03, 4.0012E+03, 4.0218E+03, 4.0425E+03, 4.0633E+03, 4.0842E+03, &
       4.1051E+03, 4.1261E+03, 4.1472E+03, 4.1683E+03, 4.1895E+03, 4.2107E+03, 4.2321E+03, 4.2535E+03, 4.2749E+03, 4.2965E+03, &
       4.3181E+03, 4.3397E+03, 4.3615E+03, 4.3833E+03, 4.4052E+03, 4.4271E+03, 4.4491E+03, 4.4712E+03, 4.4934E+03, 4.5156E+03, &
       4.5379E+03, 4.5603E+03, 4.5827E+03, 4.6052E+03, 4.6278E+03, 4.6505E+03, 4.6732E+03, 4.6960E+03, 4.7189E+03, 4.7418E+03, &
       4.7648E+03, 4.7879E+03, 4.8111E+03, 4.8343E+03, 4.8576E+03, 4.8810E+03, 4.9045E+03, 4.9280E+03, 4.9516E+03, 4.9753E+03, &
       4.9990E+03, 5.0229E+03, 5.0468E+03, 5.0708E+03, 5.0948E+03, 5.1189E+03, 5.1432E+03, 5.1674E+03, 5.1918E+03, 5.2162E+03, &
       5.2407E+03, 5.2653E+03, 5.2900E+03, 5.3147E+03, 5.3396E+03, 5.3645E+03, 5.3894E+03, 5.4145E+03, 5.4396E+03, 5.4648E+03, &
       5.4901E+03, 5.5155E+03, 5.5410E+03, 5.5665E+03, 5.5921E+03, 5.6178E+03, 5.6436E+03, 5.6694E+03, 5.6953E+03, 5.7214E+03, &
       5.7474E+03, 5.7736E+03, 5.7999E+03, 5.8262E+03, 5.8526E+03, 5.8791E+03, 5.9057E+03, 5.9324E+03, 5.9591E+03, 5.9860E+03, &
       6.0129E+03, 6.0399E+03, 6.0670E+03, 6.0941E+03, 6.1214E+03, 6.1487E+03, 6.1761E+03, 6.2036E+03, 6.2312E+03, 6.2589E+03, &
       6.2867E+03, 6.3145E+03, 6.3424E+03, 6.3705E+03, 6.3986E+03, 6.4267E+03, 6.4550E+03, 6.4834E+03, 6.5118E+03, 6.5404E+03, &
       6.5690E+03, 6.5977E+03, 6.6265E+03, 6.6554E+03, 6.6844E+03, 6.7135E+03, 6.7426E+03, 6.7719E+03, 6.8012E+03, 6.8307E+03, &
       6.8602E+03, 6.8898E+03, 6.9195E+03, 6.9493E+03, 6.9792E+03, 7.0091E+03, 7.0392E+03, 7.0694E+03, 7.0996E+03, 7.1299E+03, &
       7.1604E+03, 7.1909E+03, 7.2215E+03, 7.2522E+03, 7.2831E+03, 7.3140E+03, 7.3449E+03, 7.3760E+03, 7.4072E+03, 7.4385E+03, &
       7.4699E+03, 7.5013E+03, 7.5329E+03, 7.5646E+03, 7.5963E+03, 7.6282E+03, 7.6601E+03, 7.6922E+03, 7.7243E+03, 7.7565E+03, &
       7.7889E+03, 7.8213E+03, 7.8538E+03, 7.8865E+03, 7.9192E+03, 7.9520E+03, 7.9850E+03, 8.0180E+03, 8.0511E+03, 8.0843E+03, &
       8.1177E+03, 8.1511E+03, 8.1846E+03, 8.2182E+03, 8.2520E+03, 8.2858E+03, 8.3197E+03, 8.3538E+03, 8.3879E+03, 8.4221E+03, &
       8.4565E+03, 8.4909E+03, 8.5255E+03, 8.5601E+03, 8.5948E+03, 8.6297E+03, 8.6647E+03, 8.6997E+03, 8.7349E+03, 8.7702E+03, &
       8.8055E+03, 8.8410E+03, 8.8766E+03, 8.9123E+03, 8.9481E+03, 8.9840E+03, 9.0200E+03, 9.0562E+03, 9.0924E+03, 9.1287E+03, &
       9.1652E+03, 9.2017E+03, 9.2384E+03, 9.2751E+03, 9.3120E+03, 9.3490E+03, 9.3861E+03, 9.4233E+03, 9.4606E+03, 9.4980E+03, &
       9.5356E+03, 9.5732E+03, 9.6110E+03, 9.6488E+03, 9.6868E+03, 9.7249E+03, 9.7631E+03, 9.8014E+03, 9.8399E+03, 9.8784E+03, &
       9.9170E+03, 9.9558E+03, 9.9947E+03, 1.0034E+04, 1.0073E+04, 1.0112E+04, 1.0151E+04, 1.0191E+04, 1.0230E+04, 1.0270E+04, &
       1.0310E+04, 1.0350E+04, 1.0390E+04, 1.0430E+04, 1.0470E+04, 1.0511E+04, 1.0551E+04, 1.0592E+04, 1.0632E+04, 1.0673E+04, &
       1.0714E+04, 1.0755E+04, 1.0797E+04, 1.0838E+04, 1.0879E+04, 1.0921E+04, 1.0963E+04, 1.1004E+04, 1.1046E+04, 1.1088E+04, &
       1.1131E+04, 1.1173E+04, 1.1215E+04, 1.1258E+04, 1.1301E+04, 1.1343E+04, 1.1386E+04, 1.1429E+04, 1.1472E+04, 1.1516E+04, &
       1.1559E+04, 1.1603E+04, 1.1646E+04, 1.1690E+04, 1.1734E+04, 1.1778E+04, 1.1822E+04, 1.1866E+04, 1.1911E+04, 1.1955E+04, &
       1.2000E+04, 1.2045E+04, 1.2090E+04, 1.2135E+04, 1.2180E+04, 1.2225E+04, 1.2271E+04, 1.2316E+04, 1.2362E+04, 1.2408E+04, &
       1.2454E+04, 1.2500E+04, 1.2546E+04, 1.2592E+04, 1.2639E+04, 1.2685E+04, 1.2732E+04, 1.2779E+04, 1.2826E+04, 1.2873E+04, &
       1.2921E+04, 1.2968E+04, 1.3015E+04, 1.3063E+04, 1.3111E+04, 1.3159E+04, 1.3207E+04, 1.3255E+04, 1.3304E+04, 1.3352E+04, &
       1.3401E+04, 1.3449E+04, 1.3498E+04, 1.3547E+04, 1.3596E+04, 1.3646E+04, 1.3695E+04, 1.3745E+04, 1.3795E+04, 1.3844E+04, &
       1.3894E+04, 1.3945E+04, 1.3995E+04, 1.4045E+04, 1.4096E+04, 1.4146E+04, 1.4197E+04, 1.4248E+04, 1.4299E+04, 1.4351E+04, &
       1.4402E+04, 1.4454E+04, 1.4505E+04, 1.4557E+04, 1.4609E+04, 1.4661E+04, 1.4714E+04, 1.4766E+04, 1.4819E+04, 1.4871E+04, &
       1.4924E+04, 1.4977E+04, 1.5030E+04, 1.5084E+04, 1.5137E+04, 1.5191E+04, 1.5244E+04, 1.5298E+04, 1.5352E+04, 1.5406E+04, &
       1.5461E+04, 1.5515E+04, 1.5570E+04, 1.5625E+04, 1.5679E+04, 1.5735E+04, 1.5790E+04, 1.5845E+04, 1.5901E+04, 1.5956E+04, &
       1.6012E+04, 1.6068E+04, 1.6124E+04, 1.6181E+04, 1.6237E+04, 1.6294E+04, 1.6350E+04, 1.6407E+04, 1.6464E+04, 1.6522E+04, &
       1.6579E+04, 1.6636E+04, 1.6694E+04, 1.6752E+04, 1.6810E+04, 1.6868E+04, 1.6926E+04, 1.6985E+04, 1.7043E+04, 1.7102E+04, &
       1.7161E+04, 1.7220E+04, 1.7280E+04, 1.7339E+04, 1.7399E+04, 1.7458E+04, 1.7518E+04, 1.7578E+04, 1.7638E+04, 1.7699E+04, &
       1.7759E+04, 1.7820E+04, 1.7881E+04, 1.7942E+04, 1.8003E+04, 1.8065E+04, 1.8126E+04, 1.8188E+04, 1.8250E+04, 1.8312E+04, &
       1.8374E+04, 1.8436E+04, 1.8499E+04, 1.8561E+04, 1.8624E+04, 1.8687E+04, 1.8750E+04, 1.8814E+04, 1.8877E+04, 1.8941E+04, &
       1.9005E+04, 1.9069E+04, 1.9133E+04, 1.9197E+04, 1.9262E+04, 1.9327E+04, 1.9392E+04, 1.9457E+04, 1.9522E+04, 1.9587E+04, &
       1.9653E+04, 1.9719E+04, 1.9784E+04, 1.9851E+04, 1.9917E+04, 1.9983E+04, 2.0050E+04, 2.0117E+04, 2.0184E+04, 2.0251E+04, &
       2.0318E+04, 2.0386E+04, 2.0453E+04, 2.0521E+04, 2.0589E+04, 2.0657E+04, 2.0726E+04, 2.0794E+04, 2.0863E+04, 2.0932E+04, &
       2.1001E+04, 2.1070E+04, 2.1140E+04, 2.1209E+04, 2.1279E+04, 2.1349E+04, 2.1419E+04, 2.1490E+04, 2.1560E+04, 2.1631E+04, &
       2.1702E+04, 2.1773E+04, 2.1844E+04, 2.1916E+04, 2.1987E+04, 2.2059E+04, 2.2131E+04, 2.2203E+04, 2.2276E+04, 2.2348E+04, &
       2.2421E+04, 2.2494E+04, 2.2567E+04, 2.2640E+04, 2.2714E+04, 2.2788E+04, 2.2862E+04, 2.2936E+04, 2.3010E+04, 2.3084E+04, &
       2.3159E+04, 2.3234E+04, 2.3309E+04, 2.3384E+04, 2.3460E+04, 2.3535E+04, 2.3611E+04, 2.3687E+04, 2.3763E+04, 2.3840E+04, &
       2.3916E+04, 2.3993E+04, 2.4070E+04, 2.4147E+04, 2.4224E+04, 2.4302E+04, 2.4380E+04, 2.4458E+04, 2.4536E+04, 2.4614E+04, &
       2.4693E+04, 2.4771E+04, 2.4850E+04, 2.4930E+04, 2.5009E+04, 2.5088E+04, 2.5168E+04, 2.5248E+04, 2.5328E+04, 2.5409E+04, &
       2.5489E+04, 2.5570E+04, 2.5651E+04, 2.5732E+04, 2.5813E+04, 2.5895E+04, 2.5977E+04, 2.6059E+04, 2.6141E+04, 2.6223E+04, &
       2.6306E+04, 2.6389E+04, 2.6472E+04, 2.6555E+04, 2.6638E+04, 2.6722E+04, 2.6806E+04, 2.6890E+04, 2.6974E+04, 2.7059E+04, &
       2.7143E+04, 2.7228E+04, 2.7313E+04, 2.7399E+04, 2.7484E+04, 2.7570E+04, 2.7656E+04, 2.7742E+04, 2.7829E+04, 2.7915E+04, &
       2.8002E+04, 2.8089E+04, 2.8176E+04, 2.8264E+04, 2.8351E+04, 2.8439E+04, 2.8527E+04, 2.8616E+04, 2.8704E+04, 2.8793E+04, &
       2.8882E+04, 2.8971E+04, 2.9061E+04, 2.9150E+04, 2.9240E+04, 2.9330E+04, 2.9420E+04, 2.9511E+04, 2.9602E+04, 2.9693E+04, &
       2.9784E+04, 2.9875E+04, 2.9967E+04, 3.0059E+04, 3.0151E+04, 3.0243E+04, 3.0336E+04, 3.0428E+04, 3.0521E+04, 3.0615E+04, &
       3.0708E+04, 3.0802E+04, 3.0896E+04, 3.0990E+04, 3.1084E+04, 3.1179E+04, 3.1273E+04, 3.1368E+04, 3.1464E+04, 3.1559E+04, &
       3.1655E+04, 3.1751E+04, 3.1847E+04, 3.1943E+04, 3.2040E+04, 3.2137E+04, 3.2234E+04, 3.2332E+04, 3.2429E+04, 3.2527E+04, &
       3.2625E+04, 3.2723E+04, 3.2822E+04, 3.2921E+04, 3.3020E+04, 3.3119E+04, 3.3218E+04, 3.3318E+04, 3.3418E+04, 3.3518E+04, &
       3.3619E+04, 3.3719E+04, 3.3820E+04, 3.3921E+04, 3.4023E+04, 3.4124E+04, 3.4226E+04, 3.4328E+04, 3.4431E+04, 3.4533E+04, &
       3.4636E+04, 3.4739E+04, 3.4843E+04, 3.4946E+04, 3.5050E+04, 3.5154E+04, 3.5259E+04, 3.5363E+04, 3.5468E+04, 3.5573E+04, &
       3.5678E+04, 3.5784E+04, 3.5890E+04, 3.5996E+04, 3.6102E+04, 3.6209E+04, 3.6316E+04, 3.6423E+04, 3.6530E+04, 3.6638E+04, &
       3.6745E+04, 3.6854E+04, 3.6962E+04, 3.7070E+04, 3.7179E+04, 3.7288E+04, 3.7398E+04, 3.7507E+04, 3.7617E+04, 3.7727E+04, &
       3.7838E+04, 3.7949E+04, 3.8059E+04, 3.8171E+04, 3.8282E+04, 3.8394E+04, 3.8506E+04, 3.8618E+04, 3.8730E+04, 3.8843E+04, &
       3.8956E+04, 3.9069E+04, 3.9183E+04, 3.9297E+04, 3.9411E+04, 3.9525E+04, 3.9640E+04, 3.9754E+04, 3.9870E+04, 3.9985E+04, &
       4.0101E+04, 4.0217E+04, 4.0333E+04, 4.0449E+04, 4.0566E+04, 4.0683E+04, 4.0800E+04, 4.0918E+04, 4.1035E+04, 4.1154E+04, &
       4.1272E+04, 4.1390E+04, 4.1509E+04, 4.1629E+04, 4.1748E+04, 4.1868E+04, 4.1988E+04, 4.2108E+04, 4.2228E+04, 4.2349E+04, &
       4.2470E+04, 4.2592E+04, 4.2713E+04, 4.2835E+04, 4.2957E+04, 4.3080E+04, 4.3203E+04, 4.3326E+04, 4.3449E+04, 4.3573E+04, &
       4.3697E+04, 4.3821E+04, 4.3945E+04, 4.4070E+04, 4.4195E+04, 4.4320E+04, 4.4446E+04, 4.4572E+04, 4.4698E+04, 4.4824E+04, &
       4.4951E+04, 4.5078E+04, 4.5205E+04, 4.5333E+04, 4.5461E+04, 4.5589E+04, 4.5717E+04, 4.5846E+04, 4.5975E+04, 4.6104E+04, &
       4.6234E+04, 4.6364E+04, 4.6494E+04, 4.6625E+04, 4.6755E+04, 4.6886E+04, 4.7018E+04, 4.7150E+04, 4.7281E+04, 4.7414E+04, &
       4.7546E+04, 4.7679E+04, 4.7812E+04, 4.7946E+04, 4.8079E+04, 4.8214E+04, 4.8348E+04, 4.8482E+04, 4.8617E+04, 4.8753E+04, &
       4.8888E+04, 4.9024E+04, 4.9160E+04, 4.9297E+04, 4.9433E+04, 4.9570E+04, 4.9708E+04, 4.9846E+04, 4.9984E+04, 5.0122E+04, &
       5.0260E+04, 5.0399E+04, 5.0538E+04, 5.0678E+04, 5.0818E+04, 5.0958E+04, 5.1098E+04, 5.1239E+04, 5.1380E+04, 5.1522E+04, &
       5.1663E+04, 5.1805E+04, 5.1948E+04, 5.2090E+04, 5.2233E+04, 5.2376E+04, 5.2520E+04, 5.2664E+04, 5.2808E+04, 5.2952E+04, &
       5.3097E+04, 5.3242E+04, 5.3388E+04, 5.3534E+04, 5.3680E+04, 5.3826E+04, 5.3973E+04, 5.4120E+04, 5.4267E+04, 5.4415E+04, &
       5.4563E+04, 5.4712E+04, 5.4860E+04, 5.5009E+04, 5.5159E+04, 5.5308E+04, 5.5458E+04, 5.5608E+04, 5.5759E+04, 5.5910E+04, &
       5.6061E+04, 5.6213E+04, 5.6365E+04, 5.6517E+04, 5.6670E+04, 5.6823E+04, 5.6976E+04, 5.7129E+04, 5.7283E+04, 5.7438E+04, &
       5.7592E+04, 5.7747E+04, 5.7902E+04, 5.8058E+04, 5.8214E+04, 5.8370E+04, 5.8527E+04, 5.8684E+04, 5.8841E+04, 5.8999E+04, &
       5.9157E+04, 5.9315E+04, 5.9474E+04, 5.9632E+04, 5.9792E+04, 5.9951E+04, 6.0111E+04, 6.0272E+04, 6.0432E+04, 6.0594E+04, &
       6.0755E+04, 6.0917E+04, 6.1079E+04, 6.1241E+04, 6.1404E+04, 6.1567E+04, 6.1730E+04, 6.1894E+04, 6.2058E+04, 6.2223E+04, &
       6.2388E+04, 6.2553E+04, 6.2718E+04, 6.2884E+04, 6.3050E+04, 6.3217E+04, 6.3384E+04, 6.3551E+04, 6.3719E+04, 6.3887E+04, &
       6.4055E+04, 6.4224E+04, 6.4393E+04, 6.4563E+04, 6.4732E+04, 6.4903E+04, 6.5073E+04, 6.5244E+04, 6.5415E+04, 6.5587E+04, &
       6.5759E+04, 6.5931E+04, 6.6104E+04, 6.6277E+04, 6.6450E+04, 6.6624E+04, 6.6798E+04, 6.6973E+04, 6.7148E+04, 6.7323E+04, &
       6.7498E+04, 6.7674E+04, 6.7851E+04, 6.8027E+04, 6.8204E+04, 6.8382E+04, 6.8560E+04, 6.8738E+04, 6.8916E+04, 6.9095E+04, &
       6.9275E+04, 6.9454E+04, 6.9634E+04, 6.9815E+04, 6.9996E+04, 7.0177E+04, 7.0358E+04, 7.0540E+04, 7.0723E+04, 7.0905E+04, &
       7.1088E+04, 7.1272E+04, 7.1456E+04, 7.1640E+04, 7.1825E+04, 7.2010E+04, 7.2195E+04, 7.2381E+04, 7.2567E+04, 7.2753E+04, &
       7.2940E+04, 7.3127E+04, 7.3315E+04, 7.3503E+04, 7.3692E+04, 7.3880E+04, 7.4070E+04, 7.4259E+04, 7.4449E+04, 7.4640E+04, &
       7.4830E+04, 7.5021E+04, 7.5213E+04, 7.5405E+04, 7.5597E+04, 7.5790E+04, 7.5983E+04, 7.6177E+04, 7.6371E+04, 7.6565E+04, &
       7.6760E+04, 7.6955E+04, 7.7150E+04, 7.7346E+04, 7.7543E+04, 7.7739E+04, 7.7936E+04, 7.8134E+04, 7.8332E+04, 7.8530E+04, &
       7.8729E+04, 7.8928E+04, 7.9128E+04, 7.9327E+04, 7.9528E+04, 7.9729E+04, 7.9930E+04, 8.0131E+04, 8.0333E+04, 8.0536E+04, &
       8.0738E+04, 8.0942E+04, 8.1145E+04, 8.1349E+04, 8.1554E+04, 8.1759E+04, 8.1964E+04, 8.2169E+04, 8.2376E+04, 8.2582E+04, &
       8.2789E+04, 8.2996E+04, 8.3204E+04, 8.3412E+04, 8.3621E+04, 8.3830E+04, 8.4039E+04, 8.4249E+04, 8.4459E+04, 8.4670E+04, &
       8.4881E+04, 8.5093E+04, 8.5305E+04, 8.5517E+04, 8.5730E+04, 8.5943E+04, 8.6157E+04, 8.6371E+04, 8.6585E+04, 8.6800E+04, &
       8.7016E+04, 8.7231E+04, 8.7448E+04, 8.7664E+04, 8.7881E+04, 8.8099E+04, 8.8317E+04, 8.8535E+04, 8.8754E+04, 8.8973E+04, &
       8.9193E+04, 8.9413E+04, 8.9634E+04, 8.9855E+04, 9.0076E+04, 9.0298E+04, 9.0520E+04, 9.0743E+04, 9.0966E+04, 9.1190E+04, &
       9.1414E+04, 9.1639E+04, 9.1864E+04, 9.2089E+04, 9.2315E+04, 9.2541E+04, 9.2768E+04, 9.2995E+04, 9.3223E+04, 9.3451E+04, &
       9.3679E+04, 9.3908E+04, 9.4138E+04, 9.4368E+04, 9.4598E+04, 9.4829E+04, 9.5060E+04, 9.5292E+04, 9.5524E+04, 9.5757E+04, &
       9.5990E+04, 9.6223E+04, 9.6457E+04, 9.6692E+04, 9.6926E+04, 9.7162E+04, 9.7398E+04, 9.7634E+04, 9.7871E+04, 9.8108E+04, &
       9.8345E+04, 9.8584E+04, 9.8822E+04, 9.9061E+04, 9.9301E+04, 9.9541E+04, 9.9781E+04, 1.0002E+05, 1.0026E+05, 1.0051E+05, &
       1.0075E+05, 1.0099E+05, 1.0123E+05, 1.0148E+05, 1.0172E+05, 1.0197E+05, 1.0221E+05, 1.0246E+05, 1.0270E+05, 1.0295E+05, &
       1.0320E+05, 1.0344E+05, 1.0369E+05, 1.0394E+05, 1.0419E+05, 1.0444E+05, 1.0469E+05, 1.0494E+05, 1.0519E+05, 1.0544E+05, &
       1.0569E+05, 1.0595E+05, 1.0620E+05, 1.0645E+05, 1.0671E+05, 1.0696E+05, 1.0721E+05, 1.0747E+05, 1.0773E+05, 1.0798E+05, &
       1.0824E+05, 1.0850E+05, 1.0875E+05, 1.0901E+05, 1.0927E+05, 1.0953E+05, 1.0979E+05, 1.1005E+05, 1.1031E+05, 1.1057E+05, &
       1.1083E+05, 1.1109E+05, 1.1136E+05, 1.1162E+05, 1.1188E+05, 1.1215E+05, 1.1241E+05, 1.1268E+05, 1.1294E+05, 1.1321E+05, &
       1.1348E+05, 1.1374E+05, 1.1401E+05, 1.1428E+05, 1.1455E+05, 1.1482E+05, 1.1509E+05, 1.1536E+05, 1.1563E+05, 1.1590E+05, &
       1.1617E+05, 1.1644E+05, 1.1672E+05, 1.1699E+05, 1.1726E+05, 1.1754E+05, 1.1781E+05, 1.1809E+05, 1.1836E+05, 1.1864E+05, &
       1.1892E+05, 1.1919E+05, 1.1947E+05, 1.1975E+05, 1.2003E+05, 1.2031E+05, 1.2059E+05, 1.2087E+05, 1.2115E+05, 1.2143E+05, &
       1.2171E+05, 1.2200E+05, 1.2228E+05, 1.2256E+05, 1.2285E+05, 1.2313E+05, 1.2342E+05, 1.2370E+05, 1.2399E+05, 1.2428E+05, &
       1.2456E+05, 1.2485E+05, 1.2514E+05, 1.2543E+05, 1.2572E+05, 1.2601E+05, 1.2630E+05, 1.2659E+05, 1.2688E+05, 1.2718E+05, &
       1.2747E+05, 1.2776E+05, 1.2806E+05, 1.2835E+05, 1.2865E+05, 1.2894E+05, 1.2924E+05, 1.2953E+05, 1.2983E+05, 1.3013E+05, &
       1.3043E+05, 1.3073E+05, 1.3102E+05, 1.3132E+05, 1.3162E+05, 1.3193E+05, 1.3223E+05, 1.3253E+05, 1.3283E+05, 1.3314E+05, &
       1.3344E+05, 1.3374E+05, 1.3405E+05, 1.3435E+05, 1.3466E+05, 1.3497E+05, 1.3527E+05, 1.3558E+05, 1.3589E+05, 1.3620E+05, &
       1.3651E+05, 1.3682E+05, 1.3713E+05, 1.3744E+05, 1.3775E+05, 1.3806E+05, 1.3838E+05, 1.3869E+05, 1.3900E+05, 1.3932E+05, &
       1.3963E+05, 1.3995E+05, 1.4027E+05, 1.4058E+05, 1.4090E+05, 1.4122E+05, 1.4154E+05, 1.4186E+05, 1.4218E+05, 1.4250E+05, &
       1.4282E+05, 1.4314E+05, 1.4346E+05, 1.4378E+05, 1.4411E+05, 1.4443E+05, 1.4475E+05, 1.4508E+05, 1.4540E+05, 1.4573E+05, &
       1.4606E+05, 1.4638E+05, 1.4671E+05, 1.4704E+05, 1.4737E+05, 1.4770E+05, 1.4803E+05, 1.4836E+05, 1.4869E+05, 1.4902E+05, &
       1.4936E+05, 1.4969E+05, 1.5002E+05, 1.5036E+05, 1.5069E+05, 1.5103E+05, 1.5137E+05, 1.5170E+05, 1.5204E+05, 1.5238E+05, &
       1.5272E+05, 1.5306E+05, 1.5340E+05, 1.5374E+05, 1.5408E+05, 1.5442E+05, 1.5476E+05, 1.5510E+05, 1.5545E+05, 1.5579E+05, &
       1.5614E+05, 1.5648E+05, 1.5683E+05, 1.5717E+05, 1.5752E+05, 1.5787E+05, 1.5822E+05, 1.5857E+05, 1.5892E+05, 1.5927E+05, &
       1.5962E+05, 1.5997E+05, 1.6032E+05, 1.6067E+05, 1.6103E+05, 1.6138E+05, 1.6174E+05, 1.6209E+05, 1.6245E+05, 1.6280E+05, &
       1.6316E+05, 1.6352E+05, 1.6388E+05, 1.6424E+05, 1.6460E+05, 1.6496E+05, 1.6532E+05, 1.6568E+05, 1.6604E+05, 1.6641E+05, &
       1.6677E+05, 1.6713E+05, 1.6750E+05, 1.6786E+05, 1.6823E+05, 1.6860E+05, 1.6896E+05, 1.6933E+05, 1.6970E+05, 1.7007E+05, &
       1.7044E+05, 1.7081E+05, 1.7118E+05, 1.7155E+05, 1.7193E+05, 1.7230E+05, 1.7267E+05, 1.7305E+05, 1.7342E+05, 1.7380E+05, &
       1.7417E+05, 1.7455E+05, 1.7493E+05, 1.7531E+05, 1.7569E+05, 1.7607E+05, 1.7645E+05, 1.7683E+05, 1.7721E+05, 1.7759E+05, &
       1.7798E+05, 1.7836E+05, 1.7874E+05, 1.7913E+05, 1.7952E+05, 1.7990E+05, 1.8029E+05, 1.8068E+05, 1.8106E+05, 1.8145E+05, &
       1.8184E+05, 1.8223E+05, 1.8263E+05, 1.8302E+05, 1.8341E+05, 1.8380E+05, 1.8420E+05, 1.8459E+05, 1.8499E+05, 1.8538E+05, &
       1.8578E+05, 1.8618E+05, 1.8657E+05, 1.8697E+05, 1.8737E+05, 1.8777E+05, 1.8817E+05, 1.8857E+05, 1.8898E+05, 1.8938E+05, &
       1.8978E+05, 1.9019E+05, 1.9059E+05, 1.9100E+05, 1.9140E+05, 1.9181E+05, 1.9222E+05, 1.9263E+05, 1.9303E+05, 1.9344E+05, &
       1.9385E+05, 1.9427E+05, 1.9468E+05, 1.9509E+05, 1.9550E+05, 1.9592E+05, 1.9633E+05, 1.9675E+05, 1.9716E+05, 1.9758E+05, &
       1.9800E+05, 1.9842E+05, 1.9883E+05, 1.9925E+05, 1.9967E+05, 2.0010E+05, 2.0052E+05, 2.0094E+05, 2.0136E+05, 2.0179E+05, &
       2.0221E+05, 2.0264E+05, 2.0306E+05, 2.0349E+05, 2.0392E+05, 2.0434E+05, 2.0477E+05, 2.0520E+05, 2.0563E+05, 2.0606E+05, &
       2.0650E+05, 2.0693E+05, 2.0736E+05, 2.0780E+05, 2.0823E+05, 2.0867E+05, 2.0910E+05, 2.0954E+05, 2.0998E+05, 2.1042E+05, &
       2.1085E+05, 2.1129E+05, 2.1174E+05, 2.1218E+05, 2.1262E+05, 2.1306E+05, 2.1351E+05, 2.1395E+05, 2.1439E+05, 2.1484E+05, &
       2.1529E+05, 2.1573E+05, 2.1618E+05, 2.1663E+05, 2.1708E+05, 2.1753E+05, 2.1798E+05, 2.1843E+05, 2.1889E+05, 2.1934E+05, &
       2.1979E+05, 2.2025E+05, 2.2070E+05, 2.2116E+05, 2.2162E+05, 2.2208E+05, 2.2253E+05, 2.2299E+05, 2.2345E+05, 2.2391E+05, &
       2.2438E+05, 2.2484E+05, 2.2530E+05, 2.2577E+05, 2.2623E+05, 2.2670E+05, 2.2716E+05, 2.2763E+05, 2.2810E+05, 2.2857E+05, &
       2.2904E+05, 2.2951E+05, 2.2998E+05, 2.3045E+05, 2.3092E+05, 2.3139E+05, 2.3187E+05, 2.3234E+05, 2.3282E+05, 2.3330E+05, &
       2.3377E+05, 2.3425E+05, 2.3473E+05, 2.3521E+05, 2.3569E+05, 2.3617E+05, 2.3665E+05, 2.3714E+05, 2.3762E+05, 2.3810E+05, &
       2.3859E+05, 2.3907E+05, 2.3956E+05, 2.4005E+05, 2.4054E+05, 2.4103E+05, 2.4152E+05, 2.4201E+05, 2.4250E+05, 2.4299E+05, &
       2.4348E+05, 2.4398E+05, 2.4447E+05, 2.4497E+05, 2.4546E+05, 2.4596E+05, 2.4646E+05, 2.4696E+05, 2.4746E+05, 2.4796E+05, &
       2.4846E+05, 2.4896E+05, 2.4946E+05, 2.4997E+05, 2.5047E+05, 2.5098E+05, 2.5148E+05, 2.5199E+05, 2.5250E+05, 2.5301E+05, &
       2.5352E+05, 2.5403E+05, 2.5454E+05, 2.5505E+05, 2.5556E+05, 2.5607E+05, 2.5659E+05, 2.5710E+05, 2.5762E+05, 2.5814E+05, &
       2.5865E+05, 2.5917E+05, 2.5969E+05, 2.6021E+05, 2.6073E+05, 2.6126E+05, 2.6178E+05, 2.6230E+05, 2.6283E+05, 2.6335E+05, &
       2.6388E+05, 2.6441E+05, 2.6493E+05, 2.6546E+05, 2.6599E+05, 2.6652E+05, 2.6705E+05, 2.6758E+05, 2.6812E+05, 2.6865E+05, &
       2.6919E+05, 2.6972E+05, 2.7026E+05, 2.7079E+05, 2.7133E+05, 2.7187E+05, 2.7241E+05, 2.7295E+05, 2.7349E+05, 2.7404E+05, &
       2.7458E+05, 2.7512E+05, 2.7567E+05, 2.7621E+05, 2.7676E+05, 2.7731E+05, 2.7786E+05, 2.7841E+05, 2.7896E+05, 2.7951E+05, &
       2.8006E+05, 2.8061E+05, 2.8117E+05, 2.8172E+05, 2.8228E+05, 2.8283E+05, 2.8339E+05, 2.8395E+05, 2.8451E+05, 2.8507E+05, &
       2.8563E+05, 2.8619E+05, 2.8675E+05, 2.8731E+05, 2.8788E+05, 2.8844E+05, 2.8901E+05, 2.8958E+05, 2.9014E+05, 2.9071E+05, &
       2.9128E+05, 2.9185E+05, 2.9243E+05, 2.9300E+05, 2.9357E+05, 2.9415E+05, 2.9472E+05, 2.9530E+05, 2.9587E+05, 2.9645E+05, &
       2.9703E+05, 2.9761E+05, 2.9819E+05, 2.9877E+05, 2.9935E+05, 2.9994E+05, 3.0052E+05, 3.0111E+05, 3.0169E+05, 3.0228E+05, &
       3.0287E+05, 3.0346E+05, 3.0405E+05, 3.0464E+05, 3.0523E+05, 3.0582E+05, 3.0641E+05, 3.0701E+05, 3.0760E+05, 3.0820E+05, &
       3.0880E+05, 3.0939E+05, 3.0999E+05, 3.1059E+05, 3.1119E+05, 3.1180E+05, 3.1240E+05, 3.1300E+05, 3.1361E+05, 3.1421E+05, &
       3.1482E+05, 3.1543E+05, 3.1603E+05, 3.1664E+05, 3.1725E+05, 3.1786E+05, 3.1848E+05, 3.1909E+05, 3.1970E+05, 3.2032E+05, &
       3.2093E+05, 3.2155E+05, 3.2217E+05, 3.2279E+05, 3.2341E+05, 3.2403E+05, 3.2465E+05, 3.2527E+05, 3.2590E+05, 3.2652E+05, &
       3.2715E+05, 3.2777E+05, 3.2840E+05, 3.2903E+05, 3.2966E+05, 3.3029E+05, 3.3092E+05, 3.3155E+05, 3.3218E+05, 3.3282E+05, &
       3.3345E+05, 3.3409E+05, 3.3473E+05, 3.3537E+05, 3.3600E+05, 3.3664E+05, 3.3729E+05, 3.3793E+05, 3.3857E+05, 3.3921E+05, &
       3.3986E+05, 3.4051E+05, 3.4115E+05, 3.4180E+05, 3.4245E+05, 3.4310E+05, 3.4375E+05, 3.4440E+05, 3.4506E+05, 3.4571E+05, &
       3.4636E+05, 3.4702E+05, 3.4768E+05, 3.4833E+05, 3.4899E+05, 3.4965E+05, 3.5031E+05, 3.5098E+05, 3.5164E+05, 3.5230E+05, &
       3.5297E+05, 3.5363E+05, 3.5430E+05, 3.5497E+05, 3.5564E+05, 3.5631E+05, 3.5698E+05, 3.5765E+05, 3.5832E+05, 3.5900E+05, &
       3.5967E+05, 3.6035E+05, 3.6103E+05, 3.6170E+05, 3.6238E+05, 3.6306E+05, 3.6374E+05, 3.6443E+05, 3.6511E+05, 3.6579E+05, &
       3.6648E+05, 3.6717E+05, 3.6785E+05, 3.6854E+05, 3.6923E+05, 3.6992E+05, 3.7061E+05, 3.7130E+05, 3.7200E+05, 3.7269E+05, &
       3.7339E+05, 3.7409E+05, 3.7478E+05, 3.7548E+05, 3.7618E+05, 3.7688E+05, 3.7758E+05, 3.7829E+05, 3.7899E+05, 3.7970E+05, &
       3.8040E+05, 3.8111E+05, 3.8182E+05, 3.8253E+05, 3.8324E+05, 3.8395E+05, 3.8466E+05, 3.8538E+05, 3.8609E+05, 3.8681E+05, &
       3.8752E+05, 3.8824E+05, 3.8896E+05, 3.8968E+05, 3.9040E+05, 3.9112E+05, 3.9185E+05, 3.9257E+05, 3.9329E+05, 3.9402E+05, &
       3.9475E+05, 3.9548E+05, 3.9621E+05, 3.9694E+05, 3.9767E+05, 3.9840E+05, 3.9914E+05, 3.9987E+05, 4.0061E+05, 4.0134E+05, &
       4.0208E+05, 4.0282E+05, 4.0356E+05, 4.0430E+05, 4.0505E+05, 4.0579E+05, 4.0654E+05, 4.0728E+05, 4.0803E+05, 4.0878E+05, &
       4.0953E+05, 4.1028E+05, 4.1103E+05, 4.1178E+05, 4.1253E+05, 4.1329E+05, 4.1405E+05, 4.1480E+05, 4.1556E+05, 4.1632E+05, &
       4.1708E+05, 4.1784E+05, 4.1860E+05, 4.1937E+05, 4.2013E+05, 4.2090E+05, 4.2167E+05, 4.2243E+05, 4.2320E+05, 4.2397E+05, &
       4.2474E+05, 4.2552E+05, 4.2629E+05, 4.2707E+05, 4.2784E+05, 4.2862E+05, 4.2940E+05, 4.3018E+05, 4.3096E+05, 4.3174E+05, &
       4.3252E+05, 4.3331E+05, 4.3409E+05, 4.3488E+05, 4.3567E+05, 4.3645E+05, 4.3724E+05, 4.3803E+05, 4.3883E+05, 4.3962E+05, &
       4.4041E+05, 4.4121E+05, 4.4201E+05, 4.4280E+05, 4.4360E+05, 4.4440E+05, 4.4520E+05, 4.4601E+05, 4.4681E+05, 4.4761E+05, &
       4.4842E+05, 4.4923E+05, 4.5004E+05, 4.5085E+05, 4.5166E+05, 4.5247E+05, 4.5328E+05, 4.5409E+05, 4.5491E+05, 4.5573E+05, &
       4.5654E+05, 4.5736E+05, 4.5818E+05, 4.5900E+05, 4.5983E+05, 4.6065E+05, 4.6147E+05, 4.6230E+05, 4.6313E+05, 4.6395E+05, &
       4.6478E+05, 4.6561E+05, 4.6645E+05, 4.6728E+05, 4.6811E+05, 4.6895E+05, 4.6979E+05, 4.7062E+05, 4.7146E+05, 4.7230E+05, &
       4.7314E+05, 4.7399E+05, 4.7483E+05, 4.7567E+05, 4.7652E+05, 4.7737E+05, 4.7822E+05, 4.7907E+05, 4.7992E+05, 4.8077E+05, &
       4.8162E+05, 4.8248E+05, 4.8333E+05, 4.8419E+05, 4.8505E+05, 4.8591E+05, 4.8677E+05, 4.8763E+05, 4.8849E+05, 4.8936E+05, &
       4.9022E+05, 4.9109E+05, 4.9196E+05, 4.9283E+05, 4.9370E+05, 4.9457E+05, 4.9544E+05, 4.9632E+05, 4.9719E+05, 4.9807E+05, &
       4.9895E+05, 4.9983E+05, 5.0071E+05, 5.0159E+05, 5.0247E+05, 5.0336E+05, 5.0424E+05, 5.0513E+05, 5.0602E+05, 5.0690E+05, &
       5.0779E+05, 5.0869E+05, 5.0958E+05, 5.1047E+05, 5.1137E+05, 5.1227E+05, 5.1316E+05, 5.1406E+05, 5.1496E+05, 5.1586E+05, &
       5.1677E+05, 5.1767E+05, 5.1858E+05, 5.1948E+05, 5.2039E+05, 5.2130E+05, 5.2221E+05, 5.2312E+05, 5.2404E+05, 5.2495E+05, &
       5.2587E+05, 5.2678E+05, 5.2770E+05, 5.2862E+05, 5.2954E+05, 5.3046E+05, 5.3139E+05, 5.3231E+05, 5.3324E+05, 5.3416E+05, &
       5.3509E+05, 5.3602E+05, 5.3695E+05, 5.3789E+05, 5.3882E+05, 5.3975E+05, 5.4069E+05, 5.4163E+05, 5.4257E+05, 5.4351E+05, &
       5.4445E+05, 5.4539E+05, 5.4634E+05, 5.4728E+05, 5.4823E+05, 5.4918E+05, 5.5012E+05, 5.5108E+05, 5.5203E+05, 5.5298E+05, &
       5.5394E+05, 5.5489E+05, 5.5585E+05, 5.5681E+05, 5.5777E+05, 5.5873E+05, 5.5969E+05, 5.6065E+05, 5.6162E+05, 5.6259E+05, &
       5.6355E+05, 5.6452E+05, 5.6549E+05, 5.6646E+05, 5.6744E+05, 5.6841E+05, 5.6939E+05, 5.7036E+05, 5.7134E+05, 5.7232E+05, &
       5.7330E+05, 5.7429E+05, 5.7527E+05, 5.7626E+05, 5.7724E+05, 5.7823E+05, 5.7922E+05, 5.8021E+05, 5.8120E+05, 5.8219E+05, &
       5.8319E+05, 5.8419E+05, 5.8518E+05, 5.8618E+05, 5.8718E+05, 5.8818E+05, 5.8919E+05, 5.9019E+05, 5.9119E+05, 5.9220E+05, &
       5.9321E+05, 5.9422E+05, 5.9523E+05, 5.9624E+05, 5.9726E+05, 5.9827E+05, 5.9929E+05, 6.0031E+05, 6.0133E+05, 6.0235E+05, &
       6.0337E+05, 6.0439E+05, 6.0542E+05, 6.0644E+05, 6.0747E+05, 6.0850E+05, 6.0953E+05, 6.1056E+05, 6.1159E+05, 6.1263E+05, &
       6.1366E+05, 6.1470E+05, 6.1574E+05, 6.1678E+05, 6.1782E+05, 6.1886E+05, 6.1991E+05, 6.2095E+05, 6.2200E+05, 6.2305E+05, &
       6.2410E+05, 6.2515E+05, 6.2620E+05, 6.2726E+05, 6.2831E+05, 6.2937E+05, 6.3043E+05, 6.3149E+05, 6.3255E+05, 6.3361E+05, &
       6.3468E+05, 6.3574E+05, 6.3681E+05, 6.3788E+05, 6.3895E+05, 6.4002E+05, 6.4109E+05, 6.4216E+05, 6.4324E+05, 6.4432E+05, &
       6.4540E+05, 6.4648E+05, 6.4756E+05, 6.4864E+05, 6.4972E+05, 6.5081E+05, 6.5190E+05, 6.5298E+05, 6.5407E+05, 6.5517E+05, &
       6.5626E+05, 6.5735E+05, 6.5845E+05, 6.5955E+05, 6.6064E+05, 6.6174E+05, 6.6285E+05, 6.6395E+05, 6.6505E+05, 6.6616E+05, &
       6.6727E+05, 6.6838E+05, 6.6949E+05, 6.7060E+05, 6.7171E+05, 6.7283E+05, 6.7394E+05, 6.7506E+05, 6.7618E+05, 6.7730E+05, &
       6.7842E+05, 6.7954E+05, 6.8067E+05, 6.8180E+05, 6.8292E+05, 6.8405E+05, 6.8518E+05, 6.8632E+05, 6.8745E+05, 6.8859E+05, &
       6.8972E+05, 6.9086E+05, 6.9200E+05, 6.9314E+05, 6.9429E+05, 6.9543E+05, 6.9658E+05, 6.9772E+05, 6.9887E+05, 7.0002E+05, &
       7.0117E+05, 7.0233E+05, 7.0348E+05, 7.0464E+05, 7.0580E+05, 7.0696E+05, 7.0812E+05, 7.0928E+05, 7.1044E+05, 7.1161E+05, &
       7.1278E+05, 7.1395E+05, 7.1512E+05, 7.1629E+05, 7.1746E+05, 7.1863E+05, 7.1981E+05, 7.2099E+05, 7.2217E+05, 7.2335E+05, &
       7.2453E+05, 7.2571E+05, 7.2690E+05, 7.2809E+05, 7.2928E+05, 7.3047E+05, 7.3166E+05, 7.3285E+05, 7.3404E+05, 7.3524E+05, &
       7.3644E+05, 7.3764E+05, 7.3884E+05, 7.4004E+05, 7.4124E+05, 7.4245E+05, 7.4366E+05, 7.4487E+05, 7.4608E+05, 7.4729E+05, &
       7.4850E+05, 7.4972E+05, 7.5093E+05, 7.5215E+05, 7.5337E+05, 7.5459E+05, 7.5581E+05, 7.5704E+05, 7.5826E+05, 7.5949E+05, &
       7.6072E+05, 7.6195E+05, 7.6318E+05, 7.6442E+05, 7.6565E+05, 7.6689E+05, 7.6813E+05, 7.6937E+05, 7.7061E+05, 7.7185E+05, &
       7.7310E+05, 7.7434E+05, 7.7559E+05, 7.7684E+05, 7.7809E+05, 7.7934E+05, 7.8060E+05, 7.8185E+05, 7.8311E+05, 7.8437E+05, &
       7.8563E+05, 7.8689E+05, 7.8816E+05, 7.8942E+05, 7.9069E+05, 7.9196E+05, 7.9323E+05, 7.9450E+05, 7.9577E+05, 7.9705E+05, &
       7.9833E+05, 7.9960E+05, 8.0088E+05, 8.0217E+05, 8.0345E+05, 8.0473E+05, 8.0602E+05, 8.0731E+05, 8.0860E+05, 8.0989E+05, &
       8.1118E+05, 8.1248E+05, 8.1377E+05, 8.1507E+05, 8.1637E+05, 8.1767E+05, 8.1898E+05, 8.2028E+05, 8.2159E+05, 8.2289E+05/
      data (QofT( 7,J),J=2409,4510)/ 8.2420E+05, 8.2552E+05, 8.2683E+05, 8.2814E+05, 8.2946E+05, 8.3078E+05, 8.3210E+05, 8.3342E+05, &
       8.3474E+05, 8.3606E+05, 8.3739E+05, 8.3872E+05, 8.4005E+05, 8.4138E+05, 8.4271E+05, 8.4404E+05, 8.4538E+05, 8.4672E+05, &
       8.4806E+05, 8.4940E+05, 8.5074E+05, 8.5209E+05, 8.5343E+05, 8.5478E+05, 8.5613E+05, 8.5748E+05, 8.5883E+05, 8.6019E+05, &
       8.6154E+05, 8.6290E+05, 8.6426E+05, 8.6562E+05, 8.6698E+05, 8.6835E+05, 8.6971E+05, 8.7108E+05, 8.7245E+05, 8.7382E+05, &
       8.7520E+05, 8.7657E+05, 8.7795E+05, 8.7933E+05, 8.8071E+05, 8.8209E+05, 8.8347E+05, 8.8486E+05, 8.8624E+05, 8.8763E+05, &
       8.8902E+05, 8.9041E+05, 8.9181E+05, 8.9320E+05, 8.9460E+05, 8.9600E+05, 8.9740E+05, 8.9880E+05, 9.0020E+05, 9.0161E+05, &
       9.0302E+05, 9.0443E+05, 9.0584E+05, 9.0725E+05, 9.0866E+05, 9.1008E+05, 9.1150E+05, 9.1292E+05, 9.1434E+05, 9.1576E+05, &
       9.1719E+05, 9.1861E+05, 9.2004E+05, 9.2147E+05, 9.2290E+05, 9.2434E+05, 9.2577E+05, 9.2721E+05, 9.2865E+05, 9.3009E+05, &
       9.3153E+05, 9.3297E+05, 9.3442E+05, 9.3587E+05, 9.3732E+05, 9.3877E+05, 9.4022E+05, 9.4167E+05, 9.4313E+05, 9.4459E+05, &
       9.4605E+05, 9.4751E+05, 9.4897E+05, 9.5044E+05, 9.5191E+05, 9.5337E+05, 9.5484E+05, 9.5632E+05, 9.5779E+05, 9.5927E+05, &
       9.6074E+05, 9.6222E+05, 9.6371E+05, 9.6519E+05, 9.6667E+05, 9.6816E+05, 9.6965E+05, 9.7114E+05, 9.7263E+05, 9.7412E+05, &
       9.7562E+05, 9.7712E+05, 9.7862E+05, 9.8012E+05, 9.8162E+05, 9.8313E+05, 9.8463E+05, 9.8614E+05, 9.8765E+05, 9.8916E+05, &
       9.9068E+05, 9.9219E+05, 9.9371E+05, 9.9523E+05, 9.9675E+05, 9.9827E+05, 9.9980E+05, 1.0013E+06, 1.0029E+06, 1.0044E+06, &
       1.0059E+06, 1.0074E+06, 1.0090E+06, 1.0105E+06, 1.0121E+06, 1.0136E+06, 1.0151E+06, 1.0167E+06, 1.0182E+06, 1.0198E+06, &
       1.0213E+06, 1.0229E+06, 1.0244E+06, 1.0260E+06, 1.0276E+06, 1.0291E+06, 1.0307E+06, 1.0322E+06, 1.0338E+06, 1.0354E+06, &
       1.0369E+06, 1.0385E+06, 1.0401E+06, 1.0417E+06, 1.0432E+06, 1.0448E+06, 1.0464E+06, 1.0480E+06, 1.0496E+06, 1.0511E+06, &
       1.0527E+06, 1.0543E+06, 1.0559E+06, 1.0575E+06, 1.0591E+06, 1.0607E+06, 1.0623E+06, 1.0639E+06, 1.0655E+06, 1.0671E+06, &
       1.0687E+06, 1.0703E+06, 1.0719E+06, 1.0735E+06, 1.0752E+06, 1.0768E+06, 1.0784E+06, 1.0800E+06, 1.0816E+06, 1.0833E+06, &
       1.0849E+06, 1.0865E+06, 1.0881E+06, 1.0898E+06, 1.0914E+06, 1.0930E+06, 1.0947E+06, 1.0963E+06, 1.0979E+06, 1.0996E+06, &
       1.1012E+06, 1.1029E+06, 1.1045E+06, 1.1062E+06, 1.1078E+06, 1.1095E+06, 1.1111E+06, 1.1128E+06, 1.1145E+06, 1.1161E+06, &
       1.1178E+06, 1.1195E+06, 1.1211E+06, 1.1228E+06, 1.1245E+06, 1.1261E+06, 1.1278E+06, 1.1295E+06, 1.1312E+06, 1.1328E+06, &
       1.1345E+06, 1.1362E+06, 1.1379E+06, 1.1396E+06, 1.1413E+06, 1.1430E+06, 1.1447E+06, 1.1464E+06, 1.1481E+06, 1.1498E+06, &
       1.1515E+06, 1.1532E+06, 1.1549E+06, 1.1566E+06, 1.1583E+06, 1.1600E+06, 1.1617E+06, 1.1634E+06, 1.1652E+06, 1.1669E+06, &
       1.1686E+06, 1.1703E+06, 1.1721E+06, 1.1738E+06, 1.1755E+06, 1.1772E+06, 1.1790E+06, 1.1807E+06, 1.1825E+06, 1.1842E+06, &
       1.1859E+06, 1.1877E+06, 1.1894E+06, 1.1912E+06, 1.1929E+06, 1.1947E+06, 1.1964E+06, 1.1982E+06, 1.1999E+06, 1.2017E+06, &
       1.2035E+06, 1.2052E+06, 1.2070E+06, 1.2088E+06, 1.2105E+06, 1.2123E+06, 1.2141E+06, 1.2159E+06, 1.2176E+06, 1.2194E+06, &
       1.2212E+06, 1.2230E+06, 1.2248E+06, 1.2266E+06, 1.2284E+06, 1.2301E+06, 1.2319E+06, 1.2337E+06, 1.2355E+06, 1.2373E+06, &
       1.2391E+06, 1.2409E+06, 1.2427E+06, 1.2446E+06, 1.2464E+06, 1.2482E+06, 1.2500E+06, 1.2518E+06, 1.2536E+06, 1.2555E+06, &
       1.2573E+06, 1.2591E+06, 1.2609E+06, 1.2628E+06, 1.2646E+06, 1.2664E+06, 1.2683E+06, 1.2701E+06, 1.2719E+06, 1.2738E+06, &
       1.2756E+06, 1.2775E+06, 1.2793E+06, 1.2812E+06, 1.2830E+06, 1.2849E+06, 1.2867E+06, 1.2886E+06, 1.2904E+06, 1.2923E+06, &
       1.2942E+06, 1.2960E+06, 1.2979E+06, 1.2998E+06, 1.3016E+06, 1.3035E+06, 1.3054E+06, 1.3073E+06, 1.3092E+06, 1.3110E+06, &
       1.3129E+06, 1.3148E+06, 1.3167E+06, 1.3186E+06, 1.3205E+06, 1.3224E+06, 1.3243E+06, 1.3262E+06, 1.3281E+06, 1.3300E+06, &
       1.3319E+06, 1.3338E+06, 1.3357E+06, 1.3376E+06, 1.3395E+06, 1.3415E+06, 1.3434E+06, 1.3453E+06, 1.3472E+06, 1.3492E+06, &
       1.3511E+06, 1.3530E+06, 1.3549E+06, 1.3569E+06, 1.3588E+06, 1.3607E+06, 1.3627E+06, 1.3646E+06, 1.3666E+06, 1.3685E+06, &
       1.3705E+06, 1.3724E+06, 1.3744E+06, 1.3763E+06, 1.3783E+06, 1.3802E+06, 1.3822E+06, 1.3842E+06, 1.3861E+06, 1.3881E+06, &
       1.3901E+06, 1.3920E+06, 1.3940E+06, 1.3960E+06, 1.3980E+06, 1.4000E+06, 1.4019E+06, 1.4039E+06, 1.4059E+06, 1.4079E+06, &
       1.4099E+06, 1.4119E+06, 1.4139E+06, 1.4159E+06, 1.4179E+06, 1.4199E+06, 1.4219E+06, 1.4239E+06, 1.4259E+06, 1.4279E+06, &
       1.4299E+06, 1.4320E+06, 1.4340E+06, 1.4360E+06, 1.4380E+06, 1.4400E+06, 1.4421E+06, 1.4441E+06, 1.4461E+06, 1.4482E+06, &
       1.4502E+06, 1.4522E+06, 1.4543E+06, 1.4563E+06, 1.4584E+06, 1.4604E+06, 1.4625E+06, 1.4645E+06, 1.4666E+06, 1.4686E+06, &
       1.4707E+06, 1.4727E+06, 1.4748E+06, 1.4769E+06, 1.4789E+06, 1.4810E+06, 1.4831E+06, 1.4851E+06, 1.4872E+06, 1.4893E+06, &
       1.4914E+06, 1.4934E+06, 1.4955E+06, 1.4976E+06, 1.4997E+06, 1.5018E+06, 1.5039E+06, 1.5060E+06, 1.5081E+06, 1.5102E+06, &
       1.5123E+06, 1.5144E+06, 1.5165E+06, 1.5186E+06, 1.5207E+06, 1.5228E+06, 1.5249E+06, 1.5271E+06, 1.5292E+06, 1.5313E+06, &
       1.5334E+06, 1.5356E+06, 1.5377E+06, 1.5398E+06, 1.5420E+06, 1.5441E+06, 1.5462E+06, 1.5484E+06, 1.5505E+06, 1.5527E+06, &
       1.5548E+06, 1.5570E+06, 1.5591E+06, 1.5613E+06, 1.5634E+06, 1.5656E+06, 1.5677E+06, 1.5699E+06, 1.5721E+06, 1.5742E+06, &
       1.5764E+06, 1.5786E+06, 1.5807E+06, 1.5829E+06, 1.5851E+06, 1.5873E+06, 1.5895E+06, 1.5917E+06, 1.5938E+06, 1.5960E+06, &
       1.5982E+06, 1.6004E+06, 1.6026E+06, 1.6048E+06, 1.6070E+06, 1.6092E+06, 1.6114E+06, 1.6136E+06, 1.6159E+06, 1.6181E+06, &
       1.6203E+06, 1.6225E+06, 1.6247E+06, 1.6269E+06, 1.6292E+06, 1.6314E+06, 1.6336E+06, 1.6359E+06, 1.6381E+06, 1.6403E+06, &
       1.6426E+06, 1.6448E+06, 1.6471E+06, 1.6493E+06, 1.6515E+06, 1.6538E+06, 1.6561E+06, 1.6583E+06, 1.6606E+06, 1.6628E+06, &
       1.6651E+06, 1.6674E+06, 1.6696E+06, 1.6719E+06, 1.6742E+06, 1.6764E+06, 1.6787E+06, 1.6810E+06, 1.6833E+06, 1.6856E+06, &
       1.6878E+06, 1.6901E+06, 1.6924E+06, 1.6947E+06, 1.6970E+06, 1.6993E+06, 1.7016E+06, 1.7039E+06, 1.7062E+06, 1.7085E+06, &
       1.7108E+06, 1.7131E+06, 1.7155E+06, 1.7178E+06, 1.7201E+06, 1.7224E+06, 1.7247E+06, 1.7271E+06, 1.7294E+06, 1.7317E+06, &
       1.7341E+06, 1.7364E+06, 1.7387E+06, 1.7411E+06, 1.7434E+06, 1.7458E+06, 1.7481E+06, 1.7505E+06, 1.7528E+06, 1.7552E+06, &
       1.7575E+06, 1.7599E+06, 1.7622E+06, 1.7646E+06, 1.7670E+06, 1.7694E+06, 1.7717E+06, 1.7741E+06, 1.7765E+06, 1.7789E+06, &
       1.7812E+06, 1.7836E+06, 1.7860E+06, 1.7884E+06, 1.7908E+06, 1.7932E+06, 1.7956E+06, 1.7980E+06, 1.8004E+06, 1.8028E+06, &
       1.8052E+06, 1.8076E+06, 1.8100E+06, 1.8124E+06, 1.8148E+06, 1.8172E+06, 1.8197E+06, 1.8221E+06, 1.8245E+06, 1.8269E+06, &
       1.8294E+06, 1.8318E+06, 1.8342E+06, 1.8367E+06, 1.8391E+06, 1.8416E+06, 1.8440E+06, 1.8464E+06, 1.8489E+06, 1.8514E+06, &
       1.8538E+06, 1.8563E+06, 1.8587E+06, 1.8612E+06, 1.8636E+06, 1.8661E+06, 1.8686E+06, 1.8711E+06, 1.8735E+06, 1.8760E+06, &
       1.8785E+06, 1.8810E+06, 1.8835E+06, 1.8859E+06, 1.8884E+06, 1.8909E+06, 1.8934E+06, 1.8959E+06, 1.8984E+06, 1.9009E+06, &
       1.9034E+06, 1.9059E+06, 1.9084E+06, 1.9109E+06, 1.9135E+06, 1.9160E+06, 1.9185E+06, 1.9210E+06, 1.9235E+06, 1.9261E+06, &
       1.9286E+06, 1.9311E+06, 1.9337E+06, 1.9362E+06, 1.9387E+06, 1.9413E+06, 1.9438E+06, 1.9464E+06, 1.9489E+06, 1.9515E+06, &
       1.9540E+06, 1.9566E+06, 1.9591E+06, 1.9617E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       282
      data (QofT( 8,J),J=1,2408)/ 6.0000E+00, 6.0015E+00, 6.0289E+00, 6.1338E+00, 6.3529E+00, 6.6988E+00, 7.1686E+00, 7.7525E+00, &
       8.4392E+00, 9.2175E+00, 1.0078E+01, 1.1012E+01, 1.2012E+01, 1.3073E+01, 1.4191E+01, 1.5359E+01, 1.6576E+01, 1.7839E+01, &
       1.9144E+01, 2.0489E+01, 2.3295E+01, 2.6242E+01, 2.9322E+01, 3.2526E+01, 3.5848E+01, 3.9283E+01, 4.2825E+01, 4.6471E+01, &
       5.0218E+01, 5.4063E+01, 5.8002E+01, 6.2035E+01, 6.6157E+01, 7.0368E+01, 7.4666E+01, 7.9048E+01, 8.3514E+01, 8.8062E+01, &
       9.2689E+01, 9.7396E+01, 1.0218E+02, 1.0704E+02, 1.1198E+02, 1.1699E+02, 1.2207E+02, 1.2722E+02, 1.3245E+02, 1.3775E+02, &
       1.4311E+02, 1.4855E+02, 1.5405E+02, 1.5962E+02, 1.6525E+02, 1.7095E+02, 1.7671E+02, 1.8254E+02, 1.8843E+02, 1.9438E+02, &
       2.0040E+02, 2.0647E+02, 2.1261E+02, 2.1881E+02, 2.2507E+02, 2.3138E+02, 2.3775E+02, 2.4419E+02, 2.5068E+02, 2.5722E+02, &
       2.6382E+02, 2.7048E+02, 2.7720E+02, 2.8397E+02, 2.9079E+02, 2.9767E+02, 3.0460E+02, 3.1159E+02, 3.1863E+02, 3.2572E+02, &
       3.3286E+02, 3.4006E+02, 3.4730E+02, 3.5460E+02, 3.6195E+02, 3.6935E+02, 3.7680E+02, 3.8431E+02, 3.9186E+02, 3.9946E+02, &
       4.0710E+02, 4.1480E+02, 4.2255E+02, 4.3034E+02, 4.3819E+02, 4.4608E+02, 4.5402E+02, 4.6200E+02, 4.7003E+02, 4.7811E+02, &
       4.8624E+02, 4.9441E+02, 5.0263E+02, 5.1090E+02, 5.1921E+02, 5.2757E+02, 5.3597E+02, 5.4441E+02, 5.5291E+02, 5.6144E+02, &
       5.7003E+02, 5.7865E+02, 5.8732E+02, 5.9604E+02, 6.0480E+02, 6.1360E+02, 6.2245E+02, 6.3134E+02, 6.4028E+02, 6.4926E+02, &
       6.5828E+02, 6.6735E+02, 6.7646E+02, 6.8561E+02, 6.9481E+02, 7.0404E+02, 7.1333E+02, 7.2265E+02, 7.3202E+02, 7.4143E+02, &
       7.5088E+02, 7.6037E+02, 7.6991E+02, 7.7949E+02, 7.8911E+02, 7.9878E+02, 8.0849E+02, 8.1824E+02, 8.2803E+02, 8.3786E+02, &
       8.4774E+02, 8.5766E+02, 8.6762E+02, 8.7762E+02, 8.8767E+02, 8.9775E+02, 9.0788E+02, 9.1805E+02, 9.2827E+02, 9.3852E+02, &
       9.4882E+02, 9.5916E+02, 9.6954E+02, 9.7997E+02, 9.9043E+02, 1.0009E+03, 1.0115E+03, 1.0221E+03, 1.0327E+03, 1.0434E+03, &
       1.0541E+03, 1.0649E+03, 1.0757E+03, 1.0865E+03, 1.0974E+03, 1.1084E+03, 1.1193E+03, 1.1303E+03, 1.1414E+03, 1.1525E+03, &
       1.1637E+03, 1.1748E+03, 1.1861E+03, 1.1973E+03, 1.2087E+03, 1.2200E+03, 1.2314E+03, 1.2429E+03, 1.2544E+03, 1.2659E+03, &
       1.2775E+03, 1.2891E+03, 1.3007E+03, 1.3125E+03, 1.3242E+03, 1.3360E+03, 1.3478E+03, 1.3597E+03, 1.3716E+03, 1.3836E+03, &
       1.3956E+03, 1.4077E+03, 1.4198E+03, 1.4319E+03, 1.4441E+03, 1.4563E+03, 1.4686E+03, 1.4810E+03, 1.4933E+03, 1.5057E+03, &
       1.5182E+03, 1.5307E+03, 1.5432E+03, 1.5558E+03, 1.5685E+03, 1.5812E+03, 1.5939E+03, 1.6067E+03, 1.6195E+03, 1.6324E+03, &
       1.6453E+03, 1.6582E+03, 1.6712E+03, 1.6843E+03, 1.6974E+03, 1.7105E+03, 1.7237E+03, 1.7369E+03, 1.7502E+03, 1.7636E+03, &
       1.7769E+03, 1.7904E+03, 1.8038E+03, 1.8173E+03, 1.8309E+03, 1.8445E+03, 1.8582E+03, 1.8719E+03, 1.8857E+03, 1.8995E+03, &
       1.9133E+03, 1.9272E+03, 1.9412E+03, 1.9552E+03, 1.9692E+03, 1.9833E+03, 1.9974E+03, 2.0116E+03, 2.0259E+03, 2.0402E+03, &
       2.0545E+03, 2.0689E+03, 2.0833E+03, 2.0978E+03, 2.1124E+03, 2.1269E+03, 2.1416E+03, 2.1563E+03, 2.1710E+03, 2.1858E+03, &
       2.2006E+03, 2.2155E+03, 2.2305E+03, 2.2455E+03, 2.2605E+03, 2.2756E+03, 2.2907E+03, 2.3059E+03, 2.3212E+03, 2.3365E+03, &
       2.3518E+03, 2.3672E+03, 2.3827E+03, 2.3982E+03, 2.4138E+03, 2.4294E+03, 2.4450E+03, 2.4608E+03, 2.4765E+03, 2.4924E+03, &
       2.5082E+03, 2.5242E+03, 2.5401E+03, 2.5562E+03, 2.5723E+03, 2.5884E+03, 2.6046E+03, 2.6209E+03, 2.6372E+03, 2.6536E+03, &
       2.6700E+03, 2.6864E+03, 2.7030E+03, 2.7196E+03, 2.7362E+03, 2.7529E+03, 2.7696E+03, 2.7864E+03, 2.8033E+03, 2.8202E+03, &
       2.8372E+03, 2.8542E+03, 2.8713E+03, 2.8884E+03, 2.9056E+03, 2.9229E+03, 2.9402E+03, 2.9576E+03, 2.9750E+03, 2.9925E+03, &
       3.0100E+03, 3.0276E+03, 3.0453E+03, 3.0630E+03, 3.0808E+03, 3.0986E+03, 3.1165E+03, 3.1345E+03, 3.1525E+03, 3.1706E+03, &
       3.1887E+03, 3.2069E+03, 3.2251E+03, 3.2434E+03, 3.2618E+03, 3.2802E+03, 3.2987E+03, 3.3173E+03, 3.3359E+03, 3.3546E+03, &
       3.3733E+03, 3.3921E+03, 3.4110E+03, 3.4299E+03, 3.4488E+03, 3.4679E+03, 3.4870E+03, 3.5062E+03, 3.5254E+03, 3.5447E+03, &
       3.5640E+03, 3.5834E+03, 3.6029E+03, 3.6225E+03, 3.6421E+03, 3.6618E+03, 3.6815E+03, 3.7013E+03, 3.7211E+03, 3.7411E+03, &
       3.7611E+03, 3.7811E+03, 3.8012E+03, 3.8214E+03, 3.8417E+03, 3.8620E+03, 3.8824E+03, 3.9028E+03, 3.9234E+03, 3.9439E+03, &
       3.9646E+03, 3.9853E+03, 4.0061E+03, 4.0269E+03, 4.0478E+03, 4.0688E+03, 4.0899E+03, 4.1110E+03, 4.1322E+03, 4.1534E+03, &
       4.1748E+03, 4.1962E+03, 4.2176E+03, 4.2391E+03, 4.2607E+03, 4.2824E+03, 4.3042E+03, 4.3260E+03, 4.3478E+03, 4.3698E+03, &
       4.3918E+03, 4.4139E+03, 4.4361E+03, 4.4583E+03, 4.4806E+03, 4.5030E+03, 4.5254E+03, 4.5479E+03, 4.5705E+03, 4.5932E+03, &
       4.6159E+03, 4.6387E+03, 4.6616E+03, 4.6845E+03, 4.7076E+03, 4.7307E+03, 4.7538E+03, 4.7771E+03, 4.8004E+03, 4.8238E+03, &
       4.8472E+03, 4.8708E+03, 4.8944E+03, 4.9181E+03, 4.9419E+03, 4.9657E+03, 4.9896E+03, 5.0136E+03, 5.0377E+03, 5.0618E+03, &
       5.0860E+03, 5.1103E+03, 5.1347E+03, 5.1592E+03, 5.1837E+03, 5.2083E+03, 5.2330E+03, 5.2578E+03, 5.2826E+03, 5.3075E+03, &
       5.3325E+03, 5.3576E+03, 5.3828E+03, 5.4080E+03, 5.4333E+03, 5.4587E+03, 5.4842E+03, 5.5097E+03, 5.5354E+03, 5.5611E+03, &
       5.5869E+03, 5.6128E+03, 5.6387E+03, 5.6648E+03, 5.6909E+03, 5.7171E+03, 5.7434E+03, 5.7697E+03, 5.7962E+03, 5.8227E+03, &
       5.8493E+03, 5.8760E+03, 5.9028E+03, 5.9297E+03, 5.9566E+03, 5.9837E+03, 6.0108E+03, 6.0380E+03, 6.0653E+03, 6.0927E+03, &
       6.1201E+03, 6.1477E+03, 6.1753E+03, 6.2030E+03, 6.2308E+03, 6.2587E+03, 6.2867E+03, 6.3147E+03, 6.3429E+03, 6.3711E+03, &
       6.3994E+03, 6.4279E+03, 6.4564E+03, 6.4850E+03, 6.5136E+03, 6.5424E+03, 6.5713E+03, 6.6002E+03, 6.6292E+03, 6.6584E+03, &
       6.6876E+03, 6.7169E+03, 6.7463E+03, 6.7758E+03, 6.8053E+03, 6.8350E+03, 6.8648E+03, 6.8946E+03, 6.9246E+03, 6.9546E+03, &
       6.9847E+03, 7.0149E+03, 7.0452E+03, 7.0757E+03, 7.1062E+03, 7.1367E+03, 7.1674E+03, 7.1982E+03, 7.2291E+03, 7.2601E+03, &
       7.2911E+03, 7.3223E+03, 7.3535E+03, 7.3849E+03, 7.4163E+03, 7.4479E+03, 7.4795E+03, 7.5112E+03, 7.5431E+03, 7.5750E+03, &
       7.6070E+03, 7.6392E+03, 7.6714E+03, 7.7037E+03, 7.7361E+03, 7.7686E+03, 7.8012E+03, 7.8340E+03, 7.8668E+03, 7.8997E+03, &
       7.9327E+03, 7.9658E+03, 7.9990E+03, 8.0323E+03, 8.0658E+03, 8.0993E+03, 8.1329E+03, 8.1666E+03, 8.2004E+03, 8.2344E+03, &
       8.2684E+03, 8.3025E+03, 8.3367E+03, 8.3711E+03, 8.4055E+03, 8.4401E+03, 8.4747E+03, 8.5095E+03, 8.5443E+03, 8.5793E+03, &
       8.6143E+03, 8.6495E+03, 8.6848E+03, 8.7202E+03, 8.7556E+03, 8.7912E+03, 8.8269E+03, 8.8627E+03, 8.8987E+03, 8.9347E+03, &
       8.9708E+03, 9.0070E+03, 9.0434E+03, 9.0798E+03, 9.1164E+03, 9.1531E+03, 9.1899E+03, 9.2267E+03, 9.2637E+03, 9.3009E+03, &
       9.3381E+03, 9.3754E+03, 9.4128E+03, 9.4504E+03, 9.4881E+03, 9.5258E+03, 9.5637E+03, 9.6017E+03, 9.6398E+03, 9.6781E+03, &
       9.7164E+03, 9.7549E+03, 9.7934E+03, 9.8321E+03, 9.8709E+03, 9.9098E+03, 9.9488E+03, 9.9880E+03, 1.0027E+04, 1.0067E+04, &
       1.0106E+04, 1.0146E+04, 1.0185E+04, 1.0225E+04, 1.0265E+04, 1.0305E+04, 1.0345E+04, 1.0386E+04, 1.0426E+04, 1.0467E+04, &
       1.0507E+04, 1.0548E+04, 1.0589E+04, 1.0630E+04, 1.0671E+04, 1.0712E+04, 1.0754E+04, 1.0795E+04, 1.0837E+04, 1.0879E+04, &
       1.0921E+04, 1.0963E+04, 1.1005E+04, 1.1047E+04, 1.1089E+04, 1.1132E+04, 1.1174E+04, 1.1217E+04, 1.1260E+04, 1.1303E+04, &
       1.1346E+04, 1.1389E+04, 1.1432E+04, 1.1476E+04, 1.1520E+04, 1.1563E+04, 1.1607E+04, 1.1651E+04, 1.1695E+04, 1.1739E+04, &
       1.1784E+04, 1.1828E+04, 1.1873E+04, 1.1918E+04, 1.1962E+04, 1.2007E+04, 1.2053E+04, 1.2098E+04, 1.2143E+04, 1.2189E+04, &
       1.2234E+04, 1.2280E+04, 1.2326E+04, 1.2372E+04, 1.2418E+04, 1.2465E+04, 1.2511E+04, 1.2558E+04, 1.2604E+04, 1.2651E+04, &
       1.2698E+04, 1.2745E+04, 1.2792E+04, 1.2840E+04, 1.2887E+04, 1.2935E+04, 1.2983E+04, 1.3031E+04, 1.3079E+04, 1.3127E+04, &
       1.3175E+04, 1.3224E+04, 1.3272E+04, 1.3321E+04, 1.3370E+04, 1.3419E+04, 1.3468E+04, 1.3517E+04, 1.3567E+04, 1.3616E+04, &
       1.3666E+04, 1.3716E+04, 1.3766E+04, 1.3816E+04, 1.3866E+04, 1.3916E+04, 1.3967E+04, 1.4018E+04, 1.4068E+04, 1.4119E+04, &
       1.4171E+04, 1.4222E+04, 1.4273E+04, 1.4325E+04, 1.4376E+04, 1.4428E+04, 1.4480E+04, 1.4532E+04, 1.4585E+04, 1.4637E+04, &
       1.4690E+04, 1.4742E+04, 1.4795E+04, 1.4848E+04, 1.4901E+04, 1.4955E+04, 1.5008E+04, 1.5062E+04, 1.5115E+04, 1.5169E+04, &
       1.5223E+04, 1.5277E+04, 1.5332E+04, 1.5386E+04, 1.5441E+04, 1.5496E+04, 1.5551E+04, 1.5606E+04, 1.5661E+04, 1.5716E+04, &
       1.5772E+04, 1.5828E+04, 1.5883E+04, 1.5939E+04, 1.5996E+04, 1.6052E+04, 1.6108E+04, 1.6165E+04, 1.6222E+04, 1.6279E+04, &
       1.6336E+04, 1.6393E+04, 1.6450E+04, 1.6508E+04, 1.6566E+04, 1.6624E+04, 1.6682E+04, 1.6740E+04, 1.6798E+04, 1.6857E+04, &
       1.6915E+04, 1.6974E+04, 1.7033E+04, 1.7092E+04, 1.7152E+04, 1.7211E+04, 1.7271E+04, 1.7330E+04, 1.7390E+04, 1.7450E+04, &
       1.7511E+04, 1.7571E+04, 1.7632E+04, 1.7693E+04, 1.7753E+04, 1.7815E+04, 1.7876E+04, 1.7937E+04, 1.7999E+04, 1.8061E+04, &
       1.8123E+04, 1.8185E+04, 1.8247E+04, 1.8309E+04, 1.8372E+04, 1.8435E+04, 1.8498E+04, 1.8561E+04, 1.8624E+04, 1.8687E+04, &
       1.8751E+04, 1.8815E+04, 1.8879E+04, 1.8943E+04, 1.9007E+04, 1.9071E+04, 1.9136E+04, 1.9201E+04, 1.9266E+04, 1.9331E+04, &
       1.9396E+04, 1.9462E+04, 1.9528E+04, 1.9593E+04, 1.9659E+04, 1.9726E+04, 1.9792E+04, 1.9858E+04, 1.9925E+04, 1.9992E+04, &
       2.0059E+04, 2.0126E+04, 2.0194E+04, 2.0261E+04, 2.0329E+04, 2.0397E+04, 2.0465E+04, 2.0534E+04, 2.0602E+04, 2.0671E+04, &
       2.0740E+04, 2.0809E+04, 2.0878E+04, 2.0947E+04, 2.1017E+04, 2.1087E+04, 2.1157E+04, 2.1227E+04, 2.1297E+04, 2.1368E+04, &
       2.1438E+04, 2.1509E+04, 2.1580E+04, 2.1651E+04, 2.1723E+04, 2.1794E+04, 2.1866E+04, 2.1938E+04, 2.2010E+04, 2.2083E+04, &
       2.2155E+04, 2.2228E+04, 2.2301E+04, 2.2374E+04, 2.2447E+04, 2.2521E+04, 2.2595E+04, 2.2668E+04, 2.2742E+04, 2.2817E+04, &
       2.2891E+04, 2.2966E+04, 2.3041E+04, 2.3116E+04, 2.3191E+04, 2.3266E+04, 2.3342E+04, 2.3418E+04, 2.3494E+04, 2.3570E+04, &
       2.3646E+04, 2.3723E+04, 2.3800E+04, 2.3877E+04, 2.3954E+04, 2.4031E+04, 2.4109E+04, 2.4186E+04, 2.4264E+04, 2.4343E+04, &
       2.4421E+04, 2.4500E+04, 2.4578E+04, 2.4657E+04, 2.4736E+04, 2.4816E+04, 2.4895E+04, 2.4975E+04, 2.5055E+04, 2.5135E+04, &
       2.5216E+04, 2.5296E+04, 2.5377E+04, 2.5458E+04, 2.5539E+04, 2.5621E+04, 2.5702E+04, 2.5784E+04, 2.5866E+04, 2.5948E+04, &
       2.6031E+04, 2.6113E+04, 2.6196E+04, 2.6279E+04, 2.6363E+04, 2.6446E+04, 2.6530E+04, 2.6614E+04, 2.6698E+04, 2.6782E+04, &
       2.6867E+04, 2.6951E+04, 2.7036E+04, 2.7122E+04, 2.7207E+04, 2.7293E+04, 2.7378E+04, 2.7464E+04, 2.7551E+04, 2.7637E+04, &
       2.7724E+04, 2.7811E+04, 2.7898E+04, 2.7985E+04, 2.8073E+04, 2.8160E+04, 2.8248E+04, 2.8337E+04, 2.8425E+04, 2.8514E+04, &
       2.8603E+04, 2.8692E+04, 2.8781E+04, 2.8870E+04, 2.8960E+04, 2.9050E+04, 2.9140E+04, 2.9231E+04, 2.9321E+04, 2.9412E+04, &
       2.9503E+04, 2.9595E+04, 2.9686E+04, 2.9778E+04, 2.9870E+04, 2.9962E+04, 3.0054E+04, 3.0147E+04, 3.0240E+04, 3.0333E+04, &
       3.0427E+04, 3.0520E+04, 3.0614E+04, 3.0708E+04, 3.0802E+04, 3.0897E+04, 3.0991E+04, 3.1086E+04, 3.1182E+04, 3.1277E+04, &
       3.1373E+04, 3.1468E+04, 3.1565E+04, 3.1661E+04, 3.1758E+04, 3.1854E+04, 3.1951E+04, 3.2049E+04, 3.2146E+04, 3.2244E+04, &
       3.2342E+04, 3.2440E+04, 3.2539E+04, 3.2637E+04, 3.2736E+04, 3.2836E+04, 3.2935E+04, 3.3035E+04, 3.3135E+04, 3.3235E+04, &
       3.3335E+04, 3.3436E+04, 3.3537E+04, 3.3638E+04, 3.3739E+04, 3.3841E+04, 3.3943E+04, 3.4045E+04, 3.4147E+04, 3.4250E+04, &
       3.4353E+04, 3.4456E+04, 3.4559E+04, 3.4663E+04, 3.4766E+04, 3.4870E+04, 3.4975E+04, 3.5079E+04, 3.5184E+04, 3.5289E+04, &
       3.5395E+04, 3.5500E+04, 3.5606E+04, 3.5712E+04, 3.5818E+04, 3.5925E+04, 3.6032E+04, 3.6139E+04, 3.6246E+04, 3.6354E+04, &
       3.6462E+04, 3.6570E+04, 3.6678E+04, 3.6787E+04, 3.6896E+04, 3.7005E+04, 3.7114E+04, 3.7224E+04, 3.7334E+04, 3.7444E+04, &
       3.7554E+04, 3.7665E+04, 3.7776E+04, 3.7887E+04, 3.7999E+04, 3.8110E+04, 3.8222E+04, 3.8335E+04, 3.8447E+04, 3.8560E+04, &
       3.8673E+04, 3.8786E+04, 3.8900E+04, 3.9014E+04, 3.9128E+04, 3.9242E+04, 3.9357E+04, 3.9472E+04, 3.9587E+04, 3.9703E+04, &
       3.9818E+04, 3.9934E+04, 4.0051E+04, 4.0167E+04, 4.0284E+04, 4.0401E+04, 4.0518E+04, 4.0636E+04, 4.0754E+04, 4.0872E+04, &
       4.0991E+04, 4.1109E+04, 4.1228E+04, 4.1348E+04, 4.1467E+04, 4.1587E+04, 4.1707E+04, 4.1827E+04, 4.1948E+04, 4.2069E+04, &
       4.2190E+04, 4.2312E+04, 4.2433E+04, 4.2556E+04, 4.2678E+04, 4.2800E+04, 4.2923E+04, 4.3047E+04, 4.3170E+04, 4.3294E+04, &
       4.3418E+04, 4.3542E+04, 4.3667E+04, 4.3792E+04, 4.3917E+04, 4.4042E+04, 4.4168E+04, 4.4294E+04, 4.4420E+04, 4.4547E+04, &
       4.4674E+04, 4.4801E+04, 4.4929E+04, 4.5056E+04, 4.5184E+04, 4.5313E+04, 4.5441E+04, 4.5570E+04, 4.5700E+04, 4.5829E+04, &
       4.5959E+04, 4.6089E+04, 4.6219E+04, 4.6350E+04, 4.6481E+04, 4.6612E+04, 4.6744E+04, 4.6876E+04, 4.7008E+04, 4.7141E+04, &
       4.7273E+04, 4.7406E+04, 4.7540E+04, 4.7674E+04, 4.7808E+04, 4.7942E+04, 4.8076E+04, 4.8211E+04, 4.8346E+04, 4.8482E+04, &
       4.8618E+04, 4.8754E+04, 4.8890E+04, 4.9027E+04, 4.9164E+04, 4.9301E+04, 4.9439E+04, 4.9577E+04, 4.9715E+04, 4.9854E+04, &
       4.9993E+04, 5.0132E+04, 5.0271E+04, 5.0411E+04, 5.0551E+04, 5.0692E+04, 5.0833E+04, 5.0974E+04, 5.1115E+04, 5.1257E+04, &
       5.1399E+04, 5.1541E+04, 5.1684E+04, 5.1827E+04, 5.1970E+04, 5.2113E+04, 5.2257E+04, 5.2402E+04, 5.2546E+04, 5.2691E+04, &
       5.2836E+04, 5.2982E+04, 5.3127E+04, 5.3274E+04, 5.3420E+04, 5.3567E+04, 5.3714E+04, 5.3861E+04, 5.4009E+04, 5.4157E+04, &
       5.4306E+04, 5.4454E+04, 5.4603E+04, 5.4753E+04, 5.4903E+04, 5.5053E+04, 5.5203E+04, 5.5354E+04, 5.5505E+04, 5.5656E+04, &
       5.5808E+04, 5.5960E+04, 5.6112E+04, 5.6265E+04, 5.6418E+04, 5.6571E+04, 5.6725E+04, 5.6879E+04, 5.7033E+04, 5.7188E+04, &
       5.7343E+04, 5.7499E+04, 5.7654E+04, 5.7810E+04, 5.7967E+04, 5.8123E+04, 5.8281E+04, 5.8438E+04, 5.8596E+04, 5.8754E+04, &
       5.8912E+04, 5.9071E+04, 5.9230E+04, 5.9390E+04, 5.9549E+04, 5.9710E+04, 5.9870E+04, 6.0031E+04, 6.0192E+04, 6.0354E+04, &
       6.0516E+04, 6.0678E+04, 6.0840E+04, 6.1003E+04, 6.1167E+04, 6.1330E+04, 6.1494E+04, 6.1659E+04, 6.1823E+04, 6.1988E+04, &
       6.2154E+04, 6.2320E+04, 6.2486E+04, 6.2652E+04, 6.2819E+04, 6.2986E+04, 6.3154E+04, 6.3322E+04, 6.3490E+04, 6.3658E+04, &
       6.3827E+04, 6.3997E+04, 6.4166E+04, 6.4336E+04, 6.4507E+04, 6.4678E+04, 6.4849E+04, 6.5020E+04, 6.5192E+04, 6.5364E+04, &
       6.5537E+04, 6.5710E+04, 6.5883E+04, 6.6057E+04, 6.6231E+04, 6.6406E+04, 6.6580E+04, 6.6756E+04, 6.6931E+04, 6.7107E+04, &
       6.7283E+04, 6.7460E+04, 6.7637E+04, 6.7814E+04, 6.7992E+04, 6.8170E+04, 6.8349E+04, 6.8528E+04, 6.8707E+04, 6.8887E+04, &
       6.9067E+04, 6.9247E+04, 6.9428E+04, 6.9609E+04, 6.9791E+04, 6.9973E+04, 7.0155E+04, 7.0338E+04, 7.0521E+04, 7.0704E+04, &
       7.0888E+04, 7.1072E+04, 7.1257E+04, 7.1442E+04, 7.1627E+04, 7.1813E+04, 7.1999E+04, 7.2186E+04, 7.2372E+04, 7.2560E+04, &
       7.2747E+04, 7.2936E+04, 7.3124E+04, 7.3313E+04, 7.3502E+04, 7.3692E+04, 7.3882E+04, 7.4072E+04, 7.4263E+04, 7.4454E+04, &
       7.4646E+04, 7.4838E+04, 7.5031E+04, 7.5223E+04, 7.5417E+04, 7.5610E+04, 7.5804E+04, 7.5999E+04, 7.6193E+04, 7.6389E+04, &
       7.6584E+04, 7.6780E+04, 7.6977E+04, 7.7174E+04, 7.7371E+04, 7.7568E+04, 7.7766E+04, 7.7965E+04, 7.8164E+04, 7.8363E+04, &
       7.8563E+04, 7.8763E+04, 7.8963E+04, 7.9164E+04, 7.9366E+04, 7.9567E+04, 7.9769E+04, 7.9972E+04, 8.0175E+04, 8.0378E+04, &
       8.0582E+04, 8.0786E+04, 8.0991E+04, 8.1196E+04, 8.1401E+04, 8.1607E+04, 8.1814E+04, 8.2020E+04, 8.2227E+04, 8.2435E+04, &
       8.2643E+04, 8.2851E+04, 8.3060E+04, 8.3269E+04, 8.3479E+04, 8.3689E+04, 8.3900E+04, 8.4111E+04, 8.4322E+04, 8.4534E+04, &
       8.4746E+04, 8.4959E+04, 8.5172E+04, 8.5385E+04, 8.5599E+04, 8.5814E+04, 8.6028E+04, 8.6244E+04, 8.6459E+04, 8.6675E+04, &
       8.6892E+04, 8.7109E+04, 8.7326E+04, 8.7544E+04, 8.7762E+04, 8.7981E+04, 8.8200E+04, 8.8420E+04, 8.8640E+04, 8.8860E+04, &
       8.9081E+04, 8.9303E+04, 8.9524E+04, 8.9747E+04, 8.9969E+04, 9.0192E+04, 9.0416E+04, 9.0640E+04, 9.0865E+04, 9.1089E+04, &
       9.1315E+04, 9.1541E+04, 9.1767E+04, 9.1994E+04, 9.2221E+04, 9.2448E+04, 9.2676E+04, 9.2905E+04, 9.3134E+04, 9.3363E+04, &
       9.3593E+04, 9.3823E+04, 9.4054E+04, 9.4285E+04, 9.4517E+04, 9.4749E+04, 9.4982E+04, 9.5215E+04, 9.5449E+04, 9.5683E+04, &
       9.5917E+04, 9.6152E+04, 9.6387E+04, 9.6623E+04, 9.6859E+04, 9.7096E+04, 9.7333E+04, 9.7571E+04, 9.7809E+04, 9.8048E+04, &
       9.8287E+04, 9.8527E+04, 9.8767E+04, 9.9007E+04, 9.9248E+04, 9.9490E+04, 9.9732E+04, 9.9974E+04, 1.0022E+05, 1.0046E+05, &
       1.0070E+05, 1.0095E+05, 1.0119E+05, 1.0144E+05, 1.0168E+05, 1.0193E+05, 1.0218E+05, 1.0242E+05, 1.0267E+05, 1.0292E+05, &
       1.0317E+05, 1.0342E+05, 1.0367E+05, 1.0392E+05, 1.0417E+05, 1.0442E+05, 1.0467E+05, 1.0492E+05, 1.0517E+05, 1.0543E+05, &
       1.0568E+05, 1.0594E+05, 1.0619E+05, 1.0644E+05, 1.0670E+05, 1.0696E+05, 1.0721E+05, 1.0747E+05, 1.0773E+05, 1.0798E+05, &
       1.0824E+05, 1.0850E+05, 1.0876E+05, 1.0902E+05, 1.0928E+05, 1.0954E+05, 1.0980E+05, 1.1007E+05, 1.1033E+05, 1.1059E+05, &
       1.1085E+05, 1.1112E+05, 1.1138E+05, 1.1165E+05, 1.1191E+05, 1.1218E+05, 1.1245E+05, 1.1271E+05, 1.1298E+05, 1.1325E+05, &
       1.1352E+05, 1.1379E+05, 1.1406E+05, 1.1433E+05, 1.1460E+05, 1.1487E+05, 1.1514E+05, 1.1541E+05, 1.1568E+05, 1.1596E+05, &
       1.1623E+05, 1.1650E+05, 1.1678E+05, 1.1705E+05, 1.1733E+05, 1.1761E+05, 1.1788E+05, 1.1816E+05, 1.1844E+05, 1.1872E+05, &
       1.1900E+05, 1.1927E+05, 1.1955E+05, 1.1984E+05, 1.2012E+05, 1.2040E+05, 1.2068E+05, 1.2096E+05, 1.2125E+05, 1.2153E+05, &
       1.2181E+05, 1.2210E+05, 1.2238E+05, 1.2267E+05, 1.2296E+05, 1.2324E+05, 1.2353E+05, 1.2382E+05, 1.2411E+05, 1.2440E+05, &
       1.2468E+05, 1.2497E+05, 1.2527E+05, 1.2556E+05, 1.2585E+05, 1.2614E+05, 1.2643E+05, 1.2673E+05, 1.2702E+05, 1.2732E+05, &
       1.2761E+05, 1.2791E+05, 1.2820E+05, 1.2850E+05, 1.2880E+05, 1.2909E+05, 1.2939E+05, 1.2969E+05, 1.2999E+05, 1.3029E+05, &
       1.3059E+05, 1.3089E+05, 1.3119E+05, 1.3150E+05, 1.3180E+05, 1.3210E+05, 1.3241E+05, 1.3271E+05, 1.3302E+05, 1.3332E+05, &
       1.3363E+05, 1.3393E+05, 1.3424E+05, 1.3455E+05, 1.3486E+05, 1.3517E+05, 1.3548E+05, 1.3579E+05, 1.3610E+05, 1.3641E+05, &
       1.3672E+05, 1.3703E+05, 1.3735E+05, 1.3766E+05, 1.3797E+05, 1.3829E+05, 1.3860E+05, 1.3892E+05, 1.3924E+05, 1.3955E+05, &
       1.3987E+05, 1.4019E+05, 1.4051E+05, 1.4083E+05, 1.4115E+05, 1.4147E+05, 1.4179E+05, 1.4211E+05, 1.4243E+05, 1.4276E+05, &
       1.4308E+05, 1.4340E+05, 1.4373E+05, 1.4405E+05, 1.4438E+05, 1.4471E+05, 1.4503E+05, 1.4536E+05, 1.4569E+05, 1.4602E+05, &
       1.4635E+05, 1.4668E+05, 1.4701E+05, 1.4734E+05, 1.4767E+05, 1.4800E+05, 1.4834E+05, 1.4867E+05, 1.4901E+05, 1.4934E+05, &
       1.4968E+05, 1.5001E+05, 1.5035E+05, 1.5069E+05, 1.5102E+05, 1.5136E+05, 1.5170E+05, 1.5204E+05, 1.5238E+05, 1.5272E+05, &
       1.5306E+05, 1.5341E+05, 1.5375E+05, 1.5409E+05, 1.5444E+05, 1.5478E+05, 1.5513E+05, 1.5547E+05, 1.5582E+05, 1.5617E+05, &
       1.5651E+05, 1.5686E+05, 1.5721E+05, 1.5756E+05, 1.5791E+05, 1.5826E+05, 1.5861E+05, 1.5897E+05, 1.5932E+05, 1.5967E+05, &
       1.6003E+05, 1.6038E+05, 1.6074E+05, 1.6109E+05, 1.6145E+05, 1.6181E+05, 1.6216E+05, 1.6252E+05, 1.6288E+05, 1.6324E+05, &
       1.6360E+05, 1.6396E+05, 1.6432E+05, 1.6469E+05, 1.6505E+05, 1.6541E+05, 1.6578E+05, 1.6614E+05, 1.6651E+05, 1.6687E+05, &
       1.6724E+05, 1.6761E+05, 1.6798E+05, 1.6834E+05, 1.6871E+05, 1.6908E+05, 1.6946E+05, 1.6983E+05, 1.7020E+05, 1.7057E+05, &
       1.7094E+05, 1.7132E+05, 1.7169E+05, 1.7207E+05, 1.7244E+05, 1.7282E+05, 1.7320E+05, 1.7358E+05, 1.7396E+05, 1.7434E+05, &
       1.7472E+05, 1.7510E+05, 1.7548E+05, 1.7586E+05, 1.7624E+05, 1.7663E+05, 1.7701E+05, 1.7739E+05, 1.7778E+05, 1.7817E+05, &
       1.7855E+05, 1.7894E+05, 1.7933E+05, 1.7972E+05, 1.8011E+05, 1.8050E+05, 1.8089E+05, 1.8128E+05, 1.8167E+05, 1.8206E+05, &
       1.8246E+05, 1.8285E+05, 1.8325E+05, 1.8364E+05, 1.8404E+05, 1.8443E+05, 1.8483E+05, 1.8523E+05, 1.8563E+05, 1.8603E+05, &
       1.8643E+05, 1.8683E+05, 1.8723E+05, 1.8763E+05, 1.8804E+05, 1.8844E+05, 1.8885E+05, 1.8925E+05, 1.8966E+05, 1.9006E+05, &
       1.9047E+05, 1.9088E+05, 1.9129E+05, 1.9170E+05, 1.9211E+05, 1.9252E+05, 1.9293E+05, 1.9334E+05, 1.9376E+05, 1.9417E+05, &
       1.9458E+05, 1.9500E+05, 1.9542E+05, 1.9583E+05, 1.9625E+05, 1.9667E+05, 1.9709E+05, 1.9751E+05, 1.9793E+05, 1.9835E+05, &
       1.9877E+05, 1.9919E+05, 1.9961E+05, 2.0004E+05, 2.0046E+05, 2.0089E+05, 2.0131E+05, 2.0174E+05, 2.0217E+05, 2.0260E+05, &
       2.0302E+05, 2.0345E+05, 2.0388E+05, 2.0432E+05, 2.0475E+05, 2.0518E+05, 2.0561E+05, 2.0605E+05, 2.0648E+05, 2.0692E+05, &
       2.0735E+05, 2.0779E+05, 2.0823E+05, 2.0867E+05, 2.0911E+05, 2.0955E+05, 2.0999E+05, 2.1043E+05, 2.1087E+05, 2.1131E+05, &
       2.1176E+05, 2.1220E+05, 2.1265E+05, 2.1309E+05, 2.1354E+05, 2.1399E+05, 2.1444E+05, 2.1488E+05, 2.1533E+05, 2.1578E+05, &
       2.1624E+05, 2.1669E+05, 2.1714E+05, 2.1759E+05, 2.1805E+05, 2.1850E+05, 2.1896E+05, 2.1942E+05, 2.1987E+05, 2.2033E+05, &
       2.2079E+05, 2.2125E+05, 2.2171E+05, 2.2217E+05, 2.2263E+05, 2.2310E+05, 2.2356E+05, 2.2402E+05, 2.2449E+05, 2.2495E+05, &
       2.2542E+05, 2.2589E+05, 2.2636E+05, 2.2683E+05, 2.2730E+05, 2.2777E+05, 2.2824E+05, 2.2871E+05, 2.2918E+05, 2.2966E+05, &
       2.3013E+05, 2.3061E+05, 2.3108E+05, 2.3156E+05, 2.3204E+05, 2.3252E+05, 2.3299E+05, 2.3347E+05, 2.3396E+05, 2.3444E+05, &
       2.3492E+05, 2.3540E+05, 2.3589E+05, 2.3637E+05, 2.3686E+05, 2.3734E+05, 2.3783E+05, 2.3832E+05, 2.3881E+05, 2.3930E+05, &
       2.3979E+05, 2.4028E+05, 2.4077E+05, 2.4126E+05, 2.4176E+05, 2.4225E+05, 2.4275E+05, 2.4324E+05, 2.4374E+05, 2.4424E+05, &
       2.4474E+05, 2.4524E+05, 2.4574E+05, 2.4624E+05, 2.4674E+05, 2.4724E+05, 2.4775E+05, 2.4825E+05, 2.4875E+05, 2.4926E+05, &
       2.4977E+05, 2.5028E+05, 2.5078E+05, 2.5129E+05, 2.5180E+05, 2.5231E+05, 2.5283E+05, 2.5334E+05, 2.5385E+05, 2.5437E+05, &
       2.5488E+05, 2.5540E+05, 2.5591E+05, 2.5643E+05, 2.5695E+05, 2.5747E+05, 2.5799E+05, 2.5851E+05, 2.5903E+05, 2.5956E+05, &
       2.6008E+05, 2.6060E+05, 2.6113E+05, 2.6166E+05, 2.6218E+05, 2.6271E+05, 2.6324E+05, 2.6377E+05, 2.6430E+05, 2.6483E+05, &
       2.6536E+05, 2.6590E+05, 2.6643E+05, 2.6697E+05, 2.6750E+05, 2.6804E+05, 2.6857E+05, 2.6911E+05, 2.6965E+05, 2.7019E+05, &
       2.7073E+05, 2.7127E+05, 2.7182E+05, 2.7236E+05, 2.7291E+05, 2.7345E+05, 2.7400E+05, 2.7454E+05, 2.7509E+05, 2.7564E+05, &
       2.7619E+05, 2.7674E+05, 2.7729E+05, 2.7784E+05, 2.7840E+05, 2.7895E+05, 2.7951E+05, 2.8006E+05, 2.8062E+05, 2.8118E+05, &
       2.8173E+05, 2.8229E+05, 2.8285E+05, 2.8342E+05, 2.8398E+05, 2.8454E+05, 2.8510E+05, 2.8567E+05, 2.8623E+05, 2.8680E+05, &
       2.8737E+05, 2.8794E+05, 2.8851E+05, 2.8908E+05, 2.8965E+05, 2.9022E+05, 2.9079E+05, 2.9137E+05, 2.9194E+05, 2.9252E+05, &
       2.9309E+05, 2.9367E+05, 2.9425E+05, 2.9483E+05, 2.9541E+05, 2.9599E+05, 2.9657E+05, 2.9715E+05, 2.9774E+05, 2.9832E+05, &
       2.9891E+05, 2.9950E+05, 3.0008E+05, 3.0067E+05, 3.0126E+05, 3.0185E+05, 3.0244E+05, 3.0304E+05, 3.0363E+05, 3.0422E+05, &
       3.0482E+05, 3.0541E+05, 3.0601E+05, 3.0661E+05, 3.0721E+05, 3.0781E+05, 3.0841E+05, 3.0901E+05, 3.0961E+05, 3.1022E+05, &
       3.1082E+05, 3.1143E+05, 3.1203E+05, 3.1264E+05, 3.1325E+05, 3.1386E+05, 3.1447E+05, 3.1508E+05, 3.1569E+05, 3.1630E+05, &
       3.1692E+05, 3.1753E+05, 3.1815E+05, 3.1876E+05, 3.1938E+05, 3.2000E+05, 3.2062E+05, 3.2124E+05, 3.2186E+05, 3.2249E+05, &
       3.2311E+05, 3.2373E+05, 3.2436E+05, 3.2499E+05, 3.2561E+05, 3.2624E+05, 3.2687E+05, 3.2750E+05, 3.2813E+05, 3.2877E+05, &
       3.2940E+05, 3.3003E+05, 3.3067E+05, 3.3131E+05, 3.3194E+05, 3.3258E+05, 3.3322E+05, 3.3386E+05, 3.3450E+05, 3.3514E+05, &
       3.3579E+05, 3.3643E+05, 3.3708E+05, 3.3772E+05, 3.3837E+05, 3.3902E+05, 3.3967E+05, 3.4032E+05, 3.4097E+05, 3.4162E+05, &
       3.4228E+05, 3.4293E+05, 3.4359E+05, 3.4424E+05, 3.4490E+05, 3.4556E+05, 3.4622E+05, 3.4688E+05, 3.4754E+05, 3.4820E+05, &
       3.4886E+05, 3.4953E+05, 3.5019E+05, 3.5086E+05, 3.5153E+05, 3.5220E+05, 3.5287E+05, 3.5354E+05, 3.5421E+05, 3.5488E+05, &
       3.5555E+05, 3.5623E+05, 3.5690E+05, 3.5758E+05, 3.5826E+05, 3.5894E+05, 3.5962E+05, 3.6030E+05, 3.6098E+05, 3.6166E+05, &
       3.6235E+05, 3.6303E+05, 3.6372E+05, 3.6440E+05, 3.6509E+05, 3.6578E+05, 3.6647E+05, 3.6716E+05, 3.6785E+05, 3.6855E+05, &
       3.6924E+05, 3.6994E+05, 3.7063E+05, 3.7133E+05, 3.7203E+05, 3.7273E+05, 3.7343E+05, 3.7413E+05, 3.7484E+05, 3.7554E+05, &
       3.7624E+05, 3.7695E+05, 3.7766E+05, 3.7837E+05, 3.7907E+05, 3.7978E+05, 3.8050E+05, 3.8121E+05, 3.8192E+05, 3.8264E+05, &
       3.8335E+05, 3.8407E+05, 3.8479E+05, 3.8551E+05, 3.8623E+05, 3.8695E+05, 3.8767E+05, 3.8839E+05, 3.8912E+05, 3.8984E+05, &
       3.9057E+05, 3.9130E+05, 3.9202E+05, 3.9275E+05, 3.9348E+05, 3.9422E+05, 3.9495E+05, 3.9568E+05, 3.9642E+05, 3.9716E+05, &
       3.9789E+05, 3.9863E+05, 3.9937E+05, 4.0011E+05, 4.0085E+05, 4.0160E+05, 4.0234E+05, 4.0308E+05, 4.0383E+05, 4.0458E+05, &
       4.0533E+05, 4.0608E+05, 4.0683E+05, 4.0758E+05, 4.0833E+05, 4.0909E+05, 4.0984E+05, 4.1060E+05, 4.1135E+05, 4.1211E+05, &
       4.1287E+05, 4.1363E+05, 4.1440E+05, 4.1516E+05, 4.1592E+05, 4.1669E+05, 4.1745E+05, 4.1822E+05, 4.1899E+05, 4.1976E+05, &
       4.2053E+05, 4.2130E+05, 4.2208E+05, 4.2285E+05, 4.2363E+05, 4.2440E+05, 4.2518E+05, 4.2596E+05, 4.2674E+05, 4.2752E+05, &
       4.2830E+05, 4.2909E+05, 4.2987E+05, 4.3066E+05, 4.3144E+05, 4.3223E+05, 4.3302E+05, 4.3381E+05, 4.3460E+05, 4.3540E+05, &
       4.3619E+05, 4.3698E+05, 4.3778E+05, 4.3858E+05, 4.3938E+05, 4.4018E+05, 4.4098E+05, 4.4178E+05, 4.4258E+05, 4.4339E+05, &
       4.4419E+05, 4.4500E+05, 4.4581E+05, 4.4662E+05, 4.4743E+05, 4.4824E+05, 4.4905E+05, 4.4986E+05, 4.5068E+05, 4.5149E+05, &
       4.5231E+05, 4.5313E+05, 4.5395E+05, 4.5477E+05, 4.5559E+05, 4.5642E+05, 4.5724E+05, 4.5807E+05, 4.5889E+05, 4.5972E+05, &
       4.6055E+05, 4.6138E+05, 4.6221E+05, 4.6305E+05, 4.6388E+05, 4.6472E+05, 4.6555E+05, 4.6639E+05, 4.6723E+05, 4.6807E+05, &
       4.6891E+05, 4.6975E+05, 4.7060E+05, 4.7144E+05, 4.7229E+05, 4.7314E+05, 4.7398E+05, 4.7483E+05, 4.7568E+05, 4.7654E+05, &
       4.7739E+05, 4.7825E+05, 4.7910E+05, 4.7996E+05, 4.8082E+05, 4.8168E+05, 4.8254E+05, 4.8340E+05, 4.8426E+05, 4.8513E+05, &
       4.8599E+05, 4.8686E+05, 4.8773E+05, 4.8860E+05, 4.8947E+05, 4.9034E+05, 4.9121E+05, 4.9209E+05, 4.9296E+05, 4.9384E+05, &
       4.9472E+05, 4.9560E+05, 4.9648E+05, 4.9736E+05, 4.9825E+05, 4.9913E+05, 5.0002E+05, 5.0090E+05, 5.0179E+05, 5.0268E+05, &
       5.0357E+05, 5.0446E+05, 5.0536E+05, 5.0625E+05, 5.0715E+05, 5.0805E+05, 5.0894E+05, 5.0984E+05, 5.1074E+05, 5.1165E+05, &
       5.1255E+05, 5.1346E+05, 5.1436E+05, 5.1527E+05, 5.1618E+05, 5.1709E+05, 5.1800E+05, 5.1891E+05, 5.1982E+05, 5.2074E+05, &
       5.2166E+05, 5.2257E+05, 5.2349E+05, 5.2441E+05, 5.2533E+05, 5.2626E+05, 5.2718E+05, 5.2811E+05, 5.2903E+05, 5.2996E+05, &
       5.3089E+05, 5.3182E+05, 5.3275E+05, 5.3369E+05, 5.3462E+05, 5.3556E+05, 5.3650E+05, 5.3743E+05, 5.3837E+05, 5.3931E+05, &
       5.4026E+05, 5.4120E+05, 5.4215E+05, 5.4309E+05, 5.4404E+05, 5.4499E+05, 5.4594E+05, 5.4689E+05, 5.4784E+05, 5.4880E+05, &
       5.4975E+05, 5.5071E+05, 5.5167E+05, 5.5263E+05, 5.5359E+05, 5.5455E+05, 5.5552E+05, 5.5648E+05, 5.5745E+05, 5.5842E+05, &
       5.5939E+05, 5.6036E+05, 5.6133E+05, 5.6230E+05, 5.6327E+05, 5.6425E+05, 5.6523E+05, 5.6621E+05, 5.6719E+05, 5.6817E+05, &
       5.6915E+05, 5.7013E+05, 5.7112E+05, 5.7211E+05, 5.7309E+05, 5.7408E+05, 5.7507E+05, 5.7607E+05, 5.7706E+05, 5.7805E+05, &
       5.7905E+05, 5.8005E+05, 5.8105E+05, 5.8205E+05, 5.8305E+05, 5.8405E+05, 5.8506E+05, 5.8606E+05, 5.8707E+05, 5.8808E+05, &
       5.8909E+05, 5.9010E+05, 5.9111E+05, 5.9213E+05, 5.9314E+05, 5.9416E+05, 5.9518E+05, 5.9620E+05, 5.9722E+05, 5.9824E+05, &
       5.9927E+05, 6.0029E+05, 6.0132E+05, 6.0235E+05, 6.0337E+05, 6.0441E+05, 6.0544E+05, 6.0647E+05, 6.0751E+05, 6.0854E+05, &
       6.0958E+05, 6.1062E+05, 6.1166E+05, 6.1270E+05, 6.1375E+05, 6.1479E+05, 6.1584E+05, 6.1689E+05, 6.1794E+05, 6.1899E+05, &
       6.2004E+05, 6.2109E+05, 6.2215E+05, 6.2320E+05, 6.2426E+05, 6.2532E+05, 6.2638E+05, 6.2744E+05, 6.2851E+05, 6.2957E+05, &
       6.3064E+05, 6.3171E+05, 6.3278E+05, 6.3385E+05, 6.3492E+05, 6.3599E+05, 6.3707E+05, 6.3815E+05, 6.3922E+05, 6.4030E+05, &
       6.4138E+05, 6.4247E+05, 6.4355E+05, 6.4464E+05, 6.4572E+05, 6.4681E+05, 6.4790E+05, 6.4899E+05, 6.5008E+05, 6.5118E+05, &
       6.5227E+05, 6.5337E+05, 6.5447E+05, 6.5557E+05, 6.5667E+05, 6.5777E+05, 6.5888E+05, 6.5998E+05, 6.6109E+05, 6.6220E+05, &
       6.6331E+05, 6.6442E+05, 6.6554E+05, 6.6665E+05, 6.6777E+05, 6.6888E+05, 6.7000E+05, 6.7112E+05, 6.7225E+05, 6.7337E+05, &
       6.7449E+05, 6.7562E+05, 6.7675E+05, 6.7788E+05, 6.7901E+05, 6.8014E+05, 6.8128E+05, 6.8241E+05, 6.8355E+05, 6.8469E+05, &
       6.8583E+05, 6.8697E+05, 6.8811E+05, 6.8926E+05, 6.9041E+05, 6.9155E+05, 6.9270E+05, 6.9385E+05, 6.9501E+05, 6.9616E+05, &
       6.9731E+05, 6.9847E+05, 6.9963E+05, 7.0079E+05, 7.0195E+05, 7.0311E+05, 7.0428E+05, 7.0545E+05, 7.0661E+05, 7.0778E+05, &
       7.0895E+05, 7.1013E+05, 7.1130E+05, 7.1247E+05, 7.1365E+05, 7.1483E+05, 7.1601E+05, 7.1719E+05, 7.1837E+05, 7.1956E+05, &
       7.2074E+05, 7.2193E+05, 7.2312E+05, 7.2431E+05, 7.2551E+05, 7.2670E+05, 7.2789E+05, 7.2909E+05, 7.3029E+05, 7.3149E+05, &
       7.3269E+05, 7.3390E+05, 7.3510E+05, 7.3631E+05, 7.3752E+05, 7.3872E+05, 7.3994E+05, 7.4115E+05, 7.4236E+05, 7.4358E+05, &
       7.4480E+05, 7.4602E+05, 7.4724E+05, 7.4846E+05, 7.4968E+05, 7.5091E+05, 7.5213E+05, 7.5336E+05, 7.5459E+05, 7.5583E+05, &
       7.5706E+05, 7.5829E+05, 7.5953E+05, 7.6077E+05, 7.6201E+05, 7.6325E+05, 7.6449E+05, 7.6574E+05, 7.6698E+05, 7.6823E+05, &
       7.6948E+05, 7.7073E+05, 7.7198E+05, 7.7324E+05, 7.7449E+05, 7.7575E+05, 7.7701E+05, 7.7827E+05, 7.7953E+05, 7.8080E+05, &
       7.8206E+05, 7.8333E+05, 7.8460E+05, 7.8587E+05, 7.8714E+05, 7.8842E+05, 7.8969E+05, 7.9097E+05, 7.9225E+05, 7.9353E+05, &
       7.9481E+05, 7.9609E+05, 7.9738E+05, 7.9867E+05, 7.9995E+05, 8.0124E+05, 8.0254E+05, 8.0383E+05, 8.0512E+05, 8.0642E+05, &
       8.0772E+05, 8.0902E+05, 8.1032E+05, 8.1162E+05, 8.1293E+05, 8.1424E+05, 8.1554E+05, 8.1685E+05, 8.1817E+05, 8.1948E+05, &
       8.2079E+05, 8.2211E+05, 8.2343E+05, 8.2475E+05, 8.2607E+05, 8.2739E+05, 8.2872E+05, 8.3005E+05, 8.3137E+05, 8.3270E+05, &
       8.3404E+05, 8.3537E+05, 8.3671E+05, 8.3804E+05, 8.3938E+05, 8.4072E+05, 8.4206E+05, 8.4341E+05, 8.4475E+05, 8.4610E+05/
      data (QofT( 8,J),J=2409,4510)/ 8.4745E+05, 8.4880E+05, 8.5015E+05, 8.5150E+05, 8.5286E+05, 8.5422E+05, 8.5557E+05, 8.5694E+05, &
       8.5830E+05, 8.5966E+05, 8.6103E+05, 8.6239E+05, 8.6376E+05, 8.6513E+05, 8.6651E+05, 8.6788E+05, 8.6926E+05, 8.7064E+05, &
       8.7201E+05, 8.7340E+05, 8.7478E+05, 8.7616E+05, 8.7755E+05, 8.7894E+05, 8.8033E+05, 8.8172E+05, 8.8311E+05, 8.8451E+05, &
       8.8590E+05, 8.8730E+05, 8.8870E+05, 8.9011E+05, 8.9151E+05, 8.9291E+05, 8.9432E+05, 8.9573E+05, 8.9714E+05, 8.9855E+05, &
       8.9997E+05, 9.0138E+05, 9.0280E+05, 9.0422E+05, 9.0564E+05, 9.0707E+05, 9.0849E+05, 9.0992E+05, 9.1135E+05, 9.1278E+05, &
       9.1421E+05, 9.1564E+05, 9.1708E+05, 9.1851E+05, 9.1995E+05, 9.2139E+05, 9.2284E+05, 9.2428E+05, 9.2573E+05, 9.2717E+05, &
       9.2862E+05, 9.3008E+05, 9.3153E+05, 9.3298E+05, 9.3444E+05, 9.3590E+05, 9.3736E+05, 9.3882E+05, 9.4029E+05, 9.4175E+05, &
       9.4322E+05, 9.4469E+05, 9.4616E+05, 9.4763E+05, 9.4911E+05, 9.5058E+05, 9.5206E+05, 9.5354E+05, 9.5502E+05, 9.5651E+05, &
       9.5799E+05, 9.5948E+05, 9.6097E+05, 9.6246E+05, 9.6395E+05, 9.6545E+05, 9.6695E+05, 9.6844E+05, 9.6994E+05, 9.7145E+05, &
       9.7295E+05, 9.7446E+05, 9.7596E+05, 9.7747E+05, 9.7898E+05, 9.8050E+05, 9.8201E+05, 9.8353E+05, 9.8505E+05, 9.8657E+05, &
       9.8809E+05, 9.8961E+05, 9.9114E+05, 9.9267E+05, 9.9420E+05, 9.9573E+05, 9.9726E+05, 9.9880E+05, 1.0003E+06, 1.0019E+06, &
       1.0034E+06, 1.0050E+06, 1.0065E+06, 1.0080E+06, 1.0096E+06, 1.0111E+06, 1.0127E+06, 1.0142E+06, 1.0158E+06, 1.0174E+06, &
       1.0189E+06, 1.0205E+06, 1.0220E+06, 1.0236E+06, 1.0252E+06, 1.0267E+06, 1.0283E+06, 1.0299E+06, 1.0315E+06, 1.0330E+06, &
       1.0346E+06, 1.0362E+06, 1.0378E+06, 1.0394E+06, 1.0409E+06, 1.0425E+06, 1.0441E+06, 1.0457E+06, 1.0473E+06, 1.0489E+06, &
       1.0505E+06, 1.0521E+06, 1.0537E+06, 1.0553E+06, 1.0569E+06, 1.0585E+06, 1.0601E+06, 1.0617E+06, 1.0633E+06, 1.0650E+06, &
       1.0666E+06, 1.0682E+06, 1.0698E+06, 1.0714E+06, 1.0731E+06, 1.0747E+06, 1.0763E+06, 1.0779E+06, 1.0796E+06, 1.0812E+06, &
       1.0828E+06, 1.0845E+06, 1.0861E+06, 1.0878E+06, 1.0894E+06, 1.0911E+06, 1.0927E+06, 1.0944E+06, 1.0960E+06, 1.0977E+06, &
       1.0993E+06, 1.1010E+06, 1.1026E+06, 1.1043E+06, 1.1059E+06, 1.1076E+06, 1.1093E+06, 1.1109E+06, 1.1126E+06, 1.1143E+06, &
       1.1160E+06, 1.1176E+06, 1.1193E+06, 1.1210E+06, 1.1227E+06, 1.1244E+06, 1.1261E+06, 1.1277E+06, 1.1294E+06, 1.1311E+06, &
       1.1328E+06, 1.1345E+06, 1.1362E+06, 1.1379E+06, 1.1396E+06, 1.1413E+06, 1.1430E+06, 1.1447E+06, 1.1464E+06, 1.1482E+06, &
       1.1499E+06, 1.1516E+06, 1.1533E+06, 1.1550E+06, 1.1567E+06, 1.1585E+06, 1.1602E+06, 1.1619E+06, 1.1637E+06, 1.1654E+06, &
       1.1671E+06, 1.1689E+06, 1.1706E+06, 1.1723E+06, 1.1741E+06, 1.1758E+06, 1.1776E+06, 1.1793E+06, 1.1811E+06, 1.1828E+06, &
       1.1846E+06, 1.1863E+06, 1.1881E+06, 1.1898E+06, 1.1916E+06, 1.1934E+06, 1.1951E+06, 1.1969E+06, 1.1987E+06, 1.2005E+06, &
       1.2022E+06, 1.2040E+06, 1.2058E+06, 1.2076E+06, 1.2093E+06, 1.2111E+06, 1.2129E+06, 1.2147E+06, 1.2165E+06, 1.2183E+06, &
       1.2201E+06, 1.2219E+06, 1.2237E+06, 1.2255E+06, 1.2273E+06, 1.2291E+06, 1.2309E+06, 1.2327E+06, 1.2345E+06, 1.2363E+06, &
       1.2381E+06, 1.2400E+06, 1.2418E+06, 1.2436E+06, 1.2454E+06, 1.2473E+06, 1.2491E+06, 1.2509E+06, 1.2527E+06, 1.2546E+06, &
       1.2564E+06, 1.2583E+06, 1.2601E+06, 1.2619E+06, 1.2638E+06, 1.2656E+06, 1.2675E+06, 1.2693E+06, 1.2712E+06, 1.2730E+06, &
       1.2749E+06, 1.2768E+06, 1.2786E+06, 1.2805E+06, 1.2823E+06, 1.2842E+06, 1.2861E+06, 1.2880E+06, 1.2898E+06, 1.2917E+06, &
       1.2936E+06, 1.2955E+06, 1.2973E+06, 1.2992E+06, 1.3011E+06, 1.3030E+06, 1.3049E+06, 1.3068E+06, 1.3087E+06, 1.3106E+06, &
       1.3125E+06, 1.3144E+06, 1.3163E+06, 1.3182E+06, 1.3201E+06, 1.3220E+06, 1.3239E+06, 1.3258E+06, 1.3278E+06, 1.3297E+06, &
       1.3316E+06, 1.3335E+06, 1.3354E+06, 1.3374E+06, 1.3393E+06, 1.3412E+06, 1.3432E+06, 1.3451E+06, 1.3470E+06, 1.3490E+06, &
       1.3509E+06, 1.3529E+06, 1.3548E+06, 1.3568E+06, 1.3587E+06, 1.3607E+06, 1.3626E+06, 1.3646E+06, 1.3665E+06, 1.3685E+06, &
       1.3705E+06, 1.3724E+06, 1.3744E+06, 1.3764E+06, 1.3783E+06, 1.3803E+06, 1.3823E+06, 1.3843E+06, 1.3863E+06, 1.3882E+06, &
       1.3902E+06, 1.3922E+06, 1.3942E+06, 1.3962E+06, 1.3982E+06, 1.4002E+06, 1.4022E+06, 1.4042E+06, 1.4062E+06, 1.4082E+06, &
       1.4102E+06, 1.4122E+06, 1.4142E+06, 1.4163E+06, 1.4183E+06, 1.4203E+06, 1.4223E+06, 1.4243E+06, 1.4264E+06, 1.4284E+06, &
       1.4304E+06, 1.4324E+06, 1.4345E+06, 1.4365E+06, 1.4386E+06, 1.4406E+06, 1.4426E+06, 1.4447E+06, 1.4467E+06, 1.4488E+06, &
       1.4508E+06, 1.4529E+06, 1.4550E+06, 1.4570E+06, 1.4591E+06, 1.4611E+06, 1.4632E+06, 1.4653E+06, 1.4673E+06, 1.4694E+06, &
       1.4715E+06, 1.4736E+06, 1.4756E+06, 1.4777E+06, 1.4798E+06, 1.4819E+06, 1.4840E+06, 1.4861E+06, 1.4882E+06, 1.4903E+06, &
       1.4924E+06, 1.4945E+06, 1.4966E+06, 1.4987E+06, 1.5008E+06, 1.5029E+06, 1.5050E+06, 1.5071E+06, 1.5092E+06, 1.5113E+06, &
       1.5135E+06, 1.5156E+06, 1.5177E+06, 1.5198E+06, 1.5220E+06, 1.5241E+06, 1.5262E+06, 1.5284E+06, 1.5305E+06, 1.5326E+06, &
       1.5348E+06, 1.5369E+06, 1.5391E+06, 1.5412E+06, 1.5434E+06, 1.5455E+06, 1.5477E+06, 1.5499E+06, 1.5520E+06, 1.5542E+06, &
       1.5563E+06, 1.5585E+06, 1.5607E+06, 1.5629E+06, 1.5650E+06, 1.5672E+06, 1.5694E+06, 1.5716E+06, 1.5738E+06, 1.5759E+06, &
       1.5781E+06, 1.5803E+06, 1.5825E+06, 1.5847E+06, 1.5869E+06, 1.5891E+06, 1.5913E+06, 1.5935E+06, 1.5957E+06, 1.5979E+06, &
       1.6002E+06, 1.6024E+06, 1.6046E+06, 1.6068E+06, 1.6090E+06, 1.6112E+06, 1.6135E+06, 1.6157E+06, 1.6179E+06, 1.6202E+06, &
       1.6224E+06, 1.6246E+06, 1.6269E+06, 1.6291E+06, 1.6314E+06, 1.6336E+06, 1.6359E+06, 1.6381E+06, 1.6404E+06, 1.6426E+06, &
       1.6449E+06, 1.6472E+06, 1.6494E+06, 1.6517E+06, 1.6540E+06, 1.6562E+06, 1.6585E+06, 1.6608E+06, 1.6631E+06, 1.6653E+06, &
       1.6676E+06, 1.6699E+06, 1.6722E+06, 1.6745E+06, 1.6768E+06, 1.6791E+06, 1.6814E+06, 1.6837E+06, 1.6860E+06, 1.6883E+06, &
       1.6906E+06, 1.6929E+06, 1.6952E+06, 1.6975E+06, 1.6998E+06, 1.7022E+06, 1.7045E+06, 1.7068E+06, 1.7091E+06, 1.7115E+06, &
       1.7138E+06, 1.7161E+06, 1.7185E+06, 1.7208E+06, 1.7231E+06, 1.7255E+06, 1.7278E+06, 1.7302E+06, 1.7325E+06, 1.7349E+06, &
       1.7372E+06, 1.7396E+06, 1.7420E+06, 1.7443E+06, 1.7467E+06, 1.7491E+06, 1.7514E+06, 1.7538E+06, 1.7562E+06, 1.7586E+06, &
       1.7609E+06, 1.7633E+06, 1.7657E+06, 1.7681E+06, 1.7705E+06, 1.7729E+06, 1.7753E+06, 1.7777E+06, 1.7801E+06, 1.7825E+06, &
       1.7849E+06, 1.7873E+06, 1.7897E+06, 1.7921E+06, 1.7945E+06, 1.7969E+06, 1.7993E+06, 1.8018E+06, 1.8042E+06, 1.8066E+06, &
       1.8090E+06, 1.8115E+06, 1.8139E+06, 1.8164E+06, 1.8188E+06, 1.8212E+06, 1.8237E+06, 1.8261E+06, 1.8286E+06, 1.8310E+06, &
       1.8335E+06, 1.8359E+06, 1.8384E+06, 1.8409E+06, 1.8433E+06, 1.8458E+06, 1.8483E+06, 1.8507E+06, 1.8532E+06, 1.8557E+06, &
       1.8582E+06, 1.8606E+06, 1.8631E+06, 1.8656E+06, 1.8681E+06, 1.8706E+06, 1.8731E+06, 1.8756E+06, 1.8781E+06, 1.8806E+06, &
       1.8831E+06, 1.8856E+06, 1.8881E+06, 1.8906E+06, 1.8931E+06, 1.8956E+06, 1.8982E+06, 1.9007E+06, 1.9032E+06, 1.9057E+06, &
       1.9083E+06, 1.9108E+06, 1.9133E+06, 1.9159E+06, 1.9184E+06, 1.9209E+06, 1.9235E+06, 1.9260E+06, 1.9286E+06, 1.9311E+06, &
       1.9337E+06, 1.9362E+06, 1.9388E+06, 1.9414E+06, 1.9439E+06, 1.9465E+06, 1.9491E+06, 1.9516E+06, 1.9542E+06, 1.9568E+06, &
       1.9594E+06, 1.9620E+06, 1.9645E+06, 1.9671E+06, 1.9697E+06, 1.9723E+06, 1.9749E+06, 1.9775E+06, 1.9801E+06, 1.9827E+06, &
       1.9853E+06, 1.9879E+06, 1.9905E+06, 1.9932E+06, 1.9958E+06, 1.9984E+06, 2.0010E+06, 2.0036E+06, 2.0063E+06, 2.0089E+06, &
       2.0115E+06, 2.0142E+06, 2.0168E+06, 2.0194E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       272
      data (QofT( 9,J),J=1,2408)/ 3.6000E+01, 3.6009E+01, 3.6171E+01, 3.6792E+01, 3.8088E+01, 4.0132E+01, 4.2910E+01, 4.6367E+01, &
       5.0436E+01, 5.5054E+01, 6.0162E+01, 6.5711E+01, 7.1660E+01, 7.7974E+01, 8.4622E+01, 9.1580E+01, 9.8826E+01, 1.0634E+02, &
       1.1412E+02, 1.2213E+02, 1.3884E+02, 1.5640E+02, 1.7475E+02, 1.9384E+02, 2.1364E+02, 2.3410E+02, 2.5520E+02, 2.7693E+02, &
       2.9925E+02, 3.2216E+02, 3.4563E+02, 3.6966E+02, 3.9422E+02, 4.1931E+02, 4.4492E+02, 4.7103E+02, 4.9763E+02, 5.2473E+02, &
       5.5230E+02, 5.8034E+02, 6.0884E+02, 6.3780E+02, 6.6721E+02, 6.9706E+02, 7.2734E+02, 7.5805E+02, 7.8919E+02, 8.2074E+02, &
       8.5271E+02, 8.8508E+02, 9.1786E+02, 9.5103E+02, 9.8460E+02, 1.0186E+03, 1.0529E+03, 1.0876E+03, 1.1227E+03, 1.1582E+03, &
       1.1940E+03, 1.2302E+03, 1.2668E+03, 1.3037E+03, 1.3410E+03, 1.3786E+03, 1.4166E+03, 1.4549E+03, 1.4936E+03, 1.5326E+03, &
       1.5719E+03, 1.6116E+03, 1.6516E+03, 1.6919E+03, 1.7325E+03, 1.7735E+03, 1.8148E+03, 1.8564E+03, 1.8984E+03, 1.9406E+03, &
       1.9832E+03, 2.0261E+03, 2.0692E+03, 2.1127E+03, 2.1565E+03, 2.2006E+03, 2.2450E+03, 2.2897E+03, 2.3347E+03, 2.3799E+03, &
       2.4255E+03, 2.4714E+03, 2.5175E+03, 2.5640E+03, 2.6107E+03, 2.6577E+03, 2.7050E+03, 2.7526E+03, 2.8004E+03, 2.8486E+03, &
       2.8970E+03, 2.9457E+03, 2.9946E+03, 3.0439E+03, 3.0934E+03, 3.1432E+03, 3.1932E+03, 3.2436E+03, 3.2942E+03, 3.3450E+03, &
       3.3961E+03, 3.4475E+03, 3.4992E+03, 3.5511E+03, 3.6033E+03, 3.6558E+03, 3.7085E+03, 3.7614E+03, 3.8147E+03, 3.8682E+03, &
       3.9219E+03, 3.9759E+03, 4.0302E+03, 4.0847E+03, 4.1395E+03, 4.1945E+03, 4.2498E+03, 4.3054E+03, 4.3612E+03, 4.4172E+03, &
       4.4735E+03, 4.5301E+03, 4.5869E+03, 4.6440E+03, 4.7013E+03, 4.7589E+03, 4.8167E+03, 4.8748E+03, 4.9331E+03, 4.9917E+03, &
       5.0505E+03, 5.1096E+03, 5.1690E+03, 5.2285E+03, 5.2884E+03, 5.3485E+03, 5.4088E+03, 5.4694E+03, 5.5302E+03, 5.5913E+03, &
       5.6527E+03, 5.7143E+03, 5.7761E+03, 5.8382E+03, 5.9005E+03, 5.9631E+03, 6.0260E+03, 6.0891E+03, 6.1524E+03, 6.2160E+03, &
       6.2799E+03, 6.3440E+03, 6.4083E+03, 6.4729E+03, 6.5378E+03, 6.6029E+03, 6.6683E+03, 6.7339E+03, 6.7997E+03, 6.8659E+03, &
       6.9323E+03, 6.9989E+03, 7.0658E+03, 7.1329E+03, 7.2003E+03, 7.2680E+03, 7.3359E+03, 7.4040E+03, 7.4725E+03, 7.5411E+03, &
       7.6101E+03, 7.6793E+03, 7.7487E+03, 7.8184E+03, 7.8884E+03, 7.9587E+03, 8.0291E+03, 8.0999E+03, 8.1709E+03, 8.2422E+03, &
       8.3137E+03, 8.3855E+03, 8.4576E+03, 8.5299E+03, 8.6025E+03, 8.6753E+03, 8.7485E+03, 8.8218E+03, 8.8955E+03, 8.9694E+03, &
       9.0436E+03, 9.1180E+03, 9.1928E+03, 9.2677E+03, 9.3430E+03, 9.4185E+03, 9.4943E+03, 9.5704E+03, 9.6467E+03, 9.7233E+03, &
       9.8002E+03, 9.8774E+03, 9.9548E+03, 1.0032E+04, 1.0110E+04, 1.0189E+04, 1.0267E+04, 1.0346E+04, 1.0425E+04, 1.0505E+04, &
       1.0584E+04, 1.0664E+04, 1.0744E+04, 1.0825E+04, 1.0906E+04, 1.0987E+04, 1.1068E+04, 1.1149E+04, 1.1231E+04, 1.1314E+04, &
       1.1396E+04, 1.1479E+04, 1.1562E+04, 1.1645E+04, 1.1729E+04, 1.1813E+04, 1.1897E+04, 1.1981E+04, 1.2066E+04, 1.2151E+04, &
       1.2237E+04, 1.2322E+04, 1.2408E+04, 1.2494E+04, 1.2581E+04, 1.2668E+04, 1.2755E+04, 1.2842E+04, 1.2930E+04, 1.3018E+04, &
       1.3106E+04, 1.3195E+04, 1.3284E+04, 1.3373E+04, 1.3463E+04, 1.3552E+04, 1.3643E+04, 1.3733E+04, 1.3824E+04, 1.3915E+04, &
       1.4006E+04, 1.4098E+04, 1.4190E+04, 1.4282E+04, 1.4375E+04, 1.4468E+04, 1.4561E+04, 1.4654E+04, 1.4748E+04, 1.4843E+04, &
       1.4937E+04, 1.5032E+04, 1.5127E+04, 1.5222E+04, 1.5318E+04, 1.5414E+04, 1.5511E+04, 1.5607E+04, 1.5704E+04, 1.5802E+04, &
       1.5899E+04, 1.5997E+04, 1.6096E+04, 1.6194E+04, 1.6293E+04, 1.6393E+04, 1.6492E+04, 1.6592E+04, 1.6693E+04, 1.6793E+04, &
       1.6894E+04, 1.6996E+04, 1.7097E+04, 1.7199E+04, 1.7302E+04, 1.7404E+04, 1.7507E+04, 1.7611E+04, 1.7714E+04, 1.7819E+04, &
       1.7923E+04, 1.8028E+04, 1.8133E+04, 1.8238E+04, 1.8344E+04, 1.8450E+04, 1.8556E+04, 1.8663E+04, 1.8770E+04, 1.8878E+04, &
       1.8986E+04, 1.9094E+04, 1.9202E+04, 1.9311E+04, 1.9421E+04, 1.9530E+04, 1.9640E+04, 1.9751E+04, 1.9861E+04, 1.9972E+04, &
       2.0084E+04, 2.0196E+04, 2.0308E+04, 2.0420E+04, 2.0533E+04, 2.0647E+04, 2.0760E+04, 2.0874E+04, 2.0989E+04, 2.1103E+04, &
       2.1218E+04, 2.1334E+04, 2.1450E+04, 2.1566E+04, 2.1683E+04, 2.1800E+04, 2.1917E+04, 2.2035E+04, 2.2153E+04, 2.2271E+04, &
       2.2390E+04, 2.2510E+04, 2.2629E+04, 2.2749E+04, 2.2870E+04, 2.2991E+04, 2.3112E+04, 2.3233E+04, 2.3355E+04, 2.3478E+04, &
       2.3601E+04, 2.3724E+04, 2.3847E+04, 2.3971E+04, 2.4096E+04, 2.4221E+04, 2.4346E+04, 2.4471E+04, 2.4597E+04, 2.4724E+04, &
       2.4851E+04, 2.4978E+04, 2.5105E+04, 2.5233E+04, 2.5362E+04, 2.5491E+04, 2.5620E+04, 2.5750E+04, 2.5880E+04, 2.6010E+04, &
       2.6141E+04, 2.6272E+04, 2.6404E+04, 2.6536E+04, 2.6669E+04, 2.6802E+04, 2.6936E+04, 2.7069E+04, 2.7204E+04, 2.7338E+04, &
       2.7474E+04, 2.7609E+04, 2.7745E+04, 2.7882E+04, 2.8018E+04, 2.8156E+04, 2.8294E+04, 2.8432E+04, 2.8570E+04, 2.8709E+04, &
       2.8849E+04, 2.8989E+04, 2.9129E+04, 2.9270E+04, 2.9411E+04, 2.9553E+04, 2.9695E+04, 2.9838E+04, 2.9981E+04, 3.0125E+04, &
       3.0269E+04, 3.0413E+04, 3.0558E+04, 3.0703E+04, 3.0849E+04, 3.0995E+04, 3.1142E+04, 3.1289E+04, 3.1437E+04, 3.1585E+04, &
       3.1734E+04, 3.1883E+04, 3.2032E+04, 3.2182E+04, 3.2333E+04, 3.2484E+04, 3.2635E+04, 3.2787E+04, 3.2939E+04, 3.3092E+04, &
       3.3246E+04, 3.3399E+04, 3.3554E+04, 3.3709E+04, 3.3864E+04, 3.4020E+04, 3.4176E+04, 3.4332E+04, 3.4490E+04, 3.4647E+04, &
       3.4806E+04, 3.4964E+04, 3.5123E+04, 3.5283E+04, 3.5443E+04, 3.5604E+04, 3.5765E+04, 3.5927E+04, 3.6089E+04, 3.6252E+04, &
       3.6415E+04, 3.6579E+04, 3.6743E+04, 3.6907E+04, 3.7073E+04, 3.7238E+04, 3.7405E+04, 3.7571E+04, 3.7739E+04, 3.7906E+04, &
       3.8075E+04, 3.8244E+04, 3.8413E+04, 3.8583E+04, 3.8753E+04, 3.8924E+04, 3.9096E+04, 3.9268E+04, 3.9440E+04, 3.9613E+04, &
       3.9787E+04, 3.9961E+04, 4.0136E+04, 4.0311E+04, 4.0487E+04, 4.0663E+04, 4.0840E+04, 4.1017E+04, 4.1195E+04, 4.1373E+04, &
       4.1552E+04, 4.1732E+04, 4.1912E+04, 4.2093E+04, 4.2274E+04, 4.2456E+04, 4.2638E+04, 4.2821E+04, 4.3004E+04, 4.3188E+04, &
       4.3373E+04, 4.3558E+04, 4.3744E+04, 4.3930E+04, 4.4117E+04, 4.4304E+04, 4.4492E+04, 4.4681E+04, 4.4870E+04, 4.5060E+04, &
       4.5250E+04, 4.5441E+04, 4.5632E+04, 4.5824E+04, 4.6017E+04, 4.6210E+04, 4.6404E+04, 4.6598E+04, 4.6793E+04, 4.6988E+04, &
       4.7184E+04, 4.7381E+04, 4.7578E+04, 4.7776E+04, 4.7975E+04, 4.8174E+04, 4.8374E+04, 4.8574E+04, 4.8775E+04, 4.8976E+04, &
       4.9178E+04, 4.9381E+04, 4.9584E+04, 4.9788E+04, 4.9993E+04, 5.0198E+04, 5.0404E+04, 5.0610E+04, 5.0817E+04, 5.1025E+04, &
       5.1233E+04, 5.1442E+04, 5.1652E+04, 5.1862E+04, 5.2073E+04, 5.2284E+04, 5.2496E+04, 5.2709E+04, 5.2922E+04, 5.3136E+04, &
       5.3351E+04, 5.3566E+04, 5.3782E+04, 5.3998E+04, 5.4215E+04, 5.4433E+04, 5.4652E+04, 5.4871E+04, 5.5090E+04, 5.5311E+04, &
       5.5532E+04, 5.5754E+04, 5.5976E+04, 5.6199E+04, 5.6423E+04, 5.6647E+04, 5.6872E+04, 5.7098E+04, 5.7324E+04, 5.7551E+04, &
       5.7779E+04, 5.8007E+04, 5.8236E+04, 5.8466E+04, 5.8696E+04, 5.8927E+04, 5.9159E+04, 5.9391E+04, 5.9624E+04, 5.9858E+04, &
       6.0093E+04, 6.0328E+04, 6.0564E+04, 6.0800E+04, 6.1037E+04, 6.1275E+04, 6.1514E+04, 6.1753E+04, 6.1993E+04, 6.2234E+04, &
       6.2475E+04, 6.2718E+04, 6.2960E+04, 6.3204E+04, 6.3448E+04, 6.3693E+04, 6.3939E+04, 6.4185E+04, 6.4432E+04, 6.4680E+04, &
       6.4929E+04, 6.5178E+04, 6.5428E+04, 6.5679E+04, 6.5930E+04, 6.6182E+04, 6.6435E+04, 6.6689E+04, 6.6943E+04, 6.7199E+04, &
       6.7454E+04, 6.7711E+04, 6.7968E+04, 6.8226E+04, 6.8485E+04, 6.8745E+04, 6.9005E+04, 6.9266E+04, 6.9528E+04, 6.9791E+04, &
       7.0054E+04, 7.0318E+04, 7.0583E+04, 7.0848E+04, 7.1115E+04, 7.1382E+04, 7.1650E+04, 7.1918E+04, 7.2188E+04, 7.2458E+04, &
       7.2729E+04, 7.3001E+04, 7.3273E+04, 7.3547E+04, 7.3821E+04, 7.4095E+04, 7.4371E+04, 7.4648E+04, 7.4925E+04, 7.5203E+04, &
       7.5482E+04, 7.5761E+04, 7.6042E+04, 7.6323E+04, 7.6605E+04, 7.6887E+04, 7.7171E+04, 7.7455E+04, 7.7741E+04, 7.8027E+04, &
       7.8313E+04, 7.8601E+04, 7.8889E+04, 7.9179E+04, 7.9469E+04, 7.9760E+04, 8.0051E+04, 8.0344E+04, 8.0637E+04, 8.0931E+04, &
       8.1226E+04, 8.1522E+04, 8.1819E+04, 8.2116E+04, 8.2415E+04, 8.2714E+04, 8.3014E+04, 8.3314E+04, 8.3616E+04, 8.3919E+04, &
       8.4222E+04, 8.4526E+04, 8.4831E+04, 8.5137E+04, 8.5444E+04, 8.5752E+04, 8.6060E+04, 8.6369E+04, 8.6680E+04, 8.6991E+04, &
       8.7303E+04, 8.7615E+04, 8.7929E+04, 8.8244E+04, 8.8559E+04, 8.8875E+04, 8.9192E+04, 8.9510E+04, 8.9829E+04, 9.0149E+04, &
       9.0470E+04, 9.0791E+04, 9.1114E+04, 9.1437E+04, 9.1761E+04, 9.2087E+04, 9.2413E+04, 9.2739E+04, 9.3067E+04, 9.3396E+04, &
       9.3726E+04, 9.4056E+04, 9.4388E+04, 9.4720E+04, 9.5053E+04, 9.5387E+04, 9.5722E+04, 9.6058E+04, 9.6395E+04, 9.6733E+04, &
       9.7072E+04, 9.7412E+04, 9.7752E+04, 9.8094E+04, 9.8436E+04, 9.8780E+04, 9.9124E+04, 9.9469E+04, 9.9816E+04, 1.0016E+05, &
       1.0051E+05, 1.0086E+05, 1.0121E+05, 1.0156E+05, 1.0191E+05, 1.0227E+05, 1.0262E+05, 1.0297E+05, 1.0333E+05, 1.0369E+05, &
       1.0404E+05, 1.0440E+05, 1.0476E+05, 1.0512E+05, 1.0548E+05, 1.0585E+05, 1.0621E+05, 1.0658E+05, 1.0694E+05, 1.0731E+05, &
       1.0767E+05, 1.0804E+05, 1.0841E+05, 1.0878E+05, 1.0915E+05, 1.0953E+05, 1.0990E+05, 1.1027E+05, 1.1065E+05, 1.1103E+05, &
       1.1140E+05, 1.1178E+05, 1.1216E+05, 1.1254E+05, 1.1292E+05, 1.1330E+05, 1.1369E+05, 1.1407E+05, 1.1446E+05, 1.1484E+05, &
       1.1523E+05, 1.1562E+05, 1.1601E+05, 1.1640E+05, 1.1679E+05, 1.1719E+05, 1.1758E+05, 1.1797E+05, 1.1837E+05, 1.1877E+05, &
       1.1916E+05, 1.1956E+05, 1.1996E+05, 1.2036E+05, 1.2077E+05, 1.2117E+05, 1.2157E+05, 1.2198E+05, 1.2239E+05, 1.2279E+05, &
       1.2320E+05, 1.2361E+05, 1.2402E+05, 1.2443E+05, 1.2485E+05, 1.2526E+05, 1.2568E+05, 1.2609E+05, 1.2651E+05, 1.2693E+05, &
       1.2735E+05, 1.2777E+05, 1.2819E+05, 1.2861E+05, 1.2903E+05, 1.2946E+05, 1.2988E+05, 1.3031E+05, 1.3074E+05, 1.3117E+05, &
       1.3160E+05, 1.3203E+05, 1.3246E+05, 1.3290E+05, 1.3333E+05, 1.3377E+05, 1.3421E+05, 1.3464E+05, 1.3508E+05, 1.3552E+05, &
       1.3596E+05, 1.3641E+05, 1.3685E+05, 1.3730E+05, 1.3774E+05, 1.3819E+05, 1.3864E+05, 1.3909E+05, 1.3954E+05, 1.3999E+05, &
       1.4044E+05, 1.4090E+05, 1.4135E+05, 1.4181E+05, 1.4227E+05, 1.4273E+05, 1.4319E+05, 1.4365E+05, 1.4411E+05, 1.4457E+05, &
       1.4504E+05, 1.4550E+05, 1.4597E+05, 1.4644E+05, 1.4691E+05, 1.4738E+05, 1.4785E+05, 1.4833E+05, 1.4880E+05, 1.4928E+05, &
       1.4975E+05, 1.5023E+05, 1.5071E+05, 1.5119E+05, 1.5167E+05, 1.5215E+05, 1.5264E+05, 1.5312E+05, 1.5361E+05, 1.5410E+05, &
       1.5459E+05, 1.5508E+05, 1.5557E+05, 1.5606E+05, 1.5655E+05, 1.5705E+05, 1.5755E+05, 1.5804E+05, 1.5854E+05, 1.5904E+05, &
       1.5954E+05, 1.6005E+05, 1.6055E+05, 1.6106E+05, 1.6156E+05, 1.6207E+05, 1.6258E+05, 1.6309E+05, 1.6360E+05, 1.6411E+05, &
       1.6463E+05, 1.6514E+05, 1.6566E+05, 1.6618E+05, 1.6670E+05, 1.6722E+05, 1.6774E+05, 1.6826E+05, 1.6879E+05, 1.6931E+05, &
       1.6984E+05, 1.7037E+05, 1.7090E+05, 1.7143E+05, 1.7196E+05, 1.7249E+05, 1.7303E+05, 1.7356E+05, 1.7410E+05, 1.7464E+05, &
       1.7518E+05, 1.7572E+05, 1.7626E+05, 1.7681E+05, 1.7735E+05, 1.7790E+05, 1.7845E+05, 1.7900E+05, 1.7955E+05, 1.8010E+05, &
       1.8065E+05, 1.8121E+05, 1.8177E+05, 1.8232E+05, 1.8288E+05, 1.8344E+05, 1.8400E+05, 1.8457E+05, 1.8513E+05, 1.8570E+05, &
       1.8627E+05, 1.8683E+05, 1.8740E+05, 1.8797E+05, 1.8855E+05, 1.8912E+05, 1.8970E+05, 1.9027E+05, 1.9085E+05, 1.9143E+05, &
       1.9201E+05, 1.9260E+05, 1.9318E+05, 1.9377E+05, 1.9435E+05, 1.9494E+05, 1.9553E+05, 1.9612E+05, 1.9671E+05, 1.9731E+05, &
       1.9790E+05, 1.9850E+05, 1.9910E+05, 1.9970E+05, 2.0030E+05, 2.0090E+05, 2.0150E+05, 2.0211E+05, 2.0272E+05, 2.0332E+05, &
       2.0393E+05, 2.0455E+05, 2.0516E+05, 2.0577E+05, 2.0639E+05, 2.0701E+05, 2.0762E+05, 2.0824E+05, 2.0887E+05, 2.0949E+05, &
       2.1011E+05, 2.1074E+05, 2.1137E+05, 2.1199E+05, 2.1263E+05, 2.1326E+05, 2.1389E+05, 2.1453E+05, 2.1516E+05, 2.1580E+05, &
       2.1644E+05, 2.1708E+05, 2.1772E+05, 2.1837E+05, 2.1901E+05, 2.1966E+05, 2.2031E+05, 2.2096E+05, 2.2161E+05, 2.2226E+05, &
       2.2292E+05, 2.2357E+05, 2.2423E+05, 2.2489E+05, 2.2555E+05, 2.2621E+05, 2.2688E+05, 2.2754E+05, 2.2821E+05, 2.2888E+05, &
       2.2955E+05, 2.3022E+05, 2.3089E+05, 2.3157E+05, 2.3225E+05, 2.3292E+05, 2.3360E+05, 2.3429E+05, 2.3497E+05, 2.3565E+05, &
       2.3634E+05, 2.3703E+05, 2.3772E+05, 2.3841E+05, 2.3910E+05, 2.3979E+05, 2.4049E+05, 2.4119E+05, 2.4189E+05, 2.4259E+05, &
       2.4329E+05, 2.4399E+05, 2.4470E+05, 2.4540E+05, 2.4611E+05, 2.4682E+05, 2.4754E+05, 2.4825E+05, 2.4896E+05, 2.4968E+05, &
       2.5040E+05, 2.5112E+05, 2.5184E+05, 2.5257E+05, 2.5329E+05, 2.5402E+05, 2.5475E+05, 2.5548E+05, 2.5621E+05, 2.5694E+05, &
       2.5768E+05, 2.5841E+05, 2.5915E+05, 2.5989E+05, 2.6063E+05, 2.6138E+05, 2.6212E+05, 2.6287E+05, 2.6362E+05, 2.6437E+05, &
       2.6512E+05, 2.6588E+05, 2.6663E+05, 2.6739E+05, 2.6815E+05, 2.6891E+05, 2.6967E+05, 2.7044E+05, 2.7120E+05, 2.7197E+05, &
       2.7274E+05, 2.7351E+05, 2.7428E+05, 2.7506E+05, 2.7583E+05, 2.7661E+05, 2.7739E+05, 2.7817E+05, 2.7896E+05, 2.7974E+05, &
       2.8053E+05, 2.8132E+05, 2.8211E+05, 2.8290E+05, 2.8370E+05, 2.8449E+05, 2.8529E+05, 2.8609E+05, 2.8689E+05, 2.8769E+05, &
       2.8850E+05, 2.8931E+05, 2.9011E+05, 2.9092E+05, 2.9174E+05, 2.9255E+05, 2.9337E+05, 2.9418E+05, 2.9500E+05, 2.9582E+05, &
       2.9665E+05, 2.9747E+05, 2.9830E+05, 2.9913E+05, 2.9996E+05, 3.0079E+05, 3.0163E+05, 3.0246E+05, 3.0330E+05, 3.0414E+05, &
       3.0498E+05, 3.0582E+05, 3.0667E+05, 3.0752E+05, 3.0837E+05, 3.0922E+05, 3.1007E+05, 3.1092E+05, 3.1178E+05, 3.1264E+05, &
       3.1350E+05, 3.1436E+05, 3.1523E+05, 3.1609E+05, 3.1696E+05, 3.1783E+05, 3.1870E+05, 3.1958E+05, 3.2045E+05, 3.2133E+05, &
       3.2221E+05, 3.2309E+05, 3.2397E+05, 3.2486E+05, 3.2575E+05, 3.2664E+05, 3.2753E+05, 3.2842E+05, 3.2932E+05, 3.3021E+05, &
       3.3111E+05, 3.3201E+05, 3.3292E+05, 3.3382E+05, 3.3473E+05, 3.3564E+05, 3.3655E+05, 3.3746E+05, 3.3837E+05, 3.3929E+05, &
       3.4021E+05, 3.4113E+05, 3.4205E+05, 3.4298E+05, 3.4391E+05, 3.4483E+05, 3.4577E+05, 3.4670E+05, 3.4763E+05, 3.4857E+05, &
       3.4951E+05, 3.5045E+05, 3.5139E+05, 3.5234E+05, 3.5328E+05, 3.5423E+05, 3.5519E+05, 3.5614E+05, 3.5709E+05, 3.5805E+05, &
       3.5901E+05, 3.5997E+05, 3.6094E+05, 3.6190E+05, 3.6287E+05, 3.6384E+05, 3.6481E+05, 3.6578E+05, 3.6676E+05, 3.6774E+05, &
       3.6872E+05, 3.6970E+05, 3.7068E+05, 3.7167E+05, 3.7266E+05, 3.7365E+05, 3.7464E+05, 3.7564E+05, 3.7663E+05, 3.7763E+05, &
       3.7863E+05, 3.7964E+05, 3.8064E+05, 3.8165E+05, 3.8266E+05, 3.8367E+05, 3.8469E+05, 3.8570E+05, 3.8672E+05, 3.8774E+05, &
       3.8877E+05, 3.8979E+05, 3.9082E+05, 3.9185E+05, 3.9288E+05, 3.9391E+05, 3.9495E+05, 3.9599E+05, 3.9703E+05, 3.9807E+05, &
       3.9911E+05, 4.0016E+05, 4.0121E+05, 4.0226E+05, 4.0331E+05, 4.0437E+05, 4.0543E+05, 4.0649E+05, 4.0755E+05, 4.0861E+05, &
       4.0968E+05, 4.1075E+05, 4.1182E+05, 4.1289E+05, 4.1397E+05, 4.1505E+05, 4.1613E+05, 4.1721E+05, 4.1829E+05, 4.1938E+05, &
       4.2047E+05, 4.2156E+05, 4.2266E+05, 4.2375E+05, 4.2485E+05, 4.2595E+05, 4.2705E+05, 4.2816E+05, 4.2927E+05, 4.3038E+05, &
       4.3149E+05, 4.3260E+05, 4.3372E+05, 4.3484E+05, 4.3596E+05, 4.3708E+05, 4.3821E+05, 4.3934E+05, 4.4047E+05, 4.4160E+05, &
       4.4274E+05, 4.4387E+05, 4.4501E+05, 4.4616E+05, 4.4730E+05, 4.4845E+05, 4.4960E+05, 4.5075E+05, 4.5190E+05, 4.5306E+05, &
       4.5422E+05, 4.5538E+05, 4.5655E+05, 4.5771E+05, 4.5888E+05, 4.6005E+05, 4.6122E+05, 4.6240E+05, 4.6358E+05, 4.6476E+05, &
       4.6594E+05, 4.6713E+05, 4.6831E+05, 4.6950E+05, 4.7070E+05, 4.7189E+05, 4.7309E+05, 4.7429E+05, 4.7549E+05, 4.7670E+05, &
       4.7790E+05, 4.7911E+05, 4.8033E+05, 4.8154E+05, 4.8276E+05, 4.8398E+05, 4.8520E+05, 4.8643E+05, 4.8765E+05, 4.8888E+05, &
       4.9011E+05, 4.9135E+05, 4.9259E+05, 4.9383E+05, 4.9507E+05, 4.9631E+05, 4.9756E+05, 4.9881E+05, 5.0006E+05, 5.0132E+05, &
       5.0257E+05, 5.0383E+05, 5.0509E+05, 5.0636E+05, 5.0763E+05, 5.0890E+05, 5.1017E+05, 5.1144E+05, 5.1272E+05, 5.1400E+05, &
       5.1528E+05, 5.1657E+05, 5.1786E+05, 5.1915E+05, 5.2044E+05, 5.2174E+05, 5.2304E+05, 5.2434E+05, 5.2564E+05, 5.2695E+05, &
       5.2825E+05, 5.2957E+05, 5.3088E+05, 5.3220E+05, 5.3352E+05, 5.3484E+05, 5.3616E+05, 5.3749E+05, 5.3882E+05, 5.4015E+05, &
       5.4148E+05, 5.4282E+05, 5.4416E+05, 5.4551E+05, 5.4685E+05, 5.4820E+05, 5.4955E+05, 5.5090E+05, 5.5226E+05, 5.5362E+05, &
       5.5498E+05, 5.5635E+05, 5.5771E+05, 5.5908E+05, 5.6045E+05, 5.6183E+05, 5.6321E+05, 5.6459E+05, 5.6597E+05, 5.6736E+05, &
       5.6875E+05, 5.7014E+05, 5.7153E+05, 5.7293E+05, 5.7433E+05, 5.7573E+05, 5.7714E+05, 5.7854E+05, 5.7996E+05, 5.8137E+05, &
       5.8278E+05, 5.8420E+05, 5.8563E+05, 5.8705E+05, 5.8848E+05, 5.8991E+05, 5.9134E+05, 5.9278E+05, 5.9422E+05, 5.9566E+05, &
       5.9710E+05, 5.9855E+05, 6.0000E+05, 6.0145E+05, 6.0291E+05, 6.0436E+05, 6.0583E+05, 6.0729E+05, 6.0876E+05, 6.1023E+05, &
       6.1170E+05, 6.1317E+05, 6.1465E+05, 6.1613E+05, 6.1762E+05, 6.1910E+05, 6.2059E+05, 6.2209E+05, 6.2358E+05, 6.2508E+05, &
       6.2658E+05, 6.2809E+05, 6.2959E+05, 6.3110E+05, 6.3262E+05, 6.3413E+05, 6.3565E+05, 6.3717E+05, 6.3870E+05, 6.4023E+05, &
       6.4176E+05, 6.4329E+05, 6.4483E+05, 6.4636E+05, 6.4791E+05, 6.4945E+05, 6.5100E+05, 6.5255E+05, 6.5411E+05, 6.5566E+05, &
       6.5722E+05, 6.5879E+05, 6.6035E+05, 6.6192E+05, 6.6349E+05, 6.6507E+05, 6.6665E+05, 6.6823E+05, 6.6981E+05, 6.7140E+05, &
       6.7299E+05, 6.7458E+05, 6.7618E+05, 6.7778E+05, 6.7938E+05, 6.8099E+05, 6.8260E+05, 6.8421E+05, 6.8582E+05, 6.8744E+05, &
       6.8906E+05, 6.9068E+05, 6.9231E+05, 6.9394E+05, 6.9557E+05, 6.9721E+05, 6.9885E+05, 7.0049E+05, 7.0214E+05, 7.0378E+05, &
       7.0544E+05, 7.0709E+05, 7.0875E+05, 7.1041E+05, 7.1207E+05, 7.1374E+05, 7.1541E+05, 7.1709E+05, 7.1876E+05, 7.2044E+05, &
       7.2213E+05, 7.2381E+05, 7.2550E+05, 7.2719E+05, 7.2889E+05, 7.3059E+05, 7.3229E+05, 7.3400E+05, 7.3570E+05, 7.3742E+05, &
       7.3913E+05, 7.4085E+05, 7.4257E+05, 7.4429E+05, 7.4602E+05, 7.4775E+05, 7.4949E+05, 7.5122E+05, 7.5297E+05, 7.5471E+05, &
       7.5646E+05, 7.5821E+05, 7.5996E+05, 7.6172E+05, 7.6348E+05, 7.6524E+05, 7.6701E+05, 7.6878E+05, 7.7055E+05, 7.7233E+05, &
       7.7411E+05, 7.7589E+05, 7.7768E+05, 7.7947E+05, 7.8126E+05, 7.8306E+05, 7.8486E+05, 7.8666E+05, 7.8847E+05, 7.9028E+05, &
       7.9209E+05, 7.9391E+05, 7.9573E+05, 7.9755E+05, 7.9938E+05, 8.0121E+05, 8.0304E+05, 8.0488E+05, 8.0672E+05, 8.0856E+05, &
       8.1041E+05, 8.1226E+05, 8.1411E+05, 8.1597E+05, 8.1783E+05, 8.1969E+05, 8.2156E+05, 8.2343E+05, 8.2530E+05, 8.2718E+05, &
       8.2906E+05, 8.3095E+05, 8.3284E+05, 8.3473E+05, 8.3662E+05, 8.3852E+05, 8.4042E+05, 8.4233E+05, 8.4424E+05, 8.4615E+05, &
       8.4806E+05, 8.4998E+05, 8.5191E+05, 8.5383E+05, 8.5576E+05, 8.5769E+05, 8.5963E+05, 8.6157E+05, 8.6352E+05, 8.6546E+05, &
       8.6741E+05, 8.6937E+05, 8.7133E+05, 8.7329E+05, 8.7525E+05, 8.7722E+05, 8.7919E+05, 8.8117E+05, 8.8315E+05, 8.8513E+05, &
       8.8712E+05, 8.8911E+05, 8.9110E+05, 8.9310E+05, 8.9510E+05, 8.9710E+05, 8.9911E+05, 9.0112E+05, 9.0314E+05, 9.0516E+05, &
       9.0718E+05, 9.0921E+05, 9.1124E+05, 9.1327E+05, 9.1531E+05, 9.1735E+05, 9.1939E+05, 9.2144E+05, 9.2349E+05, 9.2555E+05, &
       9.2761E+05, 9.2967E+05, 9.3174E+05, 9.3381E+05, 9.3588E+05, 9.3796E+05, 9.4004E+05, 9.4212E+05, 9.4421E+05, 9.4630E+05, &
       9.4840E+05, 9.5050E+05, 9.5260E+05, 9.5471E+05, 9.5682E+05, 9.5894E+05, 9.6106E+05, 9.6318E+05, 9.6531E+05, 9.6744E+05, &
       9.6957E+05, 9.7171E+05, 9.7385E+05, 9.7599E+05, 9.7814E+05, 9.8030E+05, 9.8245E+05, 9.8461E+05, 9.8678E+05, 9.8895E+05, &
       9.9112E+05, 9.9329E+05, 9.9547E+05, 9.9766E+05, 9.9984E+05, 1.0020E+06, 1.0042E+06, 1.0064E+06, 1.0086E+06, 1.0108E+06, &
       1.0131E+06, 1.0153E+06, 1.0175E+06, 1.0197E+06, 1.0219E+06, 1.0242E+06, 1.0264E+06, 1.0286E+06, 1.0309E+06, 1.0331E+06, &
       1.0354E+06, 1.0376E+06, 1.0399E+06, 1.0421E+06, 1.0444E+06, 1.0467E+06, 1.0490E+06, 1.0512E+06, 1.0535E+06, 1.0558E+06, &
       1.0581E+06, 1.0604E+06, 1.0627E+06, 1.0650E+06, 1.0673E+06, 1.0696E+06, 1.0719E+06, 1.0742E+06, 1.0765E+06, 1.0789E+06, &
       1.0812E+06, 1.0835E+06, 1.0859E+06, 1.0882E+06, 1.0906E+06, 1.0929E+06, 1.0953E+06, 1.0976E+06, 1.1000E+06, 1.1024E+06, &
       1.1047E+06, 1.1071E+06, 1.1095E+06, 1.1119E+06, 1.1142E+06, 1.1166E+06, 1.1190E+06, 1.1214E+06, 1.1238E+06, 1.1262E+06, &
       1.1287E+06, 1.1311E+06, 1.1335E+06, 1.1359E+06, 1.1383E+06, 1.1408E+06, 1.1432E+06, 1.1457E+06, 1.1481E+06, 1.1505E+06, &
       1.1530E+06, 1.1555E+06, 1.1579E+06, 1.1604E+06, 1.1629E+06, 1.1653E+06, 1.1678E+06, 1.1703E+06, 1.1728E+06, 1.1753E+06, &
       1.1778E+06, 1.1803E+06, 1.1828E+06, 1.1853E+06, 1.1878E+06, 1.1903E+06, 1.1928E+06, 1.1954E+06, 1.1979E+06, 1.2004E+06, &
       1.2030E+06, 1.2055E+06, 1.2081E+06, 1.2106E+06, 1.2132E+06, 1.2157E+06, 1.2183E+06, 1.2209E+06, 1.2234E+06, 1.2260E+06, &
       1.2286E+06, 1.2312E+06, 1.2338E+06, 1.2364E+06, 1.2390E+06, 1.2416E+06, 1.2442E+06, 1.2468E+06, 1.2494E+06, 1.2520E+06, &
       1.2547E+06, 1.2573E+06, 1.2599E+06, 1.2626E+06, 1.2652E+06, 1.2679E+06, 1.2705E+06, 1.2732E+06, 1.2758E+06, 1.2785E+06, &
       1.2812E+06, 1.2838E+06, 1.2865E+06, 1.2892E+06, 1.2919E+06, 1.2946E+06, 1.2973E+06, 1.3000E+06, 1.3027E+06, 1.3054E+06, &
       1.3081E+06, 1.3109E+06, 1.3136E+06, 1.3163E+06, 1.3190E+06, 1.3218E+06, 1.3245E+06, 1.3273E+06, 1.3300E+06, 1.3328E+06, &
       1.3355E+06, 1.3383E+06, 1.3411E+06, 1.3439E+06, 1.3466E+06, 1.3494E+06, 1.3522E+06, 1.3550E+06, 1.3578E+06, 1.3606E+06, &
       1.3634E+06, 1.3662E+06, 1.3691E+06, 1.3719E+06, 1.3747E+06, 1.3775E+06, 1.3804E+06, 1.3832E+06, 1.3861E+06, 1.3889E+06, &
       1.3918E+06, 1.3946E+06, 1.3975E+06, 1.4004E+06, 1.4032E+06, 1.4061E+06, 1.4090E+06, 1.4119E+06, 1.4148E+06, 1.4177E+06, &
       1.4206E+06, 1.4235E+06, 1.4264E+06, 1.4293E+06, 1.4322E+06, 1.4352E+06, 1.4381E+06, 1.4410E+06, 1.4440E+06, 1.4469E+06, &
       1.4499E+06, 1.4528E+06, 1.4558E+06, 1.4588E+06, 1.4617E+06, 1.4647E+06, 1.4677E+06, 1.4707E+06, 1.4737E+06, 1.4767E+06, &
       1.4797E+06, 1.4827E+06, 1.4857E+06, 1.4887E+06, 1.4917E+06, 1.4947E+06, 1.4978E+06, 1.5008E+06, 1.5038E+06, 1.5069E+06, &
       1.5099E+06, 1.5130E+06, 1.5160E+06, 1.5191E+06, 1.5222E+06, 1.5252E+06, 1.5283E+06, 1.5314E+06, 1.5345E+06, 1.5376E+06, &
       1.5407E+06, 1.5438E+06, 1.5469E+06, 1.5500E+06, 1.5531E+06, 1.5563E+06, 1.5594E+06, 1.5625E+06, 1.5657E+06, 1.5688E+06, &
       1.5720E+06, 1.5751E+06, 1.5783E+06, 1.5814E+06, 1.5846E+06, 1.5878E+06, 1.5910E+06, 1.5942E+06, 1.5973E+06, 1.6005E+06, &
       1.6037E+06, 1.6069E+06, 1.6102E+06, 1.6134E+06, 1.6166E+06, 1.6198E+06, 1.6231E+06, 1.6263E+06, 1.6295E+06, 1.6328E+06, &
       1.6360E+06, 1.6393E+06, 1.6426E+06, 1.6458E+06, 1.6491E+06, 1.6524E+06, 1.6557E+06, 1.6589E+06, 1.6622E+06, 1.6655E+06, &
       1.6688E+06, 1.6722E+06, 1.6755E+06, 1.6788E+06, 1.6821E+06, 1.6855E+06, 1.6888E+06, 1.6921E+06, 1.6955E+06, 1.6988E+06, &
       1.7022E+06, 1.7056E+06, 1.7089E+06, 1.7123E+06, 1.7157E+06, 1.7191E+06, 1.7225E+06, 1.7259E+06, 1.7293E+06, 1.7327E+06, &
       1.7361E+06, 1.7395E+06, 1.7429E+06, 1.7463E+06, 1.7498E+06, 1.7532E+06, 1.7567E+06, 1.7601E+06, 1.7636E+06, 1.7670E+06, &
       1.7705E+06, 1.7740E+06, 1.7774E+06, 1.7809E+06, 1.7844E+06, 1.7879E+06, 1.7914E+06, 1.7949E+06, 1.7984E+06, 1.8019E+06, &
       1.8055E+06, 1.8090E+06, 1.8125E+06, 1.8161E+06, 1.8196E+06, 1.8231E+06, 1.8267E+06, 1.8303E+06, 1.8338E+06, 1.8374E+06, &
       1.8410E+06, 1.8446E+06, 1.8482E+06, 1.8517E+06, 1.8553E+06, 1.8589E+06, 1.8626E+06, 1.8662E+06, 1.8698E+06, 1.8734E+06, &
       1.8771E+06, 1.8807E+06, 1.8843E+06, 1.8880E+06, 1.8917E+06, 1.8953E+06, 1.8990E+06, 1.9027E+06, 1.9063E+06, 1.9100E+06, &
       1.9137E+06, 1.9174E+06, 1.9211E+06, 1.9248E+06, 1.9285E+06, 1.9322E+06, 1.9360E+06, 1.9397E+06, 1.9434E+06, 1.9472E+06, &
       1.9509E+06, 1.9547E+06, 1.9584E+06, 1.9622E+06, 1.9660E+06, 1.9698E+06, 1.9735E+06, 1.9773E+06, 1.9811E+06, 1.9849E+06, &
       1.9887E+06, 1.9925E+06, 1.9964E+06, 2.0002E+06, 2.0040E+06, 2.0079E+06, 2.0117E+06, 2.0155E+06, 2.0194E+06, 2.0233E+06, &
       2.0271E+06, 2.0310E+06, 2.0349E+06, 2.0388E+06, 2.0426E+06, 2.0465E+06, 2.0504E+06, 2.0544E+06, 2.0583E+06, 2.0622E+06, &
       2.0661E+06, 2.0700E+06, 2.0740E+06, 2.0779E+06, 2.0819E+06, 2.0858E+06, 2.0898E+06, 2.0938E+06, 2.0977E+06, 2.1017E+06, &
       2.1057E+06, 2.1097E+06, 2.1137E+06, 2.1177E+06, 2.1217E+06, 2.1257E+06, 2.1297E+06, 2.1338E+06, 2.1378E+06, 2.1418E+06, &
       2.1459E+06, 2.1499E+06, 2.1540E+06, 2.1581E+06, 2.1621E+06, 2.1662E+06, 2.1703E+06, 2.1744E+06, 2.1785E+06, 2.1826E+06, &
       2.1867E+06, 2.1908E+06, 2.1949E+06, 2.1991E+06, 2.2032E+06, 2.2073E+06, 2.2115E+06, 2.2156E+06, 2.2198E+06, 2.2240E+06, &
       2.2281E+06, 2.2323E+06, 2.2365E+06, 2.2407E+06, 2.2449E+06, 2.2491E+06, 2.2533E+06, 2.2575E+06, 2.2617E+06, 2.2659E+06, &
       2.2702E+06, 2.2744E+06, 2.2787E+06, 2.2829E+06, 2.2872E+06, 2.2915E+06, 2.2957E+06, 2.3000E+06, 2.3043E+06, 2.3086E+06, &
       2.3129E+06, 2.3172E+06, 2.3215E+06, 2.3258E+06, 2.3301E+06, 2.3345E+06, 2.3388E+06, 2.3431E+06, 2.3475E+06, 2.3519E+06, &
       2.3562E+06, 2.3606E+06, 2.3650E+06, 2.3693E+06, 2.3737E+06, 2.3781E+06, 2.3825E+06, 2.3869E+06, 2.3914E+06, 2.3958E+06, &
       2.4002E+06, 2.4046E+06, 2.4091E+06, 2.4135E+06, 2.4180E+06, 2.4224E+06, 2.4269E+06, 2.4314E+06, 2.4359E+06, 2.4404E+06, &
       2.4448E+06, 2.4494E+06, 2.4539E+06, 2.4584E+06, 2.4629E+06, 2.4674E+06, 2.4720E+06, 2.4765E+06, 2.4810E+06, 2.4856E+06, &
       2.4902E+06, 2.4947E+06, 2.4993E+06, 2.5039E+06, 2.5085E+06, 2.5131E+06, 2.5177E+06, 2.5223E+06, 2.5269E+06, 2.5315E+06, &
       2.5361E+06, 2.5408E+06, 2.5454E+06, 2.5501E+06, 2.5547E+06, 2.5594E+06, 2.5641E+06, 2.5687E+06, 2.5734E+06, 2.5781E+06, &
       2.5828E+06, 2.5875E+06, 2.5922E+06, 2.5969E+06, 2.6017E+06, 2.6064E+06, 2.6111E+06, 2.6159E+06, 2.6206E+06, 2.6254E+06, &
       2.6302E+06, 2.6349E+06, 2.6397E+06, 2.6445E+06, 2.6493E+06, 2.6541E+06, 2.6589E+06, 2.6637E+06, 2.6685E+06, 2.6734E+06, &
       2.6782E+06, 2.6830E+06, 2.6879E+06, 2.6927E+06, 2.6976E+06, 2.7025E+06, 2.7074E+06, 2.7122E+06, 2.7171E+06, 2.7220E+06, &
       2.7269E+06, 2.7319E+06, 2.7368E+06, 2.7417E+06, 2.7466E+06, 2.7516E+06, 2.7565E+06, 2.7615E+06, 2.7664E+06, 2.7714E+06, &
       2.7764E+06, 2.7814E+06, 2.7864E+06, 2.7914E+06, 2.7964E+06, 2.8014E+06, 2.8064E+06, 2.8114E+06, 2.8165E+06, 2.8215E+06, &
       2.8266E+06, 2.8316E+06, 2.8367E+06, 2.8418E+06, 2.8468E+06, 2.8519E+06, 2.8570E+06, 2.8621E+06, 2.8672E+06, 2.8723E+06, &
       2.8775E+06, 2.8826E+06, 2.8877E+06, 2.8929E+06, 2.8980E+06, 2.9032E+06, 2.9084E+06, 2.9135E+06, 2.9187E+06, 2.9239E+06, &
       2.9291E+06, 2.9343E+06, 2.9395E+06, 2.9447E+06, 2.9499E+06, 2.9552E+06, 2.9604E+06, 2.9657E+06, 2.9709E+06, 2.9762E+06, &
       2.9815E+06, 2.9867E+06, 2.9920E+06, 2.9973E+06, 3.0026E+06, 3.0079E+06, 3.0132E+06, 3.0186E+06, 3.0239E+06, 3.0292E+06, &
       3.0346E+06, 3.0399E+06, 3.0453E+06, 3.0507E+06, 3.0560E+06, 3.0614E+06, 3.0668E+06, 3.0722E+06, 3.0776E+06, 3.0830E+06, &
       3.0884E+06, 3.0939E+06, 3.0993E+06, 3.1048E+06, 3.1102E+06, 3.1157E+06, 3.1211E+06, 3.1266E+06, 3.1321E+06, 3.1376E+06, &
       3.1431E+06, 3.1486E+06, 3.1541E+06, 3.1596E+06, 3.1651E+06, 3.1707E+06, 3.1762E+06, 3.1818E+06, 3.1873E+06, 3.1929E+06, &
       3.1985E+06, 3.2041E+06, 3.2097E+06, 3.2153E+06, 3.2209E+06, 3.2265E+06, 3.2321E+06, 3.2377E+06, 3.2434E+06, 3.2490E+06, &
       3.2547E+06, 3.2603E+06, 3.2660E+06, 3.2717E+06, 3.2774E+06, 3.2831E+06, 3.2888E+06, 3.2945E+06, 3.3002E+06, 3.3059E+06, &
       3.3116E+06, 3.3174E+06, 3.3231E+06, 3.3289E+06, 3.3346E+06, 3.3404E+06, 3.3462E+06, 3.3520E+06, 3.3578E+06, 3.3636E+06, &
       3.3694E+06, 3.3752E+06, 3.3810E+06, 3.3869E+06, 3.3927E+06, 3.3986E+06, 3.4044E+06, 3.4103E+06, 3.4162E+06, 3.4221E+06, &
       3.4280E+06, 3.4339E+06, 3.4398E+06, 3.4457E+06, 3.4516E+06, 3.4576E+06, 3.4635E+06, 3.4694E+06, 3.4754E+06, 3.4814E+06, &
       3.4873E+06, 3.4933E+06, 3.4993E+06, 3.5053E+06, 3.5113E+06, 3.5173E+06, 3.5234E+06, 3.5294E+06, 3.5354E+06, 3.5415E+06, &
       3.5475E+06, 3.5536E+06, 3.5597E+06, 3.5658E+06, 3.5719E+06, 3.5780E+06, 3.5841E+06, 3.5902E+06, 3.5963E+06, 3.6024E+06, &
       3.6086E+06, 3.6147E+06, 3.6209E+06, 3.6270E+06, 3.6332E+06, 3.6394E+06, 3.6456E+06, 3.6518E+06, 3.6580E+06, 3.6642E+06, &
       3.6704E+06, 3.6767E+06, 3.6829E+06, 3.6892E+06, 3.6954E+06, 3.7017E+06, 3.7080E+06, 3.7142E+06, 3.7205E+06, 3.7268E+06, &
       3.7331E+06, 3.7395E+06, 3.7458E+06, 3.7521E+06, 3.7585E+06, 3.7648E+06, 3.7712E+06, 3.7775E+06, 3.7839E+06, 3.7903E+06, &
       3.7967E+06, 3.8031E+06, 3.8095E+06, 3.8159E+06, 3.8224E+06, 3.8288E+06, 3.8352E+06, 3.8417E+06, 3.8482E+06, 3.8546E+06, &
       3.8611E+06, 3.8676E+06, 3.8741E+06, 3.8806E+06, 3.8871E+06, 3.8936E+06, 3.9002E+06, 3.9067E+06, 3.9133E+06, 3.9198E+06, &
       3.9264E+06, 3.9330E+06, 3.9395E+06, 3.9461E+06, 3.9527E+06, 3.9594E+06, 3.9660E+06, 3.9726E+06, 3.9792E+06, 3.9859E+06, &
       3.9925E+06, 3.9992E+06, 4.0059E+06, 4.0126E+06, 4.0193E+06, 4.0260E+06, 4.0327E+06, 4.0394E+06, 4.0461E+06, 4.0528E+06, &
       4.0596E+06, 4.0663E+06, 4.0731E+06, 4.0799E+06, 4.0867E+06, 4.0934E+06, 4.1002E+06, 4.1071E+06, 4.1139E+06, 4.1207E+06, &
       4.1275E+06, 4.1344E+06, 4.1412E+06, 4.1481E+06, 4.1550E+06, 4.1618E+06, 4.1687E+06, 4.1756E+06, 4.1825E+06, 4.1894E+06, &
       4.1964E+06, 4.2033E+06, 4.2102E+06, 4.2172E+06, 4.2242E+06, 4.2311E+06, 4.2381E+06, 4.2451E+06, 4.2521E+06, 4.2591E+06, &
       4.2661E+06, 4.2731E+06, 4.2802E+06, 4.2872E+06, 4.2943E+06, 4.3013E+06, 4.3084E+06, 4.3155E+06, 4.3226E+06, 4.3297E+06, &
       4.3368E+06, 4.3439E+06, 4.3510E+06, 4.3582E+06, 4.3653E+06, 4.3725E+06, 4.3796E+06, 4.3868E+06, 4.3940E+06, 4.4012E+06, &
       4.4084E+06, 4.4156E+06, 4.4228E+06, 4.4300E+06, 4.4373E+06, 4.4445E+06, 4.4518E+06, 4.4590E+06, 4.4663E+06, 4.4736E+06, &
       4.4809E+06, 4.4882E+06, 4.4955E+06, 4.5028E+06, 4.5102E+06, 4.5175E+06, 4.5249E+06, 4.5322E+06, 4.5396E+06, 4.5470E+06, &
       4.5544E+06, 4.5618E+06, 4.5692E+06, 4.5766E+06, 4.5840E+06, 4.5915E+06, 4.5989E+06, 4.6064E+06, 4.6138E+06, 4.6213E+06, &
       4.6288E+06, 4.6363E+06, 4.6438E+06, 4.6513E+06, 4.6588E+06, 4.6664E+06, 4.6739E+06, 4.6815E+06, 4.6890E+06, 4.6966E+06, &
       4.7042E+06, 4.7118E+06, 4.7194E+06, 4.7270E+06, 4.7346E+06, 4.7422E+06, 4.7499E+06, 4.7575E+06, 4.7652E+06, 4.7729E+06, &
       4.7805E+06, 4.7882E+06, 4.7959E+06, 4.8036E+06, 4.8114E+06, 4.8191E+06, 4.8268E+06, 4.8346E+06, 4.8423E+06, 4.8501E+06, &
       4.8579E+06, 4.8657E+06, 4.8735E+06, 4.8813E+06, 4.8891E+06, 4.8969E+06, 4.9047E+06, 4.9126E+06, 4.9205E+06, 4.9283E+06, &
       4.9362E+06, 4.9441E+06, 4.9520E+06, 4.9599E+06, 4.9678E+06, 4.9757E+06, 4.9837E+06, 4.9916E+06, 4.9996E+06, 5.0075E+06/
      data (QofT( 9,J),J=2409,4510)/ 5.0155E+06, 5.0235E+06, 5.0315E+06, 5.0395E+06, 5.0475E+06, 5.0555E+06, 5.0636E+06, 5.0716E+06, &
       5.0797E+06, 5.0878E+06, 5.0958E+06, 5.1039E+06, 5.1120E+06, 5.1201E+06, 5.1282E+06, 5.1364E+06, 5.1445E+06, 5.1527E+06, &
       5.1608E+06, 5.1690E+06, 5.1772E+06, 5.1854E+06, 5.1936E+06, 5.2018E+06, 5.2100E+06, 5.2182E+06, 5.2265E+06, 5.2347E+06, &
       5.2430E+06, 5.2512E+06, 5.2595E+06, 5.2678E+06, 5.2761E+06, 5.2844E+06, 5.2928E+06, 5.3011E+06, 5.3094E+06, 5.3178E+06, &
       5.3261E+06, 5.3345E+06, 5.3429E+06, 5.3513E+06, 5.3597E+06, 5.3681E+06, 5.3766E+06, 5.3850E+06, 5.3934E+06, 5.4019E+06, &
       5.4104E+06, 5.4188E+06, 5.4273E+06, 5.4358E+06, 5.4443E+06, 5.4529E+06, 5.4614E+06, 5.4699E+06, 5.4785E+06, 5.4870E+06, &
       5.4956E+06, 5.5042E+06, 5.5128E+06, 5.5214E+06, 5.5300E+06, 5.5386E+06, 5.5473E+06, 5.5559E+06, 5.5646E+06, 5.5733E+06, &
       5.5819E+06, 5.5906E+06, 5.5993E+06, 5.6080E+06, 5.6168E+06, 5.6255E+06, 5.6342E+06, 5.6430E+06, 5.6518E+06, 5.6605E+06, &
       5.6693E+06, 5.6781E+06, 5.6869E+06, 5.6957E+06, 5.7046E+06, 5.7134E+06, 5.7223E+06, 5.7311E+06, 5.7400E+06, 5.7489E+06, &
       5.7578E+06, 5.7667E+06, 5.7756E+06, 5.7845E+06, 5.7935E+06, 5.8024E+06, 5.8114E+06, 5.8203E+06, 5.8293E+06, 5.8383E+06, &
       5.8473E+06, 5.8563E+06, 5.8653E+06, 5.8744E+06, 5.8834E+06, 5.8925E+06, 5.9016E+06, 5.9106E+06, 5.9197E+06, 5.9288E+06, &
       5.9379E+06, 5.9471E+06, 5.9562E+06, 5.9653E+06, 5.9745E+06, 5.9837E+06, 5.9928E+06, 6.0020E+06, 6.0112E+06, 6.0204E+06, &
       6.0297E+06, 6.0389E+06, 6.0481E+06, 6.0574E+06, 6.0667E+06, 6.0759E+06, 6.0852E+06, 6.0945E+06, 6.1038E+06, 6.1132E+06, &
       6.1225E+06, 6.1318E+06, 6.1412E+06, 6.1506E+06, 6.1599E+06, 6.1693E+06, 6.1787E+06, 6.1881E+06, 6.1976E+06, 6.2070E+06, &
       6.2164E+06, 6.2259E+06, 6.2354E+06, 6.2448E+06, 6.2543E+06, 6.2638E+06, 6.2734E+06, 6.2829E+06, 6.2924E+06, 6.3020E+06, &
       6.3115E+06, 6.3211E+06, 6.3307E+06, 6.3403E+06, 6.3499E+06, 6.3595E+06, 6.3691E+06, 6.3787E+06, 6.3884E+06, 6.3981E+06, &
       6.4077E+06, 6.4174E+06, 6.4271E+06, 6.4368E+06, 6.4465E+06, 6.4563E+06, 6.4660E+06, 6.4758E+06, 6.4855E+06, 6.4953E+06, &
       6.5051E+06, 6.5149E+06, 6.5247E+06, 6.5345E+06, 6.5443E+06, 6.5542E+06, 6.5640E+06, 6.5739E+06, 6.5838E+06, 6.5937E+06, &
       6.6036E+06, 6.6135E+06, 6.6234E+06, 6.6334E+06, 6.6433E+06, 6.6533E+06, 6.6632E+06, 6.6732E+06, 6.6832E+06, 6.6932E+06, &
       6.7033E+06, 6.7133E+06, 6.7233E+06, 6.7334E+06, 6.7434E+06, 6.7535E+06, 6.7636E+06, 6.7737E+06, 6.7838E+06, 6.7940E+06, &
       6.8041E+06, 6.8142E+06, 6.8244E+06, 6.8346E+06, 6.8448E+06, 6.8550E+06, 6.8652E+06, 6.8754E+06, 6.8856E+06, 6.8959E+06, &
       6.9061E+06, 6.9164E+06, 6.9267E+06, 6.9369E+06, 6.9472E+06, 6.9576E+06, 6.9679E+06, 6.9782E+06, 6.9886E+06, 6.9989E+06, &
       7.0093E+06, 7.0197E+06, 7.0301E+06, 7.0405E+06, 7.0509E+06, 7.0614E+06, 7.0718E+06, 7.0823E+06, 7.0927E+06, 7.1032E+06, &
       7.1137E+06, 7.1242E+06, 7.1347E+06, 7.1453E+06, 7.1558E+06, 7.1664E+06, 7.1769E+06, 7.1875E+06, 7.1981E+06, 7.2087E+06, &
       7.2193E+06, 7.2300E+06, 7.2406E+06, 7.2512E+06, 7.2619E+06, 7.2726E+06, 7.2833E+06, 7.2940E+06, 7.3047E+06, 7.3154E+06, &
       7.3262E+06, 7.3369E+06, 7.3477E+06, 7.3584E+06, 7.3692E+06, 7.3800E+06, 7.3908E+06, 7.4017E+06, 7.4125E+06, 7.4233E+06, &
       7.4342E+06, 7.4451E+06, 7.4560E+06, 7.4669E+06, 7.4778E+06, 7.4887E+06, 7.4996E+06, 7.5106E+06, 7.5215E+06, 7.5325E+06, &
       7.5435E+06, 7.5545E+06, 7.5655E+06, 7.5765E+06, 7.5875E+06, 7.5986E+06, 7.6096E+06, 7.6207E+06, 7.6318E+06, 7.6429E+06, &
       7.6540E+06, 7.6651E+06, 7.6763E+06, 7.6874E+06, 7.6986E+06, 7.7097E+06, 7.7209E+06, 7.7321E+06, 7.7433E+06, 7.7545E+06, &
       7.7658E+06, 7.7770E+06, 7.7883E+06, 7.7996E+06, 7.8108E+06, 7.8221E+06, 7.8334E+06, 7.8448E+06, 7.8561E+06, 7.8675E+06, &
       7.8788E+06, 7.8902E+06, 7.9016E+06, 7.9130E+06, 7.9244E+06, 7.9358E+06, 7.9472E+06, 7.9587E+06, 7.9702E+06, 7.9816E+06, &
       7.9931E+06, 8.0046E+06, 8.0161E+06, 8.0277E+06, 8.0392E+06, 8.0507E+06, 8.0623E+06, 8.0739E+06, 8.0855E+06, 8.0971E+06, &
       8.1087E+06, 8.1203E+06, 8.1320E+06, 8.1436E+06, 8.1553E+06, 8.1670E+06, 8.1787E+06, 8.1904E+06, 8.2021E+06, 8.2138E+06, &
       8.2256E+06, 8.2373E+06, 8.2491E+06, 8.2609E+06, 8.2727E+06, 8.2845E+06, 8.2963E+06, 8.3081E+06, 8.3200E+06, 8.3319E+06, &
       8.3437E+06, 8.3556E+06, 8.3675E+06, 8.3794E+06, 8.3914E+06, 8.4033E+06, 8.4152E+06, 8.4272E+06, 8.4392E+06, 8.4512E+06, &
       8.4632E+06, 8.4752E+06, 8.4872E+06, 8.4993E+06, 8.5113E+06, 8.5234E+06, 8.5355E+06, 8.5476E+06, 8.5597E+06, 8.5718E+06, &
       8.5840E+06, 8.5961E+06, 8.6083E+06, 8.6205E+06, 8.6327E+06, 8.6449E+06, 8.6571E+06, 8.6693E+06, 8.6816E+06, 8.6938E+06, &
       8.7061E+06, 8.7184E+06, 8.7307E+06, 8.7430E+06, 8.7553E+06, 8.7676E+06, 8.7800E+06, 8.7923E+06, 8.8047E+06, 8.8171E+06, &
       8.8295E+06, 8.8419E+06, 8.8544E+06, 8.8668E+06, 8.8793E+06, 8.8917E+06, 8.9042E+06, 8.9167E+06, 8.9292E+06, 8.9417E+06, &
       8.9543E+06, 8.9668E+06, 8.9794E+06, 8.9920E+06, 9.0046E+06, 9.0172E+06, 9.0298E+06, 9.0424E+06, 9.0551E+06, 9.0677E+06, &
       9.0804E+06, 9.0931E+06, 9.1058E+06, 9.1185E+06, 9.1312E+06, 9.1440E+06, 9.1567E+06, 9.1695E+06, 9.1823E+06, 9.1951E+06, &
       9.2079E+06, 9.2207E+06, 9.2336E+06, 9.2464E+06, 9.2593E+06, 9.2721E+06, 9.2850E+06, 9.2979E+06, 9.3109E+06, 9.3238E+06, &
       9.3367E+06, 9.3497E+06, 9.3627E+06, 9.3757E+06, 9.3887E+06, 9.4017E+06, 9.4147E+06, 9.4278E+06, 9.4408E+06, 9.4539E+06, &
       9.4670E+06, 9.4801E+06, 9.4932E+06, 9.5063E+06, 9.5194E+06, 9.5326E+06, 9.5458E+06, 9.5589E+06, 9.5721E+06, 9.5853E+06, &
       9.5986E+06, 9.6118E+06, 9.6251E+06, 9.6383E+06, 9.6516E+06, 9.6649E+06, 9.6782E+06, 9.6915E+06, 9.7049E+06, 9.7182E+06, &
       9.7316E+06, 9.7449E+06, 9.7583E+06, 9.7717E+06, 9.7852E+06, 9.7986E+06, 9.8120E+06, 9.8255E+06, 9.8390E+06, 9.8525E+06, &
       9.8660E+06, 9.8795E+06, 9.8930E+06, 9.9066E+06, 9.9201E+06, 9.9337E+06, 9.9473E+06, 9.9609E+06, 9.9745E+06, 9.9881E+06, &
       1.0002E+07, 1.0015E+07, 1.0029E+07, 1.0043E+07, 1.0057E+07, 1.0070E+07, 1.0084E+07, 1.0098E+07, 1.0111E+07, 1.0125E+07, &
       1.0139E+07, 1.0153E+07, 1.0167E+07, 1.0180E+07, 1.0194E+07, 1.0208E+07, 1.0222E+07, 1.0236E+07, 1.0250E+07, 1.0264E+07, &
       1.0278E+07, 1.0292E+07, 1.0306E+07, 1.0320E+07, 1.0334E+07, 1.0348E+07, 1.0362E+07, 1.0376E+07, 1.0390E+07, 1.0404E+07, &
       1.0418E+07, 1.0432E+07, 1.0446E+07, 1.0460E+07, 1.0474E+07, 1.0488E+07, 1.0503E+07, 1.0517E+07, 1.0531E+07, 1.0545E+07, &
       1.0559E+07, 1.0574E+07, 1.0588E+07, 1.0602E+07, 1.0616E+07, 1.0631E+07, 1.0645E+07, 1.0659E+07, 1.0674E+07, 1.0688E+07, &
       1.0702E+07, 1.0717E+07, 1.0731E+07, 1.0746E+07, 1.0760E+07, 1.0774E+07, 1.0789E+07, 1.0803E+07, 1.0818E+07, 1.0832E+07, &
       1.0847E+07, 1.0861E+07, 1.0876E+07, 1.0890E+07, 1.0905E+07, 1.0920E+07, 1.0934E+07, 1.0949E+07, 1.0963E+07, 1.0978E+07, &
       1.0993E+07, 1.1007E+07, 1.1022E+07, 1.1037E+07, 1.1052E+07, 1.1066E+07, 1.1081E+07, 1.1096E+07, 1.1111E+07, 1.1125E+07, &
       1.1140E+07, 1.1155E+07, 1.1170E+07, 1.1185E+07, 1.1200E+07, 1.1214E+07, 1.1229E+07, 1.1244E+07, 1.1259E+07, 1.1274E+07, &
       1.1289E+07, 1.1304E+07, 1.1319E+07, 1.1334E+07, 1.1349E+07, 1.1364E+07, 1.1379E+07, 1.1394E+07, 1.1409E+07, 1.1424E+07, &
       1.1439E+07, 1.1455E+07, 1.1470E+07, 1.1485E+07, 1.1500E+07, 1.1515E+07, 1.1530E+07, 1.1546E+07, 1.1561E+07, 1.1576E+07, &
       1.1591E+07, 1.1607E+07, 1.1622E+07, 1.1637E+07, 1.1653E+07, 1.1668E+07, 1.1683E+07, 1.1699E+07, 1.1714E+07, 1.1729E+07, &
       1.1745E+07, 1.1760E+07, 1.1776E+07, 1.1791E+07, 1.1807E+07, 1.1822E+07, 1.1838E+07, 1.1853E+07, 1.1869E+07, 1.1884E+07, &
       1.1900E+07, 1.1915E+07, 1.1931E+07, 1.1946E+07, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/

      eps=0.01
!
      TmI = Tmx(iso)
      ndat = 20+(IDINT(TmI)-20)/2
      gsi = xgj(iso)
!
      do I=1,ndat
        Q(I)=QofT(iso,I)
      enddo

!
!...value depends on temperature range
      if(T.lt.1. .OR. T.gt.TmI) then
         Qt = -1.
         write(*,'(f6.2,a,f6.2)') T, '  OUT OF TEMPERATURE RANGE 1..', TmI
         go to 99
      endif

!...check if T is one of the temperatures in our list
        do I = 1,ndat
          if(T.eq.Tdat(I))then
            Qt = Q(I)
            go to 99
          endif
        enddo
!
        do I=1,ndat
          if(T.gt.Tdat(I))then
            DT = Tdat(I+1) - Tdat(I)
            Qt = Q(I) + (Q(I+1)-Q(I))*(T - Tdat(I))/DT
          endif
        enddo
!
!
   99 return
      end
!
!     *****************
      Subroutine QT_CO2( T, ISO, GSI, QT )

      USE params, ONLY:  DOUBLE
      IMPLICIT NONE
      INTEGER , INTENT(IN)       :: ISO ! isotope code (HITRAN INDEX)
      REAL(DOUBLE)               :: T   ! temperature in K
      REAL(DOUBLE) , INTENT(OUT) :: GSI ! state independent nuclear degeneracyfactor
      REAL(DOUBLE)               :: QT  ! Total Internal Partition Function
      INTEGER                    :: I, J
      REAL(DOUBLE)                             :: TDAT
      REAL(DOUBLE), DIMENSION( ISONM(2) )     :: XGJ
      REAL(DOUBLE), DIMENSION( ISONM(2), NT ) :: QOFT
      REAL(DOUBLE), DIMENSION( NT )           :: Q
      REAL(DOUBLE), DIMENSION( Max_ISO )      :: TMX

      COMMON/Temperatures/tdat(NT)

      data (Tmx(I),I=1,13)/5000.,5000.,5000.,5000.,5000.,5000.,5000.,5000.,5000.,5000.,5000.,5000.,5000./
      data xgj/ 1.,2.,1.,6.,2.,12.,1.,6.,1.,2.,12.,2.,1./

!...      CO2
!...        --       626
      data (QofT( 1,J),J=1,2408)/ 1.1723E+00, 1.9608E+00, 2.8449E+00, 3.7338E+00, 4.6234E+00, 5.5133E+00, 6.4034E+00, 7.2936E+00, &
       8.1840E+00, 9.0743E+00, 9.9647E+00, 1.0855E+01, 1.1746E+01, 1.2636E+01, 1.3527E+01, 1.4417E+01, 1.5308E+01, 1.6198E+01, &
       1.7089E+01, 1.7979E+01, 1.9760E+01, 2.1542E+01, 2.3323E+01, 2.5104E+01, 2.6885E+01, 2.8666E+01, 3.0448E+01, 3.2229E+01, &
       3.4010E+01, 3.5792E+01, 3.7573E+01, 3.9354E+01, 4.1135E+01, 4.2917E+01, 4.4698E+01, 4.6479E+01, 4.8261E+01, 5.0042E+01, &
       5.1823E+01, 5.3605E+01, 5.5386E+01, 5.7168E+01, 5.8949E+01, 6.0731E+01, 6.2512E+01, 6.4294E+01, 6.6075E+01, 6.7857E+01, &
       6.9638E+01, 7.1420E+01, 7.3202E+01, 7.4984E+01, 7.6766E+01, 7.8548E+01, 8.0330E+01, 8.2113E+01, 8.3896E+01, 8.5679E+01, &
       8.7462E+01, 8.9246E+01, 9.1031E+01, 9.2815E+01, 9.4601E+01, 9.6387E+01, 9.8174E+01, 9.9961E+01, 1.0175E+02, 1.0354E+02, &
       1.0533E+02, 1.0712E+02, 1.0891E+02, 1.1071E+02, 1.1250E+02, 1.1430E+02, 1.1610E+02, 1.1790E+02, 1.1971E+02, 1.2151E+02, &
       1.2332E+02, 1.2513E+02, 1.2694E+02, 1.2876E+02, 1.3057E+02, 1.3239E+02, 1.3422E+02, 1.3605E+02, 1.3788E+02, 1.3971E+02, &
       1.4155E+02, 1.4339E+02, 1.4524E+02, 1.4709E+02, 1.4894E+02, 1.5080E+02, 1.5266E+02, 1.5453E+02, 1.5641E+02, 1.5829E+02, &
       1.6017E+02, 1.6206E+02, 1.6395E+02, 1.6586E+02, 1.6776E+02, 1.6968E+02, 1.7159E+02, 1.7352E+02, 1.7545E+02, 1.7739E+02, &
       1.7934E+02, 1.8129E+02, 1.8325E+02, 1.8522E+02, 1.8719E+02, 1.8918E+02, 1.9117E+02, 1.9317E+02, 1.9517E+02, 1.9719E+02, &
       1.9921E+02, 2.0124E+02, 2.0328E+02, 2.0533E+02, 2.0739E+02, 2.0946E+02, 2.1153E+02, 2.1362E+02, 2.1572E+02, 2.1782E+02, &
       2.1994E+02, 2.2206E+02, 2.2419E+02, 2.2634E+02, 2.2850E+02, 2.3066E+02, 2.3284E+02, 2.3502E+02, 2.3722E+02, 2.3943E+02, &
       2.4165E+02, 2.4388E+02, 2.4612E+02, 2.4838E+02, 2.5064E+02, 2.5292E+02, 2.5521E+02, 2.5751E+02, 2.5982E+02, 2.6215E+02, &
       2.6449E+02, 2.6684E+02, 2.6920E+02, 2.7157E+02, 2.7396E+02, 2.7636E+02, 2.7877E+02, 2.8120E+02, 2.8364E+02, 2.8609E+02, &
       2.8856E+02, 2.9104E+02, 2.9353E+02, 2.9604E+02, 2.9856E+02, 3.0110E+02, 3.0365E+02, 3.0621E+02, 3.0879E+02, 3.1138E+02, &
       3.1399E+02, 3.1661E+02, 3.1925E+02, 3.2190E+02, 3.2456E+02, 3.2724E+02, 3.2994E+02, 3.3265E+02, 3.3538E+02, 3.3812E+02, &
       3.4088E+02, 3.4365E+02, 3.4644E+02, 3.4925E+02, 3.5207E+02, 3.5491E+02, 3.5776E+02, 3.6063E+02, 3.6352E+02, 3.6642E+02, &
       3.6934E+02, 3.7228E+02, 3.7523E+02, 3.7820E+02, 3.8119E+02, 3.8419E+02, 3.8721E+02, 3.9025E+02, 3.9331E+02, 3.9638E+02, &
       3.9948E+02, 4.0259E+02, 4.0571E+02, 4.0886E+02, 4.1202E+02, 4.1520E+02, 4.1840E+02, 4.2162E+02, 4.2486E+02, 4.2811E+02, &
       4.3139E+02, 4.3468E+02, 4.3799E+02, 4.4132E+02, 4.4467E+02, 4.4804E+02, 4.5143E+02, 4.5484E+02, 4.5827E+02, 4.6171E+02, &
       4.6518E+02, 4.6867E+02, 4.7218E+02, 4.7570E+02, 4.7925E+02, 4.8282E+02, 4.8640E+02, 4.9001E+02, 4.9364E+02, 4.9729E+02, &
       5.0096E+02, 5.0465E+02, 5.0836E+02, 5.1210E+02, 5.1585E+02, 5.1963E+02, 5.2343E+02, 5.2725E+02, 5.3109E+02, 5.3495E+02, &
       5.3883E+02, 5.4274E+02, 5.4667E+02, 5.5062E+02, 5.5459E+02, 5.5859E+02, 5.6261E+02, 5.6665E+02, 5.7071E+02, 5.7480E+02, &
       5.7891E+02, 5.8304E+02, 5.8719E+02, 5.9137E+02, 5.9557E+02, 5.9980E+02, 6.0405E+02, 6.0832E+02, 6.1262E+02, 6.1694E+02, &
       6.2129E+02, 6.2566E+02, 6.3005E+02, 6.3447E+02, 6.3891E+02, 6.4338E+02, 6.4787E+02, 6.5239E+02, 6.5693E+02, 6.6150E+02, &
       6.6609E+02, 6.7071E+02, 6.7536E+02, 6.8003E+02, 6.8472E+02, 6.8944E+02, 6.9419E+02, 6.9896E+02, 7.0376E+02, 7.0859E+02, &
       7.1344E+02, 7.1832E+02, 7.2322E+02, 7.2815E+02, 7.3311E+02, 7.3810E+02, 7.4311E+02, 7.4815E+02, 7.5322E+02, 7.5832E+02, &
       7.6344E+02, 7.6859E+02, 7.7377E+02, 7.7898E+02, 7.8421E+02, 7.8948E+02, 7.9477E+02, 8.0009E+02, 8.0544E+02, 8.1082E+02, &
       8.1622E+02, 8.2166E+02, 8.2712E+02, 8.3262E+02, 8.3814E+02, 8.4370E+02, 8.4928E+02, 8.5489E+02, 8.6054E+02, 8.6621E+02, &
       8.7191E+02, 8.7765E+02, 8.8341E+02, 8.8920E+02, 8.9503E+02, 9.0088E+02, 9.0677E+02, 9.1269E+02, 9.1864E+02, 9.2462E+02, &
       9.3063E+02, 9.3668E+02, 9.4275E+02, 9.4886E+02, 9.5500E+02, 9.6117E+02, 9.6738E+02, 9.7361E+02, 9.7988E+02, 9.8619E+02, &
       9.9252E+02, 9.9889E+02, 1.0053E+03, 1.0117E+03, 1.0182E+03, 1.0247E+03, 1.0312E+03, 1.0378E+03, 1.0444E+03, 1.0510E+03, &
       1.0577E+03, 1.0644E+03, 1.0712E+03, 1.0779E+03, 1.0847E+03, 1.0916E+03, 1.0985E+03, 1.1054E+03, 1.1123E+03, 1.1193E+03, &
       1.1263E+03, 1.1334E+03, 1.1405E+03, 1.1476E+03, 1.1548E+03, 1.1620E+03, 1.1692E+03, 1.1765E+03, 1.1838E+03, 1.1912E+03, &
       1.1986E+03, 1.2060E+03, 1.2135E+03, 1.2210E+03, 1.2285E+03, 1.2361E+03, 1.2437E+03, 1.2513E+03, 1.2590E+03, 1.2668E+03, &
       1.2745E+03, 1.2823E+03, 1.2902E+03, 1.2981E+03, 1.3060E+03, 1.3140E+03, 1.3220E+03, 1.3300E+03, 1.3381E+03, 1.3462E+03, &
       1.3544E+03, 1.3626E+03, 1.3708E+03, 1.3791E+03, 1.3874E+03, 1.3958E+03, 1.4042E+03, 1.4127E+03, 1.4212E+03, 1.4297E+03, &
       1.4383E+03, 1.4469E+03, 1.4555E+03, 1.4642E+03, 1.4730E+03, 1.4818E+03, 1.4906E+03, 1.4995E+03, 1.5084E+03, 1.5174E+03, &
       1.5264E+03, 1.5354E+03, 1.5445E+03, 1.5536E+03, 1.5628E+03, 1.5720E+03, 1.5813E+03, 1.5906E+03, 1.6000E+03, 1.6094E+03, &
       1.6188E+03, 1.6283E+03, 1.6379E+03, 1.6474E+03, 1.6571E+03, 1.6668E+03, 1.6765E+03, 1.6862E+03, 1.6961E+03, 1.7059E+03, &
       1.7158E+03, 1.7258E+03, 1.7358E+03, 1.7458E+03, 1.7559E+03, 1.7661E+03, 1.7763E+03, 1.7865E+03, 1.7968E+03, 1.8072E+03, &
       1.8176E+03, 1.8280E+03, 1.8385E+03, 1.8490E+03, 1.8596E+03, 1.8702E+03, 1.8809E+03, 1.8917E+03, 1.9024E+03, 1.9133E+03, &
       1.9242E+03, 1.9351E+03, 1.9461E+03, 1.9571E+03, 1.9682E+03, 1.9794E+03, 1.9906E+03, 2.0018E+03, 2.0131E+03, 2.0245E+03, &
       2.0359E+03, 2.0473E+03, 2.0588E+03, 2.0704E+03, 2.0820E+03, 2.0937E+03, 2.1054E+03, 2.1172E+03, 2.1290E+03, 2.1409E+03, &
       2.1528E+03, 2.1648E+03, 2.1769E+03, 2.1890E+03, 2.2011E+03, 2.2133E+03, 2.2256E+03, 2.2379E+03, 2.2503E+03, 2.2627E+03, &
       2.2752E+03, 2.2878E+03, 2.3004E+03, 2.3131E+03, 2.3258E+03, 2.3386E+03, 2.3514E+03, 2.3643E+03, 2.3772E+03, 2.3902E+03, &
       2.4033E+03, 2.4164E+03, 2.4296E+03, 2.4429E+03, 2.4562E+03, 2.4695E+03, 2.4829E+03, 2.4964E+03, 2.5100E+03, 2.5236E+03, &
       2.5372E+03, 2.5510E+03, 2.5647E+03, 2.5786E+03, 2.5925E+03, 2.6065E+03, 2.6205E+03, 2.6346E+03, 2.6487E+03, 2.6629E+03, &
       2.6772E+03, 2.6916E+03, 2.7060E+03, 2.7204E+03, 2.7350E+03, 2.7496E+03, 2.7642E+03, 2.7789E+03, 2.7937E+03, 2.8086E+03, &
       2.8235E+03, 2.8385E+03, 2.8535E+03, 2.8686E+03, 2.8838E+03, 2.8990E+03, 2.9144E+03, 2.9297E+03, 2.9452E+03, 2.9607E+03, &
       2.9763E+03, 2.9919E+03, 3.0076E+03, 3.0234E+03, 3.0392E+03, 3.0551E+03, 3.0711E+03, 3.0872E+03, 3.1033E+03, 3.1195E+03, &
       3.1357E+03, 3.1521E+03, 3.1685E+03, 3.1849E+03, 3.2015E+03, 3.2181E+03, 3.2347E+03, 3.2515E+03, 3.2683E+03, 3.2852E+03, &
       3.3022E+03, 3.3192E+03, 3.3363E+03, 3.3535E+03, 3.3707E+03, 3.3881E+03, 3.4055E+03, 3.4229E+03, 3.4405E+03, 3.4581E+03, &
       3.4758E+03, 3.4935E+03, 3.5114E+03, 3.5293E+03, 3.5473E+03, 3.5653E+03, 3.5835E+03, 3.6017E+03, 3.6200E+03, 3.6384E+03, &
       3.6568E+03, 3.6753E+03, 3.6939E+03, 3.7126E+03, 3.7313E+03, 3.7502E+03, 3.7691E+03, 3.7881E+03, 3.8071E+03, 3.8263E+03, &
       3.8455E+03, 3.8648E+03, 3.8842E+03, 3.9036E+03, 3.9232E+03, 3.9428E+03, 3.9625E+03, 3.9823E+03, 4.0021E+03, 4.0221E+03, &
       4.0421E+03, 4.0622E+03, 4.0824E+03, 4.1026E+03, 4.1230E+03, 4.1434E+03, 4.1639E+03, 4.1845E+03, 4.2052E+03, 4.2260E+03, &
       4.2468E+03, 4.2678E+03, 4.2888E+03, 4.3099E+03, 4.3311E+03, 4.3524E+03, 4.3737E+03, 4.3952E+03, 4.4167E+03, 4.4383E+03, &
       4.4600E+03, 4.4818E+03, 4.5037E+03, 4.5257E+03, 4.5477E+03, 4.5699E+03, 4.5921E+03, 4.6144E+03, 4.6368E+03, 4.6593E+03, &
       4.6819E+03, 4.7046E+03, 4.7273E+03, 4.7502E+03, 4.7732E+03, 4.7962E+03, 4.8193E+03, 4.8425E+03, 4.8658E+03, 4.8893E+03, &
       4.9127E+03, 4.9363E+03, 4.9600E+03, 4.9838E+03, 5.0077E+03, 5.0316E+03, 5.0557E+03, 5.0798E+03, 5.1041E+03, 5.1284E+03, &
       5.1528E+03, 5.1774E+03, 5.2020E+03, 5.2267E+03, 5.2515E+03, 5.2764E+03, 5.3014E+03, 5.3265E+03, 5.3517E+03, 5.3770E+03, &
       5.4024E+03, 5.4279E+03, 5.4535E+03, 5.4792E+03, 5.5050E+03, 5.5309E+03, 5.5569E+03, 5.5830E+03, 5.6092E+03, 5.6355E+03, &
       5.6619E+03, 5.6884E+03, 5.7149E+03, 5.7416E+03, 5.7684E+03, 5.7953E+03, 5.8223E+03, 5.8495E+03, 5.8767E+03, 5.9040E+03, &
       5.9314E+03, 5.9589E+03, 5.9865E+03, 6.0143E+03, 6.0421E+03, 6.0700E+03, 6.0981E+03, 6.1262E+03, 6.1545E+03, 6.1829E+03, &
       6.2113E+03, 6.2399E+03, 6.2686E+03, 6.2974E+03, 6.3263E+03, 6.3553E+03, 6.3844E+03, 6.4136E+03, 6.4430E+03, 6.4724E+03, &
       6.5020E+03, 6.5317E+03, 6.5614E+03, 6.5913E+03, 6.6213E+03, 6.6514E+03, 6.6817E+03, 6.7120E+03, 6.7424E+03, 6.7730E+03, &
       6.8037E+03, 6.8345E+03, 6.8654E+03, 6.8964E+03, 6.9275E+03, 6.9588E+03, 6.9901E+03, 7.0216E+03, 7.0532E+03, 7.0849E+03, &
       7.1167E+03, 7.1486E+03, 7.1807E+03, 7.2129E+03, 7.2452E+03, 7.2776E+03, 7.3101E+03, 7.3428E+03, 7.3755E+03, 7.4084E+03, &
       7.4414E+03, 7.4745E+03, 7.5078E+03, 7.5412E+03, 7.5746E+03, 7.6083E+03, 7.6420E+03, 7.6758E+03, 7.7098E+03, 7.7439E+03, &
       7.7781E+03, 7.8125E+03, 7.8469E+03, 7.8815E+03, 7.9163E+03, 7.9511E+03, 7.9861E+03, 8.0212E+03, 8.0564E+03, 8.0917E+03, &
       8.1272E+03, 8.1628E+03, 8.1985E+03, 8.2344E+03, 8.2703E+03, 8.3065E+03, 8.3427E+03, 8.3791E+03, 8.4156E+03, 8.4522E+03, &
       8.4889E+03, 8.5258E+03, 8.5628E+03, 8.6000E+03, 8.6373E+03, 8.6747E+03, 8.7122E+03, 8.7499E+03, 8.7877E+03, 8.8256E+03, &
       8.8637E+03, 8.9019E+03, 8.9403E+03, 8.9788E+03, 9.0174E+03, 9.0561E+03, 9.0950E+03, 9.1340E+03, 9.1732E+03, 9.2125E+03, &
       9.2519E+03, 9.2915E+03, 9.3312E+03, 9.3710E+03, 9.4110E+03, 9.4511E+03, 9.4914E+03, 9.5318E+03, 9.5723E+03, 9.6130E+03, &
       9.6538E+03, 9.6948E+03, 9.7359E+03, 9.7772E+03, 9.8185E+03, 9.8601E+03, 9.9018E+03, 9.9436E+03, 9.9855E+03, 1.0028E+04, &
       1.0070E+04, 1.0112E+04, 1.0155E+04, 1.0198E+04, 1.0240E+04, 1.0283E+04, 1.0326E+04, 1.0370E+04, 1.0413E+04, 1.0457E+04, &
       1.0500E+04, 1.0544E+04, 1.0588E+04, 1.0633E+04, 1.0677E+04, 1.0721E+04, 1.0766E+04, 1.0811E+04, 1.0856E+04, 1.0901E+04, &
       1.0946E+04, 1.0991E+04, 1.1037E+04, 1.1083E+04, 1.1128E+04, 1.1174E+04, 1.1221E+04, 1.1267E+04, 1.1313E+04, 1.1360E+04, &
       1.1407E+04, 1.1454E+04, 1.1501E+04, 1.1548E+04, 1.1595E+04, 1.1643E+04, 1.1691E+04, 1.1739E+04, 1.1787E+04, 1.1835E+04, &
       1.1883E+04, 1.1932E+04, 1.1980E+04, 1.2029E+04, 1.2078E+04, 1.2127E+04, 1.2177E+04, 1.2226E+04, 1.2276E+04, 1.2326E+04, &
       1.2376E+04, 1.2426E+04, 1.2476E+04, 1.2527E+04, 1.2577E+04, 1.2628E+04, 1.2679E+04, 1.2730E+04, 1.2781E+04, 1.2833E+04, &
       1.2885E+04, 1.2936E+04, 1.2988E+04, 1.3041E+04, 1.3093E+04, 1.3145E+04, 1.3198E+04, 1.3251E+04, 1.3304E+04, 1.3357E+04, &
       1.3410E+04, 1.3464E+04, 1.3518E+04, 1.3572E+04, 1.3626E+04, 1.3680E+04, 1.3734E+04, 1.3789E+04, 1.3844E+04, 1.3899E+04, &
       1.3954E+04, 1.4009E+04, 1.4064E+04, 1.4120E+04, 1.4176E+04, 1.4232E+04, 1.4288E+04, 1.4344E+04, 1.4401E+04, 1.4458E+04, &
       1.4515E+04, 1.4572E+04, 1.4629E+04, 1.4687E+04, 1.4744E+04, 1.4802E+04, 1.4860E+04, 1.4918E+04, 1.4977E+04, 1.5035E+04, &
       1.5094E+04, 1.5153E+04, 1.5212E+04, 1.5271E+04, 1.5331E+04, 1.5390E+04, 1.5450E+04, 1.5510E+04, 1.5571E+04, 1.5631E+04, &
       1.5692E+04, 1.5753E+04, 1.5814E+04, 1.5875E+04, 1.5936E+04, 1.5998E+04, 1.6060E+04, 1.6121E+04, 1.6184E+04, 1.6246E+04, &
       1.6309E+04, 1.6371E+04, 1.6434E+04, 1.6497E+04, 1.6561E+04, 1.6624E+04, 1.6688E+04, 1.6752E+04, 1.6816E+04, 1.6881E+04, &
       1.6945E+04, 1.7010E+04, 1.7075E+04, 1.7140E+04, 1.7205E+04, 1.7271E+04, 1.7337E+04, 1.7402E+04, 1.7469E+04, 1.7535E+04, &
       1.7602E+04, 1.7668E+04, 1.7735E+04, 1.7802E+04, 1.7870E+04, 1.7937E+04, 1.8005E+04, 1.8073E+04, 1.8141E+04, 1.8210E+04, &
       1.8279E+04, 1.8347E+04, 1.8416E+04, 1.8486E+04, 1.8555E+04, 1.8625E+04, 1.8695E+04, 1.8765E+04, 1.8835E+04, 1.8906E+04, &
       1.8977E+04, 1.9047E+04, 1.9119E+04, 1.9190E+04, 1.9262E+04, 1.9334E+04, 1.9406E+04, 1.9478E+04, 1.9550E+04, 1.9623E+04, &
       1.9696E+04, 1.9769E+04, 1.9842E+04, 1.9916E+04, 1.9990E+04, 2.0064E+04, 2.0138E+04, 2.0213E+04, 2.0287E+04, 2.0362E+04, &
       2.0437E+04, 2.0513E+04, 2.0588E+04, 2.0664E+04, 2.0740E+04, 2.0816E+04, 2.0893E+04, 2.0970E+04, 2.1047E+04, 2.1124E+04, &
       2.1201E+04, 2.1279E+04, 2.1357E+04, 2.1435E+04, 2.1513E+04, 2.1592E+04, 2.1670E+04, 2.1749E+04, 2.1829E+04, 2.1908E+04, &
       2.1988E+04, 2.2068E+04, 2.2148E+04, 2.2229E+04, 2.2309E+04, 2.2390E+04, 2.2471E+04, 2.2553E+04, 2.2634E+04, 2.2716E+04, &
       2.2798E+04, 2.2881E+04, 2.2963E+04, 2.3046E+04, 2.3129E+04, 2.3212E+04, 2.3296E+04, 2.3380E+04, 2.3464E+04, 2.3548E+04, &
       2.3633E+04, 2.3717E+04, 2.3802E+04, 2.3888E+04, 2.3973E+04, 2.4059E+04, 2.4145E+04, 2.4231E+04, 2.4318E+04, 2.4404E+04, &
       2.4491E+04, 2.4579E+04, 2.4666E+04, 2.4754E+04, 2.4842E+04, 2.4930E+04, 2.5019E+04, 2.5107E+04, 2.5196E+04, 2.5286E+04, &
       2.5375E+04, 2.5465E+04, 2.5555E+04, 2.5645E+04, 2.5736E+04, 2.5827E+04, 2.5918E+04, 2.6009E+04, 2.6101E+04, 2.6193E+04, &
       2.6285E+04, 2.6377E+04, 2.6470E+04, 2.6563E+04, 2.6656E+04, 2.6749E+04, 2.6843E+04, 2.6937E+04, 2.7031E+04, 2.7126E+04, &
       2.7221E+04, 2.7316E+04, 2.7411E+04, 2.7506E+04, 2.7602E+04, 2.7698E+04, 2.7795E+04, 2.7891E+04, 2.7988E+04, 2.8086E+04, &
       2.8183E+04, 2.8281E+04, 2.8379E+04, 2.8477E+04, 2.8576E+04, 2.8674E+04, 2.8774E+04, 2.8873E+04, 2.8973E+04, 2.9073E+04, &
       2.9173E+04, 2.9273E+04, 2.9374E+04, 2.9475E+04, 2.9576E+04, 2.9678E+04, 2.9780E+04, 2.9882E+04, 2.9985E+04, 3.0087E+04, &
       3.0190E+04, 3.0294E+04, 3.0397E+04, 3.0501E+04, 3.0605E+04, 3.0710E+04, 3.0815E+04, 3.0920E+04, 3.1025E+04, 3.1131E+04, &
       3.1237E+04, 3.1343E+04, 3.1449E+04, 3.1556E+04, 3.1663E+04, 3.1771E+04, 3.1878E+04, 3.1986E+04, 3.2094E+04, 3.2203E+04, &
       3.2312E+04, 3.2421E+04, 3.2530E+04, 3.2640E+04, 3.2750E+04, 3.2860E+04, 3.2971E+04, 3.3082E+04, 3.3193E+04, 3.3305E+04, &
       3.3417E+04, 3.3529E+04, 3.3641E+04, 3.3754E+04, 3.3867E+04, 3.3980E+04, 3.4094E+04, 3.4208E+04, 3.4322E+04, 3.4437E+04, &
       3.4552E+04, 3.4667E+04, 3.4782E+04, 3.4898E+04, 3.5014E+04, 3.5131E+04, 3.5248E+04, 3.5365E+04, 3.5482E+04, 3.5600E+04, &
       3.5718E+04, 3.5836E+04, 3.5955E+04, 3.6074E+04, 3.6193E+04, 3.6313E+04, 3.6433E+04, 3.6553E+04, 3.6673E+04, 3.6794E+04, &
       3.6915E+04, 3.7037E+04, 3.7159E+04, 3.7281E+04, 3.7403E+04, 3.7526E+04, 3.7649E+04, 3.7773E+04, 3.7896E+04, 3.8021E+04, &
       3.8145E+04, 3.8270E+04, 3.8395E+04, 3.8520E+04, 3.8646E+04, 3.8772E+04, 3.8899E+04, 3.9025E+04, 3.9152E+04, 3.9280E+04, &
       3.9407E+04, 3.9536E+04, 3.9664E+04, 3.9793E+04, 3.9922E+04, 4.0051E+04, 4.0181E+04, 4.0311E+04, 4.0442E+04, 4.0572E+04, &
       4.0703E+04, 4.0835E+04, 4.0967E+04, 4.1099E+04, 4.1231E+04, 4.1364E+04, 4.1497E+04, 4.1631E+04, 4.1765E+04, 4.1899E+04, &
       4.2033E+04, 4.2168E+04, 4.2303E+04, 4.2439E+04, 4.2575E+04, 4.2711E+04, 4.2848E+04, 4.2985E+04, 4.3122E+04, 4.3260E+04, &
       4.3398E+04, 4.3536E+04, 4.3675E+04, 4.3814E+04, 4.3954E+04, 4.4094E+04, 4.4234E+04, 4.4374E+04, 4.4515E+04, 4.4657E+04, &
       4.4798E+04, 4.4940E+04, 4.5083E+04, 4.5225E+04, 4.5368E+04, 4.5512E+04, 4.5656E+04, 4.5800E+04, 4.5944E+04, 4.6089E+04, &
       4.6234E+04, 4.6380E+04, 4.6526E+04, 4.6672E+04, 4.6819E+04, 4.6966E+04, 4.7114E+04, 4.7262E+04, 4.7410E+04, 4.7558E+04, &
       4.7707E+04, 4.7857E+04, 4.8006E+04, 4.8157E+04, 4.8307E+04, 4.8458E+04, 4.8609E+04, 4.8761E+04, 4.8913E+04, 4.9065E+04, &
       4.9218E+04, 4.9371E+04, 4.9524E+04, 4.9678E+04, 4.9833E+04, 4.9987E+04, 5.0142E+04, 5.0298E+04, 5.0454E+04, 5.0610E+04, &
       5.0766E+04, 5.0923E+04, 5.1081E+04, 5.1239E+04, 5.1397E+04, 5.1555E+04, 5.1714E+04, 5.1874E+04, 5.2033E+04, 5.2193E+04, &
       5.2354E+04, 5.2515E+04, 5.2676E+04, 5.2838E+04, 5.3000E+04, 5.3163E+04, 5.3325E+04, 5.3489E+04, 5.3652E+04, 5.3817E+04, &
       5.3981E+04, 5.4146E+04, 5.4311E+04, 5.4477E+04, 5.4643E+04, 5.4810E+04, 5.4977E+04, 5.5144E+04, 5.5312E+04, 5.5480E+04, &
       5.5648E+04, 5.5817E+04, 5.5987E+04, 5.6157E+04, 5.6327E+04, 5.6498E+04, 5.6669E+04, 5.6840E+04, 5.7012E+04, 5.7184E+04, &
       5.7357E+04, 5.7530E+04, 5.7704E+04, 5.7878E+04, 5.8052E+04, 5.8227E+04, 5.8402E+04, 5.8578E+04, 5.8754E+04, 5.8930E+04, &
       5.9107E+04, 5.9285E+04, 5.9462E+04, 5.9641E+04, 5.9819E+04, 5.9998E+04, 6.0178E+04, 6.0358E+04, 6.0538E+04, 6.0719E+04, &
       6.0900E+04, 6.1082E+04, 6.1264E+04, 6.1446E+04, 6.1629E+04, 6.1813E+04, 6.1996E+04, 6.2181E+04, 6.2365E+04, 6.2551E+04, &
       6.2736E+04, 6.2922E+04, 6.3109E+04, 6.3295E+04, 6.3483E+04, 6.3671E+04, 6.3859E+04, 6.4048E+04, 6.4237E+04, 6.4426E+04, &
       6.4616E+04, 6.4807E+04, 6.4998E+04, 6.5189E+04, 6.5381E+04, 6.5573E+04, 6.5766E+04, 6.5959E+04, 6.6153E+04, 6.6347E+04, &
       6.6541E+04, 6.6736E+04, 6.6932E+04, 6.7128E+04, 6.7324E+04, 6.7521E+04, 6.7718E+04, 6.7916E+04, 6.8114E+04, 6.8313E+04, &
       6.8512E+04, 6.8711E+04, 6.8911E+04, 6.9112E+04, 6.9313E+04, 6.9514E+04, 6.9716E+04, 6.9919E+04, 7.0122E+04, 7.0325E+04, &
       7.0529E+04, 7.0733E+04, 7.0938E+04, 7.1143E+04, 7.1349E+04, 7.1555E+04, 7.1762E+04, 7.1969E+04, 7.2176E+04, 7.2384E+04, &
       7.2593E+04, 7.2802E+04, 7.3011E+04, 7.3221E+04, 7.3432E+04, 7.3643E+04, 7.3854E+04, 7.4066E+04, 7.4279E+04, 7.4492E+04, &
       7.4705E+04, 7.4919E+04, 7.5133E+04, 7.5348E+04, 7.5564E+04, 7.5779E+04, 7.5996E+04, 7.6213E+04, 7.6430E+04, 7.6648E+04, &
       7.6866E+04, 7.7085E+04, 7.7304E+04, 7.7524E+04, 7.7744E+04, 7.7965E+04, 7.8186E+04, 7.8408E+04, 7.8630E+04, 7.8853E+04, &
       7.9077E+04, 7.9300E+04, 7.9525E+04, 7.9749E+04, 7.9975E+04, 8.0201E+04, 8.0427E+04, 8.0654E+04, 8.0881E+04, 8.1109E+04, &
       8.1337E+04, 8.1566E+04, 8.1796E+04, 8.2026E+04, 8.2256E+04, 8.2487E+04, 8.2719E+04, 8.2951E+04, 8.3183E+04, 8.3416E+04, &
       8.3650E+04, 8.3884E+04, 8.4118E+04, 8.4354E+04, 8.4589E+04, 8.4825E+04, 8.5062E+04, 8.5299E+04, 8.5537E+04, 8.5775E+04, &
       8.6014E+04, 8.6253E+04, 8.6493E+04, 8.6734E+04, 8.6975E+04, 8.7216E+04, 8.7458E+04, 8.7701E+04, 8.7944E+04, 8.8187E+04, &
       8.8431E+04, 8.8676E+04, 8.8921E+04, 8.9167E+04, 8.9413E+04, 8.9660E+04, 8.9907E+04, 9.0155E+04, 9.0404E+04, 9.0653E+04, &
       9.0902E+04, 9.1153E+04, 9.1403E+04, 9.1654E+04, 9.1906E+04, 9.2158E+04, 9.2411E+04, 9.2665E+04, 9.2919E+04, 9.3173E+04, &
       9.3428E+04, 9.3684E+04, 9.3940E+04, 9.4197E+04, 9.4454E+04, 9.4712E+04, 9.4970E+04, 9.5229E+04, 9.5489E+04, 9.5749E+04, &
       9.6009E+04, 9.6271E+04, 9.6532E+04, 9.6795E+04, 9.7058E+04, 9.7321E+04, 9.7585E+04, 9.7850E+04, 9.8115E+04, 9.8381E+04, &
       9.8647E+04, 9.8914E+04, 9.9181E+04, 9.9450E+04, 9.9718E+04, 9.9987E+04, 1.0026E+05, 1.0053E+05, 1.0080E+05, 1.0107E+05, &
       1.0134E+05, 1.0161E+05, 1.0189E+05, 1.0216E+05, 1.0244E+05, 1.0271E+05, 1.0299E+05, 1.0326E+05, 1.0354E+05, 1.0382E+05, &
       1.0410E+05, 1.0437E+05, 1.0465E+05, 1.0493E+05, 1.0521E+05, 1.0549E+05, 1.0578E+05, 1.0606E+05, 1.0634E+05, 1.0662E+05, &
       1.0691E+05, 1.0719E+05, 1.0748E+05, 1.0776E+05, 1.0805E+05, 1.0834E+05, 1.0862E+05, 1.0891E+05, 1.0920E+05, 1.0949E+05, &
       1.0978E+05, 1.1007E+05, 1.1036E+05, 1.1065E+05, 1.1095E+05, 1.1124E+05, 1.1153E+05, 1.1183E+05, 1.1212E+05, 1.1242E+05, &
       1.1271E+05, 1.1301E+05, 1.1331E+05, 1.1360E+05, 1.1390E+05, 1.1420E+05, 1.1450E+05, 1.1480E+05, 1.1510E+05, 1.1540E+05, &
       1.1571E+05, 1.1601E+05, 1.1631E+05, 1.1662E+05, 1.1692E+05, 1.1723E+05, 1.1753E+05, 1.1784E+05, 1.1815E+05, 1.1846E+05, &
       1.1876E+05, 1.1907E+05, 1.1938E+05, 1.1969E+05, 1.2001E+05, 1.2032E+05, 1.2063E+05, 1.2094E+05, 1.2126E+05, 1.2157E+05, &
       1.2189E+05, 1.2220E+05, 1.2252E+05, 1.2283E+05, 1.2315E+05, 1.2347E+05, 1.2379E+05, 1.2411E+05, 1.2443E+05, 1.2475E+05, &
       1.2507E+05, 1.2539E+05, 1.2572E+05, 1.2604E+05, 1.2636E+05, 1.2669E+05, 1.2701E+05, 1.2734E+05, 1.2767E+05, 1.2799E+05, &
       1.2832E+05, 1.2865E+05, 1.2898E+05, 1.2931E+05, 1.2964E+05, 1.2997E+05, 1.3031E+05, 1.3064E+05, 1.3097E+05, 1.3131E+05, &
       1.3164E+05, 1.3198E+05, 1.3231E+05, 1.3265E+05, 1.3299E+05, 1.3332E+05, 1.3366E+05, 1.3400E+05, 1.3434E+05, 1.3468E+05, &
       1.3503E+05, 1.3537E+05, 1.3571E+05, 1.3605E+05, 1.3640E+05, 1.3674E+05, 1.3709E+05, 1.3744E+05, 1.3778E+05, 1.3813E+05, &
       1.3848E+05, 1.3883E+05, 1.3918E+05, 1.3953E+05, 1.3988E+05, 1.4023E+05, 1.4058E+05, 1.4094E+05, 1.4129E+05, 1.4165E+05, &
       1.4200E+05, 1.4236E+05, 1.4271E+05, 1.4307E+05, 1.4343E+05, 1.4379E+05, 1.4415E+05, 1.4451E+05, 1.4487E+05, 1.4523E+05, &
       1.4559E+05, 1.4596E+05, 1.4632E+05, 1.4669E+05, 1.4705E+05, 1.4742E+05, 1.4778E+05, 1.4815E+05, 1.4852E+05, 1.4889E+05, &
       1.4926E+05, 1.4963E+05, 1.5000E+05, 1.5037E+05, 1.5074E+05, 1.5112E+05, 1.5149E+05, 1.5187E+05, 1.5224E+05, 1.5262E+05, &
       1.5299E+05, 1.5337E+05, 1.5375E+05, 1.5413E+05, 1.5451E+05, 1.5489E+05, 1.5527E+05, 1.5565E+05, 1.5604E+05, 1.5642E+05, &
       1.5680E+05, 1.5719E+05, 1.5758E+05, 1.5796E+05, 1.5835E+05, 1.5874E+05, 1.5913E+05, 1.5952E+05, 1.5991E+05, 1.6030E+05, &
       1.6069E+05, 1.6108E+05, 1.6147E+05, 1.6187E+05, 1.6226E+05, 1.6266E+05, 1.6305E+05, 1.6345E+05, 1.6385E+05, 1.6425E+05, &
       1.6465E+05, 1.6505E+05, 1.6545E+05, 1.6585E+05, 1.6625E+05, 1.6666E+05, 1.6706E+05, 1.6746E+05, 1.6787E+05, 1.6828E+05, &
       1.6868E+05, 1.6909E+05, 1.6950E+05, 1.6991E+05, 1.7032E+05, 1.7073E+05, 1.7114E+05, 1.7155E+05, 1.7197E+05, 1.7238E+05, &
       1.7280E+05, 1.7321E+05, 1.7363E+05, 1.7404E+05, 1.7446E+05, 1.7488E+05, 1.7530E+05, 1.7572E+05, 1.7614E+05, 1.7656E+05, &
       1.7699E+05, 1.7741E+05, 1.7783E+05, 1.7826E+05, 1.7868E+05, 1.7911E+05, 1.7954E+05, 1.7997E+05, 1.8040E+05, 1.8083E+05, &
       1.8126E+05, 1.8169E+05, 1.8212E+05, 1.8255E+05, 1.8299E+05, 1.8342E+05, 1.8386E+05, 1.8429E+05, 1.8473E+05, 1.8517E+05, &
       1.8561E+05, 1.8605E+05, 1.8649E+05, 1.8693E+05, 1.8737E+05, 1.8781E+05, 1.8826E+05, 1.8870E+05, 1.8914E+05, 1.8959E+05, &
       1.9004E+05, 1.9049E+05, 1.9093E+05, 1.9138E+05, 1.9183E+05, 1.9228E+05, 1.9274E+05, 1.9319E+05, 1.9364E+05, 1.9410E+05, &
       1.9455E+05, 1.9501E+05, 1.9546E+05, 1.9592E+05, 1.9638E+05, 1.9684E+05, 1.9730E+05, 1.9776E+05, 1.9822E+05, 1.9868E+05, &
       1.9915E+05, 1.9961E+05, 2.0008E+05, 2.0054E+05, 2.0101E+05, 2.0148E+05, 2.0195E+05, 2.0242E+05, 2.0289E+05, 2.0336E+05, &
       2.0383E+05, 2.0430E+05, 2.0478E+05, 2.0525E+05, 2.0573E+05, 2.0620E+05, 2.0668E+05, 2.0716E+05, 2.0764E+05, 2.0812E+05, &
       2.0860E+05, 2.0908E+05, 2.0956E+05, 2.1004E+05, 2.1053E+05, 2.1101E+05, 2.1150E+05, 2.1198E+05, 2.1247E+05, 2.1296E+05, &
       2.1345E+05, 2.1394E+05, 2.1443E+05, 2.1492E+05, 2.1541E+05, 2.1591E+05, 2.1640E+05, 2.1690E+05, 2.1739E+05, 2.1789E+05, &
       2.1839E+05, 2.1889E+05, 2.1939E+05, 2.1989E+05, 2.2039E+05, 2.2089E+05, 2.2140E+05, 2.2190E+05, 2.2241E+05, 2.2291E+05, &
       2.2342E+05, 2.2393E+05, 2.2444E+05, 2.2494E+05, 2.2546E+05, 2.2597E+05, 2.2648E+05, 2.2699E+05, 2.2751E+05, 2.2802E+05, &
       2.2854E+05, 2.2905E+05, 2.2957E+05, 2.3009E+05, 2.3061E+05, 2.3113E+05, 2.3165E+05, 2.3217E+05, 2.3270E+05, 2.3322E+05, &
       2.3375E+05, 2.3427E+05, 2.3480E+05, 2.3533E+05, 2.3586E+05, 2.3639E+05, 2.3692E+05, 2.3745E+05, 2.3798E+05, 2.3851E+05, &
       2.3905E+05, 2.3958E+05, 2.4012E+05, 2.4066E+05, 2.4119E+05, 2.4173E+05, 2.4227E+05, 2.4281E+05, 2.4335E+05, 2.4390E+05, &
       2.4444E+05, 2.4499E+05, 2.4553E+05, 2.4608E+05, 2.4662E+05, 2.4717E+05, 2.4772E+05, 2.4827E+05, 2.4882E+05, 2.4937E+05, &
       2.4993E+05, 2.5048E+05, 2.5104E+05, 2.5159E+05, 2.5215E+05, 2.5271E+05, 2.5327E+05, 2.5383E+05, 2.5439E+05, 2.5495E+05, &
       2.5551E+05, 2.5607E+05, 2.5664E+05, 2.5720E+05, 2.5777E+05, 2.5834E+05, 2.5890E+05, 2.5947E+05, 2.6004E+05, 2.6062E+05, &
       2.6119E+05, 2.6176E+05, 2.6233E+05, 2.6291E+05, 2.6349E+05, 2.6406E+05, 2.6464E+05, 2.6522E+05, 2.6580E+05, 2.6638E+05, &
       2.6696E+05, 2.6755E+05, 2.6813E+05, 2.6871E+05, 2.6930E+05, 2.6989E+05, 2.7047E+05, 2.7106E+05, 2.7165E+05, 2.7224E+05, &
       2.7284E+05, 2.7343E+05, 2.7402E+05, 2.7462E+05, 2.7521E+05, 2.7581E+05, 2.7641E+05, 2.7700E+05, 2.7760E+05, 2.7821E+05, &
       2.7881E+05, 2.7941E+05, 2.8001E+05, 2.8062E+05, 2.8122E+05, 2.8183E+05, 2.8244E+05, 2.8305E+05, 2.8366E+05, 2.8427E+05, &
       2.8488E+05, 2.8549E+05, 2.8611E+05, 2.8672E+05, 2.8734E+05, 2.8795E+05, 2.8857E+05, 2.8919E+05, 2.8981E+05, 2.9043E+05, &
       2.9105E+05, 2.9167E+05, 2.9230E+05, 2.9292E+05, 2.9355E+05, 2.9418E+05, 2.9480E+05, 2.9543E+05, 2.9606E+05, 2.9670E+05, &
       2.9733E+05, 2.9796E+05, 2.9859E+05, 2.9923E+05, 2.9987E+05, 3.0050E+05, 3.0114E+05, 3.0178E+05, 3.0242E+05, 3.0306E+05, &
       3.0371E+05, 3.0435E+05, 3.0499E+05, 3.0564E+05, 3.0629E+05, 3.0693E+05, 3.0758E+05, 3.0823E+05, 3.0888E+05, 3.0954E+05, &
       3.1019E+05, 3.1084E+05, 3.1150E+05, 3.1215E+05, 3.1281E+05, 3.1347E+05, 3.1413E+05, 3.1479E+05, 3.1545E+05, 3.1611E+05, &
       3.1678E+05, 3.1744E+05, 3.1811E+05, 3.1877E+05, 3.1944E+05, 3.2011E+05, 3.2078E+05, 3.2145E+05, 3.2212E+05, 3.2280E+05, &
       3.2347E+05, 3.2415E+05, 3.2482E+05, 3.2550E+05, 3.2618E+05, 3.2686E+05, 3.2754E+05, 3.2822E+05, 3.2891E+05, 3.2959E+05, &
       3.3028E+05, 3.3096E+05, 3.3165E+05, 3.3234E+05, 3.3303E+05, 3.3372E+05, 3.3441E+05, 3.3510E+05, 3.3580E+05, 3.3649E+05, &
       3.3719E+05, 3.3788E+05, 3.3858E+05, 3.3928E+05, 3.3998E+05, 3.4068E+05, 3.4139E+05, 3.4209E+05, 3.4279E+05, 3.4350E+05, &
       3.4421E+05, 3.4492E+05, 3.4562E+05, 3.4633E+05, 3.4705E+05, 3.4776E+05, 3.4847E+05, 3.4919E+05, 3.4990E+05, 3.5062E+05, &
       3.5134E+05, 3.5206E+05, 3.5278E+05, 3.5350E+05, 3.5422E+05, 3.5495E+05, 3.5567E+05, 3.5640E+05, 3.5712E+05, 3.5785E+05, &
       3.5858E+05, 3.5931E+05, 3.6004E+05, 3.6078E+05, 3.6151E+05, 3.6225E+05, 3.6298E+05, 3.6372E+05, 3.6446E+05, 3.6520E+05, &
       3.6594E+05, 3.6668E+05, 3.6742E+05, 3.6817E+05, 3.6891E+05, 3.6966E+05, 3.7041E+05, 3.7116E+05, 3.7191E+05, 3.7266E+05, &
       3.7341E+05, 3.7416E+05, 3.7492E+05, 3.7567E+05, 3.7643E+05, 3.7719E+05, 3.7795E+05, 3.7871E+05, 3.7947E+05, 3.8023E+05, &
       3.8099E+05, 3.8176E+05, 3.8253E+05, 3.8329E+05, 3.8406E+05, 3.8483E+05, 3.8560E+05, 3.8637E+05, 3.8715E+05, 3.8792E+05, &
       3.8870E+05, 3.8947E+05, 3.9025E+05, 3.9103E+05, 3.9181E+05, 3.9259E+05, 3.9337E+05, 3.9416E+05, 3.9494E+05, 3.9573E+05, &
       3.9651E+05, 3.9730E+05, 3.9809E+05, 3.9888E+05, 3.9968E+05, 4.0047E+05, 4.0126E+05, 4.0206E+05, 4.0285E+05, 4.0365E+05, &
       4.0445E+05, 4.0525E+05, 4.0605E+05, 4.0686E+05, 4.0766E+05, 4.0846E+05, 4.0927E+05, 4.1008E+05, 4.1089E+05, 4.1170E+05, &
       4.1251E+05, 4.1332E+05, 4.1413E+05, 4.1495E+05, 4.1576E+05, 4.1658E+05, 4.1740E+05, 4.1822E+05, 4.1904E+05, 4.1986E+05, &
       4.2068E+05, 4.2151E+05, 4.2233E+05, 4.2316E+05, 4.2399E+05, 4.2482E+05, 4.2565E+05, 4.2648E+05, 4.2731E+05, 4.2815E+05, &
       4.2898E+05, 4.2982E+05, 4.3066E+05, 4.3149E+05, 4.3233E+05, 4.3318E+05, 4.3402E+05, 4.3486E+05, 4.3571E+05, 4.3655E+05, &
       4.3740E+05, 4.3825E+05, 4.3910E+05, 4.3995E+05, 4.4080E+05, 4.4166E+05, 4.4251E+05, 4.4337E+05, 4.4423E+05, 4.4508E+05, &
       4.4594E+05, 4.4681E+05, 4.4767E+05, 4.4853E+05, 4.4940E+05, 4.5026E+05, 4.5113E+05, 4.5200E+05, 4.5287E+05, 4.5374E+05, &
       4.5461E+05, 4.5549E+05, 4.5636E+05, 4.5724E+05, 4.5812E+05, 4.5899E+05, 4.5987E+05, 4.6075E+05, 4.6164E+05, 4.6252E+05, &
       4.6341E+05, 4.6429E+05, 4.6518E+05, 4.6607E+05, 4.6696E+05, 4.6785E+05, 4.6874E+05, 4.6964E+05, 4.7053E+05, 4.7143E+05, &
       4.7233E+05, 4.7323E+05, 4.7413E+05, 4.7503E+05, 4.7593E+05, 4.7683E+05, 4.7774E+05, 4.7865E+05, 4.7955E+05, 4.8046E+05, &
       4.8137E+05, 4.8229E+05, 4.8320E+05, 4.8411E+05, 4.8503E+05, 4.8595E+05, 4.8686E+05, 4.8778E+05, 4.8870E+05, 4.8963E+05, &
       4.9055E+05, 4.9147E+05, 4.9240E+05, 4.9333E+05, 4.9426E+05, 4.9519E+05, 4.9612E+05, 4.9705E+05, 4.9798E+05, 4.9892E+05, &
       4.9986E+05, 5.0079E+05, 5.0173E+05, 5.0267E+05, 5.0361E+05, 5.0456E+05, 5.0550E+05, 5.0645E+05, 5.0739E+05, 5.0834E+05, &
       5.0929E+05, 5.1024E+05, 5.1120E+05, 5.1215E+05, 5.1310E+05, 5.1406E+05, 5.1502E+05, 5.1598E+05, 5.1694E+05, 5.1790E+05, &
       5.1886E+05, 5.1982E+05, 5.2079E+05, 5.2176E+05, 5.2272E+05, 5.2369E+05, 5.2466E+05, 5.2564E+05, 5.2661E+05, 5.2758E+05, &
       5.2856E+05, 5.2954E+05, 5.3052E+05, 5.3150E+05, 5.3248E+05, 5.3346E+05, 5.3445E+05, 5.3543E+05, 5.3642E+05, 5.3741E+05, &
       5.3840E+05, 5.3939E+05, 5.4038E+05, 5.4137E+05, 5.4237E+05, 5.4336E+05, 5.4436E+05, 5.4536E+05, 5.4636E+05, 5.4736E+05, &
       5.4836E+05, 5.4937E+05, 5.5037E+05, 5.5138E+05, 5.5239E+05, 5.5340E+05, 5.5441E+05, 5.5542E+05, 5.5644E+05, 5.5745E+05, &
       5.5847E+05, 5.5949E+05, 5.6051E+05, 5.6153E+05, 5.6255E+05, 5.6357E+05, 5.6460E+05, 5.6562E+05, 5.6665E+05, 5.6768E+05, &
       5.6871E+05, 5.6974E+05, 5.7078E+05, 5.7181E+05, 5.7285E+05, 5.7388E+05, 5.7492E+05, 5.7596E+05, 5.7700E+05, 5.7805E+05, &
       5.7909E+05, 5.8013E+05, 5.8118E+05, 5.8223E+05, 5.8328E+05, 5.8433E+05, 5.8538E+05, 5.8644E+05, 5.8749E+05, 5.8855E+05, &
       5.8961E+05, 5.9067E+05, 5.9173E+05, 5.9279E+05, 5.9385E+05, 5.9492E+05, 5.9598E+05, 5.9705E+05, 5.9812E+05, 5.9919E+05, &
       6.0026E+05, 6.0134E+05, 6.0241E+05, 6.0349E+05, 6.0457E+05, 6.0565E+05, 6.0673E+05, 6.0781E+05, 6.0889E+05, 6.0998E+05, &
       6.1106E+05, 6.1215E+05, 6.1324E+05, 6.1433E+05, 6.1542E+05, 6.1651E+05, 6.1761E+05, 6.1870E+05, 6.1980E+05, 6.2090E+05, &
       6.2200E+05, 6.2310E+05, 6.2421E+05, 6.2531E+05, 6.2642E+05, 6.2752E+05, 6.2863E+05, 6.2974E+05, 6.3086E+05, 6.3197E+05, &
       6.3308E+05, 6.3420E+05, 6.3532E+05, 6.3644E+05, 6.3756E+05, 6.3868E+05, 6.3980E+05, 6.4093E+05, 6.4205E+05, 6.4318E+05, &
       6.4431E+05, 6.4544E+05, 6.4657E+05, 6.4770E+05, 6.4884E+05, 6.4998E+05, 6.5111E+05, 6.5225E+05, 6.5339E+05, 6.5453E+05, &
       6.5568E+05, 6.5682E+05, 6.5797E+05, 6.5912E+05, 6.6027E+05, 6.6142E+05, 6.6257E+05, 6.6372E+05, 6.6488E+05, 6.6604E+05, &
       6.6719E+05, 6.6835E+05, 6.6951E+05, 6.7068E+05, 6.7184E+05, 6.7301E+05, 6.7417E+05, 6.7534E+05, 6.7651E+05, 6.7768E+05, &
       6.7885E+05, 6.8003E+05, 6.8120E+05, 6.8238E+05, 6.8356E+05, 6.8474E+05, 6.8592E+05, 6.8711E+05, 6.8829E+05, 6.8948E+05, &
       6.9066E+05, 6.9185E+05, 6.9304E+05, 6.9423E+05, 6.9543E+05, 6.9662E+05, 6.9782E+05, 6.9902E+05, 7.0022E+05, 7.0142E+05, &
       7.0262E+05, 7.0382E+05, 7.0503E+05, 7.0624E+05, 7.0744E+05, 7.0865E+05, 7.0987E+05, 7.1108E+05, 7.1229E+05, 7.1351E+05, &
       7.1473E+05, 7.1594E+05, 7.1716E+05, 7.1839E+05, 7.1961E+05, 7.2083E+05, 7.2206E+05, 7.2329E+05, 7.2452E+05, 7.2575E+05, &
       7.2698E+05, 7.2822E+05, 7.2945E+05, 7.3069E+05, 7.3193E+05, 7.3317E+05, 7.3441E+05, 7.3565E+05, 7.3689E+05, 7.3814E+05, &
       7.3939E+05, 7.4064E+05, 7.4189E+05, 7.4314E+05, 7.4439E+05, 7.4565E+05, 7.4690E+05, 7.4816E+05, 7.4942E+05, 7.5068E+05/
      data (QofT( 1,J),J=2409,4510)/ 7.5195E+05, 7.5321E+05, 7.5448E+05, 7.5574E+05, 7.5701E+05, 7.5828E+05, 7.5955E+05, 7.6083E+05, &
       7.6210E+05, 7.6338E+05, 7.6466E+05, 7.6594E+05, 7.6722E+05, 7.6850E+05, 7.6978E+05, 7.7107E+05, 7.7236E+05, 7.7365E+05, &
       7.7494E+05, 7.7623E+05, 7.7752E+05, 7.7882E+05, 7.8011E+05, 7.8141E+05, 7.8271E+05, 7.8401E+05, 7.8531E+05, 7.8662E+05, &
       7.8792E+05, 7.8923E+05, 7.9054E+05, 7.9185E+05, 7.9316E+05, 7.9448E+05, 7.9579E+05, 7.9711E+05, 7.9843E+05, 7.9975E+05, &
       8.0107E+05, 8.0239E+05, 8.0371E+05, 8.0504E+05, 8.0637E+05, 8.0770E+05, 8.0903E+05, 8.1036E+05, 8.1169E+05, 8.1303E+05, &
       8.1437E+05, 8.1570E+05, 8.1704E+05, 8.1839E+05, 8.1973E+05, 8.2107E+05, 8.2242E+05, 8.2377E+05, 8.2512E+05, 8.2647E+05, &
       8.2782E+05, 8.2918E+05, 8.3053E+05, 8.3189E+05, 8.3325E+05, 8.3461E+05, 8.3597E+05, 8.3734E+05, 8.3870E+05, 8.4007E+05, &
       8.4144E+05, 8.4281E+05, 8.4418E+05, 8.4555E+05, 8.4693E+05, 8.4830E+05, 8.4968E+05, 8.5106E+05, 8.5244E+05, 8.5382E+05, &
       8.5521E+05, 8.5659E+05, 8.5798E+05, 8.5937E+05, 8.6076E+05, 8.6215E+05, 8.6355E+05, 8.6494E+05, 8.6634E+05, 8.6774E+05, &
       8.6914E+05, 8.7054E+05, 8.7194E+05, 8.7335E+05, 8.7476E+05, 8.7616E+05, 8.7757E+05, 8.7899E+05, 8.8040E+05, 8.8181E+05, &
       8.8323E+05, 8.8465E+05, 8.8607E+05, 8.8749E+05, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       636
      data (QofT( 2,J),J=1,2408)/ 2.3445E+00, 3.9214E+00, 5.6896E+00, 7.4672E+00, 9.2463E+00, 1.1026E+01, 1.2806E+01, 1.4587E+01, &
       1.6367E+01, 1.8148E+01, 1.9929E+01, 2.1709E+01, 2.3490E+01, 2.5271E+01, 2.7052E+01, 2.8833E+01, 3.0614E+01, 3.2395E+01, &
       3.4176E+01, 3.5957E+01, 3.9519E+01, 4.3081E+01, 4.6644E+01, 5.0206E+01, 5.3768E+01, 5.7330E+01, 6.0893E+01, 6.4455E+01, &
       6.8017E+01, 7.1580E+01, 7.5142E+01, 7.8705E+01, 8.2267E+01, 8.5830E+01, 8.9392E+01, 9.2955E+01, 9.6517E+01, 1.0008E+02, &
       1.0364E+02, 1.0720E+02, 1.1077E+02, 1.1433E+02, 1.1789E+02, 1.2146E+02, 1.2502E+02, 1.2858E+02, 1.3214E+02, 1.3571E+02, &
       1.3927E+02, 1.4283E+02, 1.4640E+02, 1.4996E+02, 1.5353E+02, 1.5709E+02, 1.6066E+02, 1.6422E+02, 1.6779E+02, 1.7135E+02, &
       1.7492E+02, 1.7849E+02, 1.8206E+02, 1.8563E+02, 1.8921E+02, 1.9278E+02, 1.9636E+02, 1.9993E+02, 2.0351E+02, 2.0710E+02, &
       2.1068E+02, 2.1427E+02, 2.1786E+02, 2.2145E+02, 2.2505E+02, 2.2865E+02, 2.3226E+02, 2.3587E+02, 2.3948E+02, 2.4310E+02, &
       2.4673E+02, 2.5036E+02, 2.5399E+02, 2.5764E+02, 2.6128E+02, 2.6494E+02, 2.6860E+02, 2.7227E+02, 2.7595E+02, 2.7964E+02, &
       2.8333E+02, 2.8703E+02, 2.9074E+02, 2.9446E+02, 2.9820E+02, 3.0194E+02, 3.0569E+02, 3.0945E+02, 3.1322E+02, 3.1701E+02, &
       3.2081E+02, 3.2461E+02, 3.2844E+02, 3.3227E+02, 3.3612E+02, 3.3998E+02, 3.4385E+02, 3.4774E+02, 3.5164E+02, 3.5556E+02, &
       3.5949E+02, 3.6344E+02, 3.6740E+02, 3.7138E+02, 3.7538E+02, 3.7939E+02, 3.8342E+02, 3.8746E+02, 3.9153E+02, 3.9561E+02, &
       3.9971E+02, 4.0383E+02, 4.0797E+02, 4.1212E+02, 4.1630E+02, 4.2049E+02, 4.2471E+02, 4.2894E+02, 4.3320E+02, 4.3747E+02, &
       4.4177E+02, 4.4609E+02, 4.5042E+02, 4.5479E+02, 4.5917E+02, 4.6357E+02, 4.6800E+02, 4.7245E+02, 4.7693E+02, 4.8142E+02, &
       4.8594E+02, 4.9049E+02, 4.9506E+02, 4.9965E+02, 5.0427E+02, 5.0891E+02, 5.1358E+02, 5.1827E+02, 5.2299E+02, 5.2773E+02, &
       5.3250E+02, 5.3730E+02, 5.4212E+02, 5.4697E+02, 5.5185E+02, 5.5675E+02, 5.6168E+02, 5.6664E+02, 5.7163E+02, 5.7664E+02, &
       5.8169E+02, 5.8676E+02, 5.9186E+02, 5.9699E+02, 6.0215E+02, 6.0734E+02, 6.1255E+02, 6.1780E+02, 6.2308E+02, 6.2839E+02, &
       6.3373E+02, 6.3910E+02, 6.4450E+02, 6.4993E+02, 6.5540E+02, 6.6089E+02, 6.6642E+02, 6.7198E+02, 6.7757E+02, 6.8319E+02, &
       6.8885E+02, 6.9454E+02, 7.0026E+02, 7.0602E+02, 7.1181E+02, 7.1764E+02, 7.2349E+02, 7.2939E+02, 7.3531E+02, 7.4127E+02, &
       7.4727E+02, 7.5330E+02, 7.5937E+02, 7.6547E+02, 7.7161E+02, 7.7779E+02, 7.8400E+02, 7.9024E+02, 7.9653E+02, 8.0285E+02, &
       8.0921E+02, 8.1560E+02, 8.2203E+02, 8.2850E+02, 8.3501E+02, 8.4156E+02, 8.4814E+02, 8.5477E+02, 8.6143E+02, 8.6813E+02, &
       8.7487E+02, 8.8165E+02, 8.8847E+02, 8.9533E+02, 9.0223E+02, 9.0917E+02, 9.1615E+02, 9.2317E+02, 9.3023E+02, 9.3733E+02, &
       9.4448E+02, 9.5166E+02, 9.5889E+02, 9.6616E+02, 9.7348E+02, 9.8083E+02, 9.8823E+02, 9.9567E+02, 1.0032E+03, 1.0107E+03, &
       1.0183E+03, 1.0259E+03, 1.0335E+03, 1.0412E+03, 1.0490E+03, 1.0568E+03, 1.0646E+03, 1.0725E+03, 1.0804E+03, 1.0884E+03, &
       1.0964E+03, 1.1045E+03, 1.1126E+03, 1.1207E+03, 1.1290E+03, 1.1372E+03, 1.1455E+03, 1.1538E+03, 1.1622E+03, 1.1707E+03, &
       1.1792E+03, 1.1877E+03, 1.1963E+03, 1.2049E+03, 1.2136E+03, 1.2224E+03, 1.2312E+03, 1.2400E+03, 1.2489E+03, 1.2578E+03, &
       1.2668E+03, 1.2758E+03, 1.2849E+03, 1.2941E+03, 1.3033E+03, 1.3125E+03, 1.3218E+03, 1.3311E+03, 1.3405E+03, 1.3500E+03, &
       1.3595E+03, 1.3691E+03, 1.3787E+03, 1.3883E+03, 1.3981E+03, 1.4078E+03, 1.4177E+03, 1.4275E+03, 1.4375E+03, 1.4475E+03, &
       1.4575E+03, 1.4676E+03, 1.4778E+03, 1.4880E+03, 1.4983E+03, 1.5086E+03, 1.5190E+03, 1.5294E+03, 1.5399E+03, 1.5505E+03, &
       1.5611E+03, 1.5718E+03, 1.5825E+03, 1.5933E+03, 1.6042E+03, 1.6151E+03, 1.6261E+03, 1.6371E+03, 1.6482E+03, 1.6594E+03, &
       1.6706E+03, 1.6818E+03, 1.6932E+03, 1.7046E+03, 1.7160E+03, 1.7276E+03, 1.7392E+03, 1.7508E+03, 1.7625E+03, 1.7743E+03, &
       1.7861E+03, 1.7980E+03, 1.8100E+03, 1.8220E+03, 1.8341E+03, 1.8463E+03, 1.8585E+03, 1.8708E+03, 1.8831E+03, 1.8956E+03, &
       1.9081E+03, 1.9206E+03, 1.9332E+03, 1.9459E+03, 1.9587E+03, 1.9715E+03, 1.9844E+03, 1.9973E+03, 2.0104E+03, 2.0235E+03, &
       2.0366E+03, 2.0499E+03, 2.0632E+03, 2.0766E+03, 2.0900E+03, 2.1035E+03, 2.1171E+03, 2.1308E+03, 2.1445E+03, 2.1583E+03, &
       2.1722E+03, 2.1861E+03, 2.2001E+03, 2.2142E+03, 2.2284E+03, 2.2427E+03, 2.2570E+03, 2.2714E+03, 2.2858E+03, 2.3004E+03, &
       2.3150E+03, 2.3297E+03, 2.3444E+03, 2.3593E+03, 2.3742E+03, 2.3892E+03, 2.4043E+03, 2.4194E+03, 2.4346E+03, 2.4499E+03, &
       2.4653E+03, 2.4808E+03, 2.4963E+03, 2.5119E+03, 2.5276E+03, 2.5434E+03, 2.5593E+03, 2.5752E+03, 2.5912E+03, 2.6074E+03, &
       2.6235E+03, 2.6398E+03, 2.6562E+03, 2.6726E+03, 2.6891E+03, 2.7057E+03, 2.7224E+03, 2.7392E+03, 2.7560E+03, 2.7729E+03, &
       2.7900E+03, 2.8071E+03, 2.8243E+03, 2.8415E+03, 2.8589E+03, 2.8763E+03, 2.8939E+03, 2.9115E+03, 2.9292E+03, 2.9470E+03, &
       2.9649E+03, 2.9829E+03, 3.0010E+03, 3.0191E+03, 3.0374E+03, 3.0557E+03, 3.0741E+03, 3.0926E+03, 3.1112E+03, 3.1299E+03, &
       3.1487E+03, 3.1676E+03, 3.1866E+03, 3.2057E+03, 3.2248E+03, 3.2441E+03, 3.2634E+03, 3.2829E+03, 3.3024E+03, 3.3221E+03, &
       3.3418E+03, 3.3616E+03, 3.3815E+03, 3.4016E+03, 3.4217E+03, 3.4419E+03, 3.4622E+03, 3.4826E+03, 3.5031E+03, 3.5237E+03, &
       3.5444E+03, 3.5652E+03, 3.5861E+03, 3.6072E+03, 3.6283E+03, 3.6495E+03, 3.6708E+03, 3.6922E+03, 3.7137E+03, 3.7353E+03, &
       3.7570E+03, 3.7789E+03, 3.8008E+03, 3.8228E+03, 3.8450E+03, 3.8672E+03, 3.8895E+03, 3.9120E+03, 3.9346E+03, 3.9572E+03, &
       3.9800E+03, 4.0029E+03, 4.0259E+03, 4.0490E+03, 4.0722E+03, 4.0955E+03, 4.1189E+03, 4.1424E+03, 4.1661E+03, 4.1898E+03, &
       4.2137E+03, 4.2377E+03, 4.2617E+03, 4.2859E+03, 4.3103E+03, 4.3347E+03, 4.3592E+03, 4.3839E+03, 4.4086E+03, 4.4335E+03, &
       4.4585E+03, 4.4836E+03, 4.5088E+03, 4.5342E+03, 4.5596E+03, 4.5852E+03, 4.6109E+03, 4.6367E+03, 4.6627E+03, 4.6887E+03, &
       4.7149E+03, 4.7412E+03, 4.7676E+03, 4.7941E+03, 4.8208E+03, 4.8475E+03, 4.8744E+03, 4.9014E+03, 4.9286E+03, 4.9559E+03, &
       4.9832E+03, 5.0107E+03, 5.0384E+03, 5.0661E+03, 5.0940E+03, 5.1220E+03, 5.1502E+03, 5.1784E+03, 5.2068E+03, 5.2353E+03, &
       5.2640E+03, 5.2928E+03, 5.3217E+03, 5.3507E+03, 5.3799E+03, 5.4092E+03, 5.4386E+03, 5.4681E+03, 5.4978E+03, 5.5277E+03, &
       5.5576E+03, 5.5877E+03, 5.6179E+03, 5.6483E+03, 5.6787E+03, 5.7094E+03, 5.7401E+03, 5.7710E+03, 5.8020E+03, 5.8332E+03, &
       5.8645E+03, 5.8960E+03, 5.9275E+03, 5.9593E+03, 5.9911E+03, 6.0231E+03, 6.0552E+03, 6.0875E+03, 6.1199E+03, 6.1525E+03, &
       6.1852E+03, 6.2180E+03, 6.2510E+03, 6.2842E+03, 6.3174E+03, 6.3509E+03, 6.3844E+03, 6.4181E+03, 6.4520E+03, 6.4860E+03, &
       6.5201E+03, 6.5544E+03, 6.5889E+03, 6.6235E+03, 6.6582E+03, 6.6931E+03, 6.7281E+03, 6.7633E+03, 6.7987E+03, 6.8342E+03, &
       6.8698E+03, 6.9056E+03, 6.9415E+03, 6.9777E+03, 7.0139E+03, 7.0503E+03, 7.0869E+03, 7.1236E+03, 7.1605E+03, 7.1975E+03, &
       7.2347E+03, 7.2721E+03, 7.3096E+03, 7.3472E+03, 7.3850E+03, 7.4230E+03, 7.4612E+03, 7.4995E+03, 7.5379E+03, 7.5766E+03, &
       7.6154E+03, 7.6543E+03, 7.6934E+03, 7.7327E+03, 7.7721E+03, 7.8118E+03, 7.8515E+03, 7.8915E+03, 7.9316E+03, 7.9718E+03, &
       8.0123E+03, 8.0529E+03, 8.0937E+03, 8.1346E+03, 8.1757E+03, 8.2170E+03, 8.2585E+03, 8.3001E+03, 8.3419E+03, 8.3839E+03, &
       8.4260E+03, 8.4683E+03, 8.5108E+03, 8.5535E+03, 8.5963E+03, 8.6393E+03, 8.6825E+03, 8.7259E+03, 8.7694E+03, 8.8132E+03, &
       8.8571E+03, 8.9012E+03, 8.9454E+03, 8.9899E+03, 9.0345E+03, 9.0793E+03, 9.1243E+03, 9.1694E+03, 9.2148E+03, 9.2603E+03, &
       9.3061E+03, 9.3520E+03, 9.3981E+03, 9.4443E+03, 9.4908E+03, 9.5374E+03, 9.5843E+03, 9.6313E+03, 9.6785E+03, 9.7259E+03, &
       9.7735E+03, 9.8213E+03, 9.8693E+03, 9.9174E+03, 9.9658E+03, 1.0014E+04, 1.0063E+04, 1.0112E+04, 1.0161E+04, 1.0211E+04, &
       1.0260E+04, 1.0310E+04, 1.0360E+04, 1.0410E+04, 1.0460E+04, 1.0511E+04, 1.0561E+04, 1.0612E+04, 1.0663E+04, 1.0715E+04, &
       1.0766E+04, 1.0818E+04, 1.0870E+04, 1.0922E+04, 1.0974E+04, 1.1027E+04, 1.1080E+04, 1.1133E+04, 1.1186E+04, 1.1239E+04, &
       1.1293E+04, 1.1346E+04, 1.1400E+04, 1.1455E+04, 1.1509E+04, 1.1564E+04, 1.1619E+04, 1.1674E+04, 1.1729E+04, 1.1784E+04, &
       1.1840E+04, 1.1896E+04, 1.1952E+04, 1.2008E+04, 1.2065E+04, 1.2122E+04, 1.2179E+04, 1.2236E+04, 1.2293E+04, 1.2351E+04, &
       1.2409E+04, 1.2467E+04, 1.2525E+04, 1.2584E+04, 1.2643E+04, 1.2702E+04, 1.2761E+04, 1.2820E+04, 1.2880E+04, 1.2940E+04, &
       1.3000E+04, 1.3060E+04, 1.3121E+04, 1.3182E+04, 1.3243E+04, 1.3304E+04, 1.3365E+04, 1.3427E+04, 1.3489E+04, 1.3551E+04, &
       1.3614E+04, 1.3676E+04, 1.3739E+04, 1.3802E+04, 1.3866E+04, 1.3929E+04, 1.3993E+04, 1.4057E+04, 1.4122E+04, 1.4186E+04, &
       1.4251E+04, 1.4316E+04, 1.4381E+04, 1.4447E+04, 1.4513E+04, 1.4579E+04, 1.4645E+04, 1.4712E+04, 1.4778E+04, 1.4845E+04, &
       1.4913E+04, 1.4980E+04, 1.5048E+04, 1.5116E+04, 1.5184E+04, 1.5253E+04, 1.5321E+04, 1.5390E+04, 1.5460E+04, 1.5529E+04, &
       1.5599E+04, 1.5669E+04, 1.5739E+04, 1.5810E+04, 1.5881E+04, 1.5952E+04, 1.6023E+04, 1.6095E+04, 1.6166E+04, 1.6239E+04, &
       1.6311E+04, 1.6384E+04, 1.6456E+04, 1.6530E+04, 1.6603E+04, 1.6677E+04, 1.6751E+04, 1.6825E+04, 1.6899E+04, 1.6974E+04, &
       1.7049E+04, 1.7125E+04, 1.7200E+04, 1.7276E+04, 1.7352E+04, 1.7428E+04, 1.7505E+04, 1.7582E+04, 1.7659E+04, 1.7737E+04, &
       1.7815E+04, 1.7893E+04, 1.7971E+04, 1.8050E+04, 1.8128E+04, 1.8208E+04, 1.8287E+04, 1.8367E+04, 1.8447E+04, 1.8527E+04, &
       1.8608E+04, 1.8689E+04, 1.8770E+04, 1.8851E+04, 1.8933E+04, 1.9015E+04, 1.9097E+04, 1.9180E+04, 1.9263E+04, 1.9346E+04, &
       1.9430E+04, 1.9513E+04, 1.9597E+04, 1.9682E+04, 1.9766E+04, 1.9851E+04, 1.9937E+04, 2.0022E+04, 2.0108E+04, 2.0194E+04, &
       2.0281E+04, 2.0367E+04, 2.0454E+04, 2.0542E+04, 2.0629E+04, 2.0717E+04, 2.0806E+04, 2.0894E+04, 2.0983E+04, 2.1072E+04, &
       2.1162E+04, 2.1252E+04, 2.1342E+04, 2.1432E+04, 2.1523E+04, 2.1614E+04, 2.1705E+04, 2.1797E+04, 2.1889E+04, 2.1982E+04, &
       2.2074E+04, 2.2167E+04, 2.2260E+04, 2.2354E+04, 2.2448E+04, 2.2542E+04, 2.2637E+04, 2.2732E+04, 2.2827E+04, 2.2922E+04, &
       2.3018E+04, 2.3114E+04, 2.3211E+04, 2.3308E+04, 2.3405E+04, 2.3502E+04, 2.3600E+04, 2.3698E+04, 2.3797E+04, 2.3896E+04, &
       2.3995E+04, 2.4094E+04, 2.4194E+04, 2.4294E+04, 2.4395E+04, 2.4496E+04, 2.4597E+04, 2.4698E+04, 2.4800E+04, 2.4902E+04, &
       2.5005E+04, 2.5108E+04, 2.5211E+04, 2.5315E+04, 2.5419E+04, 2.5523E+04, 2.5627E+04, 2.5732E+04, 2.5838E+04, 2.5943E+04, &
       2.6049E+04, 2.6156E+04, 2.6263E+04, 2.6370E+04, 2.6477E+04, 2.6585E+04, 2.6693E+04, 2.6802E+04, 2.6910E+04, 2.7020E+04, &
       2.7129E+04, 2.7239E+04, 2.7349E+04, 2.7460E+04, 2.7571E+04, 2.7683E+04, 2.7794E+04, 2.7906E+04, 2.8019E+04, 2.8132E+04, &
       2.8245E+04, 2.8359E+04, 2.8473E+04, 2.8587E+04, 2.8702E+04, 2.8817E+04, 2.8932E+04, 2.9048E+04, 2.9164E+04, 2.9281E+04, &
       2.9398E+04, 2.9515E+04, 2.9633E+04, 2.9751E+04, 2.9870E+04, 2.9989E+04, 3.0108E+04, 3.0228E+04, 3.0348E+04, 3.0468E+04, &
       3.0589E+04, 3.0710E+04, 3.0832E+04, 3.0954E+04, 3.1076E+04, 3.1199E+04, 3.1322E+04, 3.1446E+04, 3.1569E+04, 3.1694E+04, &
       3.1819E+04, 3.1944E+04, 3.2069E+04, 3.2195E+04, 3.2322E+04, 3.2448E+04, 3.2576E+04, 3.2703E+04, 3.2831E+04, 3.2959E+04, &
       3.3088E+04, 3.3217E+04, 3.3347E+04, 3.3477E+04, 3.3607E+04, 3.3738E+04, 3.3870E+04, 3.4001E+04, 3.4133E+04, 3.4266E+04, &
       3.4399E+04, 3.4532E+04, 3.4666E+04, 3.4800E+04, 3.4935E+04, 3.5070E+04, 3.5205E+04, 3.5341E+04, 3.5477E+04, 3.5614E+04, &
       3.5751E+04, 3.5889E+04, 3.6027E+04, 3.6165E+04, 3.6304E+04, 3.6443E+04, 3.6583E+04, 3.6723E+04, 3.6864E+04, 3.7005E+04, &
       3.7146E+04, 3.7288E+04, 3.7430E+04, 3.7573E+04, 3.7717E+04, 3.7860E+04, 3.8004E+04, 3.8149E+04, 3.8294E+04, 3.8439E+04, &
       3.8585E+04, 3.8732E+04, 3.8878E+04, 3.9026E+04, 3.9173E+04, 3.9322E+04, 3.9470E+04, 3.9619E+04, 3.9769E+04, 3.9919E+04, &
       4.0069E+04, 4.0220E+04, 4.0371E+04, 4.0523E+04, 4.0676E+04, 4.0828E+04, 4.0981E+04, 4.1135E+04, 4.1289E+04, 4.1444E+04, &
       4.1599E+04, 4.1755E+04, 4.1911E+04, 4.2067E+04, 4.2224E+04, 4.2381E+04, 4.2539E+04, 4.2698E+04, 4.2857E+04, 4.3016E+04, &
       4.3176E+04, 4.3336E+04, 4.3497E+04, 4.3658E+04, 4.3820E+04, 4.3982E+04, 4.4145E+04, 4.4308E+04, 4.4472E+04, 4.4636E+04, &
       4.4801E+04, 4.4966E+04, 4.5132E+04, 4.5298E+04, 4.5464E+04, 4.5632E+04, 4.5799E+04, 4.5967E+04, 4.6136E+04, 4.6305E+04, &
       4.6475E+04, 4.6645E+04, 4.6816E+04, 4.6987E+04, 4.7159E+04, 4.7331E+04, 4.7503E+04, 4.7677E+04, 4.7850E+04, 4.8025E+04, &
       4.8199E+04, 4.8375E+04, 4.8550E+04, 4.8727E+04, 4.8903E+04, 4.9081E+04, 4.9259E+04, 4.9437E+04, 4.9616E+04, 4.9795E+04, &
       4.9975E+04, 5.0156E+04, 5.0337E+04, 5.0518E+04, 5.0700E+04, 5.0883E+04, 5.1066E+04, 5.1249E+04, 5.1434E+04, 5.1618E+04, &
       5.1804E+04, 5.1989E+04, 5.2176E+04, 5.2363E+04, 5.2550E+04, 5.2738E+04, 5.2926E+04, 5.3115E+04, 5.3305E+04, 5.3495E+04, &
       5.3686E+04, 5.3877E+04, 5.4069E+04, 5.4261E+04, 5.4454E+04, 5.4647E+04, 5.4841E+04, 5.5036E+04, 5.5231E+04, 5.5427E+04, &
       5.5623E+04, 5.5820E+04, 5.6017E+04, 5.6215E+04, 5.6413E+04, 5.6612E+04, 5.6812E+04, 5.7012E+04, 5.7213E+04, 5.7414E+04, &
       5.7616E+04, 5.7818E+04, 5.8022E+04, 5.8225E+04, 5.8429E+04, 5.8634E+04, 5.8839E+04, 5.9045E+04, 5.9252E+04, 5.9459E+04, &
       5.9667E+04, 5.9875E+04, 6.0084E+04, 6.0293E+04, 6.0503E+04, 6.0714E+04, 6.0925E+04, 6.1137E+04, 6.1349E+04, 6.1562E+04, &
       6.1776E+04, 6.1990E+04, 6.2205E+04, 6.2420E+04, 6.2636E+04, 6.2853E+04, 6.3070E+04, 6.3287E+04, 6.3506E+04, 6.3725E+04, &
       6.3945E+04, 6.4165E+04, 6.4386E+04, 6.4607E+04, 6.4829E+04, 6.5052E+04, 6.5275E+04, 6.5499E+04, 6.5724E+04, 6.5949E+04, &
       6.6174E+04, 6.6401E+04, 6.6628E+04, 6.6856E+04, 6.7084E+04, 6.7313E+04, 6.7542E+04, 6.7772E+04, 6.8003E+04, 6.8235E+04, &
       6.8467E+04, 6.8699E+04, 6.8933E+04, 6.9167E+04, 6.9401E+04, 6.9637E+04, 6.9873E+04, 7.0109E+04, 7.0346E+04, 7.0584E+04, &
       7.0823E+04, 7.1062E+04, 7.1302E+04, 7.1542E+04, 7.1783E+04, 7.2025E+04, 7.2267E+04, 7.2510E+04, 7.2754E+04, 7.2998E+04, &
       7.3243E+04, 7.3489E+04, 7.3735E+04, 7.3983E+04, 7.4230E+04, 7.4479E+04, 7.4728E+04, 7.4977E+04, 7.5228E+04, 7.5479E+04, &
       7.5731E+04, 7.5983E+04, 7.6236E+04, 7.6490E+04, 7.6744E+04, 7.6999E+04, 7.7255E+04, 7.7512E+04, 7.7769E+04, 7.8027E+04, &
       7.8285E+04, 7.8544E+04, 7.8804E+04, 7.9065E+04, 7.9326E+04, 7.9588E+04, 7.9851E+04, 8.0114E+04, 8.0379E+04, 8.0643E+04, &
       8.0909E+04, 8.1175E+04, 8.1442E+04, 8.1710E+04, 8.1978E+04, 8.2247E+04, 8.2517E+04, 8.2787E+04, 8.3058E+04, 8.3330E+04, &
       8.3603E+04, 8.3876E+04, 8.4150E+04, 8.4425E+04, 8.4701E+04, 8.4977E+04, 8.5254E+04, 8.5531E+04, 8.5810E+04, 8.6089E+04, &
       8.6369E+04, 8.6649E+04, 8.6931E+04, 8.7213E+04, 8.7495E+04, 8.7779E+04, 8.8063E+04, 8.8348E+04, 8.8634E+04, 8.8920E+04, &
       8.9208E+04, 8.9496E+04, 8.9784E+04, 9.0074E+04, 9.0364E+04, 9.0655E+04, 9.0947E+04, 9.1239E+04, 9.1532E+04, 9.1826E+04, &
       9.2121E+04, 9.2417E+04, 9.2713E+04, 9.3010E+04, 9.3308E+04, 9.3606E+04, 9.3906E+04, 9.4206E+04, 9.4507E+04, 9.4808E+04, &
       9.5111E+04, 9.5414E+04, 9.5718E+04, 9.6023E+04, 9.6328E+04, 9.6634E+04, 9.6942E+04, 9.7249E+04, 9.7558E+04, 9.7868E+04, &
       9.8178E+04, 9.8489E+04, 9.8801E+04, 9.9113E+04, 9.9427E+04, 9.9741E+04, 1.0006E+05, 1.0037E+05, 1.0069E+05, 1.0101E+05, &
       1.0132E+05, 1.0164E+05, 1.0196E+05, 1.0228E+05, 1.0260E+05, 1.0293E+05, 1.0325E+05, 1.0357E+05, 1.0390E+05, 1.0422E+05, &
       1.0455E+05, 1.0488E+05, 1.0521E+05, 1.0553E+05, 1.0586E+05, 1.0619E+05, 1.0653E+05, 1.0686E+05, 1.0719E+05, 1.0752E+05, &
       1.0786E+05, 1.0819E+05, 1.0853E+05, 1.0887E+05, 1.0921E+05, 1.0954E+05, 1.0988E+05, 1.1022E+05, 1.1057E+05, 1.1091E+05, &
       1.1125E+05, 1.1159E+05, 1.1194E+05, 1.1228E+05, 1.1263E+05, 1.1298E+05, 1.1333E+05, 1.1368E+05, 1.1403E+05, 1.1438E+05, &
       1.1473E+05, 1.1508E+05, 1.1543E+05, 1.1579E+05, 1.1614E+05, 1.1650E+05, 1.1686E+05, 1.1721E+05, 1.1757E+05, 1.1793E+05, &
       1.1829E+05, 1.1865E+05, 1.1901E+05, 1.1938E+05, 1.1974E+05, 1.2011E+05, 1.2047E+05, 1.2084E+05, 1.2121E+05, 1.2157E+05, &
       1.2194E+05, 1.2231E+05, 1.2268E+05, 1.2306E+05, 1.2343E+05, 1.2380E+05, 1.2418E+05, 1.2455E+05, 1.2493E+05, 1.2531E+05, &
       1.2569E+05, 1.2606E+05, 1.2644E+05, 1.2683E+05, 1.2721E+05, 1.2759E+05, 1.2797E+05, 1.2836E+05, 1.2874E+05, 1.2913E+05, &
       1.2952E+05, 1.2991E+05, 1.3030E+05, 1.3069E+05, 1.3108E+05, 1.3147E+05, 1.3186E+05, 1.3226E+05, 1.3265E+05, 1.3305E+05, &
       1.3344E+05, 1.3384E+05, 1.3424E+05, 1.3464E+05, 1.3504E+05, 1.3544E+05, 1.3585E+05, 1.3625E+05, 1.3665E+05, 1.3706E+05, &
       1.3747E+05, 1.3787E+05, 1.3828E+05, 1.3869E+05, 1.3910E+05, 1.3951E+05, 1.3992E+05, 1.4034E+05, 1.4075E+05, 1.4117E+05, &
       1.4158E+05, 1.4200E+05, 1.4242E+05, 1.4284E+05, 1.4326E+05, 1.4368E+05, 1.4410E+05, 1.4452E+05, 1.4495E+05, 1.4537E+05, &
       1.4580E+05, 1.4622E+05, 1.4665E+05, 1.4708E+05, 1.4751E+05, 1.4794E+05, 1.4837E+05, 1.4881E+05, 1.4924E+05, 1.4968E+05, &
       1.5011E+05, 1.5055E+05, 1.5099E+05, 1.5143E+05, 1.5187E+05, 1.5231E+05, 1.5275E+05, 1.5319E+05, 1.5364E+05, 1.5408E+05, &
       1.5453E+05, 1.5498E+05, 1.5543E+05, 1.5587E+05, 1.5632E+05, 1.5678E+05, 1.5723E+05, 1.5768E+05, 1.5814E+05, 1.5859E+05, &
       1.5905E+05, 1.5951E+05, 1.5997E+05, 1.6043E+05, 1.6089E+05, 1.6135E+05, 1.6181E+05, 1.6228E+05, 1.6274E+05, 1.6321E+05, &
       1.6367E+05, 1.6414E+05, 1.6461E+05, 1.6508E+05, 1.6555E+05, 1.6603E+05, 1.6650E+05, 1.6697E+05, 1.6745E+05, 1.6793E+05, &
       1.6841E+05, 1.6888E+05, 1.6936E+05, 1.6985E+05, 1.7033E+05, 1.7081E+05, 1.7130E+05, 1.7178E+05, 1.7227E+05, 1.7276E+05, &
       1.7325E+05, 1.7374E+05, 1.7423E+05, 1.7472E+05, 1.7521E+05, 1.7571E+05, 1.7620E+05, 1.7670E+05, 1.7720E+05, 1.7770E+05, &
       1.7820E+05, 1.7870E+05, 1.7920E+05, 1.7970E+05, 1.8021E+05, 1.8071E+05, 1.8122E+05, 1.8173E+05, 1.8224E+05, 1.8275E+05, &
       1.8326E+05, 1.8377E+05, 1.8428E+05, 1.8480E+05, 1.8531E+05, 1.8583E+05, 1.8635E+05, 1.8687E+05, 1.8739E+05, 1.8791E+05, &
       1.8843E+05, 1.8896E+05, 1.8948E+05, 1.9001E+05, 1.9054E+05, 1.9106E+05, 1.9159E+05, 1.9213E+05, 1.9266E+05, 1.9319E+05, &
       1.9373E+05, 1.9426E+05, 1.9480E+05, 1.9534E+05, 1.9587E+05, 1.9642E+05, 1.9696E+05, 1.9750E+05, 1.9804E+05, 1.9859E+05, &
       1.9913E+05, 1.9968E+05, 2.0023E+05, 2.0078E+05, 2.0133E+05, 2.0188E+05, 2.0244E+05, 2.0299E+05, 2.0355E+05, 2.0411E+05, &
       2.0466E+05, 2.0522E+05, 2.0578E+05, 2.0635E+05, 2.0691E+05, 2.0747E+05, 2.0804E+05, 2.0861E+05, 2.0917E+05, 2.0974E+05, &
       2.1031E+05, 2.1089E+05, 2.1146E+05, 2.1203E+05, 2.1261E+05, 2.1319E+05, 2.1376E+05, 2.1434E+05, 2.1492E+05, 2.1550E+05, &
       2.1609E+05, 2.1667E+05, 2.1726E+05, 2.1784E+05, 2.1843E+05, 2.1902E+05, 2.1961E+05, 2.2020E+05, 2.2080E+05, 2.2139E+05, &
       2.2199E+05, 2.2258E+05, 2.2318E+05, 2.2378E+05, 2.2438E+05, 2.2498E+05, 2.2559E+05, 2.2619E+05, 2.2680E+05, 2.2740E+05, &
       2.2801E+05, 2.2862E+05, 2.2923E+05, 2.2985E+05, 2.3046E+05, 2.3107E+05, 2.3169E+05, 2.3231E+05, 2.3293E+05, 2.3355E+05, &
       2.3417E+05, 2.3479E+05, 2.3541E+05, 2.3604E+05, 2.3667E+05, 2.3729E+05, 2.3792E+05, 2.3855E+05, 2.3919E+05, 2.3982E+05, &
       2.4045E+05, 2.4109E+05, 2.4173E+05, 2.4237E+05, 2.4301E+05, 2.4365E+05, 2.4429E+05, 2.4493E+05, 2.4558E+05, 2.4622E+05, &
       2.4687E+05, 2.4752E+05, 2.4817E+05, 2.4882E+05, 2.4948E+05, 2.5013E+05, 2.5079E+05, 2.5145E+05, 2.5211E+05, 2.5277E+05, &
       2.5343E+05, 2.5409E+05, 2.5475E+05, 2.5542E+05, 2.5609E+05, 2.5676E+05, 2.5743E+05, 2.5810E+05, 2.5877E+05, 2.5944E+05, &
       2.6012E+05, 2.6080E+05, 2.6147E+05, 2.6215E+05, 2.6283E+05, 2.6352E+05, 2.6420E+05, 2.6488E+05, 2.6557E+05, 2.6626E+05, &
       2.6695E+05, 2.6764E+05, 2.6833E+05, 2.6903E+05, 2.6972E+05, 2.7042E+05, 2.7111E+05, 2.7181E+05, 2.7251E+05, 2.7322E+05, &
       2.7392E+05, 2.7462E+05, 2.7533E+05, 2.7604E+05, 2.7675E+05, 2.7746E+05, 2.7817E+05, 2.7888E+05, 2.7960E+05, 2.8032E+05, &
       2.8103E+05, 2.8175E+05, 2.8247E+05, 2.8320E+05, 2.8392E+05, 2.8465E+05, 2.8537E+05, 2.8610E+05, 2.8683E+05, 2.8756E+05, &
       2.8829E+05, 2.8903E+05, 2.8976E+05, 2.9050E+05, 2.9124E+05, 2.9198E+05, 2.9272E+05, 2.9346E+05, 2.9421E+05, 2.9495E+05, &
       2.9570E+05, 2.9645E+05, 2.9720E+05, 2.9795E+05, 2.9871E+05, 2.9946E+05, 3.0022E+05, 3.0097E+05, 3.0173E+05, 3.0249E+05, &
       3.0326E+05, 3.0402E+05, 3.0479E+05, 3.0555E+05, 3.0632E+05, 3.0709E+05, 3.0786E+05, 3.0864E+05, 3.0941E+05, 3.1019E+05, &
       3.1096E+05, 3.1174E+05, 3.1252E+05, 3.1331E+05, 3.1409E+05, 3.1488E+05, 3.1566E+05, 3.1645E+05, 3.1724E+05, 3.1803E+05, &
       3.1883E+05, 3.1962E+05, 3.2042E+05, 3.2121E+05, 3.2201E+05, 3.2281E+05, 3.2362E+05, 3.2442E+05, 3.2523E+05, 3.2603E+05, &
       3.2684E+05, 3.2765E+05, 3.2846E+05, 3.2928E+05, 3.3009E+05, 3.3091E+05, 3.3173E+05, 3.3255E+05, 3.3337E+05, 3.3419E+05, &
       3.3502E+05, 3.3584E+05, 3.3667E+05, 3.3750E+05, 3.3833E+05, 3.3916E+05, 3.4000E+05, 3.4083E+05, 3.4167E+05, 3.4251E+05, &
       3.4335E+05, 3.4419E+05, 3.4504E+05, 3.4588E+05, 3.4673E+05, 3.4758E+05, 3.4843E+05, 3.4928E+05, 3.5014E+05, 3.5099E+05, &
       3.5185E+05, 3.5271E+05, 3.5357E+05, 3.5443E+05, 3.5529E+05, 3.5616E+05, 3.5702E+05, 3.5789E+05, 3.5876E+05, 3.5963E+05, &
       3.6051E+05, 3.6138E+05, 3.6226E+05, 3.6314E+05, 3.6402E+05, 3.6490E+05, 3.6578E+05, 3.6667E+05, 3.6756E+05, 3.6844E+05, &
       3.6934E+05, 3.7023E+05, 3.7112E+05, 3.7202E+05, 3.7291E+05, 3.7381E+05, 3.7471E+05, 3.7561E+05, 3.7652E+05, 3.7742E+05, &
       3.7833E+05, 3.7924E+05, 3.8015E+05, 3.8106E+05, 3.8198E+05, 3.8289E+05, 3.8381E+05, 3.8473E+05, 3.8565E+05, 3.8657E+05, &
       3.8750E+05, 3.8842E+05, 3.8935E+05, 3.9028E+05, 3.9121E+05, 3.9214E+05, 3.9308E+05, 3.9402E+05, 3.9495E+05, 3.9589E+05, &
       3.9684E+05, 3.9778E+05, 3.9873E+05, 3.9967E+05, 4.0062E+05, 4.0157E+05, 4.0252E+05, 4.0348E+05, 4.0443E+05, 4.0539E+05, &
       4.0635E+05, 4.0731E+05, 4.0827E+05, 4.0924E+05, 4.1021E+05, 4.1117E+05, 4.1214E+05, 4.1312E+05, 4.1409E+05, 4.1507E+05, &
       4.1604E+05, 4.1702E+05, 4.1800E+05, 4.1899E+05, 4.1997E+05, 4.2096E+05, 4.2194E+05, 4.2293E+05, 4.2393E+05, 4.2492E+05, &
       4.2591E+05, 4.2691E+05, 4.2791E+05, 4.2891E+05, 4.2991E+05, 4.3092E+05, 4.3192E+05, 4.3293E+05, 4.3394E+05, 4.3495E+05, &
       4.3597E+05, 4.3698E+05, 4.3800E+05, 4.3902E+05, 4.4004E+05, 4.4106E+05, 4.4209E+05, 4.4311E+05, 4.4414E+05, 4.4517E+05, &
       4.4620E+05, 4.4724E+05, 4.4827E+05, 4.4931E+05, 4.5035E+05, 4.5139E+05, 4.5244E+05, 4.5348E+05, 4.5453E+05, 4.5558E+05, &
       4.5663E+05, 4.5768E+05, 4.5874E+05, 4.5979E+05, 4.6085E+05, 4.6191E+05, 4.6297E+05, 4.6404E+05, 4.6510E+05, 4.6617E+05, &
       4.6724E+05, 4.6831E+05, 4.6939E+05, 4.7046E+05, 4.7154E+05, 4.7262E+05, 4.7370E+05, 4.7478E+05, 4.7587E+05, 4.7695E+05, &
       4.7804E+05, 4.7913E+05, 4.8023E+05, 4.8132E+05, 4.8242E+05, 4.8352E+05, 4.8462E+05, 4.8572E+05, 4.8683E+05, 4.8793E+05, &
       4.8904E+05, 4.9015E+05, 4.9126E+05, 4.9238E+05, 4.9349E+05, 4.9461E+05, 4.9573E+05, 4.9685E+05, 4.9798E+05, 4.9910E+05, &
       5.0023E+05, 5.0136E+05, 5.0249E+05, 5.0363E+05, 5.0476E+05, 5.0590E+05, 5.0704E+05, 5.0818E+05, 5.0933E+05, 5.1047E+05, &
       5.1162E+05, 5.1277E+05, 5.1392E+05, 5.1508E+05, 5.1623E+05, 5.1739E+05, 5.1855E+05, 5.1971E+05, 5.2088E+05, 5.2204E+05, &
       5.2321E+05, 5.2438E+05, 5.2555E+05, 5.2673E+05, 5.2790E+05, 5.2908E+05, 5.3026E+05, 5.3144E+05, 5.3263E+05, 5.3381E+05, &
       5.3500E+05, 5.3619E+05, 5.3738E+05, 5.3858E+05, 5.3977E+05, 5.4097E+05, 5.4217E+05, 5.4338E+05, 5.4458E+05, 5.4579E+05, &
       5.4700E+05, 5.4821E+05, 5.4942E+05, 5.5064E+05, 5.5185E+05, 5.5307E+05, 5.5429E+05, 5.5552E+05, 5.5674E+05, 5.5797E+05, &
       5.5920E+05, 5.6043E+05, 5.6167E+05, 5.6290E+05, 5.6414E+05, 5.6538E+05, 5.6662E+05, 5.6787E+05, 5.6911E+05, 5.7036E+05, &
       5.7161E+05, 5.7286E+05, 5.7412E+05, 5.7538E+05, 5.7664E+05, 5.7790E+05, 5.7916E+05, 5.8043E+05, 5.8169E+05, 5.8296E+05, &
       5.8423E+05, 5.8551E+05, 5.8678E+05, 5.8806E+05, 5.8934E+05, 5.9063E+05, 5.9191E+05, 5.9320E+05, 5.9449E+05, 5.9578E+05, &
       5.9707E+05, 5.9837E+05, 5.9966E+05, 6.0096E+05, 6.0227E+05, 6.0357E+05, 6.0488E+05, 6.0619E+05, 6.0750E+05, 6.0881E+05, &
       6.1012E+05, 6.1144E+05, 6.1276E+05, 6.1408E+05, 6.1541E+05, 6.1673E+05, 6.1806E+05, 6.1939E+05, 6.2072E+05, 6.2206E+05, &
       6.2340E+05, 6.2473E+05, 6.2608E+05, 6.2742E+05, 6.2877E+05, 6.3011E+05, 6.3146E+05, 6.3282E+05, 6.3417E+05, 6.3553E+05, &
       6.3689E+05, 6.3825E+05, 6.3961E+05, 6.4098E+05, 6.4235E+05, 6.4372E+05, 6.4509E+05, 6.4646E+05, 6.4784E+05, 6.4922E+05, &
       6.5060E+05, 6.5199E+05, 6.5337E+05, 6.5476E+05, 6.5615E+05, 6.5754E+05, 6.5894E+05, 6.6034E+05, 6.6174E+05, 6.6314E+05, &
       6.6454E+05, 6.6595E+05, 6.6736E+05, 6.6877E+05, 6.7018E+05, 6.7160E+05, 6.7301E+05, 6.7443E+05, 6.7586E+05, 6.7728E+05, &
       6.7871E+05, 6.8014E+05, 6.8157E+05, 6.8300E+05, 6.8444E+05, 6.8588E+05, 6.8732E+05, 6.8876E+05, 6.9021E+05, 6.9166E+05, &
       6.9311E+05, 6.9456E+05, 6.9601E+05, 6.9747E+05, 6.9893E+05, 7.0039E+05, 7.0186E+05, 7.0332E+05, 7.0479E+05, 7.0626E+05, &
       7.0774E+05, 7.0921E+05, 7.1069E+05, 7.1217E+05, 7.1365E+05, 7.1514E+05, 7.1663E+05, 7.1812E+05, 7.1961E+05, 7.2110E+05, &
       7.2260E+05, 7.2410E+05, 7.2560E+05, 7.2711E+05, 7.2861E+05, 7.3012E+05, 7.3163E+05, 7.3315E+05, 7.3466E+05, 7.3618E+05, &
       7.3770E+05, 7.3922E+05, 7.4075E+05, 7.4228E+05, 7.4381E+05, 7.4534E+05, 7.4688E+05, 7.4841E+05, 7.4995E+05, 7.5150E+05, &
       7.5304E+05, 7.5459E+05, 7.5614E+05, 7.5769E+05, 7.5924E+05, 7.6080E+05, 7.6236E+05, 7.6392E+05, 7.6549E+05, 7.6705E+05, &
       7.6862E+05, 7.7019E+05, 7.7177E+05, 7.7334E+05, 7.7492E+05, 7.7650E+05, 7.7809E+05, 7.7967E+05, 7.8126E+05, 7.8285E+05, &
       7.8445E+05, 7.8604E+05, 7.8764E+05, 7.8924E+05, 7.9085E+05, 7.9245E+05, 7.9406E+05, 7.9567E+05, 7.9728E+05, 7.9890E+05, &
       8.0052E+05, 8.0214E+05, 8.0376E+05, 8.0539E+05, 8.0702E+05, 8.0865E+05, 8.1028E+05, 8.1192E+05, 8.1355E+05, 8.1520E+05, &
       8.1684E+05, 8.1848E+05, 8.2013E+05, 8.2178E+05, 8.2344E+05, 8.2509E+05, 8.2675E+05, 8.2841E+05, 8.3007E+05, 8.3174E+05, &
       8.3341E+05, 8.3508E+05, 8.3675E+05, 8.3843E+05, 8.4011E+05, 8.4179E+05, 8.4347E+05, 8.4516E+05, 8.4685E+05, 8.4854E+05, &
       8.5023E+05, 8.5193E+05, 8.5363E+05, 8.5533E+05, 8.5703E+05, 8.5874E+05, 8.6045E+05, 8.6216E+05, 8.6387E+05, 8.6559E+05, &
       8.6731E+05, 8.6903E+05, 8.7076E+05, 8.7248E+05, 8.7421E+05, 8.7595E+05, 8.7768E+05, 8.7942E+05, 8.8116E+05, 8.8290E+05, &
       8.8465E+05, 8.8639E+05, 8.8814E+05, 8.8990E+05, 8.9165E+05, 8.9341E+05, 8.9517E+05, 8.9693E+05, 8.9870E+05, 9.0047E+05, &
       9.0224E+05, 9.0401E+05, 9.0579E+05, 9.0757E+05, 9.0935E+05, 9.1114E+05, 9.1292E+05, 9.1471E+05, 9.1651E+05, 9.1830E+05, &
       9.2010E+05, 9.2190E+05, 9.2370E+05, 9.2551E+05, 9.2732E+05, 9.2913E+05, 9.3094E+05, 9.3276E+05, 9.3457E+05, 9.3640E+05, &
       9.3822E+05, 9.4005E+05, 9.4188E+05, 9.4371E+05, 9.4554E+05, 9.4738E+05, 9.4922E+05, 9.5106E+05, 9.5291E+05, 9.5476E+05, &
       9.5661E+05, 9.5846E+05, 9.6032E+05, 9.6218E+05, 9.6404E+05, 9.6590E+05, 9.6777E+05, 9.6964E+05, 9.7151E+05, 9.7339E+05, &
       9.7527E+05, 9.7715E+05, 9.7903E+05, 9.8092E+05, 9.8280E+05, 9.8470E+05, 9.8659E+05, 9.8849E+05, 9.9039E+05, 9.9229E+05, &
       9.9419E+05, 9.9610E+05, 9.9801E+05, 9.9993E+05, 1.0018E+06, 1.0038E+06, 1.0057E+06, 1.0076E+06, 1.0095E+06, 1.0115E+06, &
       1.0134E+06, 1.0153E+06, 1.0173E+06, 1.0192E+06, 1.0212E+06, 1.0231E+06, 1.0250E+06, 1.0270E+06, 1.0290E+06, 1.0309E+06, &
       1.0329E+06, 1.0348E+06, 1.0368E+06, 1.0388E+06, 1.0407E+06, 1.0427E+06, 1.0447E+06, 1.0467E+06, 1.0487E+06, 1.0506E+06, &
       1.0526E+06, 1.0546E+06, 1.0566E+06, 1.0586E+06, 1.0606E+06, 1.0626E+06, 1.0646E+06, 1.0666E+06, 1.0686E+06, 1.0706E+06, &
       1.0727E+06, 1.0747E+06, 1.0767E+06, 1.0787E+06, 1.0808E+06, 1.0828E+06, 1.0848E+06, 1.0869E+06, 1.0889E+06, 1.0909E+06, &
       1.0930E+06, 1.0950E+06, 1.0971E+06, 1.0991E+06, 1.1012E+06, 1.1032E+06, 1.1053E+06, 1.1074E+06, 1.1094E+06, 1.1115E+06, &
       1.1136E+06, 1.1157E+06, 1.1177E+06, 1.1198E+06, 1.1219E+06, 1.1240E+06, 1.1261E+06, 1.1282E+06, 1.1303E+06, 1.1324E+06, &
       1.1345E+06, 1.1366E+06, 1.1387E+06, 1.1408E+06, 1.1429E+06, 1.1450E+06, 1.1471E+06, 1.1493E+06, 1.1514E+06, 1.1535E+06, &
       1.1556E+06, 1.1578E+06, 1.1599E+06, 1.1621E+06, 1.1642E+06, 1.1663E+06, 1.1685E+06, 1.1706E+06, 1.1728E+06, 1.1750E+06, &
       1.1771E+06, 1.1793E+06, 1.1814E+06, 1.1836E+06, 1.1858E+06, 1.1880E+06, 1.1901E+06, 1.1923E+06, 1.1945E+06, 1.1967E+06, &
       1.1989E+06, 1.2011E+06, 1.2033E+06, 1.2055E+06, 1.2077E+06, 1.2099E+06, 1.2121E+06, 1.2143E+06, 1.2165E+06, 1.2187E+06, &
       1.2209E+06, 1.2232E+06, 1.2254E+06, 1.2276E+06, 1.2298E+06, 1.2321E+06, 1.2343E+06, 1.2365E+06, 1.2388E+06, 1.2410E+06, &
       1.2433E+06, 1.2455E+06, 1.2478E+06, 1.2500E+06, 1.2523E+06, 1.2546E+06, 1.2568E+06, 1.2591E+06, 1.2614E+06, 1.2637E+06, &
       1.2659E+06, 1.2682E+06, 1.2705E+06, 1.2728E+06, 1.2751E+06, 1.2774E+06, 1.2797E+06, 1.2820E+06, 1.2843E+06, 1.2866E+06, &
       1.2889E+06, 1.2912E+06, 1.2935E+06, 1.2958E+06, 1.2982E+06, 1.3005E+06, 1.3028E+06, 1.3051E+06, 1.3075E+06, 1.3098E+06, &
       1.3122E+06, 1.3145E+06, 1.3168E+06, 1.3192E+06, 1.3215E+06, 1.3239E+06, 1.3263E+06, 1.3286E+06, 1.3310E+06, 1.3333E+06, &
       1.3357E+06, 1.3381E+06, 1.3405E+06, 1.3428E+06, 1.3452E+06, 1.3476E+06, 1.3500E+06, 1.3524E+06, 1.3548E+06, 1.3572E+06, &
       1.3596E+06, 1.3620E+06, 1.3644E+06, 1.3668E+06, 1.3692E+06, 1.3716E+06, 1.3741E+06, 1.3765E+06, 1.3789E+06, 1.3813E+06, &
       1.3838E+06, 1.3862E+06, 1.3886E+06, 1.3911E+06, 1.3935E+06, 1.3960E+06, 1.3984E+06, 1.4009E+06, 1.4033E+06, 1.4058E+06, &
       1.4083E+06, 1.4107E+06, 1.4132E+06, 1.4157E+06, 1.4182E+06, 1.4206E+06, 1.4231E+06, 1.4256E+06, 1.4281E+06, 1.4306E+06, &
       1.4331E+06, 1.4356E+06, 1.4381E+06, 1.4406E+06, 1.4431E+06, 1.4456E+06, 1.4481E+06, 1.4506E+06, 1.4531E+06, 1.4557E+06, &
       1.4582E+06, 1.4607E+06, 1.4633E+06, 1.4658E+06, 1.4683E+06, 1.4709E+06, 1.4734E+06, 1.4760E+06, 1.4785E+06, 1.4811E+06, &
       1.4836E+06, 1.4862E+06, 1.4888E+06, 1.4913E+06, 1.4939E+06, 1.4965E+06, 1.4991E+06, 1.5016E+06, 1.5042E+06, 1.5068E+06, &
       1.5094E+06, 1.5120E+06, 1.5146E+06, 1.5172E+06, 1.5198E+06, 1.5224E+06, 1.5250E+06, 1.5276E+06, 1.5302E+06, 1.5329E+06, &
       1.5355E+06, 1.5381E+06, 1.5407E+06, 1.5434E+06, 1.5460E+06, 1.5487E+06, 1.5513E+06, 1.5539E+06, 1.5566E+06, 1.5592E+06, &
       1.5619E+06, 1.5646E+06, 1.5672E+06, 1.5699E+06, 1.5726E+06, 1.5752E+06, 1.5779E+06, 1.5806E+06, 1.5833E+06, 1.5859E+06, &
       1.5886E+06, 1.5913E+06, 1.5940E+06, 1.5967E+06, 1.5994E+06, 1.6021E+06, 1.6048E+06, 1.6075E+06, 1.6103E+06, 1.6130E+06/
      data (QofT( 2,J),J=2409,4510)/ 1.6157E+06, 1.6184E+06, 1.6212E+06, 1.6239E+06, 1.6266E+06, 1.6294E+06, 1.6321E+06, 1.6348E+06, &
       1.6376E+06, 1.6403E+06, 1.6431E+06, 1.6459E+06, 1.6486E+06, 1.6514E+06, 1.6541E+06, 1.6569E+06, 1.6597E+06, 1.6625E+06, &
       1.6652E+06, 1.6680E+06, 1.6708E+06, 1.6736E+06, 1.6764E+06, 1.6792E+06, 1.6820E+06, 1.6848E+06, 1.6876E+06, 1.6904E+06, &
       1.6932E+06, 1.6961E+06, 1.6989E+06, 1.7017E+06, 1.7045E+06, 1.7074E+06, 1.7102E+06, 1.7130E+06, 1.7159E+06, 1.7187E+06, &
       1.7216E+06, 1.7244E+06, 1.7273E+06, 1.7301E+06, 1.7330E+06, 1.7359E+06, 1.7387E+06, 1.7416E+06, 1.7445E+06, 1.7474E+06, &
       1.7502E+06, 1.7531E+06, 1.7560E+06, 1.7589E+06, 1.7618E+06, 1.7647E+06, 1.7676E+06, 1.7705E+06, 1.7734E+06, 1.7763E+06, &
       1.7792E+06, 1.7822E+06, 1.7851E+06, 1.7880E+06, 1.7909E+06, 1.7939E+06, 1.7968E+06, 1.7997E+06, 1.8027E+06, 1.8056E+06, &
       1.8086E+06, 1.8115E+06, 1.8145E+06, 1.8175E+06, 1.8204E+06, 1.8234E+06, 1.8264E+06, 1.8293E+06, 1.8323E+06, 1.8353E+06, &
       1.8383E+06, 1.8413E+06, 1.8443E+06, 1.8472E+06, 1.8502E+06, 1.8532E+06, 1.8563E+06, 1.8593E+06, 1.8623E+06, 1.8653E+06, &
       1.8683E+06, 1.8713E+06, 1.8744E+06, 1.8774E+06, 1.8804E+06, 1.8835E+06, 1.8865E+06, 1.8895E+06, 1.8926E+06, 1.8956E+06, &
       1.8987E+06, 1.9017E+06, 1.9048E+06, 1.9079E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       628
      data (QofT( 3,J),J=1,2408)/ 2.2606E+00, 4.1274E+00, 6.0087E+00, 7.8934E+00, 9.7793E+00, 1.1666E+01, 1.3553E+01, 1.5440E+01, &
       1.7327E+01, 1.9214E+01, 2.1102E+01, 2.2989E+01, 2.4877E+01, 2.6765E+01, 2.8652E+01, 3.0540E+01, 3.2428E+01, 3.4315E+01, &
       3.6203E+01, 3.8091E+01, 4.1866E+01, 4.5642E+01, 4.9417E+01, 5.3193E+01, 5.6969E+01, 6.0744E+01, 6.4520E+01, 6.8296E+01, &
       7.2071E+01, 7.5847E+01, 7.9623E+01, 8.3399E+01, 8.7175E+01, 9.0951E+01, 9.4727E+01, 9.8502E+01, 1.0228E+02, 1.0605E+02, &
       1.0983E+02, 1.1361E+02, 1.1738E+02, 1.2116E+02, 1.2493E+02, 1.2871E+02, 1.3249E+02, 1.3626E+02, 1.4004E+02, 1.4382E+02, &
       1.4759E+02, 1.5137E+02, 1.5515E+02, 1.5892E+02, 1.6270E+02, 1.6648E+02, 1.7026E+02, 1.7404E+02, 1.7781E+02, 1.8159E+02, &
       1.8538E+02, 1.8916E+02, 1.9294E+02, 1.9672E+02, 2.0051E+02, 2.0430E+02, 2.0808E+02, 2.1187E+02, 2.1567E+02, 2.1946E+02, &
       2.2326E+02, 2.2706E+02, 2.3086E+02, 2.3466E+02, 2.3847E+02, 2.4228E+02, 2.4610E+02, 2.4992E+02, 2.5374E+02, 2.5757E+02, &
       2.6141E+02, 2.6524E+02, 2.6909E+02, 2.7294E+02, 2.7680E+02, 2.8066E+02, 2.8453E+02, 2.8841E+02, 2.9229E+02, 2.9619E+02, &
       3.0009E+02, 3.0400E+02, 3.0791E+02, 3.1184E+02, 3.1578E+02, 3.1973E+02, 3.2368E+02, 3.2765E+02, 3.3163E+02, 3.3562E+02, &
       3.3962E+02, 3.4363E+02, 3.4766E+02, 3.5170E+02, 3.5575E+02, 3.5981E+02, 3.6389E+02, 3.6799E+02, 3.7209E+02, 3.7621E+02, &
       3.8035E+02, 3.8450E+02, 3.8867E+02, 3.9285E+02, 3.9705E+02, 4.0127E+02, 4.0550E+02, 4.0975E+02, 4.1402E+02, 4.1831E+02, &
       4.2261E+02, 4.2693E+02, 4.3128E+02, 4.3564E+02, 4.4002E+02, 4.4442E+02, 4.4884E+02, 4.5328E+02, 4.5774E+02, 4.6222E+02, &
       4.6673E+02, 4.7125E+02, 4.7580E+02, 4.8037E+02, 4.8496E+02, 4.8957E+02, 4.9421E+02, 4.9887E+02, 5.0355E+02, 5.0826E+02, &
       5.1299E+02, 5.1775E+02, 5.2253E+02, 5.2733E+02, 5.3216E+02, 5.3702E+02, 5.4190E+02, 5.4681E+02, 5.5174E+02, 5.5670E+02, &
       5.6169E+02, 5.6670E+02, 5.7174E+02, 5.7681E+02, 5.8191E+02, 5.8703E+02, 5.9218E+02, 5.9736E+02, 6.0257E+02, 6.0781E+02, &
       6.1307E+02, 6.1837E+02, 6.2370E+02, 6.2905E+02, 6.3444E+02, 6.3986E+02, 6.4530E+02, 6.5078E+02, 6.5629E+02, 6.6183E+02, &
       6.6740E+02, 6.7300E+02, 6.7864E+02, 6.8431E+02, 6.9001E+02, 6.9574E+02, 7.0151E+02, 7.0731E+02, 7.1314E+02, 7.1900E+02, &
       7.2490E+02, 7.3084E+02, 7.3681E+02, 7.4281E+02, 7.4885E+02, 7.5492E+02, 7.6103E+02, 7.6717E+02, 7.7335E+02, 7.7957E+02, &
       7.8582E+02, 7.9211E+02, 7.9843E+02, 8.0479E+02, 8.1119E+02, 8.1762E+02, 8.2410E+02, 8.3061E+02, 8.3716E+02, 8.4374E+02, &
       8.5037E+02, 8.5703E+02, 8.6374E+02, 8.7048E+02, 8.7726E+02, 8.8408E+02, 8.9094E+02, 8.9784E+02, 9.0478E+02, 9.1176E+02, &
       9.1878E+02, 9.2585E+02, 9.3295E+02, 9.4010E+02, 9.4728E+02, 9.5451E+02, 9.6178E+02, 9.6910E+02, 9.7645E+02, 9.8385E+02, &
       9.9129E+02, 9.9878E+02, 1.0063E+03, 1.0139E+03, 1.0215E+03, 1.0292E+03, 1.0369E+03, 1.0446E+03, 1.0524E+03, 1.0602E+03, &
       1.0681E+03, 1.0761E+03, 1.0840E+03, 1.0920E+03, 1.1001E+03, 1.1082E+03, 1.1164E+03, 1.1246E+03, 1.1329E+03, 1.1412E+03, &
       1.1495E+03, 1.1579E+03, 1.1663E+03, 1.1748E+03, 1.1834E+03, 1.1920E+03, 1.2006E+03, 1.2093E+03, 1.2180E+03, 1.2268E+03, &
       1.2357E+03, 1.2446E+03, 1.2535E+03, 1.2625E+03, 1.2715E+03, 1.2806E+03, 1.2898E+03, 1.2990E+03, 1.3082E+03, 1.3175E+03, &
       1.3269E+03, 1.3363E+03, 1.3457E+03, 1.3553E+03, 1.3648E+03, 1.3745E+03, 1.3841E+03, 1.3939E+03, 1.4036E+03, 1.4135E+03, &
       1.4234E+03, 1.4333E+03, 1.4433E+03, 1.4534E+03, 1.4635E+03, 1.4737E+03, 1.4839E+03, 1.4942E+03, 1.5045E+03, 1.5149E+03, &
       1.5254E+03, 1.5359E+03, 1.5465E+03, 1.5571E+03, 1.5678E+03, 1.5786E+03, 1.5894E+03, 1.6002E+03, 1.6112E+03, 1.6222E+03, &
       1.6332E+03, 1.6443E+03, 1.6555E+03, 1.6667E+03, 1.6780E+03, 1.6894E+03, 1.7008E+03, 1.7123E+03, 1.7238E+03, 1.7354E+03, &
       1.7471E+03, 1.7588E+03, 1.7706E+03, 1.7825E+03, 1.7944E+03, 1.8064E+03, 1.8184E+03, 1.8306E+03, 1.8427E+03, 1.8550E+03, &
       1.8673E+03, 1.8797E+03, 1.8921E+03, 1.9046E+03, 1.9172E+03, 1.9299E+03, 1.9426E+03, 1.9554E+03, 1.9682E+03, 1.9811E+03, &
       1.9941E+03, 2.0072E+03, 2.0203E+03, 2.0335E+03, 2.0468E+03, 2.0601E+03, 2.0735E+03, 2.0870E+03, 2.1006E+03, 2.1142E+03, &
       2.1279E+03, 2.1417E+03, 2.1555E+03, 2.1694E+03, 2.1834E+03, 2.1974E+03, 2.2116E+03, 2.2258E+03, 2.2401E+03, 2.2544E+03, &
       2.2689E+03, 2.2834E+03, 2.2979E+03, 2.3126E+03, 2.3273E+03, 2.3421E+03, 2.3570E+03, 2.3720E+03, 2.3870E+03, 2.4021E+03, &
       2.4173E+03, 2.4326E+03, 2.4480E+03, 2.4634E+03, 2.4789E+03, 2.4945E+03, 2.5102E+03, 2.5259E+03, 2.5418E+03, 2.5577E+03, &
       2.5737E+03, 2.5897E+03, 2.6059E+03, 2.6221E+03, 2.6385E+03, 2.6549E+03, 2.6714E+03, 2.6879E+03, 2.7046E+03, 2.7213E+03, &
       2.7381E+03, 2.7551E+03, 2.7721E+03, 2.7891E+03, 2.8063E+03, 2.8236E+03, 2.8409E+03, 2.8583E+03, 2.8758E+03, 2.8934E+03, &
       2.9111E+03, 2.9289E+03, 2.9468E+03, 2.9647E+03, 2.9828E+03, 3.0009E+03, 3.0192E+03, 3.0375E+03, 3.0559E+03, 3.0744E+03, &
       3.0930E+03, 3.1117E+03, 3.1304E+03, 3.1493E+03, 3.1683E+03, 3.1873E+03, 3.2065E+03, 3.2257E+03, 3.2450E+03, 3.2645E+03, &
       3.2840E+03, 3.3036E+03, 3.3233E+03, 3.3432E+03, 3.3631E+03, 3.3831E+03, 3.4032E+03, 3.4234E+03, 3.4437E+03, 3.4641E+03, &
       3.4846E+03, 3.5052E+03, 3.5259E+03, 3.5467E+03, 3.5676E+03, 3.5886E+03, 3.6097E+03, 3.6309E+03, 3.6522E+03, 3.6736E+03, &
       3.6951E+03, 3.7167E+03, 3.7385E+03, 3.7603E+03, 3.7822E+03, 3.8042E+03, 3.8264E+03, 3.8486E+03, 3.8710E+03, 3.8934E+03, &
       3.9160E+03, 3.9387E+03, 3.9614E+03, 3.9843E+03, 4.0073E+03, 4.0304E+03, 4.0536E+03, 4.0769E+03, 4.1004E+03, 4.1239E+03, &
       4.1475E+03, 4.1713E+03, 4.1952E+03, 4.2192E+03, 4.2433E+03, 4.2675E+03, 4.2918E+03, 4.3162E+03, 4.3408E+03, 4.3655E+03, &
       4.3902E+03, 4.4151E+03, 4.4401E+03, 4.4653E+03, 4.4905E+03, 4.5159E+03, 4.5414E+03, 4.5669E+03, 4.5927E+03, 4.6185E+03, &
       4.6444E+03, 4.6705E+03, 4.6967E+03, 4.7230E+03, 4.7495E+03, 4.7760E+03, 4.8027E+03, 4.8295E+03, 4.8564E+03, 4.8835E+03, &
       4.9106E+03, 4.9379E+03, 4.9653E+03, 4.9929E+03, 5.0205E+03, 5.0483E+03, 5.0762E+03, 5.1043E+03, 5.1325E+03, 5.1608E+03, &
       5.1892E+03, 5.2177E+03, 5.2464E+03, 5.2752E+03, 5.3042E+03, 5.3333E+03, 5.3625E+03, 5.3918E+03, 5.4213E+03, 5.4509E+03, &
       5.4806E+03, 5.5105E+03, 5.5405E+03, 5.5706E+03, 5.6009E+03, 5.6313E+03, 5.6618E+03, 5.6925E+03, 5.7233E+03, 5.7542E+03, &
       5.7853E+03, 5.8165E+03, 5.8479E+03, 5.8794E+03, 5.9110E+03, 5.9428E+03, 5.9747E+03, 6.0067E+03, 6.0389E+03, 6.0713E+03, &
       6.1038E+03, 6.1364E+03, 6.1691E+03, 6.2021E+03, 6.2351E+03, 6.2683E+03, 6.3016E+03, 6.3351E+03, 6.3688E+03, 6.4025E+03, &
       6.4365E+03, 6.4705E+03, 6.5048E+03, 6.5391E+03, 6.5737E+03, 6.6083E+03, 6.6431E+03, 6.6781E+03, 6.7132E+03, 6.7485E+03, &
       6.7839E+03, 6.8195E+03, 6.8552E+03, 6.8911E+03, 6.9271E+03, 6.9633E+03, 6.9997E+03, 7.0362E+03, 7.0728E+03, 7.1096E+03, &
       7.1466E+03, 7.1837E+03, 7.2210E+03, 7.2585E+03, 7.2961E+03, 7.3338E+03, 7.3718E+03, 7.4098E+03, 7.4481E+03, 7.4865E+03, &
       7.5251E+03, 7.5638E+03, 7.6027E+03, 7.6417E+03, 7.6810E+03, 7.7203E+03, 7.7599E+03, 7.7996E+03, 7.8395E+03, 7.8796E+03, &
       7.9198E+03, 7.9602E+03, 8.0007E+03, 8.0414E+03, 8.0823E+03, 8.1234E+03, 8.1646E+03, 8.2061E+03, 8.2476E+03, 8.2894E+03, &
       8.3313E+03, 8.3734E+03, 8.4157E+03, 8.4581E+03, 8.5008E+03, 8.5436E+03, 8.5865E+03, 8.6297E+03, 8.6730E+03, 8.7165E+03, &
       8.7602E+03, 8.8041E+03, 8.8481E+03, 8.8924E+03, 8.9368E+03, 8.9814E+03, 9.0261E+03, 9.0711E+03, 9.1162E+03, 9.1615E+03, &
       9.2070E+03, 9.2527E+03, 9.2986E+03, 9.3447E+03, 9.3909E+03, 9.4374E+03, 9.4840E+03, 9.5308E+03, 9.5778E+03, 9.6250E+03, &
       9.6724E+03, 9.7200E+03, 9.7677E+03, 9.8157E+03, 9.8638E+03, 9.9122E+03, 9.9607E+03, 1.0009E+04, 1.0058E+04, 1.0107E+04, &
       1.0157E+04, 1.0206E+04, 1.0256E+04, 1.0306E+04, 1.0356E+04, 1.0406E+04, 1.0457E+04, 1.0508E+04, 1.0559E+04, 1.0610E+04, &
       1.0661E+04, 1.0712E+04, 1.0764E+04, 1.0816E+04, 1.0868E+04, 1.0921E+04, 1.0973E+04, 1.1026E+04, 1.1079E+04, 1.1132E+04, &
       1.1185E+04, 1.1239E+04, 1.1293E+04, 1.1347E+04, 1.1401E+04, 1.1455E+04, 1.1510E+04, 1.1565E+04, 1.1620E+04, 1.1675E+04, &
       1.1731E+04, 1.1786E+04, 1.1842E+04, 1.1898E+04, 1.1955E+04, 1.2011E+04, 1.2068E+04, 1.2125E+04, 1.2182E+04, 1.2240E+04, &
       1.2298E+04, 1.2356E+04, 1.2414E+04, 1.2472E+04, 1.2531E+04, 1.2589E+04, 1.2648E+04, 1.2708E+04, 1.2767E+04, 1.2827E+04, &
       1.2887E+04, 1.2947E+04, 1.3007E+04, 1.3068E+04, 1.3129E+04, 1.3190E+04, 1.3251E+04, 1.3313E+04, 1.3374E+04, 1.3436E+04, &
       1.3499E+04, 1.3561E+04, 1.3624E+04, 1.3687E+04, 1.3750E+04, 1.3814E+04, 1.3877E+04, 1.3941E+04, 1.4005E+04, 1.4070E+04, &
       1.4134E+04, 1.4199E+04, 1.4264E+04, 1.4330E+04, 1.4395E+04, 1.4461E+04, 1.4527E+04, 1.4594E+04, 1.4660E+04, 1.4727E+04, &
       1.4794E+04, 1.4861E+04, 1.4929E+04, 1.4997E+04, 1.5065E+04, 1.5133E+04, 1.5202E+04, 1.5271E+04, 1.5340E+04, 1.5409E+04, &
       1.5479E+04, 1.5549E+04, 1.5619E+04, 1.5689E+04, 1.5760E+04, 1.5831E+04, 1.5902E+04, 1.5973E+04, 1.6045E+04, 1.6117E+04, &
       1.6189E+04, 1.6262E+04, 1.6334E+04, 1.6407E+04, 1.6481E+04, 1.6554E+04, 1.6628E+04, 1.6702E+04, 1.6777E+04, 1.6851E+04, &
       1.6926E+04, 1.7001E+04, 1.7077E+04, 1.7152E+04, 1.7228E+04, 1.7305E+04, 1.7381E+04, 1.7458E+04, 1.7535E+04, 1.7612E+04, &
       1.7690E+04, 1.7768E+04, 1.7846E+04, 1.7925E+04, 1.8003E+04, 1.8082E+04, 1.8162E+04, 1.8241E+04, 1.8321E+04, 1.8401E+04, &
       1.8482E+04, 1.8563E+04, 1.8644E+04, 1.8725E+04, 1.8807E+04, 1.8888E+04, 1.8971E+04, 1.9053E+04, 1.9136E+04, 1.9219E+04, &
       1.9302E+04, 1.9386E+04, 1.9470E+04, 1.9554E+04, 1.9639E+04, 1.9724E+04, 1.9809E+04, 1.9894E+04, 1.9980E+04, 2.0066E+04, &
       2.0152E+04, 2.0239E+04, 2.0326E+04, 2.0413E+04, 2.0501E+04, 2.0589E+04, 2.0677E+04, 2.0765E+04, 2.0854E+04, 2.0943E+04, &
       2.1032E+04, 2.1122E+04, 2.1212E+04, 2.1303E+04, 2.1393E+04, 2.1484E+04, 2.1575E+04, 2.1667E+04, 2.1759E+04, 2.1851E+04, &
       2.1944E+04, 2.2037E+04, 2.2130E+04, 2.2223E+04, 2.2317E+04, 2.2411E+04, 2.2506E+04, 2.2601E+04, 2.2696E+04, 2.2791E+04, &
       2.2887E+04, 2.2983E+04, 2.3079E+04, 2.3176E+04, 2.3273E+04, 2.3371E+04, 2.3468E+04, 2.3567E+04, 2.3665E+04, 2.3764E+04, &
       2.3863E+04, 2.3962E+04, 2.4062E+04, 2.4162E+04, 2.4262E+04, 2.4363E+04, 2.4464E+04, 2.4566E+04, 2.4668E+04, 2.4770E+04, &
       2.4872E+04, 2.4975E+04, 2.5078E+04, 2.5182E+04, 2.5286E+04, 2.5390E+04, 2.5494E+04, 2.5599E+04, 2.5705E+04, 2.5810E+04, &
       2.5916E+04, 2.6022E+04, 2.6129E+04, 2.6236E+04, 2.6344E+04, 2.6451E+04, 2.6559E+04, 2.6668E+04, 2.6777E+04, 2.6886E+04, &
       2.6995E+04, 2.7105E+04, 2.7216E+04, 2.7326E+04, 2.7437E+04, 2.7548E+04, 2.7660E+04, 2.7772E+04, 2.7885E+04, 2.7998E+04, &
       2.8111E+04, 2.8224E+04, 2.8338E+04, 2.8453E+04, 2.8567E+04, 2.8682E+04, 2.8798E+04, 2.8914E+04, 2.9030E+04, 2.9146E+04, &
       2.9263E+04, 2.9381E+04, 2.9498E+04, 2.9617E+04, 2.9735E+04, 2.9854E+04, 2.9973E+04, 3.0093E+04, 3.0213E+04, 3.0333E+04, &
       3.0454E+04, 3.0575E+04, 3.0697E+04, 3.0819E+04, 3.0941E+04, 3.1064E+04, 3.1187E+04, 3.1311E+04, 3.1435E+04, 3.1559E+04, &
       3.1684E+04, 3.1809E+04, 3.1934E+04, 3.2060E+04, 3.2187E+04, 3.2313E+04, 3.2441E+04, 3.2568E+04, 3.2696E+04, 3.2824E+04, &
       3.2953E+04, 3.3082E+04, 3.3212E+04, 3.3342E+04, 3.3472E+04, 3.3603E+04, 3.3735E+04, 3.3866E+04, 3.3998E+04, 3.4131E+04, &
       3.4264E+04, 3.4397E+04, 3.4531E+04, 3.4665E+04, 3.4800E+04, 3.4935E+04, 3.5070E+04, 3.5206E+04, 3.5342E+04, 3.5479E+04, &
       3.5616E+04, 3.5754E+04, 3.5892E+04, 3.6030E+04, 3.6169E+04, 3.6308E+04, 3.6448E+04, 3.6588E+04, 3.6729E+04, 3.6870E+04, &
       3.7011E+04, 3.7153E+04, 3.7296E+04, 3.7438E+04, 3.7582E+04, 3.7725E+04, 3.7869E+04, 3.8014E+04, 3.8159E+04, 3.8304E+04, &
       3.8450E+04, 3.8597E+04, 3.8744E+04, 3.8891E+04, 3.9038E+04, 3.9187E+04, 3.9335E+04, 3.9484E+04, 3.9634E+04, 3.9784E+04, &
       3.9934E+04, 4.0085E+04, 4.0237E+04, 4.0388E+04, 4.0541E+04, 4.0693E+04, 4.0847E+04, 4.1000E+04, 4.1154E+04, 4.1309E+04, &
       4.1464E+04, 4.1620E+04, 4.1776E+04, 4.1932E+04, 4.2089E+04, 4.2247E+04, 4.2405E+04, 4.2563E+04, 4.2722E+04, 4.2881E+04, &
       4.3041E+04, 4.3201E+04, 4.3362E+04, 4.3523E+04, 4.3685E+04, 4.3847E+04, 4.4010E+04, 4.4173E+04, 4.4337E+04, 4.4501E+04, &
       4.4666E+04, 4.4831E+04, 4.4997E+04, 4.5163E+04, 4.5329E+04, 4.5497E+04, 4.5664E+04, 4.5832E+04, 4.6001E+04, 4.6170E+04, &
       4.6340E+04, 4.6510E+04, 4.6681E+04, 4.6852E+04, 4.7023E+04, 4.7195E+04, 4.7368E+04, 4.7541E+04, 4.7715E+04, 4.7889E+04, &
       4.8064E+04, 4.8239E+04, 4.8415E+04, 4.8591E+04, 4.8768E+04, 4.8945E+04, 4.9123E+04, 4.9301E+04, 4.9480E+04, 4.9659E+04, &
       4.9839E+04, 5.0019E+04, 5.0200E+04, 5.0382E+04, 5.0564E+04, 5.0746E+04, 5.0929E+04, 5.1113E+04, 5.1297E+04, 5.1482E+04, &
       5.1667E+04, 5.1852E+04, 5.2039E+04, 5.2225E+04, 5.2413E+04, 5.2600E+04, 5.2789E+04, 5.2978E+04, 5.3167E+04, 5.3357E+04, &
       5.3548E+04, 5.3739E+04, 5.3931E+04, 5.4123E+04, 5.4315E+04, 5.4509E+04, 5.4703E+04, 5.4897E+04, 5.5092E+04, 5.5287E+04, &
       5.5483E+04, 5.5680E+04, 5.5877E+04, 5.6075E+04, 5.6273E+04, 5.6472E+04, 5.6671E+04, 5.6871E+04, 5.7072E+04, 5.7273E+04, &
       5.7475E+04, 5.7677E+04, 5.7880E+04, 5.8083E+04, 5.8287E+04, 5.8492E+04, 5.8697E+04, 5.8902E+04, 5.9109E+04, 5.9315E+04, &
       5.9523E+04, 5.9731E+04, 5.9939E+04, 6.0149E+04, 6.0358E+04, 6.0569E+04, 6.0780E+04, 6.0991E+04, 6.1203E+04, 6.1416E+04, &
       6.1629E+04, 6.1843E+04, 6.2057E+04, 6.2272E+04, 6.2488E+04, 6.2704E+04, 6.2921E+04, 6.3138E+04, 6.3356E+04, 6.3575E+04, &
       6.3794E+04, 6.4014E+04, 6.4235E+04, 6.4456E+04, 6.4677E+04, 6.4900E+04, 6.5122E+04, 6.5346E+04, 6.5570E+04, 6.5795E+04, &
       6.6020E+04, 6.6246E+04, 6.6472E+04, 6.6700E+04, 6.6927E+04, 6.7156E+04, 6.7385E+04, 6.7614E+04, 6.7845E+04, 6.8076E+04, &
       6.8307E+04, 6.8539E+04, 6.8772E+04, 6.9005E+04, 6.9239E+04, 6.9474E+04, 6.9709E+04, 6.9945E+04, 7.0182E+04, 7.0419E+04, &
       7.0657E+04, 7.0895E+04, 7.1134E+04, 7.1374E+04, 7.1615E+04, 7.1856E+04, 7.2097E+04, 7.2340E+04, 7.2583E+04, 7.2826E+04, &
       7.3071E+04, 7.3315E+04, 7.3561E+04, 7.3807E+04, 7.4054E+04, 7.4302E+04, 7.4550E+04, 7.4799E+04, 7.5048E+04, 7.5298E+04, &
       7.5549E+04, 7.5801E+04, 7.6053E+04, 7.6306E+04, 7.6559E+04, 7.6813E+04, 7.7068E+04, 7.7324E+04, 7.7580E+04, 7.7837E+04, &
       7.8094E+04, 7.8353E+04, 7.8611E+04, 7.8871E+04, 7.9131E+04, 7.9392E+04, 7.9654E+04, 7.9916E+04, 8.0179E+04, 8.0443E+04, &
       8.0707E+04, 8.0972E+04, 8.1238E+04, 8.1504E+04, 8.1771E+04, 8.2039E+04, 8.2307E+04, 8.2576E+04, 8.2846E+04, 8.3117E+04, &
       8.3388E+04, 8.3660E+04, 8.3933E+04, 8.4206E+04, 8.4480E+04, 8.4755E+04, 8.5030E+04, 8.5307E+04, 8.5583E+04, 8.5861E+04, &
       8.6139E+04, 8.6418E+04, 8.6698E+04, 8.6979E+04, 8.7260E+04, 8.7542E+04, 8.7824E+04, 8.8107E+04, 8.8391E+04, 8.8676E+04, &
       8.8962E+04, 8.9248E+04, 8.9535E+04, 8.9822E+04, 9.0111E+04, 9.0400E+04, 9.0690E+04, 9.0980E+04, 9.1272E+04, 9.1564E+04, &
       9.1857E+04, 9.2150E+04, 9.2444E+04, 9.2739E+04, 9.3035E+04, 9.3331E+04, 9.3629E+04, 9.3927E+04, 9.4225E+04, 9.4525E+04, &
       9.4825E+04, 9.5126E+04, 9.5428E+04, 9.5730E+04, 9.6033E+04, 9.6337E+04, 9.6642E+04, 9.6947E+04, 9.7254E+04, 9.7561E+04, &
       9.7868E+04, 9.8177E+04, 9.8486E+04, 9.8796E+04, 9.9107E+04, 9.9419E+04, 9.9731E+04, 1.0004E+05, 1.0036E+05, 1.0067E+05, &
       1.0099E+05, 1.0130E+05, 1.0162E+05, 1.0194E+05, 1.0226E+05, 1.0258E+05, 1.0290E+05, 1.0322E+05, 1.0354E+05, 1.0386E+05, &
       1.0418E+05, 1.0451E+05, 1.0483E+05, 1.0516E+05, 1.0549E+05, 1.0581E+05, 1.0614E+05, 1.0647E+05, 1.0680E+05, 1.0713E+05, &
       1.0746E+05, 1.0779E+05, 1.0813E+05, 1.0846E+05, 1.0879E+05, 1.0913E+05, 1.0946E+05, 1.0980E+05, 1.1014E+05, 1.1048E+05, &
       1.1082E+05, 1.1116E+05, 1.1150E+05, 1.1184E+05, 1.1218E+05, 1.1252E+05, 1.1287E+05, 1.1321E+05, 1.1356E+05, 1.1391E+05, &
       1.1425E+05, 1.1460E+05, 1.1495E+05, 1.1530E+05, 1.1565E+05, 1.1600E+05, 1.1635E+05, 1.1671E+05, 1.1706E+05, 1.1742E+05, &
       1.1777E+05, 1.1813E+05, 1.1849E+05, 1.1884E+05, 1.1920E+05, 1.1956E+05, 1.1992E+05, 1.2028E+05, 1.2065E+05, 1.2101E+05, &
       1.2137E+05, 1.2174E+05, 1.2211E+05, 1.2247E+05, 1.2284E+05, 1.2321E+05, 1.2358E+05, 1.2395E+05, 1.2432E+05, 1.2469E+05, &
       1.2506E+05, 1.2544E+05, 1.2581E+05, 1.2619E+05, 1.2656E+05, 1.2694E+05, 1.2732E+05, 1.2769E+05, 1.2807E+05, 1.2845E+05, &
       1.2884E+05, 1.2922E+05, 1.2960E+05, 1.2999E+05, 1.3037E+05, 1.3076E+05, 1.3114E+05, 1.3153E+05, 1.3192E+05, 1.3231E+05, &
       1.3270E+05, 1.3309E+05, 1.3348E+05, 1.3387E+05, 1.3427E+05, 1.3466E+05, 1.3506E+05, 1.3545E+05, 1.3585E+05, 1.3625E+05, &
       1.3665E+05, 1.3705E+05, 1.3745E+05, 1.3785E+05, 1.3825E+05, 1.3866E+05, 1.3906E+05, 1.3947E+05, 1.3987E+05, 1.4028E+05, &
       1.4069E+05, 1.4110E+05, 1.4151E+05, 1.4192E+05, 1.4233E+05, 1.4274E+05, 1.4316E+05, 1.4357E+05, 1.4398E+05, 1.4440E+05, &
       1.4482E+05, 1.4524E+05, 1.4566E+05, 1.4608E+05, 1.4650E+05, 1.4692E+05, 1.4734E+05, 1.4777E+05, 1.4819E+05, 1.4862E+05, &
       1.4904E+05, 1.4947E+05, 1.4990E+05, 1.5033E+05, 1.5076E+05, 1.5119E+05, 1.5162E+05, 1.5205E+05, 1.5249E+05, 1.5292E+05, &
       1.5336E+05, 1.5380E+05, 1.5423E+05, 1.5467E+05, 1.5511E+05, 1.5555E+05, 1.5600E+05, 1.5644E+05, 1.5688E+05, 1.5733E+05, &
       1.5777E+05, 1.5822E+05, 1.5867E+05, 1.5911E+05, 1.5956E+05, 1.6001E+05, 1.6047E+05, 1.6092E+05, 1.6137E+05, 1.6182E+05, &
       1.6228E+05, 1.6274E+05, 1.6319E+05, 1.6365E+05, 1.6411E+05, 1.6457E+05, 1.6503E+05, 1.6549E+05, 1.6596E+05, 1.6642E+05, &
       1.6689E+05, 1.6735E+05, 1.6782E+05, 1.6829E+05, 1.6876E+05, 1.6923E+05, 1.6970E+05, 1.7017E+05, 1.7064E+05, 1.7112E+05, &
       1.7159E+05, 1.7207E+05, 1.7254E+05, 1.7302E+05, 1.7350E+05, 1.7398E+05, 1.7446E+05, 1.7494E+05, 1.7543E+05, 1.7591E+05, &
       1.7639E+05, 1.7688E+05, 1.7737E+05, 1.7786E+05, 1.7834E+05, 1.7883E+05, 1.7933E+05, 1.7982E+05, 1.8031E+05, 1.8080E+05, &
       1.8130E+05, 1.8180E+05, 1.8229E+05, 1.8279E+05, 1.8329E+05, 1.8379E+05, 1.8429E+05, 1.8479E+05, 1.8530E+05, 1.8580E+05, &
       1.8631E+05, 1.8681E+05, 1.8732E+05, 1.8783E+05, 1.8834E+05, 1.8885E+05, 1.8936E+05, 1.8987E+05, 1.9039E+05, 1.9090E+05, &
       1.9142E+05, 1.9193E+05, 1.9245E+05, 1.9297E+05, 1.9349E+05, 1.9401E+05, 1.9453E+05, 1.9506E+05, 1.9558E+05, 1.9611E+05, &
       1.9663E+05, 1.9716E+05, 1.9769E+05, 1.9822E+05, 1.9875E+05, 1.9928E+05, 1.9981E+05, 2.0035E+05, 2.0088E+05, 2.0142E+05, &
       2.0195E+05, 2.0249E+05, 2.0303E+05, 2.0357E+05, 2.0411E+05, 2.0466E+05, 2.0520E+05, 2.0574E+05, 2.0629E+05, 2.0684E+05, &
       2.0738E+05, 2.0793E+05, 2.0848E+05, 2.0903E+05, 2.0958E+05, 2.1014E+05, 2.1069E+05, 2.1125E+05, 2.1180E+05, 2.1236E+05, &
       2.1292E+05, 2.1348E+05, 2.1404E+05, 2.1460E+05, 2.1516E+05, 2.1573E+05, 2.1629E+05, 2.1686E+05, 2.1743E+05, 2.1800E+05, &
       2.1857E+05, 2.1914E+05, 2.1971E+05, 2.2028E+05, 2.2085E+05, 2.2143E+05, 2.2201E+05, 2.2258E+05, 2.2316E+05, 2.2374E+05, &
       2.2432E+05, 2.2490E+05, 2.2549E+05, 2.2607E+05, 2.2665E+05, 2.2724E+05, 2.2783E+05, 2.2842E+05, 2.2901E+05, 2.2960E+05, &
       2.3019E+05, 2.3078E+05, 2.3138E+05, 2.3197E+05, 2.3257E+05, 2.3316E+05, 2.3376E+05, 2.3436E+05, 2.3496E+05, 2.3557E+05, &
       2.3617E+05, 2.3677E+05, 2.3738E+05, 2.3798E+05, 2.3859E+05, 2.3920E+05, 2.3981E+05, 2.4042E+05, 2.4103E+05, 2.4165E+05, &
       2.4226E+05, 2.4288E+05, 2.4350E+05, 2.4411E+05, 2.4473E+05, 2.4535E+05, 2.4597E+05, 2.4660E+05, 2.4722E+05, 2.4785E+05, &
       2.4847E+05, 2.4910E+05, 2.4973E+05, 2.5036E+05, 2.5099E+05, 2.5162E+05, 2.5225E+05, 2.5289E+05, 2.5352E+05, 2.5416E+05, &
       2.5480E+05, 2.5544E+05, 2.5608E+05, 2.5672E+05, 2.5736E+05, 2.5800E+05, 2.5865E+05, 2.5929E+05, 2.5994E+05, 2.6059E+05, &
       2.6124E+05, 2.6189E+05, 2.6254E+05, 2.6319E+05, 2.6385E+05, 2.6450E+05, 2.6516E+05, 2.6582E+05, 2.6648E+05, 2.6714E+05, &
       2.6780E+05, 2.6846E+05, 2.6912E+05, 2.6979E+05, 2.7046E+05, 2.7112E+05, 2.7179E+05, 2.7246E+05, 2.7313E+05, 2.7380E+05, &
       2.7448E+05, 2.7515E+05, 2.7583E+05, 2.7650E+05, 2.7718E+05, 2.7786E+05, 2.7854E+05, 2.7922E+05, 2.7991E+05, 2.8059E+05, &
       2.8128E+05, 2.8196E+05, 2.8265E+05, 2.8334E+05, 2.8403E+05, 2.8472E+05, 2.8541E+05, 2.8611E+05, 2.8680E+05, 2.8750E+05, &
       2.8820E+05, 2.8889E+05, 2.8959E+05, 2.9030E+05, 2.9100E+05, 2.9170E+05, 2.9241E+05, 2.9311E+05, 2.9382E+05, 2.9453E+05, &
       2.9524E+05, 2.9595E+05, 2.9666E+05, 2.9738E+05, 2.9809E+05, 2.9881E+05, 2.9952E+05, 3.0024E+05, 3.0096E+05, 3.0168E+05, &
       3.0240E+05, 3.0313E+05, 3.0385E+05, 3.0458E+05, 3.0531E+05, 3.0603E+05, 3.0676E+05, 3.0749E+05, 3.0823E+05, 3.0896E+05, &
       3.0969E+05, 3.1043E+05, 3.1117E+05, 3.1191E+05, 3.1264E+05, 3.1339E+05, 3.1413E+05, 3.1487E+05, 3.1562E+05, 3.1636E+05, &
       3.1711E+05, 3.1786E+05, 3.1861E+05, 3.1936E+05, 3.2011E+05, 3.2086E+05, 3.2162E+05, 3.2237E+05, 3.2313E+05, 3.2389E+05, &
       3.2465E+05, 3.2541E+05, 3.2617E+05, 3.2694E+05, 3.2770E+05, 3.2847E+05, 3.2924E+05, 3.3000E+05, 3.3077E+05, 3.3155E+05, &
       3.3232E+05, 3.3309E+05, 3.3387E+05, 3.3464E+05, 3.3542E+05, 3.3620E+05, 3.3698E+05, 3.3776E+05, 3.3854E+05, 3.3933E+05, &
       3.4011E+05, 3.4090E+05, 3.4169E+05, 3.4248E+05, 3.4327E+05, 3.4406E+05, 3.4485E+05, 3.4565E+05, 3.4644E+05, 3.4724E+05, &
       3.4804E+05, 3.4884E+05, 3.4964E+05, 3.5044E+05, 3.5124E+05, 3.5205E+05, 3.5286E+05, 3.5366E+05, 3.5447E+05, 3.5528E+05, &
       3.5609E+05, 3.5691E+05, 3.5772E+05, 3.5853E+05, 3.5935E+05, 3.6017E+05, 3.6099E+05, 3.6181E+05, 3.6263E+05, 3.6345E+05, &
       3.6428E+05, 3.6510E+05, 3.6593E+05, 3.6676E+05, 3.6759E+05, 3.6842E+05, 3.6925E+05, 3.7009E+05, 3.7092E+05, 3.7176E+05, &
       3.7259E+05, 3.7343E+05, 3.7427E+05, 3.7512E+05, 3.7596E+05, 3.7680E+05, 3.7765E+05, 3.7849E+05, 3.7934E+05, 3.8019E+05, &
       3.8104E+05, 3.8190E+05, 3.8275E+05, 3.8360E+05, 3.8446E+05, 3.8532E+05, 3.8618E+05, 3.8704E+05, 3.8790E+05, 3.8876E+05, &
       3.8962E+05, 3.9049E+05, 3.9136E+05, 3.9223E+05, 3.9310E+05, 3.9397E+05, 3.9484E+05, 3.9571E+05, 3.9659E+05, 3.9746E+05, &
       3.9834E+05, 3.9922E+05, 4.0010E+05, 4.0098E+05, 4.0186E+05, 4.0275E+05, 4.0363E+05, 4.0452E+05, 4.0541E+05, 4.0630E+05, &
       4.0719E+05, 4.0808E+05, 4.0898E+05, 4.0987E+05, 4.1077E+05, 4.1167E+05, 4.1257E+05, 4.1347E+05, 4.1437E+05, 4.1527E+05, &
       4.1618E+05, 4.1708E+05, 4.1799E+05, 4.1890E+05, 4.1981E+05, 4.2072E+05, 4.2163E+05, 4.2255E+05, 4.2346E+05, 4.2438E+05, &
       4.2530E+05, 4.2622E+05, 4.2714E+05, 4.2806E+05, 4.2899E+05, 4.2991E+05, 4.3084E+05, 4.3177E+05, 4.3270E+05, 4.3363E+05, &
       4.3456E+05, 4.3549E+05, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
      data (QofT( 3,J),J=2409,4510)/ 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       627
      data (QofT( 4,J),J=1,2408)/ 1.3259E+01, 2.4144E+01, 3.5119E+01, 4.6114E+01, 5.7117E+01, 6.8124E+01, 7.9134E+01, 9.0144E+01, &
       1.0116E+02, 1.1217E+02, 1.2318E+02, 1.3419E+02, 1.4521E+02, 1.5622E+02, 1.6723E+02, 1.7825E+02, 1.8926E+02, 2.0028E+02, &
       2.1129E+02, 2.2231E+02, 2.4433E+02, 2.6636E+02, 2.8839E+02, 3.1042E+02, 3.3245E+02, 3.5448E+02, 3.7651E+02, 3.9854E+02, &
       4.2057E+02, 4.4261E+02, 4.6464E+02, 4.8667E+02, 5.0870E+02, 5.3073E+02, 5.5276E+02, 5.7479E+02, 5.9682E+02, 6.1886E+02, &
       6.4089E+02, 6.6292E+02, 6.8495E+02, 7.0698E+02, 7.2902E+02, 7.5105E+02, 7.7308E+02, 7.9512E+02, 8.1715E+02, 8.3919E+02, &
       8.6122E+02, 8.8326E+02, 9.0529E+02, 9.2733E+02, 9.4937E+02, 9.7142E+02, 9.9346E+02, 1.0155E+03, 1.0376E+03, 1.0596E+03, &
       1.0817E+03, 1.1037E+03, 1.1258E+03, 1.1479E+03, 1.1700E+03, 1.1921E+03, 1.2142E+03, 1.2363E+03, 1.2584E+03, 1.2805E+03, &
       1.3027E+03, 1.3248E+03, 1.3470E+03, 1.3692E+03, 1.3914E+03, 1.4137E+03, 1.4359E+03, 1.4582E+03, 1.4805E+03, 1.5029E+03, &
       1.5252E+03, 1.5476E+03, 1.5700E+03, 1.5925E+03, 1.6150E+03, 1.6375E+03, 1.6601E+03, 1.6827E+03, 1.7054E+03, 1.7281E+03, &
       1.7508E+03, 1.7736E+03, 1.7965E+03, 1.8194E+03, 1.8423E+03, 1.8653E+03, 1.8884E+03, 1.9115E+03, 1.9347E+03, 1.9580E+03, &
       1.9813E+03, 2.0047E+03, 2.0282E+03, 2.0517E+03, 2.0753E+03, 2.0990E+03, 2.1228E+03, 2.1466E+03, 2.1706E+03, 2.1946E+03, &
       2.2187E+03, 2.2429E+03, 2.2672E+03, 2.2915E+03, 2.3160E+03, 2.3406E+03, 2.3652E+03, 2.3900E+03, 2.4148E+03, 2.4398E+03, &
       2.4649E+03, 2.4901E+03, 2.5154E+03, 2.5408E+03, 2.5663E+03, 2.5919E+03, 2.6176E+03, 2.6435E+03, 2.6695E+03, 2.6956E+03, &
       2.7218E+03, 2.7481E+03, 2.7746E+03, 2.8012E+03, 2.8279E+03, 2.8548E+03, 2.8818E+03, 2.9089E+03, 2.9361E+03, 2.9635E+03, &
       2.9911E+03, 3.0188E+03, 3.0466E+03, 3.0745E+03, 3.1026E+03, 3.1309E+03, 3.1593E+03, 3.1878E+03, 3.2165E+03, 3.2454E+03, &
       3.2744E+03, 3.3036E+03, 3.3329E+03, 3.3623E+03, 3.3920E+03, 3.4218E+03, 3.4517E+03, 3.4819E+03, 3.5122E+03, 3.5426E+03, &
       3.5732E+03, 3.6040E+03, 3.6350E+03, 3.6661E+03, 3.6974E+03, 3.7289E+03, 3.7606E+03, 3.7924E+03, 3.8245E+03, 3.8567E+03, &
       3.8890E+03, 3.9216E+03, 3.9543E+03, 3.9873E+03, 4.0204E+03, 4.0537E+03, 4.0872E+03, 4.1209E+03, 4.1548E+03, 4.1889E+03, &
       4.2232E+03, 4.2576E+03, 4.2923E+03, 4.3272E+03, 4.3622E+03, 4.3975E+03, 4.4330E+03, 4.4687E+03, 4.5046E+03, 4.5406E+03, &
       4.5769E+03, 4.6135E+03, 4.6502E+03, 4.6871E+03, 4.7243E+03, 4.7616E+03, 4.7992E+03, 4.8370E+03, 4.8750E+03, 4.9132E+03, &
       4.9517E+03, 4.9904E+03, 5.0293E+03, 5.0684E+03, 5.1078E+03, 5.1474E+03, 5.1872E+03, 5.2272E+03, 5.2675E+03, 5.3080E+03, &
       5.3487E+03, 5.3897E+03, 5.4309E+03, 5.4724E+03, 5.5141E+03, 5.5560E+03, 5.5982E+03, 5.6406E+03, 5.6833E+03, 5.7262E+03, &
       5.7694E+03, 5.8128E+03, 5.8564E+03, 5.9003E+03, 5.9445E+03, 5.9889E+03, 6.0336E+03, 6.0785E+03, 6.1237E+03, 6.1692E+03, &
       6.2149E+03, 6.2608E+03, 6.3071E+03, 6.3536E+03, 6.4004E+03, 6.4474E+03, 6.4947E+03, 6.5423E+03, 6.5901E+03, 6.6382E+03, &
       6.6866E+03, 6.7353E+03, 6.7842E+03, 6.8335E+03, 6.8830E+03, 6.9328E+03, 6.9828E+03, 7.0332E+03, 7.0838E+03, 7.1348E+03, &
       7.1860E+03, 7.2375E+03, 7.2893E+03, 7.3414E+03, 7.3938E+03, 7.4464E+03, 7.4994E+03, 7.5527E+03, 7.6063E+03, 7.6601E+03, &
       7.7143E+03, 7.7688E+03, 7.8236E+03, 7.8787E+03, 7.9341E+03, 7.9898E+03, 8.0458E+03, 8.1022E+03, 8.1588E+03, 8.2158E+03, &
       8.2731E+03, 8.3307E+03, 8.3886E+03, 8.4468E+03, 8.5054E+03, 8.5643E+03, 8.6235E+03, 8.6830E+03, 8.7429E+03, 8.8031E+03, &
       8.8637E+03, 8.9245E+03, 8.9857E+03, 9.0473E+03, 9.1092E+03, 9.1714E+03, 9.2339E+03, 9.2968E+03, 9.3601E+03, 9.4237E+03, &
       9.4876E+03, 9.5519E+03, 9.6166E+03, 9.6816E+03, 9.7469E+03, 9.8126E+03, 9.8787E+03, 9.9451E+03, 1.0012E+04, 1.0079E+04, &
       1.0146E+04, 1.0214E+04, 1.0283E+04, 1.0351E+04, 1.0420E+04, 1.0489E+04, 1.0559E+04, 1.0629E+04, 1.0700E+04, 1.0771E+04, &
       1.0842E+04, 1.0913E+04, 1.0985E+04, 1.1058E+04, 1.1131E+04, 1.1204E+04, 1.1277E+04, 1.1351E+04, 1.1425E+04, 1.1500E+04, &
       1.1575E+04, 1.1651E+04, 1.1727E+04, 1.1803E+04, 1.1880E+04, 1.1957E+04, 1.2034E+04, 1.2112E+04, 1.2191E+04, 1.2269E+04, &
       1.2348E+04, 1.2428E+04, 1.2508E+04, 1.2588E+04, 1.2669E+04, 1.2751E+04, 1.2832E+04, 1.2914E+04, 1.2997E+04, 1.3080E+04, &
       1.3163E+04, 1.3247E+04, 1.3331E+04, 1.3416E+04, 1.3501E+04, 1.3587E+04, 1.3673E+04, 1.3759E+04, 1.3846E+04, 1.3933E+04, &
       1.4021E+04, 1.4109E+04, 1.4198E+04, 1.4287E+04, 1.4377E+04, 1.4467E+04, 1.4557E+04, 1.4648E+04, 1.4740E+04, 1.4832E+04, &
       1.4924E+04, 1.5017E+04, 1.5110E+04, 1.5204E+04, 1.5298E+04, 1.5393E+04, 1.5488E+04, 1.5584E+04, 1.5680E+04, 1.5777E+04, &
       1.5874E+04, 1.5972E+04, 1.6070E+04, 1.6169E+04, 1.6268E+04, 1.6367E+04, 1.6467E+04, 1.6568E+04, 1.6669E+04, 1.6771E+04, &
       1.6873E+04, 1.6976E+04, 1.7079E+04, 1.7183E+04, 1.7287E+04, 1.7391E+04, 1.7497E+04, 1.7602E+04, 1.7709E+04, 1.7815E+04, &
       1.7923E+04, 1.8031E+04, 1.8139E+04, 1.8248E+04, 1.8357E+04, 1.8467E+04, 1.8578E+04, 1.8689E+04, 1.8800E+04, 1.8913E+04, &
       1.9025E+04, 1.9139E+04, 1.9252E+04, 1.9367E+04, 1.9482E+04, 1.9597E+04, 1.9713E+04, 1.9830E+04, 1.9947E+04, 2.0065E+04, &
       2.0183E+04, 2.0302E+04, 2.0421E+04, 2.0541E+04, 2.0662E+04, 2.0783E+04, 2.0905E+04, 2.1027E+04, 2.1150E+04, 2.1273E+04, &
       2.1397E+04, 2.1522E+04, 2.1647E+04, 2.1773E+04, 2.1900E+04, 2.2027E+04, 2.2155E+04, 2.2283E+04, 2.2412E+04, 2.2541E+04, &
       2.2671E+04, 2.2802E+04, 2.2934E+04, 2.3065E+04, 2.3198E+04, 2.3331E+04, 2.3465E+04, 2.3600E+04, 2.3735E+04, 2.3871E+04, &
       2.4007E+04, 2.4144E+04, 2.4282E+04, 2.4420E+04, 2.4559E+04, 2.4698E+04, 2.4839E+04, 2.4980E+04, 2.5121E+04, 2.5263E+04, &
       2.5406E+04, 2.5550E+04, 2.5694E+04, 2.5839E+04, 2.5984E+04, 2.6131E+04, 2.6278E+04, 2.6425E+04, 2.6573E+04, 2.6722E+04, &
       2.6872E+04, 2.7022E+04, 2.7173E+04, 2.7325E+04, 2.7477E+04, 2.7630E+04, 2.7784E+04, 2.7938E+04, 2.8094E+04, 2.8250E+04, &
       2.8406E+04, 2.8563E+04, 2.8721E+04, 2.8880E+04, 2.9040E+04, 2.9200E+04, 2.9361E+04, 2.9522E+04, 2.9685E+04, 2.9848E+04, &
       3.0012E+04, 3.0176E+04, 3.0341E+04, 3.0507E+04, 3.0674E+04, 3.0842E+04, 3.1010E+04, 3.1179E+04, 3.1349E+04, 3.1519E+04, &
       3.1691E+04, 3.1863E+04, 3.2036E+04, 3.2209E+04, 3.2384E+04, 3.2559E+04, 3.2735E+04, 3.2911E+04, 3.3089E+04, 3.3267E+04, &
       3.3446E+04, 3.3626E+04, 3.3807E+04, 3.3988E+04, 3.4170E+04, 3.4353E+04, 3.4537E+04, 3.4722E+04, 3.4907E+04, 3.5094E+04, &
       3.5281E+04, 3.5469E+04, 3.5657E+04, 3.5847E+04, 3.6037E+04, 3.6229E+04, 3.6421E+04, 3.6613E+04, 3.6807E+04, 3.7002E+04, &
       3.7197E+04, 3.7393E+04, 3.7590E+04, 3.7788E+04, 3.7987E+04, 3.8187E+04, 3.8387E+04, 3.8589E+04, 3.8791E+04, 3.8994E+04, &
       3.9198E+04, 3.9403E+04, 3.9609E+04, 3.9815E+04, 4.0023E+04, 4.0231E+04, 4.0440E+04, 4.0650E+04, 4.0862E+04, 4.1073E+04, &
       4.1286E+04, 4.1500E+04, 4.1715E+04, 4.1930E+04, 4.2147E+04, 4.2364E+04, 4.2583E+04, 4.2802E+04, 4.3022E+04, 4.3243E+04, &
       4.3465E+04, 4.3688E+04, 4.3912E+04, 4.4137E+04, 4.4363E+04, 4.4589E+04, 4.4817E+04, 4.5046E+04, 4.5275E+04, 4.5506E+04, &
       4.5737E+04, 4.5970E+04, 4.6203E+04, 4.6438E+04, 4.6673E+04, 4.6909E+04, 4.7147E+04, 4.7385E+04, 4.7624E+04, 4.7865E+04, &
       4.8106E+04, 4.8348E+04, 4.8592E+04, 4.8836E+04, 4.9081E+04, 4.9328E+04, 4.9575E+04, 4.9823E+04, 5.0073E+04, 5.0323E+04, &
       5.0574E+04, 5.0827E+04, 5.1080E+04, 5.1335E+04, 5.1590E+04, 5.1847E+04, 5.2105E+04, 5.2363E+04, 5.2623E+04, 5.2884E+04, &
       5.3146E+04, 5.3408E+04, 5.3672E+04, 5.3937E+04, 5.4204E+04, 5.4471E+04, 5.4739E+04, 5.5008E+04, 5.5279E+04, 5.5550E+04, &
       5.5823E+04, 5.6097E+04, 5.6371E+04, 5.6647E+04, 5.6924E+04, 5.7202E+04, 5.7482E+04, 5.7762E+04, 5.8044E+04, 5.8326E+04, &
       5.8610E+04, 5.8895E+04, 5.9181E+04, 5.9468E+04, 5.9756E+04, 6.0045E+04, 6.0336E+04, 6.0628E+04, 6.0920E+04, 6.1215E+04, &
       6.1510E+04, 6.1806E+04, 6.2104E+04, 6.2402E+04, 6.2702E+04, 6.3003E+04, 6.3305E+04, 6.3609E+04, 6.3913E+04, 6.4219E+04, &
       6.4526E+04, 6.4834E+04, 6.5144E+04, 6.5454E+04, 6.5766E+04, 6.6079E+04, 6.6393E+04, 6.6709E+04, 6.7025E+04, 6.7343E+04, &
       6.7662E+04, 6.7983E+04, 6.8304E+04, 6.8627E+04, 6.8951E+04, 6.9277E+04, 6.9603E+04, 6.9931E+04, 7.0260E+04, 7.0591E+04, &
       7.0922E+04, 7.1255E+04, 7.1589E+04, 7.1925E+04, 7.2262E+04, 7.2600E+04, 7.2939E+04, 7.3280E+04, 7.3622E+04, 7.3965E+04, &
       7.4310E+04, 7.4656E+04, 7.5003E+04, 7.5351E+04, 7.5701E+04, 7.6052E+04, 7.6405E+04, 7.6759E+04, 7.7114E+04, 7.7470E+04, &
       7.7828E+04, 7.8187E+04, 7.8548E+04, 7.8910E+04, 7.9273E+04, 7.9638E+04, 8.0004E+04, 8.0371E+04, 8.0740E+04, 8.1110E+04, &
       8.1482E+04, 8.1855E+04, 8.2229E+04, 8.2605E+04, 8.2982E+04, 8.3361E+04, 8.3741E+04, 8.4122E+04, 8.4505E+04, 8.4889E+04, &
       8.5275E+04, 8.5662E+04, 8.6050E+04, 8.6440E+04, 8.6832E+04, 8.7224E+04, 8.7619E+04, 8.8014E+04, 8.8412E+04, 8.8810E+04, &
       8.9210E+04, 8.9612E+04, 9.0015E+04, 9.0420E+04, 9.0826E+04, 9.1233E+04, 9.1642E+04, 9.2053E+04, 9.2465E+04, 9.2878E+04, &
       9.3293E+04, 9.3710E+04, 9.4128E+04, 9.4547E+04, 9.4969E+04, 9.5391E+04, 9.5815E+04, 9.6241E+04, 9.6668E+04, 9.7097E+04, &
       9.7528E+04, 9.7959E+04, 9.8393E+04, 9.8828E+04, 9.9265E+04, 9.9703E+04, 1.0014E+05, 1.0058E+05, 1.0103E+05, 1.0147E+05, &
       1.0192E+05, 1.0237E+05, 1.0281E+05, 1.0327E+05, 1.0372E+05, 1.0417E+05, 1.0463E+05, 1.0509E+05, 1.0554E+05, 1.0600E+05, &
       1.0647E+05, 1.0693E+05, 1.0740E+05, 1.0786E+05, 1.0833E+05, 1.0880E+05, 1.0928E+05, 1.0975E+05, 1.1023E+05, 1.1070E+05, &
       1.1118E+05, 1.1166E+05, 1.1214E+05, 1.1263E+05, 1.1311E+05, 1.1360E+05, 1.1409E+05, 1.1458E+05, 1.1507E+05, 1.1557E+05, &
       1.1606E+05, 1.1656E+05, 1.1706E+05, 1.1756E+05, 1.1807E+05, 1.1857E+05, 1.1908E+05, 1.1959E+05, 1.2010E+05, 1.2061E+05, &
       1.2112E+05, 1.2164E+05, 1.2215E+05, 1.2267E+05, 1.2319E+05, 1.2372E+05, 1.2424E+05, 1.2477E+05, 1.2529E+05, 1.2582E+05, &
       1.2636E+05, 1.2689E+05, 1.2742E+05, 1.2796E+05, 1.2850E+05, 1.2904E+05, 1.2958E+05, 1.3013E+05, 1.3067E+05, 1.3122E+05, &
       1.3177E+05, 1.3232E+05, 1.3288E+05, 1.3343E+05, 1.3399E+05, 1.3455E+05, 1.3511E+05, 1.3568E+05, 1.3624E+05, 1.3681E+05, &
       1.3738E+05, 1.3795E+05, 1.3852E+05, 1.3910E+05, 1.3967E+05, 1.4025E+05, 1.4083E+05, 1.4142E+05, 1.4200E+05, 1.4259E+05, &
       1.4317E+05, 1.4377E+05, 1.4436E+05, 1.4495E+05, 1.4555E+05, 1.4615E+05, 1.4675E+05, 1.4735E+05, 1.4795E+05, 1.4856E+05, &
       1.4917E+05, 1.4978E+05, 1.5039E+05, 1.5101E+05, 1.5162E+05, 1.5224E+05, 1.5286E+05, 1.5349E+05, 1.5411E+05, 1.5474E+05, &
       1.5537E+05, 1.5600E+05, 1.5663E+05, 1.5727E+05, 1.5790E+05, 1.5854E+05, 1.5918E+05, 1.5983E+05, 1.6047E+05, 1.6112E+05, &
       1.6177E+05, 1.6242E+05, 1.6308E+05, 1.6374E+05, 1.6439E+05, 1.6505E+05, 1.6572E+05, 1.6638E+05, 1.6705E+05, 1.6772E+05, &
       1.6839E+05, 1.6906E+05, 1.6974E+05, 1.7042E+05, 1.7110E+05, 1.7178E+05, 1.7247E+05, 1.7315E+05, 1.7384E+05, 1.7453E+05, &
       1.7523E+05, 1.7592E+05, 1.7662E+05, 1.7732E+05, 1.7802E+05, 1.7873E+05, 1.7944E+05, 1.8014E+05, 1.8086E+05, 1.8157E+05, &
       1.8229E+05, 1.8300E+05, 1.8373E+05, 1.8445E+05, 1.8517E+05, 1.8590E+05, 1.8663E+05, 1.8736E+05, 1.8810E+05, 1.8884E+05, &
       1.8957E+05, 1.9032E+05, 1.9106E+05, 1.9181E+05, 1.9256E+05, 1.9331E+05, 1.9406E+05, 1.9482E+05, 1.9557E+05, 1.9633E+05, &
       1.9710E+05, 1.9786E+05, 1.9863E+05, 1.9940E+05, 2.0017E+05, 2.0095E+05, 2.0173E+05, 2.0251E+05, 2.0329E+05, 2.0407E+05, &
       2.0486E+05, 2.0565E+05, 2.0644E+05, 2.0724E+05, 2.0803E+05, 2.0883E+05, 2.0964E+05, 2.1044E+05, 2.1125E+05, 2.1206E+05, &
       2.1287E+05, 2.1368E+05, 2.1450E+05, 2.1532E+05, 2.1614E+05, 2.1697E+05, 2.1780E+05, 2.1863E+05, 2.1946E+05, 2.2029E+05, &
       2.2113E+05, 2.2197E+05, 2.2281E+05, 2.2366E+05, 2.2451E+05, 2.2536E+05, 2.2621E+05, 2.2707E+05, 2.2792E+05, 2.2879E+05, &
       2.2965E+05, 2.3051E+05, 2.3138E+05, 2.3225E+05, 2.3313E+05, 2.3401E+05, 2.3489E+05, 2.3577E+05, 2.3665E+05, 2.3754E+05, &
       2.3843E+05, 2.3932E+05, 2.4022E+05, 2.4112E+05, 2.4202E+05, 2.4292E+05, 2.4383E+05, 2.4474E+05, 2.4565E+05, 2.4656E+05, &
       2.4748E+05, 2.4840E+05, 2.4932E+05, 2.5025E+05, 2.5118E+05, 2.5211E+05, 2.5304E+05, 2.5398E+05, 2.5492E+05, 2.5586E+05, &
       2.5681E+05, 2.5775E+05, 2.5870E+05, 2.5966E+05, 2.6061E+05, 2.6157E+05, 2.6254E+05, 2.6350E+05, 2.6447E+05, 2.6544E+05, &
       2.6641E+05, 2.6739E+05, 2.6837E+05, 2.6935E+05, 2.7034E+05, 2.7132E+05, 2.7231E+05, 2.7331E+05, 2.7430E+05, 2.7530E+05, &
       2.7631E+05, 2.7731E+05, 2.7832E+05, 2.7933E+05, 2.8035E+05, 2.8136E+05, 2.8238E+05, 2.8341E+05, 2.8443E+05, 2.8546E+05, &
       2.8650E+05, 2.8753E+05, 2.8857E+05, 2.8961E+05, 2.9065E+05, 2.9170E+05, 2.9275E+05, 2.9381E+05, 2.9486E+05, 2.9592E+05, &
       2.9698E+05, 2.9805E+05, 2.9912E+05, 3.0019E+05, 3.0126E+05, 3.0234E+05, 3.0342E+05, 3.0451E+05, 3.0559E+05, 3.0668E+05, &
       3.0778E+05, 3.0887E+05, 3.0997E+05, 3.1108E+05, 3.1218E+05, 3.1329E+05, 3.1440E+05, 3.1552E+05, 3.1664E+05, 3.1776E+05, &
       3.1889E+05, 3.2001E+05, 3.2115E+05, 3.2228E+05, 3.2342E+05, 3.2456E+05, 3.2570E+05, 3.2685E+05, 3.2800E+05, 3.2916E+05, &
       3.3031E+05, 3.3147E+05, 3.3264E+05, 3.3380E+05, 3.3497E+05, 3.3615E+05, 3.3733E+05, 3.3851E+05, 3.3969E+05, 3.4088E+05, &
       3.4207E+05, 3.4326E+05, 3.4446E+05, 3.4566E+05, 3.4686E+05, 3.4807E+05, 3.4928E+05, 3.5049E+05, 3.5171E+05, 3.5293E+05, &
       3.5415E+05, 3.5538E+05, 3.5661E+05, 3.5784E+05, 3.5908E+05, 3.6032E+05, 3.6157E+05, 3.6281E+05, 3.6406E+05, 3.6532E+05, &
       3.6658E+05, 3.6784E+05, 3.6910E+05, 3.7037E+05, 3.7164E+05, 3.7292E+05, 3.7420E+05, 3.7548E+05, 3.7677E+05, 3.7805E+05, &
       3.7935E+05, 3.8064E+05, 3.8194E+05, 3.8325E+05, 3.8455E+05, 3.8586E+05, 3.8718E+05, 3.8850E+05, 3.8982E+05, 3.9114E+05, &
       3.9247E+05, 3.9380E+05, 3.9514E+05, 3.9648E+05, 3.9782E+05, 3.9917E+05, 4.0052E+05, 4.0187E+05, 4.0323E+05, 4.0459E+05, &
       4.0595E+05, 4.0732E+05, 4.0869E+05, 4.1007E+05, 4.1145E+05, 4.1283E+05, 4.1422E+05, 4.1561E+05, 4.1700E+05, 4.1840E+05, &
       4.1980E+05, 4.2121E+05, 4.2262E+05, 4.2403E+05, 4.2545E+05, 4.2687E+05, 4.2829E+05, 4.2972E+05, 4.3115E+05, 4.3259E+05, &
       4.3403E+05, 4.3547E+05, 4.3692E+05, 4.3837E+05, 4.3982E+05, 4.4128E+05, 4.4274E+05, 4.4421E+05, 4.4568E+05, 4.4715E+05, &
       4.4863E+05, 4.5011E+05, 4.5159E+05, 4.5308E+05, 4.5458E+05, 4.5607E+05, 4.5758E+05, 4.5908E+05, 4.6059E+05, 4.6210E+05, &
       4.6362E+05, 4.6514E+05, 4.6666E+05, 4.6819E+05, 4.6972E+05, 4.7126E+05, 4.7280E+05, 4.7435E+05, 4.7589E+05, 4.7745E+05, &
       4.7900E+05, 4.8056E+05, 4.8213E+05, 4.8370E+05, 4.8527E+05, 4.8684E+05, 4.8842E+05, 4.9001E+05, 4.9160E+05, 4.9319E+05, &
       4.9479E+05, 4.9639E+05, 4.9799E+05, 4.9960E+05, 5.0122E+05, 5.0283E+05, 5.0445E+05, 5.0608E+05, 5.0771E+05, 5.0934E+05, &
       5.1098E+05, 5.1262E+05, 5.1427E+05, 5.1592E+05, 5.1757E+05, 5.1923E+05, 5.2090E+05, 5.2256E+05, 5.2424E+05, 5.2591E+05, &
       5.2759E+05, 5.2927E+05, 5.3096E+05, 5.3266E+05, 5.3435E+05, 5.3605E+05, 5.3776E+05, 5.3947E+05, 5.4118E+05, 5.4290E+05, &
       5.4462E+05, 5.4635E+05, 5.4808E+05, 5.4982E+05, 5.5156E+05, 5.5330E+05, 5.5505E+05, 5.5680E+05, 5.5856E+05, 5.6032E+05, &
       5.6208E+05, 5.6385E+05, 5.6563E+05, 5.6741E+05, 5.6919E+05, 5.7098E+05, 5.7277E+05, 5.7457E+05, 5.7637E+05, 5.7817E+05, &
       5.7998E+05, 5.8180E+05, 5.8362E+05, 5.8544E+05, 5.8727E+05, 5.8910E+05, 5.9093E+05, 5.9278E+05, 5.9462E+05, 5.9647E+05, &
       5.9832E+05, 6.0018E+05, 6.0205E+05, 6.0392E+05, 6.0579E+05, 6.0766E+05, 6.0955E+05, 6.1143E+05, 6.1332E+05, 6.1522E+05, &
       6.1712E+05, 6.1902E+05, 6.2093E+05, 6.2285E+05, 6.2476E+05, 6.2669E+05, 6.2861E+05, 6.3055E+05, 6.3248E+05, 6.3442E+05, &
       6.3637E+05, 6.3832E+05, 6.4028E+05, 6.4224E+05, 6.4420E+05, 6.4617E+05, 6.4815E+05, 6.5012E+05, 6.5211E+05, 6.5410E+05, &
       6.5609E+05, 6.5809E+05, 6.6009E+05, 6.6210E+05, 6.6411E+05, 6.6612E+05, 6.6815E+05, 6.7017E+05, 6.7220E+05, 6.7424E+05, &
       6.7628E+05, 6.7832E+05, 6.8038E+05, 6.8243E+05, 6.8449E+05, 6.8655E+05, 6.8862E+05, 6.9070E+05, 6.9278E+05, 6.9486E+05, &
       6.9695E+05, 6.9904E+05, 7.0114E+05, 7.0325E+05, 7.0535E+05, 7.0747E+05, 7.0959E+05, 7.1171E+05, 7.1384E+05, 7.1597E+05, &
       7.1811E+05, 7.2025E+05, 7.2240E+05, 7.2455E+05, 7.2671E+05, 7.2887E+05, 7.3104E+05, 7.3321E+05, 7.3539E+05, 7.3757E+05, &
       7.3976E+05, 7.4195E+05, 7.4415E+05, 7.4636E+05, 7.4856E+05, 7.5078E+05, 7.5299E+05, 7.5522E+05, 7.5745E+05, 7.5968E+05, &
       7.6192E+05, 7.6416E+05, 7.6641E+05, 7.6866E+05, 7.7092E+05, 7.7318E+05, 7.7545E+05, 7.7773E+05, 7.8001E+05, 7.8229E+05, &
       7.8458E+05, 7.8687E+05, 7.8917E+05, 7.9148E+05, 7.9379E+05, 7.9611E+05, 7.9843E+05, 8.0075E+05, 8.0308E+05, 8.0542E+05, &
       8.0776E+05, 8.1011E+05, 8.1246E+05, 8.1482E+05, 8.1718E+05, 8.1955E+05, 8.2192E+05, 8.2430E+05, 8.2668E+05, 8.2907E+05, &
       8.3146E+05, 8.3386E+05, 8.3627E+05, 8.3868E+05, 8.4109E+05, 8.4351E+05, 8.4594E+05, 8.4837E+05, 8.5081E+05, 8.5325E+05, &
       8.5570E+05, 8.5815E+05, 8.6061E+05, 8.6307E+05, 8.6554E+05, 8.6802E+05, 8.7050E+05, 8.7298E+05, 8.7547E+05, 8.7797E+05, &
       8.8047E+05, 8.8298E+05, 8.8549E+05, 8.8801E+05, 8.9053E+05, 8.9306E+05, 8.9559E+05, 8.9813E+05, 9.0068E+05, 9.0323E+05, &
       9.0579E+05, 9.0835E+05, 9.1091E+05, 9.1349E+05, 9.1607E+05, 9.1865E+05, 9.2124E+05, 9.2383E+05, 9.2644E+05, 9.2904E+05, &
       9.3165E+05, 9.3427E+05, 9.3689E+05, 9.3952E+05, 9.4216E+05, 9.4480E+05, 9.4744E+05, 9.5009E+05, 9.5275E+05, 9.5541E+05, &
       9.5808E+05, 9.6075E+05, 9.6343E+05, 9.6612E+05, 9.6881E+05, 9.7151E+05, 9.7421E+05, 9.7692E+05, 9.7963E+05, 9.8235E+05, &
       9.8507E+05, 9.8780E+05, 9.9054E+05, 9.9328E+05, 9.9603E+05, 9.9878E+05, 1.0015E+06, 1.0043E+06, 1.0071E+06, 1.0099E+06, &
       1.0126E+06, 1.0154E+06, 1.0182E+06, 1.0210E+06, 1.0238E+06, 1.0266E+06, 1.0295E+06, 1.0323E+06, 1.0351E+06, 1.0379E+06, &
       1.0408E+06, 1.0436E+06, 1.0465E+06, 1.0493E+06, 1.0522E+06, 1.0551E+06, 1.0580E+06, 1.0608E+06, 1.0637E+06, 1.0666E+06, &
       1.0695E+06, 1.0724E+06, 1.0753E+06, 1.0783E+06, 1.0812E+06, 1.0841E+06, 1.0870E+06, 1.0900E+06, 1.0929E+06, 1.0959E+06, &
       1.0988E+06, 1.1018E+06, 1.1048E+06, 1.1078E+06, 1.1107E+06, 1.1137E+06, 1.1167E+06, 1.1197E+06, 1.1227E+06, 1.1257E+06, &
       1.1288E+06, 1.1318E+06, 1.1348E+06, 1.1379E+06, 1.1409E+06, 1.1440E+06, 1.1470E+06, 1.1501E+06, 1.1531E+06, 1.1562E+06, &
       1.1593E+06, 1.1624E+06, 1.1655E+06, 1.1686E+06, 1.1717E+06, 1.1748E+06, 1.1779E+06, 1.1810E+06, 1.1842E+06, 1.1873E+06, &
       1.1905E+06, 1.1936E+06, 1.1968E+06, 1.1999E+06, 1.2031E+06, 1.2063E+06, 1.2094E+06, 1.2126E+06, 1.2158E+06, 1.2190E+06, &
       1.2222E+06, 1.2254E+06, 1.2286E+06, 1.2319E+06, 1.2351E+06, 1.2383E+06, 1.2416E+06, 1.2448E+06, 1.2481E+06, 1.2513E+06, &
       1.2546E+06, 1.2579E+06, 1.2612E+06, 1.2645E+06, 1.2677E+06, 1.2710E+06, 1.2744E+06, 1.2777E+06, 1.2810E+06, 1.2843E+06, &
       1.2876E+06, 1.2910E+06, 1.2943E+06, 1.2977E+06, 1.3010E+06, 1.3044E+06, 1.3078E+06, 1.3111E+06, 1.3145E+06, 1.3179E+06, &
       1.3213E+06, 1.3247E+06, 1.3281E+06, 1.3315E+06, 1.3350E+06, 1.3384E+06, 1.3418E+06, 1.3453E+06, 1.3487E+06, 1.3522E+06, &
       1.3556E+06, 1.3591E+06, 1.3626E+06, 1.3661E+06, 1.3695E+06, 1.3730E+06, 1.3765E+06, 1.3800E+06, 1.3836E+06, 1.3871E+06, &
       1.3906E+06, 1.3941E+06, 1.3977E+06, 1.4012E+06, 1.4048E+06, 1.4083E+06, 1.4119E+06, 1.4155E+06, 1.4190E+06, 1.4226E+06, &
       1.4262E+06, 1.4298E+06, 1.4334E+06, 1.4370E+06, 1.4407E+06, 1.4443E+06, 1.4479E+06, 1.4516E+06, 1.4552E+06, 1.4589E+06, &
       1.4625E+06, 1.4662E+06, 1.4699E+06, 1.4735E+06, 1.4772E+06, 1.4809E+06, 1.4846E+06, 1.4883E+06, 1.4920E+06, 1.4958E+06, &
       1.4995E+06, 1.5032E+06, 1.5070E+06, 1.5107E+06, 1.5145E+06, 1.5182E+06, 1.5220E+06, 1.5258E+06, 1.5295E+06, 1.5333E+06, &
       1.5371E+06, 1.5409E+06, 1.5447E+06, 1.5486E+06, 1.5524E+06, 1.5562E+06, 1.5600E+06, 1.5639E+06, 1.5677E+06, 1.5716E+06, &
       1.5755E+06, 1.5793E+06, 1.5832E+06, 1.5871E+06, 1.5910E+06, 1.5949E+06, 1.5988E+06, 1.6027E+06, 1.6066E+06, 1.6105E+06, &
       1.6145E+06, 1.6184E+06, 1.6224E+06, 1.6263E+06, 1.6303E+06, 1.6342E+06, 1.6382E+06, 1.6422E+06, 1.6462E+06, 1.6502E+06, &
       1.6542E+06, 1.6582E+06, 1.6622E+06, 1.6662E+06, 1.6703E+06, 1.6743E+06, 1.6784E+06, 1.6824E+06, 1.6865E+06, 1.6905E+06, &
       1.6946E+06, 1.6987E+06, 1.7028E+06, 1.7069E+06, 1.7110E+06, 1.7151E+06, 1.7192E+06, 1.7233E+06, 1.7274E+06, 1.7316E+06, &
       1.7357E+06, 1.7399E+06, 1.7440E+06, 1.7482E+06, 1.7524E+06, 1.7566E+06, 1.7607E+06, 1.7649E+06, 1.7691E+06, 1.7733E+06, &
       1.7776E+06, 1.7818E+06, 1.7860E+06, 1.7902E+06, 1.7945E+06, 1.7987E+06, 1.8030E+06, 1.8073E+06, 1.8115E+06, 1.8158E+06, &
       1.8201E+06, 1.8244E+06, 1.8287E+06, 1.8330E+06, 1.8373E+06, 1.8417E+06, 1.8460E+06, 1.8503E+06, 1.8547E+06, 1.8590E+06, &
       1.8634E+06, 1.8678E+06, 1.8721E+06, 1.8765E+06, 1.8809E+06, 1.8853E+06, 1.8897E+06, 1.8941E+06, 1.8985E+06, 1.9030E+06, &
       1.9074E+06, 1.9118E+06, 1.9163E+06, 1.9207E+06, 1.9252E+06, 1.9297E+06, 1.9342E+06, 1.9386E+06, 1.9431E+06, 1.9476E+06, &
       1.9521E+06, 1.9566E+06, 1.9612E+06, 1.9657E+06, 1.9702E+06, 1.9748E+06, 1.9793E+06, 1.9839E+06, 1.9885E+06, 1.9930E+06, &
       1.9976E+06, 2.0022E+06, 2.0068E+06, 2.0114E+06, 2.0160E+06, 2.0206E+06, 2.0253E+06, 2.0299E+06, 2.0345E+06, 2.0392E+06, &
       2.0438E+06, 2.0485E+06, 2.0532E+06, 2.0579E+06, 2.0625E+06, 2.0672E+06, 2.0719E+06, 2.0766E+06, 2.0814E+06, 2.0861E+06, &
       2.0908E+06, 2.0956E+06, 2.1003E+06, 2.1051E+06, 2.1098E+06, 2.1146E+06, 2.1194E+06, 2.1241E+06, 2.1289E+06, 2.1337E+06, &
       2.1385E+06, 2.1434E+06, 2.1482E+06, 2.1530E+06, 2.1578E+06, 2.1627E+06, 2.1675E+06, 2.1724E+06, 2.1773E+06, 2.1821E+06, &
       2.1870E+06, 2.1919E+06, 2.1968E+06, 2.2017E+06, 2.2066E+06, 2.2116E+06, 2.2165E+06, 2.2214E+06, 2.2264E+06, 2.2313E+06, &
       2.2363E+06, 2.2413E+06, 2.2462E+06, 2.2512E+06, 2.2562E+06, 2.2612E+06, 2.2662E+06, 2.2712E+06, 2.2762E+06, 2.2813E+06, &
       2.2863E+06, 2.2914E+06, 2.2964E+06, 2.3015E+06, 2.3065E+06, 2.3116E+06, 2.3167E+06, 2.3218E+06, 2.3269E+06, 2.3320E+06, &
       2.3371E+06, 2.3422E+06, 2.3474E+06, 2.3525E+06, 2.3576E+06, 2.3628E+06, 2.3680E+06, 2.3731E+06, 2.3783E+06, 2.3835E+06, &
       2.3887E+06, 2.3939E+06, 2.3991E+06, 2.4043E+06, 2.4095E+06, 2.4148E+06, 2.4200E+06, 2.4252E+06, 2.4305E+06, 2.4358E+06, &
       2.4410E+06, 2.4463E+06, 2.4516E+06, 2.4569E+06, 2.4622E+06, 2.4675E+06, 2.4728E+06, 2.4782E+06, 2.4835E+06, 2.4888E+06, &
       2.4942E+06, 2.4995E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
      data (QofT( 4,J),J=2409,4510)/ 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       638
      data (QofT( 5,J),J=1,2408)/ 4.5211E+00, 8.2548E+00, 1.2017E+01, 1.5787E+01, 1.9558E+01, 2.3331E+01, 2.7105E+01, 3.0879E+01, &
       3.4654E+01, 3.8429E+01, 4.2204E+01, 4.5979E+01, 4.9754E+01, 5.3529E+01, 5.7304E+01, 6.1079E+01, 6.4855E+01, 6.8630E+01, &
       7.2405E+01, 7.6181E+01, 8.3732E+01, 9.1283E+01, 9.8834E+01, 1.0639E+02, 1.1394E+02, 1.2149E+02, 1.2904E+02, 1.3659E+02, &
       1.4414E+02, 1.5169E+02, 1.5925E+02, 1.6680E+02, 1.7435E+02, 1.8190E+02, 1.8945E+02, 1.9700E+02, 2.0456E+02, 2.1211E+02, &
       2.1966E+02, 2.2721E+02, 2.3476E+02, 2.4232E+02, 2.4987E+02, 2.5742E+02, 2.6497E+02, 2.7252E+02, 2.8008E+02, 2.8763E+02, &
       2.9518E+02, 3.0274E+02, 3.1029E+02, 3.1785E+02, 3.2540E+02, 3.3296E+02, 3.4052E+02, 3.4808E+02, 3.5564E+02, 3.6320E+02, &
       3.7076E+02, 3.7833E+02, 3.8590E+02, 3.9347E+02, 4.0104E+02, 4.0862E+02, 4.1620E+02, 4.2379E+02, 4.3138E+02, 4.3898E+02, &
       4.4658E+02, 4.5419E+02, 4.6181E+02, 4.6943E+02, 4.7706E+02, 4.8470E+02, 4.9234E+02, 5.0000E+02, 5.0767E+02, 5.1535E+02, &
       5.2304E+02, 5.3074E+02, 5.3845E+02, 5.4618E+02, 5.5392E+02, 5.6168E+02, 5.6945E+02, 5.7724E+02, 5.8505E+02, 5.9287E+02, &
       6.0071E+02, 6.0858E+02, 6.1646E+02, 6.2436E+02, 6.3228E+02, 6.4023E+02, 6.4819E+02, 6.5619E+02, 6.6420E+02, 6.7224E+02, &
       6.8031E+02, 6.8840E+02, 6.9652E+02, 7.0467E+02, 7.1285E+02, 7.2105E+02, 7.2929E+02, 7.3755E+02, 7.4585E+02, 7.5418E+02, &
       7.6254E+02, 7.7094E+02, 7.7937E+02, 7.8783E+02, 7.9633E+02, 8.0487E+02, 8.1344E+02, 8.2205E+02, 8.3070E+02, 8.3939E+02, &
       8.4811E+02, 8.5688E+02, 8.6569E+02, 8.7453E+02, 8.8342E+02, 8.9236E+02, 9.0133E+02, 9.1035E+02, 9.1942E+02, 9.2853E+02, &
       9.3768E+02, 9.4688E+02, 9.5613E+02, 9.6542E+02, 9.7476E+02, 9.8415E+02, 9.9359E+02, 1.0031E+03, 1.0126E+03, 1.0222E+03, &
       1.0319E+03, 1.0415E+03, 1.0513E+03, 1.0611E+03, 1.0709E+03, 1.0808E+03, 1.0908E+03, 1.1008E+03, 1.1109E+03, 1.1210E+03, &
       1.1312E+03, 1.1414E+03, 1.1517E+03, 1.1621E+03, 1.1725E+03, 1.1830E+03, 1.1935E+03, 1.2041E+03, 1.2147E+03, 1.2255E+03, &
       1.2362E+03, 1.2471E+03, 1.2580E+03, 1.2689E+03, 1.2800E+03, 1.2911E+03, 1.3022E+03, 1.3134E+03, 1.3247E+03, 1.3361E+03, &
       1.3475E+03, 1.3590E+03, 1.3705E+03, 1.3821E+03, 1.3938E+03, 1.4056E+03, 1.4174E+03, 1.4293E+03, 1.4413E+03, 1.4533E+03, &
       1.4654E+03, 1.4776E+03, 1.4899E+03, 1.5022E+03, 1.5146E+03, 1.5271E+03, 1.5396E+03, 1.5522E+03, 1.5649E+03, 1.5777E+03, &
       1.5905E+03, 1.6035E+03, 1.6165E+03, 1.6295E+03, 1.6427E+03, 1.6559E+03, 1.6692E+03, 1.6826E+03, 1.6961E+03, 1.7097E+03, &
       1.7233E+03, 1.7370E+03, 1.7508E+03, 1.7647E+03, 1.7786E+03, 1.7927E+03, 1.8068E+03, 1.8210E+03, 1.8353E+03, 1.8497E+03, &
       1.8642E+03, 1.8787E+03, 1.8933E+03, 1.9081E+03, 1.9229E+03, 1.9378E+03, 1.9528E+03, 1.9678E+03, 1.9830E+03, 1.9983E+03, &
       2.0136E+03, 2.0290E+03, 2.0446E+03, 2.0602E+03, 2.0759E+03, 2.0917E+03, 2.1076E+03, 2.1236E+03, 2.1397E+03, 2.1558E+03, &
       2.1721E+03, 2.1885E+03, 2.2050E+03, 2.2215E+03, 2.2382E+03, 2.2549E+03, 2.2718E+03, 2.2887E+03, 2.3058E+03, 2.3229E+03, &
       2.3402E+03, 2.3575E+03, 2.3750E+03, 2.3925E+03, 2.4102E+03, 2.4280E+03, 2.4458E+03, 2.4638E+03, 2.4818E+03, 2.5000E+03, &
       2.5183E+03, 2.5367E+03, 2.5552E+03, 2.5738E+03, 2.5925E+03, 2.6113E+03, 2.6302E+03, 2.6492E+03, 2.6684E+03, 2.6876E+03, &
       2.7070E+03, 2.7264E+03, 2.7460E+03, 2.7657E+03, 2.7855E+03, 2.8054E+03, 2.8255E+03, 2.8456E+03, 2.8659E+03, 2.8862E+03, &
       2.9067E+03, 2.9273E+03, 2.9481E+03, 2.9689E+03, 2.9899E+03, 3.0109E+03, 3.0321E+03, 3.0535E+03, 3.0749E+03, 3.0964E+03, &
       3.1181E+03, 3.1399E+03, 3.1618E+03, 3.1839E+03, 3.2060E+03, 3.2283E+03, 3.2508E+03, 3.2733E+03, 3.2960E+03, 3.3188E+03, &
       3.3417E+03, 3.3647E+03, 3.3879E+03, 3.4112E+03, 3.4346E+03, 3.4582E+03, 3.4819E+03, 3.5057E+03, 3.5297E+03, 3.5538E+03, &
       3.5780E+03, 3.6023E+03, 3.6268E+03, 3.6514E+03, 3.6762E+03, 3.7011E+03, 3.7261E+03, 3.7513E+03, 3.7766E+03, 3.8020E+03, &
       3.8276E+03, 3.8533E+03, 3.8792E+03, 3.9052E+03, 3.9313E+03, 3.9576E+03, 3.9840E+03, 4.0106E+03, 4.0373E+03, 4.0642E+03, &
       4.0912E+03, 4.1183E+03, 4.1456E+03, 4.1731E+03, 4.2006E+03, 4.2284E+03, 4.2563E+03, 4.2843E+03, 4.3125E+03, 4.3408E+03, &
       4.3693E+03, 4.3979E+03, 4.4267E+03, 4.4557E+03, 4.4848E+03, 4.5140E+03, 4.5434E+03, 4.5730E+03, 4.6027E+03, 4.6326E+03, &
       4.6626E+03, 4.6928E+03, 4.7231E+03, 4.7537E+03, 4.7843E+03, 4.8152E+03, 4.8462E+03, 4.8773E+03, 4.9086E+03, 4.9401E+03, &
       4.9718E+03, 5.0036E+03, 5.0356E+03, 5.0677E+03, 5.1000E+03, 5.1325E+03, 5.1652E+03, 5.1980E+03, 5.2310E+03, 5.2641E+03, &
       5.2975E+03, 5.3310E+03, 5.3646E+03, 5.3985E+03, 5.4325E+03, 5.4667E+03, 5.5011E+03, 5.5356E+03, 5.5704E+03, 5.6053E+03, &
       5.6404E+03, 5.6756E+03, 5.7111E+03, 5.7467E+03, 5.7825E+03, 5.8185E+03, 5.8547E+03, 5.8910E+03, 5.9276E+03, 5.9643E+03, &
       6.0012E+03, 6.0383E+03, 6.0756E+03, 6.1131E+03, 6.1508E+03, 6.1886E+03, 6.2267E+03, 6.2649E+03, 6.3033E+03, 6.3419E+03, &
       6.3808E+03, 6.4198E+03, 6.4590E+03, 6.4984E+03, 6.5380E+03, 6.5778E+03, 6.6177E+03, 6.6579E+03, 6.6983E+03, 6.7389E+03, &
       6.7797E+03, 6.8207E+03, 6.8619E+03, 6.9033E+03, 6.9449E+03, 6.9867E+03, 7.0287E+03, 7.0710E+03, 7.1134E+03, 7.1560E+03, &
       7.1989E+03, 7.2419E+03, 7.2852E+03, 7.3287E+03, 7.3724E+03, 7.4163E+03, 7.4604E+03, 7.5048E+03, 7.5493E+03, 7.5941E+03, &
       7.6391E+03, 7.6843E+03, 7.7297E+03, 7.7753E+03, 7.8212E+03, 7.8673E+03, 7.9136E+03, 7.9601E+03, 8.0069E+03, 8.0539E+03, &
       8.1011E+03, 8.1485E+03, 8.1962E+03, 8.2441E+03, 8.2922E+03, 8.3405E+03, 8.3891E+03, 8.4379E+03, 8.4870E+03, 8.5362E+03, &
       8.5858E+03, 8.6355E+03, 8.6855E+03, 8.7357E+03, 8.7862E+03, 8.8369E+03, 8.8878E+03, 8.9390E+03, 8.9904E+03, 9.0421E+03, &
       9.0940E+03, 9.1461E+03, 9.1985E+03, 9.2512E+03, 9.3041E+03, 9.3572E+03, 9.4106E+03, 9.4642E+03, 9.5181E+03, 9.5722E+03, &
       9.6266E+03, 9.6813E+03, 9.7362E+03, 9.7913E+03, 9.8467E+03, 9.9024E+03, 9.9583E+03, 1.0014E+04, 1.0071E+04, 1.0128E+04, &
       1.0185E+04, 1.0242E+04, 1.0299E+04, 1.0357E+04, 1.0415E+04, 1.0473E+04, 1.0532E+04, 1.0591E+04, 1.0650E+04, 1.0709E+04, &
       1.0769E+04, 1.0829E+04, 1.0889E+04, 1.0949E+04, 1.1010E+04, 1.1071E+04, 1.1132E+04, 1.1194E+04, 1.1256E+04, 1.1318E+04, &
       1.1380E+04, 1.1443E+04, 1.1506E+04, 1.1569E+04, 1.1633E+04, 1.1697E+04, 1.1761E+04, 1.1825E+04, 1.1890E+04, 1.1955E+04, &
       1.2020E+04, 1.2086E+04, 1.2151E+04, 1.2218E+04, 1.2284E+04, 1.2351E+04, 1.2418E+04, 1.2485E+04, 1.2553E+04, 1.2621E+04, &
       1.2689E+04, 1.2757E+04, 1.2826E+04, 1.2895E+04, 1.2965E+04, 1.3035E+04, 1.3105E+04, 1.3175E+04, 1.3246E+04, 1.3317E+04, &
       1.3388E+04, 1.3460E+04, 1.3532E+04, 1.3604E+04, 1.3676E+04, 1.3749E+04, 1.3822E+04, 1.3896E+04, 1.3970E+04, 1.4044E+04, &
       1.4118E+04, 1.4193E+04, 1.4268E+04, 1.4344E+04, 1.4420E+04, 1.4496E+04, 1.4572E+04, 1.4649E+04, 1.4726E+04, 1.4803E+04, &
       1.4881E+04, 1.4959E+04, 1.5038E+04, 1.5116E+04, 1.5196E+04, 1.5275E+04, 1.5355E+04, 1.5435E+04, 1.5515E+04, 1.5596E+04, &
       1.5677E+04, 1.5759E+04, 1.5841E+04, 1.5923E+04, 1.6005E+04, 1.6088E+04, 1.6172E+04, 1.6255E+04, 1.6339E+04, 1.6424E+04, &
       1.6508E+04, 1.6593E+04, 1.6679E+04, 1.6764E+04, 1.6850E+04, 1.6937E+04, 1.7024E+04, 1.7111E+04, 1.7199E+04, 1.7286E+04, &
       1.7375E+04, 1.7463E+04, 1.7553E+04, 1.7642E+04, 1.7732E+04, 1.7822E+04, 1.7912E+04, 1.8003E+04, 1.8095E+04, 1.8186E+04, &
       1.8278E+04, 1.8371E+04, 1.8464E+04, 1.8557E+04, 1.8650E+04, 1.8744E+04, 1.8839E+04, 1.8933E+04, 1.9029E+04, 1.9124E+04, &
       1.9220E+04, 1.9316E+04, 1.9413E+04, 1.9510E+04, 1.9608E+04, 1.9705E+04, 1.9804E+04, 1.9902E+04, 2.0002E+04, 2.0101E+04, &
       2.0201E+04, 2.0301E+04, 2.0402E+04, 2.0503E+04, 2.0605E+04, 2.0707E+04, 2.0809E+04, 2.0912E+04, 2.1015E+04, 2.1119E+04, &
       2.1223E+04, 2.1327E+04, 2.1432E+04, 2.1537E+04, 2.1643E+04, 2.1749E+04, 2.1856E+04, 2.1963E+04, 2.2070E+04, 2.2178E+04, &
       2.2286E+04, 2.2395E+04, 2.2504E+04, 2.2614E+04, 2.2724E+04, 2.2834E+04, 2.2945E+04, 2.3056E+04, 2.3168E+04, 2.3280E+04, &
       2.3393E+04, 2.3506E+04, 2.3620E+04, 2.3734E+04, 2.3848E+04, 2.3963E+04, 2.4078E+04, 2.4194E+04, 2.4311E+04, 2.4427E+04, &
       2.4544E+04, 2.4662E+04, 2.4780E+04, 2.4899E+04, 2.5018E+04, 2.5137E+04, 2.5257E+04, 2.5378E+04, 2.5499E+04, 2.5620E+04, &
       2.5742E+04, 2.5864E+04, 2.5987E+04, 2.6110E+04, 2.6234E+04, 2.6358E+04, 2.6483E+04, 2.6608E+04, 2.6734E+04, 2.6860E+04, &
       2.6986E+04, 2.7114E+04, 2.7241E+04, 2.7369E+04, 2.7498E+04, 2.7627E+04, 2.7757E+04, 2.7887E+04, 2.8017E+04, 2.8148E+04, &
       2.8280E+04, 2.8412E+04, 2.8545E+04, 2.8678E+04, 2.8811E+04, 2.8945E+04, 2.9080E+04, 2.9215E+04, 2.9351E+04, 2.9487E+04, &
       2.9624E+04, 2.9761E+04, 2.9898E+04, 3.0037E+04, 3.0175E+04, 3.0315E+04, 3.0455E+04, 3.0595E+04, 3.0736E+04, 3.0877E+04, &
       3.1019E+04, 3.1161E+04, 3.1304E+04, 3.1448E+04, 3.1592E+04, 3.1737E+04, 3.1882E+04, 3.2027E+04, 3.2174E+04, 3.2320E+04, &
       3.2468E+04, 3.2615E+04, 3.2764E+04, 3.2913E+04, 3.3062E+04, 3.3212E+04, 3.3363E+04, 3.3514E+04, 3.3666E+04, 3.3818E+04, &
       3.3971E+04, 3.4124E+04, 3.4278E+04, 3.4433E+04, 3.4588E+04, 3.4744E+04, 3.4900E+04, 3.5057E+04, 3.5214E+04, 3.5372E+04, &
       3.5531E+04, 3.5690E+04, 3.5849E+04, 3.6010E+04, 3.6171E+04, 3.6332E+04, 3.6494E+04, 3.6657E+04, 3.6820E+04, 3.6984E+04, &
       3.7148E+04, 3.7313E+04, 3.7479E+04, 3.7645E+04, 3.7812E+04, 3.7979E+04, 3.8147E+04, 3.8316E+04, 3.8485E+04, 3.8655E+04, &
       3.8825E+04, 3.8996E+04, 3.9168E+04, 3.9340E+04, 3.9513E+04, 3.9687E+04, 3.9861E+04, 4.0036E+04, 4.0211E+04, 4.0387E+04, &
       4.0564E+04, 4.0741E+04, 4.0919E+04, 4.1098E+04, 4.1277E+04, 4.1457E+04, 4.1637E+04, 4.1818E+04, 4.2000E+04, 4.2182E+04, &
       4.2365E+04, 4.2549E+04, 4.2733E+04, 4.2918E+04, 4.3104E+04, 4.3290E+04, 4.3477E+04, 4.3664E+04, 4.3853E+04, 4.4042E+04, &
       4.4231E+04, 4.4421E+04, 4.4612E+04, 4.4804E+04, 4.4996E+04, 4.5189E+04, 4.5382E+04, 4.5577E+04, 4.5772E+04, 4.5967E+04, &
       4.6163E+04, 4.6360E+04, 4.6558E+04, 4.6756E+04, 4.6955E+04, 4.7155E+04, 4.7355E+04, 4.7556E+04, 4.7758E+04, 4.7961E+04, &
       4.8164E+04, 4.8368E+04, 4.8572E+04, 4.8778E+04, 4.8983E+04, 4.9190E+04, 4.9398E+04, 4.9606E+04, 4.9814E+04, 5.0024E+04, &
       5.0234E+04, 5.0445E+04, 5.0657E+04, 5.0869E+04, 5.1082E+04, 5.1296E+04, 5.1511E+04, 5.1726E+04, 5.1942E+04, 5.2159E+04, &
       5.2376E+04, 5.2595E+04, 5.2814E+04, 5.3033E+04, 5.3254E+04, 5.3475E+04, 5.3697E+04, 5.3920E+04, 5.4143E+04, 5.4367E+04, &
       5.4592E+04, 5.4818E+04, 5.5045E+04, 5.5272E+04, 5.5500E+04, 5.5729E+04, 5.5958E+04, 5.6188E+04, 5.6419E+04, 5.6651E+04, &
       5.6884E+04, 5.7117E+04, 5.7351E+04, 5.7586E+04, 5.7822E+04, 5.8058E+04, 5.8296E+04, 5.8534E+04, 5.8773E+04, 5.9012E+04, &
       5.9253E+04, 5.9494E+04, 5.9736E+04, 5.9979E+04, 6.0222E+04, 6.0467E+04, 6.0712E+04, 6.0958E+04, 6.1205E+04, 6.1453E+04, &
       6.1701E+04, 6.1950E+04, 6.2201E+04, 6.2452E+04, 6.2703E+04, 6.2956E+04, 6.3209E+04, 6.3463E+04, 6.3718E+04, 6.3974E+04, &
       6.4231E+04, 6.4489E+04, 6.4747E+04, 6.5006E+04, 6.5266E+04, 6.5527E+04, 6.5789E+04, 6.6051E+04, 6.6315E+04, 6.6579E+04, &
       6.6844E+04, 6.7110E+04, 6.7377E+04, 6.7645E+04, 6.7914E+04, 6.8183E+04, 6.8453E+04, 6.8724E+04, 6.8996E+04, 6.9269E+04, &
       6.9543E+04, 6.9818E+04, 7.0093E+04, 7.0370E+04, 7.0647E+04, 7.0925E+04, 7.1204E+04, 7.1484E+04, 7.1765E+04, 7.2047E+04, &
       7.2330E+04, 7.2613E+04, 7.2898E+04, 7.3183E+04, 7.3469E+04, 7.3756E+04, 7.4044E+04, 7.4333E+04, 7.4623E+04, 7.4914E+04, &
       7.5206E+04, 7.5498E+04, 7.5792E+04, 7.6086E+04, 7.6382E+04, 7.6678E+04, 7.6975E+04, 7.7273E+04, 7.7573E+04, 7.7873E+04, &
       7.8174E+04, 7.8476E+04, 7.8778E+04, 7.9082E+04, 7.9387E+04, 7.9693E+04, 7.9999E+04, 8.0307E+04, 8.0616E+04, 8.0925E+04, &
       8.1236E+04, 8.1547E+04, 8.1859E+04, 8.2173E+04, 8.2487E+04, 8.2802E+04, 8.3119E+04, 8.3436E+04, 8.3754E+04, 8.4073E+04, &
       8.4394E+04, 8.4715E+04, 8.5037E+04, 8.5360E+04, 8.5684E+04, 8.6009E+04, 8.6336E+04, 8.6663E+04, 8.6991E+04, 8.7320E+04, &
       8.7650E+04, 8.7981E+04, 8.8313E+04, 8.8647E+04, 8.8981E+04, 8.9316E+04, 8.9652E+04, 8.9989E+04, 9.0328E+04, 9.0667E+04, &
       9.1007E+04, 9.1349E+04, 9.1691E+04, 9.2034E+04, 9.2379E+04, 9.2724E+04, 9.3071E+04, 9.3418E+04, 9.3767E+04, 9.4117E+04, &
       9.4467E+04, 9.4819E+04, 9.5172E+04, 9.5526E+04, 9.5881E+04, 9.6237E+04, 9.6594E+04, 9.6952E+04, 9.7311E+04, 9.7671E+04, &
       9.8033E+04, 9.8395E+04, 9.8758E+04, 9.9123E+04, 9.9489E+04, 9.9855E+04, 1.0022E+05, 1.0059E+05, 1.0096E+05, 1.0133E+05, &
       1.0171E+05, 1.0208E+05, 1.0245E+05, 1.0283E+05, 1.0321E+05, 1.0358E+05, 1.0396E+05, 1.0434E+05, 1.0472E+05, 1.0510E+05, &
       1.0549E+05, 1.0587E+05, 1.0626E+05, 1.0664E+05, 1.0703E+05, 1.0742E+05, 1.0781E+05, 1.0820E+05, 1.0859E+05, 1.0899E+05, &
       1.0938E+05, 1.0978E+05, 1.1018E+05, 1.1057E+05, 1.1097E+05, 1.1137E+05, 1.1177E+05, 1.1218E+05, 1.1258E+05, 1.1299E+05, &
       1.1339E+05, 1.1380E+05, 1.1421E+05, 1.1462E+05, 1.1503E+05, 1.1544E+05, 1.1585E+05, 1.1627E+05, 1.1668E+05, 1.1710E+05, &
       1.1752E+05, 1.1794E+05, 1.1836E+05, 1.1878E+05, 1.1920E+05, 1.1963E+05, 1.2005E+05, 1.2048E+05, 1.2091E+05, 1.2134E+05, &
       1.2177E+05, 1.2220E+05, 1.2263E+05, 1.2306E+05, 1.2350E+05, 1.2393E+05, 1.2437E+05, 1.2481E+05, 1.2525E+05, 1.2569E+05, &
       1.2613E+05, 1.2658E+05, 1.2702E+05, 1.2747E+05, 1.2792E+05, 1.2836E+05, 1.2881E+05, 1.2927E+05, 1.2972E+05, 1.3017E+05, &
       1.3063E+05, 1.3108E+05, 1.3154E+05, 1.3200E+05, 1.3246E+05, 1.3292E+05, 1.3338E+05, 1.3385E+05, 1.3431E+05, 1.3478E+05, &
       1.3525E+05, 1.3572E+05, 1.3619E+05, 1.3666E+05, 1.3713E+05, 1.3760E+05, 1.3808E+05, 1.3856E+05, 1.3904E+05, 1.3951E+05, &
       1.4000E+05, 1.4048E+05, 1.4096E+05, 1.4145E+05, 1.4193E+05, 1.4242E+05, 1.4291E+05, 1.4340E+05, 1.4389E+05, 1.4438E+05, &
       1.4488E+05, 1.4537E+05, 1.4587E+05, 1.4637E+05, 1.4687E+05, 1.4737E+05, 1.4787E+05, 1.4837E+05, 1.4888E+05, 1.4938E+05, &
       1.4989E+05, 1.5040E+05, 1.5091E+05, 1.5142E+05, 1.5194E+05, 1.5245E+05, 1.5297E+05, 1.5349E+05, 1.5400E+05, 1.5452E+05, &
       1.5505E+05, 1.5557E+05, 1.5609E+05, 1.5662E+05, 1.5715E+05, 1.5767E+05, 1.5820E+05, 1.5874E+05, 1.5927E+05, 1.5980E+05, &
       1.6034E+05, 1.6088E+05, 1.6141E+05, 1.6195E+05, 1.6250E+05, 1.6304E+05, 1.6358E+05, 1.6413E+05, 1.6468E+05, 1.6522E+05, &
       1.6577E+05, 1.6633E+05, 1.6688E+05, 1.6743E+05, 1.6799E+05, 1.6855E+05, 1.6910E+05, 1.6967E+05, 1.7023E+05, 1.7079E+05, &
       1.7135E+05, 1.7192E+05, 1.7249E+05, 1.7306E+05, 1.7363E+05, 1.7420E+05, 1.7477E+05, 1.7535E+05, 1.7593E+05, 1.7650E+05, &
       1.7708E+05, 1.7766E+05, 1.7825E+05, 1.7883E+05, 1.7942E+05, 1.8000E+05, 1.8059E+05, 1.8118E+05, 1.8177E+05, 1.8237E+05, &
       1.8296E+05, 1.8356E+05, 1.8416E+05, 1.8475E+05, 1.8536E+05, 1.8596E+05, 1.8656E+05, 1.8717E+05, 1.8777E+05, 1.8838E+05, &
       1.8899E+05, 1.8960E+05, 1.9022E+05, 1.9083E+05, 1.9145E+05, 1.9207E+05, 1.9269E+05, 1.9331E+05, 1.9393E+05, 1.9455E+05, &
       1.9518E+05, 1.9581E+05, 1.9644E+05, 1.9707E+05, 1.9770E+05, 1.9833E+05, 1.9897E+05, 1.9961E+05, 2.0024E+05, 2.0088E+05, &
       2.0153E+05, 2.0217E+05, 2.0281E+05, 2.0346E+05, 2.0411E+05, 2.0476E+05, 2.0541E+05, 2.0606E+05, 2.0672E+05, 2.0738E+05, &
       2.0803E+05, 2.0869E+05, 2.0935E+05, 2.1002E+05, 2.1068E+05, 2.1135E+05, 2.1202E+05, 2.1269E+05, 2.1336E+05, 2.1403E+05, &
       2.1470E+05, 2.1538E+05, 2.1606E+05, 2.1674E+05, 2.1742E+05, 2.1810E+05, 2.1879E+05, 2.1947E+05, 2.2016E+05, 2.2085E+05, &
       2.2154E+05, 2.2223E+05, 2.2293E+05, 2.2362E+05, 2.2432E+05, 2.2502E+05, 2.2572E+05, 2.2643E+05, 2.2713E+05, 2.2784E+05, &
       2.2855E+05, 2.2926E+05, 2.2997E+05, 2.3068E+05, 2.3140E+05, 2.3211E+05, 2.3283E+05, 2.3355E+05, 2.3428E+05, 2.3500E+05, &
       2.3573E+05, 2.3645E+05, 2.3718E+05, 2.3791E+05, 2.3865E+05, 2.3938E+05, 2.4012E+05, 2.4085E+05, 2.4159E+05, 2.4234E+05, &
       2.4308E+05, 2.4382E+05, 2.4457E+05, 2.4532E+05, 2.4607E+05, 2.4682E+05, 2.4758E+05, 2.4833E+05, 2.4909E+05, 2.4985E+05, &
       2.5061E+05, 2.5137E+05, 2.5214E+05, 2.5290E+05, 2.5367E+05, 2.5444E+05, 2.5521E+05, 2.5599E+05, 2.5676E+05, 2.5754E+05, &
       2.5832E+05, 2.5910E+05, 2.5988E+05, 2.6067E+05, 2.6146E+05, 2.6224E+05, 2.6303E+05, 2.6383E+05, 2.6462E+05, 2.6542E+05, &
       2.6621E+05, 2.6701E+05, 2.6781E+05, 2.6862E+05, 2.6942E+05, 2.7023E+05, 2.7104E+05, 2.7185E+05, 2.7266E+05, 2.7348E+05, &
       2.7429E+05, 2.7511E+05, 2.7593E+05, 2.7675E+05, 2.7758E+05, 2.7840E+05, 2.7923E+05, 2.8006E+05, 2.8089E+05, 2.8172E+05, &
       2.8256E+05, 2.8340E+05, 2.8424E+05, 2.8508E+05, 2.8592E+05, 2.8677E+05, 2.8761E+05, 2.8846E+05, 2.8931E+05, 2.9016E+05, &
       2.9102E+05, 2.9187E+05, 2.9273E+05, 2.9359E+05, 2.9446E+05, 2.9532E+05, 2.9619E+05, 2.9705E+05, 2.9792E+05, 2.9880E+05, &
       2.9967E+05, 3.0055E+05, 3.0142E+05, 3.0230E+05, 3.0319E+05, 3.0407E+05, 3.0496E+05, 3.0584E+05, 3.0673E+05, 3.0763E+05, &
       3.0852E+05, 3.0942E+05, 3.1031E+05, 3.1121E+05, 3.1211E+05, 3.1302E+05, 3.1392E+05, 3.1483E+05, 3.1574E+05, 3.1665E+05, &
       3.1757E+05, 3.1848E+05, 3.1940E+05, 3.2032E+05, 3.2124E+05, 3.2217E+05, 3.2309E+05, 3.2402E+05, 3.2495E+05, 3.2588E+05, &
       3.2682E+05, 3.2775E+05, 3.2869E+05, 3.2963E+05, 3.3057E+05, 3.3152E+05, 3.3246E+05, 3.3341E+05, 3.3436E+05, 3.3532E+05, &
       3.3627E+05, 3.3723E+05, 3.3819E+05, 3.3915E+05, 3.4011E+05, 3.4108E+05, 3.4204E+05, 3.4301E+05, 3.4398E+05, 3.4496E+05, &
       3.4593E+05, 3.4691E+05, 3.4789E+05, 3.4887E+05, 3.4986E+05, 3.5084E+05, 3.5183E+05, 3.5282E+05, 3.5381E+05, 3.5481E+05, &
       3.5580E+05, 3.5680E+05, 3.5780E+05, 3.5881E+05, 3.5981E+05, 3.6082E+05, 3.6183E+05, 3.6284E+05, 3.6385E+05, 3.6487E+05, &
       3.6589E+05, 3.6691E+05, 3.6793E+05, 3.6896E+05, 3.6998E+05, 3.7101E+05, 3.7204E+05, 3.7308E+05, 3.7411E+05, 3.7515E+05, &
       3.7619E+05, 3.7723E+05, 3.7827E+05, 3.7932E+05, 3.8037E+05, 3.8142E+05, 3.8247E+05, 3.8353E+05, 3.8458E+05, 3.8564E+05, &
       3.8670E+05, 3.8777E+05, 3.8883E+05, 3.8990E+05, 3.9097E+05, 3.9205E+05, 3.9312E+05, 3.9420E+05, 3.9528E+05, 3.9636E+05, &
       3.9744E+05, 3.9853E+05, 3.9962E+05, 4.0071E+05, 4.0180E+05, 4.0289E+05, 4.0399E+05, 4.0509E+05, 4.0619E+05, 4.0730E+05, &
       4.0840E+05, 4.0951E+05, 4.1062E+05, 4.1173E+05, 4.1285E+05, 4.1397E+05, 4.1509E+05, 4.1621E+05, 4.1733E+05, 4.1846E+05, &
       4.1959E+05, 4.2072E+05, 4.2185E+05, 4.2299E+05, 4.2413E+05, 4.2527E+05, 4.2641E+05, 4.2756E+05, 4.2870E+05, 4.2985E+05, &
       4.3100E+05, 4.3216E+05, 4.3331E+05, 4.3447E+05, 4.3563E+05, 4.3680E+05, 4.3796E+05, 4.3913E+05, 4.4030E+05, 4.4147E+05, &
       4.4265E+05, 4.4383E+05, 4.4501E+05, 4.4619E+05, 4.4737E+05, 4.4856E+05, 4.4975E+05, 4.5094E+05, 4.5213E+05, 4.5333E+05, &
       4.5453E+05, 4.5573E+05, 4.5693E+05, 4.5814E+05, 4.5934E+05, 4.6055E+05, 4.6177E+05, 4.6298E+05, 4.6420E+05, 4.6542E+05, &
       4.6664E+05, 4.6787E+05, 4.6909E+05, 4.7032E+05, 4.7155E+05, 4.7279E+05, 4.7402E+05, 4.7526E+05, 4.7650E+05, 4.7775E+05, &
       4.7899E+05, 4.8024E+05, 4.8149E+05, 4.8275E+05, 4.8400E+05, 4.8526E+05, 4.8652E+05, 4.8778E+05, 4.8905E+05, 4.9032E+05, &
       4.9159E+05, 4.9286E+05, 4.9413E+05, 4.9541E+05, 4.9669E+05, 4.9797E+05, 4.9926E+05, 5.0055E+05, 5.0184E+05, 5.0313E+05, &
       5.0442E+05, 5.0572E+05, 5.0702E+05, 5.0832E+05, 5.0963E+05, 5.1093E+05, 5.1224E+05, 5.1356E+05, 5.1487E+05, 5.1619E+05, &
       5.1751E+05, 5.1883E+05, 5.2015E+05, 5.2148E+05, 5.2281E+05, 5.2414E+05, 5.2547E+05, 5.2681E+05, 5.2815E+05, 5.2949E+05, &
       5.3084E+05, 5.3218E+05, 5.3353E+05, 5.3488E+05, 5.3624E+05, 5.3759E+05, 5.3895E+05, 5.4032E+05, 5.4168E+05, 5.4305E+05, &
       5.4442E+05, 5.4579E+05, 5.4716E+05, 5.4854E+05, 5.4992E+05, 5.5130E+05, 5.5269E+05, 5.5407E+05, 5.5546E+05, 5.5685E+05, &
       5.5825E+05, 5.5965E+05, 5.6105E+05, 5.6245E+05, 5.6385E+05, 5.6526E+05, 5.6667E+05, 5.6808E+05, 5.6950E+05, 5.7092E+05, &
       5.7234E+05, 5.7376E+05, 5.7519E+05, 5.7661E+05, 5.7804E+05, 5.7948E+05, 5.8091E+05, 5.8235E+05, 5.8379E+05, 5.8524E+05, &
       5.8668E+05, 5.8813E+05, 5.8958E+05, 5.9104E+05, 5.9249E+05, 5.9395E+05, 5.9541E+05, 5.9688E+05, 5.9835E+05, 5.9982E+05, &
       6.0129E+05, 6.0276E+05, 6.0424E+05, 6.0572E+05, 6.0720E+05, 6.0869E+05, 6.1018E+05, 6.1167E+05, 6.1316E+05, 6.1466E+05, &
       6.1615E+05, 6.1766E+05, 6.1916E+05, 6.2067E+05, 6.2217E+05, 6.2369E+05, 6.2520E+05, 6.2672E+05, 6.2824E+05, 6.2976E+05, &
       6.3128E+05, 6.3281E+05, 6.3434E+05, 6.3588E+05, 6.3741E+05, 6.3895E+05, 6.4049E+05, 6.4203E+05, 6.4358E+05, 6.4513E+05, &
       6.4668E+05, 6.4824E+05, 6.4979E+05, 6.5135E+05, 6.5292E+05, 6.5448E+05, 6.5605E+05, 6.5762E+05, 6.5919E+05, 6.6077E+05, &
       6.6235E+05, 6.6393E+05, 6.6551E+05, 6.6710E+05, 6.6869E+05, 6.7028E+05, 6.7188E+05, 6.7347E+05, 6.7507E+05, 6.7668E+05, &
       6.7828E+05, 6.7989E+05, 6.8150E+05, 6.8312E+05, 6.8473E+05, 6.8635E+05, 6.8797E+05, 6.8960E+05, 6.9123E+05, 6.9286E+05, &
       6.9449E+05, 6.9613E+05, 6.9777E+05, 6.9941E+05, 7.0105E+05, 7.0270E+05, 7.0435E+05, 7.0600E+05, 7.0765E+05, 7.0931E+05, &
       7.1097E+05, 7.1264E+05, 7.1430E+05, 7.1597E+05, 7.1764E+05, 7.1932E+05, 7.2100E+05, 7.2268E+05, 7.2436E+05, 7.2604E+05, &
       7.2773E+05, 7.2942E+05, 7.3112E+05, 7.3281E+05, 7.3451E+05, 7.3622E+05, 7.3792E+05, 7.3963E+05, 7.4134E+05, 7.4305E+05, &
       7.4477E+05, 7.4649E+05, 7.4821E+05, 7.4994E+05, 7.5166E+05, 7.5339E+05, 7.5513E+05, 7.5686E+05, 7.5860E+05, 7.6034E+05, &
       7.6209E+05, 7.6384E+05, 7.6559E+05, 7.6734E+05, 7.6910E+05, 7.7085E+05, 7.7262E+05, 7.7438E+05, 7.7615E+05, 7.7792E+05, &
       7.7969E+05, 7.8147E+05, 7.8324E+05, 7.8502E+05, 7.8681E+05, 7.8860E+05, 7.9039E+05, 7.9218E+05, 7.9397E+05, 7.9577E+05, &
       7.9757E+05, 7.9938E+05, 8.0119E+05, 8.0300E+05, 8.0481E+05, 8.0662E+05, 8.0844E+05, 8.1026E+05, 8.1209E+05, 8.1392E+05, &
       8.1575E+05, 8.1758E+05, 8.1941E+05, 8.2125E+05, 8.2309E+05, 8.2494E+05, 8.2679E+05, 8.2864E+05, 8.3049E+05, 8.3235E+05, &
       8.3420E+05, 8.3607E+05, 8.3793E+05, 8.3980E+05, 8.4167E+05, 8.4354E+05, 8.4542E+05, 8.4730E+05, 8.4918E+05, 8.5107E+05, &
       8.5295E+05, 8.5484E+05, 8.5674E+05, 8.5863E+05, 8.6053E+05, 8.6244E+05, 8.6434E+05, 8.6625E+05, 8.6816E+05, 8.7008E+05, &
       8.7199E+05, 8.7391E+05, 8.7584E+05, 8.7776E+05, 8.7969E+05, 8.8162E+05, 8.8356E+05, 8.8550E+05, 8.8744E+05, 8.8938E+05, &
       8.9133E+05, 8.9328E+05, 8.9523E+05, 8.9718E+05, 8.9914E+05, 9.0110E+05, 9.0307E+05, 9.0504E+05, 9.0701E+05, 9.0898E+05, &
       9.1096E+05, 9.1293E+05, 9.1492E+05, 9.1690E+05, 9.1889E+05, 9.2088E+05, 9.2287E+05, 9.2487E+05, 9.2687E+05, 9.2887E+05, &
       9.3088E+05, 9.3289E+05, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
      data (QofT( 5,J),J=2409,4510)/ 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       637
      data (QofT( 6,J),J=1,2408)/ 2.6516E+01, 4.8285E+01, 7.0234E+01, 9.2224E+01, 1.1423E+02, 1.3624E+02, 1.5826E+02, 1.8028E+02, &
       2.0230E+02, 2.2433E+02, 2.4635E+02, 2.6838E+02, 2.9040E+02, 3.1243E+02, 3.3446E+02, 3.5648E+02, 3.7851E+02, 4.0054E+02, &
       4.2256E+02, 4.4459E+02, 4.8865E+02, 5.3271E+02, 5.7676E+02, 6.2082E+02, 6.6488E+02, 7.0894E+02, 7.5300E+02, 7.9705E+02, &
       8.4111E+02, 8.8517E+02, 9.2923E+02, 9.7329E+02, 1.0174E+03, 1.0614E+03, 1.1055E+03, 1.1495E+03, 1.1936E+03, 1.2377E+03, &
       1.2817E+03, 1.3258E+03, 1.3698E+03, 1.4139E+03, 1.4580E+03, 1.5020E+03, 1.5461E+03, 1.5902E+03, 1.6342E+03, 1.6783E+03, &
       1.7224E+03, 1.7664E+03, 1.8105E+03, 1.8546E+03, 1.8987E+03, 1.9428E+03, 1.9869E+03, 2.0310E+03, 2.0751E+03, 2.1192E+03, &
       2.1633E+03, 2.2075E+03, 2.2516E+03, 2.2958E+03, 2.3400E+03, 2.3842E+03, 2.4284E+03, 2.4727E+03, 2.5170E+03, 2.5613E+03, &
       2.6057E+03, 2.6500E+03, 2.6945E+03, 2.7389E+03, 2.7834E+03, 2.8280E+03, 2.8726E+03, 2.9173E+03, 2.9620E+03, 3.0068E+03, &
       3.0516E+03, 3.0965E+03, 3.1415E+03, 3.1866E+03, 3.2317E+03, 3.2770E+03, 3.3223E+03, 3.3677E+03, 3.4132E+03, 3.4588E+03, &
       3.5046E+03, 3.5504E+03, 3.5963E+03, 3.6424E+03, 3.6886E+03, 3.7349E+03, 3.7814E+03, 3.8279E+03, 3.8747E+03, 3.9215E+03, &
       3.9685E+03, 4.0157E+03, 4.0630E+03, 4.1105E+03, 4.1581E+03, 4.2060E+03, 4.2539E+03, 4.3021E+03, 4.3504E+03, 4.3990E+03, &
       4.4477E+03, 4.4966E+03, 4.5457E+03, 4.5950E+03, 4.6445E+03, 4.6942E+03, 4.7442E+03, 4.7943E+03, 4.8447E+03, 4.8953E+03, &
       4.9461E+03, 4.9971E+03, 5.0484E+03, 5.0999E+03, 5.1517E+03, 5.2037E+03, 5.2559E+03, 5.3084E+03, 5.3612E+03, 5.4142E+03, &
       5.4675E+03, 5.5210E+03, 5.5749E+03, 5.6290E+03, 5.6833E+03, 5.7380E+03, 5.7929E+03, 5.8481E+03, 5.9036E+03, 5.9594E+03, &
       6.0155E+03, 6.0719E+03, 6.1285E+03, 6.1855E+03, 6.2428E+03, 6.3005E+03, 6.3584E+03, 6.4166E+03, 6.4752E+03, 6.5341E+03, &
       6.5933E+03, 6.6528E+03, 6.7127E+03, 6.7729E+03, 6.8334E+03, 6.8943E+03, 6.9555E+03, 7.0171E+03, 7.0790E+03, 7.1413E+03, &
       7.2040E+03, 7.2669E+03, 7.3303E+03, 7.3940E+03, 7.4581E+03, 7.5225E+03, 7.5874E+03, 7.6526E+03, 7.7181E+03, 7.7841E+03, &
       7.8504E+03, 7.9171E+03, 7.9843E+03, 8.0518E+03, 8.1197E+03, 8.1880E+03, 8.2566E+03, 8.3257E+03, 8.3952E+03, 8.4652E+03, &
       8.5355E+03, 8.6062E+03, 8.6774E+03, 8.7489E+03, 8.8209E+03, 8.8933E+03, 8.9662E+03, 9.0395E+03, 9.1132E+03, 9.1873E+03, &
       9.2619E+03, 9.3369E+03, 9.4124E+03, 9.4883E+03, 9.5646E+03, 9.6414E+03, 9.7187E+03, 9.7964E+03, 9.8746E+03, 9.9532E+03, &
       1.0032E+04, 1.0112E+04, 1.0192E+04, 1.0272E+04, 1.0353E+04, 1.0435E+04, 1.0517E+04, 1.0599E+04, 1.0682E+04, 1.0766E+04, &
       1.0849E+04, 1.0934E+04, 1.1019E+04, 1.1104E+04, 1.1190E+04, 1.1276E+04, 1.1363E+04, 1.1451E+04, 1.1539E+04, 1.1627E+04, &
       1.1716E+04, 1.1806E+04, 1.1896E+04, 1.1986E+04, 1.2077E+04, 1.2169E+04, 1.2261E+04, 1.2354E+04, 1.2447E+04, 1.2541E+04, &
       1.2635E+04, 1.2730E+04, 1.2825E+04, 1.2921E+04, 1.3018E+04, 1.3115E+04, 1.3212E+04, 1.3311E+04, 1.3410E+04, 1.3509E+04, &
       1.3609E+04, 1.3709E+04, 1.3810E+04, 1.3912E+04, 1.4014E+04, 1.4117E+04, 1.4221E+04, 1.4325E+04, 1.4429E+04, 1.4535E+04, &
       1.4641E+04, 1.4747E+04, 1.4854E+04, 1.4962E+04, 1.5070E+04, 1.5179E+04, 1.5289E+04, 1.5399E+04, 1.5510E+04, 1.5621E+04, &
       1.5733E+04, 1.5846E+04, 1.5959E+04, 1.6073E+04, 1.6188E+04, 1.6303E+04, 1.6419E+04, 1.6536E+04, 1.6653E+04, 1.6771E+04, &
       1.6889E+04, 1.7009E+04, 1.7129E+04, 1.7249E+04, 1.7370E+04, 1.7492E+04, 1.7615E+04, 1.7738E+04, 1.7862E+04, 1.7987E+04, &
       1.8113E+04, 1.8239E+04, 1.8366E+04, 1.8493E+04, 1.8621E+04, 1.8750E+04, 1.8880E+04, 1.9010E+04, 1.9141E+04, 1.9273E+04, &
       1.9406E+04, 1.9539E+04, 1.9673E+04, 1.9808E+04, 1.9944E+04, 2.0080E+04, 2.0217E+04, 2.0355E+04, 2.0493E+04, 2.0632E+04, &
       2.0772E+04, 2.0913E+04, 2.1055E+04, 2.1197E+04, 2.1340E+04, 2.1484E+04, 2.1629E+04, 2.1775E+04, 2.1921E+04, 2.2068E+04, &
       2.2216E+04, 2.2364E+04, 2.2514E+04, 2.2664E+04, 2.2815E+04, 2.2967E+04, 2.3120E+04, 2.3274E+04, 2.3428E+04, 2.3583E+04, &
       2.3739E+04, 2.3896E+04, 2.4054E+04, 2.4212E+04, 2.4372E+04, 2.4532E+04, 2.4693E+04, 2.4855E+04, 2.5018E+04, 2.5182E+04, &
       2.5346E+04, 2.5512E+04, 2.5678E+04, 2.5845E+04, 2.6013E+04, 2.6182E+04, 2.6352E+04, 2.6523E+04, 2.6695E+04, 2.6867E+04, &
       2.7041E+04, 2.7215E+04, 2.7390E+04, 2.7567E+04, 2.7744E+04, 2.7922E+04, 2.8101E+04, 2.8281E+04, 2.8462E+04, 2.8644E+04, &
       2.8826E+04, 2.9010E+04, 2.9195E+04, 2.9380E+04, 2.9567E+04, 2.9754E+04, 2.9943E+04, 3.0132E+04, 3.0323E+04, 3.0514E+04, &
       3.0707E+04, 3.0900E+04, 3.1095E+04, 3.1290E+04, 3.1487E+04, 3.1684E+04, 3.1882E+04, 3.2082E+04, 3.2282E+04, 3.2484E+04, &
       3.2686E+04, 3.2890E+04, 3.3095E+04, 3.3300E+04, 3.3507E+04, 3.3715E+04, 3.3923E+04, 3.4133E+04, 3.4344E+04, 3.4556E+04, &
       3.4769E+04, 3.4983E+04, 3.5198E+04, 3.5415E+04, 3.5632E+04, 3.5850E+04, 3.6070E+04, 3.6291E+04, 3.6512E+04, 3.6735E+04, &
       3.6959E+04, 3.7184E+04, 3.7410E+04, 3.7638E+04, 3.7866E+04, 3.8096E+04, 3.8326E+04, 3.8558E+04, 3.8791E+04, 3.9025E+04, &
       3.9261E+04, 3.9497E+04, 3.9735E+04, 3.9974E+04, 4.0214E+04, 4.0455E+04, 4.0697E+04, 4.0941E+04, 4.1185E+04, 4.1431E+04, &
       4.1678E+04, 4.1927E+04, 4.2176E+04, 4.2427E+04, 4.2679E+04, 4.2932E+04, 4.3187E+04, 4.3442E+04, 4.3699E+04, 4.3957E+04, &
       4.4217E+04, 4.4477E+04, 4.4739E+04, 4.5002E+04, 4.5267E+04, 4.5533E+04, 4.5800E+04, 4.6068E+04, 4.6337E+04, 4.6608E+04, &
       4.6880E+04, 4.7154E+04, 4.7429E+04, 4.7705E+04, 4.7982E+04, 4.8261E+04, 4.8541E+04, 4.8822E+04, 4.9105E+04, 4.9389E+04, &
       4.9674E+04, 4.9961E+04, 5.0249E+04, 5.0539E+04, 5.0829E+04, 5.1122E+04, 5.1415E+04, 5.1710E+04, 5.2007E+04, 5.2304E+04, &
       5.2603E+04, 5.2904E+04, 5.3206E+04, 5.3509E+04, 5.3814E+04, 5.4120E+04, 5.4428E+04, 5.4737E+04, 5.5047E+04, 5.5359E+04, &
       5.5673E+04, 5.5987E+04, 5.6304E+04, 5.6622E+04, 5.6941E+04, 5.7261E+04, 5.7584E+04, 5.7907E+04, 5.8233E+04, 5.8559E+04, &
       5.8887E+04, 5.9217E+04, 5.9548E+04, 5.9881E+04, 6.0215E+04, 6.0551E+04, 6.0888E+04, 6.1227E+04, 6.1567E+04, 6.1909E+04, &
       6.2253E+04, 6.2598E+04, 6.2944E+04, 6.3293E+04, 6.3642E+04, 6.3994E+04, 6.4347E+04, 6.4701E+04, 6.5057E+04, 6.5415E+04, &
       6.5774E+04, 6.6135E+04, 6.6498E+04, 6.6862E+04, 6.7228E+04, 6.7596E+04, 6.7965E+04, 6.8336E+04, 6.8708E+04, 6.9082E+04, &
       6.9458E+04, 6.9835E+04, 7.0215E+04, 7.0595E+04, 7.0978E+04, 7.1362E+04, 7.1748E+04, 7.2136E+04, 7.2525E+04, 7.2916E+04, &
       7.3309E+04, 7.3704E+04, 7.4100E+04, 7.4498E+04, 7.4898E+04, 7.5299E+04, 7.5703E+04, 7.6108E+04, 7.6515E+04, 7.6923E+04, &
       7.7334E+04, 7.7746E+04, 7.8160E+04, 7.8576E+04, 7.8993E+04, 7.9413E+04, 7.9834E+04, 8.0257E+04, 8.0682E+04, 8.1109E+04, &
       8.1538E+04, 8.1968E+04, 8.2401E+04, 8.2835E+04, 8.3271E+04, 8.3709E+04, 8.4149E+04, 8.4591E+04, 8.5034E+04, 8.5480E+04, &
       8.5928E+04, 8.6377E+04, 8.6828E+04, 8.7282E+04, 8.7737E+04, 8.8194E+04, 8.8653E+04, 8.9114E+04, 8.9577E+04, 9.0042E+04, &
       9.0509E+04, 9.0978E+04, 9.1449E+04, 9.1922E+04, 9.2397E+04, 9.2874E+04, 9.3353E+04, 9.3834E+04, 9.4317E+04, 9.4802E+04, &
       9.5289E+04, 9.5779E+04, 9.6270E+04, 9.6763E+04, 9.7259E+04, 9.7756E+04, 9.8256E+04, 9.8757E+04, 9.9261E+04, 9.9767E+04, &
       1.0027E+05, 1.0078E+05, 1.0130E+05, 1.0181E+05, 1.0233E+05, 1.0285E+05, 1.0337E+05, 1.0389E+05, 1.0442E+05, 1.0494E+05, &
       1.0547E+05, 1.0600E+05, 1.0654E+05, 1.0707E+05, 1.0761E+05, 1.0815E+05, 1.0869E+05, 1.0924E+05, 1.0979E+05, 1.1034E+05, &
       1.1089E+05, 1.1144E+05, 1.1200E+05, 1.1256E+05, 1.1312E+05, 1.1368E+05, 1.1424E+05, 1.1481E+05, 1.1538E+05, 1.1595E+05, &
       1.1653E+05, 1.1711E+05, 1.1768E+05, 1.1827E+05, 1.1885E+05, 1.1944E+05, 1.2003E+05, 1.2062E+05, 1.2121E+05, 1.2181E+05, &
       1.2240E+05, 1.2300E+05, 1.2361E+05, 1.2421E+05, 1.2482E+05, 1.2543E+05, 1.2604E+05, 1.2666E+05, 1.2728E+05, 1.2790E+05, &
       1.2852E+05, 1.2914E+05, 1.2977E+05, 1.3040E+05, 1.3103E+05, 1.3167E+05, 1.3231E+05, 1.3295E+05, 1.3359E+05, 1.3423E+05, &
       1.3488E+05, 1.3553E+05, 1.3618E+05, 1.3684E+05, 1.3750E+05, 1.3816E+05, 1.3882E+05, 1.3949E+05, 1.4015E+05, 1.4083E+05, &
       1.4150E+05, 1.4217E+05, 1.4285E+05, 1.4354E+05, 1.4422E+05, 1.4491E+05, 1.4560E+05, 1.4629E+05, 1.4698E+05, 1.4768E+05, &
       1.4838E+05, 1.4908E+05, 1.4979E+05, 1.5050E+05, 1.5121E+05, 1.5192E+05, 1.5264E+05, 1.5336E+05, 1.5408E+05, 1.5481E+05, &
       1.5553E+05, 1.5626E+05, 1.5700E+05, 1.5773E+05, 1.5847E+05, 1.5921E+05, 1.5996E+05, 1.6071E+05, 1.6146E+05, 1.6221E+05, &
       1.6297E+05, 1.6372E+05, 1.6449E+05, 1.6525E+05, 1.6602E+05, 1.6679E+05, 1.6756E+05, 1.6834E+05, 1.6912E+05, 1.6990E+05, &
       1.7069E+05, 1.7147E+05, 1.7226E+05, 1.7306E+05, 1.7386E+05, 1.7466E+05, 1.7546E+05, 1.7627E+05, 1.7707E+05, 1.7789E+05, &
       1.7870E+05, 1.7952E+05, 1.8034E+05, 1.8117E+05, 1.8199E+05, 1.8282E+05, 1.8366E+05, 1.8449E+05, 1.8533E+05, 1.8618E+05, &
       1.8702E+05, 1.8787E+05, 1.8873E+05, 1.8958E+05, 1.9044E+05, 1.9130E+05, 1.9217E+05, 1.9303E+05, 1.9391E+05, 1.9478E+05, &
       1.9566E+05, 1.9654E+05, 1.9742E+05, 1.9831E+05, 1.9920E+05, 2.0010E+05, 2.0099E+05, 2.0190E+05, 2.0280E+05, 2.0371E+05, &
       2.0462E+05, 2.0553E+05, 2.0645E+05, 2.0737E+05, 2.0829E+05, 2.0922E+05, 2.1015E+05, 2.1108E+05, 2.1202E+05, 2.1296E+05, &
       2.1391E+05, 2.1485E+05, 2.1581E+05, 2.1676E+05, 2.1772E+05, 2.1868E+05, 2.1964E+05, 2.2061E+05, 2.2158E+05, 2.2256E+05, &
       2.2354E+05, 2.2452E+05, 2.2551E+05, 2.2650E+05, 2.2749E+05, 2.2849E+05, 2.2949E+05, 2.3049E+05, 2.3150E+05, 2.3251E+05, &
       2.3352E+05, 2.3454E+05, 2.3556E+05, 2.3659E+05, 2.3761E+05, 2.3865E+05, 2.3968E+05, 2.4072E+05, 2.4177E+05, 2.4281E+05, &
       2.4386E+05, 2.4492E+05, 2.4598E+05, 2.4704E+05, 2.4810E+05, 2.4917E+05, 2.5025E+05, 2.5132E+05, 2.5240E+05, 2.5349E+05, &
       2.5458E+05, 2.5567E+05, 2.5676E+05, 2.5786E+05, 2.5897E+05, 2.6007E+05, 2.6119E+05, 2.6230E+05, 2.6342E+05, 2.6454E+05, &
       2.6567E+05, 2.6680E+05, 2.6793E+05, 2.6907E+05, 2.7022E+05, 2.7136E+05, 2.7251E+05, 2.7367E+05, 2.7482E+05, 2.7599E+05, &
       2.7715E+05, 2.7832E+05, 2.7950E+05, 2.8068E+05, 2.8186E+05, 2.8304E+05, 2.8424E+05, 2.8543E+05, 2.8663E+05, 2.8783E+05, &
       2.8904E+05, 2.9025E+05, 2.9146E+05, 2.9268E+05, 2.9391E+05, 2.9513E+05, 2.9637E+05, 2.9760E+05, 2.9884E+05, 3.0009E+05, &
       3.0133E+05, 3.0259E+05, 3.0384E+05, 3.0510E+05, 3.0637E+05, 3.0764E+05, 3.0891E+05, 3.1019E+05, 3.1147E+05, 3.1276E+05, &
       3.1405E+05, 3.1535E+05, 3.1665E+05, 3.1795E+05, 3.1926E+05, 3.2057E+05, 3.2189E+05, 3.2321E+05, 3.2454E+05, 3.2587E+05, &
       3.2720E+05, 3.2854E+05, 3.2989E+05, 3.3123E+05, 3.3259E+05, 3.3394E+05, 3.3531E+05, 3.3667E+05, 3.3804E+05, 3.3942E+05, &
       3.4080E+05, 3.4218E+05, 3.4357E+05, 3.4496E+05, 3.4636E+05, 3.4777E+05, 3.4917E+05, 3.5058E+05, 3.5200E+05, 3.5342E+05, &
       3.5485E+05, 3.5628E+05, 3.5771E+05, 3.5915E+05, 3.6060E+05, 3.6205E+05, 3.6350E+05, 3.6496E+05, 3.6642E+05, 3.6789E+05, &
       3.6936E+05, 3.7084E+05, 3.7233E+05, 3.7381E+05, 3.7530E+05, 3.7680E+05, 3.7830E+05, 3.7981E+05, 3.8132E+05, 3.8284E+05, &
       3.8436E+05, 3.8589E+05, 3.8742E+05, 3.8895E+05, 3.9049E+05, 3.9204E+05, 3.9359E+05, 3.9515E+05, 3.9671E+05, 3.9827E+05, &
       3.9984E+05, 4.0142E+05, 4.0300E+05, 4.0459E+05, 4.0618E+05, 4.0777E+05, 4.0938E+05, 4.1098E+05, 4.1259E+05, 4.1421E+05, &
       4.1583E+05, 4.1746E+05, 4.1909E+05, 4.2073E+05, 4.2237E+05, 4.2402E+05, 4.2567E+05, 4.2733E+05, 4.2899E+05, 4.3066E+05, &
       4.3233E+05, 4.3401E+05, 4.3570E+05, 4.3738E+05, 4.3908E+05, 4.4078E+05, 4.4248E+05, 4.4420E+05, 4.4591E+05, 4.4763E+05, &
       4.4936E+05, 4.5109E+05, 4.5283E+05, 4.5457E+05, 4.5632E+05, 4.5807E+05, 4.5983E+05, 4.6160E+05, 4.6337E+05, 4.6514E+05, &
       4.6692E+05, 4.6871E+05, 4.7050E+05, 4.7230E+05, 4.7410E+05, 4.7591E+05, 4.7773E+05, 4.7955E+05, 4.8137E+05, 4.8320E+05, &
       4.8504E+05, 4.8688E+05, 4.8873E+05, 4.9059E+05, 4.9245E+05, 4.9431E+05, 4.9618E+05, 4.9806E+05, 4.9994E+05, 5.0183E+05, &
       5.0372E+05, 5.0562E+05, 5.0753E+05, 5.0944E+05, 5.1135E+05, 5.1328E+05, 5.1521E+05, 5.1714E+05, 5.1908E+05, 5.2103E+05, &
       5.2298E+05, 5.2494E+05, 5.2690E+05, 5.2887E+05, 5.3085E+05, 5.3283E+05, 5.3482E+05, 5.3681E+05, 5.3881E+05, 5.4081E+05, &
       5.4283E+05, 5.4484E+05, 5.4687E+05, 5.4890E+05, 5.5093E+05, 5.5297E+05, 5.5502E+05, 5.5708E+05, 5.5914E+05, 5.6120E+05, &
       5.6327E+05, 5.6535E+05, 5.6744E+05, 5.6953E+05, 5.7163E+05, 5.7373E+05, 5.7584E+05, 5.7796E+05, 5.8008E+05, 5.8221E+05, &
       5.8434E+05, 5.8648E+05, 5.8863E+05, 5.9078E+05, 5.9294E+05, 5.9511E+05, 5.9728E+05, 5.9946E+05, 6.0165E+05, 6.0384E+05, &
       6.0604E+05, 6.0824E+05, 6.1045E+05, 6.1267E+05, 6.1489E+05, 6.1712E+05, 6.1936E+05, 6.2161E+05, 6.2386E+05, 6.2611E+05, &
       6.2838E+05, 6.3064E+05, 6.3292E+05, 6.3520E+05, 6.3749E+05, 6.3979E+05, 6.4209E+05, 6.4440E+05, 6.4672E+05, 6.4904E+05, &
       6.5137E+05, 6.5371E+05, 6.5605E+05, 6.5840E+05, 6.6076E+05, 6.6312E+05, 6.6549E+05, 6.6787E+05, 6.7025E+05, 6.7264E+05, &
       6.7504E+05, 6.7744E+05, 6.7985E+05, 6.8227E+05, 6.8470E+05, 6.8713E+05, 6.8957E+05, 6.9201E+05, 6.9446E+05, 6.9692E+05, &
       6.9939E+05, 7.0186E+05, 7.0434E+05, 7.0683E+05, 7.0933E+05, 7.1183E+05, 7.1434E+05, 7.1685E+05, 7.1937E+05, 7.2190E+05, &
       7.2444E+05, 7.2699E+05, 7.2954E+05, 7.3209E+05, 7.3466E+05, 7.3723E+05, 7.3981E+05, 7.4240E+05, 7.4499E+05, 7.4760E+05, &
       7.5021E+05, 7.5282E+05, 7.5545E+05, 7.5808E+05, 7.6071E+05, 7.6336E+05, 7.6601E+05, 7.6867E+05, 7.7134E+05, 7.7402E+05, &
       7.7670E+05, 7.7939E+05, 7.8208E+05, 7.8479E+05, 7.8750E+05, 7.9022E+05, 7.9295E+05, 7.9568E+05, 7.9843E+05, 8.0118E+05, &
       8.0393E+05, 8.0670E+05, 8.0947E+05, 8.1225E+05, 8.1504E+05, 8.1783E+05, 8.2064E+05, 8.2345E+05, 8.2626E+05, 8.2909E+05, &
       8.3192E+05, 8.3477E+05, 8.3761E+05, 8.4047E+05, 8.4334E+05, 8.4621E+05, 8.4909E+05, 8.5198E+05, 8.5487E+05, 8.5778E+05, &
       8.6069E+05, 8.6361E+05, 8.6653E+05, 8.6947E+05, 8.7241E+05, 8.7536E+05, 8.7832E+05, 8.8129E+05, 8.8426E+05, 8.8725E+05, &
       8.9024E+05, 8.9324E+05, 8.9624E+05, 8.9926E+05, 9.0228E+05, 9.0531E+05, 9.0835E+05, 9.1140E+05, 9.1445E+05, 9.1752E+05, &
       9.2059E+05, 9.2367E+05, 9.2676E+05, 9.2985E+05, 9.3296E+05, 9.3607E+05, 9.3919E+05, 9.4232E+05, 9.4546E+05, 9.4860E+05, &
       9.5176E+05, 9.5492E+05, 9.5809E+05, 9.6127E+05, 9.6446E+05, 9.6765E+05, 9.7086E+05, 9.7407E+05, 9.7729E+05, 9.8052E+05, &
       9.8376E+05, 9.8700E+05, 9.9026E+05, 9.9352E+05, 9.9679E+05, 1.0001E+06, 1.0034E+06, 1.0067E+06, 1.0100E+06, 1.0133E+06, &
       1.0166E+06, 1.0199E+06, 1.0233E+06, 1.0266E+06, 1.0300E+06, 1.0333E+06, 1.0367E+06, 1.0401E+06, 1.0435E+06, 1.0469E+06, &
       1.0503E+06, 1.0537E+06, 1.0572E+06, 1.0606E+06, 1.0640E+06, 1.0675E+06, 1.0710E+06, 1.0744E+06, 1.0779E+06, 1.0814E+06, &
       1.0849E+06, 1.0884E+06, 1.0919E+06, 1.0954E+06, 1.0990E+06, 1.1025E+06, 1.1061E+06, 1.1096E+06, 1.1132E+06, 1.1168E+06, &
       1.1204E+06, 1.1240E+06, 1.1276E+06, 1.1312E+06, 1.1348E+06, 1.1385E+06, 1.1421E+06, 1.1458E+06, 1.1494E+06, 1.1531E+06, &
       1.1568E+06, 1.1605E+06, 1.1642E+06, 1.1679E+06, 1.1716E+06, 1.1753E+06, 1.1790E+06, 1.1828E+06, 1.1865E+06, 1.1903E+06, &
       1.1941E+06, 1.1979E+06, 1.2016E+06, 1.2054E+06, 1.2093E+06, 1.2131E+06, 1.2169E+06, 1.2207E+06, 1.2246E+06, 1.2285E+06, &
       1.2323E+06, 1.2362E+06, 1.2401E+06, 1.2440E+06, 1.2479E+06, 1.2518E+06, 1.2557E+06, 1.2597E+06, 1.2636E+06, 1.2676E+06, &
       1.2715E+06, 1.2755E+06, 1.2795E+06, 1.2835E+06, 1.2875E+06, 1.2915E+06, 1.2955E+06, 1.2995E+06, 1.3036E+06, 1.3076E+06, &
       1.3117E+06, 1.3158E+06, 1.3199E+06, 1.3239E+06, 1.3280E+06, 1.3322E+06, 1.3363E+06, 1.3404E+06, 1.3446E+06, 1.3487E+06, &
       1.3529E+06, 1.3570E+06, 1.3612E+06, 1.3654E+06, 1.3696E+06, 1.3738E+06, 1.3780E+06, 1.3823E+06, 1.3865E+06, 1.3908E+06, &
       1.3950E+06, 1.3993E+06, 1.4036E+06, 1.4079E+06, 1.4122E+06, 1.4165E+06, 1.4208E+06, 1.4251E+06, 1.4295E+06, 1.4338E+06, &
       1.4382E+06, 1.4426E+06, 1.4470E+06, 1.4514E+06, 1.4558E+06, 1.4602E+06, 1.4646E+06, 1.4690E+06, 1.4735E+06, 1.4779E+06, &
       1.4824E+06, 1.4869E+06, 1.4914E+06, 1.4959E+06, 1.5004E+06, 1.5049E+06, 1.5094E+06, 1.5140E+06, 1.5185E+06, 1.5231E+06, &
       1.5277E+06, 1.5323E+06, 1.5369E+06, 1.5415E+06, 1.5461E+06, 1.5507E+06, 1.5553E+06, 1.5600E+06, 1.5647E+06, 1.5693E+06, &
       1.5740E+06, 1.5787E+06, 1.5834E+06, 1.5881E+06, 1.5928E+06, 1.5976E+06, 1.6023E+06, 1.6071E+06, 1.6118E+06, 1.6166E+06, &
       1.6214E+06, 1.6262E+06, 1.6310E+06, 1.6358E+06, 1.6407E+06, 1.6455E+06, 1.6504E+06, 1.6552E+06, 1.6601E+06, 1.6650E+06, &
       1.6699E+06, 1.6748E+06, 1.6797E+06, 1.6847E+06, 1.6896E+06, 1.6946E+06, 1.6995E+06, 1.7045E+06, 1.7095E+06, 1.7145E+06, &
       1.7195E+06, 1.7245E+06, 1.7296E+06, 1.7346E+06, 1.7397E+06, 1.7448E+06, 1.7498E+06, 1.7549E+06, 1.7600E+06, 1.7651E+06, &
       1.7703E+06, 1.7754E+06, 1.7805E+06, 1.7857E+06, 1.7909E+06, 1.7961E+06, 1.8013E+06, 1.8065E+06, 1.8117E+06, 1.8169E+06, &
       1.8221E+06, 1.8274E+06, 1.8327E+06, 1.8379E+06, 1.8432E+06, 1.8485E+06, 1.8538E+06, 1.8592E+06, 1.8645E+06, 1.8698E+06, &
       1.8752E+06, 1.8806E+06, 1.8859E+06, 1.8913E+06, 1.8967E+06, 1.9021E+06, 1.9076E+06, 1.9130E+06, 1.9185E+06, 1.9239E+06, &
       1.9294E+06, 1.9349E+06, 1.9404E+06, 1.9459E+06, 1.9514E+06, 1.9569E+06, 1.9625E+06, 1.9681E+06, 1.9736E+06, 1.9792E+06, &
       1.9848E+06, 1.9904E+06, 1.9960E+06, 2.0017E+06, 2.0073E+06, 2.0130E+06, 2.0186E+06, 2.0243E+06, 2.0300E+06, 2.0357E+06, &
       2.0414E+06, 2.0471E+06, 2.0529E+06, 2.0586E+06, 2.0644E+06, 2.0702E+06, 2.0760E+06, 2.0818E+06, 2.0876E+06, 2.0934E+06, &
       2.0992E+06, 2.1051E+06, 2.1109E+06, 2.1168E+06, 2.1227E+06, 2.1286E+06, 2.1345E+06, 2.1404E+06, 2.1464E+06, 2.1523E+06, &
       2.1583E+06, 2.1643E+06, 2.1702E+06, 2.1762E+06, 2.1823E+06, 2.1883E+06, 2.1943E+06, 2.2004E+06, 2.2064E+06, 2.2125E+06, &
       2.2186E+06, 2.2247E+06, 2.2308E+06, 2.2369E+06, 2.2431E+06, 2.2492E+06, 2.2554E+06, 2.2616E+06, 2.2678E+06, 2.2740E+06, &
       2.2802E+06, 2.2864E+06, 2.2926E+06, 2.2989E+06, 2.3052E+06, 2.3114E+06, 2.3177E+06, 2.3240E+06, 2.3303E+06, 2.3367E+06, &
       2.3430E+06, 2.3494E+06, 2.3557E+06, 2.3621E+06, 2.3685E+06, 2.3749E+06, 2.3814E+06, 2.3878E+06, 2.3942E+06, 2.4007E+06, &
       2.4072E+06, 2.4137E+06, 2.4202E+06, 2.4267E+06, 2.4332E+06, 2.4397E+06, 2.4463E+06, 2.4529E+06, 2.4594E+06, 2.4660E+06, &
       2.4726E+06, 2.4792E+06, 2.4859E+06, 2.4925E+06, 2.4992E+06, 2.5058E+06, 2.5125E+06, 2.5192E+06, 2.5259E+06, 2.5327E+06, &
       2.5394E+06, 2.5462E+06, 2.5529E+06, 2.5597E+06, 2.5665E+06, 2.5733E+06, 2.5801E+06, 2.5869E+06, 2.5938E+06, 2.6007E+06, &
       2.6075E+06, 2.6144E+06, 2.6213E+06, 2.6282E+06, 2.6351E+06, 2.6421E+06, 2.6490E+06, 2.6560E+06, 2.6630E+06, 2.6700E+06, &
       2.6770E+06, 2.6840E+06, 2.6911E+06, 2.6981E+06, 2.7052E+06, 2.7122E+06, 2.7193E+06, 2.7264E+06, 2.7336E+06, 2.7407E+06, &
       2.7478E+06, 2.7550E+06, 2.7622E+06, 2.7694E+06, 2.7766E+06, 2.7838E+06, 2.7910E+06, 2.7982E+06, 2.8055E+06, 2.8128E+06, &
       2.8201E+06, 2.8273E+06, 2.8347E+06, 2.8420E+06, 2.8493E+06, 2.8567E+06, 2.8641E+06, 2.8714E+06, 2.8788E+06, 2.8862E+06, &
       2.8937E+06, 2.9011E+06, 2.9086E+06, 2.9160E+06, 2.9235E+06, 2.9310E+06, 2.9385E+06, 2.9460E+06, 2.9536E+06, 2.9611E+06, &
       2.9687E+06, 2.9763E+06, 2.9839E+06, 2.9915E+06, 2.9991E+06, 3.0067E+06, 3.0144E+06, 3.0220E+06, 3.0297E+06, 3.0374E+06, &
       3.0451E+06, 3.0529E+06, 3.0606E+06, 3.0683E+06, 3.0761E+06, 3.0839E+06, 3.0917E+06, 3.0995E+06, 3.1073E+06, 3.1152E+06, &
       3.1230E+06, 3.1309E+06, 3.1388E+06, 3.1467E+06, 3.1546E+06, 3.1625E+06, 3.1704E+06, 3.1784E+06, 3.1864E+06, 3.1943E+06, &
       3.2023E+06, 3.2104E+06, 3.2184E+06, 3.2264E+06, 3.2345E+06, 3.2426E+06, 3.2506E+06, 3.2587E+06, 3.2669E+06, 3.2750E+06, &
       3.2831E+06, 3.2913E+06, 3.2995E+06, 3.3077E+06, 3.3159E+06, 3.3241E+06, 3.3323E+06, 3.3406E+06, 3.3488E+06, 3.3571E+06, &
       3.3654E+06, 3.3737E+06, 3.3820E+06, 3.3904E+06, 3.3987E+06, 3.4071E+06, 3.4155E+06, 3.4239E+06, 3.4323E+06, 3.4407E+06, &
       3.4492E+06, 3.4576E+06, 3.4661E+06, 3.4746E+06, 3.4831E+06, 3.4916E+06, 3.5002E+06, 3.5087E+06, 3.5173E+06, 3.5258E+06, &
       3.5344E+06, 3.5430E+06, 3.5517E+06, 3.5603E+06, 3.5690E+06, 3.5776E+06, 3.5863E+06, 3.5950E+06, 3.6037E+06, 3.6125E+06, &
       3.6212E+06, 3.6300E+06, 3.6388E+06, 3.6475E+06, 3.6564E+06, 3.6652E+06, 3.6740E+06, 3.6829E+06, 3.6917E+06, 3.7006E+06, &
       3.7095E+06, 3.7184E+06, 3.7274E+06, 3.7363E+06, 3.7453E+06, 3.7542E+06, 3.7632E+06, 3.7722E+06, 3.7813E+06, 3.7903E+06, &
       3.7994E+06, 3.8084E+06, 3.8175E+06, 3.8266E+06, 3.8357E+06, 3.8449E+06, 3.8540E+06, 3.8632E+06, 3.8724E+06, 3.8815E+06, &
       3.8908E+06, 3.9000E+06, 3.9092E+06, 3.9185E+06, 3.9278E+06, 3.9370E+06, 3.9463E+06, 3.9557E+06, 3.9650E+06, 3.9744E+06, &
       3.9837E+06, 3.9931E+06, 4.0025E+06, 4.0119E+06, 4.0213E+06, 4.0308E+06, 4.0403E+06, 4.0497E+06, 4.0592E+06, 4.0687E+06, &
       4.0783E+06, 4.0878E+06, 4.0974E+06, 4.1069E+06, 4.1165E+06, 4.1261E+06, 4.1357E+06, 4.1454E+06, 4.1550E+06, 4.1647E+06, &
       4.1744E+06, 4.1841E+06, 4.1938E+06, 4.2035E+06, 4.2133E+06, 4.2230E+06, 4.2328E+06, 4.2426E+06, 4.2524E+06, 4.2623E+06, &
       4.2721E+06, 4.2820E+06, 4.2918E+06, 4.3017E+06, 4.3116E+06, 4.3216E+06, 4.3315E+06, 4.3415E+06, 4.3514E+06, 4.3614E+06, &
       4.3714E+06, 4.3814E+06, 4.3915E+06, 4.4015E+06, 4.4116E+06, 4.4217E+06, 4.4318E+06, 4.4419E+06, 4.4521E+06, 4.4622E+06, &
       4.4724E+06, 4.4826E+06, 4.4928E+06, 4.5030E+06, 4.5132E+06, 4.5235E+06, 4.5337E+06, 4.5440E+06, 4.5543E+06, 4.5646E+06, &
       4.5750E+06, 4.5853E+06, 4.5957E+06, 4.6061E+06, 4.6164E+06, 4.6269E+06, 4.6373E+06, 4.6477E+06, 4.6582E+06, 4.6687E+06, &
       4.6792E+06, 4.6897E+06, 4.7002E+06, 4.7108E+06, 4.7213E+06, 4.7319E+06, 4.7425E+06, 4.7531E+06, 4.7638E+06, 4.7744E+06, &
       4.7851E+06, 4.7957E+06, 4.8064E+06, 4.8171E+06, 4.8279E+06, 4.8386E+06, 4.8494E+06, 4.8602E+06, 4.8710E+06, 4.8818E+06, &
       4.8926E+06, 4.9034E+06, 4.9143E+06, 4.9252E+06, 4.9361E+06, 4.9470E+06, 4.9579E+06, 4.9689E+06, 4.9798E+06, 4.9908E+06, &
       5.0018E+06, 5.0128E+06, 5.0239E+06, 5.0349E+06, 5.0460E+06, 5.0570E+06, 5.0681E+06, 5.0793E+06, 5.0904E+06, 5.1015E+06, &
       5.1127E+06, 5.1239E+06, 5.1351E+06, 5.1463E+06, 5.1575E+06, 5.1688E+06, 5.1800E+06, 5.1913E+06, 5.2026E+06, 5.2140E+06, &
       5.2253E+06, 5.2366E+06, 5.2480E+06, 5.2594E+06, 5.2708E+06, 5.2822E+06, 5.2937E+06, 5.3051E+06, 5.3166E+06, 5.3281E+06, &
       5.3396E+06, 5.3511E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
      data (QofT( 6,J),J=2409,4510)/ 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       828
      data (QofT( 7,J),J=1,2408)/ 1.2509E+00, 2.1807E+00, 3.1786E+00, 4.1792E+00, 5.1803E+00, 6.1818E+00, 7.1835E+00, 8.1853E+00, &
       9.1871E+00, 1.0189E+01, 1.1191E+01, 1.2193E+01, 1.3195E+01, 1.4197E+01, 1.5199E+01, 1.6201E+01, 1.7203E+01, 1.8205E+01, &
       1.9207E+01, 2.0209E+01, 2.2213E+01, 2.4217E+01, 2.6221E+01, 2.8226E+01, 3.0230E+01, 3.2234E+01, 3.4238E+01, 3.6243E+01, &
       3.8247E+01, 4.0251E+01, 4.2255E+01, 4.4260E+01, 4.6264E+01, 4.8268E+01, 5.0273E+01, 5.2277E+01, 5.4281E+01, 5.6286E+01, &
       5.8290E+01, 6.0294E+01, 6.2299E+01, 6.4303E+01, 6.6308E+01, 6.8312E+01, 7.0317E+01, 7.2321E+01, 7.4326E+01, 7.6330E+01, &
       7.8335E+01, 8.0340E+01, 8.2345E+01, 8.4350E+01, 8.6355E+01, 8.8360E+01, 9.0366E+01, 9.2372E+01, 9.4378E+01, 9.6385E+01, &
       9.8392E+01, 1.0040E+02, 1.0241E+02, 1.0442E+02, 1.0643E+02, 1.0844E+02, 1.1045E+02, 1.1246E+02, 1.1447E+02, 1.1649E+02, &
       1.1850E+02, 1.2052E+02, 1.2254E+02, 1.2456E+02, 1.2658E+02, 1.2861E+02, 1.3063E+02, 1.3266E+02, 1.3469E+02, 1.3673E+02, &
       1.3876E+02, 1.4080E+02, 1.4285E+02, 1.4489E+02, 1.4694E+02, 1.4899E+02, 1.5105E+02, 1.5311E+02, 1.5518E+02, 1.5725E+02, &
       1.5932E+02, 1.6140E+02, 1.6348E+02, 1.6557E+02, 1.6766E+02, 1.6976E+02, 1.7186E+02, 1.7397E+02, 1.7609E+02, 1.7821E+02, &
       1.8034E+02, 1.8248E+02, 1.8462E+02, 1.8677E+02, 1.8892E+02, 1.9109E+02, 1.9326E+02, 1.9544E+02, 1.9762E+02, 1.9982E+02, &
       2.0202E+02, 2.0423E+02, 2.0645E+02, 2.0868E+02, 2.1091E+02, 2.1316E+02, 2.1541E+02, 2.1768E+02, 2.1995E+02, 2.2224E+02, &
       2.2453E+02, 2.2683E+02, 2.2915E+02, 2.3147E+02, 2.3381E+02, 2.3615E+02, 2.3851E+02, 2.4088E+02, 2.4326E+02, 2.4565E+02, &
       2.4805E+02, 2.5047E+02, 2.5289E+02, 2.5533E+02, 2.5778E+02, 2.6024E+02, 2.6272E+02, 2.6520E+02, 2.6771E+02, 2.7022E+02, &
       2.7275E+02, 2.7528E+02, 2.7784E+02, 2.8040E+02, 2.8298E+02, 2.8558E+02, 2.8819E+02, 2.9081E+02, 2.9345E+02, 2.9610E+02, &
       2.9876E+02, 3.0144E+02, 3.0414E+02, 3.0685E+02, 3.0957E+02, 3.1231E+02, 3.1506E+02, 3.1784E+02, 3.2062E+02, 3.2342E+02, &
       3.2624E+02, 3.2908E+02, 3.3193E+02, 3.3479E+02, 3.3767E+02, 3.4057E+02, 3.4349E+02, 3.4642E+02, 3.4937E+02, 3.5234E+02, &
       3.5532E+02, 3.5832E+02, 3.6134E+02, 3.6438E+02, 3.6743E+02, 3.7050E+02, 3.7359E+02, 3.7670E+02, 3.7983E+02, 3.8297E+02, &
       3.8613E+02, 3.8931E+02, 3.9251E+02, 3.9573E+02, 3.9897E+02, 4.0223E+02, 4.0550E+02, 4.0880E+02, 4.1211E+02, 4.1545E+02, &
       4.1880E+02, 4.2217E+02, 4.2557E+02, 4.2898E+02, 4.3242E+02, 4.3587E+02, 4.3934E+02, 4.4284E+02, 4.4636E+02, 4.4989E+02, &
       4.5345E+02, 4.5703E+02, 4.6063E+02, 4.6425E+02, 4.6789E+02, 4.7156E+02, 4.7524E+02, 4.7895E+02, 4.8268E+02, 4.8643E+02, &
       4.9021E+02, 4.9400E+02, 4.9782E+02, 5.0166E+02, 5.0553E+02, 5.0941E+02, 5.1332E+02, 5.1725E+02, 5.2121E+02, 5.2519E+02, &
       5.2919E+02, 5.3322E+02, 5.3727E+02, 5.4134E+02, 5.4544E+02, 5.4956E+02, 5.5371E+02, 5.5788E+02, 5.6207E+02, 5.6629E+02, &
       5.7054E+02, 5.7480E+02, 5.7910E+02, 5.8342E+02, 5.8776E+02, 5.9213E+02, 5.9653E+02, 6.0095E+02, 6.0539E+02, 6.0986E+02, &
       6.1436E+02, 6.1889E+02, 6.2344E+02, 6.2802E+02, 6.3262E+02, 6.3725E+02, 6.4191E+02, 6.4659E+02, 6.5130E+02, 6.5604E+02, &
       6.6080E+02, 6.6560E+02, 6.7042E+02, 6.7527E+02, 6.8014E+02, 6.8505E+02, 6.8998E+02, 6.9494E+02, 6.9993E+02, 7.0495E+02, &
       7.0999E+02, 7.1507E+02, 7.2017E+02, 7.2531E+02, 7.3047E+02, 7.3566E+02, 7.4088E+02, 7.4613E+02, 7.5142E+02, 7.5673E+02, &
       7.6207E+02, 7.6744E+02, 7.7284E+02, 7.7827E+02, 7.8373E+02, 7.8923E+02, 7.9475E+02, 8.0031E+02, 8.0590E+02, 8.1151E+02, &
       8.1716E+02, 8.2284E+02, 8.2856E+02, 8.3430E+02, 8.4008E+02, 8.4589E+02, 8.5173E+02, 8.5761E+02, 8.6351E+02, 8.6945E+02, &
       8.7543E+02, 8.8143E+02, 8.8747E+02, 8.9354E+02, 8.9965E+02, 9.0579E+02, 9.1196E+02, 9.1817E+02, 9.2442E+02, 9.3069E+02, &
       9.3700E+02, 9.4335E+02, 9.4973E+02, 9.5615E+02, 9.6260E+02, 9.6908E+02, 9.7560E+02, 9.8216E+02, 9.8875E+02, 9.9538E+02, &
       1.0020E+03, 1.0087E+03, 1.0155E+03, 1.0223E+03, 1.0291E+03, 1.0359E+03, 1.0428E+03, 1.0497E+03, 1.0567E+03, 1.0637E+03, &
       1.0707E+03, 1.0778E+03, 1.0849E+03, 1.0920E+03, 1.0992E+03, 1.1065E+03, 1.1137E+03, 1.1210E+03, 1.1284E+03, 1.1357E+03, &
       1.1432E+03, 1.1506E+03, 1.1581E+03, 1.1657E+03, 1.1732E+03, 1.1809E+03, 1.1885E+03, 1.1962E+03, 1.2040E+03, 1.2117E+03, &
       1.2196E+03, 1.2274E+03, 1.2353E+03, 1.2433E+03, 1.2513E+03, 1.2593E+03, 1.2674E+03, 1.2755E+03, 1.2836E+03, 1.2918E+03, &
       1.3001E+03, 1.3084E+03, 1.3167E+03, 1.3250E+03, 1.3335E+03, 1.3419E+03, 1.3504E+03, 1.3590E+03, 1.3676E+03, 1.3762E+03, &
       1.3849E+03, 1.3936E+03, 1.4024E+03, 1.4112E+03, 1.4200E+03, 1.4289E+03, 1.4379E+03, 1.4469E+03, 1.4559E+03, 1.4650E+03, &
       1.4742E+03, 1.4833E+03, 1.4926E+03, 1.5018E+03, 1.5112E+03, 1.5205E+03, 1.5299E+03, 1.5394E+03, 1.5489E+03, 1.5585E+03, &
       1.5681E+03, 1.5777E+03, 1.5875E+03, 1.5972E+03, 1.6070E+03, 1.6169E+03, 1.6268E+03, 1.6367E+03, 1.6467E+03, 1.6568E+03, &
       1.6669E+03, 1.6770E+03, 1.6872E+03, 1.6975E+03, 1.7078E+03, 1.7181E+03, 1.7285E+03, 1.7390E+03, 1.7495E+03, 1.7601E+03, &
       1.7707E+03, 1.7814E+03, 1.7921E+03, 1.8029E+03, 1.8137E+03, 1.8246E+03, 1.8355E+03, 1.8465E+03, 1.8575E+03, 1.8686E+03, &
       1.8798E+03, 1.8910E+03, 1.9022E+03, 1.9135E+03, 1.9249E+03, 1.9363E+03, 1.9478E+03, 1.9593E+03, 1.9709E+03, 1.9826E+03, &
       1.9943E+03, 2.0061E+03, 2.0179E+03, 2.0297E+03, 2.0417E+03, 2.0537E+03, 2.0657E+03, 2.0778E+03, 2.0900E+03, 2.1022E+03, &
       2.1145E+03, 2.1268E+03, 2.1392E+03, 2.1517E+03, 2.1642E+03, 2.1768E+03, 2.1894E+03, 2.2021E+03, 2.2148E+03, 2.2277E+03, &
       2.2405E+03, 2.2535E+03, 2.2665E+03, 2.2795E+03, 2.2927E+03, 2.3058E+03, 2.3191E+03, 2.3324E+03, 2.3458E+03, 2.3592E+03, &
       2.3727E+03, 2.3863E+03, 2.3999E+03, 2.4136E+03, 2.4273E+03, 2.4411E+03, 2.4550E+03, 2.4690E+03, 2.4830E+03, 2.4971E+03, &
       2.5112E+03, 2.5254E+03, 2.5397E+03, 2.5540E+03, 2.5684E+03, 2.5829E+03, 2.5974E+03, 2.6120E+03, 2.6267E+03, 2.6415E+03, &
       2.6563E+03, 2.6711E+03, 2.6861E+03, 2.7011E+03, 2.7162E+03, 2.7313E+03, 2.7466E+03, 2.7618E+03, 2.7772E+03, 2.7926E+03, &
       2.8081E+03, 2.8237E+03, 2.8394E+03, 2.8551E+03, 2.8708E+03, 2.8867E+03, 2.9026E+03, 2.9186E+03, 2.9347E+03, 2.9508E+03, &
       2.9671E+03, 2.9834E+03, 2.9997E+03, 3.0162E+03, 3.0327E+03, 3.0493E+03, 3.0659E+03, 3.0826E+03, 3.0995E+03, 3.1163E+03, &
       3.1333E+03, 3.1503E+03, 3.1674E+03, 3.1846E+03, 3.2019E+03, 3.2192E+03, 3.2367E+03, 3.2541E+03, 3.2717E+03, 3.2894E+03, &
       3.3071E+03, 3.3249E+03, 3.3428E+03, 3.3608E+03, 3.3788E+03, 3.3969E+03, 3.4151E+03, 3.4334E+03, 3.4518E+03, 3.4702E+03, &
       3.4887E+03, 3.5073E+03, 3.5260E+03, 3.5448E+03, 3.5636E+03, 3.5826E+03, 3.6016E+03, 3.6207E+03, 3.6398E+03, 3.6591E+03, &
       3.6785E+03, 3.6979E+03, 3.7174E+03, 3.7370E+03, 3.7567E+03, 3.7764E+03, 3.7963E+03, 3.8162E+03, 3.8363E+03, 3.8564E+03, &
       3.8766E+03, 3.8969E+03, 3.9172E+03, 3.9377E+03, 3.9582E+03, 3.9789E+03, 3.9996E+03, 4.0204E+03, 4.0413E+03, 4.0623E+03, &
       4.0833E+03, 4.1045E+03, 4.1258E+03, 4.1471E+03, 4.1685E+03, 4.1901E+03, 4.2117E+03, 4.2334E+03, 4.2552E+03, 4.2771E+03, &
       4.2991E+03, 4.3212E+03, 4.3433E+03, 4.3656E+03, 4.3879E+03, 4.4104E+03, 4.4329E+03, 4.4556E+03, 4.4783E+03, 4.5011E+03, &
       4.5241E+03, 4.5471E+03, 4.5702E+03, 4.5934E+03, 4.6167E+03, 4.6401E+03, 4.6636E+03, 4.6872E+03, 4.7109E+03, 4.7347E+03, &
       4.7586E+03, 4.7826E+03, 4.8067E+03, 4.8309E+03, 4.8552E+03, 4.8795E+03, 4.9040E+03, 4.9286E+03, 4.9533E+03, 4.9781E+03, &
       5.0030E+03, 5.0280E+03, 5.0531E+03, 5.0783E+03, 5.1036E+03, 5.1290E+03, 5.1545E+03, 5.1801E+03, 5.2058E+03, 5.2317E+03, &
       5.2576E+03, 5.2836E+03, 5.3098E+03, 5.3360E+03, 5.3624E+03, 5.3888E+03, 5.4154E+03, 5.4420E+03, 5.4688E+03, 5.4957E+03, &
       5.5227E+03, 5.5498E+03, 5.5770E+03, 5.6043E+03, 5.6318E+03, 5.6593E+03, 5.6869E+03, 5.7147E+03, 5.7426E+03, 5.7705E+03, &
       5.7986E+03, 5.8268E+03, 5.8552E+03, 5.8836E+03, 5.9121E+03, 5.9408E+03, 5.9695E+03, 5.9984E+03, 6.0274E+03, 6.0565E+03, &
       6.0858E+03, 6.1151E+03, 6.1446E+03, 6.1741E+03, 6.2038E+03, 6.2336E+03, 6.2635E+03, 6.2936E+03, 6.3237E+03, 6.3540E+03, &
       6.3844E+03, 6.4149E+03, 6.4455E+03, 6.4763E+03, 6.5072E+03, 6.5382E+03, 6.5693E+03, 6.6005E+03, 6.6318E+03, 6.6633E+03, &
       6.6949E+03, 6.7266E+03, 6.7585E+03, 6.7904E+03, 6.8225E+03, 6.8547E+03, 6.8871E+03, 6.9195E+03, 6.9521E+03, 6.9848E+03, &
       7.0177E+03, 7.0506E+03, 7.0837E+03, 7.1169E+03, 7.1503E+03, 7.1838E+03, 7.2174E+03, 7.2511E+03, 7.2849E+03, 7.3189E+03, &
       7.3530E+03, 7.3873E+03, 7.4216E+03, 7.4561E+03, 7.4908E+03, 7.5255E+03, 7.5604E+03, 7.5955E+03, 7.6306E+03, 7.6659E+03, &
       7.7014E+03, 7.7369E+03, 7.7726E+03, 7.8084E+03, 7.8444E+03, 7.8805E+03, 7.9167E+03, 7.9531E+03, 7.9896E+03, 8.0263E+03, &
       8.0630E+03, 8.1000E+03, 8.1370E+03, 8.1742E+03, 8.2115E+03, 8.2490E+03, 8.2866E+03, 8.3244E+03, 8.3623E+03, 8.4003E+03, &
       8.4385E+03, 8.4768E+03, 8.5152E+03, 8.5538E+03, 8.5926E+03, 8.6315E+03, 8.6705E+03, 8.7097E+03, 8.7490E+03, 8.7884E+03, &
       8.8280E+03, 8.8678E+03, 8.9077E+03, 8.9477E+03, 8.9879E+03, 9.0283E+03, 9.0687E+03, 9.1094E+03, 9.1502E+03, 9.1911E+03, &
       9.2322E+03, 9.2734E+03, 9.3148E+03, 9.3563E+03, 9.3980E+03, 9.4398E+03, 9.4818E+03, 9.5239E+03, 9.5662E+03, 9.6086E+03, &
       9.6512E+03, 9.6940E+03, 9.7369E+03, 9.7799E+03, 9.8231E+03, 9.8665E+03, 9.9100E+03, 9.9537E+03, 9.9975E+03, 1.0042E+04, &
       1.0086E+04, 1.0130E+04, 1.0174E+04, 1.0219E+04, 1.0264E+04, 1.0309E+04, 1.0354E+04, 1.0399E+04, 1.0445E+04, 1.0490E+04, &
       1.0536E+04, 1.0582E+04, 1.0628E+04, 1.0674E+04, 1.0721E+04, 1.0767E+04, 1.0814E+04, 1.0861E+04, 1.0908E+04, 1.0955E+04, &
       1.1002E+04, 1.1050E+04, 1.1098E+04, 1.1146E+04, 1.1194E+04, 1.1242E+04, 1.1290E+04, 1.1339E+04, 1.1388E+04, 1.1436E+04, &
       1.1486E+04, 1.1535E+04, 1.1584E+04, 1.1634E+04, 1.1684E+04, 1.1734E+04, 1.1784E+04, 1.1834E+04, 1.1884E+04, 1.1935E+04, &
       1.1986E+04, 1.2037E+04, 1.2088E+04, 1.2139E+04, 1.2191E+04, 1.2243E+04, 1.2294E+04, 1.2346E+04, 1.2399E+04, 1.2451E+04, &
       1.2504E+04, 1.2556E+04, 1.2609E+04, 1.2663E+04, 1.2716E+04, 1.2769E+04, 1.2823E+04, 1.2877E+04, 1.2931E+04, 1.2985E+04, &
       1.3040E+04, 1.3094E+04, 1.3149E+04, 1.3204E+04, 1.3259E+04, 1.3314E+04, 1.3370E+04, 1.3426E+04, 1.3482E+04, 1.3538E+04, &
       1.3594E+04, 1.3650E+04, 1.3707E+04, 1.3764E+04, 1.3821E+04, 1.3878E+04, 1.3936E+04, 1.3993E+04, 1.4051E+04, 1.4109E+04, &
       1.4167E+04, 1.4226E+04, 1.4284E+04, 1.4343E+04, 1.4402E+04, 1.4461E+04, 1.4521E+04, 1.4580E+04, 1.4640E+04, 1.4700E+04, &
       1.4760E+04, 1.4821E+04, 1.4881E+04, 1.4942E+04, 1.5003E+04, 1.5064E+04, 1.5126E+04, 1.5187E+04, 1.5249E+04, 1.5311E+04, &
       1.5373E+04, 1.5436E+04, 1.5498E+04, 1.5561E+04, 1.5624E+04, 1.5687E+04, 1.5751E+04, 1.5814E+04, 1.5878E+04, 1.5942E+04, &
       1.6007E+04, 1.6071E+04, 1.6136E+04, 1.6201E+04, 1.6266E+04, 1.6331E+04, 1.6397E+04, 1.6462E+04, 1.6528E+04, 1.6595E+04, &
       1.6661E+04, 1.6728E+04, 1.6794E+04, 1.6861E+04, 1.6929E+04, 1.6996E+04, 1.7064E+04, 1.7132E+04, 1.7200E+04, 1.7268E+04, &
       1.7337E+04, 1.7406E+04, 1.7475E+04, 1.7544E+04, 1.7613E+04, 1.7683E+04, 1.7753E+04, 1.7823E+04, 1.7893E+04, 1.7964E+04, &
       1.8035E+04, 1.8106E+04, 1.8177E+04, 1.8249E+04, 1.8320E+04, 1.8392E+04, 1.8464E+04, 1.8537E+04, 1.8609E+04, 1.8682E+04, &
       1.8755E+04, 1.8829E+04, 1.8902E+04, 1.8976E+04, 1.9050E+04, 1.9124E+04, 1.9199E+04, 1.9274E+04, 1.9348E+04, 1.9424E+04, &
       1.9499E+04, 1.9575E+04, 1.9651E+04, 1.9727E+04, 1.9803E+04, 1.9880E+04, 1.9957E+04, 2.0034E+04, 2.0111E+04, 2.0189E+04, &
       2.0266E+04, 2.0345E+04, 2.0423E+04, 2.0501E+04, 2.0580E+04, 2.0659E+04, 2.0738E+04, 2.0818E+04, 2.0898E+04, 2.0978E+04, &
       2.1058E+04, 2.1139E+04, 2.1219E+04, 2.1300E+04, 2.1382E+04, 2.1463E+04, 2.1545E+04, 2.1627E+04, 2.1709E+04, 2.1792E+04, &
       2.1875E+04, 2.1958E+04, 2.2041E+04, 2.2124E+04, 2.2208E+04, 2.2292E+04, 2.2377E+04, 2.2461E+04, 2.2546E+04, 2.2631E+04, &
       2.2716E+04, 2.2802E+04, 2.2888E+04, 2.2974E+04, 2.3060E+04, 2.3147E+04, 2.3234E+04, 2.3321E+04, 2.3409E+04, 2.3496E+04, &
       2.3584E+04, 2.3672E+04, 2.3761E+04, 2.3850E+04, 2.3939E+04, 2.4028E+04, 2.4118E+04, 2.4207E+04, 2.4298E+04, 2.4388E+04, &
       2.4479E+04, 2.4570E+04, 2.4661E+04, 2.4752E+04, 2.4844E+04, 2.4936E+04, 2.5028E+04, 2.5121E+04, 2.5214E+04, 2.5307E+04, &
       2.5400E+04, 2.5494E+04, 2.5588E+04, 2.5682E+04, 2.5777E+04, 2.5871E+04, 2.5966E+04, 2.6062E+04, 2.6157E+04, 2.6253E+04, &
       2.6350E+04, 2.6446E+04, 2.6543E+04, 2.6640E+04, 2.6737E+04, 2.6835E+04, 2.6933E+04, 2.7031E+04, 2.7130E+04, 2.7228E+04, &
       2.7327E+04, 2.7427E+04, 2.7526E+04, 2.7626E+04, 2.7727E+04, 2.7827E+04, 2.7928E+04, 2.8029E+04, 2.8131E+04, 2.8232E+04, &
       2.8334E+04, 2.8437E+04, 2.8539E+04, 2.8642E+04, 2.8745E+04, 2.8849E+04, 2.8953E+04, 2.9057E+04, 2.9161E+04, 2.9266E+04, &
       2.9371E+04, 2.9476E+04, 2.9582E+04, 2.9688E+04, 2.9794E+04, 2.9901E+04, 3.0007E+04, 3.0115E+04, 3.0222E+04, 3.0330E+04, &
       3.0438E+04, 3.0546E+04, 3.0655E+04, 3.0764E+04, 3.0873E+04, 3.0983E+04, 3.1093E+04, 3.1203E+04, 3.1314E+04, 3.1425E+04, &
       3.1536E+04, 3.1647E+04, 3.1759E+04, 3.1871E+04, 3.1984E+04, 3.2097E+04, 3.2210E+04, 3.2323E+04, 3.2437E+04, 3.2551E+04, &
       3.2665E+04, 3.2780E+04, 3.2895E+04, 3.3011E+04, 3.3126E+04, 3.3242E+04, 3.3359E+04, 3.3475E+04, 3.3592E+04, 3.3710E+04, &
       3.3827E+04, 3.3945E+04, 3.4064E+04, 3.4182E+04, 3.4301E+04, 3.4421E+04, 3.4540E+04, 3.4660E+04, 3.4781E+04, 3.4901E+04, &
       3.5022E+04, 3.5144E+04, 3.5265E+04, 3.5387E+04, 3.5510E+04, 3.5632E+04, 3.5755E+04, 3.5879E+04, 3.6002E+04, 3.6126E+04, &
       3.6251E+04, 3.6376E+04, 3.6501E+04, 3.6626E+04, 3.6752E+04, 3.6878E+04, 3.7005E+04, 3.7131E+04, 3.7259E+04, 3.7386E+04, &
       3.7514E+04, 3.7642E+04, 3.7771E+04, 3.7900E+04, 3.8029E+04, 3.8159E+04, 3.8289E+04, 3.8419E+04, 3.8550E+04, 3.8681E+04, &
       3.8812E+04, 3.8944E+04, 3.9076E+04, 3.9209E+04, 3.9341E+04, 3.9475E+04, 3.9608E+04, 3.9742E+04, 3.9876E+04, 4.0011E+04, &
       4.0146E+04, 4.0282E+04, 4.0417E+04, 4.0553E+04, 4.0690E+04, 4.0827E+04, 4.0964E+04, 4.1102E+04, 4.1240E+04, 4.1378E+04, &
       4.1517E+04, 4.1656E+04, 4.1795E+04, 4.1935E+04, 4.2075E+04, 4.2216E+04, 4.2357E+04, 4.2498E+04, 4.2640E+04, 4.2782E+04, &
       4.2925E+04, 4.3068E+04, 4.3211E+04, 4.3354E+04, 4.3498E+04, 4.3643E+04, 4.3788E+04, 4.3933E+04, 4.4078E+04, 4.4224E+04, &
       4.4371E+04, 4.4517E+04, 4.4664E+04, 4.4812E+04, 4.4960E+04, 4.5108E+04, 4.5257E+04, 4.5406E+04, 4.5555E+04, 4.5705E+04, &
       4.5855E+04, 4.6006E+04, 4.6157E+04, 4.6308E+04, 4.6460E+04, 4.6612E+04, 4.6765E+04, 4.6918E+04, 4.7072E+04, 4.7225E+04, &
       4.7380E+04, 4.7534E+04, 4.7689E+04, 4.7845E+04, 4.8001E+04, 4.8157E+04, 4.8313E+04, 4.8471E+04, 4.8628E+04, 4.8786E+04, &
       4.8944E+04, 4.9103E+04, 4.9262E+04, 4.9422E+04, 4.9582E+04, 4.9742E+04, 4.9903E+04, 5.0064E+04, 5.0225E+04, 5.0388E+04, &
       5.0550E+04, 5.0713E+04, 5.0876E+04, 5.1040E+04, 5.1204E+04, 5.1369E+04, 5.1533E+04, 5.1699E+04, 5.1865E+04, 5.2031E+04, &
       5.2198E+04, 5.2365E+04, 5.2532E+04, 5.2700E+04, 5.2869E+04, 5.3037E+04, 5.3207E+04, 5.3376E+04, 5.3546E+04, 5.3717E+04, &
       5.3888E+04, 5.4059E+04, 5.4231E+04, 5.4404E+04, 5.4576E+04, 5.4749E+04, 5.4923E+04, 5.5097E+04, 5.5272E+04, 5.5446E+04, &
       5.5622E+04, 5.5798E+04, 5.5974E+04, 5.6151E+04, 5.6328E+04, 5.6505E+04, 5.6683E+04, 5.6862E+04, 5.7041E+04, 5.7220E+04, &
       5.7400E+04, 5.7580E+04, 5.7761E+04, 5.7942E+04, 5.8124E+04, 5.8306E+04, 5.8488E+04, 5.8672E+04, 5.8855E+04, 5.9039E+04, &
       5.9223E+04, 5.9408E+04, 5.9593E+04, 5.9779E+04, 5.9965E+04, 6.0152E+04, 6.0339E+04, 6.0527E+04, 6.0715E+04, 6.0904E+04, &
       6.1093E+04, 6.1282E+04, 6.1472E+04, 6.1662E+04, 6.1853E+04, 6.2045E+04, 6.2237E+04, 6.2429E+04, 6.2622E+04, 6.2815E+04, &
       6.3009E+04, 6.3203E+04, 6.3398E+04, 6.3593E+04, 6.3788E+04, 6.3985E+04, 6.4181E+04, 6.4378E+04, 6.4576E+04, 6.4774E+04, &
       6.4973E+04, 6.5172E+04, 6.5371E+04, 6.5571E+04, 6.5772E+04, 6.5973E+04, 6.6174E+04, 6.6376E+04, 6.6578E+04, 6.6781E+04, &
       6.6985E+04, 6.7189E+04, 6.7393E+04, 6.7598E+04, 6.7804E+04, 6.8010E+04, 6.8216E+04, 6.8423E+04, 6.8630E+04, 6.8838E+04, &
       6.9047E+04, 6.9256E+04, 6.9465E+04, 6.9675E+04, 6.9885E+04, 7.0096E+04, 7.0308E+04, 7.0520E+04, 7.0732E+04, 7.0945E+04, &
       7.1159E+04, 7.1373E+04, 7.1587E+04, 7.1802E+04, 7.2018E+04, 7.2234E+04, 7.2450E+04, 7.2668E+04, 7.2885E+04, 7.3103E+04, &
       7.3322E+04, 7.3541E+04, 7.3761E+04, 7.3981E+04, 7.4202E+04, 7.4423E+04, 7.4645E+04, 7.4867E+04, 7.5090E+04, 7.5313E+04, &
       7.5537E+04, 7.5762E+04, 7.5987E+04, 7.6212E+04, 7.6438E+04, 7.6665E+04, 7.6892E+04, 7.7119E+04, 7.7348E+04, 7.7576E+04, &
       7.7805E+04, 7.8035E+04, 7.8266E+04, 7.8496E+04, 7.8728E+04, 7.8960E+04, 7.9192E+04, 7.9425E+04, 7.9659E+04, 7.9893E+04, &
       8.0128E+04, 8.0363E+04, 8.0599E+04, 8.0835E+04, 8.1072E+04, 8.1309E+04, 8.1547E+04, 8.1786E+04, 8.2025E+04, 8.2264E+04, &
       8.2505E+04, 8.2745E+04, 8.2987E+04, 8.3228E+04, 8.3471E+04, 8.3714E+04, 8.3957E+04, 8.4202E+04, 8.4446E+04, 8.4691E+04, &
       8.4937E+04, 8.5184E+04, 8.5431E+04, 8.5678E+04, 8.5926E+04, 8.6175E+04, 8.6424E+04, 8.6674E+04, 8.6924E+04, 8.7175E+04, &
       8.7427E+04, 8.7679E+04, 8.7931E+04, 8.8185E+04, 8.8438E+04, 8.8693E+04, 8.8948E+04, 8.9203E+04, 8.9460E+04, 8.9716E+04, &
       8.9974E+04, 9.0232E+04, 9.0490E+04, 9.0749E+04, 9.1009E+04, 9.1269E+04, 9.1530E+04, 9.1791E+04, 9.2053E+04, 9.2316E+04, &
       9.2579E+04, 9.2843E+04, 9.3107E+04, 9.3372E+04, 9.3638E+04, 9.3904E+04, 9.4171E+04, 9.4439E+04, 9.4707E+04, 9.4975E+04, &
       9.5244E+04, 9.5514E+04, 9.5785E+04, 9.6056E+04, 9.6327E+04, 9.6600E+04, 9.6872E+04, 9.7146E+04, 9.7420E+04, 9.7695E+04, &
       9.7970E+04, 9.8246E+04, 9.8523E+04, 9.8800E+04, 9.9077E+04, 9.9356E+04, 9.9635E+04, 9.9915E+04, 1.0019E+05, 1.0048E+05, &
       1.0076E+05, 1.0104E+05, 1.0132E+05, 1.0161E+05, 1.0189E+05, 1.0217E+05, 1.0246E+05, 1.0275E+05, 1.0303E+05, 1.0332E+05, &
       1.0361E+05, 1.0390E+05, 1.0418E+05, 1.0447E+05, 1.0476E+05, 1.0506E+05, 1.0535E+05, 1.0564E+05, 1.0593E+05, 1.0623E+05, &
       1.0652E+05, 1.0681E+05, 1.0711E+05, 1.0741E+05, 1.0770E+05, 1.0800E+05, 1.0830E+05, 1.0860E+05, 1.0890E+05, 1.0920E+05, &
       1.0950E+05, 1.0980E+05, 1.1010E+05, 1.1040E+05, 1.1071E+05, 1.1101E+05, 1.1132E+05, 1.1162E+05, 1.1193E+05, 1.1223E+05, &
       1.1254E+05, 1.1285E+05, 1.1316E+05, 1.1347E+05, 1.1378E+05, 1.1409E+05, 1.1440E+05, 1.1471E+05, 1.1502E+05, 1.1534E+05, &
       1.1565E+05, 1.1597E+05, 1.1628E+05, 1.1660E+05, 1.1691E+05, 1.1723E+05, 1.1755E+05, 1.1787E+05, 1.1819E+05, 1.1851E+05, &
       1.1883E+05, 1.1915E+05, 1.1947E+05, 1.1979E+05, 1.2012E+05, 1.2044E+05, 1.2077E+05, 1.2109E+05, 1.2142E+05, 1.2175E+05, &
       1.2207E+05, 1.2240E+05, 1.2273E+05, 1.2306E+05, 1.2339E+05, 1.2372E+05, 1.2405E+05, 1.2439E+05, 1.2472E+05, 1.2505E+05, &
       1.2539E+05, 1.2572E+05, 1.2606E+05, 1.2640E+05, 1.2674E+05, 1.2707E+05, 1.2741E+05, 1.2775E+05, 1.2809E+05, 1.2843E+05, &
       1.2878E+05, 1.2912E+05, 1.2946E+05, 1.2981E+05, 1.3015E+05, 1.3050E+05, 1.3084E+05, 1.3119E+05, 1.3154E+05, 1.3188E+05, &
       1.3223E+05, 1.3258E+05, 1.3293E+05, 1.3329E+05, 1.3364E+05, 1.3399E+05, 1.3434E+05, 1.3470E+05, 1.3505E+05, 1.3541E+05, &
       1.3576E+05, 1.3612E+05, 1.3648E+05, 1.3684E+05, 1.3720E+05, 1.3756E+05, 1.3792E+05, 1.3828E+05, 1.3864E+05, 1.3901E+05, &
       1.3937E+05, 1.3973E+05, 1.4010E+05, 1.4047E+05, 1.4083E+05, 1.4120E+05, 1.4157E+05, 1.4194E+05, 1.4231E+05, 1.4268E+05, &
       1.4305E+05, 1.4342E+05, 1.4379E+05, 1.4417E+05, 1.4454E+05, 1.4492E+05, 1.4529E+05, 1.4567E+05, 1.4605E+05, 1.4643E+05, &
       1.4681E+05, 1.4718E+05, 1.4757E+05, 1.4795E+05, 1.4833E+05, 1.4871E+05, 1.4910E+05, 1.4948E+05, 1.4987E+05, 1.5025E+05, &
       1.5064E+05, 1.5103E+05, 1.5141E+05, 1.5180E+05, 1.5219E+05, 1.5258E+05, 1.5298E+05, 1.5337E+05, 1.5376E+05, 1.5415E+05, &
       1.5455E+05, 1.5494E+05, 1.5534E+05, 1.5574E+05, 1.5614E+05, 1.5653E+05, 1.5693E+05, 1.5733E+05, 1.5774E+05, 1.5814E+05, &
       1.5854E+05, 1.5894E+05, 1.5935E+05, 1.5975E+05, 1.6016E+05, 1.6057E+05, 1.6097E+05, 1.6138E+05, 1.6179E+05, 1.6220E+05, &
       1.6261E+05, 1.6302E+05, 1.6344E+05, 1.6385E+05, 1.6426E+05, 1.6468E+05, 1.6509E+05, 1.6551E+05, 1.6593E+05, 1.6635E+05, &
       1.6676E+05, 1.6718E+05, 1.6760E+05, 1.6803E+05, 1.6845E+05, 1.6887E+05, 1.6930E+05, 1.6972E+05, 1.7015E+05, 1.7057E+05, &
       1.7100E+05, 1.7143E+05, 1.7186E+05, 1.7229E+05, 1.7272E+05, 1.7315E+05, 1.7358E+05, 1.7401E+05, 1.7445E+05, 1.7488E+05, &
       1.7532E+05, 1.7576E+05, 1.7619E+05, 1.7663E+05, 1.7707E+05, 1.7751E+05, 1.7795E+05, 1.7839E+05, 1.7884E+05, 1.7928E+05, &
       1.7972E+05, 1.8017E+05, 1.8062E+05, 1.8106E+05, 1.8151E+05, 1.8196E+05, 1.8241E+05, 1.8286E+05, 1.8331E+05, 1.8376E+05, &
       1.8422E+05, 1.8467E+05, 1.8512E+05, 1.8558E+05, 1.8604E+05, 1.8649E+05, 1.8695E+05, 1.8741E+05, 1.8787E+05, 1.8833E+05, &
       1.8879E+05, 1.8926E+05, 1.8972E+05, 1.9018E+05, 1.9065E+05, 1.9112E+05, 1.9158E+05, 1.9205E+05, 1.9252E+05, 1.9299E+05, &
       1.9346E+05, 1.9393E+05, 1.9440E+05, 1.9488E+05, 1.9535E+05, 1.9583E+05, 1.9630E+05, 1.9678E+05, 1.9726E+05, 1.9774E+05, &
       1.9822E+05, 1.9870E+05, 1.9918E+05, 1.9966E+05, 2.0014E+05, 2.0063E+05, 2.0111E+05, 2.0160E+05, 2.0209E+05, 2.0257E+05, &
       2.0306E+05, 2.0355E+05, 2.0404E+05, 2.0454E+05, 2.0503E+05, 2.0552E+05, 2.0602E+05, 2.0651E+05, 2.0701E+05, 2.0750E+05, &
       2.0800E+05, 2.0850E+05, 2.0900E+05, 2.0950E+05, 2.1000E+05, 2.1051E+05, 2.1101E+05, 2.1152E+05, 2.1202E+05, 2.1253E+05, &
       2.1304E+05, 2.1354E+05, 2.1405E+05, 2.1456E+05, 2.1507E+05, 2.1559E+05, 2.1610E+05, 2.1661E+05, 2.1713E+05, 2.1764E+05, &
       2.1816E+05, 2.1868E+05, 2.1920E+05, 2.1972E+05, 2.2024E+05, 2.2076E+05, 2.2128E+05, 2.2181E+05, 2.2233E+05, 2.2286E+05, &
       2.2338E+05, 2.2391E+05, 2.2444E+05, 2.2497E+05, 2.2550E+05, 2.2603E+05, 2.2656E+05, 2.2710E+05, 2.2763E+05, 2.2817E+05, &
       2.2870E+05, 2.2924E+05, 2.2978E+05, 2.3032E+05, 2.3086E+05, 2.3140E+05, 2.3194E+05, 2.3249E+05, 2.3303E+05, 2.3357E+05, &
       2.3412E+05, 2.3467E+05, 2.3522E+05, 2.3577E+05, 2.3632E+05, 2.3687E+05, 2.3742E+05, 2.3797E+05, 2.3853E+05, 2.3908E+05, &
       2.3964E+05, 2.4019E+05, 2.4075E+05, 2.4131E+05, 2.4187E+05, 2.4243E+05, 2.4299E+05, 2.4356E+05, 2.4412E+05, 2.4469E+05, &
       2.4525E+05, 2.4582E+05, 2.4639E+05, 2.4696E+05, 2.4753E+05, 2.4810E+05, 2.4867E+05, 2.4925E+05, 2.4982E+05, 2.5040E+05, &
       2.5097E+05, 2.5155E+05, 2.5213E+05, 2.5271E+05, 2.5329E+05, 2.5387E+05, 2.5445E+05, 2.5504E+05, 2.5562E+05, 2.5621E+05, &
       2.5679E+05, 2.5738E+05, 2.5797E+05, 2.5856E+05, 2.5915E+05, 2.5974E+05, 2.6034E+05, 2.6093E+05, 2.6152E+05, 2.6212E+05, &
       2.6272E+05, 2.6332E+05, 2.6392E+05, 2.6452E+05, 2.6512E+05, 2.6572E+05, 2.6632E+05, 2.6693E+05, 2.6753E+05, 2.6814E+05, &
       2.6875E+05, 2.6936E+05, 2.6997E+05, 2.7058E+05, 2.7119E+05, 2.7180E+05, 2.7242E+05, 2.7303E+05, 2.7365E+05, 2.7427E+05, &
       2.7489E+05, 2.7550E+05, 2.7613E+05, 2.7675E+05, 2.7737E+05, 2.7799E+05, 2.7862E+05, 2.7924E+05, 2.7987E+05, 2.8050E+05, &
       2.8113E+05, 2.8176E+05, 2.8239E+05, 2.8302E+05, 2.8366E+05, 2.8429E+05, 2.8493E+05, 2.8557E+05, 2.8620E+05, 2.8684E+05, &
       2.8748E+05, 2.8812E+05, 2.8877E+05, 2.8941E+05, 2.9006E+05, 2.9070E+05, 2.9135E+05, 2.9200E+05, 2.9264E+05, 2.9330E+05, &
       2.9395E+05, 2.9460E+05, 2.9525E+05, 2.9591E+05, 2.9656E+05, 2.9722E+05, 2.9788E+05, 2.9854E+05, 2.9920E+05, 2.9986E+05, &
       3.0052E+05, 3.0118E+05, 3.0185E+05, 3.0252E+05, 3.0318E+05, 3.0385E+05, 3.0452E+05, 3.0519E+05, 3.0586E+05, 3.0653E+05, &
       3.0721E+05, 3.0788E+05, 3.0856E+05, 3.0924E+05, 3.0992E+05, 3.1060E+05, 3.1128E+05, 3.1196E+05, 3.1264E+05, 3.1332E+05, &
       3.1401E+05, 3.1470E+05, 3.1538E+05, 3.1607E+05, 3.1676E+05, 3.1745E+05, 3.1815E+05, 3.1884E+05, 3.1953E+05, 3.2023E+05, &
       3.2093E+05, 3.2162E+05, 3.2232E+05, 3.2302E+05, 3.2373E+05, 3.2443E+05, 3.2513E+05, 3.2584E+05, 3.2654E+05, 3.2725E+05, &
       3.2796E+05, 3.2867E+05, 3.2938E+05, 3.3009E+05, 3.3081E+05, 3.3152E+05, 3.3224E+05, 3.3295E+05, 3.3367E+05, 3.3439E+05, &
       3.3511E+05, 3.3583E+05, 3.3655E+05, 3.3728E+05, 3.3800E+05, 3.3873E+05, 3.3946E+05, 3.4019E+05, 3.4092E+05, 3.4165E+05, &
       3.4238E+05, 3.4311E+05, 3.4385E+05, 3.4458E+05, 3.4532E+05, 3.4606E+05, 3.4680E+05, 3.4754E+05, 3.4828E+05, 3.4902E+05, &
       3.4977E+05, 3.5051E+05, 3.5126E+05, 3.5201E+05, 3.5276E+05, 3.5351E+05, 3.5426E+05, 3.5501E+05, 3.5577E+05, 3.5652E+05, &
       3.5728E+05, 3.5804E+05, 3.5880E+05, 3.5956E+05, 3.6032E+05, 3.6108E+05, 3.6184E+05, 3.6261E+05, 3.6337E+05, 3.6414E+05, &
       3.6491E+05, 3.6568E+05, 3.6645E+05, 3.6723E+05, 3.6800E+05, 3.6877E+05, 3.6955E+05, 3.7033E+05, 3.7111E+05, 3.7189E+05, &
       3.7267E+05, 3.7345E+05, 3.7423E+05, 3.7502E+05, 3.7581E+05, 3.7659E+05, 3.7738E+05, 3.7817E+05, 3.7896E+05, 3.7976E+05, &
       3.8055E+05, 3.8135E+05, 3.8214E+05, 3.8294E+05, 3.8374E+05, 3.8454E+05, 3.8534E+05, 3.8614E+05, 3.8695E+05, 3.8775E+05, &
       3.8856E+05, 3.8937E+05, 3.9017E+05, 3.9099E+05, 3.9180E+05, 3.9261E+05, 3.9342E+05, 3.9424E+05, 3.9506E+05, 3.9587E+05, &
       3.9669E+05, 3.9751E+05, 3.9834E+05, 3.9916E+05, 3.9998E+05, 4.0081E+05, 4.0164E+05, 4.0247E+05, 4.0329E+05, 4.0413E+05, &
       4.0496E+05, 4.0579E+05, 4.0663E+05, 4.0746E+05, 4.0830E+05, 4.0914E+05, 4.0998E+05, 4.1082E+05, 4.1166E+05, 4.1251E+05, &
       4.1335E+05, 4.1420E+05, 4.1505E+05, 4.1590E+05, 4.1675E+05, 4.1760E+05, 4.1845E+05, 4.1931E+05, 4.2016E+05, 4.2102E+05, &
       4.2188E+05, 4.2274E+05, 4.2360E+05, 4.2446E+05, 4.2533E+05, 4.2619E+05, 4.2706E+05, 4.2792E+05, 4.2879E+05, 4.2966E+05, &
       4.3054E+05, 4.3141E+05, 4.3228E+05, 4.3316E+05, 4.3404E+05, 4.3491E+05, 4.3579E+05, 4.3668E+05, 4.3756E+05, 4.3844E+05, &
       4.3933E+05, 4.4021E+05, 4.4110E+05, 4.4199E+05, 4.4288E+05, 4.4377E+05, 4.4467E+05, 4.4556E+05, 4.4646E+05, 4.4736E+05, &
       4.4825E+05, 4.4915E+05, 4.5006E+05, 4.5096E+05, 4.5186E+05, 4.5277E+05, 4.5368E+05, 4.5458E+05, 4.5549E+05, 4.5640E+05, &
       4.5732E+05, 4.5823E+05, 4.5915E+05, 4.6006E+05, 4.6098E+05, 4.6190E+05, 4.6282E+05, 4.6374E+05, 4.6467E+05, 4.6559E+05, &
       4.6652E+05, 4.6744E+05, 4.6837E+05, 4.6930E+05, 4.7024E+05, 4.7117E+05, 4.7210E+05, 4.7304E+05, 4.7398E+05, 4.7492E+05, &
       4.7586E+05, 4.7680E+05, 4.7774E+05, 4.7869E+05, 4.7963E+05, 4.8058E+05, 4.8153E+05, 4.8248E+05, 4.8343E+05, 4.8438E+05, &
       4.8534E+05, 4.8629E+05, 4.8725E+05, 4.8821E+05, 4.8917E+05, 4.9013E+05, 4.9109E+05, 4.9205E+05, 4.9302E+05, 4.9399E+05, &
       4.9495E+05, 4.9592E+05, 4.9690E+05, 4.9787E+05, 4.9884E+05, 4.9982E+05, 5.0079E+05, 5.0177E+05, 5.0275E+05, 5.0373E+05, &
       5.0472E+05, 5.0570E+05, 5.0669E+05, 5.0767E+05, 5.0866E+05, 5.0965E+05, 5.1064E+05, 5.1164E+05, 5.1263E+05, 5.1363E+05, &
       5.1462E+05, 5.1562E+05, 5.1662E+05, 5.1762E+05, 5.1863E+05, 5.1963E+05, 5.2064E+05, 5.2164E+05, 5.2265E+05, 5.2366E+05, &
       5.2467E+05, 5.2569E+05, 5.2670E+05, 5.2772E+05, 5.2873E+05, 5.2975E+05, 5.3077E+05, 5.3180E+05, 5.3282E+05, 5.3384E+05, &
       5.3487E+05, 5.3590E+05, 5.3693E+05, 5.3796E+05, 5.3899E+05, 5.4002E+05, 5.4106E+05, 5.4209E+05, 5.4313E+05, 5.4417E+05, &
       5.4521E+05, 5.4626E+05, 5.4730E+05, 5.4834E+05, 5.4939E+05, 5.5044E+05, 5.5149E+05, 5.5254E+05, 5.5359E+05, 5.5465E+05, &
       5.5570E+05, 5.5676E+05, 5.5782E+05, 5.5888E+05, 5.5994E+05, 5.6101E+05, 5.6207E+05, 5.6314E+05, 5.6421E+05, 5.6528E+05, &
       5.6635E+05, 5.6742E+05, 5.6849E+05, 5.6957E+05, 5.7065E+05, 5.7172E+05, 5.7280E+05, 5.7389E+05, 5.7497E+05, 5.7605E+05, &
       5.7714E+05, 5.7823E+05, 5.7932E+05, 5.8041E+05, 5.8150E+05, 5.8259E+05, 5.8369E+05, 5.8478E+05, 5.8588E+05, 5.8698E+05, &
       5.8808E+05, 5.8919E+05, 5.9029E+05, 5.9140E+05, 5.9250E+05, 5.9361E+05, 5.9472E+05, 5.9583E+05, 5.9695E+05, 5.9806E+05, &
       5.9918E+05, 6.0030E+05, 6.0142E+05, 6.0254E+05, 6.0366E+05, 6.0479E+05, 6.0591E+05, 6.0704E+05, 6.0817E+05, 6.0930E+05, &
       6.1043E+05, 6.1157E+05, 6.1270E+05, 6.1384E+05, 6.1498E+05, 6.1612E+05, 6.1726E+05, 6.1840E+05, 6.1955E+05, 6.2069E+05, &
       6.2184E+05, 6.2299E+05, 6.2414E+05, 6.2529E+05, 6.2645E+05, 6.2760E+05, 6.2876E+05, 6.2992E+05, 6.3108E+05, 6.3224E+05, &
       6.3340E+05, 6.3457E+05, 6.3573E+05, 6.3690E+05, 6.3807E+05, 6.3924E+05, 6.4042E+05, 6.4159E+05, 6.4277E+05, 6.4395E+05, &
       6.4512E+05, 6.4631E+05, 6.4749E+05, 6.4867E+05, 6.4986E+05, 6.5104E+05, 6.5223E+05, 6.5342E+05, 6.5462E+05, 6.5581E+05, &
       6.5701E+05, 6.5820E+05, 6.5940E+05, 6.6060E+05, 6.6180E+05, 6.6301E+05, 6.6421E+05, 6.6542E+05, 6.6663E+05, 6.6783E+05, &
       6.6905E+05, 6.7026E+05, 6.7147E+05, 6.7269E+05, 6.7391E+05, 6.7513E+05, 6.7635E+05, 6.7757E+05, 6.7879E+05, 6.8002E+05, &
       6.8125E+05, 6.8248E+05, 6.8371E+05, 6.8494E+05, 6.8617E+05, 6.8741E+05, 6.8865E+05, 6.8989E+05, 6.9113E+05, 6.9237E+05, &
       6.9361E+05, 6.9486E+05, 6.9611E+05, 6.9735E+05, 6.9860E+05, 6.9986E+05, 7.0111E+05, 7.0237E+05, 7.0362E+05, 7.0488E+05, &
       7.0614E+05, 7.0740E+05, 7.0867E+05, 7.0993E+05, 7.1120E+05, 7.1247E+05, 7.1374E+05, 7.1501E+05, 7.1628E+05, 7.1756E+05, &
       7.1883E+05, 7.2011E+05, 7.2139E+05, 7.2267E+05, 7.2396E+05, 7.2524E+05, 7.2653E+05, 7.2782E+05, 7.2911E+05, 7.3040E+05, &
       7.3169E+05, 7.3299E+05, 7.3428E+05, 7.3558E+05, 7.3688E+05, 7.3818E+05, 7.3949E+05, 7.4079E+05, 7.4210E+05, 7.4341E+05, &
       7.4472E+05, 7.4603E+05, 7.4734E+05, 7.4866E+05, 7.4998E+05, 7.5129E+05, 7.5261E+05, 7.5394E+05, 7.5526E+05, 7.5659E+05, &
       7.5791E+05, 7.5924E+05, 7.6057E+05, 7.6190E+05, 7.6324E+05, 7.6457E+05, 7.6591E+05, 7.6725E+05, 7.6859E+05, 7.6993E+05, &
       7.7128E+05, 7.7262E+05, 7.7397E+05, 7.7532E+05, 7.7667E+05, 7.7802E+05, 7.7938E+05, 7.8073E+05, 7.8209E+05, 7.8345E+05, &
       7.8481E+05, 7.8617E+05, 7.8754E+05, 7.8890E+05, 7.9027E+05, 7.9164E+05, 7.9301E+05, 7.9438E+05, 7.9576E+05, 7.9714E+05, &
       7.9851E+05, 7.9989E+05, 8.0128E+05, 8.0266E+05, 8.0404E+05, 8.0543E+05, 8.0682E+05, 8.0821E+05, 8.0960E+05, 8.1100E+05, &
       8.1239E+05, 8.1379E+05, 8.1519E+05, 8.1659E+05, 8.1799E+05, 8.1939E+05, 8.2080E+05, 8.2221E+05, 8.2362E+05, 8.2503E+05, &
       8.2644E+05, 8.2786E+05, 8.2927E+05, 8.3069E+05, 8.3211E+05, 8.3353E+05, 8.3496E+05, 8.3638E+05, 8.3781E+05, 8.3924E+05, &
       8.4067E+05, 8.4210E+05, 8.4353E+05, 8.4497E+05, 8.4641E+05, 8.4785E+05, 8.4929E+05, 8.5073E+05, 8.5217E+05, 8.5362E+05, &
       8.5507E+05, 8.5652E+05, 8.5797E+05, 8.5942E+05, 8.6088E+05, 8.6233E+05, 8.6379E+05, 8.6525E+05, 8.6672E+05, 8.6818E+05, &
       8.6965E+05, 8.7111E+05, 8.7258E+05, 8.7405E+05, 8.7553E+05, 8.7700E+05, 8.7848E+05, 8.7996E+05, 8.8144E+05, 8.8292E+05, &
       8.8440E+05, 8.8589E+05, 8.8737E+05, 8.8886E+05, 8.9035E+05, 8.9185E+05, 8.9334E+05, 8.9484E+05, 8.9633E+05, 8.9783E+05/
      data (QofT( 7,J),J=2409,4510)/ 8.9934E+05, 9.0084E+05, 9.0234E+05, 9.0385E+05, 9.0536E+05, 9.0687E+05, 9.0838E+05, 9.0990E+05, &
       9.1141E+05, 9.1293E+05, 9.1445E+05, 9.1597E+05, 9.1749E+05, 9.1902E+05, 9.2055E+05, 9.2207E+05, 9.2361E+05, 9.2514E+05, &
       9.2667E+05, 9.2821E+05, 9.2975E+05, 9.3128E+05, 9.3283E+05, 9.3437E+05, 9.3591E+05, 9.3746E+05, 9.3901E+05, 9.4056E+05, &
       9.4211E+05, 9.4367E+05, 9.4522E+05, 9.4678E+05, 9.4834E+05, 9.4990E+05, 9.5146E+05, 9.5303E+05, 9.5460E+05, 9.5616E+05, &
       9.5774E+05, 9.5931E+05, 9.6088E+05, 9.6246E+05, 9.6404E+05, 9.6562E+05, 9.6720E+05, 9.6878E+05, 9.7037E+05, 9.7195E+05, &
       9.7354E+05, 9.7513E+05, 9.7673E+05, 9.7832E+05, 9.7992E+05, 9.8151E+05, 9.8311E+05, 9.8472E+05, 9.8632E+05, 9.8793E+05, &
       9.8953E+05, 9.9114E+05, 9.9275E+05, 9.9437E+05, 9.9598E+05, 9.9760E+05, 9.9922E+05, 1.0008E+06, 1.0025E+06, 1.0041E+06, &
       1.0057E+06, 1.0073E+06, 1.0090E+06, 1.0106E+06, 1.0122E+06, 1.0139E+06, 1.0155E+06, 1.0171E+06, 1.0188E+06, 1.0204E+06, &
       1.0221E+06, 1.0237E+06, 1.0254E+06, 1.0270E+06, 1.0287E+06, 1.0303E+06, 1.0320E+06, 1.0336E+06, 1.0353E+06, 1.0370E+06, &
       1.0386E+06, 1.0403E+06, 1.0420E+06, 1.0436E+06, 1.0453E+06, 1.0470E+06, 1.0486E+06, 1.0503E+06, 1.0520E+06, 1.0537E+06, &
       1.0554E+06, 1.0571E+06, 1.0587E+06, 1.0604E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
!...        --       728
      data (QofT( 8,J),J=1,2408)/ 1.3912E+01, 2.5475E+01, 3.7121E+01, 4.8786E+01, 6.0459E+01, 7.2136E+01, 8.3814E+01, 9.5494E+01, &
       1.0718E+02, 1.1886E+02, 1.3054E+02, 1.4222E+02, 1.5390E+02, 1.6559E+02, 1.7727E+02, 1.8895E+02, 2.0063E+02, 2.1232E+02, &
       2.2400E+02, 2.3569E+02, 2.5905E+02, 2.8242E+02, 3.0579E+02, 3.2916E+02, 3.5252E+02, 3.7589E+02, 3.9926E+02, 4.2263E+02, &
       4.4600E+02, 4.6937E+02, 4.9274E+02, 5.1610E+02, 5.3947E+02, 5.6284E+02, 5.8621E+02, 6.0958E+02, 6.3295E+02, 6.5632E+02, &
       6.7969E+02, 7.0306E+02, 7.2643E+02, 7.4980E+02, 7.7317E+02, 7.9655E+02, 8.1992E+02, 8.4329E+02, 8.6666E+02, 8.9004E+02, &
       9.1341E+02, 9.3678E+02, 9.6016E+02, 9.8354E+02, 1.0069E+03, 1.0303E+03, 1.0537E+03, 1.0771E+03, 1.1005E+03, 1.1239E+03, &
       1.1473E+03, 1.1707E+03, 1.1941E+03, 1.2175E+03, 1.2409E+03, 1.2644E+03, 1.2878E+03, 1.3113E+03, 1.3347E+03, 1.3582E+03, &
       1.3817E+03, 1.4052E+03, 1.4288E+03, 1.4523E+03, 1.4759E+03, 1.4995E+03, 1.5231E+03, 1.5468E+03, 1.5705E+03, 1.5942E+03, &
       1.6179E+03, 1.6417E+03, 1.6655E+03, 1.6893E+03, 1.7132E+03, 1.7371E+03, 1.7611E+03, 1.7851E+03, 1.8092E+03, 1.8333E+03, &
       1.8574E+03, 1.8817E+03, 1.9059E+03, 1.9303E+03, 1.9546E+03, 1.9791E+03, 2.0036E+03, 2.0282E+03, 2.0528E+03, 2.0776E+03, &
       2.1023E+03, 2.1272E+03, 2.1522E+03, 2.1772E+03, 2.2023E+03, 2.2275E+03, 2.2528E+03, 2.2781E+03, 2.3036E+03, 2.3291E+03, &
       2.3548E+03, 2.3805E+03, 2.4063E+03, 2.4323E+03, 2.4583E+03, 2.4845E+03, 2.5107E+03, 2.5371E+03, 2.5635E+03, 2.5901E+03, &
       2.6168E+03, 2.6436E+03, 2.6706E+03, 2.6976E+03, 2.7248E+03, 2.7521E+03, 2.7795E+03, 2.8070E+03, 2.8347E+03, 2.8625E+03, &
       2.8905E+03, 2.9186E+03, 2.9468E+03, 2.9751E+03, 3.0036E+03, 3.0323E+03, 3.0610E+03, 3.0900E+03, 3.1190E+03, 3.1483E+03, &
       3.1776E+03, 3.2072E+03, 3.2368E+03, 3.2667E+03, 3.2967E+03, 3.3268E+03, 3.3571E+03, 3.3876E+03, 3.4183E+03, 3.4491E+03, &
       3.4800E+03, 3.5112E+03, 3.5425E+03, 3.5740E+03, 3.6056E+03, 3.6375E+03, 3.6695E+03, 3.7017E+03, 3.7340E+03, 3.7666E+03, &
       3.7993E+03, 3.8322E+03, 3.8653E+03, 3.8986E+03, 3.9321E+03, 3.9658E+03, 3.9996E+03, 4.0337E+03, 4.0679E+03, 4.1024E+03, &
       4.1370E+03, 4.1719E+03, 4.2069E+03, 4.2421E+03, 4.2776E+03, 4.3132E+03, 4.3491E+03, 4.3852E+03, 4.4215E+03, 4.4579E+03, &
       4.4946E+03, 4.5316E+03, 4.5687E+03, 4.6060E+03, 4.6436E+03, 4.6814E+03, 4.7194E+03, 4.7576E+03, 4.7961E+03, 4.8348E+03, &
       4.8737E+03, 4.9128E+03, 4.9522E+03, 4.9917E+03, 5.0316E+03, 5.0716E+03, 5.1119E+03, 5.1525E+03, 5.1932E+03, 5.2342E+03, &
       5.2755E+03, 5.3170E+03, 5.3587E+03, 5.4007E+03, 5.4429E+03, 5.4854E+03, 5.5281E+03, 5.5711E+03, 5.6144E+03, 5.6578E+03, &
       5.7016E+03, 5.7456E+03, 5.7898E+03, 5.8344E+03, 5.8791E+03, 5.9242E+03, 5.9695E+03, 6.0150E+03, 6.0609E+03, 6.1070E+03, &
       6.1533E+03, 6.2000E+03, 6.2469E+03, 6.2941E+03, 6.3416E+03, 6.3893E+03, 6.4373E+03, 6.4856E+03, 6.5342E+03, 6.5831E+03, &
       6.6322E+03, 6.6817E+03, 6.7314E+03, 6.7814E+03, 6.8317E+03, 6.8823E+03, 6.9332E+03, 6.9844E+03, 7.0359E+03, 7.0876E+03, &
       7.1397E+03, 7.1921E+03, 7.2448E+03, 7.2978E+03, 7.3510E+03, 7.4046E+03, 7.4585E+03, 7.5128E+03, 7.5673E+03, 7.6221E+03, &
       7.6773E+03, 7.7327E+03, 7.7885E+03, 7.8446E+03, 7.9011E+03, 7.9578E+03, 8.0149E+03, 8.0723E+03, 8.1300E+03, 8.1881E+03, &
       8.2464E+03, 8.3052E+03, 8.3642E+03, 8.4236E+03, 8.4833E+03, 8.5434E+03, 8.6038E+03, 8.6645E+03, 8.7256E+03, 8.7870E+03, &
       8.8488E+03, 8.9109E+03, 8.9734E+03, 9.0362E+03, 9.0994E+03, 9.1629E+03, 9.2268E+03, 9.2910E+03, 9.3556E+03, 9.4206E+03, &
       9.4859E+03, 9.5516E+03, 9.6176E+03, 9.6840E+03, 9.7508E+03, 9.8180E+03, 9.8855E+03, 9.9534E+03, 1.0022E+04, 1.0090E+04, &
       1.0159E+04, 1.0229E+04, 1.0299E+04, 1.0369E+04, 1.0439E+04, 1.0510E+04, 1.0582E+04, 1.0653E+04, 1.0726E+04, 1.0798E+04, &
       1.0871E+04, 1.0944E+04, 1.1018E+04, 1.1092E+04, 1.1167E+04, 1.1242E+04, 1.1317E+04, 1.1393E+04, 1.1469E+04, 1.1545E+04, &
       1.1622E+04, 1.1700E+04, 1.1778E+04, 1.1856E+04, 1.1935E+04, 1.2014E+04, 1.2093E+04, 1.2173E+04, 1.2254E+04, 1.2334E+04, &
       1.2416E+04, 1.2497E+04, 1.2579E+04, 1.2662E+04, 1.2745E+04, 1.2828E+04, 1.2912E+04, 1.2996E+04, 1.3081E+04, 1.3166E+04, &
       1.3252E+04, 1.3338E+04, 1.3425E+04, 1.3512E+04, 1.3599E+04, 1.3687E+04, 1.3776E+04, 1.3865E+04, 1.3954E+04, 1.4044E+04, &
       1.4134E+04, 1.4225E+04, 1.4316E+04, 1.4408E+04, 1.4500E+04, 1.4593E+04, 1.4686E+04, 1.4779E+04, 1.4874E+04, 1.4968E+04, &
       1.5063E+04, 1.5159E+04, 1.5255E+04, 1.5352E+04, 1.5449E+04, 1.5546E+04, 1.5644E+04, 1.5743E+04, 1.5842E+04, 1.5942E+04, &
       1.6042E+04, 1.6142E+04, 1.6244E+04, 1.6345E+04, 1.6447E+04, 1.6550E+04, 1.6653E+04, 1.6757E+04, 1.6862E+04, 1.6966E+04, &
       1.7072E+04, 1.7178E+04, 1.7284E+04, 1.7391E+04, 1.7499E+04, 1.7607E+04, 1.7715E+04, 1.7824E+04, 1.7934E+04, 1.8044E+04, &
       1.8155E+04, 1.8266E+04, 1.8378E+04, 1.8491E+04, 1.8604E+04, 1.8718E+04, 1.8832E+04, 1.8946E+04, 1.9062E+04, 1.9178E+04, &
       1.9294E+04, 1.9411E+04, 1.9529E+04, 1.9647E+04, 1.9766E+04, 1.9885E+04, 2.0005E+04, 2.0126E+04, 2.0247E+04, 2.0369E+04, &
       2.0491E+04, 2.0614E+04, 2.0738E+04, 2.0862E+04, 2.0987E+04, 2.1112E+04, 2.1238E+04, 2.1365E+04, 2.1492E+04, 2.1620E+04, &
       2.1748E+04, 2.1877E+04, 2.2007E+04, 2.2138E+04, 2.2269E+04, 2.2400E+04, 2.2532E+04, 2.2665E+04, 2.2799E+04, 2.2933E+04, &
       2.3068E+04, 2.3204E+04, 2.3340E+04, 2.3476E+04, 2.3614E+04, 2.3752E+04, 2.3891E+04, 2.4030E+04, 2.4170E+04, 2.4311E+04, &
       2.4453E+04, 2.4595E+04, 2.4738E+04, 2.4881E+04, 2.5025E+04, 2.5170E+04, 2.5316E+04, 2.5462E+04, 2.5609E+04, 2.5757E+04, &
       2.5905E+04, 2.6054E+04, 2.6204E+04, 2.6354E+04, 2.6505E+04, 2.6657E+04, 2.6810E+04, 2.6963E+04, 2.7117E+04, 2.7272E+04, &
       2.7427E+04, 2.7583E+04, 2.7740E+04, 2.7898E+04, 2.8056E+04, 2.8215E+04, 2.8375E+04, 2.8536E+04, 2.8697E+04, 2.8859E+04, &
       2.9022E+04, 2.9186E+04, 2.9350E+04, 2.9515E+04, 2.9681E+04, 2.9847E+04, 3.0015E+04, 3.0183E+04, 3.0352E+04, 3.0522E+04, &
       3.0692E+04, 3.0863E+04, 3.1035E+04, 3.1208E+04, 3.1382E+04, 3.1556E+04, 3.1732E+04, 3.1908E+04, 3.2084E+04, 3.2262E+04, &
       3.2440E+04, 3.2620E+04, 3.2800E+04, 3.2980E+04, 3.3162E+04, 3.3345E+04, 3.3528E+04, 3.3712E+04, 3.3897E+04, 3.4083E+04, &
       3.4270E+04, 3.4457E+04, 3.4645E+04, 3.4834E+04, 3.5025E+04, 3.5215E+04, 3.5407E+04, 3.5600E+04, 3.5793E+04, 3.5987E+04, &
       3.6183E+04, 3.6379E+04, 3.6575E+04, 3.6773E+04, 3.6972E+04, 3.7171E+04, 3.7372E+04, 3.7573E+04, 3.7775E+04, 3.7978E+04, &
       3.8182E+04, 3.8387E+04, 3.8593E+04, 3.8800E+04, 3.9007E+04, 3.9216E+04, 3.9425E+04, 3.9635E+04, 3.9847E+04, 4.0059E+04, &
       4.0272E+04, 4.0486E+04, 4.0701E+04, 4.0917E+04, 4.1133E+04, 4.1351E+04, 4.1570E+04, 4.1789E+04, 4.2010E+04, 4.2232E+04, &
       4.2454E+04, 4.2678E+04, 4.2902E+04, 4.3127E+04, 4.3354E+04, 4.3581E+04, 4.3810E+04, 4.4039E+04, 4.4269E+04, 4.4500E+04, &
       4.4733E+04, 4.4966E+04, 4.5200E+04, 4.5435E+04, 4.5672E+04, 4.5909E+04, 4.6147E+04, 4.6386E+04, 4.6627E+04, 4.6868E+04, &
       4.7110E+04, 4.7354E+04, 4.7598E+04, 4.7844E+04, 4.8090E+04, 4.8338E+04, 4.8586E+04, 4.8836E+04, 4.9086E+04, 4.9338E+04, &
       4.9591E+04, 4.9845E+04, 5.0100E+04, 5.0356E+04, 5.0613E+04, 5.0871E+04, 5.1130E+04, 5.1390E+04, 5.1651E+04, 5.1914E+04, &
       5.2177E+04, 5.2442E+04, 5.2708E+04, 5.2975E+04, 5.3242E+04, 5.3512E+04, 5.3782E+04, 5.4053E+04, 5.4325E+04, 5.4599E+04, &
       5.4873E+04, 5.5149E+04, 5.5426E+04, 5.5704E+04, 5.5983E+04, 5.6264E+04, 5.6545E+04, 5.6828E+04, 5.7112E+04, 5.7396E+04, &
       5.7683E+04, 5.7970E+04, 5.8258E+04, 5.8548E+04, 5.8839E+04, 5.9131E+04, 5.9424E+04, 5.9718E+04, 6.0014E+04, 6.0310E+04, &
       6.0608E+04, 6.0908E+04, 6.1208E+04, 6.1509E+04, 6.1812E+04, 6.2116E+04, 6.2421E+04, 6.2728E+04, 6.3036E+04, 6.3345E+04, &
       6.3655E+04, 6.3966E+04, 6.4279E+04, 6.4593E+04, 6.4908E+04, 6.5224E+04, 6.5542E+04, 6.5861E+04, 6.6181E+04, 6.6502E+04, &
       6.6825E+04, 6.7149E+04, 6.7474E+04, 6.7801E+04, 6.8129E+04, 6.8458E+04, 6.8789E+04, 6.9120E+04, 6.9454E+04, 6.9788E+04, &
       7.0124E+04, 7.0461E+04, 7.0799E+04, 7.1139E+04, 7.1480E+04, 7.1822E+04, 7.2166E+04, 7.2511E+04, 7.2857E+04, 7.3205E+04, &
       7.3554E+04, 7.3905E+04, 7.4257E+04, 7.4610E+04, 7.4964E+04, 7.5320E+04, 7.5678E+04, 7.6036E+04, 7.6396E+04, 7.6758E+04, &
       7.7121E+04, 7.7485E+04, 7.7851E+04, 7.8218E+04, 7.8587E+04, 7.8957E+04, 7.9328E+04, 7.9701E+04, 8.0075E+04, 8.0451E+04, &
       8.0828E+04, 8.1206E+04, 8.1586E+04, 8.1968E+04, 8.2351E+04, 8.2735E+04, 8.3121E+04, 8.3508E+04, 8.3897E+04, 8.4287E+04, &
       8.4679E+04, 8.5072E+04, 8.5467E+04, 8.5863E+04, 8.6261E+04, 8.6660E+04, 8.7061E+04, 8.7463E+04, 8.7867E+04, 8.8272E+04, &
       8.8679E+04, 8.9087E+04, 8.9497E+04, 8.9908E+04, 9.0321E+04, 9.0736E+04, 9.1152E+04, 9.1569E+04, 9.1988E+04, 9.2409E+04, &
       9.2831E+04, 9.3255E+04, 9.3681E+04, 9.4108E+04, 9.4536E+04, 9.4967E+04, 9.5398E+04, 9.5832E+04, 9.6267E+04, 9.6703E+04, &
       9.7142E+04, 9.7581E+04, 9.8023E+04, 9.8466E+04, 9.8911E+04, 9.9357E+04, 9.9805E+04, 1.0025E+05, 1.0071E+05, 1.0116E+05, &
       1.0161E+05, 1.0207E+05, 1.0253E+05, 1.0299E+05, 1.0345E+05, 1.0391E+05, 1.0438E+05, 1.0484E+05, 1.0531E+05, 1.0578E+05, &
       1.0625E+05, 1.0673E+05, 1.0720E+05, 1.0768E+05, 1.0816E+05, 1.0864E+05, 1.0912E+05, 1.0960E+05, 1.1009E+05, 1.1057E+05, &
       1.1106E+05, 1.1155E+05, 1.1205E+05, 1.1254E+05, 1.1304E+05, 1.1353E+05, 1.1403E+05, 1.1453E+05, 1.1504E+05, 1.1554E+05, &
       1.1605E+05, 1.1656E+05, 1.1707E+05, 1.1758E+05, 1.1809E+05, 1.1861E+05, 1.1913E+05, 1.1965E+05, 1.2017E+05, 1.2069E+05, &
       1.2122E+05, 1.2174E+05, 1.2227E+05, 1.2280E+05, 1.2333E+05, 1.2387E+05, 1.2440E+05, 1.2494E+05, 1.2548E+05, 1.2602E+05, &
       1.2657E+05, 1.2711E+05, 1.2766E+05, 1.2821E+05, 1.2876E+05, 1.2932E+05, 1.2987E+05, 1.3043E+05, 1.3099E+05, 1.3155E+05, &
       1.3211E+05, 1.3268E+05, 1.3324E+05, 1.3381E+05, 1.3438E+05, 1.3496E+05, 1.3553E+05, 1.3611E+05, 1.3669E+05, 1.3727E+05, &
       1.3785E+05, 1.3844E+05, 1.3902E+05, 1.3961E+05, 1.4020E+05, 1.4080E+05, 1.4139E+05, 1.4199E+05, 1.4259E+05, 1.4319E+05, &
       1.4379E+05, 1.4440E+05, 1.4501E+05, 1.4562E+05, 1.4623E+05, 1.4684E+05, 1.4746E+05, 1.4807E+05, 1.4869E+05, 1.4932E+05, &
       1.4994E+05, 1.5057E+05, 1.5120E+05, 1.5183E+05, 1.5246E+05, 1.5309E+05, 1.5373E+05, 1.5437E+05, 1.5501E+05, 1.5565E+05, &
       1.5630E+05, 1.5695E+05, 1.5760E+05, 1.5825E+05, 1.5890E+05, 1.5956E+05, 1.6022E+05, 1.6088E+05, 1.6154E+05, 1.6221E+05, &
       1.6288E+05, 1.6355E+05, 1.6422E+05, 1.6489E+05, 1.6557E+05, 1.6625E+05, 1.6693E+05, 1.6761E+05, 1.6830E+05, 1.6899E+05, &
       1.6968E+05, 1.7037E+05, 1.7106E+05, 1.7176E+05, 1.7246E+05, 1.7316E+05, 1.7387E+05, 1.7457E+05, 1.7528E+05, 1.7599E+05, &
       1.7671E+05, 1.7742E+05, 1.7814E+05, 1.7886E+05, 1.7958E+05, 1.8031E+05, 1.8104E+05, 1.8177E+05, 1.8250E+05, 1.8323E+05, &
       1.8397E+05, 1.8471E+05, 1.8545E+05, 1.8619E+05, 1.8694E+05, 1.8769E+05, 1.8844E+05, 1.8920E+05, 1.8995E+05, 1.9071E+05, &
       1.9147E+05, 1.9224E+05, 1.9300E+05, 1.9377E+05, 1.9454E+05, 1.9532E+05, 1.9609E+05, 1.9687E+05, 1.9765E+05, 1.9844E+05, &
       1.9922E+05, 2.0001E+05, 2.0080E+05, 2.0160E+05, 2.0239E+05, 2.0319E+05, 2.0399E+05, 2.0480E+05, 2.0560E+05, 2.0641E+05, &
       2.0722E+05, 2.0804E+05, 2.0885E+05, 2.0967E+05, 2.1050E+05, 2.1132E+05, 2.1215E+05, 2.1298E+05, 2.1381E+05, 2.1464E+05, &
       2.1548E+05, 2.1632E+05, 2.1717E+05, 2.1801E+05, 2.1886E+05, 2.1971E+05, 2.2056E+05, 2.2142E+05, 2.2228E+05, 2.2314E+05, &
       2.2401E+05, 2.2487E+05, 2.2574E+05, 2.2662E+05, 2.2749E+05, 2.2837E+05, 2.2925E+05, 2.3013E+05, 2.3102E+05, 2.3191E+05, &
       2.3280E+05, 2.3370E+05, 2.3459E+05, 2.3549E+05, 2.3640E+05, 2.3730E+05, 2.3821E+05, 2.3912E+05, 2.4004E+05, 2.4095E+05, &
       2.4187E+05, 2.4279E+05, 2.4372E+05, 2.4465E+05, 2.4558E+05, 2.4651E+05, 2.4745E+05, 2.4839E+05, 2.4933E+05, 2.5028E+05, &
       2.5123E+05, 2.5218E+05, 2.5313E+05, 2.5409E+05, 2.5505E+05, 2.5601E+05, 2.5698E+05, 2.5795E+05, 2.5892E+05, 2.5989E+05, &
       2.6087E+05, 2.6185E+05, 2.6283E+05, 2.6382E+05, 2.6481E+05, 2.6580E+05, 2.6680E+05, 2.6780E+05, 2.6880E+05, 2.6980E+05, &
       2.7081E+05, 2.7182E+05, 2.7284E+05, 2.7385E+05, 2.7487E+05, 2.7589E+05, 2.7692E+05, 2.7795E+05, 2.7898E+05, 2.8002E+05, &
       2.8105E+05, 2.8210E+05, 2.8314E+05, 2.8419E+05, 2.8524E+05, 2.8629E+05, 2.8735E+05, 2.8841E+05, 2.8947E+05, 2.9054E+05, &
       2.9161E+05, 2.9268E+05, 2.9376E+05, 2.9484E+05, 2.9592E+05, 2.9700E+05, 2.9809E+05, 2.9918E+05, 3.0028E+05, 3.0138E+05, &
       3.0248E+05, 3.0358E+05, 3.0469E+05, 3.0580E+05, 3.0692E+05, 3.0803E+05, 3.0915E+05, 3.1028E+05, 3.1141E+05, 3.1254E+05, &
       3.1367E+05, 3.1481E+05, 3.1595E+05, 3.1709E+05, 3.1824E+05, 3.1939E+05, 3.2054E+05, 3.2170E+05, 3.2286E+05, 3.2403E+05, &
       3.2519E+05, 3.2636E+05, 3.2754E+05, 3.2872E+05, 3.2990E+05, 3.3108E+05, 3.3227E+05, 3.3346E+05, 3.3465E+05, 3.3585E+05, &
       3.3705E+05, 3.3826E+05, 3.3947E+05, 3.4068E+05, 3.4189E+05, 3.4311E+05, 3.4433E+05, 3.4556E+05, 3.4679E+05, 3.4802E+05, &
       3.4926E+05, 3.5050E+05, 3.5174E+05, 3.5299E+05, 3.5424E+05, 3.5549E+05, 3.5675E+05, 3.5801E+05, 3.5927E+05, 3.6054E+05, &
       3.6181E+05, 3.6309E+05, 3.6437E+05, 3.6565E+05, 3.6694E+05, 3.6823E+05, 3.6952E+05, 3.7082E+05, 3.7212E+05, 3.7342E+05, &
       3.7473E+05, 3.7604E+05, 3.7735E+05, 3.7867E+05, 3.8000E+05, 3.8132E+05, 3.8265E+05, 3.8399E+05, 3.8532E+05, 3.8666E+05, &
       3.8801E+05, 3.8936E+05, 3.9071E+05, 3.9207E+05, 3.9342E+05, 3.9479E+05, 3.9616E+05, 3.9753E+05, 3.9890E+05, 4.0028E+05, &
       4.0166E+05, 4.0305E+05, 4.0444E+05, 4.0583E+05, 4.0723E+05, 4.0863E+05, 4.1004E+05, 4.1145E+05, 4.1286E+05, 4.1428E+05, &
       4.1570E+05, 4.1712E+05, 4.1855E+05, 4.1998E+05, 4.2142E+05, 4.2286E+05, 4.2430E+05, 4.2575E+05, 4.2720E+05, 4.2866E+05, &
       4.3012E+05, 4.3158E+05, 4.3305E+05, 4.3452E+05, 4.3600E+05, 4.3748E+05, 4.3896E+05, 4.4045E+05, 4.4194E+05, 4.4344E+05, &
       4.4494E+05, 4.4644E+05, 4.4795E+05, 4.4946E+05, 4.5097E+05, 4.5249E+05, 4.5402E+05, 4.5555E+05, 4.5708E+05, 4.5862E+05, &
       4.6016E+05, 4.6170E+05, 4.6325E+05, 4.6480E+05, 4.6636E+05, 4.6792E+05, 4.6948E+05, 4.7105E+05, 4.7263E+05, 4.7420E+05, &
       4.7579E+05, 4.7737E+05, 4.7896E+05, 4.8056E+05, 4.8216E+05, 4.8376E+05, 4.8537E+05, 4.8698E+05, 4.8859E+05, 4.9021E+05, &
       4.9184E+05, 4.9346E+05, 4.9510E+05, 4.9673E+05, 4.9837E+05, 5.0002E+05, 5.0167E+05, 5.0332E+05, 5.0498E+05, 5.0664E+05, &
       5.0831E+05, 5.0998E+05, 5.1166E+05, 5.1334E+05, 5.1502E+05, 5.1671E+05, 5.1840E+05, 5.2010E+05, 5.2180E+05, 5.2351E+05, &
       5.2522E+05, 5.2693E+05, 5.2865E+05, 5.3038E+05, 5.3210E+05, 5.3384E+05, 5.3557E+05, 5.3732E+05, 5.3906E+05, 5.4081E+05, &
       5.4257E+05, 5.4433E+05, 5.4609E+05, 5.4786E+05, 5.4963E+05, 5.5141E+05, 5.5319E+05, 5.5498E+05, 5.5677E+05, 5.5856E+05, &
       5.6037E+05, 5.6217E+05, 5.6398E+05, 5.6579E+05, 5.6761E+05, 5.6944E+05, 5.7126E+05, 5.7310E+05, 5.7493E+05, 5.7677E+05, &
       5.7862E+05, 5.8047E+05, 5.8233E+05, 5.8419E+05, 5.8605E+05, 5.8792E+05, 5.8980E+05, 5.9167E+05, 5.9356E+05, 5.9545E+05, &
       5.9734E+05, 5.9924E+05, 6.0114E+05, 6.0305E+05, 6.0496E+05, 6.0688E+05, 6.0880E+05, 6.1072E+05, 6.1265E+05, 6.1459E+05, &
       6.1653E+05, 6.1848E+05, 6.2043E+05, 6.2238E+05, 6.2434E+05, 6.2631E+05, 6.2828E+05, 6.3025E+05, 6.3223E+05, 6.3421E+05, &
       6.3620E+05, 6.3820E+05, 6.4020E+05, 6.4220E+05, 6.4421E+05, 6.4622E+05, 6.4824E+05, 6.5026E+05, 6.5229E+05, 6.5432E+05, &
       6.5636E+05, 6.5841E+05, 6.6045E+05, 6.6251E+05, 6.6457E+05, 6.6663E+05, 6.6870E+05, 6.7077E+05, 6.7285E+05, 6.7493E+05, &
       6.7702E+05, 6.7911E+05, 6.8121E+05, 6.8331E+05, 6.8542E+05, 6.8754E+05, 6.8965E+05, 6.9178E+05, 6.9391E+05, 6.9604E+05, &
       6.9818E+05, 7.0032E+05, 7.0247E+05, 7.0463E+05, 7.0679E+05, 7.0895E+05, 7.1112E+05, 7.1329E+05, 7.1547E+05, 7.1766E+05, &
       7.1985E+05, 7.2205E+05, 7.2425E+05, 7.2645E+05, 7.2866E+05, 7.3088E+05, 7.3310E+05, 7.3533E+05, 7.3756E+05, 7.3980E+05, &
       7.4204E+05, 7.4429E+05, 7.4654E+05, 7.4880E+05, 7.5106E+05, 7.5333E+05, 7.5561E+05, 7.5789E+05, 7.6017E+05, 7.6246E+05, &
       7.6476E+05, 7.6706E+05, 7.6937E+05, 7.7168E+05, 7.7400E+05, 7.7632E+05, 7.7865E+05, 7.8098E+05, 7.8332E+05, 7.8566E+05, &
       7.8801E+05, 7.9037E+05, 7.9273E+05, 7.9510E+05, 7.9747E+05, 7.9984E+05, 8.0223E+05, 8.0461E+05, 8.0701E+05, 8.0941E+05, &
       8.1181E+05, 8.1422E+05, 8.1664E+05, 8.1906E+05, 8.2148E+05, 8.2392E+05, 8.2635E+05, 8.2880E+05, 8.3125E+05, 8.3370E+05, &
       8.3616E+05, 8.3863E+05, 8.4110E+05, 8.4357E+05, 8.4606E+05, 8.4854E+05, 8.5104E+05, 8.5354E+05, 8.5604E+05, 8.5855E+05, &
       8.6107E+05, 8.6359E+05, 8.6612E+05, 8.6865E+05, 8.7119E+05, 8.7373E+05, 8.7628E+05, 8.7884E+05, 8.8140E+05, 8.8397E+05, &
       8.8654E+05, 8.8912E+05, 8.9171E+05, 8.9430E+05, 8.9689E+05, 8.9950E+05, 9.0210E+05, 9.0472E+05, 9.0734E+05, 9.0996E+05, &
       9.1259E+05, 9.1523E+05, 9.1787E+05, 9.2052E+05, 9.2318E+05, 9.2584E+05, 9.2850E+05, 9.3117E+05, 9.3385E+05, 9.3654E+05, &
       9.3923E+05, 9.4192E+05, 9.4462E+05, 9.4733E+05, 9.5004E+05, 9.5276E+05, 9.5549E+05, 9.5822E+05, 9.6096E+05, 9.6370E+05, &
       9.6645E+05, 9.6920E+05, 9.7197E+05, 9.7473E+05, 9.7751E+05, 9.8028E+05, 9.8307E+05, 9.8586E+05, 9.8866E+05, 9.9146E+05, &
       9.9427E+05, 9.9709E+05, 9.9991E+05, 1.0027E+06, 1.0056E+06, 1.0084E+06, 1.0113E+06, 1.0141E+06, 1.0170E+06, 1.0198E+06, &
       1.0227E+06, 1.0256E+06, 1.0285E+06, 1.0313E+06, 1.0342E+06, 1.0371E+06, 1.0400E+06, 1.0430E+06, 1.0459E+06, 1.0488E+06, &
       1.0517E+06, 1.0547E+06, 1.0576E+06, 1.0606E+06, 1.0635E+06, 1.0665E+06, 1.0695E+06, 1.0724E+06, 1.0754E+06, 1.0784E+06, &
       1.0814E+06, 1.0844E+06, 1.0874E+06, 1.0904E+06, 1.0934E+06, 1.0965E+06, 1.0995E+06, 1.1025E+06, 1.1056E+06, 1.1086E+06, &
       1.1117E+06, 1.1148E+06, 1.1178E+06, 1.1209E+06, 1.1240E+06, 1.1271E+06, 1.1302E+06, 1.1333E+06, 1.1364E+06, 1.1395E+06, &
       1.1426E+06, 1.1458E+06, 1.1489E+06, 1.1520E+06, 1.1552E+06, 1.1583E+06, 1.1615E+06, 1.1647E+06, 1.1678E+06, 1.1710E+06, &
       1.1742E+06, 1.1774E+06, 1.1806E+06, 1.1838E+06, 1.1870E+06, 1.1902E+06, 1.1935E+06, 1.1967E+06, 1.1999E+06, 1.2032E+06, &
       1.2064E+06, 1.2097E+06, 1.2129E+06, 1.2162E+06, 1.2195E+06, 1.2228E+06, 1.2261E+06, 1.2294E+06, 1.2327E+06, 1.2360E+06, &
       1.2393E+06, 1.2426E+06, 1.2460E+06, 1.2493E+06, 1.2526E+06, 1.2560E+06, 1.2594E+06, 1.2627E+06, 1.2661E+06, 1.2695E+06, &
       1.2729E+06, 1.2762E+06, 1.2796E+06, 1.2830E+06, 1.2865E+06, 1.2899E+06, 1.2933E+06, 1.2967E+06, 1.3002E+06, 1.3036E+06, &
       1.3071E+06, 1.3105E+06, 1.3140E+06, 1.3175E+06, 1.3210E+06, 1.3244E+06, 1.3279E+06, 1.3314E+06, 1.3349E+06, 1.3385E+06, &
       1.3420E+06, 1.3455E+06, 1.3490E+06, 1.3526E+06, 1.3561E+06, 1.3597E+06, 1.3633E+06, 1.3668E+06, 1.3704E+06, 1.3740E+06, &
       1.3776E+06, 1.3812E+06, 1.3848E+06, 1.3884E+06, 1.3920E+06, 1.3956E+06, 1.3993E+06, 1.4029E+06, 1.4066E+06, 1.4102E+06, &
       1.4139E+06, 1.4175E+06, 1.4212E+06, 1.4249E+06, 1.4286E+06, 1.4323E+06, 1.4360E+06, 1.4397E+06, 1.4434E+06, 1.4471E+06, &
       1.4509E+06, 1.4546E+06, 1.4583E+06, 1.4621E+06, 1.4659E+06, 1.4696E+06, 1.4734E+06, 1.4772E+06, 1.4810E+06, 1.4848E+06, &
       1.4886E+06, 1.4924E+06, 1.4962E+06, 1.5000E+06, 1.5038E+06, 1.5077E+06, 1.5115E+06, 1.5154E+06, 1.5192E+06, 1.5231E+06, &
       1.5270E+06, 1.5309E+06, 1.5348E+06, 1.5386E+06, 1.5426E+06, 1.5465E+06, 1.5504E+06, 1.5543E+06, 1.5582E+06, 1.5622E+06, &
       1.5661E+06, 1.5701E+06, 1.5740E+06, 1.5780E+06, 1.5820E+06, 1.5860E+06, 1.5900E+06, 1.5940E+06, 1.5980E+06, 1.6020E+06, &
       1.6060E+06, 1.6100E+06, 1.6141E+06, 1.6181E+06, 1.6222E+06, 1.6262E+06, 1.6303E+06, 1.6343E+06, 1.6384E+06, 1.6425E+06, &
       1.6466E+06, 1.6507E+06, 1.6548E+06, 1.6589E+06, 1.6631E+06, 1.6672E+06, 1.6713E+06, 1.6755E+06, 1.6796E+06, 1.6838E+06, &
       1.6880E+06, 1.6921E+06, 1.6963E+06, 1.7005E+06, 1.7047E+06, 1.7089E+06, 1.7131E+06, 1.7174E+06, 1.7216E+06, 1.7258E+06, &
       1.7301E+06, 1.7343E+06, 1.7386E+06, 1.7428E+06, 1.7471E+06, 1.7514E+06, 1.7557E+06, 1.7600E+06, 1.7643E+06, 1.7686E+06, &
       1.7729E+06, 1.7773E+06, 1.7816E+06, 1.7859E+06, 1.7903E+06, 1.7946E+06, 1.7990E+06, 1.8034E+06, 1.8078E+06, 1.8122E+06, &
       1.8166E+06, 1.8210E+06, 1.8254E+06, 1.8298E+06, 1.8342E+06, 1.8387E+06, 1.8431E+06, 1.8476E+06, 1.8520E+06, 1.8565E+06, &
       1.8610E+06, 1.8654E+06, 1.8699E+06, 1.8744E+06, 1.8789E+06, 1.8834E+06, 1.8880E+06, 1.8925E+06, 1.8970E+06, 1.9016E+06, &
       1.9061E+06, 1.9107E+06, 1.9152E+06, 1.9198E+06, 1.9244E+06, 1.9290E+06, 1.9336E+06, 1.9382E+06, 1.9428E+06, 1.9474E+06, &
       1.9521E+06, 1.9567E+06, 1.9614E+06, 1.9660E+06, 1.9707E+06, 1.9753E+06, 1.9800E+06, 1.9847E+06, 1.9894E+06, 1.9941E+06, &
       1.9988E+06, 2.0035E+06, 2.0083E+06, 2.0130E+06, 2.0177E+06, 2.0225E+06, 2.0272E+06, 2.0320E+06, 2.0368E+06, 2.0416E+06, &
       2.0464E+06, 2.0512E+06, 2.0560E+06, 2.0608E+06, 2.0656E+06, 2.0704E+06, 2.0753E+06, 2.0801E+06, 2.0850E+06, 2.0898E+06, &
       2.0947E+06, 2.0996E+06, 2.1045E+06, 2.1093E+06, 2.1142E+06, 2.1192E+06, 2.1241E+06, 2.1290E+06, 2.1339E+06, 2.1389E+06, &
       2.1438E+06, 2.1488E+06, 2.1538E+06, 2.1587E+06, 2.1637E+06, 2.1687E+06, 2.1737E+06, 2.1787E+06, 2.1837E+06, 2.1888E+06, &
       2.1938E+06, 2.1988E+06, 2.2039E+06, 2.2089E+06, 2.2140E+06, 2.2191E+06, 2.2241E+06, 2.2292E+06, 2.2343E+06, 2.2394E+06, &
       2.2446E+06, 2.2497E+06, 2.2548E+06, 2.2599E+06, 2.2651E+06, 2.2702E+06, 2.2754E+06, 2.2806E+06, 2.2858E+06, 2.2910E+06, &
       2.2961E+06, 2.3014E+06, 2.3066E+06, 2.3118E+06, 2.3170E+06, 2.3223E+06, 2.3275E+06, 2.3328E+06, 2.3380E+06, 2.3433E+06, &
       2.3486E+06, 2.3539E+06, 2.3592E+06, 2.3645E+06, 2.3698E+06, 2.3751E+06, 2.3804E+06, 2.3858E+06, 2.3911E+06, 2.3965E+06, &
       2.4018E+06, 2.4072E+06, 2.4126E+06, 2.4180E+06, 2.4234E+06, 2.4288E+06, 2.4342E+06, 2.4396E+06, 2.4450E+06, 2.4505E+06, &
       2.4559E+06, 2.4614E+06, 2.4668E+06, 2.4723E+06, 2.4778E+06, 2.4833E+06, 2.4888E+06, 2.4943E+06, 2.4998E+06, 2.5053E+06, &
       2.5109E+06, 2.5164E+06, 2.5219E+06, 2.5275E+06, 2.5331E+06, 2.5386E+06, 2.5442E+06, 2.5498E+06, 2.5554E+06, 2.5610E+06, &
       2.5666E+06, 2.5723E+06, 2.5779E+06, 2.5835E+06, 2.5892E+06, 2.5948E+06, 2.6005E+06, 2.6062E+06, 2.6119E+06, 2.6176E+06, &
       2.6233E+06, 2.6290E+06, 2.6347E+06, 2.6404E+06, 2.6462E+06, 2.6519E+06, 2.6577E+06, 2.6634E+06, 2.6692E+06, 2.6750E+06, &
       2.6808E+06, 2.6866E+06, 2.6924E+06, 2.6982E+06, 2.7040E+06, 2.7098E+06, 2.7157E+06, 2.7215E+06, 2.7274E+06, 2.7333E+06, &
       2.7391E+06, 2.7450E+06, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00/
      data (QofT( 8,J),J=2409,4510)/ 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000E+00, &
       0.0000E+00, 0.0000E+00, 0.0000E+00, 0.0000