// bnr.c  1 Apr 2010
// simple codes to write a 'C' bnr or FORTRAN bnr

// Jan 2011
// added read fortran data
// added swap flag

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

//#include"meeus.h"  called in bnr.h
#include"bnr.h"

// both C & FORTRAN

int swapem( char *byte, int n ) {
    int i;
    char ctmp;
    for( i=0; i<n/2; i++ ) {
        ctmp          = *(byte+i);
        *(byte+i)     = *(byte+n-i-1);
        *(byte+n-i-1) = ctmp;
    }
    return(0);
}


int bnr_write_init(FILE **bnr,char *filename) {

   if(( *bnr = fopen( filename, "wb" )) == (FILE *) NULL ) return(1);

   return(0);

}


// aircraft spectra
char *bnr_makeheader_ac( struct utc_date d, struct utc_time t, struct coord r,
                         int flt, char *ap2 ) {

   char *title = (char *) malloc( HEADLEN );
   memset( title, '\0', HEADLEN );

   sprintf( title,
   "%04d%02d%02d %02d:%02d:%02.0lfUT T:%05.2lf N:%07.2lf K:%05.2lf Z:%06.3lf A:%06.2lf F:%02d P:%s",
   d.year,  d.month,  d.day,
   t.hour,  t.minute, floor(t.second),
   r.lat,   r.lon,    r.alt/1000.0, r.zen, r.az, flt, ap2 );

   return(title);

}


char *bnr_makeheader( struct utc_date d, struct utc_time t, struct coord r,
                      double dur, double resolution, char *apod, double field_of_view ) {

   int  n=0;
   char ap2c[3];
   char *title = (char *) malloc( HEADLEN );

   memset( ap2c, '\0', 3 );            // truncate the apodization code to two characters in the bnr header - discriminates for NB-SMW
   memset( title, '\0', HEADLEN );

// 1char key for values in header

// Z  - solar zenith angle
// A  - solar azimuth
// D  - scan(s) duration
// F  - filter # (was field of view - jan 2011)
// V  - field of view
// K  - observation altitude
// UT - universal time
// R  - resolution cm-1
// P  - apodization function nemonic 2 or 3 chars
// T  - latitude
// N  - longitude positive West
// E  - ROE in direction of azimuth

   n = strlen( apod );
   //if( n > 2 )n = n-2;
   n=n-2;
   strncpy( ap2c, &apod[n], 2 );
   //printf( "<%s>   ||   <%s> %i\n", apod, ap2c, n );
   sprintf( title,
   "%04d%02d%02d %02d:%02d:%02.0lfUT Z:%07.3lf A:%06.2lf D:%06.1lf R:%.4lf P:%2s V:%07.4lf E:%04.0lf",
   d.year,   d.month,    d.day,
   t.hour,   t.minute,   floor(t.second),
   r.zen, r.az, dur, resolution, ap2c, field_of_view, r.roe );

   return(title);

}

void bnr_write_done(FILE *bnr) {

     fclose(bnr);
}

// C...
int bnr_write_header( FILE *bnr, char *title,double startw, double stopw, double spacing, int num_points) {

   char local_title[80], *ptr, *end;
	int dum;

   // make fortran string with no null terminator
   strncpy( local_title, title, 80 );
   end = local_title + strlen( local_title );
   dum = 80-strlen( local_title );
   if( dum < 0 ) dum = 0;
   memset( end, '\0', dum);

   fwrite(local_title,sizeof(char),80,bnr);
   fwrite(&startw,sizeof(double),1,bnr);
   fwrite(&stopw,sizeof(double),1,bnr);
   fwrite(&spacing,sizeof(double),1,bnr);
   fwrite(&num_points,sizeof(int),1,bnr);

   return(0);
}


int bnr_write_data(FILE *bnr, float *fptr, int num_points) {

     return( fwrite(fptr, sizeof(float), num_points, bnr ) ==1 );
}

//FORTRAN...
int bnr_write_header_F( FILE *bnr, char *title, double startw, double stopw, double spacing, int num_points) {

	char local_title[80], *ptr, *end;
	int dum;

	/* make fortran string with no null terminator */
	strncpy( local_title, title, 80 );
	end = local_title + strlen( local_title );
   dum = 80-strlen( local_title );
   if( dum < 0 ) dum = 0;
	memset( end, '\0', dum);

	//printf("%s %li\n", local_title, strlen(local_title) );

	dum=80;
	fwrite( &dum,        sizeof( int ), 1, bnr );
	fwrite( local_title, sizeof(char), 80, bnr );
	fwrite( &dum,        sizeof( int ), 1, bnr );
	dum=28;
	fwrite( &dum,        sizeof( int ),  1, bnr );
	fwrite( &startw,     sizeof(double), 1, bnr );
	fwrite( &stopw,      sizeof(double), 1, bnr );
	fwrite( &spacing,    sizeof(double), 1, bnr );
	fwrite( &num_points, sizeof( int ),  1, bnr );
	fwrite( &dum,        sizeof( int ),  1, bnr );

	return(0);
}


int bnr_write_data_F( FILE *bnr, float *fptr, int num_points ) {

   int dum=sizeof( int ) * num_points;

   fwrite( &dum, sizeof( int ), 1, bnr );
   fwrite(fptr,  sizeof( float),num_points,bnr);
   fwrite( &dum, sizeof( int ), 1, bnr );

		return(0);
}


int bnr_read_header( FILE *bnr, char title[], double *startw, double *stopw, double *spacing,
                     int *num_points, int swap) {

   char local_title[81];

   fread( &local_title[0], 80*sizeof(char), 1, bnr);
   strncpy( title, local_title, 80 );
   title[81] = '\0';


   fread( startw, sizeof( double ), 1, bnr );
   if( swap ) swapem( (char *) startw, 8 );

   fread( stopw, sizeof( double ), 1, bnr );
   if( swap ) swapem( (char *) stopw, 8 );

   fread( spacing, sizeof( double ), 1, bnr );
   if( swap ) swapem( (char *) spacing, 8 );

   fread( num_points, sizeof( int ), 1, bnr );
   if( swap ) swapem( (char *) num_points, 4 );

   /*
   fprintf( stderr, "title len %i\n%s\n", strlen( title ), title );
   fprintf( stderr, "start=%lf, stop=%lf, space=%lf, n=%i\n", *startw, *stopw,
     *spacing, *num_points );
   */

   return(0);
}


int bnr_read_header_F( FILE *bnr, char title[], double *startw, double *stopw, double *spacing,
                       int *num_points, int swap) {

   char local_title[81];
   int dum;

   fread( &dum, sizeof( int ), 1, bnr );

   fread( &local_title[0], 80*sizeof(char), 1, bnr);
   fread( &dum, sizeof( int ), 1, bnr );
   strncpy( title, local_title, 80 );
   title[81] = '\0';

   fread( &dum, sizeof( int ), 1, bnr );

   fread( startw, sizeof( double ), 1, bnr );
   if( swap ) swapem( (char *) startw, 8 );

   fread( stopw, sizeof( double ), 1, bnr );
   if( swap ) swapem( (char *) stopw, 8 );

   fread( spacing, sizeof( double ), 1, bnr );
   if( swap ) swapem( (char *) spacing, 8 );

   fread( num_points, sizeof( int ), 1, bnr );
   if( swap ) swapem( (char *) num_points, 4 );

   fread( &dum, sizeof( int ), 1, bnr );

   /*
   fprintf( stderr, "title len %i\n%s\n", strlen( title ), title );
   fprintf( stderr, "start=%lf, stop=%lf, space=%lf, n=%i\n", *startw, *stopw,
     *spacing, *num_points );
   */

   return(0);
}


int bnr_read_data_F( FILE *bnr, int npts, float *ydata, int swap ) {

   int j, dum;
   float *yptr;

	fread( &dum, sizeof( int ), 1, bnr );

	fread( ydata, sizeof(float), npts, bnr );
	if( swap ) for( j=0, yptr=ydata; j<npts; j++, yptr++ ) swapem( (char *) yptr, 4 );

   return(0);

}

int bnr_read_data( FILE *bnr, int npts, float *ydata, int swap ) {

   int j;
   float *yptr;

	fread( ydata, sizeof(float), npts, bnr );
	if( swap ) for( j=0, yptr=ydata; j<npts; j++, yptr++ ) swapem( (char *) yptr, 4 );

   return(0);

}
