// bnr.c  1 Apr 2010
// simple codes to write a 'C' bnr or FORTRAN bnr
// include in calling code

#define HEADLEN 80
#include "meeus.h"

// both C & FORTRAN

int swapem( char *byte, int n );

int bnr_write_init(FILE **bnr,char *filename);

void bnr_write_done(FILE *bnr);

char *bnr_makeheader( struct utc_date d, struct utc_time t, struct coord r,
                     double dur, double resolution, char *apod, double field_of_view );

char *bnr_makeheader_ac( struct utc_date d, struct utc_time t, struct coord r,
                         int flt, char *ap2 );

// C...

int bnr_write_data(FILE *bnr, float *fptr, int num_points);

int bnr_read_data( FILE *bnr, int npts, float *ydata, int swap );

int bnr_write_header( FILE *bnr, char *title, double startw, double stopw, double spacing,
                        int num_points);

int bnr_read_header( FILE *bnr, char title[], double *startw, double *stopw, double *spacing,
                     int *num_points, int swap);


// FORTRAN...

int bnr_write_header_F( FILE *bnr, char *title, double startw, double stopw, double spacing,
                        int num_points);

int bnr_write_data_F( FILE *bnr, float *fptr, int num_points );


int bnr_read_header_F( FILE *bnr, char title[], double *startw, double *stopw, double *spacing,
                       int *num_points, int swap);

int bnr_read_data_F( FILE *bnr, int npts, float *ydata, int swap );

