// coad.c

// Jun 2012
// added BNC option to read a 'C' written bnr file

// Feb 2011
//	added -c flag
//		- to choose whether zen used in output header and coad.out
//			are calulated using average julian datetime or is the average zen from
//			all headers read in

// Jan 2011
//  added use for eocom headers
//		- added SWAP flag to bnr.c calls so same version will run on OSX & linux
//		  1=swap, 0=noswap
// added use of jul_date and date_jul
//		- each spectra time is converted to a julian date
//		- the mean is found and converted back to a date
// added use of location on command line
//		- now a call to az_and_zen and rad_of_earth is always done using the average
//			time, lat and lon (for ac spectra or loc for station spectra)

// April 2010 removed lat and lon on input - ! never used...

// It writes a FORTRAN readable bnr 3 file.

#define TRUE 1       // zero is false everything else is true
#define FALSE 0      // OK return is ZERO multiple errors codes ate 1,2,3...

// lon is west longitude

#include <stdlib.h>
#include <stdio.h>
#include "math.h"
#include <string.h>

// Local functions
#include"constant.h"
//#include"meeus.h"  called in bnr.h
#include"bnr.h"

float find_max( float *inData, int npts );
float find_min( float *inData, int npts );


int main( int argc, char *argv[ ] ) {

   FILE *input, *bnr;

   char apd[]="000", *title, *ptr, ititle[81], type[]="UKN\0";
   char bnrname[100], tapeno[16], mon[]="UKN\0";
   char sitetag[] = "UKN\0";

   int rc, i, n, dum, npts, yy, mh, dd, hh, mm, ss, c, typ, flt, oflt, sq1, sq2;
   int swap=0, sec, calc_sza=0;
   long int j, secs, time_adjust;

   float fpts, *ydata, *ycoad;

   double bnrstart, bnrstop, bnrstep;
   double field_of_view, resolution, focal_length;
   double sum_dur, dur, seq_dur=6.0, sum_jld, jld, jldmin, jldmax;
   double roe=0.0, w_lon=0.0, n_lat=0.0, altud=0.0, in_roe=0.0, ymax=0, ymin=0;
   double azm, sum_azm, zen, sum_zen, lat, lon, sum_lat, sum_lon, alt, sum_alt;

   struct utc_date d;
   struct utc_time t;
   struct coord r;
   struct loc s;

   s = setsite( DEFx );

   while( --argc > 0 && (*++argv)[0] == '-' ) {
      while(( c = *++argv[0] ) != FALSE )
         switch( c ) {
            case 'T' :
               strncpy( type, ++argv[0], 3 );
               memset( argv[0], '\0', 3 );
               typ = type[2];
               //printf(" char site : '%s'\n", csite );
               break;
            case 'S' :
               strncpy( sitetag, ++argv[0], 3 );
               memset( argv[0], '\0', 3 );
               s = setmysite( sitetag );
               break;
            case 't' :
               if(( sec = atoi( ++argv[0] )) == 0 ) sec = 0;
               //printf( "len argv %d %s\n", strlen( argv[0] ), argv[0] );
               memset( argv[0], '\0', strlen( argv[0] ) );
               break;
            case 'c' :
               calc_sza = 1; // true
               break;
            case '?' :
            case 'h' :
               printf( "usage: coad -TXXX -SNNN -tx.xx -c\n" );
               printf( "where:\n" );
               printf( "   -S set lat lon & alt for [TAB | FL0 | MLO | KPK | PKF | MSA | SGP | TMK | JFJ]\n" );
               printf( "   -t is time offset defaults to %i [seconds]\n", s.sec_offs );
               printf( "   -c use sza calculated from averge julian datetime (else use average from sza's in headers)\n");
               printf( "   -T is bnr spectra type (for header format) [OTA | OTS | OTM | OPU | ACF | BNC]\n");
               printf( "     OTA - EOCOM archived data up through SESAME\n");
               printf( "     OTS - EOCOM from SOLVE\n");
               printf( "     OTM - files made on Mac - all EOCOM after SOLVE\n");
               printf( "     ACF - type of bnr made when any above 3 ac bnr spectra are coaded\n");
               printf( "     OPU - data from OPUS (all ground based spectra (default))\n");
               printf( "     BNC - read a bnr file written by a 'C' program & undefined header)\n");
               printf( "     bnr list is read from file 'coad.i'\n" );
               return(0);
          }
   }

//    if( strncmp( sitetag, "UKN", 3 )) {
//       printf( "Must set site -S try coad -?\n");
//       exit(3);
//    }

   //fprintf( stderr, "%s, %c\n", type, typ);

   freopen( "coad.err", "w", stderr );

   freopen( "coad.out", "w", stdout );

   if(( input = fopen( "coad.i", "r" )) == (FILE *) NULL){
      fprintf( stderr, "%s, %c, %i\n", type, typ, n);
      fprintf( stderr, "Cannot open %s input file.\n", "coad.i" );
      fprintf( stdout, "-999\n" );
      exit(1);
   } else {
      fscanf( input, "%i", &n );
      fprintf( stderr, "Number of files to process: %i\n", n );
   }

   //fprintf( stderr, "%s, %c, %i\n", type, typ, n);

   // Start loop to read bnr files -
   // convert date & time to julian day
   // average zenith angles
   // average azimuth angles
   // average latitude
   // average longitude
   // sum scan time
   // coad spectra
   // save index=0 for the average spectra

   for( i=1; i<=n; i++ ) {

      fscanf( input, "%s", bnrname );
      fprintf( stderr, "\nFile %i : %s\n", i, bnrname );
      if(( bnr = fopen( bnrname, "r" )) == (FILE *) NULL){
         fprintf( stderr, "Cannot open %s input file.\n", bnrname );
         fprintf( stdout, "-999\n" );
         exit(1);
      }
      // scan in spectra parameters from header
      switch( typ ) {
         case 'A' :

            rc = bnr_read_header_F( bnr, ititle, &bnrstart, &bnrstop, &bnrstep, &npts, swap);

            // OTA header
            // V81140 02Oct87 05:47:11 -30.28LT-178.66LN 86.62ZA 10.76AL NBM  4F 0086-0090

            rc=sscanf( ititle, "%6s %d %3s %d %d: %d: %d %lfLT %lfLN %lfZA %lfAL %3s %dF %d-%d",
               tapeno, &dd, mon, &yy, &hh, &mm, &ss, &lat, &lon, &zen, &alt, apd, &flt, &sq1, &sq2 );

            //fprintf( stderr, "INITIAL READ:\n%6s  %d %3s %d %d: %d: %d %lf  %lf  %lf  %lf   %3s %d  %d  %d\n",
            //         tapeno, dd, mon, yy, hh, mm, ss, lat, lon, zen, alt, apd, flt, sq1, sq2 );

				switch( rc ) {
					case 6 :
						fprintf(stderr," title scanf rc = %d\n", rc );

						rc=sscanf( ititle, "%6s %d %3s %d %d:0*:%d %lfLT %lfLN %lfZA %lfAL %3s %dF %d-%d",
									  tapeno, &dd, mon, &yy, &hh, &ss, &lat, &lon, &zen, &alt, apd, &flt, &sq1, &sq2 );

						mm = 0;

						fprintf( stderr, "SECOND READ:\n %6s %d %3s %d %d %d %lf  %lf  %lf  %lf  %3s %d  %d  %d\n",
									  tapeno, dd, mon, yy, hh, ss, lat, lon, zen, alt, apd, flt, sq1, sq2 );

						//fprintf(stderr," title scanf rc = %d\n", rc );
						if( rc != 14 ) {
							 fprintf(stderr, " scanf error rc = %d\n", rc );
							 exit(2);
						} else {
						   fprintf(stderr, " scanf rc = %d...OK set minutes to 0 ...continue.\n", rc );

						}

					break;

					case 15 :
						// should get 15...
					break;

					default:
						fprintf(stderr," title scanf rc = %d\n", rc );
						exit(1);
					break;
					}

            alt           = alt *1000.0;
            mh            = months( mon );
            field_of_view = .0301;
            resolution    = 0.9 / 16.0;
            dur           = (double) (sq2-sq1+1) * seq_dur;

         break;

         break;
         case 'S' :

				swap = 1;
            rc = bnr_read_header_F( bnr, ititle, &bnrstart, &bnrstop, &bnrstep, &npts, swap);

            // OTS SOLVE header
            // S012700.000 27Jan00 12:40:54  57.48LT -32.17LN 82.70ZA 11.11AL NBS  1F 0001-0004

            sscanf( ititle, "%12s %d%3s%d %d:%d:%d %lfLT%lfLN%lfZA%lfAL %3s %dF %d-%d",
               tapeno, &dd, mon, &yy, &hh, &mm, &ss,
               &lat, &lon, &zen, &alt, apd, &flt, &sq1, &sq2 );

            alt           = alt *1000.0;
            mh            = months( mon );
            field_of_view = .0301;
            resolution    = 0.9 / 16.0;
            dur           = (double) (sq2-sq1+1) * seq_dur;

         break;

         case 'C' :

				swap = 0;
            rc = bnr_read_header( bnr, ititle, &bnrstart, &bnrstop, &bnrstep, &npts, swap);

            // BNC - bnr file written by a C profram - no record blocking
            // undefined header
            alt           = 0.0;
            mh            = 0;
            field_of_view = 0.0;
            resolution    = 0.0;
            dur           = 0.0;

         break;

         case 'M' :

				swap = 1;
            rc = bnr_read_header_F( bnr, ititle, &bnrstart, &bnrstop, &bnrstep, &npts, swap);

            // OTM new (PAVE) header
            // A20041203.002 03Dec04 17:01:37U  67.21T 105.30N 67.21Z  1.88A NBM  1F 0001-0010

            sscanf( ititle, "%13s %d%3s%d %d:%d:%dU %lfT %lfN %lfZ %lfA %3s %dF %d-%d",
               tapeno, &dd, mon, &yy, &hh, &mm, &ss, &lat, &lon, &zen, &alt, apd, &flt, &sq1, &sq2 );

            alt           = alt *1000.0;
            mh            = months( mon );
            field_of_view = .0301;
            resolution    = 0.9 / 16.0;
            dur           = (double) (sq2-sq1+1) * seq_dur;

         break;

         case 'F' :

				swap = 0;
            rc = bnr_read_header_F( bnr, ititle, &bnrstart, &bnrstop, &bnrstep, &npts, swap);
            //printf( "%s\n", ititle );

            // printf( "%lf %lf %lf %d\n", bnrstart, bnrstop, bnrstep, npts );
            // ACF header made by this program from the other 3 aircraft formats
            // 19950324 20:47:33UT T:66.99 N:0050.62 K:00.40 Z:84.612 A:081.06 F:04 P:NBM

            sscanf( ititle, "%4d%2d%2d %d:%d:%dUT T:%lf N:%lf K:%lf Z:%lf A:%lf F:%d P:%3s",
                    &yy, &mh, &dd, &hh, &mm, &ss, &lat, &lon, &alt, &zen, &azm, &flt, apd );

				//printf( "%d %d %d %d %d %d\n", yy, mh, dd, hh, mm, ss);
				//printf( "%lf %lf %lf %lf %lf\n", lat, lon, alt, zen, azm);
				//printf( "%d %s\n", flt, apd);

            alt           = alt *1000.0;
            //mh            = months( mon );
            field_of_view = .0301;
            resolution    = 0.9 / 16.0;
            dur           = 0.0;

         break;

         case 'U' :
         default :

            rc = bnr_read_header_F( bnr, ititle, &bnrstart, &bnrstop, &bnrstep, &npts, swap);

            // ckopus header
            // 08/23/2008 18:43:09UT Z:67.507 A:33.631 D:203.43 R:0.0035 P:BX V:2.2727mr
            // Z  - solar zenith angle
            // A  - solar azimuth
            // D  - scan(s) duration
            // F  - filter # (was field of view - jan 2011)
            // V  - field of view
            // K  - observation altitude
            // UT - universal time
            // R  - resolution cm-1
            // P  - apodization function nemonic 2 or 3 chars
            // T  - latitude
            // N  - longitude positive West
            // E  - ROE in direction of azimuth
//            sscanf( ititle, "%d/%d/%d %d:%d:%dUT Z:%lf A:%lf D:%lf R:%lf P:%s F:%lf",
//                    &mh, &dd, &yy, &hh, &mm, &ss, &zen, &azm,
//                    &dur, &resolution, apd, &field_of_view );


            sscanf( ititle, "%4d%2d%2d %2d:%2d:%2dUT Z:%lf A:%lf D:%lf R:%lf P:%s V:%lf E:%lf",
                    &yy, &mh, &dd, &hh, &mm, &ss, &zen, &azm,
                    &dur, &resolution, apd, &field_of_view, &in_roe );

            lat = s.n_lat;
            lon = s.w_lon;
            alt = s.altud;

         break;
      }

      fprintf( stderr, "Title length=%li\n%s\n", strlen( ititle ), ititle );
      fprintf( stderr, "%lf %lf %lf %d\n", bnrstart, bnrstop, bnrstep, npts );

      // uh-oh!!! very kludgie
      if( yy < 70 )  yy += 2000;
      if( yy <= 99 ) yy += 1900;

      d.year   = yy;
      d.month  = mh;
      d.day    = dd;

      t.hour   = hh;
      t.minute = mm;
      t.second = (double) ss;

      jld = jul_date( &d, &t );

      if( i == 1 ) {
         ycoad = (float *) malloc ( npts*sizeof(float) );
         ydata = (float *) malloc ( npts*sizeof(float) );
         if( ydata == (float *) 0 || ycoad == (float *) 0 ) {
            fprintf( stderr, "Could not allocate array for y data.\n" );
            fprintf( stdout, "-999\n" );
            exit(1);
         }
         for( j=0; j<npts; j++ ) ycoad[j]=0.0;
         sum_dur = 0.0;
         sum_zen = 0.0;
         sum_azm = 0.0;
         sum_lat = 0.0;
         sum_lon = 0.0;
         sum_alt = 0.0;
         sum_jld = 0.0;
         jldmax  = jld;
         jldmin  = jld;
         oflt = flt;
      }
      else {
         if( jld > jldmax ) jldmax = jld;
         if( jld < jldmin ) jldmin = jld;
         if( oflt != flt ) {
            printf( " Error filter id's from 2 spectra differ?...STOP\n" );
            return(1);
         }
      }

      fprintf( stderr, "scanned tapeno=%s\n", tapeno );
      fprintf( stderr, "scanned month=%s yy=%d mh=%d dd=%d hh=%d mm=%d ss=%d\n", mon, yy, mh, dd, hh, mm, ss );
      fprintf( stderr, "julian day=%lf\n", jld );
      fprintf( stderr, "scanned lat  =%10lf, lon  =%10lf, alt  =%10lf\n", lat, lon, alt );
      fprintf( stderr, "scanned flt  =%10d, apd  =%10s\n" , flt, apd);
      fprintf( stderr, "scanned azm  =%10lf, zen  =%10lf, dur  =%10lf\n", azm, zen, dur );

      rc = bnr_read_data_F( bnr, npts, ydata, swap );

      fclose( bnr );

      //if( azm > 180.0) azm = azm - 360.0;

      for( j=0; j<npts; j++ ) ycoad[j]=ycoad[j]+ydata[j];
      sum_dur = sum_dur + dur;
      sum_zen = sum_zen + zen;
      sum_azm = sum_azm + azm;
      sum_lat = sum_lat + lat;
      sum_lon = sum_lon + lon;
      sum_alt = sum_alt + alt;
      sum_jld = sum_jld + jld;
   }

   fclose( input );
   free( ydata );

   fprintf( stderr, "\n\nOutput file:\n");

   for( j=0; j<npts; j++ ) ycoad[j]=ycoad[j] / (double) n;
   zen = sum_zen / (double) n;
   azm = sum_azm / (double) n;
   lat = sum_lat / (double) n;
   lon = sum_lon / (double) n;
   alt = sum_alt / (double) n;
   jld = sum_jld / (double) n;
   dur = sum_dur;

   fprintf( stderr, "julian day: min=%lf, avg=%lf, max=%lf\n", jldmin, jld, jldmax );
   fprintf( stderr, "average: \nzen  =%15lf\nazm  =%15lf\n", zen, azm );
   fprintf( stderr, "lat  =%15lf\nlon  =%15lf\nalt  =%15lf\n", lat, lon, alt );
   fprintf( stderr, "dur  =%15lf\n", dur );

   rc  = date_jul( jld, &d, &t );
   jld = jul_date( &d, &t );

   fprintf( stderr, "New mean date & time:  %lf %04i/%02i/%02i %03i %02i:%02i:%02.0lf\n", jld, d.year, d.month, d.day, d.doy, t.hour, t.minute, floor(t.second) );

   // print up new header
   switch( typ ) {
      case 'A' :
      case 'S' :
      case 'M' :
      case 'F' :

         r.alt = alt;
         r.lat = lat;
         r.lon = lon;
         az_and_zen( &d, &t, lat, lon, &r);
         fprintf( stderr, "calculated: \nzen  =%15lf\nazm  =%15lf\n", r.zen, r.az );
         if( ! calc_sza ) {
         	r.zen = zen;
         } else {
         	zen = r.zen;
         }
         rad_of_earth( lat, lon, &r );
         title = bnr_makeheader_ac( d, t, r, flt, apd );
         azm = r.az;
         //zen = r.zen;
         roe = r.roe;

      break;
      case 'U' :
      default :

         if(( s.w_lon != 0.0 ) && ( s.n_lat != 0.0 )) {
            r.alt = alt;
            r.lat = lat;
            r.lon = lon;
            az_and_zen( &d, &t, lat, lon, &r);
            fprintf( stderr, "calculated: \nzen  =%15lf\nazm  =%15lf\n", r.zen, r.az );
            if( ! calc_sza ) {
         	   r.zen = zen;
         	   r.az  = azm;
            } else {
         	   zen = r.zen;
               azm = r.az;
            }
            rad_of_earth( lat, lon, &r );
            roe = r.roe;
         }
         title = bnr_makeheader( d, t, r, dur, resolution, apd, field_of_view );

      break;
   }

   if( calc_sza ) {
   	fprintf( stderr, "Using sza calculated from average julian datetime.\n");
   } else {
   	fprintf( stderr, "Using average sza from bnr headers.\n");
   }
   fprintf( stderr, "title length =%ld\n'%s'\n", strlen(title), title );

   sprintf( bnrname, "temp.bnr" );
   fprintf( stderr, "Opening bnr file: %s\n", bnrname );
   if(( rc = bnr_write_init( &bnr, bnrname )) != 0 ) {
      fprintf( stderr, "Cannot create %s bnr file. rc:%d\n", bnrname, rc+10 );
      fprintf( stdout, "-999\n" );
      exit( rc );
   }
   if(( rc = bnr_write_header_F( bnr, title, bnrstart, bnrstop, bnrstep, npts )) != 0 ) {
      fprintf( stderr, "Cannot write header of %s bnr file. rc:%d\n", bnrname, rc+10 );
      fprintf( stdout, "-999\n" );
      exit( rc );
   }
   if(( rc = bnr_write_data_F( bnr, ycoad, npts )) != 0 ) {
      fprintf( stderr, "Cannot write data of %s bnr file. rc:%d\n", bnrname, rc+10 );
      fprintf( stdout, "-999\n" );
      exit( rc );
   }

   bnr_write_done( bnr );

    ymax = find_max(ycoad, npts);
    ymin = find_min(ycoad, npts);

   fprintf( stderr, "Closed bnr file: %s\n", bnrname );
   free( ycoad );

   fprintf( stdout, "%-9.4lf\n", zen );
   fprintf( stdout, "%-9.4lf\n", 0.9/resolution );
   fprintf( stdout, "%-6.4lf\n", field_of_view );
   fprintf( stdout, "%-s\n", apd );
   fprintf( stdout, "%-9.3lf\n", bnrstart );
   fprintf( stdout, "%-9.3f\n", bnrstop );
   fprintf( stdout, "%04i %02i %02i %02i %02i %02.0f\n",
                     d.year, d.month, d.day,
                     t.hour, t.minute, floor(t.second) );
   fprintf( stdout, "%-s\n", title );
   fprintf( stdout, "%-10.4lf\n", azm );
   fprintf( stdout, "%-8.2lf\n", dur );

   if((( s.w_lon != 0.0 ) && ( s.n_lat != 0.0 )) || typ != 'U' ) fprintf( stdout, "%-10.4lf\n", roe );
   fprintf( stdout, "%-10.3le\n", ymax);
   fprintf( stdout, "%-10.3le\n", ymin);

   free( title );

   return(0);
}

float find_min( float *inData, int npts ) {

    int j;
    float outMin;

    outMin = inData[0];

    for( j=1; j<=npts; j++ ) {
        if ( inData[j] < outMin ) outMin = inData[j];
    }

   return(outMin);

}


float find_max( float *inData, int npts ) {

    int j;
    float outMax;

    outMax = inData[0];

    for( j=1; j<=npts; j++ ) {
        if ( inData[j] > outMax ) outMax = inData[j];
    }

   return(outMax);

}



