// constant.c

// Aug 2016
// add RIK, MOS, TKB, and SYO by I. Murata

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include"constant.h"

struct loc setmysite( char* sitetag  ) {

   struct loc site;
   int i;
   //printf("%s\n", sitetag);

   for( i=0; i<3; i++ ) sitetag[i] = toupper( sitetag[i] );

   if(      ! strncmp( sitetag, "UKN", 3 )) site = setsite( DEFx );
   else if( ! strncmp( sitetag, "TAB", 3 )) site = setsite( TABx );
   else if( ! strncmp( sitetag, "MLO", 3 )) site = setsite( MLOx );
   else if( ! strncmp( sitetag, "FL0", 3 )) site = setsite( FL0x );
   else if( ! strncmp( sitetag, "SGP", 3 )) site = setsite( SGPx );
   else if( ! strncmp( sitetag, "PKF", 3 )) site = setsite( PKFx );
   else if( ! strncmp( sitetag, "MSA", 3 )) site = setsite( MSAx );
   else if( ! strncmp( sitetag, "KPK", 3 )) site = setsite( KPKx );
   else if( ! strncmp( sitetag, "TMK", 3 )) site = setsite( TMKx );
   else if( ! strncmp( sitetag, "EUR", 3 )) site = setsite( EURx );
   else if( ! strncmp( sitetag, "JFJ", 3 )) site = setsite( JFJx );
   else if( ! strncmp( sitetag, "WLG", 3 )) site = setsite( WLGx );
   else if( ! strncmp( sitetag, "LDR", 3 )) site = setsite( LDRx );
   else if( ! strncmp( sitetag, "HFI", 3 )) site = setsite( HFIx );
   else if( ! strncmp( sitetag, "HRT", 3 )) site = setsite( HRTx );
   else if( ! strncmp( sitetag, "UNM", 3 )) site = setsite( UNMx );
   else if( ! strncmp( sitetag, "ALZ", 3 )) site = setsite( ALZx );
   else if( ! strncmp( sitetag, "RIK", 3 )) site = setsite( RIKx );
   else if( ! strncmp( sitetag, "MOS", 3 )) site = setsite( MOSx );
   else if( ! strncmp( sitetag, "TKB", 3 )) site = setsite( TKBx );
   else if( ! strncmp( sitetag, "SYO", 3 )) site = setsite( SYOx );
   else if( ! strncmp( sitetag, "AAB", 3 )) site = setsite( AABx );
   else if( ! strncmp( sitetag, "STP", 3 )) site = setsite( STPx );
   else {
      printf("ckopus: Site tag unknown : %s  ...stop\n",  sitetag );
      exit(1);
   }

   return( site );

}

//  local clock time = UTC time - utc offset

struct loc setsite( int siteid  ) {

   struct loc myloc;

   myloc.n_lat =    0.0;
   myloc.w_lon =    0.0;
   myloc.altud =    0.0;
   myloc.utc_offs =   0;
   myloc.sec_offs =   0;
   myloc.strt_flg =   0;
   sprintf( myloc.tag, "%3s", "DEF" );


   switch( siteid ) {

      case DEFx :
         myloc.n_lat =       0.0;
         myloc.w_lon =       0.0;
         myloc.altud =       0.0;
         myloc.utc_offs =      0;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "DEF" );
      break;
      case MSAx :
         myloc.n_lat =       0.0;
         myloc.w_lon =       0.0;
         myloc.altud =       0.0;
         myloc.utc_offs =      0;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "MSA" );
      break;
//            UNAM   19.3	260.82	2200      99.18
      case UNMx :
         myloc.n_lat =     19.33;
         myloc.w_lon =     99.18;
         myloc.altud =    2260.0;
         myloc.utc_offs =     +6;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "UNM" );
      break;
//            Altzomoni	19.12	261.35	4010    1  98.65
      case ALZx :
         myloc.n_lat =     19.12;
         myloc.w_lon =     98.65;
         myloc.altud =    4010.0;
         myloc.utc_offs =     +6;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "ALZ" );
      break;
//            Mauna_Loa   19.5400  204.4300 3396.0000    1  155.5700
      case MLOx :
         myloc.n_lat =     19.54;
         myloc.w_lon =    155.57;
         myloc.altud =    3396.0;
         myloc.utc_offs =    +10;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "MLO" );
      break;
//                Thule   76.5300  291.2600  225.0000    1   68.7400  TAB
      case TABx :
         myloc.n_lat =    76.516;
         myloc.w_lon =    68.768;
         myloc.altud =     225.0;
         myloc.utc_offs =     +4;
         myloc.sec_offs =      0;
         myloc.strt_flg =      2;
         sprintf( myloc.tag, "%3s", "TAB" );
      break;
//              Boulder   40.0380  254.7600 1612.0000    4  105.2400   FL0
      case FL0x :
         myloc.n_lat =    40.038;
         myloc.w_lon =    105.24;
         myloc.altud =    1612.0;
         myloc.utc_offs =     +7;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "FL0" );
      break;
//               Lamont   36.6040  262.5140  320.0000    2   97.4860
      case SGPx :
         myloc.n_lat =    36.604;
         myloc.w_lon =    97.486;
         myloc.altud =     320.0;
         myloc.utc_offs =     +6;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "SGP" );
      break;
//           Poker_Flat   65.1200  212.5700  610.0000    1  147.4300  PKF
      case PKFx :
         myloc.n_lat =     65.12;
         myloc.w_lon =    147.43;
         myloc.altud =     610.0;
         myloc.utc_offs =     +9;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "PKF" );
      break;
//            Kitt_Peak   31.9600  248.4100 2060.0000    1  111.5900
      case KPKx:
         myloc.n_lat =     31.96;
         myloc.w_lon =    111.59;
         myloc.altud =    2060.0;
         myloc.utc_offs =     +7;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "KPK" );
      break;
//                Tomsk   56.4750   85.0460  106.0000    4  274.9540
      case TMKx:
         myloc.n_lat =  56.97576;              // 56 58'32.74'' C
         myloc.w_lon =  274.9537;              // 85 02'46.63'' B
         myloc.altud =     106.0;               // ~106 m
         myloc.utc_offs =     -7;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "TMK" );
      break;
//               Eureka   80.0500  273.5800  610.0000    3   86.4200  EUR
      case EURx:
         myloc.n_lat =     80.05;
         myloc.w_lon =     86.42;
         myloc.altud =     610.0;
         myloc.utc_offs =     +5;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "EUR" );
      break;
//         Jungfraujoch   46.5500    7.9800 3580.0000    1  352.0200
      case JFJx:
         myloc.n_lat =     46.55;
         myloc.w_lon =    352.02;
         myloc.altud =    3580.0;
         myloc.utc_offs =     -2;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "JFJ" );
      break;
//           Wollongong  -34.4061  150.8793   30.0000    3  209.1207  WLG
      case WLGx:
         myloc.n_lat =  -24.4061;
         myloc.w_lon =  209.1207;
         myloc.altud =       30.;
         myloc.utc_offs =    -10;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "WLG" );
      break;
//               Lauder  -45.0500  169.6700  370.0000    3  190.3300      LDR
      case LDRx:
         myloc.n_lat =    -45.05;
         myloc.w_lon =    190.33;
         myloc.altud =      370.;
         myloc.utc_offs =    -12;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "LDR" );
      break;
//               Hefei	31.905	117.171	30.000	3	HFI
      case HFIx:
         myloc.n_lat =    31.905;
         myloc.w_lon =    117.171;
         myloc.altud =      30.0;
         myloc.utc_offs =     -8;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "HFI" );
      break;
//            Rikubetsu   43.4600  143.7700  380.0000    3  216.2300   RIK
      case RIKx:
         myloc.n_lat =     43.46;
         myloc.w_lon =    216.23;
         myloc.altud =      380.;
         myloc.utc_offs =     -9;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "RIK" );
      break;
//              Moshiri   44.3700  142.2700  280.0000    3  217.7300      MOS
      case MOSx:
         myloc.n_lat =     44.37;
         myloc.w_lon =    217.73;
         myloc.altud =      280.;
         myloc.utc_offs =     -9;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "MOS" );
      break;
//              Tsukuba   36.0500  140.1200   31.0000    2  219.8800 TKB
      case TKBx:
         myloc.n_lat =     36.05;
         myloc.w_lon =    219.88;
         myloc.altud =       31.;
         myloc.utc_offs =     -9;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "TKB" );
      break;
//              Syowa_Station  -69.0000   39.5900   10.0000    1  320.4100 SYO
      case SYOx:
         myloc.n_lat =    -69.00;
         myloc.w_lon =    320.41;
         myloc.altud =       10.;
         myloc.utc_offs =     -3;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "SYO" );
      break;

//             Harestua   60.2000   10.8000  596.0000    1  349.2000  HRT
      case HRTx:
         myloc.n_lat =     60.20;
         myloc.w_lon =    349.20;
         myloc.altud =     596.0;
         myloc.utc_offs =     -1;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "HRT" );
      break;

//          Addis_Ababa    8.9830   38.8000 2444.0000    1  321.2000
      case AABx:
         myloc.n_lat =      8.98;
         myloc.w_lon =    321.20;
         myloc.altud =    2444.0;
         myloc.utc_offs =     -3;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "AAB" );
      break;

//  St Petersburg 59.8800   29.8300   20.0000    4  330.1700
      case STPx:
         myloc.n_lat =     59.88;
         myloc.w_lon =  330.1700;
         myloc.altud =      20.0;
         myloc.utc_offs =     -3;
         myloc.sec_offs =      0;
         myloc.strt_flg =      0;
         sprintf( myloc.tag, "%3s", "STP" );
      break;

      default :
         printf( " setsite: Bad site name id out of range : %d\n", siteid );
         return( myloc );
   }

   return( myloc );

}

//  Found stations # :       49
//
//                site    e_lon     n_lat     alt   id_type   w_lon
//               Eureka   80.0500  273.5800  610.0000    3   86.4200  EUR
//           Ny_Alesund   78.9000   11.9000   20.0000    3  348.1000  NYA
//                Thule   76.5300  291.2600  225.0000    1   68.7400  TAB
//               Kiruna   67.8400   20.4100  420.0000    1  339.5900  KRN
//            Sodankyla   67.3670   26.6310  184.0000    2  333.3690  SKL
//           Poker_Flat   65.1200  212.5700  610.0000    1  147.4300  PKF
//             Harestua   60.2000   10.8000  596.0000    1  349.2000  HRT
//        St_Petersburg   59.8800   29.8300   20.0000    4  330.1700  STP
//        Yekaterinburg   57.0380   59.5450  300.0000    4  300.4550  YKT  SVX
//        Fort_McMurray   56.6500  248.7800  369.0000    4  111.2200
//                Tomsk   56.4750   85.0460  106.0000    4  274.9540
//            Bialystok   53.2310   23.0250  183.0000    2  336.9750
//               Bremen   53.1000    8.9000   27.0000    2  351.1000
//               Cabauw   51.9700    4.9300   -2.0000    4  355.0700
//          Bratts_Lake   50.2000  255.8000  587.0000    4  104.2000
//            Karlsruhe   49.0900    8.4300  110.0000    2  351.5700
//                Paris   48.9700    2.3700   60.0000    4  357.6300
//              Timmins   48.5700  278.6200  295.0000    4   81.3800
//              Orleans   47.9650    2.1130  132.0000    2  357.8870
//             Garmisch   47.4760   11.0630  745.0000    3  348.9370
//            Zugspitze   47.4200   10.9800 2964.0000    1  349.0200
//         Jungfraujoch   46.5500    7.9800 3580.0000    1  352.0200
//           Park_Falls   45.9450  269.7270  442.0000    2   90.2730
//              Halifax   44.6400  296.4100   65.0000    4   63.5900
//              Moshiri   44.4000  142.3000  295.0000    2  217.7000  MOS
//               Egbert   44.2170  280.2330  251.0000    4   79.7670
//            Rikubetsu   43.4600  143.7700  380.0000    3  216.2300  RIK
//              Toronto   43.6600  280.6000  174.0000    1   79.4000
//              Boulder   40.0380  254.7600 1612.0000    4  105.2400   FL0
//             Barcroft   37.5800  241.7600 3793.0000    1  118.2400
//             4Corners   36.7970  251.5200 1643.0000    2  108.4800
//               Lamont   36.6040  262.5140  320.0000    2   97.4860
//              Tsukuba   36.0500  140.1200   31.0000    2  219.8800  TKB
//            Table_Mtn   34.4000  242.3000 2300.0000    4  117.7000
//            Kitt_Peak   31.9600  248.4100 2060.0000    1  111.5900
//                Izana   28.3000  343.5200 2370.0000    3   16.4800
//            Mauna_Loa   19.5400  204.4300 3396.0000    1  155.5700
//     Mexico_City_UNAM   19.3300  260.8200 2260.0000    4   99.1800
//            Altzomoni   19.1200  261.3500 4010.0000    4   98.6500
//          Addis_Ababa    8.9830   38.8000 2444.0000    1  321.2000
//           Paramaribo    5.8100  304.7900    7.0000    1   55.2100
//            Ascension   -7.9165  345.6675   10.0000    2   14.3325
//               Darwin  -12.4240  130.8900   20.0000    2  229.1100
//        Reunion_Maido  -21.0670   55.3800 2160.0000    3  304.6200
//     Reunion_St_Denis  -20.9000   55.4830   50.0000    3  304.5170
//           Wollongong  -34.4061  150.8793   30.0000    3  209.1207  WLG
//               Lauder  -45.0500  169.6700  370.0000    3  190.3300  LDR
//        Syowa_Station  -69.0000   39.5900   10.0000    1  320.4100  SYO
//      Arrival_Heights  -78.8300  166.6600  200.0000    1  193.3400

