// physical and numerical constants for C-program development

/*
! Numerical Constants
! Phys. Today Aug 2001
*/
/*
! Aug 2016
! add RIK, MOS, TKB, and SYO by I. Murata
*/

#define PI       3.14159265358979300
#define SCHMIT   2.686777500e+19
#define ALOGSQ   0.832554611157697800
#define PISQ     1.77245385090839500
#define RFACTOR  3.58116529200
#define RCONST2  1.438775200
#define STDTEMP  296.000
#define nsites   22

#define DEFx 0
#define TABx 1
#define MLOx 2
#define FL0x 3
#define SGPx 4
#define PKFx 5
#define MSAx 6
#define KPKx 7
#define TMKx 8
#define EURx 9
#define JFJx 10
#define WLGx 11
#define LDRx 12
#define HFIx 13
#define HRTx 14
#define UNMx 15
#define ALZx 16
#define RIKx 17
#define MOSx 18
#define TKBx 19
#define SYOx 20
#define AABx 21
#define STPx 22


struct loc {
   double n_lat;        // degrees
   double w_lon;        // degrees
   double altud;        // masl
   int utc_offs;        // utc time offset in hours
   int sec_offs;        // time offset in seconds
   int strt_flg;        // index to calculation of optimal spectrum time
   char tag[4];         // 3 char site location tag
   };

struct loc setsite( int siteid  );

struct loc setmysite( char* sitetag  );

//char mon[][4] = { "n", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
//                       "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };
