// header for opus.c read opus files

#define TRUE 1       // zero is false everything else is true
#define FALSE 0      // OK return is ZERO multiple errors codes are 1,2,3...

#define INT32 0
#define REAL64 1
#define STRING 2
#define ENUM 3
#define ENUM_CHAR 4
#define END_BLOCK 11822
#define ILABELSZ 4
#define PARAM_RCD_NULL (struct opus_param_rcd *) NULL
#define DATE_LEN 11
#define TIME_LEN 9
#define APODSZ 10
#define APERATSZ 10
#define FILTERSZ 30
#define PGAINSZ 5
#define OPUS_ERSZ 100
#define ENUMSZ 4
#define ENUM_CHARSZ 255
#define STRSZ 255
#define MAXPATH 300

#define OFFSET   0x40000000
#define DRPARBLK 0x3400       // 13312
#define INPARBLK 0x20         // 32
#define AQPARBLK 0x30         // 48
//#define AQPARBLK 0x40000030         // 48
#define FTPARBLK 0x40         // 64
#define OPPARBLK 0x60         // 96
#define SMPARBLK 0xA0         // 160

#define SNGCPARBLK 0x417      // 1047
#define IFGMPARBLK 0x817      // 2071
#define PHASPARBLK 0xC17      // 3095
#define EMISPARBLK 0x2C1F     // 11295
#define TRANPARBLK 0x141F     // 5131
#define IFG2PARBLK 0x8817     // 34839 interferogram parameters, 2nd channel IGSM/2.chn.
#define SNG2PARBLK 0x8417     // 33815 sample spectra parameters SCSM/2.chn.

#define SNGCSPCBLK 0x407      // 1031
#define IFGMSPCBLK 0x807      // 2055
#define PHASSPCBLK 0xC07      // 3079
#define EMISSPCBLK 0x2C0F     // 11279
#define TRANSPCBLK 0x140F     // 5135
#define IFG2SPCBLK 0x8807     // 34823 interferogram data point data, 2nd channel IGSM/2.chn.
#define SNG2SPCBLK 0x8407     // 33799 sample spectra data point data SCSM/2.chn.


// SWAP is an argument... 0=no swap
//int SWAP = 0;

//#define DEBUG

// global error message
char opus_error[OPUS_ERSZ];

// current index into opus block dir
int dir_index;

// Optic Parameters
struct OPPB_rcd {
   char APT[ENUM_CHARSZ];
   char BMS[ENUM_CHARSZ];
   char DTC[ENUM_CHARSZ];
   char OPF[ENUM_CHARSZ];
   char OF1[ENUM_CHARSZ];
   char PGN[ENUMSZ];
   char SRC[ENUM_CHARSZ];
   char VEL[ENUMSZ];
   char HPF[ENUMSZ];
   char LPF[ENUMSZ];
   int END;
};

// Instrument Parameters
struct INPB_rcd {
   double HFL;
   double LFL;
   int ASS;
   double DUR;
   int RSN;
   int PKA;
   int PKL;
   int SSP;
   char INS[STRSZ];
   double FOC;
   int ABP;
   double LWN;
   char RDY[ENUMSZ];
   int SSM;
   int SGP;
   int SGW;
   int DFC;
   int DFR;
   double HFF;
   double LFF;
   int GFW;
   int GBW;
   int PRA;
   int PRL;
   int ASG;     // actual signal gain
   int ARS;
   int END;
};

// Fourier Transform Parameters
struct FTPB_rcd {
   char APF[ENUMSZ];
   double HFQ;
   double LFQ;
   char PHZ[ENUMSZ];
   double PHR;
   int DIG;
   char SPZ[ENUMSZ];
   char ZFF[ENUMSZ];
   int END;
};

// Spectrum Parameters
struct SPPB_rcd {
   int DPF;
   int NPT;
   double FXV;
   double LXV;
   double CSF;
   double MXY;
   double MNY;
   char DAT[DATE_LEN];
   char TIM[TIME_LEN];
   char DXU[ENUMSZ];
   double SN1;
   double SN2;
   double SN3;
   double SN4;
   double NF1;
   double NF2;
   int END;
};

// Acquisition Parameters
struct AQPB_rcd {
   char SGN[ENUMSZ];
   char RGN[ENUMSZ];
   int  GSW;
   char GSG[ENUM_CHARSZ];
   char AQM[ENUMSZ];
   int  NSS;
   double MIN;
   char COR[ENUMSZ];
   int DLY;
   double HFW;
   double LFW;
   double RES;
   int TDL;
   char PLF[ENUMSZ];
   int DEL;
   char SOT[ENUMSZ];
   int END;
   };

// Parameter Record
struct opus_param_rcd {
	char item_label[ILABELSZ];
	int item_type;
	int item_length;
	union
	{
		int int32;
		double real64;
		char *enumeration;
		char *string;
	}value;
	struct opus_param_rcd *next;
};

void report( char *message, char *message2, char *filename);

int opus_init( FILE **opus, char *filename, int SWAP);

int opus_searchdir( FILE *opus, int blocktype, int *length, int *pointer, int SWAP);

int opus_read_spectrum( FILE *opus, double *fstartw, double *fstopw, int length, int pointer,
                        double scalefactor, int fnum_points, float ydata[], int SWAP );

int param_block_init( struct opus_param_rcd **pb, FILE *opus, int blocktype, int SWAP);

void param_block_done( struct opus_param_rcd **pb);

int param_block_find( struct opus_param_rcd *pb, char *item_label, struct opus_param_rcd *item_record);

int read_AQPAR_block( FILE *opus, struct AQPB_rcd *acqp, int SWAP );

int read_FTPAR_block( FILE *opus, struct FTPB_rcd *FTPB, int SWAP);

int read_OPPAR_block( FILE *opus, struct OPPB_rcd *OPPB, int SWAP);

int read_INPAR_block( FILE *opus, struct INPB_rcd *INPB, int SWAP);

int read_SPPAR_block( FILE *opus, int paramblocktype, struct SPPB_rcd *SPPB, int SWAP);

int opus_listBlocks( char *rname, int SWAP );

int opus_listParams( char *rname, int SWAP );

int opus_magic( char *rname, int SWAP );

