#define RETBNR 1
#define DATAOPUSDUMP 2
#define GETITEM 3
#define GETRAWBNR 4
#define LISTBLOCKS 5
#define EXITCMD 6

// uncomment next line to turn on debug print outs
//#define DEBUG

#include<ctype.h>
#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<string.h>
#include<errno.h>

#include"opus.h"

int SWAP = 0;


int returnOPUSitem(char *rname,int blocktype,char *itemname) {

     FILE *opus;
     struct opus_param_rcd *pblock_ptr, rcd;
     int result;
     result=0;

     if (( result = opus_init( &opus, rname, SWAP )) != FALSE ) {
          fprintf(stderr,"Cannot open %s opus file \n",rname);
          fprintf(stderr,"Error = %d\n",result);
          return (1);
     }

     if (!param_block_init(&pblock_ptr,opus, blocktype, SWAP)) {
          fprintf(stderr,"Cannot find blocktype %d\n",blocktype);
          fclose( opus );
          return(2);
     }
     if (!param_block_find(pblock_ptr,itemname,&rcd)) {
          fprintf(stderr,"Cannot find %s in blocktype %d\n",itemname,blocktype);
          fclose( opus );
          return(3);
     }

     result=0;
     if (!fwrite(&result,1,sizeof(result),stdout)) {
          fprintf(stderr,"Cannot write good result code to pipe \n");
          exit(1);
     }

     switch (rcd.item_type) {
     case INT32:
          printf("%d\n",rcd.value.int32);
          break;
     case REAL64:
          printf("%lf\n",rcd.value.real64);
          break;
     case STRING:
          printf("%s\n",rcd.value.string);
          break;
     case ENUM:
          printf("%s\n",rcd.value.enumeration);
          break;
     case ENUM_CHAR:
          printf("%s\n",rcd.value.enumeration);
          break;
     case END_BLOCK:
          /*			printf("Ignored end block type\n"); */
          printf("(END)\n");
          break;
     default:
          fprintf(stderr,"Unexpected item type %d ignored\n",rcd.item_type);
          fprintf(stderr,"in blocktype %x HEX\n",blocktype);
          break;
     }

   param_block_done(&pblock_ptr); // maybe

   fclose( opus );

   return(0);
}


int returnbnr(char *rname ) {

   FILE *opus;

   char titlestr[100],title[81];

	int i=0, rc=0, emisblock=0, fnum_points=0;
	int length=0, pointer=0, result=0;

	long int time_adjust=0;

	float *ydata, aperture=0.;

	double spacing=0., field_of_view=0., fstartw=0., fstopw=0.;

   struct AQPB_rcd AQPB;                     // Acquisition block
   struct SPPB_rcd IFPB, SPPB, PHPB;         // Phase, Interferogram, Emission, Single Channel block
   struct FTPB_rcd FTPB;                     // Fourier Transform block
   struct OPPB_rcd OPPB;                     // Optic block
   struct INPB_rcd INPB;                     // Instrument block

   if (( result = opus_init( &opus, rname, SWAP )) != FALSE ) {
      fprintf(stderr,"Cannot open %s opus file \n",rname);
      fprintf(stderr,"Error = %d\n",result);
      return (1);
   }

   if( ! read_AQPAR_block( opus, &AQPB, SWAP )) {
      fprintf( stderr, "  Acquisition Param Block Read NOT OK!\n" );
      exit(2);
   }

   if( ! read_FTPAR_block( opus, &FTPB, SWAP )) {
      fprintf( stderr,  "  FT Param Block Read NOT OK!\n" );
      exit(3);
   }

   if( ! read_OPPAR_block( opus, &OPPB, SWAP )) {
      fprintf( stderr, "  Optic Param Block Read NOT OK!\n" );
      exit(4);
   }
   sscanf(OPPB.APT," %f ",&aperture); //,units);

   if( ! read_INPAR_block( opus, &INPB, SWAP )) {
      fprintf( stderr, "  Instrument Param Block Read NOT OK!\n" );
      exit(5);
   }
   field_of_view = 0.0;
   if( INPB.FOC != 0.0 )  field_of_view = aperture/INPB.FOC * 1000.;

	/* read date & time from phase spectra since this time is saved
	   right after emission spectra taken, emission time is after FFT
	   is completed & so varies with filter. for MLOA Tom found
	   that 150 seconds before phase time gives best aproximation. */

   // Read in spectra block - try single channel first then emission block
   // version of OPUS 3.04 all timestamps are same EMIS PHAS SNGC IFGM

   // no channel 2 here...
   emisblock=FALSE;
   if( ! read_SPPAR_block( opus, SNGCPARBLK, &SPPB, SWAP )) {
      fprintf( stderr, "  Single Channel Param Block Read NOT OK!... try EMIS\n" );
      if( ! read_SPPAR_block( opus, EMISPARBLK, &SPPB, SWAP )) {
         fprintf( stderr, "  Emission Param Block Read NOT OK!\n" );
         exit(6);
      } else {
         emisblock=TRUE;
      }
   }

   // get time from PHAS
   if( ! read_SPPAR_block( opus, PHASPARBLK, &PHPB, SWAP )) {
      fprintf( stderr, "  Phase Param Block Read NOT OK!\n" );
      exit(4);
   }

     sprintf(titlestr,"%s %sPHAS Z:%.3lf A:%.3lf D:%.2lf R:%.4lf P:%s F:%.4lfmr",
             PHPB.DAT, PHPB.TIM, 0.0, 0.0, INPB.DUR, AQPB.RES, FTPB.APF, field_of_view);

     sprintf(title,"%-80s",titlestr);

     //printf("title length =%d\n'%s'\n",strlen(title),title);

   fstartw     = SPPB.FXV;
   fstopw      = SPPB.LXV;
   fnum_points = SPPB.NPT;
   spacing = (fstopw-fstartw) / (fnum_points-1);
   if( spacing < 0.0 ) spacing = (fstartw-fstopw) / (fnum_points-1) ;

   //printf("\t%lf to %lf  %d points\n",fstartw,fstopw,fnum_points);
   //printf("\tCalculated spacing = %lf\n",spacing);

   if( emisblock ) {
       //printf("Reading Emission data block\n");

      if( ! opus_searchdir( opus, EMISSPCBLK, &length, &pointer, SWAP )) {
         fprintf( stderr," *Cannot find data block    : %s %Xx\n", "EMIS", EMISSPCBLK );
         if( ! opus_searchdir( opus, EMISSPCBLK + OFFSET, &length, &pointer, SWAP )) {
            fprintf( stderr," *Cannot find data block    : %s %Xx\n", "EMIS", EMISSPCBLK + OFFSET );
            fclose( opus );
            return(1);
         } else fprintf( stderr,"  Data block Found          : %s 0x%x\n", "EMIS", EMISSPCBLK + OFFSET );
      } else fprintf( stderr,"  Data block Found          : %s 0x%x\n", "EMIS", EMISSPCBLK );

   } else {
       //printf("Reading Sample data block\n");

      if( ! opus_searchdir( opus, SNGCSPCBLK, &length, &pointer, SWAP )) {
         fprintf( stderr," *Cannot find data block    : %s %Xx\n", "SNGC", SNGCSPCBLK );
         if( ! opus_searchdir( opus, SNGCSPCBLK + OFFSET, &length, &pointer, SWAP )) {
            fprintf( stderr," *Cannot find data block    : %s %Xx\n", "SNGC", SNGCSPCBLK + OFFSET );
            fclose( opus );
            return(1);
         } else fprintf( stderr,"  Data block Found          : %s 0x%x\n", "SNGC", SNGCSPCBLK + OFFSET );
      } else fprintf( stderr,"  Data block Found          : %s 0x%x\n", "SNGC", SNGCSPCBLK );

   }

	ydata = (float *) malloc( length*sizeof(float) );

	if( ydata == (float *) 0 ) {
		fprintf( stderr, "Could not allocate array for y data.\n" );
		exit(1);
	}

	if( opus_read_spectrum( opus, &fstartw, &fstopw, length, pointer, SPPB.CSF, fnum_points, ydata, SWAP )) {
		fprintf( stderr,"Cannot read data.\n" );
		exit(1);
	}
   fclose( opus );

   result = 0;
   if( ! fwrite( &result, 1, sizeof(result), stdout )) {
      fprintf( stderr, "Cannot write good result code to pipe \n" );
      exit(1);
   }
   if( ! fwrite( title, 1, sizeof(title)-1, stdout )) {
      fprintf( stderr, "Cannot write title to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &fstartw, sizeof(fstartw), 1, stdout )) {
      fprintf( stderr, "Cannot write wstart to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &fstopw, sizeof(fstopw), 1, stdout )) {
      fprintf( stderr, "Cannot write wstop to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &spacing, sizeof(spacing), 1, stdout )) {
      fprintf( stderr, "Cannot write spacing to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &fnum_points, sizeof(fnum_points), 1, stdout )) {
      fprintf( stderr, "Cannot write num_points to pipe \n" );
      exit(1);
   }

   if( ! fwrite( ydata, sizeof(float), length, stdout )) {
        fprintf(stderr,"Cannot write y point to pipe \n");
        exit(1);
   }

   return(0);
}

int returnrawbnr(char *rname, int datablocktype ) {

   FILE *opus;

   char titlestr[100], title[81];

	int i=0, rc=0, emisblock=0, fnum_points=0, paramblocktype=0;
	int length=0, pointer=0, result=0;

	long int time_adjust=0;

	float *ydata, aperture=0.;

	double spacing=0., field_of_view=0., fstartw=0., fstopw=0.;

   struct SPPB_rcd SPPB;            // Phase, Interferogram, Emission, Single Channel block

   if (( result = opus_init( &opus, rname, SWAP )) != FALSE ) {
      fprintf(stderr,"Cannot open %s opus file \n",rname);
      fprintf(stderr,"Error = %d\n",result);
      return (1);
   }

   if( datablocktype == PHASSPCBLK ) paramblocktype = PHASPARBLK;
   if( datablocktype == SNGCSPCBLK ) paramblocktype = SNGCPARBLK;
   if( datablocktype == EMISSPCBLK ) paramblocktype = EMISPARBLK;
   if( datablocktype == IFGMSPCBLK ) paramblocktype = IFGMPARBLK;
   if( datablocktype == IFG2SPCBLK ) paramblocktype = IFG2PARBLK;
   if( datablocktype == SNG2SPCBLK ) paramblocktype = SNG2PARBLK;

   if( paramblocktype == 0 ) {
      fprintf( stderr, "Invalid parameter block type : %d\n", datablocktype );
      return(6);
   }

   if( ! read_SPPAR_block( opus, paramblocktype, &SPPB, SWAP )) {
      fprintf( stderr, "Cannot read raw param block %d \n", paramblocktype );
      return(6);
   }

   sprintf( titlestr, "%s", rname );
   sprintf( title, "%-80s", titlestr );

   fstartw     = SPPB.FXV;
   fstopw      = SPPB.LXV;
   fnum_points = SPPB.NPT;
   spacing = (fstopw-fstartw) / (fnum_points-1);
   if( spacing < 0.0 ) spacing = (fstartw-fstopw) / (fnum_points-1);

   if( ! opus_searchdir( opus, datablocktype, &length, &pointer, SWAP )) {
      fprintf( stderr," *Cannot find data block    : %s %Xx\n", "SNGC", datablocktype );
      if( ! opus_searchdir( opus, datablocktype + OFFSET, &length, &pointer, SWAP )) {
         fprintf( stderr," *Cannot find data block    : %s %Xx\n", "SNGC", datablocktype + OFFSET );
         fclose( opus );
         return(1);
      } else fprintf( stderr,"  Data block Found          : %s 0x%x\n", "SNGC", datablocktype + OFFSET );
   } else fprintf( stderr,"  Data block Found          : %s 0x%x\n", "SNGC", datablocktype );

	ydata = (float *) malloc( length*sizeof(float) );

	if( ydata == (float *) 0 ) {
		fprintf( stderr, "Could not allocate array for y data.\n" );
		exit(1);
	}

	if( opus_read_spectrum( opus, &fstartw, &fstopw, length, pointer, SPPB.CSF, fnum_points, ydata, SWAP )) {
		fprintf( stderr,"Cannot read data.\n" );
		exit(1);
	}

   fclose( opus );

   result = 0;
   if( ! fwrite( &result, 1, sizeof(result), stdout )) {
      fprintf( stderr, "Cannot write good result code to pipe \n" );
      exit(1);
   }
   if( ! fwrite( title, 1, sizeof(title)-1, stdout )) {
      fprintf( stderr, "Cannot write title to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &fstartw, sizeof(fstartw), 1, stdout )) {
      fprintf( stderr, "Cannot write wstart to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &fstopw, sizeof(fstopw), 1, stdout )) {
      fprintf( stderr, "Cannot write wstop to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &spacing, sizeof(spacing), 1, stdout )) {
      fprintf( stderr, "Cannot write spacing to pipe \n" );
      exit(1);
   }
   if( ! fwrite( &fnum_points, sizeof(fnum_points), 1, stdout )) {
      fprintf( stderr, "Cannot write num_points to pipe \n" );
      exit(1);
   }

   if( ! fwrite( ydata, sizeof(float), length, stdout )) {
        fprintf(stderr,"Cannot write y point to pipe \n");
        exit(1);
   }

   return(0);

}

int main(int argc,char* argv[])
{
     static char version[] = {"OPUSreader V2.0-C (26 Mar 2014) by PSM/WM"};
     // Version 2.0-C (26 Mar 2014) by PSM Corrected returnrawbnr to also add OFFSET if
     //                                    could not load original block type. Also
     //                                    added 2nd channel interferogram and Sample block types
     // Version 2.0-B (27 Feb 2014) by PSM Added SWAP to opus_init and opus_listBlocks call
     // Version 2.0-A (29 Mar 2010) by PSM & WM
     // Version 1.1-A (19 Feb 2009) by PSM & WM Add support to list datablocks
     // Version 1.0-C..C (20 Apr 2007) by PSM  add command for bnr and dataopus dump
     // Version 1.0-A..B (18 Apr 2007) by PSM  only write out bnr give OPUS filename and wavenumber range

   extern char *optarg;
   extern int optind;

   char opus_name[MAXPATH];
   char itemname[80];

   int opusfile_set;
   int cmd,result;
   int blocktype,datablocktype;

   double start_w, stop_w;

   // turn off std output
   setbuf(stdout,(char*)0);
   fprintf(stderr,"%s\r\n",version);

   //	Enter SWAP bytes flag 1 = true = swap bytes
   scanf( "%i", &SWAP );

#ifdef DEBUG
     fprintf(stderr,"swap bytes switch = %i\n",SWAP);
#endif

     for (;;) {
          scanf("%d",&cmd);

          switch (cmd) {

          case RETBNR:
               scanf("%s",opus_name);
#ifdef DEBUG
               fprintf(stderr,"BNR Opus filename = %s\n",opus_name);
#endif
               if ((result=returnbnr( opus_name ))) {
                    if (!fwrite(&result,1,sizeof(result),stdout)) {
                         fprintf(stderr,"Cannot write result code to pipe \n");
                         exit(1);
                    }
               }
               break;

          case DATAOPUSDUMP:
               scanf("%s",opus_name);
#ifdef DEBUG
               fprintf(stderr,"Data Opus filename = %s\n",opus_name);
#endif
               if(( result = opus_listParams( opus_name, SWAP ))) {
                    if (!fwrite(&result,1,sizeof(result),stdout)) {
                         fprintf(stderr,"Cannot write result code to pipe \n");
                         exit(1);
                    }
               }
               break;
          case GETITEM:
               scanf("%s",opus_name);
#ifdef DEBUG
               fprintf(stderr,"Get item Opus filename = %s\n",opus_name);
#endif
               scanf("%d",&blocktype);
#ifdef DEBUG
               fprintf(stderr,"block type = %d\n",blocktype);
#endif
               scanf("%s",itemname);
#ifdef DEBUG
               fprintf(stderr,"item name = %s\n",itemname);
#endif
               if ((result=returnOPUSitem(opus_name,blocktype,itemname))) {
                    if (!fwrite(&result,1,sizeof(result),stdout)) {
                         fprintf(stderr,"Cannot write result code to pipe \n");
                         exit(1);
                    }
               }
               break;
          case GETRAWBNR:
               scanf("%s",opus_name);
#ifdef DEBUG
               fprintf(stderr,"Raw BNR Opus filename = %s\n",opus_name);
#endif
               scanf("%d",&blocktype);
#ifdef DEBUG
               fprintf(stderr,"param block type = %d\n",blocktype);
#endif
               if(( result = returnrawbnr( opus_name, blocktype ))) {
                  if( ! fwrite( &result, 1, sizeof(result), stdout )) {
                     fprintf( stderr, "Cannot write result code to pipe \n" );
                     exit(1);
                  }
               }
               break;
          case LISTBLOCKS:
               scanf("%s",opus_name);
#ifdef DEBUG
               fprintf(stderr,"List blocks Opus filename = %s\n",opus_name);
#endif
               if((result=opus_listBlocks(opus_name,SWAP))) {
                    if (!fwrite(&result,1,sizeof(result),stdout)) {
                         fprintf(stderr,"Cannot write result code to pipe \n");
                         exit(1);
                    }
               }
               break;
          case EXITCMD:
               goto exitlabel;
               break;
          default:
               result=-1;
               if (!fwrite(&result,1,sizeof(result),stdout)) {
                    fprintf(stderr,"Cannot write result code to pipe \n");
                    exit(1);
               }
               break;
          }
     }

exitlabel:
     return(0);
}

