// solarpos.c
// calculate solar position utility

#define FALSE 0
#define TRUE 1
#define VERBOSE FALSE

#include"constant.h"
#include"meeus.h"

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<string.h>
#include<time.h>
#include<string.h>

/*********************************************************************/

/* calculate zenith angle */

int sayposition( struct utc_date sd, struct utc_time st, struct loc site, struct coord res ) {

   //struct utc_time lt={0.0,0,0,0,0,0.0};

   printf( " %8.3lf %8.3lf %7.1lf ", site.n_lat, site.w_lon, site.altud );
   printf( " %04i/%02i/%02i %03i %02i:%02i:%02.1lf %3i ", sd.year, sd.month, sd.day, sd.doy, st.hour, st.minute, st.second, site.utc_offs );

//   st.sday = st.mday * 60;

   az_and_zen( &sd, &st, site.n_lat, site.w_lon, &res );

	// Calculate the radius of the earth ellipsoid at observation lat & solar azimuth
	rad_of_earth( site.n_lat, site.w_lon, &res );

   printf( " %8.3lf %8.3lf %8.1lf\n ", res.zen, res.az, res.roe );

   return(0);

   }


int listposition( int interval, struct utc_date sd, struct utc_time st, struct loc site, struct coord res ) {

   int    i, imax_minute = 24*60;
   struct zat rise, peak, set, last, low;
   struct utc_time lt={0.0,0,0,0,0,0.0};

   printf( " Location   : %8.3lf N %8.3lf W %7.1lf masl\n", site.n_lat, site.w_lon, site.altud );
   printf( " UTC offset : %8d h\n", site.utc_offs );
   printf( "\n  Julian_Day   DOY   fDay  Minute Second  UTtime   LCHour Zenith   Azimuth(W/S)  ROE\n" );

   //if( VERBOSE ) goto skip;

   for( i=0; i<=imax_minute; i++ ) {

      st.hour = (int)  ( i / 60 );
      st.minute = i - st.hour * 60;
      st.mday = i;
      st.sday = st.mday * 60;
      /* printf( "%i t structure: %lf  %i %i  %i  %lf\n", i, st ); */

      az_and_zen( &sd, &st, site.n_lat, site.w_lon, &res );

      // Calculate the radius of the earth ellipsoid at observation lat & solar azimuth
      rad_of_earth( site.n_lat, site.w_lon, &res );

      if( !( i % interval )) {
          lt = st;
          // utc_offs in constant.c is positive W of Greenwich.  Subtract from UTC to get local time
          lt.hour = lt.hour - site.utc_offs;
          if( lt.hour < 0 ) lt.hour = lt.hour +24;
          if( st.mday == 0 ) {
              printf( " %13.5lf %3i %.5lf %4i  %6li  %02i:%02i:%02.1lf ", res.jd, sd.doy, st.frac, st.mday, st.sday, st.hour, st.minute, st.second );
              printf( "  %02i ", lt.hour );
          } else {
              printf( "%13.5lf %3i %.5lf %4i  %6li  %02i:%02i:%02.1lf ", res.jd, sd.doy, st.frac, st.mday, st.sday, st.hour, st.minute, st.second );
              printf( "  %02i ", lt.hour );
          }
          //printf( "%8.3lf %8.3lf %8.3lf %8.3lf\n ", res.ra, res.dec, res.zen, res.az );
          printf( " %8.3lf %8.3lf %8.1lf\n ", res.zen, res.az, res.roe );
      }

      if( !i ) {
          last.zenith  = res.zen;
          last.azimuth = res.az;
          last.hour    = st.hour;
          last.minute  = st.minute;
          last.second  = 0.0;
          last.frac    = st.frac;
          last.mday    = st.mday;
          rise = peak = set = low = last;
      }

      if( res.zen < peak.zenith ) {
          peak.zenith  = res.zen;
          peak.azimuth = res.az;
          peak.hour    = st.hour;
          peak.minute  = st.minute;
          peak.frac    = st.frac;
          peak.mday    = st.mday;
      }

      if( res.zen > low.zenith ) {
          low.zenith  = res.zen;
          low.azimuth = res.az;
          low.hour    = st.hour;
          low.minute  = st.minute;
          low.frac    = st.frac;
          low.mday    = st.mday;
      }

      if(( last.zenith > 90.0 ) && ( res.zen <= 90.0 )) {
          rise.zenith  = res.zen;
          rise.azimuth = res.az;
          rise.hour    = st.hour;
          rise.minute  = st.minute;
          rise.frac    = st.frac;
          rise.mday    = st.mday;
      }

      if(( last.zenith < 90.0 ) && ( res.zen >= 90.0 )) {
          set.zenith  = res.zen;
          set.azimuth = res.az;
          set.hour    = st.hour;
          set.minute  = st.minute;
          set.frac    = st.frac;
          set.mday    = st.mday;
      }

      last.zenith  = res.zen;
      last.azimuth = res.az;
      last.hour    = st.hour;
      last.minute  = st.minute;
      last.frac    = st.frac;
      last.mday    = st.mday;

      /* printf( "%i %f %i, %i  %i  %f\n", i, t ); */
      /* printf( "%.3lf %.3lf\n", azimuth, 90.0-res.zen ); */
   }

   /* printf( "Day of Year: %3i\n", d.doy ); */

   if( rise.frac == set.frac ) {
      if( peak.zenith >= 90. ) {
          printf( "The sun stays below the horizon.\n" );
      } else {
          printf( "The sun stays above the horizon.\n" );
      }
      printf( "maximum:  %3i %.5lf %4i %02i:%02i:%02.1f %8.3f %8.3f\n", sd.doy, peak.frac, peak.mday, peak.hour, peak.minute, peak.second, peak.zenith, peak.azimuth );
      printf( "minimum:  %3i %.5lf %4i %02i:%02i:%02.1f %8.3f %8.3f\n", sd.doy, low.frac, low.mday, low.hour, low.minute, low.second, low.zenith, low.azimuth );
   } else {
      printf( "\n");
      printf( "Rise:     %3i %.5lf %4i %02i:%02i:%02.1f %8.3f %8.3f\n", sd.doy, rise.frac, rise.mday, rise.hour, rise.minute, rise.second, rise.zenith, rise.azimuth );
      printf( "maximum:  %3i %.5lf %4i %02i:%02i:%02.1f %8.3f %8.3f\n", sd.doy, peak.frac, peak.mday, peak.hour, peak.minute, peak.second, peak.zenith, peak.azimuth );
      printf( "minimum:  %3i %.5lf %4i %02i:%02i:%02.1f %8.3f %8.3f\n", sd.doy, low.frac, low.mday, low.hour, low.minute, low.second, low.zenith, low.azimuth );
      printf( "Set :     %3i %.5lf %4i %02i:%02i:%02.1f %8.3f %8.3f\n", sd.doy, set.frac, set.mday, set.hour, set.minute, set.second, set.zenith, set.azimuth );
   }

   return 0;

}



int main( int argc, char *argv[] ) {

   time_t now;
   struct tm* tm;
   struct utc_date sd={0,0,0,0};
   struct utc_time st={0.0,0,0,0,0,0.0};
   struct coord res;
   struct loc site;

   char  *optarg;
   // 3 char string TAB | MLO | SGP | PKF | KPK | FL0
   char  sitetag[] = "UKN\0";

   int   interval=15 , rc, c, type='\0';
   int   optind=0, SWAP=0, utc=99, dlit=0, today=0, list=0;

   float wlon=0.0, nlat=0.0, alt=0.0;

   site = setsite( DEFx );

   while( --argc > 0 && (*++argv)[0] == '-' ) {
      while(( c = *++argv[0] ) != FALSE )
         switch( c ) {
            case 'w' :
               //printf("%s\n", ++argv[0]);
               if(( wlon = atof( ++argv[0] )) == FALSE ) wlon = 0.0;
               //printf("%f\n", site.w_lon);
               break;
            case 'n' :
               if(( nlat = atof( ++argv[0] )) == FALSE ) nlat = 0.0;
               break;
            case 'e' :
               if(( alt  = atof( ++argv[0] )) == FALSE ) alt = 0.0;
               break;
            case 'u' :
               if(( utc  = atoi( ++argv[0] )) == FALSE ) utc = 99;
               break;
            case 'S' :
               strncpy( sitetag, ++argv[0], 3 );
               memset( argv[0], '\0', 3 );
               //printf(" char site : '%s'\n", csite );
               break;
            case 'd' :
               dlit = 1;
               break;
            case 'l' :
               list = 1;
               if(( interval = atoi( ++argv[0] )) == 0 ) interval = 15;
               --argv[0];
               break;
            case 't' :
               today = 1;
               break;
            case '?' :
            case 'h' :
               printf( "usage: solarpos -wXXX -nXXX -eXXX -uhh -Ssss -d -ln\n" );
               printf( "where:\n" );
               printf( "   -w is west longitude defaults to %.2lf [decimal degrees]\n",site.w_lon );
               printf( "   -n is north latitude defaults to %.2lf [decimal degrees]\n", site.n_lat );
               printf( "   -e is elevation defaults to %.2lf [meters]\n", site.altud );
               printf( "   -u is UTC time offset defaults to %i [hours]\n", site.utc_offs );
               printf( "   -S set lat lon & alt for [TAB | FL0 | MLO | KPK | PKF | MSA | SGP | TMK]\n" );
               printf( "   -d use daylight savings for local time\n" );
               printf( "   -l print list of positions every n (15) minutes of day\n" );
               printf( "   -t calculate position for today\n" );
               return(0);
          }
   }

   site = setmysite( sitetag );
   if( nlat != 0.0 )site.n_lat    = nlat;
   if( wlon != 0.0 )site.w_lon    = wlon;
   if( alt  != 0.0 )site.altud    = alt;
   if( utc  != 99  )site.utc_offs = utc;

   //printf(" %s %8.3lf %8.3lf %8.3lf %i %i\n", sitetag, site.n_lat, site.w_lon, site.altud, site.utc_offs, site.sec_offs);

   //printf("%i %i %i\n", list, today, interval);
   //exit(0);

   // utc offset  = utc - local in standard time
   if( dlit ) site.utc_offs = site.utc_offs -1;
   //printf(" %d\n", site.utc_offs );
   //if( today || !list ) {
   if( today ) {
      now = time(0);
      tm  = gmtime(&now);
      //printf("%d %d %d %d\n", tm->tm_year+1990, tm->tm_mon+1, tm->tm_mday, tm->tm_hour);
      sd.year   = tm->tm_year +1900;
      sd.month  = tm->tm_mon +1;
      sd.day    = tm->tm_mday;
      sd.doy    = tm->tm_yday;
      st.hour   = tm->tm_hour;
      st.minute = tm->tm_min;
      st.second = (double)tm->tm_sec;
   }
   else {
      printf( "Enter year month & day : " );
      scanf( "%i", &sd.year );
      if( sd.year == -1 ) return( 0 );
      scanf( "%i %i", &sd.month, &sd.day );
   }

   if( list ) {
      printf( " Date       : %04i/%02i/%02i %3i\n", sd.year, sd.month, sd.day, sd.doy );
      rc = listposition( interval, sd, st, site, res );
   }
   else {
      rc = sayposition( sd, st, site, res );
   }


//         printf( "\nEnter UT time for calculation (hh mm ss.s)? " );
//         scanf( "%i", &st.hour );
//         if( st.hour == -1 ) return( 0 );
//         scanf( "%i %lf", &st.minute, &st.second );
//
//         st.mday = st.hour*60 + st.minute;
//         st.frac = (double) st.mday/(24*60);
//
//         if( VERBOSE ) printf( "t structure: %lf  %i %i  %i  %lf\n", st );
//
//         az_and_zen( &sd, &st, n_lat, w_lon, &res );
//         lt = st;
//         lt.hour = lt.hour + site.utc_offs;
//         if( lt.hour < 0 ) lt.hour = lt.hour +24;
//
//         printf( "%13.5lf %3i %.5lf %4i  %02i:%02i:%02.1lf ", res.jd, sd.doy, st );
//         printf( "  %02i ", lt.hour );
//         //printf("%8.3lf %8.3lf %8.3lf %8.3lf\n ", res.ra, res.dec, res.zen, res.az );
//         printf( " %8.3lf %8.3lf\n ", res.zen, res.az );

    return 0;

}
